# Observe: Integrating Feedback to Reflect and Adapt

Observations are **how an Agent perceives the consequences of its actions**.

They provide crucial information that fuels the Agent's thought process and guides future actions.

They are **signals from the environment**—whether it’s data from an API, error messages, or system logs—that guide the next cycle of thought.

In the observation phase, the agent:

- **Collects Feedback:** Receives data or confirmation that its action was successful (or not).
- **Appends Results:** Integrates the new information into its existing context, effectively updating its memory.
- **Adapts its Strategy:** Uses this updated context to refine subsequent thoughts and actions.

For example, if a weather API returns the data *"partly cloudy, 15°C, 60% humidity"*, this observation is appended to the agent’s memory (at the end of the prompt).

The Agent then uses it to decide whether additional information is needed or if it’s ready to provide a final answer.

This **iterative incorporation of feedback ensures the agent remains dynamically aligned with its goals**, constantly learning and adjusting based on real-world outcomes.

These observations **can take many forms**, from reading webpage text to monitoring a robot arm's position. This can be seen like Tool "logs" that provide textual feedback of the Action execution.

| Type of Observation | Example                                                                   |
|---------------------|---------------------------------------------------------------------------|
| System Feedback     | Error messages, success notifications, status codes                       |
| Data Changes        | Database updates, file system modifications, state changes                |
| Environmental Data  | Sensor readings, system metrics, resource usage                           |
| Response Analysis   | API responses, query results, computation outputs                         |
| Time-based Events   | Deadlines reached, scheduled tasks completed                              |

## How Are the Results Appended?

After performing an action, the framework follows these steps in order:

1. **Parse the action** to identify the function(s) to call and the argument(s) to use.  
2. **Execute the action.**  
3. **Append the result** as an **Observation**.  

---
We've now learned the Agent's Thought-Action-Observation Cycle. 

If some aspects still seem a bit blurry, don't worry—we'll revisit and deepen these concepts in future Units. 

Now, it's time to put your knowledge into practice by coding your very first Agent!


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/unit1/observations.mdx" />