# Introducción a `LangGraph`

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/LangGraph.png" alt="Unit 2.3 Thumbnail"/>

Bienvenido a esta siguiente parte de nuestro viaje, donde aprenderás **cómo construir aplicaciones** utilizando el marco de trabajo [`LangGraph`](https://github.com/langchain-ai/langgraph) diseñado para ayudarte a estructurar y orquestar flujos de trabajo complejos con LLM.

`LangGraph` es un marco de trabajo que te permite construir aplicaciones  **listas para producción** dándote herramientas de **control** sobre el flujo de tu agente.

## Descripción General del Módulo

En esta unidad, descubrirás:

### 1️⃣ [¿Qué es LangGraph y cuándo usarlo?](./when_to_use_langgraph)
### 2️⃣ [Componentes Básicos de LangGraph](./building_blocks)
### 3️⃣ [Alfred, el mayordomo clasificador de correo](./first_graph)
### 4️⃣ [Alfred, el agente de Análisis de documentos](./document_analysis_agent)
### 5️⃣ [Cuestionario](./quizz1)

> [!WARNING]
> Los ejemplos en esta sección requieren acceso a un modelo LLM/VLM potente. Los ejecutamos usando la API de GPT-4o porque tiene la mejor compatibilidad con langGraph.

¡Al final de esta unidad, estarás equipado para construir aplicaciones robustas, organizadas y listas para producción! 

Dicho esto, esta sección es una introducción a langGraph y se pueden descubrir temas más avanzados en el curso gratuito de langChain academy: [Introducción a LangGraph](https://academy.langchain.com/courses/intro-to-langgraph)

¡Comencemos!

## Recursos

- [Agentes LangGraph](https://langchain-ai.github.io/langgraph/) - Ejemplos de agentes LangGraph
- [Academia LangChain](https://academy.langchain.com/courses/intro-to-langgraph) - FCurso completo sobre LangGraph de LangChain

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/es/unit2/langgraph/introduction.mdx" />