# Introducción a LlamaIndex

Bienvenido a este módulo, donde aprenderás a construir agentes impulsados por LLM utilizando el kit de herramientas de [LlamaIndex](https://www.llamaindex.ai/).

LlamaIndex es **un kit de herramientas completo para crear agentes impulsados por LLM sobre tus datos utilizando índices y flujos de trabajo**. En este curso, nos centraremos en tres partes principales que ayudan a construir agentes en LlamaIndex: **Componentes**, **Herramientas y Agentes** y **Flujos de trabajo**.

![LlamaIndex](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/thumbnail.png)

Echemos un vistazo a estas partes clave de LlamaIndex y cómo ayudan a construir agentes:

- **Componentes** son los bloques de construcción básicos que se utilizan en LlamaIndex. Estos incluyen cosas como prompts, modelos y bases de datos. Los componentes suelen ayudar a conectar LlamaIndex con otras herramientas y bibliotecas.
- **Herramientas**: Las herramientas son componentes que proporcionan capacidades específicas como búsqueda, cálculo o acceso a servicios externos. Son los bloques de construcción que permiten a los agentes realizar tareas.
- **Agentes**: Los agentes son componentes autónomos que pueden utilizar herramientas y tomar decisiones. Coordinan el uso de herramientas para lograr objetivos complejos.
- **Flujos de trabajo** son procesos paso a paso que procesan lógica juntos. Los flujos de trabajo o flujos de trabajo agentivos son una forma de estructurar el comportamiento agente sin el uso explícito de agentes.

## ¿Qué hace que LlamaIndex sea especial?

Aunque LlamaIndex hace algunas cosas similares a otros frameworks como smolagents, tiene algunas ventajas clave:

- **Sistema de flujo de trabajo claro**. Los flujos de trabajo ayudan a descomponer cómo los agentes deben tomar decisiones paso a paso utilizando una sintaxis de eventos y async-first. Esto te ayuda a organizar y componer tu lógica de manera clara.
- **Análisis de documentos avanzado con LlamaParse** LlamaParse se creó específicamente para LlamaIndex, por lo que la integración es perfecta, aunque es una característica de pago.
- **Muchos componentes listos para usar** LlamaIndex ha estado disponible durante un tiempo, por lo que funciona con muchos otros frameworks. Esto significa que tiene muchos componentes probados y confiables, como LLMs, recuperadores, índices y más.
- **LlamaHub** es un registro de cientos de estos componentes, agentes y herramientas que puedes utilizar dentro de LlamaIndex.

Todos estos conceptos son necesarios en diferentes escenarios para crear agentes útiles.
En las siguientes secciones, exploraremos cada uno de estos conceptos en detalle.
Después de dominar los conceptos, utilizaremos lo que hemos aprendido para **crear casos de uso aplicados con Alfred el agente**!

¿Estás emocionado de empezar a trabajar con LlamaIndex? ¡Vamos a empezar a **buscar e instalar las integraciones que necesitamos utilizando LlamaHub! 🚀**

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/es/unit2/llama-index/introduction.mdx" />