import{s as ft,a as Mt,n as yt,o as Tt}from"../chunks/scheduler.505acc25.js";import{S as gt,i as vt,e as a,s as l,c,h as Ut,a as r,d as n,b as i,f as dt,g as d,j as o,k as D,l as Jt,m as s,n as m,t as f,o as M,p as y}from"../chunks/index.b1175496.js";import{C as ht,H as ze}from"../chunks/Heading.988e52fa.js";import{C as mt}from"../chunks/CodeBlock.ed64aebc.js";import{E as Ct}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function bt(Ae){let p,K,O,ee,T,te,g,ne,u,Ze="<p>Dans cette section, nous explorons les étapes concrètes qu’un agent entreprend pour interagir avec son environnement.</p> <p>Nous aborderons la manière dont les actions sont représentées (en utilisant du JSON ou du code), l’importance de l’approche <i>stop</i> and <i>parse</i>, et nous présenterons différents types d’agents.</p>",se,v,Ge="Les actions sont les étapes concrètes qu’un <strong>agent entreprend pour interagir avec son environnement</strong>.",le,U,Ne="Que ce soit pour naviguer sur le web à la recherche d’informations ou pour contrôler un dispositif physique, chaque action est une opération délibérée exécutée par l’agent.",ie,J,Re="Par exemple, un agent assistant au service client pourrait récupérer des données client, proposer des articles de support ou transférer des problèmes à un représentant humain.",ae,h,re,C,Pe="Il existe plusieurs types d’agents qui réalisent des actions de manières différentes :",oe,b,Xe="<thead><tr><th>Type d’Agent</th> <th>Description</th></tr></thead> <tbody><tr><td>Agent à JSON</td> <td>L’action à entreprendre est spécifiée au format JSON.</td></tr> <tr><td>Agent à code</td> <td>L’agent génère un bloc de code qui est interprété de manière externe.</td></tr> <tr><td>Agent à appel de fonction</td> <td>Il s’agit d’une sous-catégorie de l’agent JSON qui a été affiné pour générer un nouveau message pour chaque action.</td></tr></tbody>",pe,x,ke="Les actions elles-mêmes peuvent remplir de nombreux objectifs :",ue,w,Ve="<thead><tr><th>Type d’Action</th> <th>Description</th></tr></thead> <tbody><tr><td>Collecte d’informations</td> <td>Effectuer des recherches sur le web, interroger des bases de données ou récupérer des documents.</td></tr> <tr><td>Utilisation d’outils</td> <td>Effectuer des appels API, réaliser des calculs et exécuter du code.</td></tr> <tr><td>Interaction avec l’environnement</td> <td>Manipuler des interfaces numériques ou contrôler des dispositifs physiques.</td></tr> <tr><td>Communication</td> <td>Interagir avec les utilisateurs via le chat ou collaborer avec d’autres agents.</td></tr></tbody>",ce,j,Ye=`Le LLM ne gère que du texte et l’utilise pour décrire l’action qu’il souhaite entreprendre ainsi que les paramètres à fournir à l’outil.
Pour qu’un agent fonctionne correctement, le LLM doit savoir <strong>ARRÊTER de générer de nouveaux <em>tokens</em> lorsque l’action est terminée</strong>. Cela permet de transférer le contrôle du LLM à l’agent et de s’assurer que le résultat est analysable, que le format prévu soit JSON, du code ou des appels de fonctions.`,de,q,me,I,We="Une méthode clé pour implémenter des actions est l’<strong>approche <em>stop</em> and <em>parse</em></strong>. Cette méthode garantit que la sortie de l’agent est structurée et prévisible :",fe,L,Oe="<li><p><strong>Génération dans un format structuré</strong> :</p> <p>L’agent produit l’action envisagée dans un format clair et prédéfini (JSON ou code).</p></li> <li><p><strong>Arrêt de la génération</strong> :</p> <p>Une fois que le texte définissant l’action a été émis, le <strong>LLM cesse de générer des <em>tokens</em> supplémentaires</strong>. Cela permet d’éviter les sorties supplémentaires ou erronées.</p></li> <li><p><strong>Analyse de la sortie</strong> :</p> <p>Un parseur externe lit l’action formatée, détermine quel outil appeler, et extrait les paramètres requis.</p></li>",Me,$,Fe="Par exemple, un agent ayant besoin de vérifier la météo pourrait produire la sortie suivante :",ye,_,Te,B,De="Le <em>framework</em> peut ensuite analyser facilement le nom de la fonction à appeler et les arguments à fournir.",ge,H,Ke="Ce format clair et lisible par une machine minimise les erreurs et permet aux outils externes de traiter avec précision la commande de l’agent.",ve,E,et="<p>Note : Les agents à appel de fonction fonctionnent de manière similaire en structurant chaque action de manière à ce qu’une fonction désignée soit invoquée avec les arguments corrects. Nous approfondirons ces types d’agents dans une prochaine unité.</p>",Ue,Q,Je,S,tt=`Une approche alternative consiste à utiliser des <em>agents [générateur de] code</em>.<br/>
L’idée est : <strong>au lieu de produire un simple objet JSON</strong>, un agent code génère un <strong>bloc de code exécutable — typiquement dans un langage de haut niveau comme Python</strong>.`,he,z,nt,Ce,A,st="Cette approche offre plusieurs avantages :",be,Z,lt="<li><strong>Expressivité :</strong> Le code peut naturellement représenter une logique complexe, incluant des boucles, des conditionnels et des fonctions imbriquées, offrant ainsi une flexibilité supérieure au JSON.</li> <li><strong>Modularité et réutilisabilité :</strong> Le code généré peut inclure des fonctions et des modules réutilisables pour différentes actions ou tâches.</li> <li><strong>Débogage amélioré :</strong> Grâce à une syntaxe de programmation bien définie, les erreurs de code sont souvent plus faciles à détecter et corriger.</li> <li><strong>Intégration directe :</strong> Les agents à code peuvent s’intégrer directement avec des bibliothèques et des API externes, permettant ainsi des opérations plus complexes comme le traitement de données ou la prise de décision en temps réel.</li>",xe,G,it="Par exemple, un agent à code chargé de récupérer la météo pourrait générer l’extrait Python suivant :",we,N,je,R,at="Dans cet exemple, l’agent à code :",qe,P,rt="<li>Récupère des données météo <strong>via un appel API</strong>,</li> <li>Traite la réponse,</li> <li>Et utilise la fonction <code>print()</code> pour afficher la réponse finale.</li>",Ie,X,ot="Cette méthode <strong>suit également l’approche <em>stop and parse</em></strong> en délimitant clairement le bloc de code et en signalant quand l’exécution est terminée (ici, par l’affichage de <code>final_answer</code>).",Le,$e,_e,k,pt="Nous avons vu que les actions font le lien entre le raisonnement interne de l’agent et ses interactions réelles en exécutant des tâches claires et structurées — que ce soit via JSON, du code ou des appels de fonctions.",Be,V,ut="Cette exécution délibérée garantit que chaque action est précise et prête pour un traitement externe via l’approche <em>stop and parse</em>. Dans la section suivante, nous explorerons les Observations pour voir comment les agents capturent et intègrent les retours de leur environnement.",He,Y,ct="Après cela, nous serons <strong>finalement prêts à construire notre premier agent !</strong>",Ee,W,Qe,F,Se;return T=new ht({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new ze({props:{title:"Actions : permettre à l’agent d’interagir avec son environnement",local:"actions--permettre-à-lagent-dinteragir-avec-son-environnement",headingTag:"h1"}}),h=new ze({props:{title:"Types d’actions",local:"types-dactions",headingTag:"h2"}}),q=new ze({props:{title:"L’approche Stop and Parse",local:"lapproche-stop-and-parse",headingTag:"h2"}}),_=new mt({props:{code:"VGhvdWdodCUzQSUyMEplJTIwZG9pcyUyMHYlQzMlQTlyaWZpZXIlMjBsZSUyMHRlbXBzJTIwcXUnaWwlMjBmYWl0JTIwJUMzJUEwJTIwTmV3JTIwWW9yay4lMEFBY3Rpb24lMjAlM0ElMEElN0IlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJnZXRfd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMmFjdGlvbl9pbnB1dCUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyTmV3JTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> Je dois vérifier le temps qu&#x27;il fait à New York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;New York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Q=new ze({props:{title:"Agents à code",local:"agents-à-code",headingTag:"h2"}}),N=new mt({props:{code:"JTIzJTIwRXhlbXBsZSUyMGQnQWdlbnQlMjBDb2RlJTIwJTNBJTIwUiVDMyVBOWN1cCVDMyVBOXJlciUyMGRlcyUyMGluZm9ybWF0aW9ucyUyMG0lQzMlQTl0JUMzJUE5b3JvbG9naXF1ZXMlMEFkZWYlMjBnZXRfd2VhdGhlcihjaXR5KSUzQSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMHJlcXVlc3RzJTBBJTIwJTIwJTIwJTIwYXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRmFwaS53ZWF0aGVyLmNvbSUyRnYxJTJGbG9jYXRpb24lMkYlN0JjaXR5JTdEJTNGYXBpS2V5JTNEWU9VUl9BUElfS0VZJTIyJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQoYXBpX3VybCklMEElMjAlMjAlMjAlMjBpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwJTNEJTNEJTIwMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YSUyMCUzRCUyMHJlc3BvbnNlLmpzb24oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGRhdGEuZ2V0KCUyMndlYXRoZXIlMjIlMkMlMjAlMjJBdWN1bmUlMjBpbmZvcm1hdGlvbiUyMG0lQzMlQTl0JUMzJUE5byUyMGRpc3BvbmlibGUlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkVycmV1ciUyMCUzQSUyMEltcG9zc2libGUlMjBkZSUyMHIlQzMlQTljdXAlQzMlQTlyZXIlMjBsZXMlMjBkb25uJUMzJUE5ZXMlMjBtJUMzJUE5dCVDMyVBOW8uJTIyJTBBJTBBJTIzJTIwRXglQzMlQTljdXRlciUyMGxhJTIwZm9uY3Rpb24lMjBldCUyMHByJUMzJUE5cGFyZXIlMjBsYSUyMHIlQzMlQTlwb25zZSUyMGZpbmFsZSUwQXJlc3VsdCUyMCUzRCUyMGdldF93ZWF0aGVyKCUyMk5ldyUyMFlvcmslMjIpJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwZiUyMkxhJTIwbSVDMyVBOXQlQzMlQTlvJTIwYWN0dWVsbGUlMjAlQzMlQTAlMjBOZXclMjBZb3JrJTIwZXN0JTIwJTNBJTIwJTdCcmVzdWx0JTdEJTIyJTBBcHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:`<span class="hljs-comment"># Exemple d&#x27;Agent Code : Récupérer des informations météorologiques</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;Aucune information météo disponible&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Erreur : Impossible de récupérer les données météo.&quot;</span>

<span class="hljs-comment"># Exécuter la fonction et préparer la réponse finale</span>
result = get_weather(<span class="hljs-string">&quot;New York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;La météo actuelle à New York est : <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),W=new Ct({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit1/actions.mdx"}}),{c(){p=a("meta"),K=l(),O=a("p"),ee=l(),c(T.$$.fragment),te=l(),c(g.$$.fragment),ne=l(),u=a("blockquote"),u.innerHTML=Ze,se=l(),v=a("p"),v.innerHTML=Ge,le=l(),U=a("p"),U.textContent=Ne,ie=l(),J=a("p"),J.textContent=Re,ae=l(),c(h.$$.fragment),re=l(),C=a("p"),C.textContent=Pe,oe=l(),b=a("table"),b.innerHTML=Xe,pe=l(),x=a("p"),x.textContent=ke,ue=l(),w=a("table"),w.innerHTML=Ve,ce=l(),j=a("p"),j.innerHTML=Ye,de=l(),c(q.$$.fragment),me=l(),I=a("p"),I.innerHTML=We,fe=l(),L=a("ol"),L.innerHTML=Oe,Me=l(),$=a("p"),$.textContent=Fe,ye=l(),c(_.$$.fragment),Te=l(),B=a("p"),B.innerHTML=De,ge=l(),H=a("p"),H.textContent=Ke,ve=l(),E=a("blockquote"),E.innerHTML=et,Ue=l(),c(Q.$$.fragment),Je=l(),S=a("p"),S.innerHTML=tt,he=l(),z=a("img"),Ce=l(),A=a("p"),A.textContent=st,be=l(),Z=a("ul"),Z.innerHTML=lt,xe=l(),G=a("p"),G.textContent=it,we=l(),c(N.$$.fragment),je=l(),R=a("p"),R.textContent=at,qe=l(),P=a("ul"),P.innerHTML=rt,Ie=l(),X=a("p"),X.innerHTML=ot,Le=l(),$e=a("hr"),_e=l(),k=a("p"),k.textContent=pt,Be=l(),V=a("p"),V.innerHTML=ut,He=l(),Y=a("p"),Y.innerHTML=ct,Ee=l(),c(W.$$.fragment),Qe=l(),F=a("p"),this.h()},l(e){const t=Ut("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(n),K=i(e),O=r(e,"P",{}),dt(O).forEach(n),ee=i(e),d(T.$$.fragment,e),te=i(e),d(g.$$.fragment,e),ne=i(e),u=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(u)!=="svelte-oo722p"&&(u.innerHTML=Ze),se=i(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1697wml"&&(v.innerHTML=Ge),le=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-4fz2z8"&&(U.textContent=Ne),ie=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1404tx8"&&(J.textContent=Re),ae=i(e),d(h.$$.fragment,e),re=i(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1fso4d5"&&(C.textContent=Pe),oe=i(e),b=r(e,"TABLE",{"data-svelte-h":!0}),o(b)!=="svelte-2hr652"&&(b.innerHTML=Xe),pe=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1o3pjlj"&&(x.textContent=ke),ue=i(e),w=r(e,"TABLE",{"data-svelte-h":!0}),o(w)!=="svelte-1md8d1s"&&(w.innerHTML=Ve),ce=i(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1gi0wjo"&&(j.innerHTML=Ye),de=i(e),d(q.$$.fragment,e),me=i(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1j2776x"&&(I.innerHTML=We),fe=i(e),L=r(e,"OL",{"data-svelte-h":!0}),o(L)!=="svelte-gq832m"&&(L.innerHTML=Oe),Me=i(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1c5nt2s"&&($.textContent=Fe),ye=i(e),d(_.$$.fragment,e),Te=i(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-18q8hc0"&&(B.innerHTML=De),ge=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1bbqe0p"&&(H.textContent=Ke),ve=i(e),E=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(E)!=="svelte-gpl4dn"&&(E.innerHTML=et),Ue=i(e),d(Q.$$.fragment,e),Je=i(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1becqkk"&&(S.innerHTML=tt),he=i(e),z=r(e,"IMG",{src:!0,alt:!0}),Ce=i(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-hsjn6l"&&(A.textContent=st),be=i(e),Z=r(e,"UL",{"data-svelte-h":!0}),o(Z)!=="svelte-g2neo8"&&(Z.innerHTML=lt),xe=i(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-16y7q2r"&&(G.textContent=it),we=i(e),d(N.$$.fragment,e),je=i(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1hqpb3n"&&(R.textContent=at),qe=i(e),P=r(e,"UL",{"data-svelte-h":!0}),o(P)!=="svelte-168stk7"&&(P.innerHTML=rt),Ie=i(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-15wvbu7"&&(X.innerHTML=ot),Le=i(e),$e=r(e,"HR",{}),_e=i(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-2r0pbh"&&(k.textContent=pt),Be=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-tnlt1c"&&(V.innerHTML=ut),He=i(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1x6jlyx"&&(Y.innerHTML=ct),Ee=i(e),d(W.$$.fragment,e),Qe=i(e),F=r(e,"P",{}),dt(F).forEach(n),this.h()},h(){D(p,"name","hf:doc:metadata"),D(p,"content",xt),D(u,"class","tip"),Mt(z.src,nt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||D(z,"src",nt),D(z,"alt","Agents Code")},m(e,t){Jt(document.head,p),s(e,K,t),s(e,O,t),s(e,ee,t),m(T,e,t),s(e,te,t),m(g,e,t),s(e,ne,t),s(e,u,t),s(e,se,t),s(e,v,t),s(e,le,t),s(e,U,t),s(e,ie,t),s(e,J,t),s(e,ae,t),m(h,e,t),s(e,re,t),s(e,C,t),s(e,oe,t),s(e,b,t),s(e,pe,t),s(e,x,t),s(e,ue,t),s(e,w,t),s(e,ce,t),s(e,j,t),s(e,de,t),m(q,e,t),s(e,me,t),s(e,I,t),s(e,fe,t),s(e,L,t),s(e,Me,t),s(e,$,t),s(e,ye,t),m(_,e,t),s(e,Te,t),s(e,B,t),s(e,ge,t),s(e,H,t),s(e,ve,t),s(e,E,t),s(e,Ue,t),m(Q,e,t),s(e,Je,t),s(e,S,t),s(e,he,t),s(e,z,t),s(e,Ce,t),s(e,A,t),s(e,be,t),s(e,Z,t),s(e,xe,t),s(e,G,t),s(e,we,t),m(N,e,t),s(e,je,t),s(e,R,t),s(e,qe,t),s(e,P,t),s(e,Ie,t),s(e,X,t),s(e,Le,t),s(e,$e,t),s(e,_e,t),s(e,k,t),s(e,Be,t),s(e,V,t),s(e,He,t),s(e,Y,t),s(e,Ee,t),m(W,e,t),s(e,Qe,t),s(e,F,t),Se=!0},p:yt,i(e){Se||(f(T.$$.fragment,e),f(g.$$.fragment,e),f(h.$$.fragment,e),f(q.$$.fragment,e),f(_.$$.fragment,e),f(Q.$$.fragment,e),f(N.$$.fragment,e),f(W.$$.fragment,e),Se=!0)},o(e){M(T.$$.fragment,e),M(g.$$.fragment,e),M(h.$$.fragment,e),M(q.$$.fragment,e),M(_.$$.fragment,e),M(Q.$$.fragment,e),M(N.$$.fragment,e),M(W.$$.fragment,e),Se=!1},d(e){e&&(n(K),n(O),n(ee),n(te),n(ne),n(u),n(se),n(v),n(le),n(U),n(ie),n(J),n(ae),n(re),n(C),n(oe),n(b),n(pe),n(x),n(ue),n(w),n(ce),n(j),n(de),n(me),n(I),n(fe),n(L),n(Me),n($),n(ye),n(Te),n(B),n(ge),n(H),n(ve),n(E),n(Ue),n(Je),n(S),n(he),n(z),n(Ce),n(A),n(be),n(Z),n(xe),n(G),n(we),n(je),n(R),n(qe),n(P),n(Ie),n(X),n(Le),n($e),n(_e),n(k),n(Be),n(V),n(He),n(Y),n(Ee),n(Qe),n(F)),n(p),y(T,e),y(g,e),y(h,e),y(q,e),y(_,e),y(Q,e),y(N,e),y(W,e)}}}const xt='{"title":"Actions : permettre à l’agent d’interagir avec son environnement","local":"actions--permettre-à-lagent-dinteragir-avec-son-environnement","sections":[{"title":"Types d’actions","local":"types-dactions","sections":[],"depth":2},{"title":"L’approche Stop and Parse","local":"lapproche-stop-and-parse","sections":[],"depth":2},{"title":"Agents à code","local":"agents-à-code","sections":[],"depth":2}],"depth":1}';function wt(Ae){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends gt{constructor(p){super(),vt(this,p,wt,bt,ft,{})}}export{_t as component};
