import{s as Te,a as ce,n as we,o as Ie}from"../chunks/scheduler.505acc25.js";import{S as de,i as he,e as M,s as a,c as y,h as be,a as i,d as e,b as n,f as ue,g as o,j as p,k as Cl,l as Ce,m as t,n as r,t as U,o as J,p as j}from"../chunks/index.b1175496.js";import{C as ge,H as m}from"../chunks/Heading.988e52fa.js";import{C as c}from"../chunks/CodeBlock.ed64aebc.js";import{E as Be}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function fe(Ns){let u,fl,gl,Zl,w,Wl,I,Gl,d,vs="Maintenant que nous comprenons les composants de base, mettons-les en pratique en construisant notre premier graphe fonctionnel. Nous implémenterons le système de traitement des emails reçus par Alfred, où il doit :",Al,h,Ss="<li>Lire les emails entrants</li> <li>Les classifier comme spam ou légitimes</li> <li>Rédiger une réponse préliminaire pour les emails légitimes</li> <li>Envoyer les informations à M. Wayne quand c’est légitime (affichage seulement)</li>",Vl,b,zs="Cet exemple démontre comment structurer un <em>workflow</em> avec LangGraph qui implique une prise de décision basée sur LLM. Bien que cela ne puisse pas être considéré comme un agent car aucun outil n’est impliqué, cette section se concentre plus sur l’apprentissage du <em>framework</em> LangGraph que sur les agents.",Ql,T,Xs='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/langgraph/mail_sorting.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',ql,C,El,g,ks="Voici le <em>workflow</em> que nous allons construire :",Nl,B,Fs,vl,f,Sl,Z,xs="Tout d’abord, installons les <em>packages</em> requis :",zl,W,Xl,G,_s="Ensuite, importons les modules nécessaires :",kl,A,Fl,V,xl,Q,$s="Définissons quelles informations Alfred doit suivre pendant le <em>workflow</em> de traitement des emails :",_l,q,$l,E,Rs="<p>💡 <strong>Astuce :</strong> Rendez votre état suffisamment complet pour suivre toutes les informations importantes, mais évitez de l’encombrer avec des détails inutiles.</p>",Rl,N,Yl,v,Ys="Maintenant, créons les fonctions de traitement qui formeront nos nœuds :",Hl,S,Ll,z,Dl,X,Hs="Nous avons besoin d’une fonction pour déterminer quel chemin prendre après la classification :",Ol,k,Pl,F,Ls="<p>💡 <strong>Note :</strong> Cette fonction de routage est appelée par LangGraph pour déterminer quelle arête suivre après le nœud de classification. La valeur de retour doit correspondre à l’une des clés dans notre mappage d’arêtes conditionnelles.</p>",Kl,x,ls,_,Ds="Maintenant nous connectons tout ensemble :",ss,$,es,R,Os="Remarquez comment nous utilisons le nœud spécial <code>END</code> fourni par LangGraph. Cela indique les états terminaux où le <em>workflow</em> se termine.",ts,Y,as,H,Ps="Testons notre graphe avec un email légitime et un email spam :",ns,L,Ms,D,is,O,Ks="Alors qu’Alfred peaufine l’agent trieur d’email, il se lasse de déboguer ses exécutions. Les agents, par nature, sont imprévisibles et difficiles à inspecter. Mais comme il vise à construire l’agent de détection de spam ultime et à le déployer en production, il a besoin d’une traçabilité robuste pour le <em>monitoring</em> et l’analyse futurs.",ps,P,le='Pour cela, Alfred peut utiliser un outil d’observabilité comme <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> pour tracer et monitorer l’agent.',ys,K,se="Premièrement, nous installons Langfuse avec pip :",os,ll,rs,sl,ee="Deuxièmement, nous installons LangChain avec pip (LangChain est requis car nous utilisons LangFuse) :",Us,el,Js,tl,te='Ensuite, nous ajoutons les clés API LangFuse et l’adresse de l’hôte comme variables d’environnement. Vous pouvez obtenir vos identifiants LangFuse en vous inscrivant sur <a href="https://cloud.langfuse.com" rel="nofollow">LangFuse Cloud</a> ou en <a href="https://langfuse.com/self-hosting" rel="nofollow">auto-hébergeant LangFuse</a>.',js,al,ms,nl,ae='Ensuite, nous configurons le <a href="https://langfuse.com/docs/integrations/langchain/tracing#add-langfuse-to-your-langchain-application" rel="nofollow">LangFuse <code>callback_handler</code></a> et instrumentons l’agent en ajoutant le <code>langfuse_callback</code> à l’invocation du graphe : <code>config={&quot;callbacks&quot;: [langfuse_handler]}</code>.',cs,Ml,us,il,ne="Alfred est maintenant connecté 🔌 ! Les exécutions de LangGraph sont enregistrées dans LangFuse, lui donnant une visibilité complète sur le comportement de l’agent. Avec cette configuration, il est prêt à revisiter les exécutions précédentes et à affiner encore plus son agent de tri de courrier.",Ts,pl,Me='<img src="https://langfuse.com/images/cookbook/huggingface-agent-course/langgraph-trace-legit.png" alt="Example trace in Langfuse"/>',ws,yl,ie='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/f5d6d72e-20af-4357-b232-af44c3728a7b?timestamp=2025-03-17T10%3A13%3A28.413Z&amp;observation=6997ba69-043f-4f77-9445-700a033afba1" rel="nofollow">Lien public vers la trace avec l’email légitime</a></em>',Is,ol,ds,rl,pe="LangGraph nous permet de visualiser notre <em>workflow</em> pour mieux comprendre et déboguer sa structure :",hs,Ul,bs,Jl,ye,Cs,jl,oe="Cela produit une représentation visuelle montrant comment nos nœuds sont connectés et les chemins conditionnels qui peuvent être pris.",gs,ml,Bs,cl,re="Nous avons créé un <em>workflow</em> complet de traitement des emails qui :",fs,ul,Ue="<li>Prend un email entrant</li> <li>Utilise un LLM pour le classifier comme spam ou légitime</li> <li>Gère le spam en le rejetant</li> <li>Pour les emails légitimes, rédige une réponse et informe M. Hugg</li>",Zs,Tl,Je="Cela démontre la puissance de LangGraph pour orchestrer des <em>workflows</em> complexes avec des LLM tout en maintenant un flux clair et structuré.",Ws,wl,Gs,Il,je="<li><strong>Gestion d’état</strong> : Nous avons défini un état complet pour suivre tous les aspects du traitement des emails</li> <li><strong>Implémentation de nœuds</strong> : Nous avons créé des nœuds fonctionnels qui interagissent avec un LLM</li> <li><strong>Routage conditionnel</strong> : Nous avons implémenté une logique d’embranchement basée sur la classification des emails</li> <li><strong>États terminaux</strong> : Nous avons utilisé le nœud <em>END</em> pour marquer les points d’achèvement dans notre <em>workflow</em></li>",As,dl,Vs,hl,me="Dans la prochaine section, nous explorerons des fonctionnalités plus avancées de LangGraph, y compris la gestion de l’interaction humaine dans le <em>workflow</em> et l’implémentation d’une logique d’embranchement plus complexe basée sur plusieurs conditions.",Qs,bl,qs,Bl,Es;return w=new ge({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),I=new m({props:{title:"Construire votre premier LangGraph",local:"construire-votre-premier-langgraph",headingTag:"h1"}}),C=new m({props:{title:"Notre workflow",local:"notre-workflow",headingTag:"h2"}}),f=new m({props:{title:"Configuration de notre environnement",local:"configuration-de-notre-environnement",headingTag:"h2"}}),W=new c({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWk=",highlighted:"%pip install langgraph langchain_openai",wrap:!1}}),A=new c({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwVHlwZWREaWN0JTJDJTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEFmcm9tJTIwbGFuZ2NoYWluX29wZW5haSUyMGltcG9ydCUyMENoYXRPcGVuQUklMEFmcm9tJTIwbGFuZ2NoYWluX2NvcmUubWVzc2FnZXMlMjBpbXBvcnQlMjBIdW1hbk1lc3NhZ2U=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> HumanMessage`,wrap:!1}}),V=new m({props:{title:"Étape 1 : Définir notre état",local:"étape-1--définir-notre-état",headingTag:"h2"}}),q=new c({props:{code:"Y2xhc3MlMjBFbWFpbFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBMJ2VtYWlsJTIwZW4lMjBjb3VycyUyMGRlJTIwdHJhaXRlbWVudCUwQSUyMCUyMCUyMCUyMGVtYWlsJTNBJTIwRGljdCU1QnN0ciUyQyUyMEFueSU1RCUyMCUyMCUyMyUyMENvbnRpZW50JTIwc3VqZXQlMkMlMjBleHAlQzMlQTlkaXRldXIlMkMlMjBjb3JwcyUyQyUyMGV0Yy4lMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDYXQlQzMlQTlnb3JpZSUyMGRlJTIwbCdlbWFpbCUyMChlbnF1JUMzJUFBdGUlMkMlMjBwbGFpbnRlJTJDJTIwZXRjLiklMEElMjAlMjAlMjAlMjBlbWFpbF9jYXRlZ29yeSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmFpc29uJTIwcG91cnF1b2klMjBsJ2VtYWlsJTIwYSUyMCVDMyVBOXQlQzMlQTklMjBtYXJxdSVDMyVBOSUyMGNvbW1lJTIwc3BhbSUwQSUyMCUyMCUyMCUyMHNwYW1fcmVhc29uJTNBJTIwT3B0aW9uYWwlNUJzdHIlNUQlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBBbmFseXNlJTIwZXQlMjBkJUMzJUE5Y2lzaW9ucyUwQSUyMCUyMCUyMCUyMGlzX3NwYW0lM0ElMjBPcHRpb25hbCU1QmJvb2wlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBHJUMzJUE5biVDMyVBOXJhdGlvbiUyMGRlJTIwciVDMyVBOXBvbnNlJTBBJTIwJTIwJTIwJTIwZW1haWxfZHJhZnQlM0ElMjBPcHRpb25hbCU1QnN0ciU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyME0lQzMlQTl0YWRvbm4lQzMlQTllcyUyMGRlJTIwdHJhaXRlbWVudCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNBJTIwTGlzdCU1QkRpY3QlNUJzdHIlMkMlMjBBbnklNUQlNUQlMjAlMjAlMjMlMjBTdWl2cmUlMjBsYSUyMGNvbnZlcnNhdGlvbiUyMGF2ZWMlMjBsZSUyMExMTSUyMHBvdXIlMjBsJ2FuYWx5c2U=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmailState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># L&#x27;email en cours de traitement</span>
    email: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]  <span class="hljs-comment"># Contient sujet, expéditeur, corps, etc.</span>

    <span class="hljs-comment"># Catégorie de l&#x27;email (enquête, plainte, etc.)</span>
    email_category: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]

    <span class="hljs-comment"># Raison pourquoi l&#x27;email a été marqué comme spam</span>
    spam_reason: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]

    <span class="hljs-comment"># Analyse et décisions</span>
    is_spam: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>]
    
    <span class="hljs-comment"># Génération de réponse</span>
    email_draft: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]
    
    <span class="hljs-comment"># Métadonnées de traitement</span>
    messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]  <span class="hljs-comment"># Suivre la conversation avec le LLM pour l&#x27;analyse</span>`,wrap:!1}}),N=new m({props:{title:"Étape 2 : Définir nos nœuds",local:"étape-2--définir-nos-nœuds",headingTag:"h2"}}),S=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># Initialiser notre LLM</span>
model = ChatOpenAI(temperature=<span class="hljs-number">0</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred lit et enregistre l&#x27;email entrant&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Ici nous pourrions faire un prétraitement initial</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred traite un email de <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span> avec le sujet : <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    
    <span class="hljs-comment"># Aucun changement d&#x27;état nécessaire ici</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred utilise un LLM pour déterminer si l&#x27;email est spam ou légitime&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Préparer notre prompt pour le LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    En tant qu&#x27;Alfred le majordome, analysez cet email et déterminez s&#x27;il s&#x27;agit de spam ou s&#x27;il est légitime.
    
    email :
    De : <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Sujet : <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Corps : <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    Premièrement, détermine si cet email est du spam. S&#x27;il s&#x27;agit de spam, explique pourquoi.
    S&#x27;il est légitime, catégorise-le (enquête, plainte, remerciement, etc.).
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Appeler le LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Logique simple pour analyser la réponse (dans une vraie app, vous voudriez un parsing plus robuste)</span>
    response_text = response.content.lower()
    is_spam = <span class="hljs-string">&quot;spam&quot;</span> <span class="hljs-keyword">in</span> response_text <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;not spam&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> response_text
    
    <span class="hljs-comment"># Extraire une raison si c&#x27;est du spam</span>
    spam_reason = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> is_spam <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;reason:&quot;</span> <span class="hljs-keyword">in</span> response_text:
        spam_reason = response_text.split(<span class="hljs-string">&quot;reason:&quot;</span>)[<span class="hljs-number">1</span>].strip()
    
    <span class="hljs-comment"># Déterminer la catégorie si légitime</span>
    email_category = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> is_spam:
        categories = [<span class="hljs-string">&quot;inquiry&quot;</span>, <span class="hljs-string">&quot;complaint&quot;</span>, <span class="hljs-string">&quot;thank you&quot;</span>, <span class="hljs-string">&quot;request&quot;</span>, <span class="hljs-string">&quot;information&quot;</span>]
        <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> categories:
            <span class="hljs-keyword">if</span> category <span class="hljs-keyword">in</span> response_text:
                email_category = category
                <span class="hljs-keyword">break</span>
    
    <span class="hljs-comment"># Mettre à jour les messages pour le suivi</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Retourner les mises à jour d&#x27;état</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;is_spam&quot;</span>: is_spam,
        <span class="hljs-string">&quot;spam_reason&quot;</span>: spam_reason,
        <span class="hljs-string">&quot;email_category&quot;</span>: email_category,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_spam</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred rejette l&#x27;email spam avec une note explicative&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred a marqué l&#x27;email comme spam. Raison : <span class="hljs-subst">{state[<span class="hljs-string">&#x27;spam_reason&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L&#x27;email a été déplacé dans le dossier spam.&quot;</span>)
    
    <span class="hljs-comment"># Nous avons fini de traiter cet email</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draft_response</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred rédige une réponse préliminaire pour les emails légitimes&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    category = state[<span class="hljs-string">&quot;email_category&quot;</span>] <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;general&quot;</span>
    
    <span class="hljs-comment"># Préparer notre prompt pour le LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    En tant qu&#x27;Alfred le majordome, rédige une réponse préliminaire polie à cet email.
    
    email :
    De : <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Sujet : <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Corps : <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    Cet email a été catégorisé comme : <span class="hljs-subst">{category}</span>
    
    Rédige une réponse brève et professionnelle que M. Hugg peut réviser et personnaliser avant l&#x27;envoi.
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Appeler le LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Mettre à jour les messages pour le suivi</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Retourner les mises à jour d&#x27;état</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;email_draft&quot;</span>: response.content,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">notify_mr_hugg</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred informe M. Hugg de l&#x27;email et présente le brouillon de réponse&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Monsieur, vous avez reçu un email de <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Sujet : <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Catégorie : <span class="hljs-subst">{state[<span class="hljs-string">&#x27;email_category&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nJ&#x27;ai préparé un brouillon de réponse pour votre révision :&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;email_draft&quot;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)
    
    <span class="hljs-comment"># Nous avons fini de traiter cet email</span>
    <span class="hljs-keyword">return</span> {}`,wrap:!1}}),z=new m({props:{title:"Étape 3 : Définir notre logique de routage",local:"étape-3--définir-notre-logique-de-routage",headingTag:"h2"}}),k=new c({props:{code:"ZGVmJTIwcm91dGVfZW1haWwoc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJEJUMzJUE5dGVybWluZXIlMjBsYSUyMHByb2NoYWluZSUyMCVDMyVBOXRhcGUlMjBiYXMlQzMlQTllJTIwc3VyJTIwbGElMjBjbGFzc2lmaWNhdGlvbiUyMGVuJTIwc3BhbSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwc3RhdGUlNUIlMjJpc19zcGFtJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyc3BhbSUyMiUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJsZWdpdGltYXRlJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">route_email</span>(<span class="hljs-params">state: EmailState</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Déterminer la prochaine étape basée sur la classification en spam&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> state[<span class="hljs-string">&quot;is_spam&quot;</span>]:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;spam&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;legitimate&quot;</span>`,wrap:!1}}),x=new m({props:{title:"Étape 4 : Créer le StateGraph et définir les arêtes",local:"étape-4--créer-le-stategraph-et-définir-les-arêtes",headingTag:"h2"}}),$=new c({props:{code:"JTIzJTIwQ3IlQzMlQTllciUyMGxlJTIwZ3JhcGhlJTBBZW1haWxfZ3JhcGglMjAlM0QlMjBTdGF0ZUdyYXBoKEVtYWlsU3RhdGUpJTBBJTBBJTIzJTIwQWpvdXRlciUyMGxlcyUyMG4lQzUlOTN1ZHMlMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJyZWFkX2VtYWlsJTIyJTJDJTIwcmVhZF9lbWFpbCklMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJjbGFzc2lmeV9lbWFpbCUyMiUyQyUyMGNsYXNzaWZ5X2VtYWlsKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMmhhbmRsZV9zcGFtJTIyJTJDJTIwaGFuZGxlX3NwYW0pJTBBZW1haWxfZ3JhcGguYWRkX25vZGUoJTIyZHJhZnRfcmVzcG9uc2UlMjIlMkMlMjBkcmFmdF9yZXNwb25zZSklMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJub3RpZnlfbXJfaHVnZyUyMiUyQyUyMG5vdGlmeV9tcl9odWdnKSUwQSUwQSUyMyUyMENvbW1lbmNlciUyMGxlcyUyMGFyJUMzJUFBdGVzJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoU1RBUlQlMkMlMjAlMjJyZWFkX2VtYWlsJTIyKSUwQSUyMyUyMEFqb3V0ZXIlMjBsZXMlMjBhciVDMyVBQXRlcyUyMC0lMjBkJUMzJUE5ZmluaXIlMjBsZSUyMGZsdXglMEFlbWFpbF9ncmFwaC5hZGRfZWRnZSglMjJyZWFkX2VtYWlsJTIyJTJDJTIwJTIyY2xhc3NpZnlfZW1haWwlMjIpJTBBJTBBJTIzJTIwQWpvdXRlciUyMGwnZW1icmFuY2hlbWVudCUyMGNvbmRpdGlvbm5lbCUyMGRlcHVpcyUyMGNsYXNzaWZ5X2VtYWlsJTBBZW1haWxfZ3JhcGguYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUwQSUyMCUyMCUyMCUyMCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcm91dGVfZW1haWwlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGFtJTIyJTNBJTIwJTIyaGFuZGxlX3NwYW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWdpdGltYXRlJTIyJTNBJTIwJTIyZHJhZnRfcmVzcG9uc2UlMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBBJTBBJTIzJTIwQWpvdXRlciUyMGxlcyUyMGFyJUMzJUFBdGVzJTIwZmluYWxlcyUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKCUyMmhhbmRsZV9zcGFtJTIyJTJDJTIwRU5EKSUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKCUyMmRyYWZ0X3Jlc3BvbnNlJTIyJTJDJTIwJTIybm90aWZ5X21yX2h1Z2clMjIpJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIybm90aWZ5X21yX2h1Z2clMjIlMkMlMjBFTkQpJTBBJTBBJTIzJTIwQ29tcGlsZXIlMjBsZSUyMGdyYXBoZSUwQWNvbXBpbGVkX2dyYXBoJTIwJTNEJTIwZW1haWxfZ3JhcGguY29tcGlsZSgp",highlighted:`<span class="hljs-comment"># Créer le graphe</span>
email_graph = StateGraph(EmailState)

<span class="hljs-comment"># Ajouter les nœuds</span>
email_graph.add_node(<span class="hljs-string">&quot;read_email&quot;</span>, read_email)
email_graph.add_node(<span class="hljs-string">&quot;classify_email&quot;</span>, classify_email)
email_graph.add_node(<span class="hljs-string">&quot;handle_spam&quot;</span>, handle_spam)
email_graph.add_node(<span class="hljs-string">&quot;draft_response&quot;</span>, draft_response)
email_graph.add_node(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, notify_mr_hugg)

<span class="hljs-comment"># Commencer les arêtes</span>
email_graph.add_edge(START, <span class="hljs-string">&quot;read_email&quot;</span>)
<span class="hljs-comment"># Ajouter les arêtes - définir le flux</span>
email_graph.add_edge(<span class="hljs-string">&quot;read_email&quot;</span>, <span class="hljs-string">&quot;classify_email&quot;</span>)

<span class="hljs-comment"># Ajouter l&#x27;embranchement conditionnel depuis classify_email</span>
email_graph.add_conditional_edges(
    <span class="hljs-string">&quot;classify_email&quot;</span>,
    route_email,
    {
        <span class="hljs-string">&quot;spam&quot;</span>: <span class="hljs-string">&quot;handle_spam&quot;</span>,
        <span class="hljs-string">&quot;legitimate&quot;</span>: <span class="hljs-string">&quot;draft_response&quot;</span>
    }
)

<span class="hljs-comment"># Ajouter les arêtes finales</span>
email_graph.add_edge(<span class="hljs-string">&quot;handle_spam&quot;</span>, END)
email_graph.add_edge(<span class="hljs-string">&quot;draft_response&quot;</span>, <span class="hljs-string">&quot;notify_mr_hugg&quot;</span>)
email_graph.add_edge(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, END)

<span class="hljs-comment"># Compiler le graphe</span>
compiled_graph = email_graph.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),Y=new m({props:{title:"Étape 5 : Exécuter l’application",local:"étape-5--exécuter-lapplication",headingTag:"h2"}}),L=new c({props:{code:"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",highlighted:`<span class="hljs-comment"># Exemple d&#x27;email légitime</span>
legitimate_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;john.smith@example.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;Question sur vos services&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;Cher M. Hugg, J&#x27;ai été référé à vous par un collègue et je suis intéressé à en savoir plus sur vos services de conseil. Pourrions-nous programmer un appel la semaine prochaine ? Meilleures salutations, John Smith&quot;</span>
}

<span class="hljs-comment"># Exemple d&#x27;email spam</span>
spam_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;winner@lottery-intl.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;VOUS AVEZ GAGNÉ 5 000 000 $ !!!&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;FÉLICITATIONS ! Vous avez été sélectionné comme gagnant de notre loterie internationale ! Pour réclamer votre prix de 5 000 000 $, veuillez nous envoyer vos coordonnées bancaires et des frais de traitement de 100 $.&quot;</span>
}

<span class="hljs-comment"># Traiter l&#x27;email légitime</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nTraitement de l&#x27;email légitime...&quot;</span>)
legitimate_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: legitimate_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_draft&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})

<span class="hljs-comment"># Traiter l&#x27;email spam</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nTraitement de l&#x27;email spam...&quot;</span>)
spam_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: spam_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_draft&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})`,wrap:!1}}),D=new m({props:{title:"Étape 6 : Inspecter notre agent trieur d’email avec Langfuse 📡",local:"étape-6--inspecter-notre-agent-trieur-demail-avec-langfuse-",headingTag:"h2"}}),ll=new c({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwbGFuZ2Z1c2U=",highlighted:"%pip install -q langfuse",wrap:!1}}),el=new c({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdjaGFpbg==",highlighted:"%pip install langchain",wrap:!1}}),al=new c({props:{code:"aW1wb3J0JTIwb3MlMEElMjAlMEElMjMlMjBPYnRlbmV6JTIwbGVzJTIwY2wlQzMlQTlzJTIwcG91ciUyMHZvdHJlJTIwcHJvamV0JTIwZGVwdWlzJTIwbGElMjBwYWdlJTIwZGVzJTIwcGFyYW0lQzMlQTh0cmVzJTIwZHUlMjBwcm9qZXQlMjAlM0ElMjBodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9QVUJMSUNfS0VZJTIyJTVEJTIwJTNEJTIwJTIycGstbGYtLi4uJTIyJTIwJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1NFQ1JFVF9LRVklMjIlNUQlMjAlM0QlMjAlMjJzay1sZi0uLi4lMjIlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfSE9TVCUyMiU1RCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTIyJTIwJTIzJTIwJUYwJTlGJTg3JUFBJUYwJTlGJTg3JUJBJTIwciVDMyVBOWdpb24lMjBFVSUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjByJUMzJUE5Z2lvbiUyMFVT",highlighted:`<span class="hljs-keyword">import</span> os
 
<span class="hljs-comment"># Obtenez les clés pour votre projet depuis la page des paramètres du projet : https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 région EU</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 région US</span>`,wrap:!1}}),Ml=new c({props:{code:"ZnJvbSUyMGxhbmdmdXNlLmxhbmdjaGFpbiUyMGltcG9ydCUyMENhbGxiYWNrSGFuZGxlciUwQSUwQSUyMyUyMEluaXRpYWxpc2VyJTIwbGUlMjBDYWxsYmFja0hhbmRsZXIlMjBMYW5nZnVzZSUyMHBvdXIlMjBMYW5nR3JhcGglMkZMYW5nY2hhaW4lMjAodHJhJUMzJUE3YWdlKSUwQWxhbmdmdXNlX2hhbmRsZXIlMjAlM0QlMjBDYWxsYmFja0hhbmRsZXIoKSUwQSUwQSUyMyUyMFRyYWl0ZXIlMjBsJ2VtYWlsJTIwbCVDMyVBOWdpdGltZSUwQWxlZ2l0aW1hdGVfcmVzdWx0JTIwJTNEJTIwY29tcGlsZWRfZ3JhcGguaW52b2tlKCUwQSUyMCUyMCUyMCUyMGlucHV0JTNEJTdCJTIyZW1haWwlMjIlM0ElMjBsZWdpdGltYXRlX2VtYWlsJTJDJTIwJTIyaXNfc3BhbSUyMiUzQSUyME5vbmUlMkMlMjAlMjJzcGFtX3JlYXNvbiUyMiUzQSUyME5vbmUlMkMlMjAlMjJlbWFpbF9jYXRlZ29yeSUyMiUzQSUyME5vbmUlMkMlMjAlMjJkcmFmdF9yZXNwb25zZSUyMiUzQSUyME5vbmUlMkMlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRCU3QiUyMmNhbGxiYWNrcyUyMiUzQSUyMCU1QmxhbmdmdXNlX2hhbmRsZXIlNUQlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse.langchain <span class="hljs-keyword">import</span> CallbackHandler

<span class="hljs-comment"># Initialiser le CallbackHandler Langfuse pour LangGraph/Langchain (traçage)</span>
langfuse_handler = CallbackHandler()

<span class="hljs-comment"># Traiter l&#x27;email légitime</span>
legitimate_result = compiled_graph.invoke(
    <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;email&quot;</span>: legitimate_email, <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;messages&quot;</span>: []},
    config={<span class="hljs-string">&quot;callbacks&quot;</span>: [langfuse_handler]}
)`,wrap:!1}}),ol=new m({props:{title:"Visualiser notre graphe",local:"visualiser-notre-graphe",headingTag:"h2"}}),Ul=new c({props:{code:"Y29tcGlsZWRfZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygp",highlighted:"compiled_graph.get_graph().draw_mermaid_png()",wrap:!1}}),ml=new m({props:{title:"Ce que nous avons construit",local:"ce-que-nous-avons-construit",headingTag:"h2"}}),wl=new m({props:{title:"Points clés à retenir",local:"points-clés-à-retenir",headingTag:"h2"}}),dl=new m({props:{title:"Et maintenant ?",local:"et-maintenant-",headingTag:"h2"}}),bl=new Be({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/langgraph/first_graph.mdx"}}),{c(){u=M("meta"),fl=a(),gl=M("p"),Zl=a(),y(w.$$.fragment),Wl=a(),y(I.$$.fragment),Gl=a(),d=M("p"),d.textContent=vs,Al=a(),h=M("ol"),h.innerHTML=Ss,Vl=a(),b=M("p"),b.innerHTML=zs,Ql=a(),T=M("blockquote"),T.innerHTML=Xs,ql=a(),y(C.$$.fragment),El=a(),g=M("p"),g.innerHTML=ks,Nl=a(),B=M("img"),vl=a(),y(f.$$.fragment),Sl=a(),Z=M("p"),Z.innerHTML=xs,zl=a(),y(W.$$.fragment),Xl=a(),G=M("p"),G.textContent=_s,kl=a(),y(A.$$.fragment),Fl=a(),y(V.$$.fragment),xl=a(),Q=M("p"),Q.innerHTML=$s,_l=a(),y(q.$$.fragment),$l=a(),E=M("blockquote"),E.innerHTML=Rs,Rl=a(),y(N.$$.fragment),Yl=a(),v=M("p"),v.textContent=Ys,Hl=a(),y(S.$$.fragment),Ll=a(),y(z.$$.fragment),Dl=a(),X=M("p"),X.textContent=Hs,Ol=a(),y(k.$$.fragment),Pl=a(),F=M("blockquote"),F.innerHTML=Ls,Kl=a(),y(x.$$.fragment),ls=a(),_=M("p"),_.textContent=Ds,ss=a(),y($.$$.fragment),es=a(),R=M("p"),R.innerHTML=Os,ts=a(),y(Y.$$.fragment),as=a(),H=M("p"),H.textContent=Ps,ns=a(),y(L.$$.fragment),Ms=a(),y(D.$$.fragment),is=a(),O=M("p"),O.innerHTML=Ks,ps=a(),P=M("p"),P.innerHTML=le,ys=a(),K=M("p"),K.textContent=se,os=a(),y(ll.$$.fragment),rs=a(),sl=M("p"),sl.textContent=ee,Us=a(),y(el.$$.fragment),Js=a(),tl=M("p"),tl.innerHTML=te,js=a(),y(al.$$.fragment),ms=a(),nl=M("p"),nl.innerHTML=ae,cs=a(),y(Ml.$$.fragment),us=a(),il=M("p"),il.textContent=ne,Ts=a(),pl=M("p"),pl.innerHTML=Me,ws=a(),yl=M("p"),yl.innerHTML=ie,Is=a(),y(ol.$$.fragment),ds=a(),rl=M("p"),rl.innerHTML=pe,hs=a(),y(Ul.$$.fragment),bs=a(),Jl=M("img"),Cs=a(),jl=M("p"),jl.textContent=oe,gs=a(),y(ml.$$.fragment),Bs=a(),cl=M("p"),cl.innerHTML=re,fs=a(),ul=M("ol"),ul.innerHTML=Ue,Zs=a(),Tl=M("p"),Tl.innerHTML=Je,Ws=a(),y(wl.$$.fragment),Gs=a(),Il=M("ul"),Il.innerHTML=je,As=a(),y(dl.$$.fragment),Vs=a(),hl=M("p"),hl.innerHTML=me,Qs=a(),y(bl.$$.fragment),qs=a(),Bl=M("p"),this.h()},l(l){const s=be("svelte-u9bgzb",document.head);u=i(s,"META",{name:!0,content:!0}),s.forEach(e),fl=n(l),gl=i(l,"P",{}),ue(gl).forEach(e),Zl=n(l),o(w.$$.fragment,l),Wl=n(l),o(I.$$.fragment,l),Gl=n(l),d=i(l,"P",{"data-svelte-h":!0}),p(d)!=="svelte-joxdvp"&&(d.textContent=vs),Al=n(l),h=i(l,"OL",{"data-svelte-h":!0}),p(h)!=="svelte-d8d9yj"&&(h.innerHTML=Ss),Vl=n(l),b=i(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-zv1y8r"&&(b.innerHTML=zs),Ql=n(l),T=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-179ghm9"&&(T.innerHTML=Xs),ql=n(l),o(C.$$.fragment,l),El=n(l),g=i(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-klwm00"&&(g.innerHTML=ks),Nl=n(l),B=i(l,"IMG",{src:!0,alt:!0}),vl=n(l),o(f.$$.fragment,l),Sl=n(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-86hspx"&&(Z.innerHTML=xs),zl=n(l),o(W.$$.fragment,l),Xl=n(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1o6mwvs"&&(G.textContent=_s),kl=n(l),o(A.$$.fragment,l),Fl=n(l),o(V.$$.fragment,l),xl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-zwio3t"&&(Q.innerHTML=$s),_l=n(l),o(q.$$.fragment,l),$l=n(l),E=i(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(E)!=="svelte-1ngenq0"&&(E.innerHTML=Rs),Rl=n(l),o(N.$$.fragment,l),Yl=n(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1r9d606"&&(v.textContent=Ys),Hl=n(l),o(S.$$.fragment,l),Ll=n(l),o(z.$$.fragment,l),Dl=n(l),X=i(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-vnm3qe"&&(X.textContent=Hs),Ol=n(l),o(k.$$.fragment,l),Pl=n(l),F=i(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(F)!=="svelte-1u2eq3s"&&(F.innerHTML=Ls),Kl=n(l),o(x.$$.fragment,l),ls=n(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1y957er"&&(_.textContent=Ds),ss=n(l),o($.$$.fragment,l),es=n(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1wjyxp5"&&(R.innerHTML=Os),ts=n(l),o(Y.$$.fragment,l),as=n(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-oq767u"&&(H.textContent=Ps),ns=n(l),o(L.$$.fragment,l),Ms=n(l),o(D.$$.fragment,l),is=n(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-y4amsa"&&(O.innerHTML=Ks),ps=n(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-vgvz2k"&&(P.innerHTML=le),ys=n(l),K=i(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-uhpw4h"&&(K.textContent=se),os=n(l),o(ll.$$.fragment,l),rs=n(l),sl=i(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-alijlj"&&(sl.textContent=ee),Us=n(l),o(el.$$.fragment,l),Js=n(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-1yo6vsj"&&(tl.innerHTML=te),js=n(l),o(al.$$.fragment,l),ms=n(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-13dikqx"&&(nl.innerHTML=ae),cs=n(l),o(Ml.$$.fragment,l),us=n(l),il=i(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-1tphwqw"&&(il.textContent=ne),Ts=n(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-3rgcl6"&&(pl.innerHTML=Me),ws=n(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-ujuql6"&&(yl.innerHTML=ie),Is=n(l),o(ol.$$.fragment,l),ds=n(l),rl=i(l,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-mw5vba"&&(rl.innerHTML=pe),hs=n(l),o(Ul.$$.fragment,l),bs=n(l),Jl=i(l,"IMG",{src:!0,alt:!0}),Cs=n(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-v54btz"&&(jl.textContent=oe),gs=n(l),o(ml.$$.fragment,l),Bs=n(l),cl=i(l,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-1gki4s6"&&(cl.innerHTML=re),fs=n(l),ul=i(l,"OL",{"data-svelte-h":!0}),p(ul)!=="svelte-khkzyp"&&(ul.innerHTML=Ue),Zs=n(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-1fawh0f"&&(Tl.innerHTML=Je),Ws=n(l),o(wl.$$.fragment,l),Gs=n(l),Il=i(l,"UL",{"data-svelte-h":!0}),p(Il)!=="svelte-2wb9vm"&&(Il.innerHTML=je),As=n(l),o(dl.$$.fragment,l),Vs=n(l),hl=i(l,"P",{"data-svelte-h":!0}),p(hl)!=="svelte-9gepeu"&&(hl.innerHTML=me),Qs=n(l),o(bl.$$.fragment,l),qs=n(l),Bl=i(l,"P",{}),ue(Bl).forEach(e),this.h()},h(){Cl(u,"name","hf:doc:metadata"),Cl(u,"content",Ze),Cl(T,"class","tip"),ce(B.src,Fs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/first_graph.png")||Cl(B,"src",Fs),Cl(B,"alt","First LangGraph"),ce(Jl.src,ye="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/mail_flow.png")||Cl(Jl,"src",ye),Cl(Jl,"alt","Mail LangGraph")},m(l,s){Ce(document.head,u),t(l,fl,s),t(l,gl,s),t(l,Zl,s),r(w,l,s),t(l,Wl,s),r(I,l,s),t(l,Gl,s),t(l,d,s),t(l,Al,s),t(l,h,s),t(l,Vl,s),t(l,b,s),t(l,Ql,s),t(l,T,s),t(l,ql,s),r(C,l,s),t(l,El,s),t(l,g,s),t(l,Nl,s),t(l,B,s),t(l,vl,s),r(f,l,s),t(l,Sl,s),t(l,Z,s),t(l,zl,s),r(W,l,s),t(l,Xl,s),t(l,G,s),t(l,kl,s),r(A,l,s),t(l,Fl,s),r(V,l,s),t(l,xl,s),t(l,Q,s),t(l,_l,s),r(q,l,s),t(l,$l,s),t(l,E,s),t(l,Rl,s),r(N,l,s),t(l,Yl,s),t(l,v,s),t(l,Hl,s),r(S,l,s),t(l,Ll,s),r(z,l,s),t(l,Dl,s),t(l,X,s),t(l,Ol,s),r(k,l,s),t(l,Pl,s),t(l,F,s),t(l,Kl,s),r(x,l,s),t(l,ls,s),t(l,_,s),t(l,ss,s),r($,l,s),t(l,es,s),t(l,R,s),t(l,ts,s),r(Y,l,s),t(l,as,s),t(l,H,s),t(l,ns,s),r(L,l,s),t(l,Ms,s),r(D,l,s),t(l,is,s),t(l,O,s),t(l,ps,s),t(l,P,s),t(l,ys,s),t(l,K,s),t(l,os,s),r(ll,l,s),t(l,rs,s),t(l,sl,s),t(l,Us,s),r(el,l,s),t(l,Js,s),t(l,tl,s),t(l,js,s),r(al,l,s),t(l,ms,s),t(l,nl,s),t(l,cs,s),r(Ml,l,s),t(l,us,s),t(l,il,s),t(l,Ts,s),t(l,pl,s),t(l,ws,s),t(l,yl,s),t(l,Is,s),r(ol,l,s),t(l,ds,s),t(l,rl,s),t(l,hs,s),r(Ul,l,s),t(l,bs,s),t(l,Jl,s),t(l,Cs,s),t(l,jl,s),t(l,gs,s),r(ml,l,s),t(l,Bs,s),t(l,cl,s),t(l,fs,s),t(l,ul,s),t(l,Zs,s),t(l,Tl,s),t(l,Ws,s),r(wl,l,s),t(l,Gs,s),t(l,Il,s),t(l,As,s),r(dl,l,s),t(l,Vs,s),t(l,hl,s),t(l,Qs,s),r(bl,l,s),t(l,qs,s),t(l,Bl,s),Es=!0},p:we,i(l){Es||(U(w.$$.fragment,l),U(I.$$.fragment,l),U(C.$$.fragment,l),U(f.$$.fragment,l),U(W.$$.fragment,l),U(A.$$.fragment,l),U(V.$$.fragment,l),U(q.$$.fragment,l),U(N.$$.fragment,l),U(S.$$.fragment,l),U(z.$$.fragment,l),U(k.$$.fragment,l),U(x.$$.fragment,l),U($.$$.fragment,l),U(Y.$$.fragment,l),U(L.$$.fragment,l),U(D.$$.fragment,l),U(ll.$$.fragment,l),U(el.$$.fragment,l),U(al.$$.fragment,l),U(Ml.$$.fragment,l),U(ol.$$.fragment,l),U(Ul.$$.fragment,l),U(ml.$$.fragment,l),U(wl.$$.fragment,l),U(dl.$$.fragment,l),U(bl.$$.fragment,l),Es=!0)},o(l){J(w.$$.fragment,l),J(I.$$.fragment,l),J(C.$$.fragment,l),J(f.$$.fragment,l),J(W.$$.fragment,l),J(A.$$.fragment,l),J(V.$$.fragment,l),J(q.$$.fragment,l),J(N.$$.fragment,l),J(S.$$.fragment,l),J(z.$$.fragment,l),J(k.$$.fragment,l),J(x.$$.fragment,l),J($.$$.fragment,l),J(Y.$$.fragment,l),J(L.$$.fragment,l),J(D.$$.fragment,l),J(ll.$$.fragment,l),J(el.$$.fragment,l),J(al.$$.fragment,l),J(Ml.$$.fragment,l),J(ol.$$.fragment,l),J(Ul.$$.fragment,l),J(ml.$$.fragment,l),J(wl.$$.fragment,l),J(dl.$$.fragment,l),J(bl.$$.fragment,l),Es=!1},d(l){l&&(e(fl),e(gl),e(Zl),e(Wl),e(Gl),e(d),e(Al),e(h),e(Vl),e(b),e(Ql),e(T),e(ql),e(El),e(g),e(Nl),e(B),e(vl),e(Sl),e(Z),e(zl),e(Xl),e(G),e(kl),e(Fl),e(xl),e(Q),e(_l),e($l),e(E),e(Rl),e(Yl),e(v),e(Hl),e(Ll),e(Dl),e(X),e(Ol),e(Pl),e(F),e(Kl),e(ls),e(_),e(ss),e(es),e(R),e(ts),e(as),e(H),e(ns),e(Ms),e(is),e(O),e(ps),e(P),e(ys),e(K),e(os),e(rs),e(sl),e(Us),e(Js),e(tl),e(js),e(ms),e(nl),e(cs),e(us),e(il),e(Ts),e(pl),e(ws),e(yl),e(Is),e(ds),e(rl),e(hs),e(bs),e(Jl),e(Cs),e(jl),e(gs),e(Bs),e(cl),e(fs),e(ul),e(Zs),e(Tl),e(Ws),e(Gs),e(Il),e(As),e(Vs),e(hl),e(Qs),e(qs),e(Bl)),e(u),j(w,l),j(I,l),j(C,l),j(f,l),j(W,l),j(A,l),j(V,l),j(q,l),j(N,l),j(S,l),j(z,l),j(k,l),j(x,l),j($,l),j(Y,l),j(L,l),j(D,l),j(ll,l),j(el,l),j(al,l),j(Ml,l),j(ol,l),j(Ul,l),j(ml,l),j(wl,l),j(dl,l),j(bl,l)}}}const Ze='{"title":"Construire votre premier LangGraph","local":"construire-votre-premier-langgraph","sections":[{"title":"Notre workflow","local":"notre-workflow","sections":[],"depth":2},{"title":"Configuration de notre environnement","local":"configuration-de-notre-environnement","sections":[],"depth":2},{"title":"Étape 1 : Définir notre état","local":"étape-1--définir-notre-état","sections":[],"depth":2},{"title":"Étape 2 : Définir nos nœuds","local":"étape-2--définir-nos-nœuds","sections":[],"depth":2},{"title":"Étape 3 : Définir notre logique de routage","local":"étape-3--définir-notre-logique-de-routage","sections":[],"depth":2},{"title":"Étape 4 : Créer le StateGraph et définir les arêtes","local":"étape-4--créer-le-stategraph-et-définir-les-arêtes","sections":[],"depth":2},{"title":"Étape 5 : Exécuter l’application","local":"étape-5--exécuter-lapplication","sections":[],"depth":2},{"title":"Étape 6 : Inspecter notre agent trieur d’email avec Langfuse 📡","local":"étape-6--inspecter-notre-agent-trieur-demail-avec-langfuse-","sections":[],"depth":2},{"title":"Visualiser notre graphe","local":"visualiser-notre-graphe","sections":[],"depth":2},{"title":"Ce que nous avons construit","local":"ce-que-nous-avons-construit","sections":[],"depth":2},{"title":"Points clés à retenir","local":"points-clés-à-retenir","sections":[],"depth":2},{"title":"Et maintenant ?","local":"et-maintenant-","sections":[],"depth":2}],"depth":1}';function We(Ns){return Ie(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends de{constructor(u){super(),he(this,u,We,fe,Te,{})}}export{Ee as component};
