import{s as Ds,a as St,n as Ps,o as Os}from"../chunks/scheduler.505acc25.js";import{S as Ks,i as en,e as i,s as n,c as u,h as ln,a as M,d as t,b as a,f as Ft,g as r,j as o,k as c,l as tn,m as s,n as J,t as U,o as p,p as T}from"../chunks/index.b1175496.js";import{C as sn,H as w}from"../chunks/Heading.988e52fa.js";import{C as y}from"../chunks/CodeBlock.ed64aebc.js";import{C as nn}from"../chunks/CourseFloatingBanner.79ef6243.js";import{E as an}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function Mn(Ht){let m,ll,Ke,tl,b,sl,v,nl,V,al,h,Et="Les agents à code sont le type d’agent par défaut dans <code>smolagents</code>. Ils génèrent des appels d’outils Python pour effectuer des actions, obtenant des représentations d’actions qui sont efficaces, expressives et précises.",il,B,Xt="Leur approche simplifiée réduit le nombre d’actions requises, simplifie les opérations complexes et permet la réutilisation de fonctions de code existantes. <code>smolagents</code> fournit un <em>framework</em> léger pour construire de tels agents en environ 1 000 lignes de code.",Ml,Z,$t=`<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png" alt="Code vs JSON Actions"/>
Graphique issu du papier <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>`,ol,j,Lt='<p>Si vous voulez en savoir plus sur pourquoi les agents à code sont efficaces, consultez <a href="https://huggingface.co/docs/smolagents/en/conceptual_guides/intro_agents#code-agents" target="_blank">ce guide</a> de la documentation smolagents.</p>',ul,A,rl,k,Rt="Dans un processus d’agent multi-étapes, le LLM écrit et exécute des actions, impliquant généralement des appels d’outils externes. Les approches traditionnelles utilisent un format JSON pour spécifier les noms d’outils et les arguments sous forme de chaînes, <strong>que le système doit analyser pour déterminer quel outil exécuter</strong>.",Jl,G,_t='Cependant, la recherche montre que <strong>les LLM d’appel d’outils fonctionnent plus efficacement avec du code directement</strong>. C’est un principe fondamental de <code>smolagents</code>, comme le montre le diagramme ci-dessus issu de <a href="https://huggingface.co/papers/2402.01030" rel="nofollow"><em>Executable Code Actions Elicit Better LLM Agents</em></a>.',Ul,Q,Yt="Écrire des actions en code plutôt qu’en JSON offre plusieurs avantages clés :",pl,N,Dt="<li><strong>Composabilité</strong> : Combiner et réutiliser facilement des actions</li> <li><strong>Gestion d’objets</strong> : Travailler directement avec des structures complexes comme des images</li> <li><strong>Généralité</strong> : Exprimer toute tâche computationnellement possible</li> <li><strong>Naturel pour les LLM</strong> : Du code de haute qualité est déjà présent dans les données d’entraînement des LLM</li>",Tl,W,cl,z,Pt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/codeagent_docs.png" alt="From https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',yl,x,Ot="Le diagramme ci-dessus illustre comment <code>CodeAgent.run()</code> fonctionne, suivant le <em>framework</em> ReAct que nous avons mentionné dans l’Unité 1. L’abstraction principale pour les agents dans <code>smolagents</code> est un <code>MultiStepAgent</code> qui sert de bloc de construction principal. Comme nous le verrons dans un exemple ci-dessous, <code>CodeAgent</code> est un type spécial de <code>MultiStepAgent</code>.",dl,q,Kt="Un <code>CodeAgent</code> effectue des actions à travers un cycle d’étapes (avec les variables existantes et les connaissances étant incorporées dans le contexte de l’agent) qui est conservé dans un journal d’exécution :",wl,S,es='<li><p>Le <em>prompt</em> système est stocké dans un <code>SystemPromptStep</code> et la requête utilisateur est enregistrée dans un <code>TaskStep</code>.</p></li> <li><p>Ensuite, la boucle <em>while</em> suivante est exécutée :</p> <p>2.1 La méthode <code>agent.write_memory_to_messages()</code> écrit les <em>logs</em> de l’agent dans une liste de <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">messages de chat</a> lisibles par le LLM.</p> <p>2.2 Ces messages sont envoyés à un <code>Model</code> qui génère une complétion.</p> <p>2.3 La complétion est analysée pour extraire l’action, qui, dans notre cas, devrait être un extrait de code puisque nous travaillons avec un <code>CodeAgent</code>.</p> <p>2.4 L’action est exécutée.</p> <p>2.5 Les résultats sont enregistrés en mémoire dans un <code>ActionStep</code>.</p></li>',ml,F,ls="À la fin de chaque étape, si l’agent inclut des appels de fonction (dans <code>agent.step_callback</code>), ils sont exécutés.",jl,H,Il,I,ts='<p>Vous pouvez suivre le code dans <a href="https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/code_agents.ipynb" target="_blank">ce <i>notebook</i></a> que vous pouvez exécuter avec Google Colab.</p>',gl,E,ss="Alfred planifie une fête au manoir de la famille Wayne et a besoin de votre aide pour s’assurer que tout se passe bien. Pour l’aider, nous appliquerons ce que nous avons appris sur le fonctionnement d’un <code>CodeAgent</code> multi-étapes.",Cl,X,ns,fl,$,as="Si vous n’avez pas encore installé <code>smolagents</code>, vous pouvez le faire en exécutant la commande suivante :",bl,L,vl,R,is="Connectons-nous également au Hub d’Hugging Face pour avoir accès à l’API d’inférence <em>Serverless</em>.",Vl,_,hl,Y,Bl,D,Ms="La musique est un élément essentiel d’une fête réussie ! Alfred a besoin d’aide pour sélectionner la <em>playlist</em>. Heureusement, <code>smolagents</code> nous couvre ! Nous pouvons construire un agent capable de rechercher sur le web en utilisant DuckDuckGo. Pour donner à l’accès à cet outil  l’agent, nous l’incluons dans la liste des outils lors de la création de l’agent.",Zl,P,os,Al,O,us='Pour le modèle, nous nous appuierons sur <code>InferenceClientModel</code>, qui fournit l’accès à l’<a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">API d’inférence Serverless</a> d’Hugging Face. Le modèle par défaut est <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>, qui est performant et disponible pour une inférence rapide, mais vous pouvez sélectionner depuis le Hub n’importe quel modèle compatible.',kl,K,rs="Exécuter un agent est assez simple :",Gl,ee,Ql,le,Js="Lorsque vous exécutez cet exemple, la sortie <strong>affichera une trace des étapes du <em>workflow</em> en cours d’exécution</strong>. Elle affichera également le code Python correspondant avec le message :",Nl,te,Wl,se,Us="Après quelques étapes, vous verrez la <em>playlist</em> générée qu’Alfred peut utiliser pour la fête ! 🎵",zl,ne,xl,ae,ps,ql,ie,Ts="Maintenant que nous avons sélectionné une <em>playlist</em>, nous devons organiser le menu pour les invités. Encore une fois, Alfred peut tirer parti de <code>smolagents</code> pour le faire. Ici, nous utilisons le décorateur <code>@tool</code> pour définir une fonction personnalisée qui agit comme un outil. Nous couvrirons la création d’outils plus en détail plus tard, donc pour l’instant, nous pouvons simplement exécuter le code.",Sl,Me,cs="Comme vous pouvez le voir dans l’exemple ci-dessous, nous allons créer un outil en utilisant le décorateur <code>@tool</code> et l’inclure dans la liste <code>tools</code>.",Fl,oe,Hl,ue,ys="L’agent s’exécutera pendant quelques étapes jusqu’à trouver la réponse. Préciser les valeurs autorisées dans la docstring aide à diriger l’agent vers les valeurs d’argument <code>occasion</code> qui existent et limite les hallucinations.",El,re,ds="Le menu est prêt ! 🥗",Xl,Je,$l,Ue,ws="Nous avons la <em>playlist</em> et le menu prêts, mais nous devons vérifier un dernier détail crucial : le temps de préparation !",Ll,pe,ms="Alfred doit calculer quand tout serait prêt s’il commençait à préparer maintenant, au cas où ils auraient besoin de l’aide d’autres super-héros.",Rl,Te,js="<code>smolagents</code> est spécialisé dans les agents qui écrivent et exécutent des extraits de code Python, offrant une exécution sécurisée.",_l,ce,Is=`En effet, <strong>l’exécution du code a des mesures de sécurité strictes</strong> : les imports en dehors d’une liste sûre prédéfinie sont bloqués par défaut. Cependant, vous pouvez autoriser des imports supplémentaires en les passant sous forme de chaînes dans <code>additional_authorized_imports</code>.
Pour plus de détails sur l’exécution sécurisée du code, consultez le <a href="https://huggingface.co/docs/smolagents/tutorials/secure_code_execution" rel="nofollow">guide</a> officiel.`,Yl,ye,gs="Lors de la création de l’agent, nous utiliserons <code>additional_authorized_imports</code> pour permettre l’importation du module <code>datetime</code>.",Dl,de,Pl,we,Cs=`Ces exemples ne sont que le début de ce que vous pouvez faire avec les agents à code, et nous commençons déjà à voir leur utilité pour préparer la fête.
Vous pouvez en apprendre davantage sur la façon de construire de tels agents dans la <a href="https://huggingface.co/docs/smolagents" rel="nofollow">documentation de <code>smolagents</code></a>.`,Ol,me,fs="En résumé, <code>smolagents</code> se spécialise dans les agents qui écrivent et exécutent des extraits de code Python, offrant une exécution sécurisée. Il supporte à la fois les modèles de langage locaux et basés sur API, le rendant adaptable à divers environnements de développement.",Kl,je,et,Ie,bs="Ne serait-il pas <strong>incroyable de partager notre propre agent Alfred avec le reste du monde</strong> ? En faisant cela, n’importe qui peut facilement télécharger et utiliser l’agent directement depuis le Hub, apportant l’ultime planificateur de fête de Gotham à portée de main ! Faisons-le ! 🎉",lt,ge,vs="La bibliothèque <code>smolagents</code> rend cela possible en vous permettant de partager un agent complet avec la communauté et de télécharger ceux des autres pour une utilisation immédiate. C’est aussi simple que ce qui suit :",tt,Ce,st,fe,Vs="Pour télécharger à nouveau l’agent, utilisez le code ci-dessous :",nt,be,at,ve,hs='Ce qui est également excitant, c’est que les agents partagés sont directement disponibles en tant que <em>Spaces</em>, vous permettant d’interagir avec eux en temps réel. Vous pouvez explorer d’autres agents <a href="https://huggingface.co/spaces/davidberenstein1957/smolagents-and-tools" rel="nofollow">ici</a>.',it,Ve,Bs='Par exemple, l’<em>AlfredAgent</em> est disponible <a href="https://huggingface.co/spaces/sergiopaniego/AlfredAgent" rel="nofollow">ici</a>. Vous pouvez l’essayer directement ci-dessous :',Mt,d,Zs,ot,he,As="Vous vous demandez peut-être comment Alfred a construit un tel agent en utilisant <code>smolagents</code> ? En intégrant plusieurs outils, il peut générer un agent comme suit. Ne vous inquiétez pas des outils pour l’instant, car nous aurons une section dédiée plus tard dans cette unité pour explorer cela en détail :",ut,Be,rt,Ze,ks="Comme vous pouvez le voir, nous avons créé un <code>CodeAgent</code> avec plusieurs outils qui améliorent la fonctionnalité de l’agent, le transformant en l’ultime planificateur de fête prêt à partager avec la communauté ! 🎉",Jt,Ae,Gs="Maintenant, c’est à votre tour : construisez votre propre agent et partagez-le avec la communauté en utilisant les connaissances que nous venons d’apprendre ! 🕵️‍♂️💡",Ut,g,Qs='<p>Si vous souhaitez partager votre projet d’agent, créez un <i>Space</i> et taguez <a href="https://huggingface.co/agents-course">agents-course</a> sur le Hub. Nous serions ravis de voir ce que vous avez créé !</p>',pt,ke,Tt,Ge,Ns="Alors qu’Alfred peaufine l’agent, il se lasse de déboguer ses exécutions. Les agents, par nature, sont imprévisibles et difficiles à inspecter. Mais comme il vise à construire l’ultime agent préparateur de fête et à le déployer en production, il a besoin d’une traçabilité robuste pour la surveillance et l’analyse futures.",ct,Qe,Ws='Encore une fois, <code>smolagents</code> vient à la rescousse ! Il adopte la norme <a href="https://opentelemetry.io/" rel="nofollow">OpenTelemetry</a> pour instrumenter les exécutions d’agents, permettant une inspection et une journalisation transparentes. Avec l’aide de <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> et du <code>SmolagentsInstrumentor</code>, Alfred peut facilement suivre et analyser le comportement de son agent.',yt,Ne,zs="La configuration est simple !",dt,We,xs="D’abord, nous devons installer les dépendances nécessaires :",wt,ze,mt,xe,qs='Ensuite, Alfred a déjà créé un compte sur Langfuse et a ses clés API prêtes. Si vous ne l’avez pas encore fait, vous pouvez vous inscrire à Langfuse Cloud <a href="https://cloud.langfuse.com/" rel="nofollow">ici</a> ou explorer des <a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">alternatives</a>.',jt,qe,Ss="Une fois que vous avez vos clés API, elles doivent être correctement configurées comme suit :",It,Se,gt,Fe,Fs="Avec les variables d’environnement définies, nous pouvons maintenant initialiser le client Langfuse. <code>get_client()</code> initialise le client Langfuse en utilisant les identifiants fournis dans les variables d’environnement.",Ct,He,ft,Ee,Hs="Enfin, Alfred est prêt à initialiser le <code>SmolagentsInstrumentor</code> et commencer à suivre les performances de son agent.",bt,Xe,vt,$e,Es="Alfred est maintenant connecté 🔌 ! Les exécutions de <code>smolagents</code> sont enregistrées dans Langfuse, lui donnant une visibilité complète sur le comportement de l’agent. Avec cette configuration, il est prêt à revisiter les exécutions précédentes et à affiner encore plus son agent préparateur de fête.",Vt,C,Xs='<p>Pour en savoir plus sur le traçage de vos agents et l’utilisation des données collectées pour évaluer leurs performances, consultez <a href="https://huggingface.co/learn/agents-course/fr/bonus-unit2/introduction">l’Unité Bonus 2</a>.</p>',ht,Le,Bt,Re,$s='Alfred peut maintenant accéder aux logs <a href="https://cloud.langfuse.com/project/cm7bq0abj025rad078ak3luwi/traces/995fc019255528e4f48cf6770b0ce27b?timestamp=2025-02-19T10%3A28%3A36.929Z" rel="nofollow">ici</a> pour les relire et les analyser.',Zt,f,Ls='<p>En fait, une erreur mineure s’est produite lors de l’exécution. Pouvez-vous la repérer dans les logs ? Essayez de suivre comment l’agent la gère et renvoie quand même une réponse valide. <a href="https://cloud.langfuse.com/project/cm7bq0abj025rad078ak3luwi/traces/995fc019255528e4f48cf6770b0ce27b?timestamp=2025-02-19T10%3A28%3A36.929Z&amp;observation=80ca57ace4f69b52">Voici</a> le lien direct vers l’erreur si vous voulez vérifier votre réponse. Bien sûr, l’erreur a été corrigée entre-temps, plus de détails peuvent être trouvés dans cette <a href="https://github.com/huggingface/smolagents/issues/838"><i>issue</i></a>.</p>',At,_e,Rs='Pendant ce temps, la <a href="https://open.spotify.com/playlist/0gZMMHjuxMrrybQ7wTMTpw" rel="nofollow"><em>playlist</em> suggérée</a> crée l’ambiance parfaite pour les préparatifs de la fête. Cool, non ? 🎶',kt,Gt,Qt,Ye,_s="Maintenant que nous avons créé notre premier <em>Code Agent</em>, <strong>apprenons comment nous pouvons créer des <em>Tool Calling Agents</em></strong>, le deuxième type d’agent disponible dans <code>smolagents</code>.",Nt,De,Wt,Pe,Ys='<li><a href="https://huggingface.co/blog/smolagents" rel="nofollow">Blog smolagents</a> - Introduction à smolagents et aux interactions de code</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">smolagents : Construire de bons agents</a> - Meilleures pratiques pour des agents fiables</li> <li><a href="https://www.anthropic.com/research/building-effective-agents" rel="nofollow">Construire des agents efficaces - Anthropic</a> - Principes de conception d’agents</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">Partager des exécutions avec OpenTelemetry</a> - Détails sur la façon de configurer OpenTelemetry pour suivre vos agents.</li>',zt,Oe,xt,el,qt;return b=new nn({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/fr/unit2/smolagents/code_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),v=new sn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),V=new w({props:{title:"Construire des agents qui utilisent du code",local:"construire-des-agents-qui-utilisent-du-code",headingTag:"h1"}}),A=new w({props:{title:"Pourquoi les agents à code ?",local:"pourquoi-les-agents-à-code-",headingTag:"h2"}}),W=new w({props:{title:"Comment fonctionne un agent à code ?",local:"comment-fonctionne-un-agent-à-code-",headingTag:"h2"}}),H=new w({props:{title:"Voyons quelques exemples",local:"voyons-quelques-exemples",headingTag:"h2"}}),L=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjAtVQ==",highlighted:"pip install smolagents -U",wrap:!1}}),_=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()`,wrap:!1}}),Y=new w({props:{title:"Sélectionner une playlist pour la fête en utilisant smolagents",local:"sélectionner-une-playlist-pour-la-fête-en-utilisant-smolagents",headingTag:"h3"}}),ee=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJSZWNoZXJjaGUlMjBsZXMlMjBtZWlsbGV1cmVzJTIwcmVjb21tYW5kYXRpb25zJTIwbXVzaWNhbGVzJTIwcG91ciUyMHVuZSUyMGYlQzMlQUF0ZSUyMGF1JTIwbWFub2lyJTIwZGVzJTIwV2F5bmUuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel

agent = CodeAgent(tools=[DuckDuckGoSearchTool()], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Recherche les meilleures recommandations musicales pour une fête au manoir des Wayne.&quot;</span>)`,wrap:!1}}),te=new y({props:{code:"JTIwJUUyJTk0JTgwJTIwRXhlY3V0aW5nJTIwcGFyc2VkJTIwY29kZSUzQSUyMCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCUyMCUwQSUyMCUyMHJlc3VsdHMlMjAlM0QlMjB3ZWJfc2VhcmNoKHF1ZXJ5JTNEJTIyYmVzdCUyMG11c2ljJTIwZm9yJTIwYSUyMEJhdG1hbiUyMHBhcnR5JTIyKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMHByaW50KHJlc3VsdHMpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJTIw",highlighted:` ─ Executing parsed code: ──────────────────────────────────────────────────────────────────────────────────────── 
  results = web_search(query=<span class="hljs-string">&quot;best music for a Batman party&quot;</span>)                                                      
  <span class="hljs-built_in">print</span>(results)                                                                                                   
 ───────────────────────────────────────────────────────────────────────────────────────────────────────────────── `,wrap:!1}}),ne=new w({props:{title:"Utiliser un outil personnalisé pour préparer le menu",local:"utiliser-un-outil-personnalisé-pour-préparer-le-menu",headingTag:"h3"}}),oe=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, tool, InferenceClientModel

<span class="hljs-comment"># Outil pour suggérer un menu basé sur l&#x27;occasion</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggère un menu basé sur l&#x27;occasion.
    Args:
        occasion (str): Le type d&#x27;occasion pour la fête. Les valeurs autorisées sont :
                        - &quot;casual&quot;: Menu pour une fête décontractée.
                        - &quot;formal&quot;: Menu pour une fête formelle.
                        - &quot;superhero&quot;: Menu pour une fête de super-héros.
                        - &quot;custom&quot;: Menu personnalisé.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, collations et boissons.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Dîner 3 services avec vin et dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet avec nourriture énergétique et saine.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Menu personnalisé pour le majordome.&quot;</span>

<span class="hljs-comment"># Alfred, le majordome, préparant le menu pour la fête</span>
agent = CodeAgent(tools=[suggest_menu], model=InferenceClientModel())

<span class="hljs-comment"># Préparer le menu pour la fête</span>
agent.run(<span class="hljs-string">&quot;Prépare un menu formel pour la fête.&quot;</span>)`,wrap:!1}}),Je=new w({props:{title:"Utiliser des imports Python à l’intérieur de l’agent",local:"utiliser-des-imports-python-à-lintérieur-de-lagent",headingTag:"h3"}}),de=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRpbWUlMEFpbXBvcnQlMjBkYXRldGltZSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUInZGF0ZXRpbWUnJTVEKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBbGZyZWQlMjBkb2l0JTIwc2UlMjBwciVDMyVBOXBhcmVyJTIwcG91ciUyMGxhJTIwZiVDMyVBQXRlLiUyMFZvaWNpJTIwbGVzJTIwdCVDMyVBMmNoZXMlMjAlM0ElMEElMjAlMjAlMjAlMjAxLiUyMFByJUMzJUE5cGFyZXIlMjBsZXMlMjBib2lzc29ucyUyMC0lMjAzMCUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjAyLiUyMEQlQzMlQTljb3JlciUyMGxlJTIwbWFub2lyJTIwLSUyMDYwJTIwbWludXRlcyUwQSUyMCUyMCUyMCUyMDMuJTIwTWV0dHJlJTIwZW4lMjBwbGFjZSUyMGxlJTIwbWVudSUyMC0lMjA0NSUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjA0LiUyMFByJUMzJUE5cGFyZXIlMjBsYSUyMG11c2lxdWUlMjBldCUyMGxhJTIwcGxheWxpc3QlMjAtJTIwNDUlMjBtaW51dGVzJTBBJTBBJTIwJTIwJTIwJTIwU2klMjBub3VzJTIwY29tbWVuJUMzJUE3b25zJTIwbWFpbnRlbmFudCUyQyUyMCVDMyVBMCUyMHF1ZWxsZSUyMGhldXJlJTIwbGElMjBmJUMzJUFBdGUlMjBzZXJhLXQtZWxsZSUyMHByJUMzJUFBdGUlMjAlM0YlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> datetime

agent = CodeAgent(tools=[], model=InferenceClientModel(), additional_authorized_imports=[<span class="hljs-string">&#x27;datetime&#x27;</span>])

agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Alfred doit se préparer pour la fête. Voici les tâches :
    1. Préparer les boissons - 30 minutes
    2. Décorer le manoir - 60 minutes
    3. Mettre en place le menu - 45 minutes
    4. Préparer la musique et la playlist - 45 minutes

    Si nous commençons maintenant, à quelle heure la fête sera-t-elle prête ?
    &quot;&quot;&quot;</span>
)`,wrap:!1}}),je=new w({props:{title:"Partager notre agent préparateur de fête personnalisé sur le Hub",local:"partager-notre-agent-préparateur-de-fête-personnalisé-sur-le-hub",headingTag:"h3"}}),Ce=new y({props:{code:"JTIzJTIwQ2hhbmdleiUyMHBvdXIlMjB2b3RyZSUyMG5vbSUyMGQndXRpbGlzYXRldXIlMjBldCUyMG5vbSUyMGRlJTIwZCVDMyVBOXAlQzMlQjR0JTBBYWdlbnQucHVzaF90b19odWIoJ3Nlcmdpb3BhbmllZ28lMkZBbGZyZWRBZ2VudCcp",highlighted:`<span class="hljs-comment"># Changez pour votre nom d&#x27;utilisateur et nom de dépôt</span>
agent.push_to_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>)`,wrap:!1}}),be=new y({props:{code:"JTIzJTIwQ2hhbmdleiUyMHBvdXIlMjB2b3RyZSUyMG5vbSUyMGQndXRpbGlzYXRldXIlMjBldCUyMG5vbSUyMGRlJTIwZCVDMyVBOXAlQzMlQjR0JTBBYWxmcmVkX2FnZW50JTIwJTNEJTIwYWdlbnQuZnJvbV9odWIoJ3Nlcmdpb3BhbmllZ28lMkZBbGZyZWRBZ2VudCclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBJTBBYWxmcmVkX2FnZW50LnJ1biglMjJEb25uZS1tb2klMjBsYSUyMG1laWxsZXVyZSUyMHBsYXlsaXN0JTIwcG91ciUyMHVuZSUyMGYlQzMlQUF0ZSUyMGF1JTIwbWFub2lyJTIwZGVzJTIwV2F5bmUuJTIwTCdpZCVDMyVBOWUlMjBkZSUyMGxhJTIwZiVDMyVBQXRlJTIwZXN0JTIwdW4lMjB0aCVDMyVBOG1lJTIwJ21hc2NhcmFkZSUyMGRlJTIwbSVDMyVBOWNoYW50cyclMjIpJTIwJTIw",highlighted:`<span class="hljs-comment"># Changez pour votre nom d&#x27;utilisateur et nom de dépôt</span>
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

alfred_agent.run(<span class="hljs-string">&quot;Donne-moi la meilleure playlist pour une fête au manoir des Wayne. L&#x27;idée de la fête est un thème &#x27;mascarade de méchants&#x27;&quot;</span>)  `,wrap:!1}}),Be=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, InferenceClientModel, Tool, tool, VisitWebpageTool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggère un menu basé sur l&#x27;occasion.
    Args:
        occasion: Le type d&#x27;occasion pour la fête.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, collations et boissons.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Dîner 3 services avec vin et dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet avec nourriture énergétique et saine.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Menu personnalisé pour le majordome.&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Cet outil renvoie le service de restauration le mieux noté à Gotham City.
    
    Args:
        query: Un terme de recherche pour trouver des services de restauration.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Exemple de liste de services de restauration et leurs notes</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }
    
    <span class="hljs-comment"># Trouver le service de restauration le mieux noté (simuler le filtrage de requête de recherche)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)
    
    <span class="hljs-keyword">return</span> best_service

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    Cet outil suggère des idées créatives de fête sur le thème des super-héros basées sur une catégorie.
    Il renvoie une idée de thème de fête unique.&quot;&quot;&quot;</span>
    
    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Le type de fête de super-héros (par ex., &#x27;héros classiques&#x27;, &#x27;mascarade de méchants&#x27;, &#x27;Gotham futuriste&#x27;).&quot;</span>,
        }
    }
    
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Gala de la Justice League : Les invités viennent habillés comme leurs héros DC préférés avec des cocktails thématiques comme &#x27;Le Punch Kryptonite&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Bal des Voyous de Gotham : Une mascarade mystérieuse où les invités s&#x27;habillent en méchants classiques de Batman.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Nuit Neo-Gotham : Une fête de style cyberpunk inspirée de Batman Beyond, avec des décorations néon et des gadgets futuristes.&quot;</span>
        }
        
        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Idée de fête thématique non trouvée. Essayez &#x27;héros classiques&#x27;, &#x27;mascarade de méchants&#x27;, ou &#x27;Gotham futuriste&#x27;.&quot;</span>)


<span class="hljs-comment"># Alfred, le majordome, préparant le menu pour la fête</span>
agent = CodeAgent(
    tools=[
        DuckDuckGoSearchTool(), 
        VisitWebpageTool(),
        suggest_menu,
        catering_service_tool,
        SuperheroPartyThemeTool(),
	FinalAnswerTool()
    ], 
    model=InferenceClientModel(),
    max_steps=<span class="hljs-number">10</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

agent.run(<span class="hljs-string">&quot;Donne-moi la meilleure playlist pour une fête au manoir des Wayne. L&#x27;idée de la fête est un thème &#x27;mascarade de méchants&#x27;&quot;</span>)`,wrap:!1}}),ke=new w({props:{title:"Inspecter notre agent préparateur de fête avec OpenTelemetry et Langfuse 📡",local:"inspecter-notre-agent-préparateur-de-fête-avec-opentelemetry-et-langfuse-",headingTag:"h3"}}),ze=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wZW50ZWxlbWV0cnktc2RrJTIwb3BlbnRlbGVtZXRyeS1leHBvcnRlci1vdGxwJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cyUyMGxhbmdmdXNl",highlighted:"pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents langfuse",wrap:!1}}),Se=new y({props:{code:"aW1wb3J0JTIwb3MlMEElMEElMjMlMjBPYnRlbmV6JTIwbGVzJTIwY2wlQzMlQTlzJTIwcG91ciUyMHZvdHJlJTIwcHJvamV0JTIwZGVwdWlzJTIwbGElMjBwYWdlJTIwZGVzJTIwcGFyYW0lQzMlQTh0cmVzJTIwZHUlMjBwcm9qZXQlMjAlM0ElMjBodHRwcyUzQSUyRiUyRmNsb3VkLmxhbmdmdXNlLmNvbSUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9QVUJMSUNfS0VZJTIyJTVEJTIwJTNEJTIwJTIycGstbGYtLi4uJTIyJTIwJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1NFQ1JFVF9LRVklMjIlNUQlMjAlM0QlMjAlMjJzay1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfSE9TVCUyMiU1RCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTIyJTIwJTIzJTIwJUYwJTlGJTg3JUFBJUYwJTlGJTg3JUJBJTIwUiVDMyVBOWdpb24lMjBVRSUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBSJUMzJUE5Z2lvbiUyMFVT",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Obtenez les clés pour votre projet depuis la page des paramètres du projet : https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 Région UE</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 Région US</span>`,wrap:!1}}),He=new y({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwViVDMyVBOXJpZmllciUyMGxhJTIwY29ubmV4aW9uJTBBaWYlMjBsYW5nZnVzZS5hdXRoX2NoZWNrKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJMZSUyMGNsaWVudCUyMExhbmdmdXNlJTIwZXN0JTIwYXV0aGVudGlmaSVDMyVBOSUyMGV0JTIwcHIlQzMlQUF0JTIwISUyMiklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTCdhdXRoZW50aWZpY2F0aW9uJTIwYSUyMCVDMyVBOWNob3UlQzMlQTkuJTIwVmV1aWxsZXolMjB2JUMzJUE5cmlmaWVyJTIwdm9zJTIwaWRlbnRpZmlhbnRzJTIwZXQlMjBsJ2glQzMlQjR0ZS4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Vérifier la connexion</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Le client Langfuse est authentifié et prêt !&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L&#x27;authentification a échoué. Veuillez vérifier vos identifiants et l&#x27;hôte.&quot;</span>)`,wrap:!1}}),Xe=new y({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor

SmolagentsInstrumentor().instrument()`,wrap:!1}}),Le=new y({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQWFsZnJlZF9hZ2VudCUyMCUzRCUyMGFnZW50LmZyb21faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWFsZnJlZF9hZ2VudC5ydW4oJTIyRG9ubmUtbW9pJTIwbGElMjBtZWlsbGV1cmUlMjBwbGF5bGlzdCUyMHBvdXIlMjB1bmUlMjBmJUMzJUFBdGUlMjBhdSUyMG1hbm9pciUyMGRlcyUyMFdheW5lLiUyMEwnaWQlQzMlQTllJTIwZGUlMjBsYSUyMGYlQzMlQUF0ZSUyMGVzdCUyMHVuJTIwdGglQzMlQThtZSUyMCdtYXNjYXJhZGUlMjBkZSUyMG0lQzMlQTljaGFudHMnJTIyKSUyMCUyMA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(tools=[], model=InferenceClientModel())
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
alfred_agent.run(<span class="hljs-string">&quot;Donne-moi la meilleure playlist pour une fête au manoir des Wayne. L&#x27;idée de la fête est un thème &#x27;mascarade de méchants&#x27;&quot;</span>)  `,wrap:!1}}),De=new w({props:{title:"Ressources",local:"ressources",headingTag:"h2"}}),Oe=new an({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/smolagents/code_agents.mdx"}}),{c(){m=i("meta"),ll=n(),Ke=i("p"),tl=n(),u(b.$$.fragment),sl=n(),u(v.$$.fragment),nl=n(),u(V.$$.fragment),al=n(),h=i("p"),h.innerHTML=Et,il=n(),B=i("p"),B.innerHTML=Xt,Ml=n(),Z=i("p"),Z.innerHTML=$t,ol=n(),j=i("blockquote"),j.innerHTML=Lt,ul=n(),u(A.$$.fragment),rl=n(),k=i("p"),k.innerHTML=Rt,Jl=n(),G=i("p"),G.innerHTML=_t,Ul=n(),Q=i("p"),Q.textContent=Yt,pl=n(),N=i("ul"),N.innerHTML=Dt,Tl=n(),u(W.$$.fragment),cl=n(),z=i("p"),z.innerHTML=Pt,yl=n(),x=i("p"),x.innerHTML=Ot,dl=n(),q=i("p"),q.innerHTML=Kt,wl=n(),S=i("ol"),S.innerHTML=es,ml=n(),F=i("p"),F.innerHTML=ls,jl=n(),u(H.$$.fragment),Il=n(),I=i("blockquote"),I.innerHTML=ts,gl=n(),E=i("p"),E.innerHTML=ss,Cl=n(),X=i("img"),fl=n(),$=i("p"),$.innerHTML=as,bl=n(),u(L.$$.fragment),vl=n(),R=i("p"),R.innerHTML=is,Vl=n(),u(_.$$.fragment),hl=n(),u(Y.$$.fragment),Bl=n(),D=i("p"),D.innerHTML=Ms,Zl=n(),P=i("img"),Al=n(),O=i("p"),O.innerHTML=us,kl=n(),K=i("p"),K.textContent=rs,Gl=n(),u(ee.$$.fragment),Ql=n(),le=i("p"),le.innerHTML=Js,Nl=n(),u(te.$$.fragment),Wl=n(),se=i("p"),se.innerHTML=Us,zl=n(),u(ne.$$.fragment),xl=n(),ae=i("img"),ql=n(),ie=i("p"),ie.innerHTML=Ts,Sl=n(),Me=i("p"),Me.innerHTML=cs,Fl=n(),u(oe.$$.fragment),Hl=n(),ue=i("p"),ue.innerHTML=ys,El=n(),re=i("p"),re.textContent=ds,Xl=n(),u(Je.$$.fragment),$l=n(),Ue=i("p"),Ue.innerHTML=ws,Ll=n(),pe=i("p"),pe.textContent=ms,Rl=n(),Te=i("p"),Te.innerHTML=js,_l=n(),ce=i("p"),ce.innerHTML=Is,Yl=n(),ye=i("p"),ye.innerHTML=gs,Dl=n(),u(de.$$.fragment),Pl=n(),we=i("p"),we.innerHTML=Cs,Ol=n(),me=i("p"),me.innerHTML=fs,Kl=n(),u(je.$$.fragment),et=n(),Ie=i("p"),Ie.innerHTML=bs,lt=n(),ge=i("p"),ge.innerHTML=vs,tt=n(),u(Ce.$$.fragment),st=n(),fe=i("p"),fe.textContent=Vs,nt=n(),u(be.$$.fragment),at=n(),ve=i("p"),ve.innerHTML=hs,it=n(),Ve=i("p"),Ve.innerHTML=Bs,Mt=n(),d=i("iframe"),ot=n(),he=i("p"),he.innerHTML=As,ut=n(),u(Be.$$.fragment),rt=n(),Ze=i("p"),Ze.innerHTML=ks,Jt=n(),Ae=i("p"),Ae.textContent=Gs,Ut=n(),g=i("blockquote"),g.innerHTML=Qs,pt=n(),u(ke.$$.fragment),Tt=n(),Ge=i("p"),Ge.textContent=Ns,ct=n(),Qe=i("p"),Qe.innerHTML=Ws,yt=n(),Ne=i("p"),Ne.textContent=zs,dt=n(),We=i("p"),We.textContent=xs,wt=n(),u(ze.$$.fragment),mt=n(),xe=i("p"),xe.innerHTML=qs,jt=n(),qe=i("p"),qe.textContent=Ss,It=n(),u(Se.$$.fragment),gt=n(),Fe=i("p"),Fe.innerHTML=Fs,Ct=n(),u(He.$$.fragment),ft=n(),Ee=i("p"),Ee.innerHTML=Hs,bt=n(),u(Xe.$$.fragment),vt=n(),$e=i("p"),$e.innerHTML=Es,Vt=n(),C=i("blockquote"),C.innerHTML=Xs,ht=n(),u(Le.$$.fragment),Bt=n(),Re=i("p"),Re.innerHTML=$s,Zt=n(),f=i("blockquote"),f.innerHTML=Ls,At=n(),_e=i("p"),_e.innerHTML=Rs,kt=n(),Gt=i("hr"),Qt=n(),Ye=i("p"),Ye.innerHTML=_s,Nt=n(),u(De.$$.fragment),Wt=n(),Pe=i("ul"),Pe.innerHTML=Ys,zt=n(),u(Oe.$$.fragment),xt=n(),el=i("p"),this.h()},l(e){const l=ln("svelte-u9bgzb",document.head);m=M(l,"META",{name:!0,content:!0}),l.forEach(t),ll=a(e),Ke=M(e,"P",{}),Ft(Ke).forEach(t),tl=a(e),r(b.$$.fragment,e),sl=a(e),r(v.$$.fragment,e),nl=a(e),r(V.$$.fragment,e),al=a(e),h=M(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-w14gwc"&&(h.innerHTML=Et),il=a(e),B=M(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1w7tdn8"&&(B.innerHTML=Xt),Ml=a(e),Z=M(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-104mgp5"&&(Z.innerHTML=$t),ol=a(e),j=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-ojur7l"&&(j.innerHTML=Lt),ul=a(e),r(A.$$.fragment,e),rl=a(e),k=M(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-tfi5uw"&&(k.innerHTML=Rt),Jl=a(e),G=M(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1j1nox0"&&(G.innerHTML=_t),Ul=a(e),Q=M(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-pyefm3"&&(Q.textContent=Yt),pl=a(e),N=M(e,"UL",{"data-svelte-h":!0}),o(N)!=="svelte-ljzzvy"&&(N.innerHTML=Dt),Tl=a(e),r(W.$$.fragment,e),cl=a(e),z=M(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-2i0rf5"&&(z.innerHTML=Pt),yl=a(e),x=M(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-31rm5i"&&(x.innerHTML=Ot),dl=a(e),q=M(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-e2xwrt"&&(q.innerHTML=Kt),wl=a(e),S=M(e,"OL",{"data-svelte-h":!0}),o(S)!=="svelte-8653na"&&(S.innerHTML=es),ml=a(e),F=M(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-ke17x7"&&(F.innerHTML=ls),jl=a(e),r(H.$$.fragment,e),Il=a(e),I=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-v9dbhk"&&(I.innerHTML=ts),gl=a(e),E=M(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-hlzj5i"&&(E.innerHTML=ss),Cl=a(e),X=M(e,"IMG",{src:!0,alt:!0}),fl=a(e),$=M(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-in86n6"&&($.innerHTML=as),bl=a(e),r(L.$$.fragment,e),vl=a(e),R=M(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-i1q2eb"&&(R.innerHTML=is),Vl=a(e),r(_.$$.fragment,e),hl=a(e),r(Y.$$.fragment,e),Bl=a(e),D=M(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-nbv8of"&&(D.innerHTML=Ms),Zl=a(e),P=M(e,"IMG",{src:!0,alt:!0}),Al=a(e),O=M(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-ros972"&&(O.innerHTML=us),kl=a(e),K=M(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-10dimdp"&&(K.textContent=rs),Gl=a(e),r(ee.$$.fragment,e),Ql=a(e),le=M(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1je39e0"&&(le.innerHTML=Js),Nl=a(e),r(te.$$.fragment,e),Wl=a(e),se=M(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-q8z4id"&&(se.innerHTML=Us),zl=a(e),r(ne.$$.fragment,e),xl=a(e),ae=M(e,"IMG",{src:!0,alt:!0}),ql=a(e),ie=M(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-19rnwld"&&(ie.innerHTML=Ts),Sl=a(e),Me=M(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1odaua3"&&(Me.innerHTML=cs),Fl=a(e),r(oe.$$.fragment,e),Hl=a(e),ue=M(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-vb5vfu"&&(ue.innerHTML=ys),El=a(e),re=M(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-soaq08"&&(re.textContent=ds),Xl=a(e),r(Je.$$.fragment,e),$l=a(e),Ue=M(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-h0ap13"&&(Ue.innerHTML=ws),Ll=a(e),pe=M(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-176qcik"&&(pe.textContent=ms),Rl=a(e),Te=M(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1nbkqdp"&&(Te.innerHTML=js),_l=a(e),ce=M(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-4dnuda"&&(ce.innerHTML=Is),Yl=a(e),ye=M(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-93tlx9"&&(ye.innerHTML=gs),Dl=a(e),r(de.$$.fragment,e),Pl=a(e),we=M(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-g6rq43"&&(we.innerHTML=Cs),Ol=a(e),me=M(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1ypso5j"&&(me.innerHTML=fs),Kl=a(e),r(je.$$.fragment,e),et=a(e),Ie=M(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-oq2swv"&&(Ie.innerHTML=bs),lt=a(e),ge=M(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-ad9apm"&&(ge.innerHTML=vs),tt=a(e),r(Ce.$$.fragment,e),st=a(e),fe=M(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1qfppzv"&&(fe.textContent=Vs),nt=a(e),r(be.$$.fragment,e),at=a(e),ve=M(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1h3kncv"&&(ve.innerHTML=hs),it=a(e),Ve=M(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-bhiihf"&&(Ve.innerHTML=Bs),Mt=a(e),d=M(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ft(d).forEach(t),ot=a(e),he=M(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-u5okdk"&&(he.innerHTML=As),ut=a(e),r(Be.$$.fragment,e),rt=a(e),Ze=M(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1u3udsr"&&(Ze.innerHTML=ks),Jt=a(e),Ae=M(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1n74e31"&&(Ae.textContent=Gs),Ut=a(e),g=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-xvemed"&&(g.innerHTML=Qs),pt=a(e),r(ke.$$.fragment,e),Tt=a(e),Ge=M(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-5ucj7u"&&(Ge.textContent=Ns),ct=a(e),Qe=M(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-th4cqd"&&(Qe.innerHTML=Ws),yt=a(e),Ne=M(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1kqsety"&&(Ne.textContent=zs),dt=a(e),We=M(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1vyo3dy"&&(We.textContent=xs),wt=a(e),r(ze.$$.fragment,e),mt=a(e),xe=M(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-tiqfgb"&&(xe.innerHTML=qs),jt=a(e),qe=M(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1u3cp6e"&&(qe.textContent=Ss),It=a(e),r(Se.$$.fragment,e),gt=a(e),Fe=M(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-163dki2"&&(Fe.innerHTML=Fs),Ct=a(e),r(He.$$.fragment,e),ft=a(e),Ee=M(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-n7e0p9"&&(Ee.innerHTML=Hs),bt=a(e),r(Xe.$$.fragment,e),vt=a(e),$e=M(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1yvulo5"&&($e.innerHTML=Es),Vt=a(e),C=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1ln306s"&&(C.innerHTML=Xs),ht=a(e),r(Le.$$.fragment,e),Bt=a(e),Re=M(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1mgyxy6"&&(Re.innerHTML=$s),Zt=a(e),f=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-e6pw4i"&&(f.innerHTML=Ls),At=a(e),_e=M(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1k95rqr"&&(_e.innerHTML=Rs),kt=a(e),Gt=M(e,"HR",{}),Qt=a(e),Ye=M(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-e10mys"&&(Ye.innerHTML=_s),Nt=a(e),r(De.$$.fragment,e),Wt=a(e),Pe=M(e,"UL",{"data-svelte-h":!0}),o(Pe)!=="svelte-92ndd0"&&(Pe.innerHTML=Ys),zt=a(e),r(Oe.$$.fragment,e),xt=a(e),el=M(e,"P",{}),Ft(el).forEach(t),this.h()},h(){c(m,"name","hf:doc:metadata"),c(m,"content",on),c(j,"class","tip"),c(I,"class","tip"),St(X.src,ns="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-party.jpg")||c(X,"src",ns),c(X,"alt","Alfred Party"),St(P.src,os="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-playlist.jpg")||c(P,"src",os),c(P,"alt","Alfred Playlist"),St(ae.src,ps="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-menu.jpg")||c(ae,"src",ps),c(ae,"alt","Alfred Menu"),St(d.src,Zs="https://sergiopaniego-alfredagent.hf.space/")||c(d,"src",Zs),c(d,"frameborder","0"),c(d,"width","850"),c(d,"height","450"),c(g,"class","tip"),c(C,"class","tip"),c(f,"class","tip")},m(e,l){tn(document.head,m),s(e,ll,l),s(e,Ke,l),s(e,tl,l),J(b,e,l),s(e,sl,l),J(v,e,l),s(e,nl,l),J(V,e,l),s(e,al,l),s(e,h,l),s(e,il,l),s(e,B,l),s(e,Ml,l),s(e,Z,l),s(e,ol,l),s(e,j,l),s(e,ul,l),J(A,e,l),s(e,rl,l),s(e,k,l),s(e,Jl,l),s(e,G,l),s(e,Ul,l),s(e,Q,l),s(e,pl,l),s(e,N,l),s(e,Tl,l),J(W,e,l),s(e,cl,l),s(e,z,l),s(e,yl,l),s(e,x,l),s(e,dl,l),s(e,q,l),s(e,wl,l),s(e,S,l),s(e,ml,l),s(e,F,l),s(e,jl,l),J(H,e,l),s(e,Il,l),s(e,I,l),s(e,gl,l),s(e,E,l),s(e,Cl,l),s(e,X,l),s(e,fl,l),s(e,$,l),s(e,bl,l),J(L,e,l),s(e,vl,l),s(e,R,l),s(e,Vl,l),J(_,e,l),s(e,hl,l),J(Y,e,l),s(e,Bl,l),s(e,D,l),s(e,Zl,l),s(e,P,l),s(e,Al,l),s(e,O,l),s(e,kl,l),s(e,K,l),s(e,Gl,l),J(ee,e,l),s(e,Ql,l),s(e,le,l),s(e,Nl,l),J(te,e,l),s(e,Wl,l),s(e,se,l),s(e,zl,l),J(ne,e,l),s(e,xl,l),s(e,ae,l),s(e,ql,l),s(e,ie,l),s(e,Sl,l),s(e,Me,l),s(e,Fl,l),J(oe,e,l),s(e,Hl,l),s(e,ue,l),s(e,El,l),s(e,re,l),s(e,Xl,l),J(Je,e,l),s(e,$l,l),s(e,Ue,l),s(e,Ll,l),s(e,pe,l),s(e,Rl,l),s(e,Te,l),s(e,_l,l),s(e,ce,l),s(e,Yl,l),s(e,ye,l),s(e,Dl,l),J(de,e,l),s(e,Pl,l),s(e,we,l),s(e,Ol,l),s(e,me,l),s(e,Kl,l),J(je,e,l),s(e,et,l),s(e,Ie,l),s(e,lt,l),s(e,ge,l),s(e,tt,l),J(Ce,e,l),s(e,st,l),s(e,fe,l),s(e,nt,l),J(be,e,l),s(e,at,l),s(e,ve,l),s(e,it,l),s(e,Ve,l),s(e,Mt,l),s(e,d,l),s(e,ot,l),s(e,he,l),s(e,ut,l),J(Be,e,l),s(e,rt,l),s(e,Ze,l),s(e,Jt,l),s(e,Ae,l),s(e,Ut,l),s(e,g,l),s(e,pt,l),J(ke,e,l),s(e,Tt,l),s(e,Ge,l),s(e,ct,l),s(e,Qe,l),s(e,yt,l),s(e,Ne,l),s(e,dt,l),s(e,We,l),s(e,wt,l),J(ze,e,l),s(e,mt,l),s(e,xe,l),s(e,jt,l),s(e,qe,l),s(e,It,l),J(Se,e,l),s(e,gt,l),s(e,Fe,l),s(e,Ct,l),J(He,e,l),s(e,ft,l),s(e,Ee,l),s(e,bt,l),J(Xe,e,l),s(e,vt,l),s(e,$e,l),s(e,Vt,l),s(e,C,l),s(e,ht,l),J(Le,e,l),s(e,Bt,l),s(e,Re,l),s(e,Zt,l),s(e,f,l),s(e,At,l),s(e,_e,l),s(e,kt,l),s(e,Gt,l),s(e,Qt,l),s(e,Ye,l),s(e,Nt,l),J(De,e,l),s(e,Wt,l),s(e,Pe,l),s(e,zt,l),J(Oe,e,l),s(e,xt,l),s(e,el,l),qt=!0},p:Ps,i(e){qt||(U(b.$$.fragment,e),U(v.$$.fragment,e),U(V.$$.fragment,e),U(A.$$.fragment,e),U(W.$$.fragment,e),U(H.$$.fragment,e),U(L.$$.fragment,e),U(_.$$.fragment,e),U(Y.$$.fragment,e),U(ee.$$.fragment,e),U(te.$$.fragment,e),U(ne.$$.fragment,e),U(oe.$$.fragment,e),U(Je.$$.fragment,e),U(de.$$.fragment,e),U(je.$$.fragment,e),U(Ce.$$.fragment,e),U(be.$$.fragment,e),U(Be.$$.fragment,e),U(ke.$$.fragment,e),U(ze.$$.fragment,e),U(Se.$$.fragment,e),U(He.$$.fragment,e),U(Xe.$$.fragment,e),U(Le.$$.fragment,e),U(De.$$.fragment,e),U(Oe.$$.fragment,e),qt=!0)},o(e){p(b.$$.fragment,e),p(v.$$.fragment,e),p(V.$$.fragment,e),p(A.$$.fragment,e),p(W.$$.fragment,e),p(H.$$.fragment,e),p(L.$$.fragment,e),p(_.$$.fragment,e),p(Y.$$.fragment,e),p(ee.$$.fragment,e),p(te.$$.fragment,e),p(ne.$$.fragment,e),p(oe.$$.fragment,e),p(Je.$$.fragment,e),p(de.$$.fragment,e),p(je.$$.fragment,e),p(Ce.$$.fragment,e),p(be.$$.fragment,e),p(Be.$$.fragment,e),p(ke.$$.fragment,e),p(ze.$$.fragment,e),p(Se.$$.fragment,e),p(He.$$.fragment,e),p(Xe.$$.fragment,e),p(Le.$$.fragment,e),p(De.$$.fragment,e),p(Oe.$$.fragment,e),qt=!1},d(e){e&&(t(ll),t(Ke),t(tl),t(sl),t(nl),t(al),t(h),t(il),t(B),t(Ml),t(Z),t(ol),t(j),t(ul),t(rl),t(k),t(Jl),t(G),t(Ul),t(Q),t(pl),t(N),t(Tl),t(cl),t(z),t(yl),t(x),t(dl),t(q),t(wl),t(S),t(ml),t(F),t(jl),t(Il),t(I),t(gl),t(E),t(Cl),t(X),t(fl),t($),t(bl),t(vl),t(R),t(Vl),t(hl),t(Bl),t(D),t(Zl),t(P),t(Al),t(O),t(kl),t(K),t(Gl),t(Ql),t(le),t(Nl),t(Wl),t(se),t(zl),t(xl),t(ae),t(ql),t(ie),t(Sl),t(Me),t(Fl),t(Hl),t(ue),t(El),t(re),t(Xl),t($l),t(Ue),t(Ll),t(pe),t(Rl),t(Te),t(_l),t(ce),t(Yl),t(ye),t(Dl),t(Pl),t(we),t(Ol),t(me),t(Kl),t(et),t(Ie),t(lt),t(ge),t(tt),t(st),t(fe),t(nt),t(at),t(ve),t(it),t(Ve),t(Mt),t(d),t(ot),t(he),t(ut),t(rt),t(Ze),t(Jt),t(Ae),t(Ut),t(g),t(pt),t(Tt),t(Ge),t(ct),t(Qe),t(yt),t(Ne),t(dt),t(We),t(wt),t(mt),t(xe),t(jt),t(qe),t(It),t(gt),t(Fe),t(Ct),t(ft),t(Ee),t(bt),t(vt),t($e),t(Vt),t(C),t(ht),t(Bt),t(Re),t(Zt),t(f),t(At),t(_e),t(kt),t(Gt),t(Qt),t(Ye),t(Nt),t(Wt),t(Pe),t(zt),t(xt),t(el)),t(m),T(b,e),T(v,e),T(V,e),T(A,e),T(W,e),T(H,e),T(L,e),T(_,e),T(Y,e),T(ee,e),T(te,e),T(ne,e),T(oe,e),T(Je,e),T(de,e),T(je,e),T(Ce,e),T(be,e),T(Be,e),T(ke,e),T(ze,e),T(Se,e),T(He,e),T(Xe,e),T(Le,e),T(De,e),T(Oe,e)}}}const on='{"title":"Construire des agents qui utilisent du code","local":"construire-des-agents-qui-utilisent-du-code","sections":[{"title":"Pourquoi les agents à code ?","local":"pourquoi-les-agents-à-code-","sections":[],"depth":2},{"title":"Comment fonctionne un agent à code ?","local":"comment-fonctionne-un-agent-à-code-","sections":[],"depth":2},{"title":"Voyons quelques exemples","local":"voyons-quelques-exemples","sections":[{"title":"Sélectionner une playlist pour la fête en utilisant smolagents","local":"sélectionner-une-playlist-pour-la-fête-en-utilisant-smolagents","sections":[],"depth":3},{"title":"Utiliser un outil personnalisé pour préparer le menu","local":"utiliser-un-outil-personnalisé-pour-préparer-le-menu","sections":[],"depth":3},{"title":"Utiliser des imports Python à l’intérieur de l’agent","local":"utiliser-des-imports-python-à-lintérieur-de-lagent","sections":[],"depth":3},{"title":"Partager notre agent préparateur de fête personnalisé sur le Hub","local":"partager-notre-agent-préparateur-de-fête-personnalisé-sur-le-hub","sections":[],"depth":3},{"title":"Inspecter notre agent préparateur de fête avec OpenTelemetry et Langfuse 📡","local":"inspecter-notre-agent-préparateur-de-fête-avec-opentelemetry-et-langfuse-","sections":[],"depth":3}],"depth":2},{"title":"Ressources","local":"ressources","sections":[],"depth":2}],"depth":1}';function un(Ht){return Os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends Ks{constructor(m){super(),en(this,m,un,Mn,Ds,{})}}export{yn as component};
