# 액션: 에이전트가 환경과 상호작용할 수 있게 하기 [[actions-enabling-the-agent-to-engage-with-its-environment]]

> [!TIP]
> 이 섹션에서는 AI 에이전트가 환경과 상호작용하기 위해 취하는 구체적인 단계를 살펴봅니다.
>
>  액션이 어떻게 표현되는지(JSON 또는 코드 사용), 중지 및 구문 분석 접근 방식의 중요성, 그리고 다양한 유형의 에이전트를 소개합니다.

액션은 **AI 에이전트가 환경과 상호작용하기 위해 취하는** 구체적인 단계입니다.

정보를 위해 웹을 검색하든 물리적 장치를 제어하든, 각 액션은 에이전트가 실행하는 의도적인 작업입니다.

예를 들어, 고객 서비스를 지원하는 에이전트는 고객 데이터를 검색하거나, 도움말 문서를 제공하거나, 문제를 인간 담당자에게 이관할 수 있습니다.

## 에이전트 액션의 유형 [[types-of-agent-actions]]

액션을 다르게 취하는 여러 유형의 에이전트가 있습니다:

| 에이전트 유형 | 설명 |
|--------------|------|
| JSON 에이전트 | 취할 액션이 JSON 형식으로 지정됩니다. |
| 코드 에이전트 | 에이전트가 외부에서 해석되는 코드 블록을 작성합니다. |
| 함수 호출 에이전트 | JSON 에이전트의 하위 카테고리로, 각 액션마다 새로운 메시지를 생성하도록 미세 조정되었습니다. |

액션 자체는 다양한 목적을 가질 수 있습니다:

| 액션 유형 | 설명 |
|----------|------|
| 정보 수집 | 웹 검색 수행, 데이터베이스 쿼리, 문서 검색 등 |
| 도구 사용 | API 호출, 계산 실행, 코드 실행 |
| 환경 상호작용 | 디지털 인터페이스 조작 또는 물리적 장치 제어 |
| 의사소통 | 채팅을 통한 사용자와의 상호작용 또는 다른 에이전트와의 협업 |

모든 형식의 에이전트(JSON, 코드, 함수 호출)에 있어 중요한 부분은 **액션이 완료되면 새로운 토큰 생성을 중지하는 능력**입니다. 이는 의도하지 않은 출력을 방지하고 에이전트의 응답이 명확하고 정확하도록 보장합니다.

LLM은 텍스트만 처리하며 이를 사용하여 취하고자 하는 액션과 도구에 제공할 매개변수를 설명합니다.

## 중지 및 구문 분석 접근 방식 [[the-stop-and-parse-approach]]

액션을 구현하는 핵심 방법 중 하나는 **중지 및 구문 분석 접근 방식**입니다. 이 방법은 에이전트의 출력이 구조화되고 예측 가능하도록 보장합니다:

1. **구조화된 형식으로 생성**:

에이전트는 의도한 액션을 명확하고 미리 정의된 형식(JSON 또는 코드)으로 출력합니다.

2. **추가 생성 중지**:

액션이 완료되면 **에이전트는 추가 토큰 생성을 중지**합니다. 이는 불필요하거나 오류가 있는 출력을 방지합니다.

3. **출력 구문 분석**:

외부 파서가 형식화된 액션을 읽고, 어떤 도구를 호출할지 결정하며, 필요한 매개변수를 추출합니다.

예를 들어, 날씨를 확인해야 하는 에이전트는 다음과 같이 출력할 수 있습니다:


```json
Thought: 서울의 현재 날씨를 확인해야 합니다.
Action :
{
  "action": "get_weather",
  "action_input": {"location": "Seoul"}
}
```
프레임워크는 호출할 함수의 이름과 적용할 인자를 쉽게 구문 분석할 수 있습니다.

이 명확하고 기계가 읽을 수 있는 형식은 오류를 최소화하고 외부 도구가 에이전트의 명령을 정확하게 처리할 수 있게 합니다.

참고: 함수 호출 에이전트는 각 액션을 구조화하여 지정된 함수가 올바른 인수와 함께 호출되도록 하는 비슷한 방식으로 작동합니다.
이러한 유형의 에이전트에 대해서는 향후 유닛에서 더 자세히 살펴볼 것입니다.

## 코드 에이전트 [[code-agents]]

대안적인 접근 방식은 *코드 에이전트*를 사용하는 것입니다.
핵심 아이디어는 **단순한 JSON 객체를 출력하는 대신**, 코드 에이전트가 **실행 가능한 코드 블록(일반적으로 Python과 같은 고수준 언어로 작성)**을 생성한다는 것입니다.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png" alt="코드 에이전트" />

이 접근 방식은 여러 장점을 제공합니다:

- **표현력:** 코드는 루프, 조건문, 중첩 함수를 포함한 복잡한 로직을 자연스럽게 표현할 수 있어 JSON보다 더 큰 유연성을 제공합니다.
- **모듈성 및 재사용성:** 생성된 코드는 다양한 액션이나 작업에서 재사용할 수 있는 함수와 모듈을 포함할 수 있습니다.
- **향상된 디버깅 가능성:** 잘 정의된 프로그래밍 구문을 통해 코드 오류를 감지하고 수정하기가 더 쉬운 경우가 많습니다.
- **직접 통합:** 코드 에이전트는 외부 라이브러리 및 API와 직접 통합할 수 있어 데이터 처리나 실시간 의사 결정과 같은 복잡한 작업이 가능합니다.

예를 들어, 날씨 정보를 가져오는 임무를 맡은 코드 에이전트는 다음과 같은 Python 코드 조각을 생성할 수 있습니다:

```python
# 코드 에이전트 예시: 날씨 정보 검색
def get_weather(city):
    import requests
    api_url = f"https://api.weather.com/v1/location/{city}?apiKey=YOUR_API_KEY"
    response = requests.get(api_url)
    if response.status_code == 200:
        data = response.json()
        return data.get("weather", "날씨 정보가 없습니다")
    else:
        return "오류: 날씨 데이터를 가져올 수 없습니다."

# 함수 실행 및 최종 답변 준비
result = get_weather("Seoul")
final_answer = f"서울의 현재 날씨는: {result}"
print(final_answer)
```

이 예시에서 코드 에이전트는:

- **API 호출**을 통해 날씨 데이터를 검색하고,
- 응답을 처리하며,
- print() 함수를 사용하여 최종 답변을 출력합니다.

이 방법 **또한 중지 및 구문 분석 접근 방식**을 따르며, 코드 블록을 명확하게 구분하고 실행이 완료되었음을 신호합니다(여기서는 final_answer를 출력함으로써).

---

액션은 JSON, 코드 또는 함수 호출을 통해 명확하고 구조화된 작업을 실행함으로써 에이전트의 내부 추론과 실제 상호작용을 연결한다는 점을 배웠습니다.

이러한 의도적인 실행은 각 액션이 정확하고 중지 및 구문 분석 접근 방식을 통해 외부 처리가 가능하도록 보장합니다. 다음 섹션에서는 에이전트가 환경으로부터 피드백을 캡처하고 통합하는 방법을 알아보기 위해 관찰(Observations)에 대해 살펴볼 것입니다.

이후에는 **드디어 우리의 첫 번째 에이전트를 구축할 준비가 됩니다!**


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ko/unit1/actions.mdx" />