# Действия: Обеспечение взаимодействия Агента с его Окружением

> [!TIP]
> В этом разделе мы рассмотрим конкретные действия AI агента по взаимодействию с окружением. 
>
> Мы расскажем о том, как представляются действия (с помощью JSON или кода), о важности подхода "остановить и разобрать", а также представим различные типы агентов.

Действия - это конкретные шаги, которые **AI агент предпринимает для взаимодействия с окружением**. 

Будь то просмотр информации в Интернете или управление физическим устройством, каждое действие - это целенаправленная операция, выполняемая агентом. 

Например, агент, помогающий в службе поддержки клиентов, может получать данные о клиентах, предлагать статьи по поддержке или передавать проблемы представителю компании.

## Типы Действий Агента

There are multiple types of Agents that take actions differently:

| Тип агента                                        | Описание |
|---------------------------------------------------|-------------------------------------------------------------------------------------------------------|
| JSON Агент                                        | Действие, которое необходимо предпринять, указывается в формате JSON.                                 |
| Агент кода (Code Agent)                           | Агент пишет блок кода, который интерпретируется извне.                                                |
| Агент вызывающий функции (Function-calling Agent) | Это подкатегория агента JSON, который был дообучен генерировать новое сообщение для каждого действия. |

Сами действия могут служить разным целям:

| Тип действия                | Описание |
|-----------------------------|------------------------------------------------------------------------------------------|
| Сбор информации             | Выполнение поиска в Интернете, запрос к базам данных или получение документов.           |
| Использование инструментов  | Выполнение вызовов API, вычислений и выполнение кода.                                    |
| Взаимодействие с окружением | Манипулирование цифровыми интерфейсами или управление физическими устройствами.          |
| Общение                     | Взаимодействие с пользователями через чат или сотрудничество с другими агентами.         |

Одной из важнейших составляющих агента является **возможность прекратить генерацию новых токенов после завершения действия**, и это справедливо для всех форматов Агентов: JSON, код или вызов функций. Это предотвращает непреднамеренный вывод и гарантирует, что ответ агента будет ясным и точным.

LLM работает только с текстом и использует его для описания действий, которые она хочет выполнить, и параметров, которые нужно передать инструменту.

## Подход с Остановись и Разберись

Одним из ключевых методов реализации действий является подход **остановить и разобрать**. Этот метод обеспечивает структурированность и предсказуемость выходных данных агента:

1. **Генерация в структурированном формате**:

Агент выводит предполагаемое действие в четком, заранее определенном формате (JSON или код).

2. **Прекращение дальнейшей генерации**:

После завершения действия **агент прекращает генерировать дополнительные токены**. Это позволяет избежать лишнего или ошибочного вывода.

3. **Разбор выходных данных**:

Внешний парсер считывает отформатированное действие, определяет, какой Инструмент следует вызвать, и извлекает необходимые параметры.

Например, агент, которому нужно проверить погоду, может вывести:


```json
Thought: I need to check the current weather for New York.
Action :
{
  "action": "get_weather",
  "action_input": {"location": "New York"}
}
```
Затем фреймворк может легко разобрать имя функции для вызова и аргументы для применения.

Такой понятный, машиночитаемый формат минимизирует ошибки и позволяет внешним инструментам точно обрабатывать команду агента.

Примечание: агенты вызова функций работают аналогичным образом, структурируя каждое действие так, чтобы вызывалась определенная функция с правильными аргументами.
Мы подробнее рассмотрим эти типы агентов в одном из следующих разделов.

## Агенты Кода

Альтернативный подход - использование *Агентов Кода*.
Идея заключается в следующем: ** вместо того, чтобы выводить простой объект JSON**, агент кода генерирует **исполняемый блок кода - обычно на языке высокого уровня, таком как Python**. 

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png" alt="Code Agents" />

Этот подход имеет ряд преимуществ:

- **Выразительность:** Код может естественным образом представлять сложную логику, включая циклы, условия и вложенные функции, обеспечивая большую гибкость, чем JSON.
- **Модульность и возможность повторного использования:** Генерируемый код может включать функции и модули, которые можно повторно использовать в различных действиях или задачах.
- **Улучшенная отлаживаемость:** Благодаря четко определенному синтаксису программирования ошибки в коде зачастую легче обнаружить и исправить.
- **Прямая интеграция:** Агенты кода могут напрямую интегрироваться с внешними библиотеками и API, что позволяет выполнять более сложные операции, такие как обработка данных или принятие решений в режиме реального времени.

Например, Агент Кода, которому поручено получить информацию о погоде, может сгенерировать следующий фрагмент на языке Python:

```python
# Пример Агента Кода: Получение информации о погоде
def get_weather(city):
    import requests
    api_url = f"https://api.weather.com/v1/location/{city}?apiKey=YOUR_API_KEY"
    response = requests.get(api_url)
    if response.status_code == 200:
        data = response.json()
        return data.get("weather", "No weather information available")
    else:
        return "Error: Unable to fetch weather data."

# Выполнение функции и подготовка окончательного ответа
result = get_weather("New York")
final_answer = f"The current weather in New York is: {result}"
print(final_answer)
```

В этом примере Агент Кода:

- Получает данные о погоде **посредством вызова API**,
- обрабатывает ответ,
- И использует функцию print() для вывода окончательного ответа.

Этот метод **также следует подходу "остановись и разбери"**, четко разграничивая блок кода и сигнализируя о завершении выполнения (здесь - выводом final_answer).

---

Мы узнали, что действия связывают внутренние рассуждения агента и его взаимодействие с реальным миром, выполняя четкие, структурированные задачи - через JSON, код или вызов функций.

Такое продуманное выполнение гарантирует, что каждое действие будет точным и готовым к внешней обработке с помощью подхода «остановить и разобрать». В следующем разделе мы рассмотрим Наблюдения, чтобы увидеть, как агенты улавливают и интегрируют обратную связь от своего окружения.

После этого мы будем **окончательно готовы к созданию нашего первого агента!**.








<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ru-RU/unit1/actions.mdx" />