# Наблюдение: Интеграция Обратной Связи для Рефлексии и Адаптации

Наблюдения - это то, **как агент воспринимает последствия своих действий**.

Они предоставляют важную информацию, которая подпитывает мыслительный процесс агента и направляет его дальнейшие действия.

Это **сигналы из окружения** - будь то данные из API, сообщения об ошибках или системные журналы, - которые направляют следующий цикл размышлений.

В фазе наблюдения агент:

- **Собирает обратную связь:** Получает данные или подтверждение того, что его действия были успешными (или нет).
- **Применяет результаты:** Интегрирует новую информацию в существующий контекст, эффективно обновляя свою память.
- **Адаптирует свою стратегию:** Использует этот обновленный контекст для уточнения последующих мыслей и действий.

Например, если погодный API возвращает данные *переменная облачность, 15 °C, влажность 60 %*, это наблюдение добавляется в память агента (в конце подсказки).

Затем агент использует это наблюдение, чтобы решить, нужна ли дополнительная информация или он готов дать окончательный ответ.

Это **итеративное включение обратной связи обеспечивает динамическое соответствие агента его целям**, постоянное обучение и корректировку на основе реальных результатов.

Эти наблюдения **могут принимать различные формы**, от чтения текста на веб-странице до наблюдения за положением руки робота. Это можно рассматривать как "журналы" Инструментов, которые предоставляют текстовую обратную связь о выполнении действий.

| Тип наблюдения                 | Пример                                                                   |
|--------------------------------|--------------------------------------------------------------------------|
| Обратная связь с системой      | Сообщения об ошибках, уведомления об успехе, коды состояния              |
| Изменения данных               | Обновления баз данных, модификации файловой системы, изменения состояния |
| Данные об окружении            | Показания датчиков, системные метрики, использование ресурсов            |
| Анализ ответов                 | Ответы API, результаты запросов, результаты вычислений                   |
| События, основанные на времени | Достигнутые сроки, выполнение запланированных задач                      |

## Как применяются Результаты?

После выполнения действия фреймворк выполняет следующие шаги по порядку:

1. **Разбор действия** для определения функции (функций) для вызова и аргумента (аргументов) для использования. 
2. **Выполнение действия**. 
3. **Принятие результата** в качестве **Наблюдения**.

---
Теперь мы изучили цикл "Мышление-Действие-Наблюдение" агента. 

Если некоторые аспекты все еще кажутся немного размытыми, не волнуйтесь - мы вернемся к этим понятиям и углубим их понимание в следующих разделах. 

А теперь пришло время применить полученные знания на практике, создав своего первого агента!


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ru-RU/unit1/observations.mdx" />