# Давайте создадим нашего первого агента с помощью smolagents

В прошлом разделе мы узнали, как можно создавать агентов с нуля, используя код на Python, и **увидели, насколько утомительным может быть этот процесс**. К счастью, многие библиотеки Агентов упрощают эту работу, **выполняя большую часть тяжелой работы за вас**.

В этом уроке **вы создадите своего первого агента**, способного выполнять такие действия, как генерация изображений, веб-поиск, проверка часового пояса и многое другое!

Вы также опубликуете своего агента **в пространстве Hugging Face Space, чтобы вы могли поделиться им с друзьями и коллегами**.

Давайте начнем!


## Что такое smolagents?

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png" alt="smolagents"/>

Для создания этого агента мы будем использовать библиотеку `smolagents`, которая **предоставляет основу для разработки агентов с легкостью**.

Эта легковесная библиотека создана для простоты, но она абстрагирует большую часть сложности создания агента, позволяя вам сосредоточиться на разработке поведения агента.

В следующем разделе мы углубимся в изучение smolagents. А пока вы можете ознакомиться с этой <a href="https://huggingface.co/blog/smolagents" target="_blank">статьей в блоге</a> или с <a href="https://github.com/huggingface/smolagents" target="_blank">репозиторием библиотеки на GitHub</a>.

Вкратце, `smolagents` - это библиотека, ориентированная на **Агентов кода**, вид агента, который выполняет **"Действия"** через блоки кода, а затем **"Наблюдает"** за результатами, выполняя код.

Вот пример того, что мы будем создавать! 

Мы предоставили нашему агенту **Инструмент генерации изображений** и попросили его сгенерировать изображение кошки.

Агент внутри `smolagents` будет иметь **такое же поведение, как и пользовательский агент, который мы построили ранее**: он будет **думать, действовать и наблюдать в цикле**, пока не придет к окончательному ответу:

<iframe width="560" height="315" src="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA" title="Видеоплеер YouTube" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>

Захватывающе, правда?

## Давайте создадим нашего агента!

Для начала продублируйте это пространство (Space): <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>
> Спасибо <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> за этот шаблон! 🙌


Дублирование этого пространства означает **создание локальной копии в вашем собственном профиле**:
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif" alt="Дубликат"/>

На протяжении всего этого урока единственным файлом, который вам придется изменить, будет (на данный момент неполный) **"app.py »**. Здесь вы можете увидеть [оригинал в шаблоне](https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py). Чтобы найти свой, зайдите в свою копию пространства, затем перейдите на вкладку `Files`, а затем на `app.py` в списке каталогов.

Давайте разберем код вместе:

- Файл начинается с простого, но необходимого импорта библиотек

```python
from smolagents import CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
import datetime
import requests
import pytz
import yaml
from tools.final_answer import FinalAnswerTool
```

Как уже говорилось ранее, мы будем напрямую использовать класс **CodeAgent** из **smolagents**.


### Инструменты

Теперь перейдем к инструментам! Если вы хотите узнать больше об инструментах, не стесняйтесь вернуться к разделу курса [Инструменты](tools).

```python
@tool
def my_custom_tool(arg1:str, arg2:int)-> str: # важно указать возвращаемый тип
    # Сохраните этот формат для описания инструмента / описания аргументов, но не стесняйтесь модифицировать инструмент
    """Инструмент, который пока ничего не делает
    Аргументы:
        arg1: первый аргумент
        arg2: второй аргумент
    """
    return "Какую магию вы будете создавать?"

@tool
def get_current_time_in_timezone(timezone: str) -> str:
    """Инструмент для получения текущего местного времени в указанном часовом поясе.
    Аргменты:
        timezone: Строка, представляющая действительный часовой пояс (например, 'America/New_York').
    """
    try:
        # Создание объекта timezone
        tz = pytz.timezone(timezone)
        # Получение текущего времени в заданном часовом поясе
        local_time = datetime.datetime.now(tz).strftime("%Y-%m-%d %H:%M:%S")
        return f"Текущее местное время в {timezone} составляет: {local_time}"
    except Exception as e:
        return f"Ошибка получения времени для часового пояса '{timezone}': {str(e)}"
```


Инструменты - это то, что мы призываем вас создать в этом разделе! Мы приводим два примера:

1. **нерабочий фиктивный инструмент**, который вы можете модифицировать, чтобы сделать что-то полезное.
2. **действительно работающий инструмент**, который получает текущее время в любой точке мира.

Чтобы определить свой инструмент, необходимо:

1. Предоставить входной и выходной типы для вашей функции, как в `get_current_time_in_timezone(timezone: str) -> str:`
2. **Написать хорошо отформатированную строку документации**. `smolagents` ожидает, что все аргументы будут иметь **текстовое описание в строке документации**.

### Агент

Он использует [`Qwen/Qwen2.5-Coder-32B-Instruct`](https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct) в качестве движка LLM. Это очень способная модель, к которой мы будем обращаться через бессерверный API.

```python
final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=2096,
    temperature=0.5,
    model_id='Qwen/Qwen2.5-Coder-32B-Instruct',
    custom_role_conversions=None,
)

with open("prompts.yaml", 'r') as stream:
    prompt_templates = yaml.safe_load(stream)
    
# Создаем наш Кодовый Агент
agent = CodeAgent(
    model=model,
    tools=[final_answer], # добавьте сюда свои инструменты (не удаляйте final_answer)
    max_steps=6,
    verbosity_level=1,
    grammar=None,
    planning_interval=None,
    name=None,
    description=None,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()
```

Этот агент по-прежнему использует `InferenceClient`, который мы видели в предыдущем разделе за классом **InferenceClientModel**!

Мы приведем более подробные примеры, когда будем представлять фреймворк в разделе 2. Пока же вам нужно сосредоточиться на **добавлении новых инструментов в список инструментов** с помощью параметра `tools` вашего Агента.

Например, вы можете использовать `DuckDuckGoSearchTool`, который был импортирован в первой строке кода, или вы можете изучить `image_generation_tool`, который загружается из Hub позже в коде.

**Добавление инструментов даст вашему агенту новые возможности**, попробуйте проявить творческий подход!

Полная версия "app.py":

```python
from smolagents import CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
import datetime
import requests
import pytz
import yaml
from tools.final_answer import FinalAnswerTool

from Gradio_UI import GradioUI

# Ниже приведен пример инструмента, который ничего не делает. Удивите нас своей креативностью!
@tool
def my_custom_tool(arg1:str, arg2:int)-> str: # важно указать возвращаемый тип
    # Сохраните этот формат для описания инструмента / описания аргументов, но не стесняйтесь модифицировать инструмент
    """Инструмент, который пока ничего не делает
    Аргументы:
        arg1: первый аргумент
        arg2: второй аргумент
    """
    return "Какую магию вы будете создавать?"

@tool
def get_current_time_in_timezone(timezone: str) -> str:
    """Инструмент для получения текущего местного времени в указанном часовом поясе.
    Аргменты:
        timezone: Строка, представляющая действительный часовой пояс (например, 'America/New_York').
    """
    try:
        # Создание объекта timezone
        tz = pytz.timezone(timezone)
        # Получение текущего времени в заданном часовом поясе
        local_time = datetime.datetime.now(tz).strftime("%Y-%m-%d %H:%M:%S")
        return f"Текущее местное время в {timezone} составляет: {local_time}"
    except Exception as e:
        return f"Ошибка получения времени для часового пояса '{timezone}': {str(e)}"


final_answer = FinalAnswerTool()
model = InferenceClientModel(
max_tokens=2096,
temperature=0.5,
model_id='Qwen/Qwen2.5-Coder-32B-Instruct',
custom_role_conversions=None,
)


# Импорт инструмента из Hub
image_generation_tool = load_tool("agents-course/text-to-image", trust_remote_code=True)

with open("prompts.yaml", 'r') as stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], # добавьте сюда свои инструменты (не удаляйте final_answer)
    max_steps=6,
    verbosity_level=1,
    grammar=None,
    planning_interval=None,
    name=None,
    description=None,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()
```

Ваша **Цель** - познакомиться с Пространством и Агентом. 

В настоящее время агент в шаблоне **не использует никаких инструментов, поэтому постарайтесь снабдить его некоторыми из готовых инструментов или даже сделать новые инструменты самостоятельно!**.

Мы с нетерпением ждем ваших потрясающих выводов агентов в канале discord **#agents-course-showcase**!


---
Поздравляем, вы создали своего первого агента! Не стесняйтесь поделиться им со своими друзьями и коллегами.

Поскольку это ваша первая попытка, совершенно нормально, если он будет немного глючным или медленным. В следующих разделах мы узнаем, как создавать еще более совершенных агентов.

Лучший способ научиться - это попробовать, поэтому не стесняйтесь обновлять его, добавлять новые инструменты, пробовать с другой моделью и т. д.

В следующем разделе вы пройдете финальный тест и получите сертификат!


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ru-RU/unit1/tutorial.mdx" />