# Что такое Агент?

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-no-check.jpg" alt="Unit 1 planning"/>

К концу этого раздела вы будете чувствовать себя комфортно с концепцией агентов и их различными применениями в ИИ.

Чтобы объяснить, что такое агент, давайте начнем с аналогии.

## Общая картина: Агент Альфред

Познакомьтесь с Альфредом. Альфред - **агент**.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/this-is-alfred.jpg" alt="This is Alfred"/>

Представьте, что Альфред **получает команду**, например: «Альфред, я бы хотел кофе, пожалуйста».

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/coffee-please.jpg" alt="I would like a coffee"/>

Поскольку Альфред **понимает естественный язык**, он быстро понимает нашу просьбу.

Перед выполнением заказа Альфред занимается **рассуждениями и планированием**, определяя, какие действия и инструменты ему понадобятся:

1. Пойти на кухню  
2. Воспользоваться кофеваркой  
3. Заварите кофе  
4. Принесите кофе обратно

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/reason-and-plan.jpg" alt="Reason and plan"/>

Когда у него есть план, он **должен действовать**. Чтобы выполнить свой план, **он может использовать инструменты из списка инструментов, о которых он знает**. 

В данном случае, чтобы приготовить кофе, он использует кофеварку. Он активирует кофеварку, чтобы сварить кофе.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/make-coffee.jpg" alt="Make coffee"/>

Наконец Альфред приносит нам свежесваренный кофе.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/bring-coffee.jpg" alt="Bring coffee"/>

Именно это и есть агент: **ИИ модель, способная рассуждать, планировать и взаимодействовать со своим окружением**. 

Мы называем его агентом, потому что он обладает _агентностью_, то есть способностью взаимодействовать с окружающей средой.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/process.jpg" alt="Agent process"/>

## Давайте будем более формальны

Теперь, когда вы получили общую картину, вот более точное определение:

> Агент - это система, использующая модель искусственного интеллекта для взаимодействия с окружающей средой с целью достижения определенной пользователем цели. Он сочетает в себе рассуждения, планирование и выполнение действий (часто с помощью внешних инструментов) для выполнения задач.

Считайте, что агент состоит из двух основных частей:

1. **Мозг (модель ИИ)**.

Именно здесь происходит все мышление. Модель ИИ **занимается рассуждениями и планированием**.
Она решает, **какие действия предпринять в зависимости от ситуации**.

2. **Тело (возможности и инструменты)**.

Эта часть представляет собой **все, что агент способен делать**.

Набор **возможных действий** зависит от того, чем **наделен агент**. Например, поскольку у человека нет крыльев, он не может выполнять **действие «летать», но может выполнять такие **действия**, как «ходить», «бегать», «прыгать», «хватать» и так далее.

## Какие модели ИИ мы используем для агентов?

Наиболее распространенной моделью ИИ, используемой в агентах, является LLM (большая языковая модель), которая принимает на вход **Текст** и выводит **Текст**.

Известными примерами являются **GPT4** от **OpenAI**, **LLama** от **Meta**, **Gemini** от **Google** и т. д. Эти модели были обучены на огромном количестве текстов и способны к обобщению. Подробнее о LLM мы узнаем в [следующем разделе](what-are-llms).

> [!TIP]
> Также можно использовать модели, принимающие другие входные данные, в качестве основной модели агента. Например, Vision Language Model (VLM), которая похожа на LLM, но также понимает изображения в качестве входных данных. Пока что мы сосредоточимся на LLM и обсудим другие варианты позже.

## Как ИИ воздействует на окружающую среду?

LLM - замечательные модели, но **они могут генерировать только текст**. 

Однако если вы попросите известное чат-приложение, например HuggingChat или ChatGPT, сгенерировать изображение, они смогут! Как такое возможно?

Ответ заключается в том, что разработчики HuggingChat, ChatGPT и подобных приложений реализовали дополнительный функционал (так называемые **инструменты (tools)**), которые LLM может использовать для создания изображений.

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/eiffel_brocolis.jpg" alt="Eiffel Brocolis"/>
<figcaption>The model used an Image Generation Tool to generate this image.
</figcaption>
</figure>

Подробнее об инструментах мы поговорим в разделе [Инструменты](tools).

## Какой тип задач может выполнять Агент?

Агент может выполнять любые задачи, которые мы реализуем с помощью **Инструментов** для выполнения **Действий**.

Например, если я напишу агента, который будет действовать как мой личный помощник (как Siri) на моем компьютере, и попрошу его «отправить электронное письмо моему менеджеру с просьбой отложить сегодняшнюю встречу», я могу дать ему код для отправки электронных писем. Это будет новый инструмент, который агент сможет использовать всякий раз, когда ему понадобится отправить письмо. Мы можем написать его на языке Python:

```python
def send_message_to(recipient, message):
    """Используется для отправки электронного сообщения получателю"""
    ...
```

LLM, как мы увидим, будет генерировать код для запуска инструмента, когда это необходимо, и таким образом выполнять поставленную задачу.

```python
send_message_to("Менеджер", "Мы можем отложить сегодняшнюю встречу?")
```

Дизайн **Инструментов очень важен и оказывает большое влияние на качество работы вашего Агента**. Некоторые задачи требуют создания очень специфических инструментов, в то время как другие могут быть решены с помощью инструментов общего назначения, таких как "web_search".

> Обратите внимание, что **Действия - это не то же самое, что Инструменты**. Действие, например, может включать в себя использование нескольких инструментов для выполнения.

Предоставление агенту возможности взаимодействовать с окружающей средой **позволяет использовать его в реальной жизни компаниями и частными лицами**.

### Пример 1: Виртуальные персональные ассистенты

Виртуальные помощники, такие как Siri, Alexa или Google Assistant, работают как агенты, когда взаимодействуют от имени пользователей в их цифровом окружении.

Они принимают запросы пользователей, анализируют контекст, извлекают информацию из баз данных, дают ответы или инициируют действия (например, устанавливают напоминания, отправляют сообщения или управляют смарт-устройствами).

Пример 2: Чат-боты для обслуживания клиентов

Многие компании используют чат-боты в качестве агентов, которые взаимодействуют с клиентами на естественном языке. 

Эти агенты могут отвечать на вопросы, направлять пользователей по шагам устранения неисправностей, открывать проблемы во внутренних базах данных или даже завершать транзакции.

Их заранее определенные цели могут включать повышение удовлетворенности пользователей, сокращение времени ожидания или увеличение коэффициента конверсии продаж. Взаимодействуя непосредственно с клиентами, обучаясь в ходе диалога и адаптируя свои ответы с течением времени, они демонстрируют основные принципы работы агента в действии.


### Пример 3: ИИ неигрового персонажа в видеоигре

Вкратце, агент - это система, которая использует модель ИИ (обычно LLM) в качестве основного механизма рассуждений, чтобы:

Вместо того чтобы следовать жесткому дереву поведения, они могут **реагировать контекстно, адаптироваться к взаимодействию с игроком** и генерировать более тонкие диалоги. Такая гибкость помогает создавать более реалистичные и увлекательные персонажи, которые развиваются вместе с действиями игрока.

---

Вкратце, агент - это система, которая использует  ИИ модель (обычно LLM) в качестве основного механизма рассуждений, чтобы:

- **Понимать естественный язык:** Интерпретировать и осмысленно отвечать на человеческие инструкции.

- **Рассуждать и планировать:** Анализировать информацию, принимать решения и разрабатывать стратегии для решения проблем.

- **Взаимодействовать с окружающей средой:** Собирать информацию, предпринимать действия и наблюдать за их результатами.

Теперь, когда вы хорошо знаете, что такое агенты, давайте закрепим ваше понимание с помощью короткого теста без оценки. После этого мы погрузимся в «мозг агента»: [LLMs](what-are-llms).


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ru-RU/unit1/what-are-agents.mdx" />