# Что такое LLM?

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-1.jpg" alt="Unit 1 planning"/>

В предыдущем разделе мы узнали, что каждый агент нуждается в ** AI Модели как в ядре**, и что LLM являются наиболее распространенным типом AI моделей использующихся для этой цели.

Теперь мы узнаем, что такое LLM и как они наделяют агентов мощью.

В этом разделе представлено краткое техническое объяснение использования LLM. Если вы хотите погрузиться глубже, вы можете ознакомиться с нашим <a href="https://huggingface.co/learn/nlp-course/chapter1/1" target="_blank">бесплатным курсом по Обработке Естественного Языка (Natural Language Processing).</a>.

## ## Что такое Большая Языковая Модель?

Большая Языковая Модель (Large Language Model, LLM) - это тип AI модели, которая превосходно работает с **пониманием и генерированием человеческого языка**.  Они обучаются на огромных объемах текстовых данных, что позволяет им изучать шаблоны, структуру и даже нюансы языка. Эти модели обычно состоят из многих миллионов параметров.

Большинство LLM в настоящее время **построены на архитектуре Transformer** - архитектуре глубокого обучения, основанной на алгоритме «Внимания» («Attention» algorithm), который стал вызывать значительный интерес после выхода BERT от Google в 2018 году.

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/transformer.jpg" alt="Transformer"/>
<figcaption>Оригинальная архитектура трансформера выглядела следующим образом: слева располагался кодер, справа - декодер.
</figcaption>
</figure>

Существует 3 типа трансформеров:

1. **Энкодеры (кодеры)**    
   Трансформер на основе кодировщика принимает на вход текст (или другие данные) и выдает плотное векторное представление (или эмбеддинг) этого текста.

   - **Пример**: BERT от Google
   - **Примеры использования**: классификация текста, семантический поиск, Распознавание Именованных Сущностей (Named Entity Recognition, NER)
   - **Типичный размер**: миллионы параметров

2. **Декодеры**.  
   Трансформер на основе декодера фокусируется **на генерации новых токенов для завершения последовательности, по одному токену за раз**.

   - **Пример**: Llama из Meta 
   - **Примеры использования**: Генерация текста, чат-боты, генерация кода
   - **Типичный размер**: Миллиарды (в американском понимании, т.е. 10^9) параметров

3. **Seq2Seq (энкодер-декодер)**.  
   Трансформер преобразующие последовательности в последовательность (sequence-to-sequence) объединяет в себе энкодер и декодер. Сначала энкодер преобразует входную последовательность в контекстное представление, а затем декодер генерирует выходную последовательность.

   - **Пример**: T5, BART 
   - **Примеры использования**:  Перевод, обобщение, перефразирование.
   - **Типичный размер**: Миллионы параметров

Хотя Большие Языковые Модели (Large Language Model) бывают разных форм, LLM обычно представляют собой модели на основе декодера с миллиардами параметров. Вот некоторые из наиболее известных LLM:

| **Модель**                          | **Провайдер**                              |
|-----------------------------------|-------------------------------------------|
| **Deepseek-R1**                    | DeepSeek                                  |
| **GPT4**                           | OpenAI                                    |
| **Llama 3**                        | Meta (Facebook AI Research)               |
| **SmolLM2**                       | Hugging Face     |
| **Gemma**                          | Google                                    |
| **Mistral**                        | Mistral                                |

Принцип, лежащий в основе LLM, прост, но очень эффективен: **его цель - предсказать следующий токен, учитывая последовательность предыдущих токенов**. "Токен" - это единица информации, с которой работает LLM. Вы можете воспринимать "токен" как "слово", но по соображениям эффективности LLM не используют целые слова.

Например, если в английском языке насчитывается около 600 000 слов, то в LLM может быть около 32 000 токенов (как в случае с Llama 2). Токенизация часто работает по подсловам, которые можно комбинировать.

Например, рассмотрим, как токены "interest" и "ing" могут быть объединены в слово "interesting", или "ed" может быть добавлено в слово "interested".

Вы можете поэкспериментировать с различными токенами в интерактивной демонстрации ниже:

<iframe
	src="https://agents-course-the-tokenizer-playground.static.hf.space"
	frameborder="0"
	width="850"
	height="450"
></iframe>

Каждая LLM имеет несколько **специальных токенов**, специфичных для данной модели. LLM использует эти токены для открытия и закрытия структурированных компонентов своей генерации. Например, чтобы указать начало или конец последовательности, сообщения или ответа. Кроме того, инструкции для ввода (input prompts), которые мы передаем модели, также структурированы с помощью специальных токенов. Наиболее важным из них является токен **Конец последовательности** (EOS).

Формы специальных токенов у разных провайдеров моделей весьма разнообразны.

Таблица ниже иллюстрирует разнообразие специальных токенов.

<table>
  <thead>
    <tr>
      <th><strong>Model</strong></th>
      <th><strong>Provider</strong></th>
      <th><strong>EOS Token</strong></th>
      <th><strong>Functionality</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><strong>GPT4</strong></td>
      <td>OpenAI</td>
      <td><code>&lt;|endoftext|&gt;</code></td>
      <td>End of message text</td>
    </tr>
    <tr>
      <td><strong>Llama 3</strong></td>
      <td>Meta (Facebook AI Research)</td>
      <td><code>&lt;|eot_id|&gt;</code></td>
      <td>End of sequence</td>
    </tr>
    <tr>
      <td><strong>Deepseek-R1</strong></td>
      <td>DeepSeek</td>
      <td><code>&lt;|end_of_sentence|&gt;</code></td>
      <td>End of message text</td>
    </tr>
    <tr>
      <td><strong>SmolLM2</strong></td>
      <td>Hugging Face</td>
      <td><code>&lt;|im_end|&gt;</code></td>
      <td>End of instruction or message</td>
    </tr>
    <tr>
      <td><strong>Gemma</strong></td>
      <td>Google</td>
      <td><code>&lt;end_of_turn&gt;</code></td>
      <td>End of conversation turn</td>
    </tr>
  </tbody>
</table>

> [!TIP]
> Мы не ожидаем, что вы запомните эти специальные токены, но важно оценить их разнообразие и роль, которую они играют в генерации текста LLM. Если вы хотите узнать больше о специальных токенах, вы можете посмотреть конфигурацию модели в ее репозитории на Hugging Face Hub. Например, вы можете найти специальные токены модели SmolLM2 в ее <a href="https://huggingface.co/HuggingFaceTB/SmolLM2-135M-Instruct/blob/main/tokenizer_config.json">tokenizer_config.json</a>.

## Понимание предсказания следующего токена.

Считается, что LLM - это **авторегрессия**, то есть **выход одного прохода становится входом для следующего**. Этот цикл продолжается до тех пор, пока модель не предскажет, что следующим токеном будет токен EOS, на котором модель может остановиться.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/AutoregressionSchema.gif" alt="Визуализация процесса авторегрессионного декодирования" width="60%">

Другими словами, LLM будет декодировать текст до тех пор, пока он не достигнет EOS. Но что происходит во время одного цикла декодирования?

Хотя полное описание процесса может быть довольно техническим для целей изучения агентов, вот краткий обзор:

- После того как входной текст **токинизирован**, модель вычисляет представление последовательности, которое содержит информацию о значении и положении каждого токена во входной последовательности.
- Это представление поступает в модель, которая возвращает оценки, оценивающие вероятность для каждого токена из ее словаря быть следующим в последовательности.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/DecodingFinal.gif" alt="Визуализация процесса декодирования" width="60%">

Основываясь на этих оценках, у нас есть несколько стратегий выбора токенов для завершения предложения. 

- Самой простой стратегией декодирования будет всегда брать токен с максимальным количеством баллов.

Вы можете самостоятельно взаимодействовать с процессом декодирования с помощью SmolLM2 в этом Пространстве (помните, что она декодирует до достижения токена **EOS**, которым является **<|im_end|>** для этой модели):

<iframe
	src="https://agents-course-decoding-visualizer.hf.space"
	frameborder="0"
	width="850"
	height="450"
></iframe>

- Но есть и более продвинутые стратегии декодирования. Например, *лучевой поиск (beam search)* исследует несколько последовательностей-кандидатов, чтобы найти ту, которая имеет максимальную общую оценку - даже если некоторые отдельные токены имеют более низкие оценки.

<iframe
	src="https://agents-course-beam-search-visualizer.hf.space"
	frameborder="0"
	width="850"
	height="450"
></iframe>

Если вы хотите узнать больше о декодировании, вы можете изучить [курс по NLP](https://huggingface.co/learn/nlp-course).

## Внимание - это все, что вам нужно

Ключевым аспектом архитектуры трансформера является **Внимание (Attention)**. При предсказании следующего слова,
не все слова в предложении одинаково важны; такие слова, как "France" и "capital" в предложении *"The capital of France is ..."*, несут наибольшую смысловую нагрузку.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/AttentionSceneFinal.gif" alt="Визуализация механизма Внимания" width="60%">
Этот процесс определения наиболее релевантных слов для предсказания следующего токена оказался невероятно эффективным.

Хотя основной принцип работы LLM - предсказание следующего токена - остается неизменным со времен GPT-2, были достигнуты значительные успехи в масштабировании нейронных сетей и обеспечении работы механизма внимания для все более длинных последовательностей.

Если вы взаимодействовали с LLM, вы, вероятно, знакомы с термином *длина контекста (context length)*, который обозначает максимальное количество токенов, которые может обработать LLM, и максимальную _продолжительность внимания (attention span)_, которой она обладает.

## Подсказки для LLM очень важны

Учитывая, что единственная задача LLM - предсказать следующий токен, просматривая каждый входной токен, и выбрать "важные" токены, формулировка вашей входной последовательности очень важна.

Входная последовательность, которую вы передаете LLM, называется _подсказкой (prompt)_. Тщательное проектирование подсказки облегчает **направление генерации LLM к желаемому результату**.

## Как обучаются LLM?

Модели LLM обучаются на больших массивах данных текста, где они учатся предсказывать следующее слово в последовательности с помощью самообучения (self-supervised) или маскированного языкового моделирования (masked language modeling). 

В результате такого обучения без учителя модель изучает структуру языка и **основные закономерности в тексте, что позволяет модели обобщать ранее не встречавшиеся данные**.

После такого начального _предварительного_ обучения LLM могут быть дообучены для выполнения конкретных задач методами обучения с учителем. Например, некоторые модели обучаются разговорным структурам или использованию инструментов, в то время как другие сосредоточены на классификации или генерации кода.

## Как я могу использовать LLM?

У вас есть два основных варианта:

1. **Запустить локально** (если у вас достаточно аппаратных ресурсов).

2. **Использовать облако/API** (например, через Hugging Face Serverless Inference API).

На протяжении всего курса мы будем использовать модели через API на Hugging Face Hub. Позже мы изучим, как запустить эти модели локально на вашем оборудовании.


## Как LLM используются в AI Агентах?

LLM являются ключевым компонентом агентов искусственного интеллекта, **обеспечивая основу для понимания и генерации человеческого языка**.

Они могут интерпретировать инструкции пользователя, поддерживать контекст в разговоре, определять план и решать, какие инструменты использовать.

Мы рассмотрим эти шаги более подробно в данном Разделе, а пока вам нужно понять, что LLM - это **мозг агента**.

---

Это был большой объем информации! Мы рассмотрели основы того, что такое LLM, как они функционируют и какова их роль в работе AI агентов. 

Если вы хотите еще глубже погрузиться в увлекательный мир языковых моделей и обработки естественного языка, не поленитесь ознакомиться с нашим <a href="https://huggingface.co/learn/nlp-course/chapter1/1" target="_blank">бесплатным курсом по NLP</a>.

Теперь, когда мы поняли, как работают LLM, пришло время увидеть **как LLM структурируют свою генерацию в разговорном контексте**.

Чтобы запустить <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit1/dummy_agent_library.ipynb" target="_blank">этот блокнот</a>, **вам понадобится токен Hugging Face** который вы можете получить из <a href="https://hf.co/settings/tokens" target="_blank">https://hf.co/settings/tokens</a>.

Более подробную информацию о том, как запустить блокноты Jupyter, изучите <a href="https://huggingface.co/docs/hub/notebooks">Блокноты Jupyter на Hugging Face Hub</a>.

Вам также необходимо запросить доступ к <a href="https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct" target="_blank">модели Meta Llama</a>.


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ru-RU/unit1/what-are-llms.mdx" />