# LlamaIndex 简介

欢迎来到本模块，您将学习如何使用 [LlamaIndex](https://www.llamaindex.ai/) 工具包构建基于大语言模型（LLM）的智能体。

LlamaIndex 是**通过索引和工作流在您的数据上创建 LLM 驱动智能体的完整工具包**。本课程我们将重点关注构建 LlamaIndex 智能体的三个核心部分：**组件**、**智能体与工具**以及**工作流**。

![LlamaIndex](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/thumbnail.png)

让我们解析这些核心要素及其对智能体的支持：

- **组件**是 LlamaIndex 中的基础构建模块，包括提示词、模型和数据库等。组件通常帮助 LlamaIndex 与其他工具和库进行集成。
- **工具**：提供特定功能的组件，如搜索、计算或访问外部服务。它们是支撑智能体执行任务的基础模块。
- **智能体**：能够自主使用工具并做出决策的独立组件，通过协调工具使用来实现复杂目标。
- **工作流**：按步骤处理逻辑的流程。智能体工作流是一种无需显式使用智能体即可构建智能行为的方式。


## LlamaIndex 的独特之处

虽然LlamaIndex与其他框架（如 smolagents）有相似之处，但具备以下关键优势：

- **清晰的工作流系统**。通过事件驱动和异步优先的语法，工作流帮助您逐步分解智能体的决策过程，实现逻辑的清晰组合与组织。
- **基于 LlamaParse 的高级文档解析** 专为 LlamaIndex 打造的文档解析工具，尽管是付费功能，但提供无缝集成体验。
- **丰富的即用组件** 凭借长期的技术积累，LlamaIndex 与众多框架兼容，提供大量经过验证的可靠组件（如 LLM、检索器、索引等）。
- **LlamaHub** 提供了数百个此类组件、智能体和工具的注册中心，方便您在 LlamaIndex 中直接使用。

这些概念在不同场景中都是创建实用智能体的必要元素。
后续章节我们将深入解析每个概念。
掌握这些知识后，我们将运用所学**通过 Alfred 智能体创建实际应用案例**！

准备好探索 LlamaIndex 的精彩世界了吗？让我们立即启程，**通过 LlamaHub 查找并安装所需集成吧！🚀**

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit2/llama-index/introduction.mdx" />