# 什么是GAIA？

[GAIA](https://huggingface.co/papers/2311.12983) 是一个**用于评估AI助手在需要核心能力组合的真实世界任务上的表现的基准**，这些核心能力包括推理、多模态理解、网页浏览和熟练的工具使用。

此论文介绍了GAIA _"[GAIA: A Benchmark for General AI Assistants](https://huggingface.co/papers/2311.12983)"_。

该基准包含**466个精心策划的问题**，这些问题对人类来说**在概念上简单**，但对当前的AI系统来说却**极具挑战性**。

为了说明差距：
- **人类**：约92%的成功率  
- **带有插件的GPT-4**：约15%  
- **深度研究（OpenAI）**：在验证集上的得分为67.36%

GAIA突出了AI模型的当前局限性，并提供了一个严格的基准来评估向真正通用AI助手发展的进展。

## 🌱 GAIA的核心原则

GAIA围绕以下支柱精心设计：

- 🔍 **现实世界的难度**：任务需要多步骤推理、多模态理解和工具交互。
- 🧾 **人类可解释性**：尽管对AI来说很难，但每个任务在概念上对人类来说仍然简单易懂。
- 🛡️ **不可游戏化**：正确答案需要完整的任务执行，使得蛮力破解无效。
- 🧰 **评估的简单性**：答案简洁、事实性强且明确———作为一个理想的基准测试。

## 难度等级

GAIA任务被组织为**三个递增复杂度的等级**，每个等级测试特定技能：

- **一级**：需要少于5个步骤和最少的工具使用。
- **二级**：涉及更复杂的推理和多个工具之间的协调以及5-10个步骤。
- **三级**：需要长期规划和各种工具的高级集成。

![GAIA等级](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit4/gaia_levels.png)

## 困难GAIA等级（Hard GAIA）的问题示例

> 在2008年画作“乌兹别克斯坦的刺绣”中展示的水果中，哪些曾在1949年10月的早餐菜单中被提供，作为后来用于电影《最后航程》的远洋班轮的一部分？请将这些水果以逗号分隔的列表形式给出，按照它们在画作中从12点位置开始的顺时针排列顺序，并使用每种水果的复数形式。

正如您所见，这个问题在几个方面对AI系统提出了挑战：

- 需要一个**结构化的响应格式**
- 涉及**多模态推理**（例如，分析图像）
- 需要**多跳检索**相互依赖的事实：
  - 识别画作中的水果
  - 发现哪个远洋班轮用于*最后航程*
  - 查找该船1949年10月的早餐菜单
- 需要**正确的排序**和高级规划以按正确顺序解决

这种任务突出了单独的LLM往往不足的地方，使GAIA成为**基于智能体的系统**的理想基准，这些系统可以在多个步骤和模态上进行推理、检索和执行。

![GAIA capabilities plot](https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit4/gaia_capabilities.png)

## 实时评估

为了鼓励持续的基准测试，**GAIA在Hugging Face上提供了一个公共排行榜**，您可以在其中测试您的模型对**300个测试问题**的表现。

👉 在[这里](https://huggingface.co/spaces/gaia-benchmark/leaderboard)查看排行榜

<iframe
	src="https://gaia-benchmark-leaderboard.hf.space"
	frameborder="0"
	width="850"
	height="450"
></iframe>

想深入了解GAIA？

- 📄 [阅读完整论文](https://huggingface.co/papers/2311.12983)
- 📄 [OpenAI的深度研究发布文章](https://openai.com/index/introducing-deep-research/)
- 📄 [开源DeepResearch – 释放我们的搜索智能体](https://huggingface.co/blog/open-deep-research)

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit4/what-is-gaia.mdx" />