import{s as ut,o as ht,n as Me}from"../chunks/scheduler.36a0863c.js";import{S as Mt,i as jt,g as o,s as l,u,A as yt,h as i,f as e,c as n,j as I,v as h,y as d,k as w,o as T,a as t,w as M,d as j,t as y,x as f}from"../chunks/index.d0f7a4c4.js";import{T as Ja}from"../chunks/Tip.4c7d7eb1.js";import{Y as ft}from"../chunks/Youtube.d15bb502.js";import{I as ne}from"../chunks/IconCopyLink.bc5fad79.js";import{C as $}from"../chunks/CodeBlock.69433f87.js";import{F as mt,M as dt}from"../chunks/Markdown.1d1f160a.js";function gt(k){let p,g='Revisa la <a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">página de la tarea</a> de reconocimiento automático del habla para acceder a más información sobre los modelos, datasets y métricas asociados.';return{c(){p=o("p"),p.innerHTML=g},l(r){p=i(r,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1fx6n3a"&&(p.innerHTML=g)},m(r,J){t(r,p,J)},p:Me,d(r){r&&e(p)}}}function Jt(k){let p,g='Si no tienes experiencia haciéndole fine-tuning a un modelo con el <code>Trainer</code>, ¡échale un vistazo al tutorial básico <a href="../training#train-with-pytorch-trainer">aquí</a>!';return{c(){p=o("p"),p.innerHTML=g},l(r){p=i(r,"P",{"data-svelte-h":!0}),d(p)!=="svelte-llf0wi"&&(p.innerHTML=g)},m(r,J){t(r,p,J)},p:Me,d(r){r&&e(p)}}}function wt(k){let p,g,r,J="¡Ya puedes empezar a entrenar tu modelo! Para ello, carga Wav2Vec2 con <code>AutoModelForCTC</code>. Especifica la reducción que quieres aplicar con el parámetro <code>ctc_loss_reduction</code>. A menudo, es mejor usar el promedio en lugar de la sumatoria que se hace por defecto.",b,U,G,_,B="En este punto, solo quedan tres pasos:",X,R,E="<li>Define tus hiperparámetros de entrenamiento en <code>TrainingArguments</code>. El único parámetro obligatorio es <code>output_dir</code> (carpeta de salida), el cual especifica dónde guardar tu modelo. Puedes subir este modelo al Hub haciendo <code>push_to_hub=True</code> (debes haber iniciado sesión en Hugging Face para subir tu modelo). Al final de cada época, el <code>Trainer</code> evaluará la WER y guardará el punto de control del entrenamiento.</li> <li>Pásale los argumentos del entrenamiento al <code>Trainer</code> junto con el modelo, el dataset, el tokenizer, el collator de datos y la función <code>compute_metrics</code>.</li> <li>Llama el método <code>train()</code> para hacerle fine-tuning a tu modelo.</li>",W,C,Z,m,x="Una vez que el entrenamiento haya sido completado, comparte tu modelo en el Hub con el método <code>push_to_hub()</code> para que todo el mundo pueda usar tu modelo:",V,Y,N;return p=new Ja({props:{$$slots:{default:[Jt]},$$scope:{ctx:k}}}),U=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNUQyUyQyUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UlMjIlMkMlMEElMjAlMjAlMjAlMjBjdGNfbG9zc19yZWR1Y3Rpb24lM0QlMjJtZWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEcHJvY2Vzc29yLnRva2VuaXplci5wYWRfdG9rZW5faWQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCTC, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>,
<span class="hljs-meta">... </span>    ctc_loss_reduction=<span class="hljs-string">&quot;mean&quot;</span>,
<span class="hljs-meta">... </span>    pad_token_id=processor.tokenizer.pad_token_id,
<span class="hljs-meta">... </span>)`}}),C=new $({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJteV9hd2Vzb21lX2Fzcl9taW5kX21vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtNSUyQyUwQSUyMCUyMCUyMCUyMHdhcm11cF9zdGVwcyUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDIwMDAlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9jaGVja3BvaW50aW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JvdXBfYnlfbGVuZ3RoJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY19mb3JfYmVzdF9tb2RlbCUzRCUyMndlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGVuY29kZWRfbWluZHMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGVuY29kZWRfbWluZHMlNUIlMjJ0ZXN0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_asr_mind_model&quot;</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    warmup_steps=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>    max_steps=<span class="hljs-number">2000</span>,
<span class="hljs-meta">... </span>    gradient_checkpointing=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    group_by_length=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
<span class="hljs-meta">... </span>    greater_is_better=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=encoded_minds[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=encoded_minds[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    tokenizer=processor.feature_extractor,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`}}),Y=new $({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()'}}),{c(){u(p.$$.fragment),g=l(),r=o("p"),r.innerHTML=J,b=l(),u(U.$$.fragment),G=l(),_=o("p"),_.textContent=B,X=l(),R=o("ol"),R.innerHTML=E,W=l(),u(C.$$.fragment),Z=l(),m=o("p"),m.innerHTML=x,V=l(),u(Y.$$.fragment)},l(c){h(p.$$.fragment,c),g=n(c),r=i(c,"P",{"data-svelte-h":!0}),d(r)!=="svelte-s5u87n"&&(r.innerHTML=J),b=n(c),h(U.$$.fragment,c),G=n(c),_=i(c,"P",{"data-svelte-h":!0}),d(_)!=="svelte-bd5x35"&&(_.textContent=B),X=n(c),R=i(c,"OL",{"data-svelte-h":!0}),d(R)!=="svelte-19msr18"&&(R.innerHTML=E),W=n(c),h(C.$$.fragment,c),Z=n(c),m=i(c,"P",{"data-svelte-h":!0}),d(m)!=="svelte-1884cpm"&&(m.innerHTML=x),V=n(c),h(Y.$$.fragment,c)},m(c,v){M(p,c,v),t(c,g,v),t(c,r,v),t(c,b,v),M(U,c,v),t(c,G,v),t(c,_,v),t(c,X,v),t(c,R,v),t(c,W,v),M(C,c,v),t(c,Z,v),t(c,m,v),t(c,V,v),M(Y,c,v),N=!0},p(c,v){const ts={};v&2&&(ts.$$scope={dirty:v,ctx:c}),p.$set(ts)},i(c){N||(j(p.$$.fragment,c),j(U.$$.fragment,c),j(C.$$.fragment,c),j(Y.$$.fragment,c),N=!0)},o(c){y(p.$$.fragment,c),y(U.$$.fragment,c),y(C.$$.fragment,c),y(Y.$$.fragment,c),N=!1},d(c){c&&(e(g),e(r),e(b),e(G),e(_),e(X),e(R),e(W),e(Z),e(m),e(V)),f(p,c),f(U,c),f(C,c),f(Y,c)}}}function bt(k){let p,g;return p=new dt({props:{$$slots:{default:[wt]},$$scope:{ctx:k}}}),{c(){u(p.$$.fragment)},l(r){h(p.$$.fragment,r)},m(r,J){M(p,r,J),g=!0},p(r,J){const b={};J&2&&(b.$$scope={dirty:J,ctx:r}),p.$set(b)},i(r){g||(j(p.$$.fragment,r),g=!0)},o(r){y(p.$$.fragment,r),g=!1},d(r){f(p,r)}}}function Tt(k){let p,g='Para ver un ejemplo más detallado de cómo hacerle fine-tuning a un modelo para reconocimiento automático del habla, échale un vistazo a esta <a href="https://huggingface.co/blog/fine-tune-wav2vec2-english" rel="nofollow">entrada de blog</a> para ASR en inglés y a esta <a href="https://huggingface.co/blog/fine-tune-xlsr-wav2vec2" rel="nofollow">entrada</a> para ASR multilingüe.';return{c(){p=o("p"),p.innerHTML=g},l(r){p=i(r,"P",{"data-svelte-h":!0}),d(p)!=="svelte-mtqee0"&&(p.innerHTML=g)},m(r,J){t(r,p,J)},p:Me,d(r){r&&e(p)}}}function Ut(k){let p,g="La transcripción es decente, pero podría ser mejor. ¡Intenta hacerle fine-tuning a tu modelo con más ejemplos para obtener resultados aún mejores!";return{c(){p=o("p"),p.textContent=g},l(r){p=i(r,"P",{"data-svelte-h":!0}),d(p)!=="svelte-8zadbm"&&(p.textContent=g)},m(r,J){t(r,p,J)},p:Me,d(r){r&&e(p)}}}function $t(k){let p,g="Carga un procesador para preprocesar el archivo de audio y la transcripción y devuelve el <code>input</code> como un tensor de PyTorch:",r,J,b,U,G="Pásale tus entradas al modelo y devuelve los logits:",_,B,X,R,E="Obtén los identificadores de los tokens con mayor probabilidad en las predicciones y usa el procesador para decodificarlos y transformarlos en texto:",W,C,Z;return J=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRfbW9kZWwlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_asr_mind_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`}}),B=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNUQyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRfbW9kZWwlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;stevhliu/my_awesome_asr_mind_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits`}}),C=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwcmVkaWN0ZWRfaWRzJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription
[<span class="hljs-string">&#x27;I WOUL LIKE O SET UP JOINT ACOUNT WTH Y PARTNER&#x27;</span>]`}}),{c(){p=o("p"),p.innerHTML=g,r=l(),u(J.$$.fragment),b=l(),U=o("p"),U.textContent=G,_=l(),u(B.$$.fragment),X=l(),R=o("p"),R.textContent=E,W=l(),u(C.$$.fragment)},l(m){p=i(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-uqabxl"&&(p.innerHTML=g),r=n(m),h(J.$$.fragment,m),b=n(m),U=i(m,"P",{"data-svelte-h":!0}),d(U)!=="svelte-xfmo9s"&&(U.textContent=G),_=n(m),h(B.$$.fragment,m),X=n(m),R=i(m,"P",{"data-svelte-h":!0}),d(R)!=="svelte-ld7ycn"&&(R.textContent=E),W=n(m),h(C.$$.fragment,m)},m(m,x){t(m,p,x),t(m,r,x),M(J,m,x),t(m,b,x),t(m,U,x),t(m,_,x),M(B,m,x),t(m,X,x),t(m,R,x),t(m,W,x),M(C,m,x),Z=!0},p:Me,i(m){Z||(j(J.$$.fragment,m),j(B.$$.fragment,m),j(C.$$.fragment,m),Z=!0)},o(m){y(J.$$.fragment,m),y(B.$$.fragment,m),y(C.$$.fragment,m),Z=!1},d(m){m&&(e(p),e(r),e(b),e(U),e(_),e(X),e(R),e(W)),f(J,m),f(B,m),f(C,m)}}}function vt(k){let p,g;return p=new dt({props:{$$slots:{default:[$t]},$$scope:{ctx:k}}}),{c(){u(p.$$.fragment)},l(r){h(p.$$.fragment,r)},m(r,J){M(p,r,J),g=!0},p(r,J){const b={};J&2&&(b.$$scope={dirty:J,ctx:r}),p.$set(b)},i(r){g||(j(p.$$.fragment,r),g=!0)},o(r){y(p.$$.fragment,r),g=!1},d(r){f(p,r)}}}function _t(k){let p,g,r,J,b,U,G,_,B,X,R="Reconocimiento automático del habla",E,W,C,Z,m="El reconocimiento automático del habla (ASR, por sus siglas en inglés) convierte una señal de habla en texto y mapea una secuencia de entradas de audio en salidas en forma de texto. Los asistentes virtuales como Siri y Alexa usan modelos de ASR para ayudar a sus usuarios todos los días. De igual forma, hay muchas otras aplicaciones, como la transcripción de contenidos en vivo y la toma automática de notas durante reuniones.",x,V,Y="En esta guía te mostraremos como:",N,c,v='<li>Hacer fine-tuning al modelo <a href="https://huggingface.co/facebook/wav2vec2-base" rel="nofollow">Wav2Vec2</a> con el dataset <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> para transcribir audio a texto.</li> <li>Usar tu modelo ajustado para tareas de inferencia.</li>',ts,F,je,ls,va="Antes de comenzar, asegúrate de haber instalado todas las librerías necesarias:",ye,ns,fe,ps,_a="Te aconsejamos iniciar sesión con tu cuenta de Hugging Face para que puedas subir tu modelo y comartirlo con la comunidad. Cuando te sea solicitado, ingresa tu token para iniciar sesión:",ge,rs,Je,H,S,pe,os,wa,se,Ca="Cargar el dataset MInDS-14",we,is,Ia='Comencemos cargando un subconjunto más pequeño del dataset <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> desde la biblioteca 🤗 Datasets. De esta forma, tendrás la oportunidad de experimentar y asegurarte de que todo funcione antes de invertir más tiempo entrenando con el dataset entero.',be,cs,Te,ms,xa="Divide la partición <code>train</code> (entrenamiento) en una partición de entrenamiento y una de prueba usando el método <code>~Dataset.train_test_split</code>:",Ue,ds,$e,us,ka="Ahora échale un vistazo al dataset:",ve,hs,_e,Ms,Ra="Aunque el dataset contiene mucha información útil, como los campos <code>lang_id</code> (identificador del lenguaje) y <code>english_transcription</code> (transcripción al inglés), en esta guía nos enfocaremos en los campos <code>audio</code> y <code>transcription</code>. Puedes quitar las otras columnas con el método <code>remove_columns</code>:",Ce,js,Ie,ys,Wa="Vuelve a echarle un vistazo al ejemplo:",xe,fs,ke,gs,Za="Hay dos campos:",Re,Js,Xa="<li><code>audio</code>: un <code>array</code> (arreglo) unidimensional de la señal de habla que debe ser invocado para cargar y re-muestrear el archivo de audio.</li> <li><code>transcription</code>: el texto objetivo.</li>",We,z,P,re,ws,ba,ee,Ba="Preprocesamiento",Ze,bs,Ga="El siguiente paso es cargar un procesador Wav2Vec2 para procesar la señal de audio:",Xe,Ts,Be,Us,Va='El dataset MInDS-14 tiene una tasa de muestreo de 8000kHz (puedes encontrar esta información en su <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">tarjeta de dataset</a>), lo que significa que tendrás que re-muestrear el dataset a 16000kHz para poder usar el modelo Wav2Vec2 pre-entrenado:',Ge,$s,Ve,vs,Ea="Como puedes ver en el campo <code>transcription</code>, el texto contiene una mezcla de carácteres en mayúsculas y en minúsculas. El tokenizer Wav2Vec2 fue entrenado únicamente con carácteres en mayúsculas, así que tendrás que asegurarte de que el texto se ajuste al vocabulario del tokenizer:",Ee,_s,Ye,Cs,Ya="Ahora vamos a crear una función de preprocesamiento que:",Ne,Is,Na="<li>Invoque la columna <code>audio</code> para cargar y re-muestrear el archivo de audio.</li> <li>Extraiga el campo <code>input_values</code> (valores de entrada) del archivo de audio y haga la tokenización de la columna <code>transcription</code> con el procesador.</li>",He,xs,ze,ks,Ha="Para aplicar la función de preprocesamiento a todo el dataset, puedes usar la función <code>map</code> de 🤗 Datasets. Para acelerar la función <code>map</code> puedes incrementar el número de procesos con el parámetro <code>num_proc</code>. Quita las columnas que no necesites con el método <code>remove_columns</code>:",Ae,Rs,qe,Ws,za="🤗 Transformers no tiene un collator de datos para la tarea de ASR, así que tendrás que adaptar el <code>DataCollatorWithPadding</code> para crear un lote de ejemplos. El collator también le aplicará padding dinámico a tu texto y etiquetas para que tengan la longitud del elemento más largo en su lote (en vez de la mayor longitud en el dataset entero), de forma que todas las muestras tengan una longitud uniforme. Aunque es posible hacerle padding a tu texto con el <code>tokenizer</code> haciendo <code>padding=True</code>, el padding dinámico es más eficiente.",Qe,Zs,Aa="A diferencia de otros collators de datos, este tiene que aplicarle un método de padding distinto a los campos <code>input_values</code> (valores de entrada) y <code>labels</code> (etiquetas):",Fe,Xs,Se,Bs,qa="Ahora puedes instanciar tu <code>DataCollatorForCTCWithPadding</code>:",Pe,Gs,Le,A,L,oe,Vs,Ta,ae,Qa="Evaluación",De,Es,Fa='A menudo es útil incluir una métrica durante el entrenamiento para evaluar el rendimiento de tu modelo. Puedes cargar un método de evaluación rápidamente con la biblioteca 🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a>. Para esta tarea, puedes usar la métrica de <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">tasa de error por palabra</a> (WER, por sus siglas en inglés). Puedes ver la <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">guía rápida</a> de 🤗 Evaluate para aprender más acerca de cómo cargar y computar una métrica.',Ke,Ys,Oe,Ns,Sa="Ahora crea una función que le pase tus predicciones y etiquetas a <code>compute</code> para calcular la WER:",sa,Hs,ea,zs,Pa="Ahora tu función <code>compute_metrics</code> (computar métricas) está lista y podrás usarla cuando estés preparando tu entrenamiento.",aa,q,D,ie,As,Ua,te,La="Entrenamiento",ta,K,la,O,na,Q,ss,ce,qs,$a,le,Da="Inferencia",pa,Qs,Ka="¡Genial, ahora que le has hecho fine-tuning a un modelo, puedes usarlo para inferencia!",ra,Fs,Oa="Carga el archivo de audio sobre el cual quieras correr la inferencia. ¡Recuerda re-muestrar la tasa de muestreo del archivo de audio para que sea la misma del modelo si es necesario!",oa,Ss,ia,Ps,st="La manera más simple de probar tu modelo para hacer inferencia es usarlo en un <code>pipeline()</code>. Puedes instanciar un <code>pipeline</code> para reconocimiento automático del habla con tu modelo y pasarle tu archivo de audio:",ca,Ls,ma,es,da,Ds,et="También puedes replicar de forma manual los resultados del <code>pipeline</code> si lo deseas:",ua,as,ha,me,Ma;return _=new ne({}),W=new ft({props:{id:"TksaY_FDgnk"}}),F=new Ja({props:{$$slots:{default:[gt]},$$scope:{ctx:k}}}),ns=new $({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGUlMjBqaXdlcg==",highlighted:"pip install transformers datasets evaluate jiwer"}}),rs=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`}}),os=new ne({}),cs=new $({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwbmFtZSUzRCUyMmVuLVVTJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTEwMCU1RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train[:100]&quot;</span>)`}}),ds=new $({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.train_test_split(test_size=<span class="hljs-number">0.2</span>)'}}),hs=new $({props:{code:"bWluZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">16</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;transcription&#x27;</span>, <span class="hljs-string">&#x27;english_transcription&#x27;</span>, <span class="hljs-string">&#x27;intent_class&#x27;</span>, <span class="hljs-string">&#x27;lang_id&#x27;</span>],
        num_rows: <span class="hljs-number">4</span>
    })
})`}}),js=new $({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyglNUIlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJsYW5nX2lkJTIyJTVEKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.remove_columns([<span class="hljs-string">&quot;english_transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;lang_id&quot;</span>])'}}),fs=new $({props:{code:"bWluZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([-<span class="hljs-number">0.00024414</span>,  <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.</span>        , ...,  <span class="hljs-number">0.00024414</span>,
          <span class="hljs-number">0.00024414</span>,  <span class="hljs-number">0.00024414</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">8000</span>},
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
 <span class="hljs-string">&#x27;transcription&#x27;</span>: <span class="hljs-string">&quot;hi I&#x27;m trying to use the banking app on my phone and currently my checking and savings account balance is not refreshing&quot;</span>}`}}),ws=new ne({}),Ts=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base&quot;</span>)`}}),$s=new $({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5jYXN0X2NvbHVtbiglMjJhdWRpbyUyMiUyQyUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0QxNl8wMDApKSUwQW1pbmRzJTVCJTIydHJhaW4lMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>minds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;audio&#x27;</span>: {<span class="hljs-string">&#x27;array&#x27;</span>: array([-<span class="hljs-number">2.38064706e-04</span>, -<span class="hljs-number">1.58618059e-04</span>, -<span class="hljs-number">5.43987835e-06</span>, ...,
          <span class="hljs-number">2.78103951e-04</span>,  <span class="hljs-number">2.38446111e-04</span>,  <span class="hljs-number">1.18740834e-04</span>], dtype=float32),
  <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
  <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>},
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~APP_ERROR/602ba9e2963e11ccd901cd4f.wav&#x27;</span>,
 <span class="hljs-string">&#x27;transcription&#x27;</span>: <span class="hljs-string">&quot;hi I&#x27;m trying to use the banking app on my phone and currently my checking and savings account balance is not refreshing&quot;</span>}`}}),_s=new $({props:{code:"ZGVmJTIwdXBwZXJjYXNlKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMGV4YW1wbGUlNUIlMjJ0cmFuc2NyaXB0aW9uJTIyJTVELnVwcGVyKCklN0QlMEElMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLm1hcCh1cHBlcmNhc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">uppercase</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;transcription&quot;</span>: example[<span class="hljs-string">&quot;transcription&quot;</span>].upper()}


<span class="hljs-meta">&gt;&gt;&gt; </span>minds = minds.<span class="hljs-built_in">map</span>(uppercase)`}}),xs=new $({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwYmF0Y2glNUIlMjJhdWRpbyUyMiU1RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwdGV4dCUzRGJhdGNoJTVCJTIydHJhbnNjcmlwdGlvbiUyMiU1RCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyMCUzRCUyMGxlbihiYXRjaCU1QiUyMmlucHV0X3ZhbHVlcyUyMiU1RCU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    audio = batch[<span class="hljs-string">&quot;audio&quot;</span>]
<span class="hljs-meta">... </span>    batch = processor(audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], text=batch[<span class="hljs-string">&quot;transcription&quot;</span>])
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(batch[<span class="hljs-string">&quot;input_values&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch`}}),Rs=new $({props:{code:"ZW5jb2RlZF9taW5kcyUyMCUzRCUyMG1pbmRzLm1hcChwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRG1pbmRzLmNvbHVtbl9uYW1lcyU1QiUyMnRyYWluJTIyJTVEJTJDJTIwbnVtX3Byb2MlM0Q0KQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=minds.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">4</span>)'}}),Xs=new $({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorCTCWithPadding</span>:
<span class="hljs-meta">... </span>    processor: AutoProcessor
<span class="hljs-meta">... </span>    padding: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bool</span>, <span class="hljs-built_in">str</span>] = <span class="hljs-string">&quot;longest&quot;</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
<span class="hljs-meta">... </span>        <span class="hljs-comment"># particiona las entradas y las etiquetas ya que tienen que tener longitudes distintas y</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># requieren métodos de padding diferentes</span>
<span class="hljs-meta">... </span>        input_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;input_values&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

<span class="hljs-meta">... </span>        batch = self.processor.pad(input_features, padding=self.padding, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        labels_batch = self.processor.pad(labels=label_features, padding=self.padding, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># remplaza el padding con -100 para ignorar la pérdida de forma correcta</span>
<span class="hljs-meta">... </span>        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`}}),Gs=new $({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckNUQ1dpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3NvciUyQyUyMHBhZGRpbmclM0QlMjJsb25nZXN0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DataCollatorCTCWithPadding(processor=processor, padding=<span class="hljs-string">&quot;longest&quot;</span>)'}}),Vs=new ne({}),Ys=new $({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEF3ZXIlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>wer = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`}}),Hs=new $({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKHByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZF9sb2dpdHMlMjAlM0QlMjBwcmVkLnByZWRpY3Rpb25zJTBBJTIwJTIwJTIwJTIwcHJlZF9pZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZF9sb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTBBJTIwJTIwJTIwJTIwcHJlZC5sYWJlbF9pZHMlNUJwcmVkLmxhYmVsX2lkcyUyMCUzRCUzRCUyMC0xMDAlNUQlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLnBhZF90b2tlbl9pZCUwQSUwQSUyMCUyMCUyMCUyMHByZWRfc3RyJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkX2lkcyklMEElMjAlMjAlMjAlMjBsYWJlbF9zdHIlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWQubGFiZWxfaWRzJTJDJTIwZ3JvdXBfdG9rZW5zJTNERmFsc2UpJTBBJTBBJTIwJTIwJTIwJTIwd2VyJTIwJTNEJTIwd2VyLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkX3N0ciUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbF9zdHIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyd2VyJTIyJTNBJTIwd2VyJTdE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
<span class="hljs-meta">... </span>    pred_logits = pred.predictions
<span class="hljs-meta">... </span>    pred_ids = np.argmax(pred_logits, axis=-<span class="hljs-number">1</span>)

<span class="hljs-meta">... </span>    pred.label_ids[pred.label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

<span class="hljs-meta">... </span>    pred_str = processor.batch_decode(pred_ids)
<span class="hljs-meta">... </span>    label_str = processor.batch_decode(pred.label_ids, group_tokens=<span class="hljs-literal">False</span>)

<span class="hljs-meta">... </span>    wer = wer.compute(predictions=pred_str, references=label_str)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer&quot;</span>: wer}`}}),As=new ne({}),K=new mt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[bt]},$$scope:{ctx:k}}}),O=new Ja({props:{$$slots:{default:[Tt]},$$scope:{ctx:k}}}),qs=new ne({}),Ss=new $({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMlBvbHlBSSUyRm1pbmRzMTQlMjIlMkMlMjAlMjJlbi1VUyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQWF1ZGlvX2ZpbGUlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIycGF0aCUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, <span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_file = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;path&quot;</span>]`}}),Ls=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzdGV2aGxpdSUyRm15X2F3ZXNvbWVfYXNyX21pbmRzX21vZGVsJTIyKSUwQXRyYW5zY3JpYmVyKGF1ZGlvX2ZpbGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;stevhliu/my_awesome_asr_minds_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(audio_file)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I WOUD LIKE O SET UP JOINT ACOUNT WTH Y PARTNER&#x27;</span>}`}}),es=new Ja({props:{$$slots:{default:[Ut]},$$scope:{ctx:k}}}),as=new mt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[vt]},$$scope:{ctx:k}}}),{c(){p=o("meta"),g=l(),r=o("p"),J=l(),b=o("h1"),U=o("a"),G=o("span"),u(_.$$.fragment),B=l(),X=o("span"),X.textContent=R,E=l(),u(W.$$.fragment),C=l(),Z=o("p"),Z.textContent=m,x=l(),V=o("p"),V.textContent=Y,N=l(),c=o("ol"),c.innerHTML=v,ts=l(),u(F.$$.fragment),je=l(),ls=o("p"),ls.textContent=va,ye=l(),u(ns.$$.fragment),fe=l(),ps=o("p"),ps.textContent=_a,ge=l(),u(rs.$$.fragment),Je=l(),H=o("h2"),S=o("a"),pe=o("span"),u(os.$$.fragment),wa=l(),se=o("span"),se.textContent=Ca,we=l(),is=o("p"),is.innerHTML=Ia,be=l(),u(cs.$$.fragment),Te=l(),ms=o("p"),ms.innerHTML=xa,Ue=l(),u(ds.$$.fragment),$e=l(),us=o("p"),us.textContent=ka,ve=l(),u(hs.$$.fragment),_e=l(),Ms=o("p"),Ms.innerHTML=Ra,Ce=l(),u(js.$$.fragment),Ie=l(),ys=o("p"),ys.textContent=Wa,xe=l(),u(fs.$$.fragment),ke=l(),gs=o("p"),gs.textContent=Za,Re=l(),Js=o("ul"),Js.innerHTML=Xa,We=l(),z=o("h2"),P=o("a"),re=o("span"),u(ws.$$.fragment),ba=l(),ee=o("span"),ee.textContent=Ba,Ze=l(),bs=o("p"),bs.textContent=Ga,Xe=l(),u(Ts.$$.fragment),Be=l(),Us=o("p"),Us.innerHTML=Va,Ge=l(),u($s.$$.fragment),Ve=l(),vs=o("p"),vs.innerHTML=Ea,Ee=l(),u(_s.$$.fragment),Ye=l(),Cs=o("p"),Cs.textContent=Ya,Ne=l(),Is=o("ol"),Is.innerHTML=Na,He=l(),u(xs.$$.fragment),ze=l(),ks=o("p"),ks.innerHTML=Ha,Ae=l(),u(Rs.$$.fragment),qe=l(),Ws=o("p"),Ws.innerHTML=za,Qe=l(),Zs=o("p"),Zs.innerHTML=Aa,Fe=l(),u(Xs.$$.fragment),Se=l(),Bs=o("p"),Bs.innerHTML=qa,Pe=l(),u(Gs.$$.fragment),Le=l(),A=o("h2"),L=o("a"),oe=o("span"),u(Vs.$$.fragment),Ta=l(),ae=o("span"),ae.textContent=Qa,De=l(),Es=o("p"),Es.innerHTML=Fa,Ke=l(),u(Ys.$$.fragment),Oe=l(),Ns=o("p"),Ns.innerHTML=Sa,sa=l(),u(Hs.$$.fragment),ea=l(),zs=o("p"),zs.innerHTML=Pa,aa=l(),q=o("h2"),D=o("a"),ie=o("span"),u(As.$$.fragment),Ua=l(),te=o("span"),te.textContent=La,ta=l(),u(K.$$.fragment),la=l(),u(O.$$.fragment),na=l(),Q=o("h2"),ss=o("a"),ce=o("span"),u(qs.$$.fragment),$a=l(),le=o("span"),le.textContent=Da,pa=l(),Qs=o("p"),Qs.textContent=Ka,ra=l(),Fs=o("p"),Fs.textContent=Oa,oa=l(),u(Ss.$$.fragment),ia=l(),Ps=o("p"),Ps.innerHTML=st,ca=l(),u(Ls.$$.fragment),ma=l(),u(es.$$.fragment),da=l(),Ds=o("p"),Ds.innerHTML=et,ua=l(),u(as.$$.fragment),ha=l(),me=o("p"),this.h()},l(s){const a=yt("svelte-1phssyn",document.head);p=i(a,"META",{name:!0,content:!0}),a.forEach(e),g=n(s),r=i(s,"P",{}),I(r).forEach(e),J=n(s),b=i(s,"H1",{class:!0});var Ks=I(b);U=i(Ks,"A",{id:!0,class:!0,href:!0});var de=I(U);G=i(de,"SPAN",{});var ue=I(G);h(_.$$.fragment,ue),ue.forEach(e),de.forEach(e),B=n(Ks),X=i(Ks,"SPAN",{"data-svelte-h":!0}),d(X)!=="svelte-psqvty"&&(X.textContent=R),Ks.forEach(e),E=n(s),h(W.$$.fragment,s),C=n(s),Z=i(s,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-epcgmo"&&(Z.textContent=m),x=n(s),V=i(s,"P",{"data-svelte-h":!0}),d(V)!=="svelte-cz2yfj"&&(V.textContent=Y),N=n(s),c=i(s,"OL",{"data-svelte-h":!0}),d(c)!=="svelte-15cr61c"&&(c.innerHTML=v),ts=n(s),h(F.$$.fragment,s),je=n(s),ls=i(s,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-dzv42z"&&(ls.textContent=va),ye=n(s),h(ns.$$.fragment,s),fe=n(s),ps=i(s,"P",{"data-svelte-h":!0}),d(ps)!=="svelte-1cq1w7n"&&(ps.textContent=_a),ge=n(s),h(rs.$$.fragment,s),Je=n(s),H=i(s,"H2",{class:!0});var Os=I(H);S=i(Os,"A",{id:!0,class:!0,href:!0});var he=I(S);pe=i(he,"SPAN",{});var at=I(pe);h(os.$$.fragment,at),at.forEach(e),he.forEach(e),wa=n(Os),se=i(Os,"SPAN",{"data-svelte-h":!0}),d(se)!=="svelte-y3kpqz"&&(se.textContent=Ca),Os.forEach(e),we=n(s),is=i(s,"P",{"data-svelte-h":!0}),d(is)!=="svelte-1xjdzog"&&(is.innerHTML=Ia),be=n(s),h(cs.$$.fragment,s),Te=n(s),ms=i(s,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-1mkamtr"&&(ms.innerHTML=xa),Ue=n(s),h(ds.$$.fragment,s),$e=n(s),us=i(s,"P",{"data-svelte-h":!0}),d(us)!=="svelte-1br3wmv"&&(us.textContent=ka),ve=n(s),h(hs.$$.fragment,s),_e=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),d(Ms)!=="svelte-17zedvp"&&(Ms.innerHTML=Ra),Ce=n(s),h(js.$$.fragment,s),Ie=n(s),ys=i(s,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-et2cmw"&&(ys.textContent=Wa),xe=n(s),h(fs.$$.fragment,s),ke=n(s),gs=i(s,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-1829lf7"&&(gs.textContent=Za),Re=n(s),Js=i(s,"UL",{"data-svelte-h":!0}),d(Js)!=="svelte-1hsf2hk"&&(Js.innerHTML=Xa),We=n(s),z=i(s,"H2",{class:!0});var ja=I(z);P=i(ja,"A",{id:!0,class:!0,href:!0});var tt=I(P);re=i(tt,"SPAN",{});var lt=I(re);h(ws.$$.fragment,lt),lt.forEach(e),tt.forEach(e),ba=n(ja),ee=i(ja,"SPAN",{"data-svelte-h":!0}),d(ee)!=="svelte-klvb09"&&(ee.textContent=Ba),ja.forEach(e),Ze=n(s),bs=i(s,"P",{"data-svelte-h":!0}),d(bs)!=="svelte-1g0fsgx"&&(bs.textContent=Ga),Xe=n(s),h(Ts.$$.fragment,s),Be=n(s),Us=i(s,"P",{"data-svelte-h":!0}),d(Us)!=="svelte-1mv5akl"&&(Us.innerHTML=Va),Ge=n(s),h($s.$$.fragment,s),Ve=n(s),vs=i(s,"P",{"data-svelte-h":!0}),d(vs)!=="svelte-12xa7sk"&&(vs.innerHTML=Ea),Ee=n(s),h(_s.$$.fragment,s),Ye=n(s),Cs=i(s,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-vbsdut"&&(Cs.textContent=Ya),Ne=n(s),Is=i(s,"OL",{"data-svelte-h":!0}),d(Is)!=="svelte-1exh166"&&(Is.innerHTML=Na),He=n(s),h(xs.$$.fragment,s),ze=n(s),ks=i(s,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-61w3lz"&&(ks.innerHTML=Ha),Ae=n(s),h(Rs.$$.fragment,s),qe=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),d(Ws)!=="svelte-162z1az"&&(Ws.innerHTML=za),Qe=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-1uop6u5"&&(Zs.innerHTML=Aa),Fe=n(s),h(Xs.$$.fragment,s),Se=n(s),Bs=i(s,"P",{"data-svelte-h":!0}),d(Bs)!=="svelte-tdpb5h"&&(Bs.innerHTML=qa),Pe=n(s),h(Gs.$$.fragment,s),Le=n(s),A=i(s,"H2",{class:!0});var ya=I(A);L=i(ya,"A",{id:!0,class:!0,href:!0});var nt=I(L);oe=i(nt,"SPAN",{});var pt=I(oe);h(Vs.$$.fragment,pt),pt.forEach(e),nt.forEach(e),Ta=n(ya),ae=i(ya,"SPAN",{"data-svelte-h":!0}),d(ae)!=="svelte-1uzk3ci"&&(ae.textContent=Qa),ya.forEach(e),De=n(s),Es=i(s,"P",{"data-svelte-h":!0}),d(Es)!=="svelte-17q3xd7"&&(Es.innerHTML=Fa),Ke=n(s),h(Ys.$$.fragment,s),Oe=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-yu81ac"&&(Ns.innerHTML=Sa),sa=n(s),h(Hs.$$.fragment,s),ea=n(s),zs=i(s,"P",{"data-svelte-h":!0}),d(zs)!=="svelte-1sl6wg0"&&(zs.innerHTML=Pa),aa=n(s),q=i(s,"H2",{class:!0});var fa=I(q);D=i(fa,"A",{id:!0,class:!0,href:!0});var rt=I(D);ie=i(rt,"SPAN",{});var ot=I(ie);h(As.$$.fragment,ot),ot.forEach(e),rt.forEach(e),Ua=n(fa),te=i(fa,"SPAN",{"data-svelte-h":!0}),d(te)!=="svelte-1b8djky"&&(te.textContent=La),fa.forEach(e),ta=n(s),h(K.$$.fragment,s),la=n(s),h(O.$$.fragment,s),na=n(s),Q=i(s,"H2",{class:!0});var ga=I(Q);ss=i(ga,"A",{id:!0,class:!0,href:!0});var it=I(ss);ce=i(it,"SPAN",{});var ct=I(ce);h(qs.$$.fragment,ct),ct.forEach(e),it.forEach(e),$a=n(ga),le=i(ga,"SPAN",{"data-svelte-h":!0}),d(le)!=="svelte-1y1q1cz"&&(le.textContent=Da),ga.forEach(e),pa=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-1w5qtze"&&(Qs.textContent=Ka),ra=n(s),Fs=i(s,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-1tpt1c6"&&(Fs.textContent=Oa),oa=n(s),h(Ss.$$.fragment,s),ia=n(s),Ps=i(s,"P",{"data-svelte-h":!0}),d(Ps)!=="svelte-1kz9iuo"&&(Ps.innerHTML=st),ca=n(s),h(Ls.$$.fragment,s),ma=n(s),h(es.$$.fragment,s),da=n(s),Ds=i(s,"P",{"data-svelte-h":!0}),d(Ds)!=="svelte-o5jka0"&&(Ds.innerHTML=et),ua=n(s),h(as.$$.fragment,s),ha=n(s),me=i(s,"P",{}),I(me).forEach(e),this.h()},h(){w(p,"name","hf:doc:metadata"),w(p,"content",JSON.stringify(Ct)),w(U,"id","reconocimiento-automtico-del-habla"),w(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(U,"href","#reconocimiento-automtico-del-habla"),w(b,"class","relative group"),w(S,"id","cargar-el-dataset-minds14"),w(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(S,"href","#cargar-el-dataset-minds14"),w(H,"class","relative group"),w(P,"id","preprocesamiento"),w(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(P,"href","#preprocesamiento"),w(z,"class","relative group"),w(L,"id","evaluacin"),w(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(L,"href","#evaluacin"),w(A,"class","relative group"),w(D,"id","entrenamiento"),w(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(D,"href","#entrenamiento"),w(q,"class","relative group"),w(ss,"id","inferencia"),w(ss,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),w(ss,"href","#inferencia"),w(Q,"class","relative group")},m(s,a){T(document.head,p),t(s,g,a),t(s,r,a),t(s,J,a),t(s,b,a),T(b,U),T(U,G),M(_,G,null),T(b,B),T(b,X),t(s,E,a),M(W,s,a),t(s,C,a),t(s,Z,a),t(s,x,a),t(s,V,a),t(s,N,a),t(s,c,a),t(s,ts,a),M(F,s,a),t(s,je,a),t(s,ls,a),t(s,ye,a),M(ns,s,a),t(s,fe,a),t(s,ps,a),t(s,ge,a),M(rs,s,a),t(s,Je,a),t(s,H,a),T(H,S),T(S,pe),M(os,pe,null),T(H,wa),T(H,se),t(s,we,a),t(s,is,a),t(s,be,a),M(cs,s,a),t(s,Te,a),t(s,ms,a),t(s,Ue,a),M(ds,s,a),t(s,$e,a),t(s,us,a),t(s,ve,a),M(hs,s,a),t(s,_e,a),t(s,Ms,a),t(s,Ce,a),M(js,s,a),t(s,Ie,a),t(s,ys,a),t(s,xe,a),M(fs,s,a),t(s,ke,a),t(s,gs,a),t(s,Re,a),t(s,Js,a),t(s,We,a),t(s,z,a),T(z,P),T(P,re),M(ws,re,null),T(z,ba),T(z,ee),t(s,Ze,a),t(s,bs,a),t(s,Xe,a),M(Ts,s,a),t(s,Be,a),t(s,Us,a),t(s,Ge,a),M($s,s,a),t(s,Ve,a),t(s,vs,a),t(s,Ee,a),M(_s,s,a),t(s,Ye,a),t(s,Cs,a),t(s,Ne,a),t(s,Is,a),t(s,He,a),M(xs,s,a),t(s,ze,a),t(s,ks,a),t(s,Ae,a),M(Rs,s,a),t(s,qe,a),t(s,Ws,a),t(s,Qe,a),t(s,Zs,a),t(s,Fe,a),M(Xs,s,a),t(s,Se,a),t(s,Bs,a),t(s,Pe,a),M(Gs,s,a),t(s,Le,a),t(s,A,a),T(A,L),T(L,oe),M(Vs,oe,null),T(A,Ta),T(A,ae),t(s,De,a),t(s,Es,a),t(s,Ke,a),M(Ys,s,a),t(s,Oe,a),t(s,Ns,a),t(s,sa,a),M(Hs,s,a),t(s,ea,a),t(s,zs,a),t(s,aa,a),t(s,q,a),T(q,D),T(D,ie),M(As,ie,null),T(q,Ua),T(q,te),t(s,ta,a),M(K,s,a),t(s,la,a),M(O,s,a),t(s,na,a),t(s,Q,a),T(Q,ss),T(ss,ce),M(qs,ce,null),T(Q,$a),T(Q,le),t(s,pa,a),t(s,Qs,a),t(s,ra,a),t(s,Fs,a),t(s,oa,a),M(Ss,s,a),t(s,ia,a),t(s,Ps,a),t(s,ca,a),M(Ls,s,a),t(s,ma,a),M(es,s,a),t(s,da,a),t(s,Ds,a),t(s,ua,a),M(as,s,a),t(s,ha,a),t(s,me,a),Ma=!0},p(s,[a]){const Ks={};a&2&&(Ks.$$scope={dirty:a,ctx:s}),F.$set(Ks);const de={};a&2&&(de.$$scope={dirty:a,ctx:s}),K.$set(de);const ue={};a&2&&(ue.$$scope={dirty:a,ctx:s}),O.$set(ue);const Os={};a&2&&(Os.$$scope={dirty:a,ctx:s}),es.$set(Os);const he={};a&2&&(he.$$scope={dirty:a,ctx:s}),as.$set(he)},i(s){Ma||(j(_.$$.fragment,s),j(W.$$.fragment,s),j(F.$$.fragment,s),j(ns.$$.fragment,s),j(rs.$$.fragment,s),j(os.$$.fragment,s),j(cs.$$.fragment,s),j(ds.$$.fragment,s),j(hs.$$.fragment,s),j(js.$$.fragment,s),j(fs.$$.fragment,s),j(ws.$$.fragment,s),j(Ts.$$.fragment,s),j($s.$$.fragment,s),j(_s.$$.fragment,s),j(xs.$$.fragment,s),j(Rs.$$.fragment,s),j(Xs.$$.fragment,s),j(Gs.$$.fragment,s),j(Vs.$$.fragment,s),j(Ys.$$.fragment,s),j(Hs.$$.fragment,s),j(As.$$.fragment,s),j(K.$$.fragment,s),j(O.$$.fragment,s),j(qs.$$.fragment,s),j(Ss.$$.fragment,s),j(Ls.$$.fragment,s),j(es.$$.fragment,s),j(as.$$.fragment,s),Ma=!0)},o(s){y(_.$$.fragment,s),y(W.$$.fragment,s),y(F.$$.fragment,s),y(ns.$$.fragment,s),y(rs.$$.fragment,s),y(os.$$.fragment,s),y(cs.$$.fragment,s),y(ds.$$.fragment,s),y(hs.$$.fragment,s),y(js.$$.fragment,s),y(fs.$$.fragment,s),y(ws.$$.fragment,s),y(Ts.$$.fragment,s),y($s.$$.fragment,s),y(_s.$$.fragment,s),y(xs.$$.fragment,s),y(Rs.$$.fragment,s),y(Xs.$$.fragment,s),y(Gs.$$.fragment,s),y(Vs.$$.fragment,s),y(Ys.$$.fragment,s),y(Hs.$$.fragment,s),y(As.$$.fragment,s),y(K.$$.fragment,s),y(O.$$.fragment,s),y(qs.$$.fragment,s),y(Ss.$$.fragment,s),y(Ls.$$.fragment,s),y(es.$$.fragment,s),y(as.$$.fragment,s),Ma=!1},d(s){s&&(e(g),e(r),e(J),e(b),e(E),e(C),e(Z),e(x),e(V),e(N),e(c),e(ts),e(je),e(ls),e(ye),e(fe),e(ps),e(ge),e(Je),e(H),e(we),e(is),e(be),e(Te),e(ms),e(Ue),e($e),e(us),e(ve),e(_e),e(Ms),e(Ce),e(Ie),e(ys),e(xe),e(ke),e(gs),e(Re),e(Js),e(We),e(z),e(Ze),e(bs),e(Xe),e(Be),e(Us),e(Ge),e(Ve),e(vs),e(Ee),e(Ye),e(Cs),e(Ne),e(Is),e(He),e(ze),e(ks),e(Ae),e(qe),e(Ws),e(Qe),e(Zs),e(Fe),e(Se),e(Bs),e(Pe),e(Le),e(A),e(De),e(Es),e(Ke),e(Oe),e(Ns),e(sa),e(ea),e(zs),e(aa),e(q),e(ta),e(la),e(na),e(Q),e(pa),e(Qs),e(ra),e(Fs),e(oa),e(ia),e(Ps),e(ca),e(ma),e(da),e(Ds),e(ua),e(ha),e(me)),e(p),f(_),f(W,s),f(F,s),f(ns,s),f(rs,s),f(os),f(cs,s),f(ds,s),f(hs,s),f(js,s),f(fs,s),f(ws),f(Ts,s),f($s,s),f(_s,s),f(xs,s),f(Rs,s),f(Xs,s),f(Gs,s),f(Vs),f(Ys,s),f(Hs,s),f(As),f(K,s),f(O,s),f(qs),f(Ss,s),f(Ls,s),f(es,s),f(as,s)}}}const Ct={local:"reconocimiento-automtico-del-habla",sections:[{local:"cargar-el-dataset-minds14",title:"Cargar el dataset MInDS-14"},{local:"preprocesamiento",title:"Preprocesamiento"},{local:"evaluacin",title:"Evaluación"},{local:"entrenamiento",title:"Entrenamiento"},{local:"inferencia",title:"Inferencia"}],title:"Reconocimiento automático del habla"};function It(k){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gt extends Mt{constructor(p){super(),jt(this,p,It,_t,ut,{})}}export{Gt as component};
