import{s as A$,o as Y$,n as U}from"../chunks/scheduler.9bc65507.js";import{S as K$,i as ew,g as r,s,r as l,A as tw,h as a,f as n,c as o,j as _,u as d,x as y,k as b,y as t,a as c,v as p,d as m,t as g,w as u}from"../chunks/index.707bf1b6.js";import{T as Cn}from"../chunks/Tip.c2ecdbf4.js";import{D as T}from"../chunks/Docstring.17db21ae.js";import{C}from"../chunks/CodeBlock.54a9f38d.js";import{E as P}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as E}from"../chunks/Heading.342b1fa6.js";function nw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBlcHNpbG9uJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMjBOb3RlJTIwdGhhdCUyMHRoaXMlMjBpcyUyMHNpbWlsYXIlMjB0byUwQSUyMyUyMFRvcCUyMFAlMjBzYW1wbGluZyUyQyUyMHdoaWNoJTIwcmVzdHJpY3RzJTIwdG9rZW5zJTIwYmFzZWQlMjBvbiUyMHRoZWlyJTIwY3VtdWxhdGl2ZSUyMHByb2JhYmlsaXR5LiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBlcHNpbG9uX2N1dG9mZiU2MCUyMHZhbHVlcyUyMGJldHdlZW4lMjAzZS00JTIwYW5kJTIwOWUtNCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBlcHNpbG9uX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function sw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBldGElMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyMFlvdSUyMGNhbiUyMHNlZSUyMGl0JTIwYXMlMjBhJTIwZHluYW1pYyUyMGZvcm0lMjBvZiUwQSUyMyUyMGVwc2lsb24lMjBzYW1wbGluZyUyMHRoYXQlMjBhZGFwdHMlMjBpdHMlMjBjdXRvZmYlMjBwcm9iYWJpbGl0eSUyMGJhc2VkJTIwb24lMjB0aGUlMjBlbnRyb3B5JTIwKGhpZ2glMjBlbnRyb3B5JTIwJTNEJTIwbG93ZXIlMjBjdXRvZmYpLiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBldGFfY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjB0byUyMDRlLTMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZXRhX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function ow(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate sequences without exponential penalty. We want short sentences, so we limit max_length=30</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see that the answer tends to end abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I<span class="hljs-string">&#x27;m not even a lawyer. I&#x27;</span>m a man. I have no real knowledge of politics. I<span class="hljs-string">&#x27;m a

&gt;&gt;&gt; # Generate sequences with exponential penalty, we add the exponential_decay_length_penalty=(start_index, decay_factor)
&gt;&gt;&gt; # We see that instead of cutting at max_tokens, the output comes to an end before (at 25 tokens) and with more meaning
&gt;&gt;&gt; # What happens is that starting from \`start_index\` the EOS token score will be increased by decay_factor exponentially
&gt;&gt;&gt; outputs = model.generate(
...     **inputs,
...     do_sample=True,
...     temperature=0.9,
...     max_length=30,
...     pad_token_id=50256,
...     exponential_decay_length_penalty=(15, 1.6),
... )
&gt;&gt;&gt; print(tokenizer.batch_decode(outputs)[0])
Just wanted to let you know, I&#x27;</span>ve got a very cool t-shirt educating people on how to use the Internet&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate sequences with smaller decay_factor, still improving the hard cutoff mid-sentence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.05</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I<span class="hljs-string">&#x27;ve been working on it for about 6 months and now it&#x27;</span>s <span class="hljs-keyword">in</span> Alpha.&lt;|endoftext|&gt;`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function rw(M){let f,x=`Diverse beam search can be particularly useful in scenarios where a variety of different outputs is desired, rather
than multiple similar sequences. It allows the model to explore different generation paths and provides a broader
coverage of possible outputs.`;return{c(){f=r("p"),f.textContent=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-xttj3z"&&(f.textContent=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function aw(M){let f,x="This logits processor can be resource-intensive, especially when using large models or long sequences.";return{c(){f=r("p"),f.textContent=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-6lf7c0"&&(f.textContent=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function iw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function cw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwSWYlMjB0aGUlMjBtYXhpbXVtJTIwbGVuZ3RoJTIwKGRlZmF1bHQlMjAlM0QlMjAyMCklMjBpcyUyMHNtYWxsZXIlMjB0aGFuJTIwdGhlJTIwbWluaW11bSUyMGxlbmd0aCUyMGNvbnN0cmFpbnQlMkMlMjB0aGUlMjBsYXR0ZXIlMjBpcyUyMGlnbm9yZWQhJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX25ld190b2tlbnMlM0QzMCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEZvciUyMHRlc3RpbmclMjBwdXJwb3NlcyUyQyUyMGxldCdzJTIwc2V0JTIwJTYwZW9zX3Rva2VuJTYwJTIwdG8lMjAlNjAlMjJjb21wYW55JTIyJTYwJTJDJTIwdGhlJTIwZmlyc3QlMjBnZW5lcmF0ZWQlMjB0b2tlbi4lMjBUaGlzJTIwd2lsbCUyMG1ha2UlMEElMjMlMjBnZW5lcmF0aW9uJTIwZW5kJTIwdGhlcmUuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZW9zX3Rva2VuX2lkJTNEMTY2NCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEluY3JlYXNpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBtYWtlJTIwZ2VuZXJhdGlvbiUyMGlnbm9yZSUyMG9jY3VyZW5jZXMlMjAlNjAlMjJjb21wYW55JTIyJTYwJTIwKGVvcyUyMHRva2VuKSUyMGJlZm9yZSUyMHRoZSUwQSUyMyUyMG1pbmltdW0lMjBsZW5ndGglMjBjb25kaXRpb24lMjBpcyUyMGhvbm9yZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX25ld190b2tlbnMlM0QyJTJDJTIwZW9zX3Rva2VuX2lkJTNEMTY2NCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If the maximum length (default = 20) is smaller than the minimum length constraint, the latter is ignored!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, min_new_tokens=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company that has been working on a new product <span class="hljs-keyword">for</span> the past year.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For testing purposes, let&#x27;s set \`eos_token\` to \`&quot;company&quot;\`, the first generated token. This will make</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generation end there.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Increasing \`min_new_tokens\` will make generation ignore occurences \`&quot;company&quot;\` (eos token) before the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># minimum length condition is honored.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a new company`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function lw(M){let f,x=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){f=r("p"),f.innerHTML=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-15bvr1j"&&(f.innerHTML=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function dw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function pw(M){let f,x=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){f=r("p"),f.innerHTML=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-5zfsi9"&&(f.innerHTML=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function mw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMjBJJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTBBJTIzJTIwTm93JTIwbGV0J3MlMjBhZGQlMjBuZ3JhbSUyMHNpemUlMjB1c2luZyUyMCU2MG5vX3JlcGVhdF9uZ3JhbV9zaXplJTYwLiUyMFRoaXMlMjBzdG9wcyUyMHRoZSUyMHJlcGV0aXRpb25zJTIwKCUyMkklRTIlODAlOTltJTIyKSUyMGluJTIwdGhlJTIwb3V0cHV0LiUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0QyKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function gw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkknbSUyMG5vdCUyMGdvaW5nJTIwdG8lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRoaXMlMjBzaG93cyUyMGElMjBub3JtYWwlMjBnZW5lcmF0ZSUyMHdpdGhvdXQlMjBhbnklMjBzcGVjaWZpYyUyMHBhcmFtZXRlcnMlMEFzdW1tYXJ5X2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoc3VtbWFyeV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFRoaXMlMjBnZW5lcmF0ZXMlMjBhJTIwcGVuYWx0eSUyMGZvciUyMHJlcGVhdGVkJTIwdG9rZW5zJTBBcGVuYWxpemVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUocGVuYWxpemVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function uw(M){let f,x=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){f=r("p"),f.innerHTML=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-16cusgy"&&(f.innerHTML=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function hw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function fw(M){let f,x=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){f=r("p"),f.innerHTML=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1byeoum"&&(f.innerHTML=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function _w(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHRlbXBlcmF0dXJlJTNEMS4wJTJDJTIwdGhlJTIwZGVmYXVsdCUyQyUyMHdlJTIwY29uc2lzdGVudGx5JTIwZ2V0JTIwcmFuZG9tJTIwb3V0cHV0cyUyMGR1ZSUyMHRvJTIwcmFuZG9tJTIwc2FtcGxpbmcuJTBBZ2VuZXJhdGVfa3dhcmdzJTIwJTNEJTIwJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMCUyQyUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMFRydWUlMkMlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDEuMCUyQyUyMCUyMm51bV9yZXR1cm5fc2VxdWVuY2VzJTIyJTNBJTIwMiU3RCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBIb3dldmVyJTJDJTIwd2l0aCUyMHRlbXBlcmF0dXJlJTIwY2xvc2UlMjB0byUyMDAlMkMlMjBpdCUyMGFwcHJveGltYXRlcyUyMGdyZWVkeSUyMGRlY29kaW5nJTIwc3RyYXRlZ2llcyUyMChpbnZhcmlhbnQpJTBBZ2VuZXJhdGVfa3dhcmdzJTVCJTIydGVtcGVyYXR1cmUlMjIlNUQlMjAlM0QlMjAwLjAwMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjAqKmdlbmVyYXRlX2t3YXJncyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a joint venture between GEO Group, one of&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is not an exact science – but what we believe does&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function bw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjAlNjB0b3BfcCU2MCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfcCU2MCUyMGluJTIwdGhlJTIwMC45LTAuOTUlMjByYW5nZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdG9wX3AlM0QwLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function Tw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMkMlMjBhJTIwZHJhZ29uJTIwZmxldyUyMG92ZXIlMjBQYXJpcyUyQyUyMEZyYW5jZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBuZWdhdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMiUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdpdGglMjBhJTIwcG9zaXRpdmUlMjBwcm9tcHQlMEFuZWdfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjB2ZXJ5JTIwaGFwcHklMjBldmVudCUyMGhhcHBlbmVkJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMjBuZWdhdGl2ZV9wcm9tcHRfaWRzJTNEbmVnX2lucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function yw(M){let f,x;return f=new C({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){l(f.$$.fragment)},l($){d(f.$$.fragment,$)},m($,v){p(f,$,v),x=!0},p:U,i($){x||(m(f.$$.fragment,$),x=!0)},o($){g(f.$$.fragment,$),x=!1},d($){u(f,$)}}}function vw(M){let f,x="The API for the streamer classes is still under development and may change in the future.";return{c(){f=r("p"),f.textContent=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-gv2g1g"&&(f.textContent=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function $w(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHRvayklMEElMEElMjMlMjBEZXNwaXRlJTIwcmV0dXJuaW5nJTIwdGhlJTIwdXN1YWwlMjBvdXRwdXQlMkMlMjB0aGUlMjBzdHJlYW1lciUyMHdpbGwlMjBhbHNvJTIwcHJpbnQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwdG8lMjBzdGRvdXQuJTBBXyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function ww(M){let f,x="The API for the streamer classes is still under development and may change in the future.";return{c(){f=r("p"),f.textContent=x},l($){f=a($,"P",{"data-svelte-h":!0}),y(f)!=="svelte-gv2g1g"&&(f.textContent=x)},m($,v){c($,f,v)},p:U,d($){$&&n(f)}}}function xw(M){let f,x="Examples:",$,v,w;return v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dEl0ZXJhdG9yU3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGdlbmVyYXRpb24lMjBpbiUyMGElMjBzZXBhcmF0ZSUyMHRocmVhZCUyQyUyMHNvJTIwdGhhdCUyMHdlJTIwY2FuJTIwZmV0Y2glMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwaW4lMjBhJTIwbm9uLWJsb2NraW5nJTIwd2F5LiUwQWdlbmVyYXRpb25fa3dhcmdzJTIwJTNEJTIwZGljdChpbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0aHJlYWQlMjAlM0QlMjBUaHJlYWQodGFyZ2V0JTNEbW9kZWwuZ2VuZXJhdGUlMkMlMjBrd2FyZ3MlM0RnZW5lcmF0aW9uX2t3YXJncyklMEF0aHJlYWQuc3RhcnQoKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwJTIyJTIyJTBBZm9yJTIwbmV3X3RleHQlMjBpbiUyMHN0cmVhbWVyJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlMjAlMkIlM0QlMjBuZXdfdGV4dCUwQWdlbmVyYXRlZF90ZXh0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){f=r("p"),f.textContent=x,$=s(),l(v.$$.fragment)},l(h){f=a(h,"P",{"data-svelte-h":!0}),y(f)!=="svelte-kvfsh7"&&(f.textContent=x),$=o(h),d(v.$$.fragment,h)},m(h,k){c(h,f,k),c(h,$,k),p(v,h,k),w=!0},p:U,i(h){w||(m(v.$$.fragment,h),w=!0)},o(h){g(v.$$.fragment,h),w=!1},d(h){h&&(n(f),n($)),u(v,h)}}}function kw(M){let f,x,$,v,w,h,k,Ab=`This page lists all the utility functions used by <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search">greedy_search()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search">contrastive_search()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.sample">sample()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>, and
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search">constrained_beam_search()</a>.`,qp,Bn,Yb="Most of those are only useful if you are studying the code of the generate methods in the library.",Wp,qn,Vp,Wn,Kb=`The output of <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Sp,Vn,eT="Here’s an example:",Zp,Sn,Dp,Zn,tT=`The <code>generation_output</code> object is a <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput">GreedySearchDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Pp,Dn,nT="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Gp,Pn,sT=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Ep,Gn,oT=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Xp,En,rT=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Np,Xn,Rp,Nn,aT="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",Hp,Rn,iT=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Op,Hn,cT="We document here all output types.",Qp,On,Ap,dt,Qn,$u,Ya,lT=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Yp,pt,An,wu,Ka,dT="Base class for outputs of decoder-only generation models using greedy search.",Kp,mt,Yn,xu,ei,pT=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,em,gt,Kn,ku,ti,mT="Base class for outputs of decoder-only generation models using sampling.",tm,ut,es,Mu,ni,gT=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,nm,ht,ts,ju,si,uT="Base class for outputs of decoder-only generation models using beam search.",sm,ft,ns,Lu,oi,hT=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,om,_t,ss,Fu,ri,fT="Base class for outputs of decoder-only generation models using beam sample.",rm,bt,os,zu,ai,_T="Base class for outputs of decoder-only generation models using contrastive search.",am,Tt,rs,Uu,ii,bT="Base class for outputs of decoder-only generation models using contrastive search.",im,as,cm,yt,is,Ju,ci,TT=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,lm,vt,cs,Iu,li,yT="Base class for outputs of decoder-only generation models using greedy search.",dm,$t,ls,Cu,di,vT=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,pm,wt,ds,Bu,pi,$T="Base class for outputs of decoder-only generation models using sampling.",mm,xt,ps,qu,mi,wT=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,gm,kt,ms,Wu,gi,xT="Base class for outputs of decoder-only generation models using beam search.",um,Mt,gs,Vu,ui,kT=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,hm,jt,us,Su,hi,MT="Base class for outputs of decoder-only generation models using beam sample.",fm,Lt,hs,Zu,fi,jT=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,_m,Ft,fs,Du,_i,LT="Base class for outputs of decoder-only generation models using contrastive search.",bm,_s,Tm,oe,bs,Pu,bi,FT="Flax Base class for outputs of decoder-only generation models using sampling.",Gu,Bt,Ts,Eu,Ti,zT="“Returns a new object replacing the specified fields with new values.",ym,re,ys,Xu,yi,UT="Flax Base class for outputs of decoder-only generation models using greedy search.",Nu,qt,vs,Ru,vi,JT="“Returns a new object replacing the specified fields with new values.",vm,ae,$s,Hu,$i,IT="Flax Base class for outputs of decoder-only generation models using greedy search.",Ou,Wt,ws,Qu,wi,CT="“Returns a new object replacing the specified fields with new values.",$m,xs,wm,ks,BT=`A <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,xm,Ms,km,ie,js,Au,xi,qT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of <code>Bark</code>’s fine submodel.',Yu,ki,Ls,Mm,X,Fs,Ku,Mi,WT=`Logits processor for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,eh,ji,VT='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',th,Li,zs,jm,ce,Us,nh,Fi,ST=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces no repetition of encoder input ids n-grams for the decoder ids. See
<a href="https://github.com/facebookresearch/ParlAI/blob/master/parlai/core/torch_generator_agent.py#L1350" rel="nofollow">ParlAI</a>.`,sh,zi,Js,Lm,le,Is,oh,Ui,ZT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing an exponential penalty on tokens that are not in the original input.',rh,Ji,Cs,Fm,N,Bs,ah,Ii,DT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,ih,Vt,ch,Ci,qs,zm,R,Ws,lh,Bi,PT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,dh,St,ph,qi,Vs,Um,H,Ss,mh,Wi,GT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,gh,Zt,uh,Vi,Zs,Jm,de,Ds,hh,Si,ET='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token.',fh,Zi,Ps,Im,pe,Gs,_h,Di,XT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',bh,Pi,Es,Cm,me,Xs,Th,Gi,NT=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index.`,yh,Ei,Ns,Bm,j,Rs,vh,Xi,RT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',$h,Ni,HT=`Note that this logits processor is only effective for <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">PreTrainedModel.group_beam_search()</a>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,wh,Dt,xh,Pt,kh,Ri,OT=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,Mh,Hi,QT="How It Works:",jh,Oi,AT=`<li><strong>Grouping Beams</strong>: Beams are divided into groups. Each group selects tokens independently of the others.</li> <li><strong>Penalizing Repeated Tokens</strong>: If a beam in a group selects a token already chosen by another group in the
same step, a penalty is applied to that token’s score.</li> <li><strong>Promoting Diversity</strong>: This penalty discourages beams within a group from selecting the same tokens as
beams in other groups.</li>`,Lh,Qi,YT="Benefits:",Fh,Ai,KT="<li><strong>Diverse Outputs</strong>: Produces a variety of different sequences.</li> <li><strong>Exploration</strong>: Allows the model to explore different paths.</li>",zh,Gt,Uh,Yi,Hs,qm,ge,Os,Jh,Ki,ey=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,Ih,ec,Qs,Wm,ue,As,Ch,tc,ty=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,Bh,nc,Ys,Vm,he,Ks,qh,sc,ny="Abstract base class for all logit processors that can be applied during generation.",Wh,oc,eo,Sm,fe,to,Vh,rc,sy=`This class can be used to create a list of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,Sh,ac,no,Zm,_e,so,Zh,ic,oy="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Dh,cc,oo,Dm,be,ro,Ph,lc,ry='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Gh,dc,ao,Pm,O,io,Eh,pc,ay=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Note that for decoder-only models, such as Llama2, <code>min_length</code> will compute the length of <code>prompt + newly generated tokens</code> whereas for other models it will behave as <code>min_new_tokens</code>, that is, taking only into account
the newly generated ones.`,Xh,Et,Nh,mc,co,Gm,q,lo,Rh,gc,iy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',Hh,Xt,Oh,Nt,Qh,uc,po,Em,W,mo,Ah,hc,cy=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Yh,Rt,Kh,Ht,ef,fc,go,Xm,Te,uo,tf,_c,ly=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,nf,bc,ho,Nm,Q,fo,sf,Tc,dy=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through an exponential penalty. This technique
shares some similarities with coverage mechanisms and other aimed at reducing repetition. During the text
generation process, the probability distribution for the next token is determined using a formula that incorporates
token scores based on their occurrence in the generated sequence. Tokens with higher scores are more likely to be
selected. The formula can be seen in the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>. According to the
paper a penalty of around 1.2 yields a good balance between truthful generation and lack of repetition.`,of,Ot,rf,yc,_o,Rm,V,bo,af,vc,py=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,cf,Qt,lf,At,df,$c,To,Hm,ye,yo,pf,wc,my=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,mf,xc,vo,Om,ve,$o,gf,kc,gy=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,uf,Mc,wo,Qm,S,xo,hf,jc,uy=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens.`,ff,Yt,_f,Kt,bf,Lc,ko,Am,$e,Mo,Tf,Fc,hy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',yf,zc,jo,Ym,A,Lo,vf,Uc,fy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',$f,en,wf,Jc,Fo,Km,we,zo,xf,Ic,_y=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language
Generation</a> for more information.`,kf,Cc,Uo,eg,Z,Jo,Mf,Bc,by=`Logits processor for Classifier-Free Guidance (CFG). The processors
computes a weighted average across scores from prompt conditional and prompt unconditional (or negative) logits,
parameterized by the <code>guidance_scale</code>. The unconditional scores are computed internally by prompting <code>model</code> with
the <code>unconditional_ids</code> branch.`,jf,qc,Ty='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',Lf,tn,Ff,Wc,Io,tg,Y,Co,zf,Vc,yy=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,Uf,Sc,vy='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',Jf,Zc,Bo,ng,qo,sg,xe,Wo,If,Dc,$y='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',Cf,Pc,Vo,og,ke,So,Bf,Gc,wy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',qf,Ec,Zo,rg,Me,Do,Wf,Xc,xy=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,Vf,Nc,Po,ag,je,Go,Sf,Rc,ky="Abstract base class for all logit processors that can be applied during generation.",Zf,nn,Eo,Df,Hc,My="TF method for processing logits.",ig,Le,Xo,Pf,Oc,jy=`This class can be used to create a list of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,Gf,Qc,No,cg,Fe,Ro,Ef,Ac,Ly="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Xf,sn,Ho,Nf,Yc,Fy="TF method for warping logits.",lg,ze,Oo,Rf,Kc,zy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Hf,el,Qo,dg,Ue,Ao,Of,tl,Uy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',Qf,nl,Yo,pg,Je,Ko,Af,sl,Jy=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Yf,ol,er,mg,Ie,tr,Kf,rl,Iy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',e_,al,nr,gg,Ce,sr,t_,il,Cy=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,n_,cl,or,ug,Be,rr,s_,ll,By=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,o_,dl,ar,hg,qe,ir,r_,pl,qy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',a_,ml,cr,fg,We,lr,i_,gl,Wy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',c_,ul,dr,_g,Ve,pr,l_,hl,Vy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',d_,fl,mr,bg,gr,Tg,Se,ur,p_,_l,Sy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',m_,bl,hr,yg,Ze,fr,g_,Tl,Zy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',u_,yl,_r,vg,De,br,h_,vl,Dy=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,f_,$l,Tr,$g,Pe,yr,__,wl,Py="Abstract base class for all logit processors that can be applied during generation.",b_,on,vr,T_,xl,Gy="Flax method for processing logits.",wg,Ge,$r,y_,kl,Ey=`This class can be used to create a list of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,v_,Ml,wr,xg,Ee,xr,$_,jl,Xy="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",w_,rn,kr,x_,Ll,Ny="Flax method for warping logits.",kg,Xe,Mr,k_,Fl,Ry='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',M_,zl,jr,Mg,Ne,Lr,j_,Ul,Hy=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,L_,Jl,Fr,jg,Re,zr,F_,Il,Oy=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,z_,Cl,Ur,Lg,He,Jr,U_,Bl,Qy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',J_,ql,Ir,Fg,Oe,Cr,I_,Wl,Ay='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',C_,Vl,Br,zg,Qe,qr,B_,Sl,Yy='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',q_,Zl,Wr,Ug,Ae,Vr,W_,Dl,Ky=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,V_,Pl,Sr,Jg,Zr,Ig,Dr,ev='A <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusivelly available to our PyTorch implementations.',Cg,Ye,Pr,S_,Gl,tv="Abstract base class for all stopping criteria that can be applied during generation.",Z_,El,Gr,Bg,zt,Er,D_,Xl,Xr,qg,Ke,Nr,P_,Nl,nv=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,G_,Rl,Rr,Wg,et,Hr,E_,Hl,sv=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,X_,Ol,Or,Vg,Qr,Sg,Ar,ov='A <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusivelly available to our PyTorch implementations.',Zg,L,Yr,N_,Ql,rv=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,R_,Al,av="All classes that inherit Constraint must follow the requirement that",H_,an,O_,Yl,iv="will always terminate (halt).",Q_,cn,Kr,A_,Kl,cv="When called, returns the token that would take this constraint one step closer to being fulfilled.",Y_,ln,ea,K_,ed,lv="Creates a new instance of this constraint.",eb,dn,ta,tb,td,dv="Reads in a token and returns whether it creates progress.",nb,pn,na,sb,nd,pv="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",ob,mn,sa,rb,sd,mv=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,ab,gn,oa,ib,od,gv="Tests whether this constraint has been properly defined.",cb,st,ra,lb,rd,uv=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,db,ad,hv=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,Dg,Ut,aa,pb,id,fv='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',Pg,Jt,ia,mb,cd,_v='A special <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',Gg,K,ca,gb,ld,bv="A class for beam scorers to track its progress through a list of constraints.",ub,B,la,hb,dd,Tv=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,fb,pd,yv=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,_b,md,vv="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",bb,gd,$v=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,Tb,ud,wv=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,yb,un,da,vb,hd,xv="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Eg,pa,Xg,ee,ma,$b,fd,kv=`Abstract base class for all beam scorers that are used for <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a> and
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>.`,wb,_d,ga,xb,bd,ua,Ng,I,ha,kb,Td,Mv='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',Mb,yd,jv=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,jb,vd,Lv=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,Lb,$d,fa,Fb,wd,_a,Rg,te,ba,zb,xd,Fv='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',Ub,kd,Ta,Jb,Md,ya,Hg,va,Og,tt,$a,Ib,jd,zv="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Cb,Ld,Uv='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Qg,nt,wa,Bb,Fd,Jv="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",qb,zd,Iv='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Ag,xa,Yg,J,ka,Wb,Ud,Cv="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",Vb,hn,Sb,fn,Zb,_n,Ma,Db,Jd,Bv="Flushes any remaining cache and prints a newline to stdout.",Pb,bn,ja,Gb,Id,qv="Prints the new text to stdout. If the stream is ending, also prints a newline.",Eb,Tn,La,Xb,Cd,Wv="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",Kg,D,Fa,Nb,Bd,Vv=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,Rb,yn,Hb,vn,Ob,$n,za,Qb,qd,Sv="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",eu,Bp,tu;return w=new E({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),qn=new E({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),Sn=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIwYW5kJTIwJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0aW9uX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),Xn=new C({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),On=new E({props:{title:"PyTorch",local:"transformers.generation.GreedySearchEncoderDecoderOutput",headingTag:"h3"}}),Qn=new T({props:{name:"class transformers.generation.GreedySearchEncoderDecoderOutput",anchor:"transformers.generation.GreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L184"}}),An=new T({props:{name:"class transformers.generation.GreedySearchDecoderOnlyOutput",anchor:"transformers.generation.GreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L88"}}),Yn=new T({props:{name:"class transformers.generation.SampleEncoderDecoderOutput",anchor:"transformers.generation.SampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape
<code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L255"}}),Kn=new T({props:{name:"class transformers.generation.SampleDecoderOnlyOutput",anchor:"transformers.generation.SampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L226"}}),es=new T({props:{name:"class transformers.generation.BeamSearchEncoderDecoderOutput",anchor:"transformers.generation.BeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L333"}}),ts=new T({props:{name:"class transformers.generation.BeamSearchDecoderOnlyOutput",anchor:"transformers.generation.BeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L298"}}),ns=new T({props:{name:"class transformers.generation.BeamSampleEncoderDecoderOutput",anchor:"transformers.generation.BeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>).`,name:"scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L418"}}),ss=new T({props:{name:"class transformers.generation.BeamSampleDecoderOnlyOutput",anchor:"transformers.generation.BeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L383"}}),os=new T({props:{name:"class transformers.generation.ContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L116"}}),rs=new T({props:{name:"class transformers.generation.ContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when &#x2014;
<code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.hidden_states",description:"<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is &#x2014;",name:"hidden_states"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.passed",description:`<strong>passed</strong> or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"passed"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L155"}}),as=new E({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),is=new T({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L86"}}),cs=new T({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L58"}}),ls=new T({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L156"}}),ds=new T({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L128"}}),ps=new T({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L233"}}),ms=new T({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L198"}}),gs=new T({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L318"}}),us=new T({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L283"}}),hs=new T({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L394"}}),fs=new T({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L367"}}),_s=new E({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),bs=new T({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_utils.py#L69"}}),Ts=new T({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/flax/struct.py#L111"}}),ys=new T({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_utils.py#L55"}}),vs=new T({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/flax/struct.py#L111"}}),$s=new T({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_utils.py#L83"}}),ws=new T({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/flax/struct.py#L111"}}),xs=new E({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),Ms=new E({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),js=new T({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1553"}}),Ls=new T({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1574"}}),Fs=new T({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1513"}}),zs=new T({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1537",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Us=new T({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L763"}}),Js=new T({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L786",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Is=new T({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.hallucination_penalty",description:`<strong>hallucination_penalty</strong> (<code>float</code>) &#x2014;
The parameter for hallucination penalty. 1.0 means no penalty.`,name:"hallucination_penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L323"}}),Cs=new T({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L341",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Bs=new T({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L493"}}),Vt=new P({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[nw]},$$scope:{ctx:M}}}),qs=new T({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L546",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ws=new T({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L560"}}),St=new P({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[sw]},$$scope:{ctx:M}}}),Vs=new T({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L623",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ss=new T({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": typing.Tuple[int, float]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1298"}}),Zt=new P({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[ow]},$$scope:{ctx:M}}}),Zs=new T({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1371",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ds=new T({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1230"}}),Ps=new T({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1242",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Gs=new T({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1252"}}),Es=new T({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1270",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xs=new T({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1428"}}),Ns=new T({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1436",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Rs=new T({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if group beam search is enabled. The
penalty applied to a beam&#x2019;s score when it generates a token that has already been chosen by another beam
within the same group during the same time step. A higher <code>diversity_penalty</code> will enforce greater
diversity among the beams, making it less likely for multiple beams to choose the same token. Conversely, a
lower penalty will allow beams to more freely choose similar tokens. Adjusting this value can help strike a
balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams used for group beam search. Beam search is a method used that maintains beams (or &#x201C;multiple
hypotheses&#x201D;) at each step, expanding each one and keeping the top-scoring sequences. A higher <code>num_beams</code>
will explore more potential sequences. This can increase chances of finding a high-quality output but also
increases computational cost.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
Each group of beams will operate independently, selecting tokens without considering the choices of other
groups. This division promotes diversity by ensuring that beams within different groups explore different
paths. For instance, if <code>num_beams</code> is 6 and <code>num_beam_groups</code> is 2, there will be 2 groups each containing
3 beams. The choice of <code>num_beam_groups</code> should be made considering the desired level of output diversity
and the total number of beams. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1067"}}),Dt=new Cn({props:{$$slots:{default:[rw]},$$scope:{ctx:M}}}),Pt=new Cn({props:{warning:!0,$$slots:{default:[aw]},$$scope:{ctx:M}}}),Gt=new P({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[iw]},$$scope:{ctx:M}}}),Hs=new T({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1184",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Os=new T({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1281"}}),Qs=new T({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1287",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),As=new T({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1382"}}),Ys=new T({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1390",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ks=new T({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L44"}}),eo=new T({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L47",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),to=new T({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L64"}}),no=new T({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L71",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),so=new T({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L54"}}),oo=new T({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L57",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ro=new T({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L101"}}),ao=new T({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L124",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),io=new T({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L133"}}),Et=new P({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[cw]},$$scope:{ctx:M}}}),co=new T({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L195",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new T({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L953"}}),Xt=new Cn({props:{$$slots:{default:[lw]},$$scope:{ctx:M}}}),Nt=new P({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[dw]},$$scope:{ctx:M}}}),po=new T({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L876",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),mo=new T({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L706"}}),Rt=new Cn({props:{$$slots:{default:[pw]},$$scope:{ctx:M}}}),Ht=new P({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[mw]},$$scope:{ctx:M}}}),go=new T({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L752",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),uo=new T({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": typing.Callable[[int, torch.Tensor], typing.List[int]]"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1040"}}),ho=new T({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1057",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fo=new T({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L270"}}),Ot=new P({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[gw]},$$scope:{ctx:M}}}),_o=new T({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L312",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bo=new T({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": typing.Dict[typing.Tuple[int], float]"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L805"}}),Qt=new Cn({props:{$$slots:{default:[uw]},$$scope:{ctx:M}}}),At=new P({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[hw]},$$scope:{ctx:M}}}),To=new T({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L876",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yo=new T({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1396"}}),vo=new T({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1407",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new T({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1415"}}),wo=new T({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1422",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new T({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L205"}}),Yt=new Cn({props:{$$slots:{default:[fw]},$$scope:{ctx:M}}}),Kt=new P({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[_w]},$$scope:{ctx:M}}}),ko=new T({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L264",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mo=new T({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L415"}}),jo=new T({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L435",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Lo=new T({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L352"}}),en=new P({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[bw]},$$scope:{ctx:M}}}),Fo=new T({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L399",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zo=new T({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L444"}}),Uo=new T({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L469",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Jo=new T({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"unconditional_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <strong>optional</strong>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.smooth_factor",description:`<strong>smooth_factor</strong> (<code>float</code>, <strong>optional</strong>) &#x2014;
The interpolation weight for CFG Rescale. 1 means no rescaling, 0 reduces to the conditional scores without
CFG. Turn it lower if the output degenerates.`,name:"smooth_factor"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <strong>optional</strong>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1589"}}),tn=new P({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Tw]},$$scope:{ctx:M}}}),Io=new T({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1698"}}),Co=new T({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1446"}}),Bo=new T({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1475",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qo=new E({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Wo=new T({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L448"}}),Vo=new T({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L462"}}),So=new T({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L478"}}),Zo=new T({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L495"}}),Do=new T({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L551"}}),Po=new T({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L567"}}),Go=new T({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L53"}}),Eo=new T({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xo=new T({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L75"}}),No=new T({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ro=new T({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L64"}}),Ho=new T({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Oo=new T({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L202"}}),Qo=new T({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L228"}}),Ao=new T({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L288"}}),Yo=new T({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L367"}}),Ko=new T({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L388"}}),er=new T({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L427"}}),tr=new T({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L238"}}),nr=new T({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L280"}}),sr=new T({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L511"}}),or=new T({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L522"}}),rr=new T({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L535"}}),ar=new T({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L542"}}),ir=new T({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L98"}}),cr=new T({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L113"}}),lr=new T({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L118"}}),dr=new T({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L138"}}),pr=new T({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L146"}}),mr=new T({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L170"}}),gr=new E({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),ur=new T({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L194"}}),hr=new T({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L206"}}),fr=new T({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L216"}}),_r=new T({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L231"}}),br=new T({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L315"}}),Tr=new T({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L337"}}),yr=new T({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L50"}}),vr=new T({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$r=new T({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L72"}}),wr=new T({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L79",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xr=new T({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L61"}}),kr=new T({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L64",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mr=new T({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L241"}}),jr=new T({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L262"}}),Lr=new T({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L271"}}),Fr=new T({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L288"}}),zr=new T({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L296"}}),Ur=new T({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L309"}}),Jr=new T({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L95"}}),Ir=new T({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L110"}}),Cr=new T({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L159"}}),Br=new T({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L179"}}),qr=new T({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L115"}}),Wr=new T({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L139"}}),Vr=new T({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L363"}}),Sr=new T({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L397"}}),Zr=new E({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Pr=new T({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L36"}}),Gr=new T({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L39",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Er=new T({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L124"}}),Xr=new T({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L125",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Nr=new T({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <code>optional</code>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L44"}}),Rr=new T({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L60",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Hr=new T({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L102"}}),Or=new T({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L119",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),Qr=new E({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),Yr=new T({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L5"}}),an=new P({props:{anchor:"transformers.Constraint.example",$$slots:{default:[yw]},$$scope:{ctx:M}}}),Kr=new T({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids(<code>torch.tensor</code>)</p>
`}}),ea=new T({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),ta=new T({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L60"}}),na=new T({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L104"}}),sa=new T({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L94"}}),oa=new T({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L24"}}),ra=new T({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),aa=new T({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": typing.List[int]"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L129"}}),ia=new T({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": typing.List[typing.List[int]]"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:"<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014; a list of words, where each word is a list of ids. This constraint",name:"nested_token_ids"},{anchor:"transformers.DisjunctiveConstraint.is",description:"<strong>is</strong> fulfilled by generating just one from the list of words. &#x2014;",name:"is"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L261"}}),ca=new T({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L350"}}),la=new T({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L382"}}),da=new T({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": typing.Optional[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L417"}}),pa=new E({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),ma=new T({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L91"}}),ga=new T({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),ua=new T({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),ha=new T({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L123"}}),fa=new T({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"group_index",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L215"}}),_a=new T({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L315"}}),ba=new T({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[str, bool, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L410"}}),Ta=new T({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.34.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L504",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),ya=new T({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L798"}}),va=new E({props:{title:"Utilities",local:"transformers.top_k_top_p_filtering",headingTag:"h2"}}),$a=new T({props:{name:"transformers.top_k_top_p_filtering",anchor:"transformers.top_k_top_p_filtering",parameters:[{name:"logits",val:": FloatTensor"},{name:"top_k",val:": int = 0"},{name:"top_p",val:": float = 1.0"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L4706"}}),wa=new T({props:{name:"transformers.tf_top_k_top_p_filtering",anchor:"transformers.tf_top_k_top_p_filtering",parameters:[{name:"logits",val:""},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 1.0"},{name:"filter_value",val:" = -inf"},{name:"min_tokens_to_keep",val:" = 1"}],parametersDescription:[{anchor:"transformers.tf_top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.tf_top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.tf_top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L3063"}}),xa=new E({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),ka=new T({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L38"}}),hn=new Cn({props:{warning:!0,$$slots:{default:[vw]},$$scope:{ctx:M}}}),fn=new P({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[$w]},$$scope:{ctx:M}}}),Ma=new T({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L116"}}),ja=new T({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L130"}}),La=new T({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L82"}}),Fa=new T({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L159"}}),yn=new Cn({props:{warning:!0,$$slots:{default:[ww]},$$scope:{ctx:M}}}),vn=new P({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[xw]},$$scope:{ctx:M}}}),za=new T({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L213"}}),{c(){f=r("meta"),x=s(),$=r("p"),v=s(),l(w.$$.fragment),h=s(),k=r("p"),k.innerHTML=Ab,qp=s(),Bn=r("p"),Bn.textContent=Yb,Wp=s(),l(qn.$$.fragment),Vp=s(),Wn=r("p"),Wn.innerHTML=Kb,Sp=s(),Vn=r("p"),Vn.textContent=eT,Zp=s(),l(Sn.$$.fragment),Dp=s(),Zn=r("p"),Zn.innerHTML=tT,Pp=s(),Dn=r("ul"),Dn.innerHTML=nT,Gp=s(),Pn=r("p"),Pn.innerHTML=sT,Ep=s(),Gn=r("p"),Gn.innerHTML=oT,Xp=s(),En=r("p"),En.innerHTML=rT,Np=s(),l(Xn.$$.fragment),Rp=s(),Nn=r("p"),Nn.innerHTML=aT,Hp=s(),Rn=r("p"),Rn.innerHTML=iT,Op=s(),Hn=r("p"),Hn.textContent=cT,Qp=s(),l(On.$$.fragment),Ap=s(),dt=r("div"),l(Qn.$$.fragment),$u=s(),Ya=r("p"),Ya.textContent=lT,Yp=s(),pt=r("div"),l(An.$$.fragment),wu=s(),Ka=r("p"),Ka.textContent=dT,Kp=s(),mt=r("div"),l(Yn.$$.fragment),xu=s(),ei=r("p"),ei.textContent=pT,em=s(),gt=r("div"),l(Kn.$$.fragment),ku=s(),ti=r("p"),ti.textContent=mT,tm=s(),ut=r("div"),l(es.$$.fragment),Mu=s(),ni=r("p"),ni.textContent=gT,nm=s(),ht=r("div"),l(ts.$$.fragment),ju=s(),si=r("p"),si.textContent=uT,sm=s(),ft=r("div"),l(ns.$$.fragment),Lu=s(),oi=r("p"),oi.textContent=hT,om=s(),_t=r("div"),l(ss.$$.fragment),Fu=s(),ri=r("p"),ri.textContent=fT,rm=s(),bt=r("div"),l(os.$$.fragment),zu=s(),ai=r("p"),ai.textContent=_T,am=s(),Tt=r("div"),l(rs.$$.fragment),Uu=s(),ii=r("p"),ii.textContent=bT,im=s(),l(as.$$.fragment),cm=s(),yt=r("div"),l(is.$$.fragment),Ju=s(),ci=r("p"),ci.textContent=TT,lm=s(),vt=r("div"),l(cs.$$.fragment),Iu=s(),li=r("p"),li.textContent=yT,dm=s(),$t=r("div"),l(ls.$$.fragment),Cu=s(),di=r("p"),di.textContent=vT,pm=s(),wt=r("div"),l(ds.$$.fragment),Bu=s(),pi=r("p"),pi.textContent=$T,mm=s(),xt=r("div"),l(ps.$$.fragment),qu=s(),mi=r("p"),mi.textContent=wT,gm=s(),kt=r("div"),l(ms.$$.fragment),Wu=s(),gi=r("p"),gi.textContent=xT,um=s(),Mt=r("div"),l(gs.$$.fragment),Vu=s(),ui=r("p"),ui.textContent=kT,hm=s(),jt=r("div"),l(us.$$.fragment),Su=s(),hi=r("p"),hi.textContent=MT,fm=s(),Lt=r("div"),l(hs.$$.fragment),Zu=s(),fi=r("p"),fi.textContent=jT,_m=s(),Ft=r("div"),l(fs.$$.fragment),Du=s(),_i=r("p"),_i.textContent=LT,bm=s(),l(_s.$$.fragment),Tm=s(),oe=r("div"),l(bs.$$.fragment),Pu=s(),bi=r("p"),bi.textContent=FT,Gu=s(),Bt=r("div"),l(Ts.$$.fragment),Eu=s(),Ti=r("p"),Ti.textContent=zT,ym=s(),re=r("div"),l(ys.$$.fragment),Xu=s(),yi=r("p"),yi.textContent=UT,Nu=s(),qt=r("div"),l(vs.$$.fragment),Ru=s(),vi=r("p"),vi.textContent=JT,vm=s(),ae=r("div"),l($s.$$.fragment),Hu=s(),$i=r("p"),$i.textContent=IT,Ou=s(),Wt=r("div"),l(ws.$$.fragment),Qu=s(),wi=r("p"),wi.textContent=CT,$m=s(),l(xs.$$.fragment),wm=s(),ks=r("p"),ks.innerHTML=BT,xm=s(),l(Ms.$$.fragment),km=s(),ie=r("div"),l(js.$$.fragment),Au=s(),xi=r("p"),xi.innerHTML=qT,Yu=s(),ki=r("div"),l(Ls.$$.fragment),Mm=s(),X=r("div"),l(Fs.$$.fragment),Ku=s(),Mi=r("p"),Mi.innerHTML=WT,eh=s(),ji=r("p"),ji.innerHTML=VT,th=s(),Li=r("div"),l(zs.$$.fragment),jm=s(),ce=r("div"),l(Us.$$.fragment),nh=s(),Fi=r("p"),Fi.innerHTML=ST,sh=s(),zi=r("div"),l(Js.$$.fragment),Lm=s(),le=r("div"),l(Is.$$.fragment),oh=s(),Ui=r("p"),Ui.innerHTML=ZT,rh=s(),Ji=r("div"),l(Cs.$$.fragment),Fm=s(),N=r("div"),l(Bs.$$.fragment),ah=s(),Ii=r("p"),Ii.innerHTML=DT,ih=s(),l(Vt.$$.fragment),ch=s(),Ci=r("div"),l(qs.$$.fragment),zm=s(),R=r("div"),l(Ws.$$.fragment),lh=s(),Bi=r("p"),Bi.innerHTML=PT,dh=s(),l(St.$$.fragment),ph=s(),qi=r("div"),l(Vs.$$.fragment),Um=s(),H=r("div"),l(Ss.$$.fragment),mh=s(),Wi=r("p"),Wi.innerHTML=GT,gh=s(),l(Zt.$$.fragment),uh=s(),Vi=r("div"),l(Zs.$$.fragment),Jm=s(),de=r("div"),l(Ds.$$.fragment),hh=s(),Si=r("p"),Si.innerHTML=ET,fh=s(),Zi=r("div"),l(Ps.$$.fragment),Im=s(),pe=r("div"),l(Gs.$$.fragment),_h=s(),Di=r("p"),Di.innerHTML=XT,bh=s(),Pi=r("div"),l(Es.$$.fragment),Cm=s(),me=r("div"),l(Xs.$$.fragment),Th=s(),Gi=r("p"),Gi.innerHTML=NT,yh=s(),Ei=r("div"),l(Ns.$$.fragment),Bm=s(),j=r("div"),l(Rs.$$.fragment),vh=s(),Xi=r("p"),Xi.innerHTML=RT,$h=s(),Ni=r("p"),Ni.innerHTML=HT,wh=s(),l(Dt.$$.fragment),xh=s(),l(Pt.$$.fragment),kh=s(),Ri=r("p"),Ri.innerHTML=OT,Mh=s(),Hi=r("p"),Hi.textContent=QT,jh=s(),Oi=r("ul"),Oi.innerHTML=AT,Lh=s(),Qi=r("p"),Qi.textContent=YT,Fh=s(),Ai=r("ul"),Ai.innerHTML=KT,zh=s(),l(Gt.$$.fragment),Uh=s(),Yi=r("div"),l(Hs.$$.fragment),qm=s(),ge=r("div"),l(Os.$$.fragment),Jh=s(),Ki=r("p"),Ki.innerHTML=ey,Ih=s(),ec=r("div"),l(Qs.$$.fragment),Wm=s(),ue=r("div"),l(As.$$.fragment),Ch=s(),tc=r("p"),tc.innerHTML=ty,Bh=s(),nc=r("div"),l(Ys.$$.fragment),Vm=s(),he=r("div"),l(Ks.$$.fragment),qh=s(),sc=r("p"),sc.textContent=ny,Wh=s(),oc=r("div"),l(eo.$$.fragment),Sm=s(),fe=r("div"),l(to.$$.fragment),Vh=s(),rc=r("p"),rc.innerHTML=sy,Sh=s(),ac=r("div"),l(no.$$.fragment),Zm=s(),_e=r("div"),l(so.$$.fragment),Zh=s(),ic=r("p"),ic.textContent=oy,Dh=s(),cc=r("div"),l(oo.$$.fragment),Dm=s(),be=r("div"),l(ro.$$.fragment),Ph=s(),lc=r("p"),lc.innerHTML=ry,Gh=s(),dc=r("div"),l(ao.$$.fragment),Pm=s(),O=r("div"),l(io.$$.fragment),Eh=s(),pc=r("p"),pc.innerHTML=ay,Xh=s(),l(Et.$$.fragment),Nh=s(),mc=r("div"),l(co.$$.fragment),Gm=s(),q=r("div"),l(lo.$$.fragment),Rh=s(),gc=r("p"),gc.innerHTML=iy,Hh=s(),l(Xt.$$.fragment),Oh=s(),l(Nt.$$.fragment),Qh=s(),uc=r("div"),l(po.$$.fragment),Em=s(),W=r("div"),l(mo.$$.fragment),Ah=s(),hc=r("p"),hc.innerHTML=cy,Yh=s(),l(Rt.$$.fragment),Kh=s(),l(Ht.$$.fragment),ef=s(),fc=r("div"),l(go.$$.fragment),Xm=s(),Te=r("div"),l(uo.$$.fragment),tf=s(),_c=r("p"),_c.innerHTML=ly,nf=s(),bc=r("div"),l(ho.$$.fragment),Nm=s(),Q=r("div"),l(fo.$$.fragment),sf=s(),Tc=r("p"),Tc.innerHTML=dy,of=s(),l(Ot.$$.fragment),rf=s(),yc=r("div"),l(_o.$$.fragment),Rm=s(),V=r("div"),l(bo.$$.fragment),af=s(),vc=r("p"),vc.innerHTML=py,cf=s(),l(Qt.$$.fragment),lf=s(),l(At.$$.fragment),df=s(),$c=r("div"),l(To.$$.fragment),Hm=s(),ye=r("div"),l(yo.$$.fragment),pf=s(),wc=r("p"),wc.innerHTML=my,mf=s(),xc=r("div"),l(vo.$$.fragment),Om=s(),ve=r("div"),l($o.$$.fragment),gf=s(),kc=r("p"),kc.innerHTML=gy,uf=s(),Mc=r("div"),l(wo.$$.fragment),Qm=s(),S=r("div"),l(xo.$$.fragment),hf=s(),jc=r("p"),jc.innerHTML=uy,ff=s(),l(Yt.$$.fragment),_f=s(),l(Kt.$$.fragment),bf=s(),Lc=r("div"),l(ko.$$.fragment),Am=s(),$e=r("div"),l(Mo.$$.fragment),Tf=s(),Fc=r("p"),Fc.innerHTML=hy,yf=s(),zc=r("div"),l(jo.$$.fragment),Ym=s(),A=r("div"),l(Lo.$$.fragment),vf=s(),Uc=r("p"),Uc.innerHTML=fy,$f=s(),l(en.$$.fragment),wf=s(),Jc=r("div"),l(Fo.$$.fragment),Km=s(),we=r("div"),l(zo.$$.fragment),xf=s(),Ic=r("p"),Ic.innerHTML=_y,kf=s(),Cc=r("div"),l(Uo.$$.fragment),eg=s(),Z=r("div"),l(Jo.$$.fragment),Mf=s(),Bc=r("p"),Bc.innerHTML=by,jf=s(),qc=r("p"),qc.innerHTML=Ty,Lf=s(),l(tn.$$.fragment),Ff=s(),Wc=r("div"),l(Io.$$.fragment),tg=s(),Y=r("div"),l(Co.$$.fragment),zf=s(),Vc=r("p"),Vc.innerHTML=yy,Uf=s(),Sc=r("p"),Sc.innerHTML=vy,Jf=s(),Zc=r("div"),l(Bo.$$.fragment),ng=s(),l(qo.$$.fragment),sg=s(),xe=r("div"),l(Wo.$$.fragment),If=s(),Dc=r("p"),Dc.innerHTML=$y,Cf=s(),Pc=r("div"),l(Vo.$$.fragment),og=s(),ke=r("div"),l(So.$$.fragment),Bf=s(),Gc=r("p"),Gc.innerHTML=wy,qf=s(),Ec=r("div"),l(Zo.$$.fragment),rg=s(),Me=r("div"),l(Do.$$.fragment),Wf=s(),Xc=r("p"),Xc.innerHTML=xy,Vf=s(),Nc=r("div"),l(Po.$$.fragment),ag=s(),je=r("div"),l(Go.$$.fragment),Sf=s(),Rc=r("p"),Rc.textContent=ky,Zf=s(),nn=r("div"),l(Eo.$$.fragment),Df=s(),Hc=r("p"),Hc.textContent=My,ig=s(),Le=r("div"),l(Xo.$$.fragment),Pf=s(),Oc=r("p"),Oc.innerHTML=jy,Gf=s(),Qc=r("div"),l(No.$$.fragment),cg=s(),Fe=r("div"),l(Ro.$$.fragment),Ef=s(),Ac=r("p"),Ac.textContent=Ly,Xf=s(),sn=r("div"),l(Ho.$$.fragment),Nf=s(),Yc=r("p"),Yc.textContent=Fy,lg=s(),ze=r("div"),l(Oo.$$.fragment),Rf=s(),Kc=r("p"),Kc.innerHTML=zy,Hf=s(),el=r("div"),l(Qo.$$.fragment),dg=s(),Ue=r("div"),l(Ao.$$.fragment),Of=s(),tl=r("p"),tl.innerHTML=Uy,Qf=s(),nl=r("div"),l(Yo.$$.fragment),pg=s(),Je=r("div"),l(Ko.$$.fragment),Af=s(),sl=r("p"),sl.innerHTML=Jy,Yf=s(),ol=r("div"),l(er.$$.fragment),mg=s(),Ie=r("div"),l(tr.$$.fragment),Kf=s(),rl=r("p"),rl.innerHTML=Iy,e_=s(),al=r("div"),l(nr.$$.fragment),gg=s(),Ce=r("div"),l(sr.$$.fragment),t_=s(),il=r("p"),il.innerHTML=Cy,n_=s(),cl=r("div"),l(or.$$.fragment),ug=s(),Be=r("div"),l(rr.$$.fragment),s_=s(),ll=r("p"),ll.innerHTML=By,o_=s(),dl=r("div"),l(ar.$$.fragment),hg=s(),qe=r("div"),l(ir.$$.fragment),r_=s(),pl=r("p"),pl.innerHTML=qy,a_=s(),ml=r("div"),l(cr.$$.fragment),fg=s(),We=r("div"),l(lr.$$.fragment),i_=s(),gl=r("p"),gl.innerHTML=Wy,c_=s(),ul=r("div"),l(dr.$$.fragment),_g=s(),Ve=r("div"),l(pr.$$.fragment),l_=s(),hl=r("p"),hl.innerHTML=Vy,d_=s(),fl=r("div"),l(mr.$$.fragment),bg=s(),l(gr.$$.fragment),Tg=s(),Se=r("div"),l(ur.$$.fragment),p_=s(),_l=r("p"),_l.innerHTML=Sy,m_=s(),bl=r("div"),l(hr.$$.fragment),yg=s(),Ze=r("div"),l(fr.$$.fragment),g_=s(),Tl=r("p"),Tl.innerHTML=Zy,u_=s(),yl=r("div"),l(_r.$$.fragment),vg=s(),De=r("div"),l(br.$$.fragment),h_=s(),vl=r("p"),vl.innerHTML=Dy,f_=s(),$l=r("div"),l(Tr.$$.fragment),$g=s(),Pe=r("div"),l(yr.$$.fragment),__=s(),wl=r("p"),wl.textContent=Py,b_=s(),on=r("div"),l(vr.$$.fragment),T_=s(),xl=r("p"),xl.textContent=Gy,wg=s(),Ge=r("div"),l($r.$$.fragment),y_=s(),kl=r("p"),kl.innerHTML=Ey,v_=s(),Ml=r("div"),l(wr.$$.fragment),xg=s(),Ee=r("div"),l(xr.$$.fragment),$_=s(),jl=r("p"),jl.textContent=Xy,w_=s(),rn=r("div"),l(kr.$$.fragment),x_=s(),Ll=r("p"),Ll.textContent=Ny,kg=s(),Xe=r("div"),l(Mr.$$.fragment),k_=s(),Fl=r("p"),Fl.innerHTML=Ry,M_=s(),zl=r("div"),l(jr.$$.fragment),Mg=s(),Ne=r("div"),l(Lr.$$.fragment),j_=s(),Ul=r("p"),Ul.innerHTML=Hy,L_=s(),Jl=r("div"),l(Fr.$$.fragment),jg=s(),Re=r("div"),l(zr.$$.fragment),F_=s(),Il=r("p"),Il.innerHTML=Oy,z_=s(),Cl=r("div"),l(Ur.$$.fragment),Lg=s(),He=r("div"),l(Jr.$$.fragment),U_=s(),Bl=r("p"),Bl.innerHTML=Qy,J_=s(),ql=r("div"),l(Ir.$$.fragment),Fg=s(),Oe=r("div"),l(Cr.$$.fragment),I_=s(),Wl=r("p"),Wl.innerHTML=Ay,C_=s(),Vl=r("div"),l(Br.$$.fragment),zg=s(),Qe=r("div"),l(qr.$$.fragment),B_=s(),Sl=r("p"),Sl.innerHTML=Yy,q_=s(),Zl=r("div"),l(Wr.$$.fragment),Ug=s(),Ae=r("div"),l(Vr.$$.fragment),W_=s(),Dl=r("p"),Dl.innerHTML=Ky,V_=s(),Pl=r("div"),l(Sr.$$.fragment),Jg=s(),l(Zr.$$.fragment),Ig=s(),Dr=r("p"),Dr.innerHTML=ev,Cg=s(),Ye=r("div"),l(Pr.$$.fragment),S_=s(),Gl=r("p"),Gl.textContent=tv,Z_=s(),El=r("div"),l(Gr.$$.fragment),Bg=s(),zt=r("div"),l(Er.$$.fragment),D_=s(),Xl=r("div"),l(Xr.$$.fragment),qg=s(),Ke=r("div"),l(Nr.$$.fragment),P_=s(),Nl=r("p"),Nl.innerHTML=nv,G_=s(),Rl=r("div"),l(Rr.$$.fragment),Wg=s(),et=r("div"),l(Hr.$$.fragment),E_=s(),Hl=r("p"),Hl.innerHTML=sv,X_=s(),Ol=r("div"),l(Or.$$.fragment),Vg=s(),l(Qr.$$.fragment),Sg=s(),Ar=r("p"),Ar.innerHTML=ov,Zg=s(),L=r("div"),l(Yr.$$.fragment),N_=s(),Ql=r("p"),Ql.textContent=rv,R_=s(),Al=r("p"),Al.textContent=av,H_=s(),l(an.$$.fragment),O_=s(),Yl=r("p"),Yl.textContent=iv,Q_=s(),cn=r("div"),l(Kr.$$.fragment),A_=s(),Kl=r("p"),Kl.textContent=cv,Y_=s(),ln=r("div"),l(ea.$$.fragment),K_=s(),ed=r("p"),ed.textContent=lv,eb=s(),dn=r("div"),l(ta.$$.fragment),tb=s(),td=r("p"),td.textContent=dv,nb=s(),pn=r("div"),l(na.$$.fragment),sb=s(),nd=r("p"),nd.innerHTML=pv,ob=s(),mn=r("div"),l(sa.$$.fragment),rb=s(),sd=r("p"),sd.textContent=mv,ab=s(),gn=r("div"),l(oa.$$.fragment),ib=s(),od=r("p"),od.textContent=gv,cb=s(),st=r("div"),l(ra.$$.fragment),lb=s(),rd=r("p"),rd.innerHTML=uv,db=s(),ad=r("p"),ad.textContent=hv,Dg=s(),Ut=r("div"),l(aa.$$.fragment),pb=s(),id=r("p"),id.innerHTML=fv,Pg=s(),Jt=r("div"),l(ia.$$.fragment),mb=s(),cd=r("p"),cd.innerHTML=_v,Gg=s(),K=r("div"),l(ca.$$.fragment),gb=s(),ld=r("p"),ld.textContent=bv,ub=s(),B=r("div"),l(la.$$.fragment),hb=s(),dd=r("p"),dd.textContent=Tv,fb=s(),pd=r("p"),pd.innerHTML=yv,_b=s(),md=r("p"),md.innerHTML=vv,bb=s(),gd=r("p"),gd.innerHTML=$v,Tb=s(),ud=r("p"),ud.textContent=wv,yb=s(),un=r("div"),l(da.$$.fragment),vb=s(),hd=r("p"),hd.textContent=xv,Eg=s(),l(pa.$$.fragment),Xg=s(),ee=r("div"),l(ma.$$.fragment),$b=s(),fd=r("p"),fd.innerHTML=kv,wb=s(),_d=r("div"),l(ga.$$.fragment),xb=s(),bd=r("div"),l(ua.$$.fragment),Ng=s(),I=r("div"),l(ha.$$.fragment),kb=s(),Td=r("p"),Td.innerHTML=Mv,Mb=s(),yd=r("p"),yd.innerHTML=jv,jb=s(),vd=r("p"),vd.innerHTML=Lv,Lb=s(),$d=r("div"),l(fa.$$.fragment),Fb=s(),wd=r("div"),l(_a.$$.fragment),Rg=s(),te=r("div"),l(ba.$$.fragment),zb=s(),xd=r("p"),xd.innerHTML=Fv,Ub=s(),kd=r("div"),l(Ta.$$.fragment),Jb=s(),Md=r("div"),l(ya.$$.fragment),Hg=s(),l(va.$$.fragment),Og=s(),tt=r("div"),l($a.$$.fragment),Ib=s(),jd=r("p"),jd.textContent=zv,Cb=s(),Ld=r("p"),Ld.innerHTML=Uv,Qg=s(),nt=r("div"),l(wa.$$.fragment),Bb=s(),Fd=r("p"),Fd.textContent=Jv,qb=s(),zd=r("p"),zd.innerHTML=Iv,Ag=s(),l(xa.$$.fragment),Yg=s(),J=r("div"),l(ka.$$.fragment),Wb=s(),Ud=r("p"),Ud.textContent=Cv,Vb=s(),l(hn.$$.fragment),Sb=s(),l(fn.$$.fragment),Zb=s(),_n=r("div"),l(Ma.$$.fragment),Db=s(),Jd=r("p"),Jd.textContent=Bv,Pb=s(),bn=r("div"),l(ja.$$.fragment),Gb=s(),Id=r("p"),Id.textContent=qv,Eb=s(),Tn=r("div"),l(La.$$.fragment),Xb=s(),Cd=r("p"),Cd.textContent=Wv,Kg=s(),D=r("div"),l(Fa.$$.fragment),Nb=s(),Bd=r("p"),Bd.textContent=Vv,Rb=s(),l(yn.$$.fragment),Hb=s(),l(vn.$$.fragment),Ob=s(),$n=r("div"),l(za.$$.fragment),Qb=s(),qd=r("p"),qd.textContent=Sv,eu=s(),Bp=r("p"),this.h()},l(e){const i=tw("svelte-u9bgzb",document.head);f=a(i,"META",{name:!0,content:!0}),i.forEach(n),x=o(e),$=a(e,"P",{}),_($).forEach(n),v=o(e),d(w.$$.fragment,e),h=o(e),k=a(e,"P",{"data-svelte-h":!0}),y(k)!=="svelte-l8fur4"&&(k.innerHTML=Ab),qp=o(e),Bn=a(e,"P",{"data-svelte-h":!0}),y(Bn)!=="svelte-1blns9e"&&(Bn.textContent=Yb),Wp=o(e),d(qn.$$.fragment,e),Vp=o(e),Wn=a(e,"P",{"data-svelte-h":!0}),y(Wn)!=="svelte-1gg7gaa"&&(Wn.innerHTML=Kb),Sp=o(e),Vn=a(e,"P",{"data-svelte-h":!0}),y(Vn)!=="svelte-wwwyth"&&(Vn.textContent=eT),Zp=o(e),d(Sn.$$.fragment,e),Dp=o(e),Zn=a(e,"P",{"data-svelte-h":!0}),y(Zn)!=="svelte-1fgti5v"&&(Zn.innerHTML=tT),Pp=o(e),Dn=a(e,"UL",{"data-svelte-h":!0}),y(Dn)!=="svelte-1arpy9m"&&(Dn.innerHTML=nT),Gp=o(e),Pn=a(e,"P",{"data-svelte-h":!0}),y(Pn)!=="svelte-xh59rv"&&(Pn.innerHTML=sT),Ep=o(e),Gn=a(e,"P",{"data-svelte-h":!0}),y(Gn)!=="svelte-rqavqw"&&(Gn.innerHTML=oT),Xp=o(e),En=a(e,"P",{"data-svelte-h":!0}),y(En)!=="svelte-qr02he"&&(En.innerHTML=rT),Np=o(e),d(Xn.$$.fragment,e),Rp=o(e),Nn=a(e,"P",{"data-svelte-h":!0}),y(Nn)!=="svelte-114v74y"&&(Nn.innerHTML=aT),Hp=o(e),Rn=a(e,"P",{"data-svelte-h":!0}),y(Rn)!=="svelte-13knclg"&&(Rn.innerHTML=iT),Op=o(e),Hn=a(e,"P",{"data-svelte-h":!0}),y(Hn)!=="svelte-gz8gow"&&(Hn.textContent=cT),Qp=o(e),d(On.$$.fragment,e),Ap=o(e),dt=a(e,"DIV",{class:!0});var Ua=_(dt);d(Qn.$$.fragment,Ua),$u=o(Ua),Ya=a(Ua,"P",{"data-svelte-h":!0}),y(Ya)!=="svelte-1bnrp61"&&(Ya.textContent=lT),Ua.forEach(n),Yp=o(e),pt=a(e,"DIV",{class:!0});var Ja=_(pt);d(An.$$.fragment,Ja),wu=o(Ja),Ka=a(Ja,"P",{"data-svelte-h":!0}),y(Ka)!=="svelte-fenhkk"&&(Ka.textContent=dT),Ja.forEach(n),Kp=o(e),mt=a(e,"DIV",{class:!0});var Ia=_(mt);d(Yn.$$.fragment,Ia),xu=o(Ia),ei=a(Ia,"P",{"data-svelte-h":!0}),y(ei)!=="svelte-1dqtgq4"&&(ei.textContent=pT),Ia.forEach(n),em=o(e),gt=a(e,"DIV",{class:!0});var Ca=_(gt);d(Kn.$$.fragment,Ca),ku=o(Ca),ti=a(Ca,"P",{"data-svelte-h":!0}),y(ti)!=="svelte-10orfv5"&&(ti.textContent=mT),Ca.forEach(n),tm=o(e),ut=a(e,"DIV",{class:!0});var Ba=_(ut);d(es.$$.fragment,Ba),Mu=o(Ba),ni=a(Ba,"P",{"data-svelte-h":!0}),y(ni)!=="svelte-jg8udg"&&(ni.textContent=gT),Ba.forEach(n),nm=o(e),ht=a(e,"DIV",{class:!0});var qa=_(ht);d(ts.$$.fragment,qa),ju=o(qa),si=a(qa,"P",{"data-svelte-h":!0}),y(si)!=="svelte-1i40667"&&(si.textContent=uT),qa.forEach(n),sm=o(e),ft=a(e,"DIV",{class:!0});var Wa=_(ft);d(ns.$$.fragment,Wa),Lu=o(Wa),oi=a(Wa,"P",{"data-svelte-h":!0}),y(oi)!=="svelte-n5fi8x"&&(oi.textContent=hT),Wa.forEach(n),om=o(e),_t=a(e,"DIV",{class:!0});var Va=_(_t);d(ss.$$.fragment,Va),Fu=o(Va),ri=a(Va,"P",{"data-svelte-h":!0}),y(ri)!=="svelte-h5pj3l"&&(ri.textContent=fT),Va.forEach(n),rm=o(e),bt=a(e,"DIV",{class:!0});var Sa=_(bt);d(os.$$.fragment,Sa),zu=o(Sa),ai=a(Sa,"P",{"data-svelte-h":!0}),y(ai)!=="svelte-pru3ks"&&(ai.textContent=_T),Sa.forEach(n),am=o(e),Tt=a(e,"DIV",{class:!0});var Za=_(Tt);d(rs.$$.fragment,Za),Uu=o(Za),ii=a(Za,"P",{"data-svelte-h":!0}),y(ii)!=="svelte-pru3ks"&&(ii.textContent=bT),Za.forEach(n),im=o(e),d(as.$$.fragment,e),cm=o(e),yt=a(e,"DIV",{class:!0});var Da=_(yt);d(is.$$.fragment,Da),Ju=o(Da),ci=a(Da,"P",{"data-svelte-h":!0}),y(ci)!=="svelte-1bnrp61"&&(ci.textContent=TT),Da.forEach(n),lm=o(e),vt=a(e,"DIV",{class:!0});var Pa=_(vt);d(cs.$$.fragment,Pa),Iu=o(Pa),li=a(Pa,"P",{"data-svelte-h":!0}),y(li)!=="svelte-fenhkk"&&(li.textContent=yT),Pa.forEach(n),dm=o(e),$t=a(e,"DIV",{class:!0});var Ga=_($t);d(ls.$$.fragment,Ga),Cu=o(Ga),di=a(Ga,"P",{"data-svelte-h":!0}),y(di)!=="svelte-1dqtgq4"&&(di.textContent=vT),Ga.forEach(n),pm=o(e),wt=a(e,"DIV",{class:!0});var Ea=_(wt);d(ds.$$.fragment,Ea),Bu=o(Ea),pi=a(Ea,"P",{"data-svelte-h":!0}),y(pi)!=="svelte-10orfv5"&&(pi.textContent=$T),Ea.forEach(n),mm=o(e),xt=a(e,"DIV",{class:!0});var Xa=_(xt);d(ps.$$.fragment,Xa),qu=o(Xa),mi=a(Xa,"P",{"data-svelte-h":!0}),y(mi)!=="svelte-jg8udg"&&(mi.textContent=wT),Xa.forEach(n),gm=o(e),kt=a(e,"DIV",{class:!0});var Na=_(kt);d(ms.$$.fragment,Na),Wu=o(Na),gi=a(Na,"P",{"data-svelte-h":!0}),y(gi)!=="svelte-1i40667"&&(gi.textContent=xT),Na.forEach(n),um=o(e),Mt=a(e,"DIV",{class:!0});var Ra=_(Mt);d(gs.$$.fragment,Ra),Vu=o(Ra),ui=a(Ra,"P",{"data-svelte-h":!0}),y(ui)!=="svelte-n5fi8x"&&(ui.textContent=kT),Ra.forEach(n),hm=o(e),jt=a(e,"DIV",{class:!0});var Ha=_(jt);d(us.$$.fragment,Ha),Su=o(Ha),hi=a(Ha,"P",{"data-svelte-h":!0}),y(hi)!=="svelte-h5pj3l"&&(hi.textContent=MT),Ha.forEach(n),fm=o(e),Lt=a(e,"DIV",{class:!0});var Oa=_(Lt);d(hs.$$.fragment,Oa),Zu=o(Oa),fi=a(Oa,"P",{"data-svelte-h":!0}),y(fi)!=="svelte-b9zq6n"&&(fi.textContent=jT),Oa.forEach(n),_m=o(e),Ft=a(e,"DIV",{class:!0});var Qa=_(Ft);d(fs.$$.fragment,Qa),Du=o(Qa),_i=a(Qa,"P",{"data-svelte-h":!0}),y(_i)!=="svelte-pru3ks"&&(_i.textContent=LT),Qa.forEach(n),bm=o(e),d(_s.$$.fragment,e),Tm=o(e),oe=a(e,"DIV",{class:!0});var It=_(oe);d(bs.$$.fragment,It),Pu=o(It),bi=a(It,"P",{"data-svelte-h":!0}),y(bi)!=="svelte-qoov36"&&(bi.textContent=FT),Gu=o(It),Bt=a(It,"DIV",{class:!0});var Aa=_(Bt);d(Ts.$$.fragment,Aa),Eu=o(Aa),Ti=a(Aa,"P",{"data-svelte-h":!0}),y(Ti)!=="svelte-5ihtpa"&&(Ti.textContent=zT),Aa.forEach(n),It.forEach(n),ym=o(e),re=a(e,"DIV",{class:!0});var Ct=_(re);d(ys.$$.fragment,Ct),Xu=o(Ct),yi=a(Ct,"P",{"data-svelte-h":!0}),y(yi)!=="svelte-1tz7qrd"&&(yi.textContent=UT),Nu=o(Ct),qt=a(Ct,"DIV",{class:!0});var nu=_(qt);d(vs.$$.fragment,nu),Ru=o(nu),vi=a(nu,"P",{"data-svelte-h":!0}),y(vi)!=="svelte-5ihtpa"&&(vi.textContent=JT),nu.forEach(n),Ct.forEach(n),vm=o(e),ae=a(e,"DIV",{class:!0});var Wd=_(ae);d($s.$$.fragment,Wd),Hu=o(Wd),$i=a(Wd,"P",{"data-svelte-h":!0}),y($i)!=="svelte-1tz7qrd"&&($i.textContent=IT),Ou=o(Wd),Wt=a(Wd,"DIV",{class:!0});var su=_(Wt);d(ws.$$.fragment,su),Qu=o(su),wi=a(su,"P",{"data-svelte-h":!0}),y(wi)!=="svelte-5ihtpa"&&(wi.textContent=CT),su.forEach(n),Wd.forEach(n),$m=o(e),d(xs.$$.fragment,e),wm=o(e),ks=a(e,"P",{"data-svelte-h":!0}),y(ks)!=="svelte-f3yvc7"&&(ks.innerHTML=BT),xm=o(e),d(Ms.$$.fragment,e),km=o(e),ie=a(e,"DIV",{class:!0});var Vd=_(ie);d(js.$$.fragment,Vd),Au=o(Vd),xi=a(Vd,"P",{"data-svelte-h":!0}),y(xi)!=="svelte-drtesy"&&(xi.innerHTML=qT),Yu=o(Vd),ki=a(Vd,"DIV",{class:!0});var Zv=_(ki);d(Ls.$$.fragment,Zv),Zv.forEach(n),Vd.forEach(n),Mm=o(e),X=a(e,"DIV",{class:!0});var wn=_(X);d(Fs.$$.fragment,wn),Ku=o(wn),Mi=a(wn,"P",{"data-svelte-h":!0}),y(Mi)!=="svelte-151ju3h"&&(Mi.innerHTML=WT),eh=o(wn),ji=a(wn,"P",{"data-svelte-h":!0}),y(ji)!=="svelte-lu7kru"&&(ji.innerHTML=VT),th=o(wn),Li=a(wn,"DIV",{class:!0});var Dv=_(Li);d(zs.$$.fragment,Dv),Dv.forEach(n),wn.forEach(n),jm=o(e),ce=a(e,"DIV",{class:!0});var Sd=_(ce);d(Us.$$.fragment,Sd),nh=o(Sd),Fi=a(Sd,"P",{"data-svelte-h":!0}),y(Fi)!=="svelte-i2uxap"&&(Fi.innerHTML=ST),sh=o(Sd),zi=a(Sd,"DIV",{class:!0});var Pv=_(zi);d(Js.$$.fragment,Pv),Pv.forEach(n),Sd.forEach(n),Lm=o(e),le=a(e,"DIV",{class:!0});var Zd=_(le);d(Is.$$.fragment,Zd),oh=o(Zd),Ui=a(Zd,"P",{"data-svelte-h":!0}),y(Ui)!=="svelte-1euyjy8"&&(Ui.innerHTML=ZT),rh=o(Zd),Ji=a(Zd,"DIV",{class:!0});var Gv=_(Ji);d(Cs.$$.fragment,Gv),Gv.forEach(n),Zd.forEach(n),Fm=o(e),N=a(e,"DIV",{class:!0});var xn=_(N);d(Bs.$$.fragment,xn),ah=o(xn),Ii=a(xn,"P",{"data-svelte-h":!0}),y(Ii)!=="svelte-1g3p3yi"&&(Ii.innerHTML=DT),ih=o(xn),d(Vt.$$.fragment,xn),ch=o(xn),Ci=a(xn,"DIV",{class:!0});var Ev=_(Ci);d(qs.$$.fragment,Ev),Ev.forEach(n),xn.forEach(n),zm=o(e),R=a(e,"DIV",{class:!0});var kn=_(R);d(Ws.$$.fragment,kn),lh=o(kn),Bi=a(kn,"P",{"data-svelte-h":!0}),y(Bi)!=="svelte-9coi3i"&&(Bi.innerHTML=PT),dh=o(kn),d(St.$$.fragment,kn),ph=o(kn),qi=a(kn,"DIV",{class:!0});var Xv=_(qi);d(Vs.$$.fragment,Xv),Xv.forEach(n),kn.forEach(n),Um=o(e),H=a(e,"DIV",{class:!0});var Mn=_(H);d(Ss.$$.fragment,Mn),mh=o(Mn),Wi=a(Mn,"P",{"data-svelte-h":!0}),y(Wi)!=="svelte-a8r3fr"&&(Wi.innerHTML=GT),gh=o(Mn),d(Zt.$$.fragment,Mn),uh=o(Mn),Vi=a(Mn,"DIV",{class:!0});var Nv=_(Vi);d(Zs.$$.fragment,Nv),Nv.forEach(n),Mn.forEach(n),Jm=o(e),de=a(e,"DIV",{class:!0});var Dd=_(de);d(Ds.$$.fragment,Dd),hh=o(Dd),Si=a(Dd,"P",{"data-svelte-h":!0}),y(Si)!=="svelte-ntadn"&&(Si.innerHTML=ET),fh=o(Dd),Zi=a(Dd,"DIV",{class:!0});var Rv=_(Zi);d(Ps.$$.fragment,Rv),Rv.forEach(n),Dd.forEach(n),Im=o(e),pe=a(e,"DIV",{class:!0});var Pd=_(pe);d(Gs.$$.fragment,Pd),_h=o(Pd),Di=a(Pd,"P",{"data-svelte-h":!0}),y(Di)!=="svelte-15g4knr"&&(Di.innerHTML=XT),bh=o(Pd),Pi=a(Pd,"DIV",{class:!0});var Hv=_(Pi);d(Es.$$.fragment,Hv),Hv.forEach(n),Pd.forEach(n),Cm=o(e),me=a(e,"DIV",{class:!0});var Gd=_(me);d(Xs.$$.fragment,Gd),Th=o(Gd),Gi=a(Gd,"P",{"data-svelte-h":!0}),y(Gi)!=="svelte-lka4kd"&&(Gi.innerHTML=NT),yh=o(Gd),Ei=a(Gd,"DIV",{class:!0});var Ov=_(Ei);d(Ns.$$.fragment,Ov),Ov.forEach(n),Gd.forEach(n),Bm=o(e),j=a(e,"DIV",{class:!0});var F=_(j);d(Rs.$$.fragment,F),vh=o(F),Xi=a(F,"P",{"data-svelte-h":!0}),y(Xi)!=="svelte-1dk14jl"&&(Xi.innerHTML=RT),$h=o(F),Ni=a(F,"P",{"data-svelte-h":!0}),y(Ni)!=="svelte-1t8rpl0"&&(Ni.innerHTML=HT),wh=o(F),d(Dt.$$.fragment,F),xh=o(F),d(Pt.$$.fragment,F),kh=o(F),Ri=a(F,"P",{"data-svelte-h":!0}),y(Ri)!=="svelte-2fpu88"&&(Ri.innerHTML=OT),Mh=o(F),Hi=a(F,"P",{"data-svelte-h":!0}),y(Hi)!=="svelte-1nj4y15"&&(Hi.textContent=QT),jh=o(F),Oi=a(F,"UL",{"data-svelte-h":!0}),y(Oi)!=="svelte-1knkx0p"&&(Oi.innerHTML=AT),Lh=o(F),Qi=a(F,"P",{"data-svelte-h":!0}),y(Qi)!=="svelte-5xwkxe"&&(Qi.textContent=YT),Fh=o(F),Ai=a(F,"UL",{"data-svelte-h":!0}),y(Ai)!=="svelte-7rlln8"&&(Ai.innerHTML=KT),zh=o(F),d(Gt.$$.fragment,F),Uh=o(F),Yi=a(F,"DIV",{class:!0});var Qv=_(Yi);d(Hs.$$.fragment,Qv),Qv.forEach(n),F.forEach(n),qm=o(e),ge=a(e,"DIV",{class:!0});var Ed=_(ge);d(Os.$$.fragment,Ed),Jh=o(Ed),Ki=a(Ed,"P",{"data-svelte-h":!0}),y(Ki)!=="svelte-1hcl0ha"&&(Ki.innerHTML=ey),Ih=o(Ed),ec=a(Ed,"DIV",{class:!0});var Av=_(ec);d(Qs.$$.fragment,Av),Av.forEach(n),Ed.forEach(n),Wm=o(e),ue=a(e,"DIV",{class:!0});var Xd=_(ue);d(As.$$.fragment,Xd),Ch=o(Xd),tc=a(Xd,"P",{"data-svelte-h":!0}),y(tc)!=="svelte-9gfnav"&&(tc.innerHTML=ty),Bh=o(Xd),nc=a(Xd,"DIV",{class:!0});var Yv=_(nc);d(Ys.$$.fragment,Yv),Yv.forEach(n),Xd.forEach(n),Vm=o(e),he=a(e,"DIV",{class:!0});var Nd=_(he);d(Ks.$$.fragment,Nd),qh=o(Nd),sc=a(Nd,"P",{"data-svelte-h":!0}),y(sc)!=="svelte-y1kta5"&&(sc.textContent=ny),Wh=o(Nd),oc=a(Nd,"DIV",{class:!0});var Kv=_(oc);d(eo.$$.fragment,Kv),Kv.forEach(n),Nd.forEach(n),Sm=o(e),fe=a(e,"DIV",{class:!0});var Rd=_(fe);d(to.$$.fragment,Rd),Vh=o(Rd),rc=a(Rd,"P",{"data-svelte-h":!0}),y(rc)!=="svelte-l8wqof"&&(rc.innerHTML=sy),Sh=o(Rd),ac=a(Rd,"DIV",{class:!0});var e$=_(ac);d(no.$$.fragment,e$),e$.forEach(n),Rd.forEach(n),Zm=o(e),_e=a(e,"DIV",{class:!0});var Hd=_(_e);d(so.$$.fragment,Hd),Zh=o(Hd),ic=a(Hd,"P",{"data-svelte-h":!0}),y(ic)!=="svelte-th82mu"&&(ic.textContent=oy),Dh=o(Hd),cc=a(Hd,"DIV",{class:!0});var t$=_(cc);d(oo.$$.fragment,t$),t$.forEach(n),Hd.forEach(n),Dm=o(e),be=a(e,"DIV",{class:!0});var Od=_(be);d(ro.$$.fragment,Od),Ph=o(Od),lc=a(Od,"P",{"data-svelte-h":!0}),y(lc)!=="svelte-nebqir"&&(lc.innerHTML=ry),Gh=o(Od),dc=a(Od,"DIV",{class:!0});var n$=_(dc);d(ao.$$.fragment,n$),n$.forEach(n),Od.forEach(n),Pm=o(e),O=a(e,"DIV",{class:!0});var jn=_(O);d(io.$$.fragment,jn),Eh=o(jn),pc=a(jn,"P",{"data-svelte-h":!0}),y(pc)!=="svelte-nrctmo"&&(pc.innerHTML=ay),Xh=o(jn),d(Et.$$.fragment,jn),Nh=o(jn),mc=a(jn,"DIV",{class:!0});var s$=_(mc);d(co.$$.fragment,s$),s$.forEach(n),jn.forEach(n),Gm=o(e),q=a(e,"DIV",{class:!0});var ot=_(q);d(lo.$$.fragment,ot),Rh=o(ot),gc=a(ot,"P",{"data-svelte-h":!0}),y(gc)!=="svelte-1seqc3n"&&(gc.innerHTML=iy),Hh=o(ot),d(Xt.$$.fragment,ot),Oh=o(ot),d(Nt.$$.fragment,ot),Qh=o(ot),uc=a(ot,"DIV",{class:!0});var o$=_(uc);d(po.$$.fragment,o$),o$.forEach(n),ot.forEach(n),Em=o(e),W=a(e,"DIV",{class:!0});var rt=_(W);d(mo.$$.fragment,rt),Ah=o(rt),hc=a(rt,"P",{"data-svelte-h":!0}),y(hc)!=="svelte-hhgmof"&&(hc.innerHTML=cy),Yh=o(rt),d(Rt.$$.fragment,rt),Kh=o(rt),d(Ht.$$.fragment,rt),ef=o(rt),fc=a(rt,"DIV",{class:!0});var r$=_(fc);d(go.$$.fragment,r$),r$.forEach(n),rt.forEach(n),Xm=o(e),Te=a(e,"DIV",{class:!0});var Qd=_(Te);d(uo.$$.fragment,Qd),tf=o(Qd),_c=a(Qd,"P",{"data-svelte-h":!0}),y(_c)!=="svelte-1yvu4vf"&&(_c.innerHTML=ly),nf=o(Qd),bc=a(Qd,"DIV",{class:!0});var a$=_(bc);d(ho.$$.fragment,a$),a$.forEach(n),Qd.forEach(n),Nm=o(e),Q=a(e,"DIV",{class:!0});var Ln=_(Q);d(fo.$$.fragment,Ln),sf=o(Ln),Tc=a(Ln,"P",{"data-svelte-h":!0}),y(Tc)!=="svelte-exwhzw"&&(Tc.innerHTML=dy),of=o(Ln),d(Ot.$$.fragment,Ln),rf=o(Ln),yc=a(Ln,"DIV",{class:!0});var i$=_(yc);d(_o.$$.fragment,i$),i$.forEach(n),Ln.forEach(n),Rm=o(e),V=a(e,"DIV",{class:!0});var at=_(V);d(bo.$$.fragment,at),af=o(at),vc=a(at,"P",{"data-svelte-h":!0}),y(vc)!=="svelte-17fg652"&&(vc.innerHTML=py),cf=o(at),d(Qt.$$.fragment,at),lf=o(at),d(At.$$.fragment,at),df=o(at),$c=a(at,"DIV",{class:!0});var c$=_($c);d(To.$$.fragment,c$),c$.forEach(n),at.forEach(n),Hm=o(e),ye=a(e,"DIV",{class:!0});var Ad=_(ye);d(yo.$$.fragment,Ad),pf=o(Ad),wc=a(Ad,"P",{"data-svelte-h":!0}),y(wc)!=="svelte-1171zzm"&&(wc.innerHTML=my),mf=o(Ad),xc=a(Ad,"DIV",{class:!0});var l$=_(xc);d(vo.$$.fragment,l$),l$.forEach(n),Ad.forEach(n),Om=o(e),ve=a(e,"DIV",{class:!0});var Yd=_(ve);d($o.$$.fragment,Yd),gf=o(Yd),kc=a(Yd,"P",{"data-svelte-h":!0}),y(kc)!=="svelte-a554sd"&&(kc.innerHTML=gy),uf=o(Yd),Mc=a(Yd,"DIV",{class:!0});var d$=_(Mc);d(wo.$$.fragment,d$),d$.forEach(n),Yd.forEach(n),Qm=o(e),S=a(e,"DIV",{class:!0});var it=_(S);d(xo.$$.fragment,it),hf=o(it),jc=a(it,"P",{"data-svelte-h":!0}),y(jc)!=="svelte-jf5ff1"&&(jc.innerHTML=uy),ff=o(it),d(Yt.$$.fragment,it),_f=o(it),d(Kt.$$.fragment,it),bf=o(it),Lc=a(it,"DIV",{class:!0});var p$=_(Lc);d(ko.$$.fragment,p$),p$.forEach(n),it.forEach(n),Am=o(e),$e=a(e,"DIV",{class:!0});var Kd=_($e);d(Mo.$$.fragment,Kd),Tf=o(Kd),Fc=a(Kd,"P",{"data-svelte-h":!0}),y(Fc)!=="svelte-4ojcid"&&(Fc.innerHTML=hy),yf=o(Kd),zc=a(Kd,"DIV",{class:!0});var m$=_(zc);d(jo.$$.fragment,m$),m$.forEach(n),Kd.forEach(n),Ym=o(e),A=a(e,"DIV",{class:!0});var Fn=_(A);d(Lo.$$.fragment,Fn),vf=o(Fn),Uc=a(Fn,"P",{"data-svelte-h":!0}),y(Uc)!=="svelte-1izb6kv"&&(Uc.innerHTML=fy),$f=o(Fn),d(en.$$.fragment,Fn),wf=o(Fn),Jc=a(Fn,"DIV",{class:!0});var g$=_(Jc);d(Fo.$$.fragment,g$),g$.forEach(n),Fn.forEach(n),Km=o(e),we=a(e,"DIV",{class:!0});var ep=_(we);d(zo.$$.fragment,ep),xf=o(ep),Ic=a(ep,"P",{"data-svelte-h":!0}),y(Ic)!=="svelte-2tw0se"&&(Ic.innerHTML=_y),kf=o(ep),Cc=a(ep,"DIV",{class:!0});var u$=_(Cc);d(Uo.$$.fragment,u$),u$.forEach(n),ep.forEach(n),eg=o(e),Z=a(e,"DIV",{class:!0});var ct=_(Z);d(Jo.$$.fragment,ct),Mf=o(ct),Bc=a(ct,"P",{"data-svelte-h":!0}),y(Bc)!=="svelte-pi0cpg"&&(Bc.innerHTML=by),jf=o(ct),qc=a(ct,"P",{"data-svelte-h":!0}),y(qc)!=="svelte-5qs7tv"&&(qc.innerHTML=Ty),Lf=o(ct),d(tn.$$.fragment,ct),Ff=o(ct),Wc=a(ct,"DIV",{class:!0});var h$=_(Wc);d(Io.$$.fragment,h$),h$.forEach(n),ct.forEach(n),tg=o(e),Y=a(e,"DIV",{class:!0});var zn=_(Y);d(Co.$$.fragment,zn),zf=o(zn),Vc=a(zn,"P",{"data-svelte-h":!0}),y(Vc)!=="svelte-1sygpwz"&&(Vc.innerHTML=yy),Uf=o(zn),Sc=a(zn,"P",{"data-svelte-h":!0}),y(Sc)!=="svelte-qmmn5t"&&(Sc.innerHTML=vy),Jf=o(zn),Zc=a(zn,"DIV",{class:!0});var f$=_(Zc);d(Bo.$$.fragment,f$),f$.forEach(n),zn.forEach(n),ng=o(e),d(qo.$$.fragment,e),sg=o(e),xe=a(e,"DIV",{class:!0});var tp=_(xe);d(Wo.$$.fragment,tp),If=o(tp),Dc=a(tp,"P",{"data-svelte-h":!0}),y(Dc)!=="svelte-voeybv"&&(Dc.innerHTML=$y),Cf=o(tp),Pc=a(tp,"DIV",{class:!0});var _$=_(Pc);d(Vo.$$.fragment,_$),_$.forEach(n),tp.forEach(n),og=o(e),ke=a(e,"DIV",{class:!0});var np=_(ke);d(So.$$.fragment,np),Bf=o(np),Gc=a(np,"P",{"data-svelte-h":!0}),y(Gc)!=="svelte-17rwet3"&&(Gc.innerHTML=wy),qf=o(np),Ec=a(np,"DIV",{class:!0});var b$=_(Ec);d(Zo.$$.fragment,b$),b$.forEach(n),np.forEach(n),rg=o(e),Me=a(e,"DIV",{class:!0});var sp=_(Me);d(Do.$$.fragment,sp),Wf=o(sp),Xc=a(sp,"P",{"data-svelte-h":!0}),y(Xc)!=="svelte-1557waw"&&(Xc.innerHTML=xy),Vf=o(sp),Nc=a(sp,"DIV",{class:!0});var T$=_(Nc);d(Po.$$.fragment,T$),T$.forEach(n),sp.forEach(n),ag=o(e),je=a(e,"DIV",{class:!0});var op=_(je);d(Go.$$.fragment,op),Sf=o(op),Rc=a(op,"P",{"data-svelte-h":!0}),y(Rc)!=="svelte-y1kta5"&&(Rc.textContent=ky),Zf=o(op),nn=a(op,"DIV",{class:!0});var ou=_(nn);d(Eo.$$.fragment,ou),Df=o(ou),Hc=a(ou,"P",{"data-svelte-h":!0}),y(Hc)!=="svelte-5aspnb"&&(Hc.textContent=My),ou.forEach(n),op.forEach(n),ig=o(e),Le=a(e,"DIV",{class:!0});var rp=_(Le);d(Xo.$$.fragment,rp),Pf=o(rp),Oc=a(rp,"P",{"data-svelte-h":!0}),y(Oc)!=="svelte-16xpl5j"&&(Oc.innerHTML=jy),Gf=o(rp),Qc=a(rp,"DIV",{class:!0});var y$=_(Qc);d(No.$$.fragment,y$),y$.forEach(n),rp.forEach(n),cg=o(e),Fe=a(e,"DIV",{class:!0});var ap=_(Fe);d(Ro.$$.fragment,ap),Ef=o(ap),Ac=a(ap,"P",{"data-svelte-h":!0}),y(Ac)!=="svelte-th82mu"&&(Ac.textContent=Ly),Xf=o(ap),sn=a(ap,"DIV",{class:!0});var ru=_(sn);d(Ho.$$.fragment,ru),Nf=o(ru),Yc=a(ru,"P",{"data-svelte-h":!0}),y(Yc)!=="svelte-hcoglc"&&(Yc.textContent=Fy),ru.forEach(n),ap.forEach(n),lg=o(e),ze=a(e,"DIV",{class:!0});var ip=_(ze);d(Oo.$$.fragment,ip),Rf=o(ip),Kc=a(ip,"P",{"data-svelte-h":!0}),y(Kc)!=="svelte-1wj83fn"&&(Kc.innerHTML=zy),Hf=o(ip),el=a(ip,"DIV",{class:!0});var v$=_(el);d(Qo.$$.fragment,v$),v$.forEach(n),ip.forEach(n),dg=o(e),Ue=a(e,"DIV",{class:!0});var cp=_(Ue);d(Ao.$$.fragment,cp),Of=o(cp),tl=a(cp,"P",{"data-svelte-h":!0}),y(tl)!=="svelte-1lbpi80"&&(tl.innerHTML=Uy),Qf=o(cp),nl=a(cp,"DIV",{class:!0});var $$=_(nl);d(Yo.$$.fragment,$$),$$.forEach(n),cp.forEach(n),pg=o(e),Je=a(e,"DIV",{class:!0});var lp=_(Je);d(Ko.$$.fragment,lp),Af=o(lp),sl=a(lp,"P",{"data-svelte-h":!0}),y(sl)!=="svelte-l6uyww"&&(sl.innerHTML=Jy),Yf=o(lp),ol=a(lp,"DIV",{class:!0});var w$=_(ol);d(er.$$.fragment,w$),w$.forEach(n),lp.forEach(n),mg=o(e),Ie=a(e,"DIV",{class:!0});var dp=_(Ie);d(tr.$$.fragment,dp),Kf=o(dp),rl=a(dp,"P",{"data-svelte-h":!0}),y(rl)!=="svelte-g5f6kf"&&(rl.innerHTML=Iy),e_=o(dp),al=a(dp,"DIV",{class:!0});var x$=_(al);d(nr.$$.fragment,x$),x$.forEach(n),dp.forEach(n),gg=o(e),Ce=a(e,"DIV",{class:!0});var pp=_(Ce);d(sr.$$.fragment,pp),t_=o(pp),il=a(pp,"P",{"data-svelte-h":!0}),y(il)!=="svelte-t5gdhi"&&(il.innerHTML=Cy),n_=o(pp),cl=a(pp,"DIV",{class:!0});var k$=_(cl);d(or.$$.fragment,k$),k$.forEach(n),pp.forEach(n),ug=o(e),Be=a(e,"DIV",{class:!0});var mp=_(Be);d(rr.$$.fragment,mp),s_=o(mp),ll=a(mp,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-a554sd"&&(ll.innerHTML=By),o_=o(mp),dl=a(mp,"DIV",{class:!0});var M$=_(dl);d(ar.$$.fragment,M$),M$.forEach(n),mp.forEach(n),hg=o(e),qe=a(e,"DIV",{class:!0});var gp=_(qe);d(ir.$$.fragment,gp),r_=o(gp),pl=a(gp,"P",{"data-svelte-h":!0}),y(pl)!=="svelte-19favda"&&(pl.innerHTML=qy),a_=o(gp),ml=a(gp,"DIV",{class:!0});var j$=_(ml);d(cr.$$.fragment,j$),j$.forEach(n),gp.forEach(n),fg=o(e),We=a(e,"DIV",{class:!0});var up=_(We);d(lr.$$.fragment,up),i_=o(up),gl=a(up,"P",{"data-svelte-h":!0}),y(gl)!=="svelte-pjbkwd"&&(gl.innerHTML=Wy),c_=o(up),ul=a(up,"DIV",{class:!0});var L$=_(ul);d(dr.$$.fragment,L$),L$.forEach(n),up.forEach(n),_g=o(e),Ve=a(e,"DIV",{class:!0});var hp=_(Ve);d(pr.$$.fragment,hp),l_=o(hp),hl=a(hp,"P",{"data-svelte-h":!0}),y(hl)!=="svelte-18sh8t7"&&(hl.innerHTML=Vy),d_=o(hp),fl=a(hp,"DIV",{class:!0});var F$=_(fl);d(mr.$$.fragment,F$),F$.forEach(n),hp.forEach(n),bg=o(e),d(gr.$$.fragment,e),Tg=o(e),Se=a(e,"DIV",{class:!0});var fp=_(Se);d(ur.$$.fragment,fp),p_=o(fp),_l=a(fp,"P",{"data-svelte-h":!0}),y(_l)!=="svelte-zv94bn"&&(_l.innerHTML=Sy),m_=o(fp),bl=a(fp,"DIV",{class:!0});var z$=_(bl);d(hr.$$.fragment,z$),z$.forEach(n),fp.forEach(n),yg=o(e),Ze=a(e,"DIV",{class:!0});var _p=_(Ze);d(fr.$$.fragment,_p),g_=o(_p),Tl=a(_p,"P",{"data-svelte-h":!0}),y(Tl)!=="svelte-1yf8m7"&&(Tl.innerHTML=Zy),u_=o(_p),yl=a(_p,"DIV",{class:!0});var U$=_(yl);d(_r.$$.fragment,U$),U$.forEach(n),_p.forEach(n),vg=o(e),De=a(e,"DIV",{class:!0});var bp=_(De);d(br.$$.fragment,bp),h_=o(bp),vl=a(bp,"P",{"data-svelte-h":!0}),y(vl)!=="svelte-rkuqik"&&(vl.innerHTML=Dy),f_=o(bp),$l=a(bp,"DIV",{class:!0});var J$=_($l);d(Tr.$$.fragment,J$),J$.forEach(n),bp.forEach(n),$g=o(e),Pe=a(e,"DIV",{class:!0});var Tp=_(Pe);d(yr.$$.fragment,Tp),__=o(Tp),wl=a(Tp,"P",{"data-svelte-h":!0}),y(wl)!=="svelte-y1kta5"&&(wl.textContent=Py),b_=o(Tp),on=a(Tp,"DIV",{class:!0});var au=_(on);d(vr.$$.fragment,au),T_=o(au),xl=a(au,"P",{"data-svelte-h":!0}),y(xl)!=="svelte-1l17mwc"&&(xl.textContent=Gy),au.forEach(n),Tp.forEach(n),wg=o(e),Ge=a(e,"DIV",{class:!0});var yp=_(Ge);d($r.$$.fragment,yp),y_=o(yp),kl=a(yp,"P",{"data-svelte-h":!0}),y(kl)!=="svelte-1msuvzz"&&(kl.innerHTML=Ey),v_=o(yp),Ml=a(yp,"DIV",{class:!0});var I$=_(Ml);d(wr.$$.fragment,I$),I$.forEach(n),yp.forEach(n),xg=o(e),Ee=a(e,"DIV",{class:!0});var vp=_(Ee);d(xr.$$.fragment,vp),$_=o(vp),jl=a(vp,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-th82mu"&&(jl.textContent=Xy),w_=o(vp),rn=a(vp,"DIV",{class:!0});var iu=_(rn);d(kr.$$.fragment,iu),x_=o(iu),Ll=a(iu,"P",{"data-svelte-h":!0}),y(Ll)!=="svelte-1tcb5cf"&&(Ll.textContent=Ny),iu.forEach(n),vp.forEach(n),kg=o(e),Xe=a(e,"DIV",{class:!0});var $p=_(Xe);d(Mr.$$.fragment,$p),k_=o($p),Fl=a($p,"P",{"data-svelte-h":!0}),y(Fl)!=="svelte-kpdw0r"&&(Fl.innerHTML=Ry),M_=o($p),zl=a($p,"DIV",{class:!0});var C$=_(zl);d(jr.$$.fragment,C$),C$.forEach(n),$p.forEach(n),Mg=o(e),Ne=a(e,"DIV",{class:!0});var wp=_(Ne);d(Lr.$$.fragment,wp),j_=o(wp),Ul=a(wp,"P",{"data-svelte-h":!0}),y(Ul)!=="svelte-13b3njj"&&(Ul.innerHTML=Hy),L_=o(wp),Jl=a(wp,"DIV",{class:!0});var B$=_(Jl);d(Fr.$$.fragment,B$),B$.forEach(n),wp.forEach(n),jg=o(e),Re=a(e,"DIV",{class:!0});var xp=_(Re);d(zr.$$.fragment,xp),F_=o(xp),Il=a(xp,"P",{"data-svelte-h":!0}),y(Il)!=="svelte-gno4o1"&&(Il.innerHTML=Oy),z_=o(xp),Cl=a(xp,"DIV",{class:!0});var q$=_(Cl);d(Ur.$$.fragment,q$),q$.forEach(n),xp.forEach(n),Lg=o(e),He=a(e,"DIV",{class:!0});var kp=_(He);d(Jr.$$.fragment,kp),U_=o(kp),Bl=a(kp,"P",{"data-svelte-h":!0}),y(Bl)!=="svelte-sxr190"&&(Bl.innerHTML=Qy),J_=o(kp),ql=a(kp,"DIV",{class:!0});var W$=_(ql);d(Ir.$$.fragment,W$),W$.forEach(n),kp.forEach(n),Fg=o(e),Oe=a(e,"DIV",{class:!0});var Mp=_(Oe);d(Cr.$$.fragment,Mp),I_=o(Mp),Wl=a(Mp,"P",{"data-svelte-h":!0}),y(Wl)!=="svelte-niszw7"&&(Wl.innerHTML=Ay),C_=o(Mp),Vl=a(Mp,"DIV",{class:!0});var V$=_(Vl);d(Br.$$.fragment,V$),V$.forEach(n),Mp.forEach(n),zg=o(e),Qe=a(e,"DIV",{class:!0});var jp=_(Qe);d(qr.$$.fragment,jp),B_=o(jp),Sl=a(jp,"P",{"data-svelte-h":!0}),y(Sl)!=="svelte-110n4jl"&&(Sl.innerHTML=Yy),q_=o(jp),Zl=a(jp,"DIV",{class:!0});var S$=_(Zl);d(Wr.$$.fragment,S$),S$.forEach(n),jp.forEach(n),Ug=o(e),Ae=a(e,"DIV",{class:!0});var Lp=_(Ae);d(Vr.$$.fragment,Lp),W_=o(Lp),Dl=a(Lp,"P",{"data-svelte-h":!0}),y(Dl)!=="svelte-1sygpwz"&&(Dl.innerHTML=Ky),V_=o(Lp),Pl=a(Lp,"DIV",{class:!0});var Z$=_(Pl);d(Sr.$$.fragment,Z$),Z$.forEach(n),Lp.forEach(n),Jg=o(e),d(Zr.$$.fragment,e),Ig=o(e),Dr=a(e,"P",{"data-svelte-h":!0}),y(Dr)!=="svelte-16avlbn"&&(Dr.innerHTML=ev),Cg=o(e),Ye=a(e,"DIV",{class:!0});var Fp=_(Ye);d(Pr.$$.fragment,Fp),S_=o(Fp),Gl=a(Fp,"P",{"data-svelte-h":!0}),y(Gl)!=="svelte-rfvu1k"&&(Gl.textContent=tv),Z_=o(Fp),El=a(Fp,"DIV",{class:!0});var D$=_(El);d(Gr.$$.fragment,D$),D$.forEach(n),Fp.forEach(n),Bg=o(e),zt=a(e,"DIV",{class:!0});var cu=_(zt);d(Er.$$.fragment,cu),D_=o(cu),Xl=a(cu,"DIV",{class:!0});var P$=_(Xl);d(Xr.$$.fragment,P$),P$.forEach(n),cu.forEach(n),qg=o(e),Ke=a(e,"DIV",{class:!0});var zp=_(Ke);d(Nr.$$.fragment,zp),P_=o(zp),Nl=a(zp,"P",{"data-svelte-h":!0}),y(Nl)!=="svelte-4hfu96"&&(Nl.innerHTML=nv),G_=o(zp),Rl=a(zp,"DIV",{class:!0});var G$=_(Rl);d(Rr.$$.fragment,G$),G$.forEach(n),zp.forEach(n),Wg=o(e),et=a(e,"DIV",{class:!0});var Up=_(et);d(Hr.$$.fragment,Up),E_=o(Up),Hl=a(Up,"P",{"data-svelte-h":!0}),y(Hl)!=="svelte-q5v59n"&&(Hl.innerHTML=sv),X_=o(Up),Ol=a(Up,"DIV",{class:!0});var E$=_(Ol);d(Or.$$.fragment,E$),E$.forEach(n),Up.forEach(n),Vg=o(e),d(Qr.$$.fragment,e),Sg=o(e),Ar=a(e,"P",{"data-svelte-h":!0}),y(Ar)!=="svelte-1vv5qy5"&&(Ar.innerHTML=ov),Zg=o(e),L=a(e,"DIV",{class:!0});var z=_(L);d(Yr.$$.fragment,z),N_=o(z),Ql=a(z,"P",{"data-svelte-h":!0}),y(Ql)!=="svelte-1kh5y5v"&&(Ql.textContent=rv),R_=o(z),Al=a(z,"P",{"data-svelte-h":!0}),y(Al)!=="svelte-1ygkifj"&&(Al.textContent=av),H_=o(z),d(an.$$.fragment,z),O_=o(z),Yl=a(z,"P",{"data-svelte-h":!0}),y(Yl)!=="svelte-7kbd1a"&&(Yl.textContent=iv),Q_=o(z),cn=a(z,"DIV",{class:!0});var lu=_(cn);d(Kr.$$.fragment,lu),A_=o(lu),Kl=a(lu,"P",{"data-svelte-h":!0}),y(Kl)!=="svelte-691079"&&(Kl.textContent=cv),lu.forEach(n),Y_=o(z),ln=a(z,"DIV",{class:!0});var du=_(ln);d(ea.$$.fragment,du),K_=o(du),ed=a(du,"P",{"data-svelte-h":!0}),y(ed)!=="svelte-dtkk01"&&(ed.textContent=lv),du.forEach(n),eb=o(z),dn=a(z,"DIV",{class:!0});var pu=_(dn);d(ta.$$.fragment,pu),tb=o(pu),td=a(pu,"P",{"data-svelte-h":!0}),y(td)!=="svelte-11pa7k0"&&(td.textContent=dv),pu.forEach(n),nb=o(z),pn=a(z,"DIV",{class:!0});var mu=_(pn);d(na.$$.fragment,mu),sb=o(mu),nd=a(mu,"P",{"data-svelte-h":!0}),y(nd)!=="svelte-57vcuk"&&(nd.innerHTML=pv),mu.forEach(n),ob=o(z),mn=a(z,"DIV",{class:!0});var gu=_(mn);d(sa.$$.fragment,gu),rb=o(gu),sd=a(gu,"P",{"data-svelte-h":!0}),y(sd)!=="svelte-e342dt"&&(sd.textContent=mv),gu.forEach(n),ab=o(z),gn=a(z,"DIV",{class:!0});var uu=_(gn);d(oa.$$.fragment,uu),ib=o(uu),od=a(uu,"P",{"data-svelte-h":!0}),y(od)!=="svelte-vbd5xj"&&(od.textContent=gv),uu.forEach(n),cb=o(z),st=a(z,"DIV",{class:!0});var Jp=_(st);d(ra.$$.fragment,Jp),lb=o(Jp),rd=a(Jp,"P",{"data-svelte-h":!0}),y(rd)!=="svelte-1c2dshy"&&(rd.innerHTML=uv),db=o(Jp),ad=a(Jp,"P",{"data-svelte-h":!0}),y(ad)!=="svelte-1qvu1un"&&(ad.textContent=hv),Jp.forEach(n),z.forEach(n),Dg=o(e),Ut=a(e,"DIV",{class:!0});var hu=_(Ut);d(aa.$$.fragment,hu),pb=o(hu),id=a(hu,"P",{"data-svelte-h":!0}),y(id)!=="svelte-koz29d"&&(id.innerHTML=fv),hu.forEach(n),Pg=o(e),Jt=a(e,"DIV",{class:!0});var fu=_(Jt);d(ia.$$.fragment,fu),mb=o(fu),cd=a(fu,"P",{"data-svelte-h":!0}),y(cd)!=="svelte-17xixic"&&(cd.innerHTML=_v),fu.forEach(n),Gg=o(e),K=a(e,"DIV",{class:!0});var Un=_(K);d(ca.$$.fragment,Un),gb=o(Un),ld=a(Un,"P",{"data-svelte-h":!0}),y(ld)!=="svelte-rxlesw"&&(ld.textContent=bv),ub=o(Un),B=a(Un,"DIV",{class:!0});var ne=_(B);d(la.$$.fragment,ne),hb=o(ne),dd=a(ne,"P",{"data-svelte-h":!0}),y(dd)!=="svelte-15hhlou"&&(dd.textContent=Tv),fb=o(ne),pd=a(ne,"P",{"data-svelte-h":!0}),y(pd)!=="svelte-x0d0uq"&&(pd.innerHTML=yv),_b=o(ne),md=a(ne,"P",{"data-svelte-h":!0}),y(md)!=="svelte-1w36vm3"&&(md.innerHTML=vv),bb=o(ne),gd=a(ne,"P",{"data-svelte-h":!0}),y(gd)!=="svelte-1niq0qw"&&(gd.innerHTML=$v),Tb=o(ne),ud=a(ne,"P",{"data-svelte-h":!0}),y(ud)!=="svelte-af4g6f"&&(ud.textContent=wv),ne.forEach(n),yb=o(Un),un=a(Un,"DIV",{class:!0});var _u=_(un);d(da.$$.fragment,_u),vb=o(_u),hd=a(_u,"P",{"data-svelte-h":!0}),y(hd)!=="svelte-eab6jp"&&(hd.textContent=xv),_u.forEach(n),Un.forEach(n),Eg=o(e),d(pa.$$.fragment,e),Xg=o(e),ee=a(e,"DIV",{class:!0});var Jn=_(ee);d(ma.$$.fragment,Jn),$b=o(Jn),fd=a(Jn,"P",{"data-svelte-h":!0}),y(fd)!=="svelte-168d6b"&&(fd.innerHTML=kv),wb=o(Jn),_d=a(Jn,"DIV",{class:!0});var X$=_(_d);d(ga.$$.fragment,X$),X$.forEach(n),xb=o(Jn),bd=a(Jn,"DIV",{class:!0});var N$=_(bd);d(ua.$$.fragment,N$),N$.forEach(n),Jn.forEach(n),Ng=o(e),I=a(e,"DIV",{class:!0});var se=_(I);d(ha.$$.fragment,se),kb=o(se),Td=a(se,"P",{"data-svelte-h":!0}),y(Td)!=="svelte-wkez1k"&&(Td.innerHTML=Mv),Mb=o(se),yd=a(se,"P",{"data-svelte-h":!0}),y(yd)!=="svelte-19qrwo1"&&(yd.innerHTML=jv),jb=o(se),vd=a(se,"P",{"data-svelte-h":!0}),y(vd)!=="svelte-l79sbt"&&(vd.innerHTML=Lv),Lb=o(se),$d=a(se,"DIV",{class:!0});var R$=_($d);d(fa.$$.fragment,R$),R$.forEach(n),Fb=o(se),wd=a(se,"DIV",{class:!0});var H$=_(wd);d(_a.$$.fragment,H$),H$.forEach(n),se.forEach(n),Rg=o(e),te=a(e,"DIV",{class:!0});var In=_(te);d(ba.$$.fragment,In),zb=o(In),xd=a(In,"P",{"data-svelte-h":!0}),y(xd)!=="svelte-ppih7l"&&(xd.innerHTML=Fv),Ub=o(In),kd=a(In,"DIV",{class:!0});var O$=_(kd);d(Ta.$$.fragment,O$),O$.forEach(n),Jb=o(In),Md=a(In,"DIV",{class:!0});var Q$=_(Md);d(ya.$$.fragment,Q$),Q$.forEach(n),In.forEach(n),Hg=o(e),d(va.$$.fragment,e),Og=o(e),tt=a(e,"DIV",{class:!0});var Ip=_(tt);d($a.$$.fragment,Ip),Ib=o(Ip),jd=a(Ip,"P",{"data-svelte-h":!0}),y(jd)!=="svelte-1aiwpx2"&&(jd.textContent=zv),Cb=o(Ip),Ld=a(Ip,"P",{"data-svelte-h":!0}),y(Ld)!=="svelte-ts4ue3"&&(Ld.innerHTML=Uv),Ip.forEach(n),Qg=o(e),nt=a(e,"DIV",{class:!0});var Cp=_(nt);d(wa.$$.fragment,Cp),Bb=o(Cp),Fd=a(Cp,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-1aiwpx2"&&(Fd.textContent=Jv),qb=o(Cp),zd=a(Cp,"P",{"data-svelte-h":!0}),y(zd)!=="svelte-ts4ue3"&&(zd.innerHTML=Iv),Cp.forEach(n),Ag=o(e),d(xa.$$.fragment,e),Yg=o(e),J=a(e,"DIV",{class:!0});var G=_(J);d(ka.$$.fragment,G),Wb=o(G),Ud=a(G,"P",{"data-svelte-h":!0}),y(Ud)!=="svelte-5jvlz5"&&(Ud.textContent=Cv),Vb=o(G),d(hn.$$.fragment,G),Sb=o(G),d(fn.$$.fragment,G),Zb=o(G),_n=a(G,"DIV",{class:!0});var bu=_(_n);d(Ma.$$.fragment,bu),Db=o(bu),Jd=a(bu,"P",{"data-svelte-h":!0}),y(Jd)!=="svelte-10d94rs"&&(Jd.textContent=Bv),bu.forEach(n),Pb=o(G),bn=a(G,"DIV",{class:!0});var Tu=_(bn);d(ja.$$.fragment,Tu),Gb=o(Tu),Id=a(Tu,"P",{"data-svelte-h":!0}),y(Id)!=="svelte-tm945r"&&(Id.textContent=qv),Tu.forEach(n),Eb=o(G),Tn=a(G,"DIV",{class:!0});var yu=_(Tn);d(La.$$.fragment,yu),Xb=o(yu),Cd=a(yu,"P",{"data-svelte-h":!0}),y(Cd)!=="svelte-1i1356p"&&(Cd.textContent=Wv),yu.forEach(n),G.forEach(n),Kg=o(e),D=a(e,"DIV",{class:!0});var lt=_(D);d(Fa.$$.fragment,lt),Nb=o(lt),Bd=a(lt,"P",{"data-svelte-h":!0}),y(Bd)!=="svelte-190fodr"&&(Bd.textContent=Vv),Rb=o(lt),d(yn.$$.fragment,lt),Hb=o(lt),d(vn.$$.fragment,lt),Ob=o(lt),$n=a(lt,"DIV",{class:!0});var vu=_($n);d(za.$$.fragment,vu),Qb=o(vu),qd=a(vu,"P",{"data-svelte-h":!0}),y(qd)!=="svelte-16i5iz"&&(qd.textContent=Sv),vu.forEach(n),lt.forEach(n),eu=o(e),Bp=a(e,"P",{}),_(Bp).forEach(n),this.h()},h(){b(f,"name","hf:doc:metadata"),b(f,"content",Mw),b(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ki,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(zi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ji,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ci,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(qi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Vi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Zi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Pi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ei,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(nc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ac,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(cc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(dc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(uc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(fc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(bc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(yc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(xc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Lc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(zc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Jc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Cc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Wc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Zc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Nc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Qc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(el,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(nl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ol,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(al,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(cl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ml,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ul,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(fl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(bl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ml,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(zl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Jl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Cl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ql,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Vl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Zl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Pl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(El,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Xl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Rl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ol,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(kd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Md,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,f),c(e,x,i),c(e,$,i),c(e,v,i),p(w,e,i),c(e,h,i),c(e,k,i),c(e,qp,i),c(e,Bn,i),c(e,Wp,i),p(qn,e,i),c(e,Vp,i),c(e,Wn,i),c(e,Sp,i),c(e,Vn,i),c(e,Zp,i),p(Sn,e,i),c(e,Dp,i),c(e,Zn,i),c(e,Pp,i),c(e,Dn,i),c(e,Gp,i),c(e,Pn,i),c(e,Ep,i),c(e,Gn,i),c(e,Xp,i),c(e,En,i),c(e,Np,i),p(Xn,e,i),c(e,Rp,i),c(e,Nn,i),c(e,Hp,i),c(e,Rn,i),c(e,Op,i),c(e,Hn,i),c(e,Qp,i),p(On,e,i),c(e,Ap,i),c(e,dt,i),p(Qn,dt,null),t(dt,$u),t(dt,Ya),c(e,Yp,i),c(e,pt,i),p(An,pt,null),t(pt,wu),t(pt,Ka),c(e,Kp,i),c(e,mt,i),p(Yn,mt,null),t(mt,xu),t(mt,ei),c(e,em,i),c(e,gt,i),p(Kn,gt,null),t(gt,ku),t(gt,ti),c(e,tm,i),c(e,ut,i),p(es,ut,null),t(ut,Mu),t(ut,ni),c(e,nm,i),c(e,ht,i),p(ts,ht,null),t(ht,ju),t(ht,si),c(e,sm,i),c(e,ft,i),p(ns,ft,null),t(ft,Lu),t(ft,oi),c(e,om,i),c(e,_t,i),p(ss,_t,null),t(_t,Fu),t(_t,ri),c(e,rm,i),c(e,bt,i),p(os,bt,null),t(bt,zu),t(bt,ai),c(e,am,i),c(e,Tt,i),p(rs,Tt,null),t(Tt,Uu),t(Tt,ii),c(e,im,i),p(as,e,i),c(e,cm,i),c(e,yt,i),p(is,yt,null),t(yt,Ju),t(yt,ci),c(e,lm,i),c(e,vt,i),p(cs,vt,null),t(vt,Iu),t(vt,li),c(e,dm,i),c(e,$t,i),p(ls,$t,null),t($t,Cu),t($t,di),c(e,pm,i),c(e,wt,i),p(ds,wt,null),t(wt,Bu),t(wt,pi),c(e,mm,i),c(e,xt,i),p(ps,xt,null),t(xt,qu),t(xt,mi),c(e,gm,i),c(e,kt,i),p(ms,kt,null),t(kt,Wu),t(kt,gi),c(e,um,i),c(e,Mt,i),p(gs,Mt,null),t(Mt,Vu),t(Mt,ui),c(e,hm,i),c(e,jt,i),p(us,jt,null),t(jt,Su),t(jt,hi),c(e,fm,i),c(e,Lt,i),p(hs,Lt,null),t(Lt,Zu),t(Lt,fi),c(e,_m,i),c(e,Ft,i),p(fs,Ft,null),t(Ft,Du),t(Ft,_i),c(e,bm,i),p(_s,e,i),c(e,Tm,i),c(e,oe,i),p(bs,oe,null),t(oe,Pu),t(oe,bi),t(oe,Gu),t(oe,Bt),p(Ts,Bt,null),t(Bt,Eu),t(Bt,Ti),c(e,ym,i),c(e,re,i),p(ys,re,null),t(re,Xu),t(re,yi),t(re,Nu),t(re,qt),p(vs,qt,null),t(qt,Ru),t(qt,vi),c(e,vm,i),c(e,ae,i),p($s,ae,null),t(ae,Hu),t(ae,$i),t(ae,Ou),t(ae,Wt),p(ws,Wt,null),t(Wt,Qu),t(Wt,wi),c(e,$m,i),p(xs,e,i),c(e,wm,i),c(e,ks,i),c(e,xm,i),p(Ms,e,i),c(e,km,i),c(e,ie,i),p(js,ie,null),t(ie,Au),t(ie,xi),t(ie,Yu),t(ie,ki),p(Ls,ki,null),c(e,Mm,i),c(e,X,i),p(Fs,X,null),t(X,Ku),t(X,Mi),t(X,eh),t(X,ji),t(X,th),t(X,Li),p(zs,Li,null),c(e,jm,i),c(e,ce,i),p(Us,ce,null),t(ce,nh),t(ce,Fi),t(ce,sh),t(ce,zi),p(Js,zi,null),c(e,Lm,i),c(e,le,i),p(Is,le,null),t(le,oh),t(le,Ui),t(le,rh),t(le,Ji),p(Cs,Ji,null),c(e,Fm,i),c(e,N,i),p(Bs,N,null),t(N,ah),t(N,Ii),t(N,ih),p(Vt,N,null),t(N,ch),t(N,Ci),p(qs,Ci,null),c(e,zm,i),c(e,R,i),p(Ws,R,null),t(R,lh),t(R,Bi),t(R,dh),p(St,R,null),t(R,ph),t(R,qi),p(Vs,qi,null),c(e,Um,i),c(e,H,i),p(Ss,H,null),t(H,mh),t(H,Wi),t(H,gh),p(Zt,H,null),t(H,uh),t(H,Vi),p(Zs,Vi,null),c(e,Jm,i),c(e,de,i),p(Ds,de,null),t(de,hh),t(de,Si),t(de,fh),t(de,Zi),p(Ps,Zi,null),c(e,Im,i),c(e,pe,i),p(Gs,pe,null),t(pe,_h),t(pe,Di),t(pe,bh),t(pe,Pi),p(Es,Pi,null),c(e,Cm,i),c(e,me,i),p(Xs,me,null),t(me,Th),t(me,Gi),t(me,yh),t(me,Ei),p(Ns,Ei,null),c(e,Bm,i),c(e,j,i),p(Rs,j,null),t(j,vh),t(j,Xi),t(j,$h),t(j,Ni),t(j,wh),p(Dt,j,null),t(j,xh),p(Pt,j,null),t(j,kh),t(j,Ri),t(j,Mh),t(j,Hi),t(j,jh),t(j,Oi),t(j,Lh),t(j,Qi),t(j,Fh),t(j,Ai),t(j,zh),p(Gt,j,null),t(j,Uh),t(j,Yi),p(Hs,Yi,null),c(e,qm,i),c(e,ge,i),p(Os,ge,null),t(ge,Jh),t(ge,Ki),t(ge,Ih),t(ge,ec),p(Qs,ec,null),c(e,Wm,i),c(e,ue,i),p(As,ue,null),t(ue,Ch),t(ue,tc),t(ue,Bh),t(ue,nc),p(Ys,nc,null),c(e,Vm,i),c(e,he,i),p(Ks,he,null),t(he,qh),t(he,sc),t(he,Wh),t(he,oc),p(eo,oc,null),c(e,Sm,i),c(e,fe,i),p(to,fe,null),t(fe,Vh),t(fe,rc),t(fe,Sh),t(fe,ac),p(no,ac,null),c(e,Zm,i),c(e,_e,i),p(so,_e,null),t(_e,Zh),t(_e,ic),t(_e,Dh),t(_e,cc),p(oo,cc,null),c(e,Dm,i),c(e,be,i),p(ro,be,null),t(be,Ph),t(be,lc),t(be,Gh),t(be,dc),p(ao,dc,null),c(e,Pm,i),c(e,O,i),p(io,O,null),t(O,Eh),t(O,pc),t(O,Xh),p(Et,O,null),t(O,Nh),t(O,mc),p(co,mc,null),c(e,Gm,i),c(e,q,i),p(lo,q,null),t(q,Rh),t(q,gc),t(q,Hh),p(Xt,q,null),t(q,Oh),p(Nt,q,null),t(q,Qh),t(q,uc),p(po,uc,null),c(e,Em,i),c(e,W,i),p(mo,W,null),t(W,Ah),t(W,hc),t(W,Yh),p(Rt,W,null),t(W,Kh),p(Ht,W,null),t(W,ef),t(W,fc),p(go,fc,null),c(e,Xm,i),c(e,Te,i),p(uo,Te,null),t(Te,tf),t(Te,_c),t(Te,nf),t(Te,bc),p(ho,bc,null),c(e,Nm,i),c(e,Q,i),p(fo,Q,null),t(Q,sf),t(Q,Tc),t(Q,of),p(Ot,Q,null),t(Q,rf),t(Q,yc),p(_o,yc,null),c(e,Rm,i),c(e,V,i),p(bo,V,null),t(V,af),t(V,vc),t(V,cf),p(Qt,V,null),t(V,lf),p(At,V,null),t(V,df),t(V,$c),p(To,$c,null),c(e,Hm,i),c(e,ye,i),p(yo,ye,null),t(ye,pf),t(ye,wc),t(ye,mf),t(ye,xc),p(vo,xc,null),c(e,Om,i),c(e,ve,i),p($o,ve,null),t(ve,gf),t(ve,kc),t(ve,uf),t(ve,Mc),p(wo,Mc,null),c(e,Qm,i),c(e,S,i),p(xo,S,null),t(S,hf),t(S,jc),t(S,ff),p(Yt,S,null),t(S,_f),p(Kt,S,null),t(S,bf),t(S,Lc),p(ko,Lc,null),c(e,Am,i),c(e,$e,i),p(Mo,$e,null),t($e,Tf),t($e,Fc),t($e,yf),t($e,zc),p(jo,zc,null),c(e,Ym,i),c(e,A,i),p(Lo,A,null),t(A,vf),t(A,Uc),t(A,$f),p(en,A,null),t(A,wf),t(A,Jc),p(Fo,Jc,null),c(e,Km,i),c(e,we,i),p(zo,we,null),t(we,xf),t(we,Ic),t(we,kf),t(we,Cc),p(Uo,Cc,null),c(e,eg,i),c(e,Z,i),p(Jo,Z,null),t(Z,Mf),t(Z,Bc),t(Z,jf),t(Z,qc),t(Z,Lf),p(tn,Z,null),t(Z,Ff),t(Z,Wc),p(Io,Wc,null),c(e,tg,i),c(e,Y,i),p(Co,Y,null),t(Y,zf),t(Y,Vc),t(Y,Uf),t(Y,Sc),t(Y,Jf),t(Y,Zc),p(Bo,Zc,null),c(e,ng,i),p(qo,e,i),c(e,sg,i),c(e,xe,i),p(Wo,xe,null),t(xe,If),t(xe,Dc),t(xe,Cf),t(xe,Pc),p(Vo,Pc,null),c(e,og,i),c(e,ke,i),p(So,ke,null),t(ke,Bf),t(ke,Gc),t(ke,qf),t(ke,Ec),p(Zo,Ec,null),c(e,rg,i),c(e,Me,i),p(Do,Me,null),t(Me,Wf),t(Me,Xc),t(Me,Vf),t(Me,Nc),p(Po,Nc,null),c(e,ag,i),c(e,je,i),p(Go,je,null),t(je,Sf),t(je,Rc),t(je,Zf),t(je,nn),p(Eo,nn,null),t(nn,Df),t(nn,Hc),c(e,ig,i),c(e,Le,i),p(Xo,Le,null),t(Le,Pf),t(Le,Oc),t(Le,Gf),t(Le,Qc),p(No,Qc,null),c(e,cg,i),c(e,Fe,i),p(Ro,Fe,null),t(Fe,Ef),t(Fe,Ac),t(Fe,Xf),t(Fe,sn),p(Ho,sn,null),t(sn,Nf),t(sn,Yc),c(e,lg,i),c(e,ze,i),p(Oo,ze,null),t(ze,Rf),t(ze,Kc),t(ze,Hf),t(ze,el),p(Qo,el,null),c(e,dg,i),c(e,Ue,i),p(Ao,Ue,null),t(Ue,Of),t(Ue,tl),t(Ue,Qf),t(Ue,nl),p(Yo,nl,null),c(e,pg,i),c(e,Je,i),p(Ko,Je,null),t(Je,Af),t(Je,sl),t(Je,Yf),t(Je,ol),p(er,ol,null),c(e,mg,i),c(e,Ie,i),p(tr,Ie,null),t(Ie,Kf),t(Ie,rl),t(Ie,e_),t(Ie,al),p(nr,al,null),c(e,gg,i),c(e,Ce,i),p(sr,Ce,null),t(Ce,t_),t(Ce,il),t(Ce,n_),t(Ce,cl),p(or,cl,null),c(e,ug,i),c(e,Be,i),p(rr,Be,null),t(Be,s_),t(Be,ll),t(Be,o_),t(Be,dl),p(ar,dl,null),c(e,hg,i),c(e,qe,i),p(ir,qe,null),t(qe,r_),t(qe,pl),t(qe,a_),t(qe,ml),p(cr,ml,null),c(e,fg,i),c(e,We,i),p(lr,We,null),t(We,i_),t(We,gl),t(We,c_),t(We,ul),p(dr,ul,null),c(e,_g,i),c(e,Ve,i),p(pr,Ve,null),t(Ve,l_),t(Ve,hl),t(Ve,d_),t(Ve,fl),p(mr,fl,null),c(e,bg,i),p(gr,e,i),c(e,Tg,i),c(e,Se,i),p(ur,Se,null),t(Se,p_),t(Se,_l),t(Se,m_),t(Se,bl),p(hr,bl,null),c(e,yg,i),c(e,Ze,i),p(fr,Ze,null),t(Ze,g_),t(Ze,Tl),t(Ze,u_),t(Ze,yl),p(_r,yl,null),c(e,vg,i),c(e,De,i),p(br,De,null),t(De,h_),t(De,vl),t(De,f_),t(De,$l),p(Tr,$l,null),c(e,$g,i),c(e,Pe,i),p(yr,Pe,null),t(Pe,__),t(Pe,wl),t(Pe,b_),t(Pe,on),p(vr,on,null),t(on,T_),t(on,xl),c(e,wg,i),c(e,Ge,i),p($r,Ge,null),t(Ge,y_),t(Ge,kl),t(Ge,v_),t(Ge,Ml),p(wr,Ml,null),c(e,xg,i),c(e,Ee,i),p(xr,Ee,null),t(Ee,$_),t(Ee,jl),t(Ee,w_),t(Ee,rn),p(kr,rn,null),t(rn,x_),t(rn,Ll),c(e,kg,i),c(e,Xe,i),p(Mr,Xe,null),t(Xe,k_),t(Xe,Fl),t(Xe,M_),t(Xe,zl),p(jr,zl,null),c(e,Mg,i),c(e,Ne,i),p(Lr,Ne,null),t(Ne,j_),t(Ne,Ul),t(Ne,L_),t(Ne,Jl),p(Fr,Jl,null),c(e,jg,i),c(e,Re,i),p(zr,Re,null),t(Re,F_),t(Re,Il),t(Re,z_),t(Re,Cl),p(Ur,Cl,null),c(e,Lg,i),c(e,He,i),p(Jr,He,null),t(He,U_),t(He,Bl),t(He,J_),t(He,ql),p(Ir,ql,null),c(e,Fg,i),c(e,Oe,i),p(Cr,Oe,null),t(Oe,I_),t(Oe,Wl),t(Oe,C_),t(Oe,Vl),p(Br,Vl,null),c(e,zg,i),c(e,Qe,i),p(qr,Qe,null),t(Qe,B_),t(Qe,Sl),t(Qe,q_),t(Qe,Zl),p(Wr,Zl,null),c(e,Ug,i),c(e,Ae,i),p(Vr,Ae,null),t(Ae,W_),t(Ae,Dl),t(Ae,V_),t(Ae,Pl),p(Sr,Pl,null),c(e,Jg,i),p(Zr,e,i),c(e,Ig,i),c(e,Dr,i),c(e,Cg,i),c(e,Ye,i),p(Pr,Ye,null),t(Ye,S_),t(Ye,Gl),t(Ye,Z_),t(Ye,El),p(Gr,El,null),c(e,Bg,i),c(e,zt,i),p(Er,zt,null),t(zt,D_),t(zt,Xl),p(Xr,Xl,null),c(e,qg,i),c(e,Ke,i),p(Nr,Ke,null),t(Ke,P_),t(Ke,Nl),t(Ke,G_),t(Ke,Rl),p(Rr,Rl,null),c(e,Wg,i),c(e,et,i),p(Hr,et,null),t(et,E_),t(et,Hl),t(et,X_),t(et,Ol),p(Or,Ol,null),c(e,Vg,i),p(Qr,e,i),c(e,Sg,i),c(e,Ar,i),c(e,Zg,i),c(e,L,i),p(Yr,L,null),t(L,N_),t(L,Ql),t(L,R_),t(L,Al),t(L,H_),p(an,L,null),t(L,O_),t(L,Yl),t(L,Q_),t(L,cn),p(Kr,cn,null),t(cn,A_),t(cn,Kl),t(L,Y_),t(L,ln),p(ea,ln,null),t(ln,K_),t(ln,ed),t(L,eb),t(L,dn),p(ta,dn,null),t(dn,tb),t(dn,td),t(L,nb),t(L,pn),p(na,pn,null),t(pn,sb),t(pn,nd),t(L,ob),t(L,mn),p(sa,mn,null),t(mn,rb),t(mn,sd),t(L,ab),t(L,gn),p(oa,gn,null),t(gn,ib),t(gn,od),t(L,cb),t(L,st),p(ra,st,null),t(st,lb),t(st,rd),t(st,db),t(st,ad),c(e,Dg,i),c(e,Ut,i),p(aa,Ut,null),t(Ut,pb),t(Ut,id),c(e,Pg,i),c(e,Jt,i),p(ia,Jt,null),t(Jt,mb),t(Jt,cd),c(e,Gg,i),c(e,K,i),p(ca,K,null),t(K,gb),t(K,ld),t(K,ub),t(K,B),p(la,B,null),t(B,hb),t(B,dd),t(B,fb),t(B,pd),t(B,_b),t(B,md),t(B,bb),t(B,gd),t(B,Tb),t(B,ud),t(K,yb),t(K,un),p(da,un,null),t(un,vb),t(un,hd),c(e,Eg,i),p(pa,e,i),c(e,Xg,i),c(e,ee,i),p(ma,ee,null),t(ee,$b),t(ee,fd),t(ee,wb),t(ee,_d),p(ga,_d,null),t(ee,xb),t(ee,bd),p(ua,bd,null),c(e,Ng,i),c(e,I,i),p(ha,I,null),t(I,kb),t(I,Td),t(I,Mb),t(I,yd),t(I,jb),t(I,vd),t(I,Lb),t(I,$d),p(fa,$d,null),t(I,Fb),t(I,wd),p(_a,wd,null),c(e,Rg,i),c(e,te,i),p(ba,te,null),t(te,zb),t(te,xd),t(te,Ub),t(te,kd),p(Ta,kd,null),t(te,Jb),t(te,Md),p(ya,Md,null),c(e,Hg,i),p(va,e,i),c(e,Og,i),c(e,tt,i),p($a,tt,null),t(tt,Ib),t(tt,jd),t(tt,Cb),t(tt,Ld),c(e,Qg,i),c(e,nt,i),p(wa,nt,null),t(nt,Bb),t(nt,Fd),t(nt,qb),t(nt,zd),c(e,Ag,i),p(xa,e,i),c(e,Yg,i),c(e,J,i),p(ka,J,null),t(J,Wb),t(J,Ud),t(J,Vb),p(hn,J,null),t(J,Sb),p(fn,J,null),t(J,Zb),t(J,_n),p(Ma,_n,null),t(_n,Db),t(_n,Jd),t(J,Pb),t(J,bn),p(ja,bn,null),t(bn,Gb),t(bn,Id),t(J,Eb),t(J,Tn),p(La,Tn,null),t(Tn,Xb),t(Tn,Cd),c(e,Kg,i),c(e,D,i),p(Fa,D,null),t(D,Nb),t(D,Bd),t(D,Rb),p(yn,D,null),t(D,Hb),p(vn,D,null),t(D,Ob),t(D,$n),p(za,$n,null),t($n,Qb),t($n,qd),c(e,eu,i),c(e,Bp,i),tu=!0},p(e,[i]){const Ua={};i&2&&(Ua.$$scope={dirty:i,ctx:e}),Vt.$set(Ua);const Ja={};i&2&&(Ja.$$scope={dirty:i,ctx:e}),St.$set(Ja);const Ia={};i&2&&(Ia.$$scope={dirty:i,ctx:e}),Zt.$set(Ia);const Ca={};i&2&&(Ca.$$scope={dirty:i,ctx:e}),Dt.$set(Ca);const Ba={};i&2&&(Ba.$$scope={dirty:i,ctx:e}),Pt.$set(Ba);const qa={};i&2&&(qa.$$scope={dirty:i,ctx:e}),Gt.$set(qa);const Wa={};i&2&&(Wa.$$scope={dirty:i,ctx:e}),Et.$set(Wa);const Va={};i&2&&(Va.$$scope={dirty:i,ctx:e}),Xt.$set(Va);const Sa={};i&2&&(Sa.$$scope={dirty:i,ctx:e}),Nt.$set(Sa);const Za={};i&2&&(Za.$$scope={dirty:i,ctx:e}),Rt.$set(Za);const Da={};i&2&&(Da.$$scope={dirty:i,ctx:e}),Ht.$set(Da);const Pa={};i&2&&(Pa.$$scope={dirty:i,ctx:e}),Ot.$set(Pa);const Ga={};i&2&&(Ga.$$scope={dirty:i,ctx:e}),Qt.$set(Ga);const Ea={};i&2&&(Ea.$$scope={dirty:i,ctx:e}),At.$set(Ea);const Xa={};i&2&&(Xa.$$scope={dirty:i,ctx:e}),Yt.$set(Xa);const Na={};i&2&&(Na.$$scope={dirty:i,ctx:e}),Kt.$set(Na);const Ra={};i&2&&(Ra.$$scope={dirty:i,ctx:e}),en.$set(Ra);const Ha={};i&2&&(Ha.$$scope={dirty:i,ctx:e}),tn.$set(Ha);const Oa={};i&2&&(Oa.$$scope={dirty:i,ctx:e}),an.$set(Oa);const Qa={};i&2&&(Qa.$$scope={dirty:i,ctx:e}),hn.$set(Qa);const It={};i&2&&(It.$$scope={dirty:i,ctx:e}),fn.$set(It);const Aa={};i&2&&(Aa.$$scope={dirty:i,ctx:e}),yn.$set(Aa);const Ct={};i&2&&(Ct.$$scope={dirty:i,ctx:e}),vn.$set(Ct)},i(e){tu||(m(w.$$.fragment,e),m(qn.$$.fragment,e),m(Sn.$$.fragment,e),m(Xn.$$.fragment,e),m(On.$$.fragment,e),m(Qn.$$.fragment,e),m(An.$$.fragment,e),m(Yn.$$.fragment,e),m(Kn.$$.fragment,e),m(es.$$.fragment,e),m(ts.$$.fragment,e),m(ns.$$.fragment,e),m(ss.$$.fragment,e),m(os.$$.fragment,e),m(rs.$$.fragment,e),m(as.$$.fragment,e),m(is.$$.fragment,e),m(cs.$$.fragment,e),m(ls.$$.fragment,e),m(ds.$$.fragment,e),m(ps.$$.fragment,e),m(ms.$$.fragment,e),m(gs.$$.fragment,e),m(us.$$.fragment,e),m(hs.$$.fragment,e),m(fs.$$.fragment,e),m(_s.$$.fragment,e),m(bs.$$.fragment,e),m(Ts.$$.fragment,e),m(ys.$$.fragment,e),m(vs.$$.fragment,e),m($s.$$.fragment,e),m(ws.$$.fragment,e),m(xs.$$.fragment,e),m(Ms.$$.fragment,e),m(js.$$.fragment,e),m(Ls.$$.fragment,e),m(Fs.$$.fragment,e),m(zs.$$.fragment,e),m(Us.$$.fragment,e),m(Js.$$.fragment,e),m(Is.$$.fragment,e),m(Cs.$$.fragment,e),m(Bs.$$.fragment,e),m(Vt.$$.fragment,e),m(qs.$$.fragment,e),m(Ws.$$.fragment,e),m(St.$$.fragment,e),m(Vs.$$.fragment,e),m(Ss.$$.fragment,e),m(Zt.$$.fragment,e),m(Zs.$$.fragment,e),m(Ds.$$.fragment,e),m(Ps.$$.fragment,e),m(Gs.$$.fragment,e),m(Es.$$.fragment,e),m(Xs.$$.fragment,e),m(Ns.$$.fragment,e),m(Rs.$$.fragment,e),m(Dt.$$.fragment,e),m(Pt.$$.fragment,e),m(Gt.$$.fragment,e),m(Hs.$$.fragment,e),m(Os.$$.fragment,e),m(Qs.$$.fragment,e),m(As.$$.fragment,e),m(Ys.$$.fragment,e),m(Ks.$$.fragment,e),m(eo.$$.fragment,e),m(to.$$.fragment,e),m(no.$$.fragment,e),m(so.$$.fragment,e),m(oo.$$.fragment,e),m(ro.$$.fragment,e),m(ao.$$.fragment,e),m(io.$$.fragment,e),m(Et.$$.fragment,e),m(co.$$.fragment,e),m(lo.$$.fragment,e),m(Xt.$$.fragment,e),m(Nt.$$.fragment,e),m(po.$$.fragment,e),m(mo.$$.fragment,e),m(Rt.$$.fragment,e),m(Ht.$$.fragment,e),m(go.$$.fragment,e),m(uo.$$.fragment,e),m(ho.$$.fragment,e),m(fo.$$.fragment,e),m(Ot.$$.fragment,e),m(_o.$$.fragment,e),m(bo.$$.fragment,e),m(Qt.$$.fragment,e),m(At.$$.fragment,e),m(To.$$.fragment,e),m(yo.$$.fragment,e),m(vo.$$.fragment,e),m($o.$$.fragment,e),m(wo.$$.fragment,e),m(xo.$$.fragment,e),m(Yt.$$.fragment,e),m(Kt.$$.fragment,e),m(ko.$$.fragment,e),m(Mo.$$.fragment,e),m(jo.$$.fragment,e),m(Lo.$$.fragment,e),m(en.$$.fragment,e),m(Fo.$$.fragment,e),m(zo.$$.fragment,e),m(Uo.$$.fragment,e),m(Jo.$$.fragment,e),m(tn.$$.fragment,e),m(Io.$$.fragment,e),m(Co.$$.fragment,e),m(Bo.$$.fragment,e),m(qo.$$.fragment,e),m(Wo.$$.fragment,e),m(Vo.$$.fragment,e),m(So.$$.fragment,e),m(Zo.$$.fragment,e),m(Do.$$.fragment,e),m(Po.$$.fragment,e),m(Go.$$.fragment,e),m(Eo.$$.fragment,e),m(Xo.$$.fragment,e),m(No.$$.fragment,e),m(Ro.$$.fragment,e),m(Ho.$$.fragment,e),m(Oo.$$.fragment,e),m(Qo.$$.fragment,e),m(Ao.$$.fragment,e),m(Yo.$$.fragment,e),m(Ko.$$.fragment,e),m(er.$$.fragment,e),m(tr.$$.fragment,e),m(nr.$$.fragment,e),m(sr.$$.fragment,e),m(or.$$.fragment,e),m(rr.$$.fragment,e),m(ar.$$.fragment,e),m(ir.$$.fragment,e),m(cr.$$.fragment,e),m(lr.$$.fragment,e),m(dr.$$.fragment,e),m(pr.$$.fragment,e),m(mr.$$.fragment,e),m(gr.$$.fragment,e),m(ur.$$.fragment,e),m(hr.$$.fragment,e),m(fr.$$.fragment,e),m(_r.$$.fragment,e),m(br.$$.fragment,e),m(Tr.$$.fragment,e),m(yr.$$.fragment,e),m(vr.$$.fragment,e),m($r.$$.fragment,e),m(wr.$$.fragment,e),m(xr.$$.fragment,e),m(kr.$$.fragment,e),m(Mr.$$.fragment,e),m(jr.$$.fragment,e),m(Lr.$$.fragment,e),m(Fr.$$.fragment,e),m(zr.$$.fragment,e),m(Ur.$$.fragment,e),m(Jr.$$.fragment,e),m(Ir.$$.fragment,e),m(Cr.$$.fragment,e),m(Br.$$.fragment,e),m(qr.$$.fragment,e),m(Wr.$$.fragment,e),m(Vr.$$.fragment,e),m(Sr.$$.fragment,e),m(Zr.$$.fragment,e),m(Pr.$$.fragment,e),m(Gr.$$.fragment,e),m(Er.$$.fragment,e),m(Xr.$$.fragment,e),m(Nr.$$.fragment,e),m(Rr.$$.fragment,e),m(Hr.$$.fragment,e),m(Or.$$.fragment,e),m(Qr.$$.fragment,e),m(Yr.$$.fragment,e),m(an.$$.fragment,e),m(Kr.$$.fragment,e),m(ea.$$.fragment,e),m(ta.$$.fragment,e),m(na.$$.fragment,e),m(sa.$$.fragment,e),m(oa.$$.fragment,e),m(ra.$$.fragment,e),m(aa.$$.fragment,e),m(ia.$$.fragment,e),m(ca.$$.fragment,e),m(la.$$.fragment,e),m(da.$$.fragment,e),m(pa.$$.fragment,e),m(ma.$$.fragment,e),m(ga.$$.fragment,e),m(ua.$$.fragment,e),m(ha.$$.fragment,e),m(fa.$$.fragment,e),m(_a.$$.fragment,e),m(ba.$$.fragment,e),m(Ta.$$.fragment,e),m(ya.$$.fragment,e),m(va.$$.fragment,e),m($a.$$.fragment,e),m(wa.$$.fragment,e),m(xa.$$.fragment,e),m(ka.$$.fragment,e),m(hn.$$.fragment,e),m(fn.$$.fragment,e),m(Ma.$$.fragment,e),m(ja.$$.fragment,e),m(La.$$.fragment,e),m(Fa.$$.fragment,e),m(yn.$$.fragment,e),m(vn.$$.fragment,e),m(za.$$.fragment,e),tu=!0)},o(e){g(w.$$.fragment,e),g(qn.$$.fragment,e),g(Sn.$$.fragment,e),g(Xn.$$.fragment,e),g(On.$$.fragment,e),g(Qn.$$.fragment,e),g(An.$$.fragment,e),g(Yn.$$.fragment,e),g(Kn.$$.fragment,e),g(es.$$.fragment,e),g(ts.$$.fragment,e),g(ns.$$.fragment,e),g(ss.$$.fragment,e),g(os.$$.fragment,e),g(rs.$$.fragment,e),g(as.$$.fragment,e),g(is.$$.fragment,e),g(cs.$$.fragment,e),g(ls.$$.fragment,e),g(ds.$$.fragment,e),g(ps.$$.fragment,e),g(ms.$$.fragment,e),g(gs.$$.fragment,e),g(us.$$.fragment,e),g(hs.$$.fragment,e),g(fs.$$.fragment,e),g(_s.$$.fragment,e),g(bs.$$.fragment,e),g(Ts.$$.fragment,e),g(ys.$$.fragment,e),g(vs.$$.fragment,e),g($s.$$.fragment,e),g(ws.$$.fragment,e),g(xs.$$.fragment,e),g(Ms.$$.fragment,e),g(js.$$.fragment,e),g(Ls.$$.fragment,e),g(Fs.$$.fragment,e),g(zs.$$.fragment,e),g(Us.$$.fragment,e),g(Js.$$.fragment,e),g(Is.$$.fragment,e),g(Cs.$$.fragment,e),g(Bs.$$.fragment,e),g(Vt.$$.fragment,e),g(qs.$$.fragment,e),g(Ws.$$.fragment,e),g(St.$$.fragment,e),g(Vs.$$.fragment,e),g(Ss.$$.fragment,e),g(Zt.$$.fragment,e),g(Zs.$$.fragment,e),g(Ds.$$.fragment,e),g(Ps.$$.fragment,e),g(Gs.$$.fragment,e),g(Es.$$.fragment,e),g(Xs.$$.fragment,e),g(Ns.$$.fragment,e),g(Rs.$$.fragment,e),g(Dt.$$.fragment,e),g(Pt.$$.fragment,e),g(Gt.$$.fragment,e),g(Hs.$$.fragment,e),g(Os.$$.fragment,e),g(Qs.$$.fragment,e),g(As.$$.fragment,e),g(Ys.$$.fragment,e),g(Ks.$$.fragment,e),g(eo.$$.fragment,e),g(to.$$.fragment,e),g(no.$$.fragment,e),g(so.$$.fragment,e),g(oo.$$.fragment,e),g(ro.$$.fragment,e),g(ao.$$.fragment,e),g(io.$$.fragment,e),g(Et.$$.fragment,e),g(co.$$.fragment,e),g(lo.$$.fragment,e),g(Xt.$$.fragment,e),g(Nt.$$.fragment,e),g(po.$$.fragment,e),g(mo.$$.fragment,e),g(Rt.$$.fragment,e),g(Ht.$$.fragment,e),g(go.$$.fragment,e),g(uo.$$.fragment,e),g(ho.$$.fragment,e),g(fo.$$.fragment,e),g(Ot.$$.fragment,e),g(_o.$$.fragment,e),g(bo.$$.fragment,e),g(Qt.$$.fragment,e),g(At.$$.fragment,e),g(To.$$.fragment,e),g(yo.$$.fragment,e),g(vo.$$.fragment,e),g($o.$$.fragment,e),g(wo.$$.fragment,e),g(xo.$$.fragment,e),g(Yt.$$.fragment,e),g(Kt.$$.fragment,e),g(ko.$$.fragment,e),g(Mo.$$.fragment,e),g(jo.$$.fragment,e),g(Lo.$$.fragment,e),g(en.$$.fragment,e),g(Fo.$$.fragment,e),g(zo.$$.fragment,e),g(Uo.$$.fragment,e),g(Jo.$$.fragment,e),g(tn.$$.fragment,e),g(Io.$$.fragment,e),g(Co.$$.fragment,e),g(Bo.$$.fragment,e),g(qo.$$.fragment,e),g(Wo.$$.fragment,e),g(Vo.$$.fragment,e),g(So.$$.fragment,e),g(Zo.$$.fragment,e),g(Do.$$.fragment,e),g(Po.$$.fragment,e),g(Go.$$.fragment,e),g(Eo.$$.fragment,e),g(Xo.$$.fragment,e),g(No.$$.fragment,e),g(Ro.$$.fragment,e),g(Ho.$$.fragment,e),g(Oo.$$.fragment,e),g(Qo.$$.fragment,e),g(Ao.$$.fragment,e),g(Yo.$$.fragment,e),g(Ko.$$.fragment,e),g(er.$$.fragment,e),g(tr.$$.fragment,e),g(nr.$$.fragment,e),g(sr.$$.fragment,e),g(or.$$.fragment,e),g(rr.$$.fragment,e),g(ar.$$.fragment,e),g(ir.$$.fragment,e),g(cr.$$.fragment,e),g(lr.$$.fragment,e),g(dr.$$.fragment,e),g(pr.$$.fragment,e),g(mr.$$.fragment,e),g(gr.$$.fragment,e),g(ur.$$.fragment,e),g(hr.$$.fragment,e),g(fr.$$.fragment,e),g(_r.$$.fragment,e),g(br.$$.fragment,e),g(Tr.$$.fragment,e),g(yr.$$.fragment,e),g(vr.$$.fragment,e),g($r.$$.fragment,e),g(wr.$$.fragment,e),g(xr.$$.fragment,e),g(kr.$$.fragment,e),g(Mr.$$.fragment,e),g(jr.$$.fragment,e),g(Lr.$$.fragment,e),g(Fr.$$.fragment,e),g(zr.$$.fragment,e),g(Ur.$$.fragment,e),g(Jr.$$.fragment,e),g(Ir.$$.fragment,e),g(Cr.$$.fragment,e),g(Br.$$.fragment,e),g(qr.$$.fragment,e),g(Wr.$$.fragment,e),g(Vr.$$.fragment,e),g(Sr.$$.fragment,e),g(Zr.$$.fragment,e),g(Pr.$$.fragment,e),g(Gr.$$.fragment,e),g(Er.$$.fragment,e),g(Xr.$$.fragment,e),g(Nr.$$.fragment,e),g(Rr.$$.fragment,e),g(Hr.$$.fragment,e),g(Or.$$.fragment,e),g(Qr.$$.fragment,e),g(Yr.$$.fragment,e),g(an.$$.fragment,e),g(Kr.$$.fragment,e),g(ea.$$.fragment,e),g(ta.$$.fragment,e),g(na.$$.fragment,e),g(sa.$$.fragment,e),g(oa.$$.fragment,e),g(ra.$$.fragment,e),g(aa.$$.fragment,e),g(ia.$$.fragment,e),g(ca.$$.fragment,e),g(la.$$.fragment,e),g(da.$$.fragment,e),g(pa.$$.fragment,e),g(ma.$$.fragment,e),g(ga.$$.fragment,e),g(ua.$$.fragment,e),g(ha.$$.fragment,e),g(fa.$$.fragment,e),g(_a.$$.fragment,e),g(ba.$$.fragment,e),g(Ta.$$.fragment,e),g(ya.$$.fragment,e),g(va.$$.fragment,e),g($a.$$.fragment,e),g(wa.$$.fragment,e),g(xa.$$.fragment,e),g(ka.$$.fragment,e),g(hn.$$.fragment,e),g(fn.$$.fragment,e),g(Ma.$$.fragment,e),g(ja.$$.fragment,e),g(La.$$.fragment,e),g(Fa.$$.fragment,e),g(yn.$$.fragment,e),g(vn.$$.fragment,e),g(za.$$.fragment,e),tu=!1},d(e){e&&(n(x),n($),n(v),n(h),n(k),n(qp),n(Bn),n(Wp),n(Vp),n(Wn),n(Sp),n(Vn),n(Zp),n(Dp),n(Zn),n(Pp),n(Dn),n(Gp),n(Pn),n(Ep),n(Gn),n(Xp),n(En),n(Np),n(Rp),n(Nn),n(Hp),n(Rn),n(Op),n(Hn),n(Qp),n(Ap),n(dt),n(Yp),n(pt),n(Kp),n(mt),n(em),n(gt),n(tm),n(ut),n(nm),n(ht),n(sm),n(ft),n(om),n(_t),n(rm),n(bt),n(am),n(Tt),n(im),n(cm),n(yt),n(lm),n(vt),n(dm),n($t),n(pm),n(wt),n(mm),n(xt),n(gm),n(kt),n(um),n(Mt),n(hm),n(jt),n(fm),n(Lt),n(_m),n(Ft),n(bm),n(Tm),n(oe),n(ym),n(re),n(vm),n(ae),n($m),n(wm),n(ks),n(xm),n(km),n(ie),n(Mm),n(X),n(jm),n(ce),n(Lm),n(le),n(Fm),n(N),n(zm),n(R),n(Um),n(H),n(Jm),n(de),n(Im),n(pe),n(Cm),n(me),n(Bm),n(j),n(qm),n(ge),n(Wm),n(ue),n(Vm),n(he),n(Sm),n(fe),n(Zm),n(_e),n(Dm),n(be),n(Pm),n(O),n(Gm),n(q),n(Em),n(W),n(Xm),n(Te),n(Nm),n(Q),n(Rm),n(V),n(Hm),n(ye),n(Om),n(ve),n(Qm),n(S),n(Am),n($e),n(Ym),n(A),n(Km),n(we),n(eg),n(Z),n(tg),n(Y),n(ng),n(sg),n(xe),n(og),n(ke),n(rg),n(Me),n(ag),n(je),n(ig),n(Le),n(cg),n(Fe),n(lg),n(ze),n(dg),n(Ue),n(pg),n(Je),n(mg),n(Ie),n(gg),n(Ce),n(ug),n(Be),n(hg),n(qe),n(fg),n(We),n(_g),n(Ve),n(bg),n(Tg),n(Se),n(yg),n(Ze),n(vg),n(De),n($g),n(Pe),n(wg),n(Ge),n(xg),n(Ee),n(kg),n(Xe),n(Mg),n(Ne),n(jg),n(Re),n(Lg),n(He),n(Fg),n(Oe),n(zg),n(Qe),n(Ug),n(Ae),n(Jg),n(Ig),n(Dr),n(Cg),n(Ye),n(Bg),n(zt),n(qg),n(Ke),n(Wg),n(et),n(Vg),n(Sg),n(Ar),n(Zg),n(L),n(Dg),n(Ut),n(Pg),n(Jt),n(Gg),n(K),n(Eg),n(Xg),n(ee),n(Ng),n(I),n(Rg),n(te),n(Hg),n(Og),n(tt),n(Qg),n(nt),n(Ag),n(Yg),n(J),n(Kg),n(D),n(eu),n(Bp)),n(f),u(w,e),u(qn,e),u(Sn,e),u(Xn,e),u(On,e),u(Qn),u(An),u(Yn),u(Kn),u(es),u(ts),u(ns),u(ss),u(os),u(rs),u(as,e),u(is),u(cs),u(ls),u(ds),u(ps),u(ms),u(gs),u(us),u(hs),u(fs),u(_s,e),u(bs),u(Ts),u(ys),u(vs),u($s),u(ws),u(xs,e),u(Ms,e),u(js),u(Ls),u(Fs),u(zs),u(Us),u(Js),u(Is),u(Cs),u(Bs),u(Vt),u(qs),u(Ws),u(St),u(Vs),u(Ss),u(Zt),u(Zs),u(Ds),u(Ps),u(Gs),u(Es),u(Xs),u(Ns),u(Rs),u(Dt),u(Pt),u(Gt),u(Hs),u(Os),u(Qs),u(As),u(Ys),u(Ks),u(eo),u(to),u(no),u(so),u(oo),u(ro),u(ao),u(io),u(Et),u(co),u(lo),u(Xt),u(Nt),u(po),u(mo),u(Rt),u(Ht),u(go),u(uo),u(ho),u(fo),u(Ot),u(_o),u(bo),u(Qt),u(At),u(To),u(yo),u(vo),u($o),u(wo),u(xo),u(Yt),u(Kt),u(ko),u(Mo),u(jo),u(Lo),u(en),u(Fo),u(zo),u(Uo),u(Jo),u(tn),u(Io),u(Co),u(Bo),u(qo,e),u(Wo),u(Vo),u(So),u(Zo),u(Do),u(Po),u(Go),u(Eo),u(Xo),u(No),u(Ro),u(Ho),u(Oo),u(Qo),u(Ao),u(Yo),u(Ko),u(er),u(tr),u(nr),u(sr),u(or),u(rr),u(ar),u(ir),u(cr),u(lr),u(dr),u(pr),u(mr),u(gr,e),u(ur),u(hr),u(fr),u(_r),u(br),u(Tr),u(yr),u(vr),u($r),u(wr),u(xr),u(kr),u(Mr),u(jr),u(Lr),u(Fr),u(zr),u(Ur),u(Jr),u(Ir),u(Cr),u(Br),u(qr),u(Wr),u(Vr),u(Sr),u(Zr,e),u(Pr),u(Gr),u(Er),u(Xr),u(Nr),u(Rr),u(Hr),u(Or),u(Qr,e),u(Yr),u(an),u(Kr),u(ea),u(ta),u(na),u(sa),u(oa),u(ra),u(aa),u(ia),u(ca),u(la),u(da),u(pa,e),u(ma),u(ga),u(ua),u(ha),u(fa),u(_a),u(ba),u(Ta),u(ya),u(va,e),u($a),u(wa),u(xa,e),u(ka),u(hn),u(fn),u(Ma),u(ja),u(La),u(Fa),u(yn),u(vn),u(za)}}}const Mw='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Utilities","local":"transformers.top_k_top_p_filtering","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2}],"depth":1}';function jw(M){return Y$(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bw extends K${constructor(f){super(),ew(this,f,jw,kw,A$,{})}}export{Bw as component};
