import{s as Ta,o as ja,n as ka}from"../chunks/scheduler.6062bdaf.js";import{S as Ja,i as Ha,g as n,s,r as p,A as Za,h as o,f as t,c as i,j as c,u as f,x as r,k as d,y as h,a,v as u,d as g,t as m,w}from"../chunks/index.4bca734e.js";import{T as Ca}from"../chunks/Tip.b9ac1f03.js";import{I as Z}from"../chunks/IconCopyLink.68a13644.js";import{C as y}from"../chunks/CodeBlock.f213e6a5.js";function qa(ot){let v,R=`The returned filepath is a pointer to the HF local cache. Therefore, it is important to not modify the file to avoid
having a corrupted cache. If you are interested in getting to know more about how files are cached, please refer to our
<a href="./manage-cache">caching guide</a>.`;return{c(){v=n("p"),v.innerHTML=R},l(b){v=o(b,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1jtqj65"&&(v.innerHTML=R)},m(b,_){a(b,v,_)},p:ka,d(b){b&&t(v)}}}function Ya(ot){let v,R,b,_,De,W,ul,We,Ml="Download files from the Hub",st,B,xl=`The <code>huggingface_hub</code> library provides functions to download files from the repositories
stored on the Hub. You can use these functions independently or integrate them into your
own library, making it more convenient for your users to interact with the Hub. This
guide will show you how to:`,it,Q,Tl="<li>Download and cache a single file.</li> <li>Download and cache an entire repository.</li> <li>Download files to a local folder.</li>",rt,$,C,Ve,z,gl,Be,jl="Download a single file",dt,P,kl=`The <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> function is the main function for downloading files from the Hub.
It downloads the remote file, caches it on disk (in a version-aware way), and returns its local file path.`,ht,q,ct,M,Y,Ke,S,ml,Qe,Jl="From latest version",pt,A,Hl=`Select the file to download using the <code>repo_id</code>, <code>repo_type</code> and <code>filename</code> parameters. By default, the file will
be considered as being part of a <code>model</code> repo.`,ft,F,ut,x,U,Oe,E,wl,ze,Zl="From specific version",gt,D,Cl=`By default, the latest version from the <code>main</code> branch is downloaded. However, in some cases you want to download a file
at a particular version (e.g. from a specific branch, a PR, a tag or a commit hash).
To do so, use the <code>revision</code> parameter:`,mt,V,wt,K,ql="<strong>Note:</strong> When using the commit hash, it must be the full-length hash instead of a 7-character commit hash.",vt,T,L,et,O,vl,Pe,Yl="Construct a download URL",bt,ee,Ul=`In case you want to construct the URL used to download a file from a repo, you can use <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.hf_hub_url">hf_hub_url()</a> which returns a URL.
Note that it is used internally by <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a>.`,yt,j,I,tt,te,bl,Se,Ll="Download an entire repository",_t,le,Il=`<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads an entire repository at a given revision. It uses internally <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> which
means all downloaded files are also cached on your local disk. Downloads are made concurrently to speed-up the process.`,$t,ae,Gl="To download a whole repository, just pass the <code>repo_id</code> and <code>repo_type</code>:",Mt,ne,xt,oe,Nl=`<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> downloads the latest revision by default. If you want a specific repository revision, use the
<code>revision</code> parameter:`,Tt,se,jt,k,G,lt,ie,yl,Ae,Xl="Filter files to download",kt,re,Rl=`<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> provides an easy way to download a repository. However, you don’t always want to download the
entire content of a repository. For example, you might want to prevent downloading all <code>.bin</code> files if you know you’ll
only use the <code>.safetensors</code> weights. You can do that using <code>allow_patterns</code> and <code>ignore_patterns</code> parameters.`,Jt,de,Wl=`These parameters accept either a single pattern or a list of patterns. Patterns are Standard Wildcards (globbing
patterns) as documented <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">here</a>. The pattern matching is
based on <a href="https://docs.python.org/3/library/fnmatch.html" rel="nofollow"><code>fnmatch</code></a>.`,Ht,he,Bl="For example, you can use <code>allow_patterns</code> to only download JSON configuration files:",Zt,ce,Ct,pe,Ql=`On the other hand, <code>ignore_patterns</code> can exclude certain files from being downloaded. The
following example ignores the <code>.msgpack</code> and <code>.h5</code> file extensions:`,qt,fe,Yt,ue,zl=`Finally, you can combine both to precisely filter your download. Here is an example to download all json and markdown
files except <code>vocab.json</code>.`,Ut,ge,Lt,J,N,at,me,_l,Fe,Pl="Download file(s) to local folder",It,we,Sl=`The recommended (and default) way to download files from the Hub is to use the <a href="./manage-cache">cache-system</a>.
You can define your cache location by setting <code>cache_dir</code> parameter (both in <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a>).`,Gt,ve,Al=`However, in some cases you want to download files and move them to a specific folder. This is useful to get a workflow
closer to what <code>git</code> commands offer. You can do that using the <code>local_dir</code> and <code>local_dir_use_symlinks</code> parameters:`,Nt,be,Fl=`<li><code>local_dir</code> must be a path to a folder on your system. The downloaded files will keep the same file structure as in the
repo. For example if <code>filename=&quot;data/train.csv&quot;</code> and <code>local_dir=&quot;path/to/folder&quot;</code>, then the returned filepath will be
<code>&quot;path/to/folder/data/train.csv&quot;</code>.</li> <li><code>local_dir_use_symlinks</code> defines how the file must be saved in your local folder.<ul><li>The default behavior (<code>&quot;auto&quot;</code>) is to duplicate small files (&lt;5MB) and use symlinks for bigger files. Symlinks allow
to optimize both bandwidth and disk usage. However manually editing a symlinked file might corrupt the cache, hence
the duplication for small files. The 5MB threshold can be configured with the <code>HF_HUB_LOCAL_DIR_AUTO_SYMLINK_THRESHOLD</code>
environment variable.</li> <li>If <code>local_dir_use_symlinks=True</code> is set, all files are symlinked for an optimal disk space optimization. This is
for example useful when downloading a huge dataset with thousands of small files.</li> <li>Finally, if you don’t want symlinks at all you can disable them (<code>local_dir_use_symlinks=False</code>). The cache directory
will still be used to check wether the file is already cached or not. If already cached, the file is <strong>duplicated</strong>
from the cache (i.e. saves bandwidth but increases disk usage). If the file is not already cached, it will be
downloaded and moved directly to the local dir. This means that if you need to reuse it somewhere else later, it
will be <strong>re-downloaded</strong>.</li></ul></li>`,Xt,ye,El="Here is a table that summarizes the different options to help you choose the parameters that best suit your use case.",Rt,_e,Dl='<thead><tr><th>Parameters</th> <th align="center">File already cached</th> <th align="center">Returned path</th> <th align="center">Can read path?</th> <th align="center">Can save to path?</th> <th align="center">Optimized bandwidth</th> <th align="center">Optimized disk usage</th></tr></thead> <tbody><tr><td><code>local_dir=None</code></td> <td align="center"></td> <td align="center">symlink in cache</td> <td align="center">✅</td> <td align="center">❌<br/><em>(save would corrupt the cache)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=&quot;auto&quot;</code></td> <td align="center"></td> <td align="center">file or symlink in folder</td> <td align="center">✅</td> <td align="center">✅ <em>(for small files)</em> <br/> ⚠️ <em>(for big files do not resolve path before saving)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=True</code></td> <td align="center"></td> <td align="center">symlink in folder</td> <td align="center">✅</td> <td align="center">⚠️<br/><em>(do not resolve path before saving)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=False</code></td> <td align="center">No</td> <td align="center">file in folder</td> <td align="center">✅</td> <td align="center">✅</td> <td align="center">❌<br/><em>(if re-run, file is re-downloaded)</em></td> <td align="center">⚠️<br/>(multiple copies if ran in multiple folders)</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=False</code></td> <td align="center">Yes</td> <td align="center">file in folder</td> <td align="center">✅</td> <td align="center">✅</td> <td align="center">⚠️<br/><em>(file has to be cached first)</em></td> <td align="center">❌<br/><em>(file is duplicated)</em></td></tr></tbody>',Wt,$e,Vl=`<strong>Note:</strong> if you are on a Windows machine, you need to enable developer mode or run <code>huggingface_hub</code> as admin to enable
symlinks. Check out the <a href="../guides/manage-cache#limitations">cache limitations</a> section for more details.`,Bt,H,X,nt,Me,$l,Ee,Kl="Download from the CLI",Qt,xe,Ol=`You can use the <code>huggingface-cli download</code> command from the terminal to directly download files from the Hub.
Internally, it uses the same <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.hf_hub_download">hf_hub_download()</a> and <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/file_download#huggingface_hub.snapshot_download">snapshot_download()</a> helpers described above and prints the
returned path to the terminal:`,zt,Te,Pt,je,ea=`By default, the token saved locally (using <code>huggingface-cli login</code>) will be used. If you want to authenticate explicitly,
use the <code>--token</code> option:`,St,ke,At,Je,ta=`You can download multiple files at once which displays a progress bar and returns the snapshot path in which the files
are located:`,Ft,He,Et,Ze,la=`If you want to silence the progress bars and potential warnings, use the <code>--quiet</code> option. This can prove useful if you
want to pass the output to another command in a script.`,Dt,Ce,Vt,qe,aa=`By default, files are downloaded to the cache directory defined by <code>HF_HOME</code> environment variable (or <code>~/.cache/huggingface/hub</code> if not specified). You
can override this by using the <code>--cache-dir</code> option:`,Kt,Ye,Ot,Ue,na=`If you want to download files to a local folder, without the cache directory structure, you can use <code>--local-dir</code>.
Downloading to a local folder comes with its limitations which are listed in this <a href="https://huggingface.co/docs/huggingface_hub/guides/download#download-files-to-local-folder" rel="nofollow">table</a>.`,el,Le,tl,Ie,oa=`There are more arguments you can specify to download from different repo types or revisions and to include/exclude files to download using
glob patterns:`,ll,Ge,al,Ne,sa="For a full list of the arguments, you can run:",nl,Xe,ol;return W=new Z({}),z=new Z({}),q=new Ca({props:{$$slots:{default:[qa]},$$scope:{ctx:ot}}}),S=new Z({}),F=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIyZ29vZ2xlJTJGZmxldXJzJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJmbGV1cnMucHklMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade/config.json&#x27;</span>

<span class="hljs-comment"># Download from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, filename=<span class="hljs-string">&quot;fleurs.py&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34/fleurs.py&#x27;</span>`}}),E=new Z({}),V=new y({props:{code:"aGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnYxLjAlMjIpJTBBJTBBaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnRlc3QtYnJhbmNoJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYzJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-comment"># Download from the \`v1.0\` tag</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;v1.0&quot;</span>)

<span class="hljs-comment"># Download from the \`test-branch\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;test-branch&quot;</span>)

<span class="hljs-comment"># Download from Pull Request #3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/3&quot;</span>)

<span class="hljs-comment"># Download from a specific commit hash</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`}}),O=new Z({}),te=new Z({}),ne=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyKSUwQSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJnb29nbGUlMkZmbGV1cnMlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade&#x27;</span>

<span class="hljs-comment"># Or from a dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34&#x27;</span>`}}),se=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/1&quot;</span>)`}}),ie=new Z({}),ce=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwYWxsb3dfcGF0dGVybnMlM0QlMjIqLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, allow_patterns=<span class="hljs-string">&quot;*.json&quot;</span>)`}}),fe=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwaWdub3JlX3BhdHRlcm5zJTNEJTVCJTIyKi5tc2dwYWNrJTIyJTJDJTIwJTIyKi5oNSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, ignore_patterns=[<span class="hljs-string">&quot;*.msgpack&quot;</span>, <span class="hljs-string">&quot;*.h5&quot;</span>])`}}),ge=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmdwdDIlMjIlMkMlMjBhbGxvd19wYXR0ZXJucyUzRCU1QiUyMioubWQlMjIlMkMlMjAlMjIqLmpzb24lMjIlNUQlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjJ2b2NhYi5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;gpt2&quot;</span>, allow_patterns=[<span class="hljs-string">&quot;*.md&quot;</span>, <span class="hljs-string">&quot;*.json&quot;</span>], ignore_patterns=<span class="hljs-string">&quot;vocab.json&quot;</span>)`}}),me=new Z({}),Me=new Z({}),Te=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24=",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`}}),ke=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjAtLXRva2VuJTNEaGZfKioqKg==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json --token=hf_****
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`}}),He=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjBtb2RlbC5zYWZldGVuc29ycw==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json model.safetensors
Fetching 2 files: 100%|████████████████████████████████████████████| 2/2 [00:00&lt;00:00, 23831.27it/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`}}),Ce=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjBtb2RlbC5zYWZldGVuc29ycw==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json model.safetensors
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`}}),Ye=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjAtLWNhY2hlLWRpciUzRC4lMkZjYWNoZQ==",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json --cache-dir=./cache
./cache/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`}}),Le=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBncHQyJTIwY29uZmlnLmpzb24lMjAtLWxvY2FsLWRpciUzRC4lMkZtb2RlbHMlMkZncHQy",highlighted:`&gt;&gt;&gt; huggingface-cli download gpt2 config.json --local-dir=./models/gpt2
./models/gpt2/config.json`}}),Ge=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjBiaWdjb2RlJTJGdGhlLXN0YWNrJTIwLS1yZXBvLXR5cGUlM0RkYXRhc2V0JTIwLS1yZXZpc2lvbiUzRHYxLjIlMjAtLWluY2x1ZGUlM0QlMjJkYXRhJTJGcHl0aG9uJTJGKiUyMiUyMC0tZXhjbHU=",highlighted:`&gt;&gt;&gt; huggingface-cli download bigcode/the-stack --repo-type=dataset --revision=v1.2 --include=<span class="hljs-string">&quot;data/python/*&quot;</span> --exclu
de=<span class="hljs-string">&quot;*.json&quot;</span> --exclude=<span class="hljs-string">&quot;*.zip&quot;</span>
Fetching 206 files:   100%|████████████████████████████████████████████| 206/206 [02:31&lt;2:31, ?it/s]
/home/wauplin/.cache/huggingface/hub/datasets--bigcode--the-stack/snapshots/9ca8fa6acdbc8ce920a0cb58adcdafc495818ae7`}}),Xe=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZG93bmxvYWQlMjAtLWhlbHA=",highlighted:'huggingface-cli download --<span class="hljs-built_in">help</span>'}}),{c(){v=n("meta"),R=s(),b=n("h1"),_=n("a"),De=n("span"),p(W.$$.fragment),ul=s(),We=n("span"),We.textContent=Ml,st=s(),B=n("p"),B.innerHTML=xl,it=s(),Q=n("ul"),Q.innerHTML=Tl,rt=s(),$=n("h2"),C=n("a"),Ve=n("span"),p(z.$$.fragment),gl=s(),Be=n("span"),Be.textContent=jl,dt=s(),P=n("p"),P.innerHTML=kl,ht=s(),p(q.$$.fragment),ct=s(),M=n("h3"),Y=n("a"),Ke=n("span"),p(S.$$.fragment),ml=s(),Qe=n("span"),Qe.textContent=Jl,pt=s(),A=n("p"),A.innerHTML=Hl,ft=s(),p(F.$$.fragment),ut=s(),x=n("h3"),U=n("a"),Oe=n("span"),p(E.$$.fragment),wl=s(),ze=n("span"),ze.textContent=Zl,gt=s(),D=n("p"),D.innerHTML=Cl,mt=s(),p(V.$$.fragment),wt=s(),K=n("p"),K.innerHTML=ql,vt=s(),T=n("h3"),L=n("a"),et=n("span"),p(O.$$.fragment),vl=s(),Pe=n("span"),Pe.textContent=Yl,bt=s(),ee=n("p"),ee.innerHTML=Ul,yt=s(),j=n("h2"),I=n("a"),tt=n("span"),p(te.$$.fragment),bl=s(),Se=n("span"),Se.textContent=Ll,_t=s(),le=n("p"),le.innerHTML=Il,$t=s(),ae=n("p"),ae.innerHTML=Gl,Mt=s(),p(ne.$$.fragment),xt=s(),oe=n("p"),oe.innerHTML=Nl,Tt=s(),p(se.$$.fragment),jt=s(),k=n("h3"),G=n("a"),lt=n("span"),p(ie.$$.fragment),yl=s(),Ae=n("span"),Ae.textContent=Xl,kt=s(),re=n("p"),re.innerHTML=Rl,Jt=s(),de=n("p"),de.innerHTML=Wl,Ht=s(),he=n("p"),he.innerHTML=Bl,Zt=s(),p(ce.$$.fragment),Ct=s(),pe=n("p"),pe.innerHTML=Ql,qt=s(),p(fe.$$.fragment),Yt=s(),ue=n("p"),ue.innerHTML=zl,Ut=s(),p(ge.$$.fragment),Lt=s(),J=n("h2"),N=n("a"),at=n("span"),p(me.$$.fragment),_l=s(),Fe=n("span"),Fe.textContent=Pl,It=s(),we=n("p"),we.innerHTML=Sl,Gt=s(),ve=n("p"),ve.innerHTML=Al,Nt=s(),be=n("ul"),be.innerHTML=Fl,Xt=s(),ye=n("p"),ye.textContent=El,Rt=s(),_e=n("table"),_e.innerHTML=Dl,Wt=s(),$e=n("p"),$e.innerHTML=Vl,Bt=s(),H=n("h2"),X=n("a"),nt=n("span"),p(Me.$$.fragment),$l=s(),Ee=n("span"),Ee.textContent=Kl,Qt=s(),xe=n("p"),xe.innerHTML=Ol,zt=s(),p(Te.$$.fragment),Pt=s(),je=n("p"),je.innerHTML=ea,St=s(),p(ke.$$.fragment),At=s(),Je=n("p"),Je.textContent=ta,Ft=s(),p(He.$$.fragment),Et=s(),Ze=n("p"),Ze.innerHTML=la,Dt=s(),p(Ce.$$.fragment),Vt=s(),qe=n("p"),qe.innerHTML=aa,Kt=s(),p(Ye.$$.fragment),Ot=s(),Ue=n("p"),Ue.innerHTML=na,el=s(),p(Le.$$.fragment),tl=s(),Ie=n("p"),Ie.textContent=oa,ll=s(),p(Ge.$$.fragment),al=s(),Ne=n("p"),Ne.textContent=sa,nl=s(),p(Xe.$$.fragment),this.h()},l(e){const l=Za("svelte-1phssyn",document.head);v=o(l,"META",{name:!0,content:!0}),l.forEach(t),R=i(e),b=o(e,"H1",{class:!0});var Re=c(b);_=o(Re,"A",{id:!0,class:!0,href:!0});var ia=c(_);De=o(ia,"SPAN",{});var ra=c(De);f(W.$$.fragment,ra),ra.forEach(t),ia.forEach(t),ul=i(Re),We=o(Re,"SPAN",{"data-svelte-h":!0}),r(We)!=="svelte-cuew1u"&&(We.textContent=Ml),Re.forEach(t),st=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-10amgpw"&&(B.innerHTML=xl),it=i(e),Q=o(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-39f2bi"&&(Q.innerHTML=Tl),rt=i(e),$=o(e,"H2",{class:!0});var sl=c($);C=o(sl,"A",{id:!0,class:!0,href:!0});var da=c(C);Ve=o(da,"SPAN",{});var ha=c(Ve);f(z.$$.fragment,ha),ha.forEach(t),da.forEach(t),gl=i(sl),Be=o(sl,"SPAN",{"data-svelte-h":!0}),r(Be)!=="svelte-1lqhcbi"&&(Be.textContent=jl),sl.forEach(t),dt=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-nj0ogy"&&(P.innerHTML=kl),ht=i(e),f(q.$$.fragment,e),ct=i(e),M=o(e,"H3",{class:!0});var il=c(M);Y=o(il,"A",{id:!0,class:!0,href:!0});var ca=c(Y);Ke=o(ca,"SPAN",{});var pa=c(Ke);f(S.$$.fragment,pa),pa.forEach(t),ca.forEach(t),ml=i(il),Qe=o(il,"SPAN",{"data-svelte-h":!0}),r(Qe)!=="svelte-1p8vcb4"&&(Qe.textContent=Jl),il.forEach(t),pt=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-18kdxej"&&(A.innerHTML=Hl),ft=i(e),f(F.$$.fragment,e),ut=i(e),x=o(e,"H3",{class:!0});var rl=c(x);U=o(rl,"A",{id:!0,class:!0,href:!0});var fa=c(U);Oe=o(fa,"SPAN",{});var ua=c(Oe);f(E.$$.fragment,ua),ua.forEach(t),fa.forEach(t),wl=i(rl),ze=o(rl,"SPAN",{"data-svelte-h":!0}),r(ze)!=="svelte-1jumv67"&&(ze.textContent=Zl),rl.forEach(t),gt=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-16duplw"&&(D.innerHTML=Cl),mt=i(e),f(V.$$.fragment,e),wt=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1inqh8h"&&(K.innerHTML=ql),vt=i(e),T=o(e,"H3",{class:!0});var dl=c(T);L=o(dl,"A",{id:!0,class:!0,href:!0});var ga=c(L);et=o(ga,"SPAN",{});var ma=c(et);f(O.$$.fragment,ma),ma.forEach(t),ga.forEach(t),vl=i(dl),Pe=o(dl,"SPAN",{"data-svelte-h":!0}),r(Pe)!=="svelte-1rqdvek"&&(Pe.textContent=Yl),dl.forEach(t),bt=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1cfphxq"&&(ee.innerHTML=Ul),yt=i(e),j=o(e,"H2",{class:!0});var hl=c(j);I=o(hl,"A",{id:!0,class:!0,href:!0});var wa=c(I);tt=o(wa,"SPAN",{});var va=c(tt);f(te.$$.fragment,va),va.forEach(t),wa.forEach(t),bl=i(hl),Se=o(hl,"SPAN",{"data-svelte-h":!0}),r(Se)!=="svelte-1rxr4dz"&&(Se.textContent=Ll),hl.forEach(t),_t=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-11co58l"&&(le.innerHTML=Il),$t=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-18b676r"&&(ae.innerHTML=Gl),Mt=i(e),f(ne.$$.fragment,e),xt=i(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1lz88hc"&&(oe.innerHTML=Nl),Tt=i(e),f(se.$$.fragment,e),jt=i(e),k=o(e,"H3",{class:!0});var cl=c(k);G=o(cl,"A",{id:!0,class:!0,href:!0});var ba=c(G);lt=o(ba,"SPAN",{});var ya=c(lt);f(ie.$$.fragment,ya),ya.forEach(t),ba.forEach(t),yl=i(cl),Ae=o(cl,"SPAN",{"data-svelte-h":!0}),r(Ae)!=="svelte-1o8ylmn"&&(Ae.textContent=Xl),cl.forEach(t),kt=i(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1ezcxxa"&&(re.innerHTML=Rl),Jt=i(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-u3vbhu"&&(de.innerHTML=Wl),Ht=i(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1dn885x"&&(he.innerHTML=Bl),Zt=i(e),f(ce.$$.fragment,e),Ct=i(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-uzetax"&&(pe.innerHTML=Ql),qt=i(e),f(fe.$$.fragment,e),Yt=i(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-ndvph"&&(ue.innerHTML=zl),Ut=i(e),f(ge.$$.fragment,e),Lt=i(e),J=o(e,"H2",{class:!0});var pl=c(J);N=o(pl,"A",{id:!0,class:!0,href:!0});var _a=c(N);at=o(_a,"SPAN",{});var $a=c(at);f(me.$$.fragment,$a),$a.forEach(t),_a.forEach(t),_l=i(pl),Fe=o(pl,"SPAN",{"data-svelte-h":!0}),r(Fe)!=="svelte-rsdvjl"&&(Fe.textContent=Pl),pl.forEach(t),It=i(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1s8qfd4"&&(we.innerHTML=Sl),Gt=i(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-ph8yhc"&&(ve.innerHTML=Al),Nt=i(e),be=o(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-8wrzrg"&&(be.innerHTML=Fl),Xt=i(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-bmnyq5"&&(ye.textContent=El),Rt=i(e),_e=o(e,"TABLE",{"data-svelte-h":!0}),r(_e)!=="svelte-1qvhd9t"&&(_e.innerHTML=Dl),Wt=i(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1slb1nq"&&($e.innerHTML=Vl),Bt=i(e),H=o(e,"H2",{class:!0});var fl=c(H);X=o(fl,"A",{id:!0,class:!0,href:!0});var Ma=c(X);nt=o(Ma,"SPAN",{});var xa=c(nt);f(Me.$$.fragment,xa),xa.forEach(t),Ma.forEach(t),$l=i(fl),Ee=o(fl,"SPAN",{"data-svelte-h":!0}),r(Ee)!=="svelte-l2nvvu"&&(Ee.textContent=Kl),fl.forEach(t),Qt=i(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-u80zrb"&&(xe.innerHTML=Ol),zt=i(e),f(Te.$$.fragment,e),Pt=i(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1ivwxb5"&&(je.innerHTML=ea),St=i(e),f(ke.$$.fragment,e),At=i(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-c19wqr"&&(Je.textContent=ta),Ft=i(e),f(He.$$.fragment,e),Et=i(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1b2g1yi"&&(Ze.innerHTML=la),Dt=i(e),f(Ce.$$.fragment,e),Vt=i(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-q75tw1"&&(qe.innerHTML=aa),Kt=i(e),f(Ye.$$.fragment,e),Ot=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1qj6x7w"&&(Ue.innerHTML=na),el=i(e),f(Le.$$.fragment,e),tl=i(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-dgjt9v"&&(Ie.textContent=oa),ll=i(e),f(Ge.$$.fragment,e),al=i(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1e8vszn"&&(Ne.textContent=sa),nl=i(e),f(Xe.$$.fragment,e),this.h()},h(){d(v,"name","hf:doc:metadata"),d(v,"content",JSON.stringify(Ua)),d(_,"id","download-files-from-the-hub"),d(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(_,"href","#download-files-from-the-hub"),d(b,"class","relative group"),d(C,"id","download-a-single-file"),d(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(C,"href","#download-a-single-file"),d($,"class","relative group"),d(Y,"id","from-latest-version"),d(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Y,"href","#from-latest-version"),d(M,"class","relative group"),d(U,"id","from-specific-version"),d(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(U,"href","#from-specific-version"),d(x,"class","relative group"),d(L,"id","construct-a-download-url"),d(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(L,"href","#construct-a-download-url"),d(T,"class","relative group"),d(I,"id","download-an-entire-repository"),d(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(I,"href","#download-an-entire-repository"),d(j,"class","relative group"),d(G,"id","filter-files-to-download"),d(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(G,"href","#filter-files-to-download"),d(k,"class","relative group"),d(N,"id","download-files-to-local-folder"),d(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(N,"href","#download-files-to-local-folder"),d(J,"class","relative group"),d(X,"id","download-from-the-cli"),d(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(X,"href","#download-from-the-cli"),d(H,"class","relative group")},m(e,l){h(document.head,v),a(e,R,l),a(e,b,l),h(b,_),h(_,De),u(W,De,null),h(b,ul),h(b,We),a(e,st,l),a(e,B,l),a(e,it,l),a(e,Q,l),a(e,rt,l),a(e,$,l),h($,C),h(C,Ve),u(z,Ve,null),h($,gl),h($,Be),a(e,dt,l),a(e,P,l),a(e,ht,l),u(q,e,l),a(e,ct,l),a(e,M,l),h(M,Y),h(Y,Ke),u(S,Ke,null),h(M,ml),h(M,Qe),a(e,pt,l),a(e,A,l),a(e,ft,l),u(F,e,l),a(e,ut,l),a(e,x,l),h(x,U),h(U,Oe),u(E,Oe,null),h(x,wl),h(x,ze),a(e,gt,l),a(e,D,l),a(e,mt,l),u(V,e,l),a(e,wt,l),a(e,K,l),a(e,vt,l),a(e,T,l),h(T,L),h(L,et),u(O,et,null),h(T,vl),h(T,Pe),a(e,bt,l),a(e,ee,l),a(e,yt,l),a(e,j,l),h(j,I),h(I,tt),u(te,tt,null),h(j,bl),h(j,Se),a(e,_t,l),a(e,le,l),a(e,$t,l),a(e,ae,l),a(e,Mt,l),u(ne,e,l),a(e,xt,l),a(e,oe,l),a(e,Tt,l),u(se,e,l),a(e,jt,l),a(e,k,l),h(k,G),h(G,lt),u(ie,lt,null),h(k,yl),h(k,Ae),a(e,kt,l),a(e,re,l),a(e,Jt,l),a(e,de,l),a(e,Ht,l),a(e,he,l),a(e,Zt,l),u(ce,e,l),a(e,Ct,l),a(e,pe,l),a(e,qt,l),u(fe,e,l),a(e,Yt,l),a(e,ue,l),a(e,Ut,l),u(ge,e,l),a(e,Lt,l),a(e,J,l),h(J,N),h(N,at),u(me,at,null),h(J,_l),h(J,Fe),a(e,It,l),a(e,we,l),a(e,Gt,l),a(e,ve,l),a(e,Nt,l),a(e,be,l),a(e,Xt,l),a(e,ye,l),a(e,Rt,l),a(e,_e,l),a(e,Wt,l),a(e,$e,l),a(e,Bt,l),a(e,H,l),h(H,X),h(X,nt),u(Me,nt,null),h(H,$l),h(H,Ee),a(e,Qt,l),a(e,xe,l),a(e,zt,l),u(Te,e,l),a(e,Pt,l),a(e,je,l),a(e,St,l),u(ke,e,l),a(e,At,l),a(e,Je,l),a(e,Ft,l),u(He,e,l),a(e,Et,l),a(e,Ze,l),a(e,Dt,l),u(Ce,e,l),a(e,Vt,l),a(e,qe,l),a(e,Kt,l),u(Ye,e,l),a(e,Ot,l),a(e,Ue,l),a(e,el,l),u(Le,e,l),a(e,tl,l),a(e,Ie,l),a(e,ll,l),u(Ge,e,l),a(e,al,l),a(e,Ne,l),a(e,nl,l),u(Xe,e,l),ol=!0},p(e,[l]){const Re={};l&2&&(Re.$$scope={dirty:l,ctx:e}),q.$set(Re)},i(e){ol||(g(W.$$.fragment,e),g(z.$$.fragment,e),g(q.$$.fragment,e),g(S.$$.fragment,e),g(F.$$.fragment,e),g(E.$$.fragment,e),g(V.$$.fragment,e),g(O.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(ie.$$.fragment,e),g(ce.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(me.$$.fragment,e),g(Me.$$.fragment,e),g(Te.$$.fragment,e),g(ke.$$.fragment,e),g(He.$$.fragment,e),g(Ce.$$.fragment,e),g(Ye.$$.fragment,e),g(Le.$$.fragment,e),g(Ge.$$.fragment,e),g(Xe.$$.fragment,e),ol=!0)},o(e){m(W.$$.fragment,e),m(z.$$.fragment,e),m(q.$$.fragment,e),m(S.$$.fragment,e),m(F.$$.fragment,e),m(E.$$.fragment,e),m(V.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(me.$$.fragment,e),m(Me.$$.fragment,e),m(Te.$$.fragment,e),m(ke.$$.fragment,e),m(He.$$.fragment,e),m(Ce.$$.fragment,e),m(Ye.$$.fragment,e),m(Le.$$.fragment,e),m(Ge.$$.fragment,e),m(Xe.$$.fragment,e),ol=!1},d(e){e&&(t(R),t(b),t(st),t(B),t(it),t(Q),t(rt),t($),t(dt),t(P),t(ht),t(ct),t(M),t(pt),t(A),t(ft),t(ut),t(x),t(gt),t(D),t(mt),t(wt),t(K),t(vt),t(T),t(bt),t(ee),t(yt),t(j),t(_t),t(le),t($t),t(ae),t(Mt),t(xt),t(oe),t(Tt),t(jt),t(k),t(kt),t(re),t(Jt),t(de),t(Ht),t(he),t(Zt),t(Ct),t(pe),t(qt),t(Yt),t(ue),t(Ut),t(Lt),t(J),t(It),t(we),t(Gt),t(ve),t(Nt),t(be),t(Xt),t(ye),t(Rt),t(_e),t(Wt),t($e),t(Bt),t(H),t(Qt),t(xe),t(zt),t(Pt),t(je),t(St),t(At),t(Je),t(Ft),t(Et),t(Ze),t(Dt),t(Vt),t(qe),t(Kt),t(Ot),t(Ue),t(el),t(tl),t(Ie),t(ll),t(al),t(Ne),t(nl)),t(v),w(W),w(z),w(q,e),w(S),w(F,e),w(E),w(V,e),w(O),w(te),w(ne,e),w(se,e),w(ie),w(ce,e),w(fe,e),w(ge,e),w(me),w(Me),w(Te,e),w(ke,e),w(He,e),w(Ce,e),w(Ye,e),w(Le,e),w(Ge,e),w(Xe,e)}}}const Ua={local:"download-files-from-the-hub",sections:[{local:"download-a-single-file",sections:[{local:"from-latest-version",title:"From latest version"},{local:"from-specific-version",title:"From specific version"},{local:"construct-a-download-url",title:"Construct a download URL"}],title:"Download a single file"},{local:"download-an-entire-repository",sections:[{local:"filter-files-to-download",title:"Filter files to download"}],title:"Download an entire repository"},{local:"download-files-to-local-folder",title:"Download file(s) to local folder"},{local:"download-from-the-cli",title:"Download from the CLI"}],title:"Download files from the Hub"};function La(ot){return ja(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends Ja{constructor(v){super(),Ha(this,v,La,Ya,Ta,{})}}export{Wa as component};
