import{s as pe,f as re,n as ye,o as ce}from"../chunks/scheduler.389d799c.js";import{S as me,i as de,g as i,s as a,r as p,A as ue,h as M,f as l,c as n,j as Ft,u as r,x as o,k as U,y as he,a as s,v as y,d as c,t as m,w as d}from"../chunks/index.8f81d18f.js";import{C as h}from"../chunks/CodeBlock.3845caa1.js";import{H as tt}from"../chunks/Heading.41733039.js";function je(Vt){let j,st,et,at,w,nt,J,Qt="The get started guide will show you how to quickly use Hugging Face on Amazon SageMaker. Learn how to fine-tune and deploy a pretrained 🤗 Transformers model on SageMaker for a binary text classification task.",it,T,qt='💡 If you are new to Hugging Face, we recommend first reading the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/quicktour" rel="nofollow">quick tour</a>.',Mt,u,St,ot,f,xt='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/sagemaker-notebook.ipynb" rel="nofollow">notebook</a> to follow along!',pt,g,rt,b,Et='Get started by installing the necessary Hugging Face libraries and SageMaker. You will also need to install <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch</a> and <a href="https://www.tensorflow.org/install/pip#tensorflow-2-packages-are-available" rel="nofollow">TensorFlow</a> if you don’t already have it installed.',yt,C,ct,I,Lt='If you want to run this example in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio.html" rel="nofollow">SageMaker Studio</a>, upgrade <a href="https://ipywidgets.readthedocs.io/en/latest/" rel="nofollow">ipywidgets</a> for the 🤗 Datasets library and restart the kernel:',mt,Z,dt,k,Pt='Next, you should set up your environment: a SageMaker session and an S3 bucket. The S3 bucket will store data, models, and logs. You will need access to an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM execution role</a> with the required permissions.',ut,X,Kt='If you are planning on using SageMaker in a local environment, you need to provide the <code>role</code> yourself. Learn more about how to set this up <a href="https://huggingface.co/docs/sagemaker/train#installation-and-setup" rel="nofollow">here</a>.',ht,$,Dt="⚠️ The execution role is only available when you run a notebook within SageMaker. If you try to run <code>get_execution_role</code> in a notebook not on SageMaker, you will get a region error.",jt,_,Ut,B,wt,W,Ot='The 🤗 Datasets library makes it easy to download and preprocess a dataset for training. Download and tokenize the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">IMDb</a> dataset:',Jt,z,Tt,G,ft,H,te='Next, upload the preprocessed dataset to your S3 session bucket with 🤗 Datasets S3 <a href="https://huggingface.co/docs/datasets/filesystems.html" rel="nofollow">filesystem</a> implementation:',gt,v,bt,A,Ct,N,ee="Create a Hugging Face Estimator to handle end-to-end SageMaker training and deployment. The most important parameters to pay attention to are:",It,R,le='<li><code>entry_point</code> refers to the fine-tuning script which you can find <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">here</a>.</li> <li><code>instance_type</code> refers to the SageMaker instance that will be launched. Take a look <a href="https://aws.amazon.com/sagemaker/pricing/" rel="nofollow">here</a> for a complete list of instance types.</li> <li><code>hyperparameters</code> refers to the training hyperparameters the model will be fine-tuned with.</li>',Zt,Y,kt,F,se="Begin training with one line of code:",Xt,V,$t,Q,_t,q,ae="Once the training job is complete, deploy your fine-tuned model by calling <code>deploy()</code> with the number of instances and instance type:",Bt,S,Wt,x,ne="Call <code>predict()</code> on your data:",zt,E,Gt,L,ie="After running your request, delete the endpoint:",Ht,P,vt,K,At,D,Me="Congratulations, you’ve just fine-tuned and deployed a pretrained 🤗 Transformers model on SageMaker! 🎉",Nt,O,oe='For your next steps, keep reading our documentation for more details about training and deployment. There are many interesting features such as <a href="/docs/sagemaker/train#distributed-training">distributed training</a> and <a href="/docs/sagemaker/train#spot-instances">Spot instances</a>.',Rt,lt,Yt;return w=new tt({props:{title:"Train and deploy Hugging Face on Amazon SageMaker",local:"train-and-deploy-hugging-face-on-amazon-sagemaker",headingTag:"h1"}}),g=new tt({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),C=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNhZ2VtYWtlciUzRSUzRDIuMTQwLjAlMjIlMjAlMjJ0cmFuc2Zvcm1lcnMlM0QlM0Q0LjI2LjElMjIlMjAlMjJkYXRhc2V0cyU1QnMzJTVEJTNEJTNEMi4xMC4xJTIyJTIwLS11cGdyYWRl",highlighted:'pip install <span class="hljs-string">&quot;sagemaker&gt;=2.140.0&quot;</span> <span class="hljs-string">&quot;transformers==4.26.1&quot;</span> <span class="hljs-string">&quot;datasets[s3]==2.10.1&quot;</span> --upgrade',wrap:!1}}),Z=new h({props:{code:"JTI1JTI1Y2FwdHVyZSUwQWltcG9ydCUyMElQeXRob24lMEEhY29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGlweXdpZGdldHMlMjAteSUwQUlQeXRob24uQXBwbGljYXRpb24uaW5zdGFuY2UoKS5rZXJuZWwuZG9fc2h1dGRvd24oVHJ1ZSk=",highlighted:`%%capture
<span class="hljs-keyword">import</span> IPython
!conda install -c conda-forge ipywidgets -y
IPython.Application.instance().kernel.do_shutdown(<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new h({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjAlM0QlMjBOb25lJTBBaWYlMjBzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjBpcyUyME5vbmUlMjBhbmQlMjBzZXNzJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2FnZW1ha2VyX3Nlc3Npb25fYnVja2V0JTIwJTNEJTIwc2Vzcy5kZWZhdWx0X2J1Y2tldCgpJTBBJTBBcm9sZSUyMCUzRCUyMHNhZ2VtYWtlci5nZXRfZXhlY3V0aW9uX3JvbGUoKSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker

sess = sagemaker.Session()
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    sagemaker_session_bucket = sess.default_bucket()

role = sagemaker.get_execution_role()
sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)`,wrap:!1}}),B=new tt({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),z=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBsb2FkJTIwZGF0YXNldCUwQXRyYWluX2RhdGFzZXQlMkMlMjB0ZXN0X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTVCJTIydHJhaW4lMjIlMkMlMjAlMjJ0ZXN0JTIyJTVEKSUwQSUwQSUyMyUyMGxvYWQlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMEElMjMlMjBjcmVhdGUlMjB0b2tlbml6YXRpb24lMjBmdW5jdGlvbiUwQWRlZiUyMHRva2VuaXplKGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplcihiYXRjaCU1QiUyMnRleHQlMjIlNUQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHRydW5jYXRpb24lM0RUcnVlKSUwQSUwQSUyMyUyMHRva2VuaXplJTIwdHJhaW4lMjBhbmQlMjB0ZXN0JTIwZGF0YXNldHMlMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwdHJhaW5fZGF0YXNldC5tYXAodG9rZW5pemUlMkMlMjBiYXRjaGVkJTNEVHJ1ZSklMEF0ZXN0X2RhdGFzZXQlMjAlM0QlMjB0ZXN0X2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBJTBBJTIzJTIwc2V0JTIwZGF0YXNldCUyMGZvcm1hdCUyMGZvciUyMFB5VG9yY2glMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwJTIwdHJhaW5fZGF0YXNldC5yZW5hbWVfY29sdW1uKCUyMmxhYmVsJTIyJTJDJTIwJTIybGFiZWxzJTIyKSUwQXRyYWluX2RhdGFzZXQuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiUyQyUyMGNvbHVtbnMlM0QlNUIlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJhdHRlbnRpb25fbWFzayUyMiUyQyUyMCUyMmxhYmVscyUyMiU1RCklMEF0ZXN0X2RhdGFzZXQlMjAlM0QlMjB0ZXN0X2RhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0ZXN0X2RhdGFzZXQuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiUyQyUyMGNvbHVtbnMlM0QlNUIlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJhdHRlbnRpb25fbWFzayUyMiUyQyUyMCUyMmxhYmVscyUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># load dataset</span>
train_dataset, test_dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=[<span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;test&quot;</span>])

<span class="hljs-comment"># load tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)

<span class="hljs-comment"># create tokenization function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># tokenize train and test datasets</span>
train_dataset = train_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)
test_dataset = test_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># set dataset format for PyTorch</span>
train_dataset =  train_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
train_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])
test_dataset = test_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
test_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),G=new tt({props:{title:"Upload dataset to S3 bucket",local:"upload-dataset-to-s3-bucket",headingTag:"h2"}}),v=new h({props:{code:"JTIzJTIwc2F2ZSUyMHRyYWluX2RhdGFzZXQlMjB0byUyMHMzJTBBdHJhaW5pbmdfaW5wdXRfcGF0aCUyMCUzRCUyMGYnczMlM0ElMkYlMkYlN0JzZXNzLmRlZmF1bHRfYnVja2V0KCklN0QlMkYlN0JzM19wcmVmaXglN0QlMkZ0cmFpbiclMEF0cmFpbl9kYXRhc2V0LnNhdmVfdG9fZGlzayh0cmFpbmluZ19pbnB1dF9wYXRoKSUwQSUwQSUyMyUyMHNhdmUlMjB0ZXN0X2RhdGFzZXQlMjB0byUyMHMzJTBBdGVzdF9pbnB1dF9wYXRoJTIwJTNEJTIwZidzMyUzQSUyRiUyRiU3QnNlc3MuZGVmYXVsdF9idWNrZXQoKSU3RCUyRiU3QnMzX3ByZWZpeCU3RCUyRnRlc3QnJTBBdGVzdF9kYXRhc2V0LnNhdmVfdG9fZGlzayh0ZXN0X2lucHV0X3BhdGgp",highlighted:`<span class="hljs-comment"># save train_dataset to s3</span>
training_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/train&#x27;</span>
train_dataset.save_to_disk(training_input_path)

<span class="hljs-comment"># save test_dataset to s3</span>
test_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/test&#x27;</span>
test_dataset.save_to_disk(test_input_path)`,wrap:!1}}),A=new tt({props:{title:"Start a training job",local:"start-a-training-job",headingTag:"h2"}}),Y=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

hyperparameters={
    <span class="hljs-string">&quot;epochs&quot;</span>: <span class="hljs-number">1</span>,                            <span class="hljs-comment"># number of training epochs</span>
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: <span class="hljs-number">32</span>,                 <span class="hljs-comment"># training batch size</span>
    <span class="hljs-string">&quot;model_name&quot;</span>:<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>  <span class="hljs-comment"># name of pretrained model</span>
}

huggingface_estimator = HuggingFace(
    entry_point=<span class="hljs-string">&quot;train.py&quot;</span>,                 <span class="hljs-comment"># fine-tuning script to use in training job</span>
    source_dir=<span class="hljs-string">&quot;./scripts&quot;</span>,                 <span class="hljs-comment"># directory where fine-tuning script is stored</span>
    instance_type=<span class="hljs-string">&quot;ml.p3.2xlarge&quot;</span>,          <span class="hljs-comment"># instance type</span>
    instance_count=<span class="hljs-number">1</span>,                       <span class="hljs-comment"># number of instances</span>
    role=role,                              <span class="hljs-comment"># IAM role used in training job to acccess AWS resources (S3)</span>
    transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,             <span class="hljs-comment"># Transformers version</span>
    pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                  <span class="hljs-comment"># PyTorch version</span>
    py_version=<span class="hljs-string">&quot;py39&quot;</span>,                      <span class="hljs-comment"># Python version</span>
    hyperparameters=hyperparameters         <span class="hljs-comment"># hyperparameters to use in training job</span>
)`,wrap:!1}}),V=new h({props:{code:"aHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdCglN0IlMjJ0cmFpbiUyMiUzQSUyMHRyYWluaW5nX2lucHV0X3BhdGglMkMlMjAlMjJ0ZXN0JTIyJTNBJTIwdGVzdF9pbnB1dF9wYXRoJTdEKQ==",highlighted:'huggingface_estimator.fit({<span class="hljs-string">&quot;train&quot;</span>: training_input_path, <span class="hljs-string">&quot;test&quot;</span>: test_input_path})',wrap:!1}}),Q=new tt({props:{title:"Deploy model",local:"deploy-model",headingTag:"h2"}}),S=new h({props:{code:"cHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMm1sLmc0ZG4ueGxhcmdlJTIyKQ==",highlighted:'predictor = huggingface_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>,<span class="hljs-string">&quot;ml.g4dn.xlarge&quot;</span>)',wrap:!1}}),E=new h({props:{code:"c2VudGltZW50X2lucHV0JTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySXQlMjBmZWVscyUyMGxpa2UlMjBhJTIwY3VydGFpbiUyMGNsb3NpbmcuLi50aGVyZSUyMHdhcyUyMGFuJTIwZWxlZ2FuY2UlMjBpbiUyMHRoZSUyMHdheSUyMHRoZXklMjBtb3ZlZCUyMHRvd2FyZCUyMGNvbmNsdXNpb24uJTIwTm8lMjBmYW4lMjBpcyUyMGdvaW5nJTIwdG8lMjB3YXRjaCUyMGFuZCUyMGZlZWwlMjBzaG9ydC1jaGFuZ2VkLiUyMiU3RCUwQSUwQXByZWRpY3Rvci5wcmVkaWN0KHNlbnRpbWVudF9pbnB1dCk=",highlighted:`sentiment_input = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;It feels like a curtain closing...there was an elegance in the way they moved toward conclusion. No fan is going to watch and feel short-changed.&quot;</span>}

predictor.predict(sentiment_input)`,wrap:!1}}),P=new h({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:"predictor.delete_endpoint()",wrap:!1}}),K=new tt({props:{title:"What’s next?",local:"whats-next",headingTag:"h2"}}),{c(){j=i("meta"),st=a(),et=i("p"),at=a(),p(w.$$.fragment),nt=a(),J=i("p"),J.textContent=Qt,it=a(),T=i("p"),T.innerHTML=qt,Mt=a(),u=i("iframe"),ot=a(),f=i("p"),f.innerHTML=xt,pt=a(),p(g.$$.fragment),rt=a(),b=i("p"),b.innerHTML=Et,yt=a(),p(C.$$.fragment),ct=a(),I=i("p"),I.innerHTML=Lt,mt=a(),p(Z.$$.fragment),dt=a(),k=i("p"),k.innerHTML=Pt,ut=a(),X=i("p"),X.innerHTML=Kt,ht=a(),$=i("p"),$.innerHTML=Dt,jt=a(),p(_.$$.fragment),Ut=a(),p(B.$$.fragment),wt=a(),W=i("p"),W.innerHTML=Ot,Jt=a(),p(z.$$.fragment),Tt=a(),p(G.$$.fragment),ft=a(),H=i("p"),H.innerHTML=te,gt=a(),p(v.$$.fragment),bt=a(),p(A.$$.fragment),Ct=a(),N=i("p"),N.textContent=ee,It=a(),R=i("ul"),R.innerHTML=le,Zt=a(),p(Y.$$.fragment),kt=a(),F=i("p"),F.textContent=se,Xt=a(),p(V.$$.fragment),$t=a(),p(Q.$$.fragment),_t=a(),q=i("p"),q.innerHTML=ae,Bt=a(),p(S.$$.fragment),Wt=a(),x=i("p"),x.innerHTML=ne,zt=a(),p(E.$$.fragment),Gt=a(),L=i("p"),L.textContent=ie,Ht=a(),p(P.$$.fragment),vt=a(),p(K.$$.fragment),At=a(),D=i("p"),D.textContent=Me,Nt=a(),O=i("p"),O.innerHTML=oe,Rt=a(),lt=i("p"),this.h()},l(t){const e=ue("svelte-u9bgzb",document.head);j=M(e,"META",{name:!0,content:!0}),e.forEach(l),st=n(t),et=M(t,"P",{}),Ft(et).forEach(l),at=n(t),r(w.$$.fragment,t),nt=n(t),J=M(t,"P",{"data-svelte-h":!0}),o(J)!=="svelte-n7q5fy"&&(J.textContent=Qt),it=n(t),T=M(t,"P",{"data-svelte-h":!0}),o(T)!=="svelte-uamv5h"&&(T.innerHTML=qt),Mt=n(t),u=M(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Ft(u).forEach(l),ot=n(t),f=M(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-edxdkx"&&(f.innerHTML=xt),pt=n(t),r(g.$$.fragment,t),rt=n(t),b=M(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-10ldwp9"&&(b.innerHTML=Et),yt=n(t),r(C.$$.fragment,t),ct=n(t),I=M(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-yozy2b"&&(I.innerHTML=Lt),mt=n(t),r(Z.$$.fragment,t),dt=n(t),k=M(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1sllt2f"&&(k.innerHTML=Pt),ut=n(t),X=M(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-tg9h77"&&(X.innerHTML=Kt),ht=n(t),$=M(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-y9vgbx"&&($.innerHTML=Dt),jt=n(t),r(_.$$.fragment,t),Ut=n(t),r(B.$$.fragment,t),wt=n(t),W=M(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-b8daui"&&(W.innerHTML=Ot),Jt=n(t),r(z.$$.fragment,t),Tt=n(t),r(G.$$.fragment,t),ft=n(t),H=M(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-nm384r"&&(H.innerHTML=te),gt=n(t),r(v.$$.fragment,t),bt=n(t),r(A.$$.fragment,t),Ct=n(t),N=M(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-16p4w97"&&(N.textContent=ee),It=n(t),R=M(t,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-11sz5m6"&&(R.innerHTML=le),Zt=n(t),r(Y.$$.fragment,t),kt=n(t),F=M(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-b865q9"&&(F.textContent=se),Xt=n(t),r(V.$$.fragment,t),$t=n(t),r(Q.$$.fragment,t),_t=n(t),q=M(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-twh61n"&&(q.innerHTML=ae),Bt=n(t),r(S.$$.fragment,t),Wt=n(t),x=M(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-19s4ndj"&&(x.innerHTML=ne),zt=n(t),r(E.$$.fragment,t),Gt=n(t),L=M(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-l180zc"&&(L.textContent=ie),Ht=n(t),r(P.$$.fragment,t),vt=n(t),r(K.$$.fragment,t),At=n(t),D=M(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1rjk4za"&&(D.textContent=Me),Nt=n(t),O=M(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1qzgnqe"&&(O.innerHTML=oe),Rt=n(t),lt=M(t,"P",{}),Ft(lt).forEach(l),this.h()},h(){U(j,"name","hf:doc:metadata"),U(j,"content",Ue),U(u,"width","560"),U(u,"height","315"),re(u.src,St="https://www.youtube.com/embed/pYqjCzoyWyo")||U(u,"src",St),U(u,"title","YouTube video player"),U(u,"frameborder","0"),U(u,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),u.allowFullscreen=""},m(t,e){he(document.head,j),s(t,st,e),s(t,et,e),s(t,at,e),y(w,t,e),s(t,nt,e),s(t,J,e),s(t,it,e),s(t,T,e),s(t,Mt,e),s(t,u,e),s(t,ot,e),s(t,f,e),s(t,pt,e),y(g,t,e),s(t,rt,e),s(t,b,e),s(t,yt,e),y(C,t,e),s(t,ct,e),s(t,I,e),s(t,mt,e),y(Z,t,e),s(t,dt,e),s(t,k,e),s(t,ut,e),s(t,X,e),s(t,ht,e),s(t,$,e),s(t,jt,e),y(_,t,e),s(t,Ut,e),y(B,t,e),s(t,wt,e),s(t,W,e),s(t,Jt,e),y(z,t,e),s(t,Tt,e),y(G,t,e),s(t,ft,e),s(t,H,e),s(t,gt,e),y(v,t,e),s(t,bt,e),y(A,t,e),s(t,Ct,e),s(t,N,e),s(t,It,e),s(t,R,e),s(t,Zt,e),y(Y,t,e),s(t,kt,e),s(t,F,e),s(t,Xt,e),y(V,t,e),s(t,$t,e),y(Q,t,e),s(t,_t,e),s(t,q,e),s(t,Bt,e),y(S,t,e),s(t,Wt,e),s(t,x,e),s(t,zt,e),y(E,t,e),s(t,Gt,e),s(t,L,e),s(t,Ht,e),y(P,t,e),s(t,vt,e),y(K,t,e),s(t,At,e),s(t,D,e),s(t,Nt,e),s(t,O,e),s(t,Rt,e),s(t,lt,e),Yt=!0},p:ye,i(t){Yt||(c(w.$$.fragment,t),c(g.$$.fragment,t),c(C.$$.fragment,t),c(Z.$$.fragment,t),c(_.$$.fragment,t),c(B.$$.fragment,t),c(z.$$.fragment,t),c(G.$$.fragment,t),c(v.$$.fragment,t),c(A.$$.fragment,t),c(Y.$$.fragment,t),c(V.$$.fragment,t),c(Q.$$.fragment,t),c(S.$$.fragment,t),c(E.$$.fragment,t),c(P.$$.fragment,t),c(K.$$.fragment,t),Yt=!0)},o(t){m(w.$$.fragment,t),m(g.$$.fragment,t),m(C.$$.fragment,t),m(Z.$$.fragment,t),m(_.$$.fragment,t),m(B.$$.fragment,t),m(z.$$.fragment,t),m(G.$$.fragment,t),m(v.$$.fragment,t),m(A.$$.fragment,t),m(Y.$$.fragment,t),m(V.$$.fragment,t),m(Q.$$.fragment,t),m(S.$$.fragment,t),m(E.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),Yt=!1},d(t){t&&(l(st),l(et),l(at),l(nt),l(J),l(it),l(T),l(Mt),l(u),l(ot),l(f),l(pt),l(rt),l(b),l(yt),l(ct),l(I),l(mt),l(dt),l(k),l(ut),l(X),l(ht),l($),l(jt),l(Ut),l(wt),l(W),l(Jt),l(Tt),l(ft),l(H),l(gt),l(bt),l(Ct),l(N),l(It),l(R),l(Zt),l(kt),l(F),l(Xt),l($t),l(_t),l(q),l(Bt),l(Wt),l(x),l(zt),l(Gt),l(L),l(Ht),l(vt),l(At),l(D),l(Nt),l(O),l(Rt),l(lt)),l(j),d(w,t),d(g,t),d(C,t),d(Z,t),d(_,t),d(B,t),d(z,t),d(G,t),d(v,t),d(A,t),d(Y,t),d(V,t),d(Q,t),d(S,t),d(E,t),d(P,t),d(K,t)}}}const Ue='{"title":"Train and deploy Hugging Face on Amazon SageMaker","local":"train-and-deploy-hugging-face-on-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Upload dataset to S3 bucket","local":"upload-dataset-to-s3-bucket","sections":[],"depth":2},{"title":"Start a training job","local":"start-a-training-job","sections":[],"depth":2},{"title":"Deploy model","local":"deploy-model","sections":[],"depth":2},{"title":"What’s next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function we(Vt){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends me{constructor(j){super(),de(this,j,we,je,pe,{})}}export{be as component};
