import{s as pl,f as nl,o as dl,n as ul}from"../chunks/scheduler.f6319a2a.js";import{S as hl,i as ml,g as n,s,r as p,A as cl,h as i,f as l,c as a,j as il,u as d,x as r,k as vt,y as Ml,a as o,v as h,d as m,t as c,w as M}from"../chunks/index.85aa684c.js";import{T as rl}from"../chunks/Tip.3d397a88.js";import{C as f}from"../chunks/CodeBlock.97b48fd2.js";import{D as yl}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as fe,E as bl}from"../chunks/EditOnGithub.006048dd.js";function fl(ge){let u,b='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){u=n("p"),u.innerHTML=b},l(y){u=i(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1p1d9vw"&&(u.innerHTML=b)},m(y,g){o(y,u,g)},p:ul,d(y){y&&l(u)}}}function gl(ge){let u,b="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){u=n("p"),u.textContent=b},l(y){u=i(y,"P",{"data-svelte-h":!0}),r(u)!=="svelte-h9mzfm"&&(u.textContent=b)},m(y,g){o(y,u,g)},p:ul,d(y){y&&l(u)}}}function wl(ge){let u,b,y,g,T,Je,J,ve,v,Ct="Here, we’re going to see advanced tool usage.",Ce,w,je,C,jt='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',$e,j,_e,$,$t="A tool is mostly a function that an LLM can use in an agentic system.",Ie,_,_t="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Ze,I,It="So it cannot be only a function. It should be a class.",He,Z,Zt="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",Ge,H,Ht="Here’s how it looks:",ke,G,Be,k,Gt='The custom tool subclasses <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',xe,B,kt='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',Re,x,Bt="And that’s all it needs to be used in an agent!",We,R,xt='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/main/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',Ve,W,Rt='In this case, you can build your tool by subclassing <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> as described above.',Qe,V,Ae,Q,Wt='You can share your custom tool to the Hub by calling <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Ee,A,Le,E,Vt="For the push to Hub to work, your tool will need to respect some rules:",Ne,L,Qt='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',Se,N,At='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',Fe,S,Et='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',qe,F,Lt=`Then you can load the tool with <a href="/docs/smolagents/main/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,Ye,q,ze,Y,Xe,z,Nt='You can directly import a Space from the Hub as a tool using the <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',Pe,X,St='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',De,P,Ft='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',Ke,D,Oe,K,qt="And voilà, here’s your image! 🏖️",et,we,Yt,tt,O,zt="Then you can use this tool just like any other tool.  For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code> and generate an image of it.",lt,ee,ot,te,st,Ue,Xt,at,le,Pt="How cool is this? 🤩",nt,oe,it,se,Dt=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,rt,ae,Kt=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,ut,ne,pt,ie,dt,re,Ot="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",ht,ue,el="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",mt,pe,ct,de,tl="Now we can leverage the new tool:",Mt,he,yt,U,bt,me,ft,ce,ll=`You can leverage tool collections by using the <code>ToolCollection</code> object, with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,gt,Me,wt,ye,ol="To speed up the start, tools are loaded only if called by the agent.",Ut,be,Tt,Te,Jt;return T=new fe({props:{title:"Tools",local:"tools",headingTag:"h1"}}),J=new yl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),w=new rl({props:{warning:!1,$$slots:{default:[fl]},$$scope:{ctx:ge}}}),j=new fe({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),G=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),V=new fe({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),A=new f({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),q=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Y=new fe({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),D=new f({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),ee=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTIwcHJvbXB0JTNEJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, prompt=<span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>
)`,wrap:!1}}),te=new f({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),oe=new fe({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),ne=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),ie=new fe({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),pe=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBYWdlbnQudG9vbHMlNUJtb2RlbF9kb3dubG9hZF90b29sLm5hbWUlNUQlMjAlM0QlMjBtb2RlbF9kb3dubG9hZF90b29s",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),he=new f({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),U=new rl({props:{warning:!1,$$slots:{default:[gl]},$$scope:{ctx:ge}}}),me=new fe({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),Me=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),be=new bl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){u=n("meta"),b=s(),y=n("p"),g=s(),p(T.$$.fragment),Je=s(),p(J.$$.fragment),ve=s(),v=n("p"),v.textContent=Ct,Ce=s(),p(w.$$.fragment),je=s(),C=n("ul"),C.innerHTML=jt,$e=s(),p(j.$$.fragment),_e=s(),$=n("p"),$.textContent=$t,Ie=s(),_=n("p"),_.textContent=_t,Ze=s(),I=n("p"),I.textContent=It,He=s(),Z=n("p"),Z.textContent=Zt,Ge=s(),H=n("p"),H.textContent=Ht,ke=s(),p(G.$$.fragment),Be=s(),k=n("p"),k.innerHTML=Gt,xe=s(),B=n("ul"),B.innerHTML=kt,Re=s(),x=n("p"),x.textContent=Bt,We=s(),R=n("p"),R.innerHTML=xt,Ve=s(),W=n("p"),W.innerHTML=Rt,Qe=s(),p(V.$$.fragment),Ae=s(),Q=n("p"),Q.innerHTML=Wt,Ee=s(),p(A.$$.fragment),Le=s(),E=n("p"),E.textContent=Vt,Ne=s(),L=n("ul"),L.innerHTML=Qt,Se=s(),N=n("p"),N.innerHTML=At,Fe=s(),S=n("p"),S.innerHTML=Et,qe=s(),F=n("p"),F.innerHTML=Lt,Ye=s(),p(q.$$.fragment),ze=s(),p(Y.$$.fragment),Xe=s(),z=n("p"),z.innerHTML=Nt,Pe=s(),X=n("p"),X.innerHTML=St,De=s(),P=n("p"),P.innerHTML=Ft,Ke=s(),p(D.$$.fragment),Oe=s(),K=n("p"),K.textContent=qt,et=s(),we=n("img"),tt=s(),O=n("p"),O.innerHTML=zt,lt=s(),p(ee.$$.fragment),ot=s(),p(te.$$.fragment),st=s(),Ue=n("img"),at=s(),le=n("p"),le.textContent=Pt,nt=s(),p(oe.$$.fragment),it=s(),se=n("p"),se.innerHTML=Dt,rt=s(),ae=n("p"),ae.innerHTML=Kt,ut=s(),p(ne.$$.fragment),pt=s(),p(ie.$$.fragment),dt=s(),re=n("p"),re.innerHTML=Ot,ht=s(),ue=n("p"),ue.innerHTML=el,mt=s(),p(pe.$$.fragment),ct=s(),de=n("p"),de.textContent=tl,Mt=s(),p(he.$$.fragment),yt=s(),p(U.$$.fragment),bt=s(),p(me.$$.fragment),ft=s(),ce=n("p"),ce.innerHTML=ll,gt=s(),p(Me.$$.fragment),wt=s(),ye=n("p"),ye.textContent=ol,Ut=s(),p(be.$$.fragment),Tt=s(),Te=n("p"),this.h()},l(e){const t=cl("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),b=a(e),y=i(e,"P",{}),il(y).forEach(l),g=a(e),d(T.$$.fragment,e),Je=a(e),d(J.$$.fragment,e),ve=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-8951oz"&&(v.textContent=Ct),Ce=a(e),d(w.$$.fragment,e),je=a(e),C=i(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-gdosxb"&&(C.innerHTML=jt),$e=a(e),d(j.$$.fragment,e),_e=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-50z9h0"&&($.textContent=$t),Ie=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1llqfcr"&&(_.textContent=_t),Ze=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-eilpgu"&&(I.textContent=It),He=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-suz7fy"&&(Z.textContent=Zt),Ge=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-x18ywb"&&(H.textContent=Ht),ke=a(e),d(G.$$.fragment,e),Be=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-prn7f3"&&(k.innerHTML=Gt),xe=a(e),B=i(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-xqgwuf"&&(B.innerHTML=kt),Re=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-220ayw"&&(x.textContent=Bt),We=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-13idprj"&&(R.innerHTML=xt),Ve=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1lot62h"&&(W.innerHTML=Rt),Qe=a(e),d(V.$$.fragment,e),Ae=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1p4y3bf"&&(Q.innerHTML=Wt),Ee=a(e),d(A.$$.fragment,e),Le=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-hoocvd"&&(E.textContent=Vt),Ne=a(e),L=i(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-cqj6gr"&&(L.innerHTML=Qt),Se=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-4n5s3c"&&(N.innerHTML=At),Fe=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1knl8v8"&&(S.innerHTML=Et),qe=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1skw0cc"&&(F.innerHTML=Lt),Ye=a(e),d(q.$$.fragment,e),ze=a(e),d(Y.$$.fragment,e),Xe=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-6y3nzn"&&(z.innerHTML=Nt),Pe=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1xkj0c9"&&(X.innerHTML=St),De=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1gucs20"&&(P.innerHTML=Ft),Ke=a(e),d(D.$$.fragment,e),Oe=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-sgspwr"&&(K.textContent=qt),et=a(e),we=i(e,"IMG",{src:!0}),tt=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-3y2998"&&(O.innerHTML=zt),lt=a(e),d(ee.$$.fragment,e),ot=a(e),d(te.$$.fragment,e),st=a(e),Ue=i(e,"IMG",{src:!0}),at=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-i5dtbz"&&(le.textContent=Pt),nt=a(e),d(oe.$$.fragment,e),it=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1rq40pf"&&(se.innerHTML=Dt),rt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1g7jkvd"&&(ae.innerHTML=Kt),ut=a(e),d(ne.$$.fragment,e),pt=a(e),d(ie.$$.fragment,e),dt=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-69p3x"&&(re.innerHTML=Ot),ht=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-ocb8u2"&&(ue.innerHTML=el),mt=a(e),d(pe.$$.fragment,e),ct=a(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-o3ledg"&&(de.textContent=tl),Mt=a(e),d(he.$$.fragment,e),yt=a(e),d(U.$$.fragment,e),bt=a(e),d(me.$$.fragment,e),ft=a(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-f5mdoi"&&(ce.innerHTML=ll),gt=a(e),d(Me.$$.fragment,e),wt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-6r1jgt"&&(ye.textContent=ol),Ut=a(e),d(be.$$.fragment,e),Tt=a(e),Te=i(e,"P",{}),il(Te).forEach(l),this.h()},h(){vt(u,"name","hf:doc:metadata"),vt(u,"content",Ul),nl(we.src,Yt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||vt(we,"src",Yt),nl(Ue.src,Xt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||vt(Ue,"src",Xt)},m(e,t){Ml(document.head,u),o(e,b,t),o(e,y,t),o(e,g,t),h(T,e,t),o(e,Je,t),h(J,e,t),o(e,ve,t),o(e,v,t),o(e,Ce,t),h(w,e,t),o(e,je,t),o(e,C,t),o(e,$e,t),h(j,e,t),o(e,_e,t),o(e,$,t),o(e,Ie,t),o(e,_,t),o(e,Ze,t),o(e,I,t),o(e,He,t),o(e,Z,t),o(e,Ge,t),o(e,H,t),o(e,ke,t),h(G,e,t),o(e,Be,t),o(e,k,t),o(e,xe,t),o(e,B,t),o(e,Re,t),o(e,x,t),o(e,We,t),o(e,R,t),o(e,Ve,t),o(e,W,t),o(e,Qe,t),h(V,e,t),o(e,Ae,t),o(e,Q,t),o(e,Ee,t),h(A,e,t),o(e,Le,t),o(e,E,t),o(e,Ne,t),o(e,L,t),o(e,Se,t),o(e,N,t),o(e,Fe,t),o(e,S,t),o(e,qe,t),o(e,F,t),o(e,Ye,t),h(q,e,t),o(e,ze,t),h(Y,e,t),o(e,Xe,t),o(e,z,t),o(e,Pe,t),o(e,X,t),o(e,De,t),o(e,P,t),o(e,Ke,t),h(D,e,t),o(e,Oe,t),o(e,K,t),o(e,et,t),o(e,we,t),o(e,tt,t),o(e,O,t),o(e,lt,t),h(ee,e,t),o(e,ot,t),h(te,e,t),o(e,st,t),o(e,Ue,t),o(e,at,t),o(e,le,t),o(e,nt,t),h(oe,e,t),o(e,it,t),o(e,se,t),o(e,rt,t),o(e,ae,t),o(e,ut,t),h(ne,e,t),o(e,pt,t),h(ie,e,t),o(e,dt,t),o(e,re,t),o(e,ht,t),o(e,ue,t),o(e,mt,t),h(pe,e,t),o(e,ct,t),o(e,de,t),o(e,Mt,t),h(he,e,t),o(e,yt,t),h(U,e,t),o(e,bt,t),h(me,e,t),o(e,ft,t),o(e,ce,t),o(e,gt,t),h(Me,e,t),o(e,wt,t),o(e,ye,t),o(e,Ut,t),h(be,e,t),o(e,Tt,t),o(e,Te,t),Jt=!0},p(e,[t]){const sl={};t&2&&(sl.$$scope={dirty:t,ctx:e}),w.$set(sl);const al={};t&2&&(al.$$scope={dirty:t,ctx:e}),U.$set(al)},i(e){Jt||(m(T.$$.fragment,e),m(J.$$.fragment,e),m(w.$$.fragment,e),m(j.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(A.$$.fragment,e),m(q.$$.fragment,e),m(Y.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(oe.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(he.$$.fragment,e),m(U.$$.fragment,e),m(me.$$.fragment,e),m(Me.$$.fragment,e),m(be.$$.fragment,e),Jt=!0)},o(e){c(T.$$.fragment,e),c(J.$$.fragment,e),c(w.$$.fragment,e),c(j.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(A.$$.fragment,e),c(q.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(U.$$.fragment,e),c(me.$$.fragment,e),c(Me.$$.fragment,e),c(be.$$.fragment,e),Jt=!1},d(e){e&&(l(b),l(y),l(g),l(Je),l(ve),l(v),l(Ce),l(je),l(C),l($e),l(_e),l($),l(Ie),l(_),l(Ze),l(I),l(He),l(Z),l(Ge),l(H),l(ke),l(Be),l(k),l(xe),l(B),l(Re),l(x),l(We),l(R),l(Ve),l(W),l(Qe),l(Ae),l(Q),l(Ee),l(Le),l(E),l(Ne),l(L),l(Se),l(N),l(Fe),l(S),l(qe),l(F),l(Ye),l(ze),l(Xe),l(z),l(Pe),l(X),l(De),l(P),l(Ke),l(Oe),l(K),l(et),l(we),l(tt),l(O),l(lt),l(ot),l(st),l(Ue),l(at),l(le),l(nt),l(it),l(se),l(rt),l(ae),l(ut),l(pt),l(dt),l(re),l(ht),l(ue),l(mt),l(ct),l(de),l(Mt),l(yt),l(bt),l(ft),l(ce),l(gt),l(wt),l(ye),l(Ut),l(Tt),l(Te)),l(u),M(T,e),M(J,e),M(w,e),M(j,e),M(G,e),M(V,e),M(A,e),M(q,e),M(Y,e),M(D,e),M(ee,e),M(te,e),M(oe,e),M(ne,e),M(ie,e),M(pe,e),M(he,e),M(U,e),M(me,e),M(Me,e),M(be,e)}}}const Ul='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[],"depth":3}],"depth":1}';function Tl(ge){return dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends hl{constructor(u){super(),ml(this,u,Tl,wl,pl,{})}}export{Il as component};
