import{s as se,n as ae,o as oe}from"../chunks/scheduler.505acc25.js";import{S as ie,i as re,e as o,s,c as p,h as pe,a as i,d as n,b as a,f as le,g as c,j as r,k as P,l as ce,m as l,n as y,t as m,o as u,p as M}from"../chunks/index.fbb49fb4.js";import{C as ye}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as Wt}from"../chunks/CodeBlock.7f0851b7.js";import{H as Qt}from"../chunks/Heading.511e0027.js";import{E as me}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function ue(kt){let w,D,N,K,h,O,b,tt,g,Vt=`Remember Alfred, our helpful butler agent from earlier? Well, he’s about to get an upgrade!
Now that we understand the tools available in LlamaIndex, we can give Alfred new capabilities to serve us better.`,et,U,_t=`But before we continue, let’s remind ourselves what makes an agent like Alfred tick.
Back in Unit 1, we learned that:`,nt,f,Rt="<p>An Agent is a system that leverages an AI model to interact with its environment to achieve a user-defined objective. It combines reasoning, planning, and action execution (often via external tools) to fulfil tasks.</p>",lt,j,St="LlamaIndex supports <strong>three main types of reasoning agents:</strong>",st,I,At='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/agents.png" alt="Agents"/>',at,B,Yt="<li><code>Function Calling Agents</code> - These work with AI models that can call specific functions.</li> <li><code>ReAct Agents</code> - These can work with any AI that does chat or text endpoint and deal with complex reasoning tasks.</li> <li><code>Advanced Custom Agents</code> - These use more complex methods to deal with more complex tasks and workflows.</li>",ot,d,Ht='<p>Find more information on advanced agents on <a href="https://github.com/run-llama/llama_index/blob/main/llama-index-core/llama_index/core/agent/workflow/base_agent.py">BaseWorkflowAgent</a></p>',it,C,rt,J,Et='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',pt,x,Xt=`To create an agent, we start by providing it with a <strong>set of functions/tools that define its capabilities</strong>.
Let’s look at how to create an agent with some basic tools. As of this writing, the agent will automatically use the function calling API (if available), or a standard ReAct agent loop.`,ct,G,$t="LLMs that support a tools/functions API are relatively new, but they provide a powerful way to call tools by avoiding specific prompting and allowing the LLM to create tool calls based on provided schemas.",yt,v,Ft="ReAct agents are also good at complex reasoning tasks and can work with any LLM that has chat or text completion capabilities. They are more verbose, and show the reasoning behind certain actions that they take.",mt,Z,ut,W,Lt=`<strong>Agents are stateless by default</strong>, however, they can remember past interactions using a <code>Context</code> object.
This might be useful if you want to use an agent that needs to remember previous interactions, like a chatbot that maintains context across multiple messages or a task manager that needs to track progress over time.`,Mt,Q,wt,k,qt='You’ll notice that agents in <code>LlamaIndex</code> are async because they use Python’s <code>await</code> operator. If you are new to async code in Python, or need a refresher, they have an <a href="https://docs.llamaindex.ai/en/stable/getting_started/async_python/" rel="nofollow">excellent async guide</a>.',dt,V,Nt="Now we’ve gotten the basics, let’s take a look at how we can use more complex tools in our agents.",Jt,_,Tt,R,zt=`<strong>Agentic RAG is a powerful way to use agents to answer questions about your data.</strong> We can pass various tools to Alfred to help him answer questions.
However, instead of answering the question on top of documents automatically, Alfred can decide to use any other tool or flow to answer the question.`,ht,S,Pt='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/agentic-rag.png" alt="Agentic RAG"/>',bt,A,Dt=`It is easy to <strong>wrap <code>QueryEngine</code> as a tool</strong> for an agent.
When doing so, we need to <strong>define a name and description</strong>. The LLM will use this information to correctly use the tool.
Let’s see how to load in a <code>QueryEngineTool</code> using the <code>QueryEngine</code> we created in the <a href="components">component section</a>.`,gt,Y,Ut,H,ft,E,Kt="The <code>AgentWorkflow</code> class also directly supports multi-agent systems. By giving each agent a name and description, the system maintains a single active speaker, with each agent having the ability to hand off to another agent.",jt,X,Ot="By narrowing the scope of each agent, we can help increase their general accuracy when responding to user messages.",It,$,te="<strong>Agents in LlamaIndex can also directly be used as tools</strong> for other agents, for more complex and custom scenarios.",Bt,F,Ct,T,ee='<p>Haven’t learned enough yet? There is a lot more to discover about agents and tools in LlamaIndex within the <a href="https://docs.llamaindex.ai/en/stable/examples/agent/agent_workflow_basic/">AgentWorkflow Basic Introduction</a> or the <a href="https://docs.llamaindex.ai/en/stable/understanding/agent/">Agent Learning Guide</a>, where you can read more about streaming, context serialization, and human-in-the-loop!</p>',xt,L,ne="Now that we understand the basics of agents and tools in LlamaIndex, let’s see how we can use LlamaIndex to <strong>create configurable and manageable workflows!</strong>",Gt,q,vt,z,Zt;return h=new ye({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new Qt({props:{title:"Using Agents in LlamaIndex",local:"using-agents-in-llamaindex",headingTag:"h1"}}),C=new Qt({props:{title:"Initialising Agents",local:"initialising-agents",headingTag:"h2"}}),Z=new Wt({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5hZ2VudC53b3JrZmxvdyUyMGltcG9ydCUyMEFnZW50V29ya2Zsb3clMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS50b29scyUyMGltcG9ydCUyMEZ1bmN0aW9uVG9vbCUwQSUwQSUyMyUyMGRlZmluZSUyMHNhbXBsZSUyMFRvb2wlMjAtLSUyMHR5cGUlMjBhbm5vdGF0aW9ucyUyQyUyMGZ1bmN0aW9uJTIwbmFtZXMlMkMlMjBhbmQlMjBkb2NzdHJpbmdzJTJDJTIwYXJlJTIwYWxsJTIwaW5jbHVkZWQlMjBpbiUyMHBhcnNlZCUyMHNjaGVtYXMhJTBBZGVmJTIwbXVsdGlwbHkoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGxpZXMlMjB0d28lMjBpbnRlZ2VycyUyMGFuZCUyMHJldHVybnMlMjB0aGUlMjByZXN1bHRpbmclMjBpbnRlZ2VyJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBJTIzJTIwaW5pdGlhbGl6ZSUyMGxsbSUwQWxsbSUyMCUzRCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJKG1vZGVsX25hbWUlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBJTIzJTIwaW5pdGlhbGl6ZSUyMGFnZW50JTBBYWdlbnQlMjAlM0QlMjBBZ2VudFdvcmtmbG93LmZyb21fdG9vbHNfb3JfZnVuY3Rpb25zKCUwQSUyMCUyMCUyMCUyMCU1QkZ1bmN0aW9uVG9vbC5mcm9tX2RlZmF1bHRzKG11bHRpcGx5KSU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbSUzRGxsbSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI
<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> AgentWorkflow
<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool

<span class="hljs-comment"># define sample Tool -- type annotations, function names, and docstrings, are all included in parsed schemas!</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiplies two integers and returns the resulting integer&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-comment"># initialize llm</span>
llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

<span class="hljs-comment"># initialize agent</span>
agent = AgentWorkflow.from_tools_or_functions(
    [FunctionTool.from_defaults(multiply)],
    llm=llm
)`,wrap:!1}}),Q=new Wt({props:{code:"JTIzJTIwc3RhdGVsZXNzJTBBcmVzcG9uc2UlMjAlM0QlMjBhd2FpdCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjAyJTIwdGltZXMlMjAyJTNGJTIyKSUwQSUwQSUyMyUyMHJlbWVtYmVyaW5nJTIwc3RhdGUlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS53b3JrZmxvdyUyMGltcG9ydCUyMENvbnRleHQlMEElMEFjdHglMjAlM0QlMjBDb250ZXh0KGFnZW50KSUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBhZ2VudC5ydW4oJTIyTXklMjBuYW1lJTIwaXMlMjBCb2IuJTIyJTJDJTIwY3R4JTNEY3R4KSUwQXJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBhZ2VudC5ydW4oJTIyV2hhdCUyMHdhcyUyMG15JTIwbmFtZSUyMGFnYWluJTNGJTIyJTJDJTIwY3R4JTNEY3R4KQ==",highlighted:`<span class="hljs-comment"># stateless</span>
response = <span class="hljs-keyword">await</span> agent.run(<span class="hljs-string">&quot;What is 2 times 2?&quot;</span>)

<span class="hljs-comment"># remembering state</span>
<span class="hljs-keyword">from</span> llama_index.core.workflow <span class="hljs-keyword">import</span> Context

ctx = Context(agent)

response = <span class="hljs-keyword">await</span> agent.run(<span class="hljs-string">&quot;My name is Bob.&quot;</span>, ctx=ctx)
response = <span class="hljs-keyword">await</span> agent.run(<span class="hljs-string">&quot;What was my name again?&quot;</span>, ctx=ctx)`,wrap:!1}}),_=new Qt({props:{title:"Creating RAG Agents with QueryEngineTools",local:"creating-rag-agents-with-queryenginetools",headingTag:"h2"}}),Y=new Wt({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBRdWVyeUVuZ2luZVRvb2wlMEElMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBpbmRleC5hc19xdWVyeV9lbmdpbmUobGxtJTNEbGxtJTJDJTIwc2ltaWxhcml0eV90b3BfayUzRDMpJTIwJTIzJTIwYXMlMjBzaG93biUyMGluJTIwdGhlJTIwQ29tcG9uZW50cyUyMGluJTIwTGxhbWFJbmRleCUyMHNlY3Rpb24lMEElMEFxdWVyeV9lbmdpbmVfdG9vbCUyMCUzRCUyMFF1ZXJ5RW5naW5lVG9vbC5mcm9tX2RlZmF1bHRzKCUwQSUyMCUyMCUyMCUyMHF1ZXJ5X2VuZ2luZSUzRHF1ZXJ5X2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJuYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJhJTIwc3BlY2lmaWMlMjBkZXNjcmlwdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl9kaXJlY3QlM0RGYWxzZSUyQyUwQSklMEFxdWVyeV9lbmdpbmVfYWdlbnQlMjAlM0QlMjBBZ2VudFdvcmtmbG93LmZyb21fdG9vbHNfb3JfZnVuY3Rpb25zKCUwQSUyMCUyMCUyMCUyMCU1QnF1ZXJ5X2VuZ2luZV90b29sJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGxtJTNEbGxtJTJDJTBBJTIwJTIwJTIwJTIwc3lzdGVtX3Byb21wdCUzRCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50JTIwdGhhdCUyMGhhcyUyMGFjY2VzcyUyMHRvJTIwYSUyMGRhdGFiYXNlJTIwY29udGFpbmluZyUyMHBlcnNvbmElMjBkZXNjcmlwdGlvbnMuJTIwJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> QueryEngineTool

query_engine = index.as_query_engine(llm=llm, similarity_top_k=<span class="hljs-number">3</span>) <span class="hljs-comment"># as shown in the Components in LlamaIndex section</span>

query_engine_tool = QueryEngineTool.from_defaults(
    query_engine=query_engine,
    name=<span class="hljs-string">&quot;name&quot;</span>,
    description=<span class="hljs-string">&quot;a specific description&quot;</span>,
    return_direct=<span class="hljs-literal">False</span>,
)
query_engine_agent = AgentWorkflow.from_tools_or_functions(
    [query_engine_tool],
    llm=llm,
    system_prompt=<span class="hljs-string">&quot;You are a helpful assistant that has access to a database containing persona descriptions. &quot;</span>
)`,wrap:!1}}),H=new Qt({props:{title:"Creating Multi-agent systems",local:"creating-multi-agent-systems",headingTag:"h2"}}),F=new Wt({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.agent.workflow <span class="hljs-keyword">import</span> (
    AgentWorkflow,
    FunctionAgent,
    ReActAgent,
)

<span class="hljs-comment"># Define some tools</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a + b


<span class="hljs-keyword">def</span> <span class="hljs-title function_">subtract</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Subtract two numbers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a - b


<span class="hljs-comment"># Create agent configs</span>
<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> we can use FunctionAgent or ReActAgent here.</span>
<span class="hljs-comment"># FunctionAgent works for LLMs with a function calling API.</span>
<span class="hljs-comment"># ReActAgent works for any LLM.</span>
calculator_agent = ReActAgent(
    name=<span class="hljs-string">&quot;calculator&quot;</span>,
    description=<span class="hljs-string">&quot;Performs basic arithmetic operations&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;You are a calculator assistant. Use your tools for any math operation.&quot;</span>,
    tools=[add, subtract],
    llm=llm,
)

query_agent = ReActAgent(
    name=<span class="hljs-string">&quot;info_lookup&quot;</span>,
    description=<span class="hljs-string">&quot;Looks up information about XYZ&quot;</span>,
    system_prompt=<span class="hljs-string">&quot;Use your tool to query a RAG system to answer information about XYZ&quot;</span>,
    tools=[query_engine_tool],
    llm=llm
)

<span class="hljs-comment"># Create and run the workflow</span>
agent = AgentWorkflow(
    agents=[calculator_agent, query_agent], root_agent=<span class="hljs-string">&quot;calculator&quot;</span>
)

<span class="hljs-comment"># Run the system</span>
response = <span class="hljs-keyword">await</span> agent.run(user_msg=<span class="hljs-string">&quot;Can you add 5 and 3?&quot;</span>)`,wrap:!1}}),q=new me({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/agents.mdx"}}),{c(){w=o("meta"),D=s(),N=o("p"),K=s(),p(h.$$.fragment),O=s(),p(b.$$.fragment),tt=s(),g=o("p"),g.textContent=Vt,et=s(),U=o("p"),U.textContent=_t,nt=s(),f=o("blockquote"),f.innerHTML=Rt,lt=s(),j=o("p"),j.innerHTML=St,st=s(),I=o("p"),I.innerHTML=At,at=s(),B=o("ol"),B.innerHTML=Yt,ot=s(),d=o("blockquote"),d.innerHTML=Ht,it=s(),p(C.$$.fragment),rt=s(),J=o("blockquote"),J.innerHTML=Et,pt=s(),x=o("p"),x.innerHTML=Xt,ct=s(),G=o("p"),G.textContent=$t,yt=s(),v=o("p"),v.textContent=Ft,mt=s(),p(Z.$$.fragment),ut=s(),W=o("p"),W.innerHTML=Lt,Mt=s(),p(Q.$$.fragment),wt=s(),k=o("p"),k.innerHTML=qt,dt=s(),V=o("p"),V.textContent=Nt,Jt=s(),p(_.$$.fragment),Tt=s(),R=o("p"),R.innerHTML=zt,ht=s(),S=o("p"),S.innerHTML=Pt,bt=s(),A=o("p"),A.innerHTML=Dt,gt=s(),p(Y.$$.fragment),Ut=s(),p(H.$$.fragment),ft=s(),E=o("p"),E.innerHTML=Kt,jt=s(),X=o("p"),X.textContent=Ot,It=s(),$=o("p"),$.innerHTML=te,Bt=s(),p(F.$$.fragment),Ct=s(),T=o("blockquote"),T.innerHTML=ee,xt=s(),L=o("p"),L.innerHTML=ne,Gt=s(),p(q.$$.fragment),vt=s(),z=o("p"),this.h()},l(t){const e=pe("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(n),D=a(t),N=i(t,"P",{}),le(N).forEach(n),K=a(t),c(h.$$.fragment,t),O=a(t),c(b.$$.fragment,t),tt=a(t),g=i(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-k20nvn"&&(g.textContent=Vt),et=a(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1hjwxub"&&(U.textContent=_t),nt=a(t),f=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(f)!=="svelte-15o6tbi"&&(f.innerHTML=Rt),lt=a(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1i02awx"&&(j.innerHTML=St),st=a(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-14dee9q"&&(I.innerHTML=At),at=a(t),B=i(t,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-1bz4j87"&&(B.innerHTML=Yt),ot=a(t),d=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(d)!=="svelte-1n8lcg8"&&(d.innerHTML=Ht),it=a(t),c(C.$$.fragment,t),rt=a(t),J=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-iskmgm"&&(J.innerHTML=Et),pt=a(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1k9r5ws"&&(x.innerHTML=Xt),ct=a(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-gafhou"&&(G.textContent=$t),yt=a(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-dm7947"&&(v.textContent=Ft),mt=a(t),c(Z.$$.fragment,t),ut=a(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1hbrpvb"&&(W.innerHTML=Lt),Mt=a(t),c(Q.$$.fragment,t),wt=a(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-18kp6fu"&&(k.innerHTML=qt),dt=a(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-epz1ho"&&(V.textContent=Nt),Jt=a(t),c(_.$$.fragment,t),Tt=a(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-cdj536"&&(R.innerHTML=zt),ht=a(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1srircl"&&(S.innerHTML=Pt),bt=a(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-sogywd"&&(A.innerHTML=Dt),gt=a(t),c(Y.$$.fragment,t),Ut=a(t),c(H.$$.fragment,t),ft=a(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-pnrrlw"&&(E.innerHTML=Kt),jt=a(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1lnlpu9"&&(X.textContent=Ot),It=a(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-19na4nh"&&($.innerHTML=te),Bt=a(t),c(F.$$.fragment,t),Ct=a(t),T=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-5bjjvw"&&(T.innerHTML=ee),xt=a(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1synfbm"&&(L.innerHTML=ne),Gt=a(t),c(q.$$.fragment,t),vt=a(t),z=i(t,"P",{}),le(z).forEach(n),this.h()},h(){P(w,"name","hf:doc:metadata"),P(w,"content",Me),P(d,"class","tip"),P(J,"class","tip"),P(T,"class","tip")},m(t,e){ce(document.head,w),l(t,D,e),l(t,N,e),l(t,K,e),y(h,t,e),l(t,O,e),y(b,t,e),l(t,tt,e),l(t,g,e),l(t,et,e),l(t,U,e),l(t,nt,e),l(t,f,e),l(t,lt,e),l(t,j,e),l(t,st,e),l(t,I,e),l(t,at,e),l(t,B,e),l(t,ot,e),l(t,d,e),l(t,it,e),y(C,t,e),l(t,rt,e),l(t,J,e),l(t,pt,e),l(t,x,e),l(t,ct,e),l(t,G,e),l(t,yt,e),l(t,v,e),l(t,mt,e),y(Z,t,e),l(t,ut,e),l(t,W,e),l(t,Mt,e),y(Q,t,e),l(t,wt,e),l(t,k,e),l(t,dt,e),l(t,V,e),l(t,Jt,e),y(_,t,e),l(t,Tt,e),l(t,R,e),l(t,ht,e),l(t,S,e),l(t,bt,e),l(t,A,e),l(t,gt,e),y(Y,t,e),l(t,Ut,e),y(H,t,e),l(t,ft,e),l(t,E,e),l(t,jt,e),l(t,X,e),l(t,It,e),l(t,$,e),l(t,Bt,e),y(F,t,e),l(t,Ct,e),l(t,T,e),l(t,xt,e),l(t,L,e),l(t,Gt,e),y(q,t,e),l(t,vt,e),l(t,z,e),Zt=!0},p:ae,i(t){Zt||(m(h.$$.fragment,t),m(b.$$.fragment,t),m(C.$$.fragment,t),m(Z.$$.fragment,t),m(Q.$$.fragment,t),m(_.$$.fragment,t),m(Y.$$.fragment,t),m(H.$$.fragment,t),m(F.$$.fragment,t),m(q.$$.fragment,t),Zt=!0)},o(t){u(h.$$.fragment,t),u(b.$$.fragment,t),u(C.$$.fragment,t),u(Z.$$.fragment,t),u(Q.$$.fragment,t),u(_.$$.fragment,t),u(Y.$$.fragment,t),u(H.$$.fragment,t),u(F.$$.fragment,t),u(q.$$.fragment,t),Zt=!1},d(t){t&&(n(D),n(N),n(K),n(O),n(tt),n(g),n(et),n(U),n(nt),n(f),n(lt),n(j),n(st),n(I),n(at),n(B),n(ot),n(d),n(it),n(rt),n(J),n(pt),n(x),n(ct),n(G),n(yt),n(v),n(mt),n(ut),n(W),n(Mt),n(wt),n(k),n(dt),n(V),n(Jt),n(Tt),n(R),n(ht),n(S),n(bt),n(A),n(gt),n(Ut),n(ft),n(E),n(jt),n(X),n(It),n($),n(Bt),n(Ct),n(T),n(xt),n(L),n(Gt),n(vt),n(z)),n(w),M(h,t),M(b,t),M(C,t),M(Z,t),M(Q,t),M(_,t),M(Y,t),M(H,t),M(F,t),M(q,t)}}}const Me='{"title":"Using Agents in LlamaIndex","local":"using-agents-in-llamaindex","sections":[{"title":"Initialising Agents","local":"initialising-agents","sections":[],"depth":2},{"title":"Creating RAG Agents with QueryEngineTools","local":"creating-rag-agents-with-queryenginetools","sections":[],"depth":2},{"title":"Creating Multi-agent systems","local":"creating-multi-agent-systems","sections":[],"depth":2}],"depth":1}';function we(kt){return oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends ie{constructor(w){super(),re(this,w,we,ue,se,{})}}export{Ue as component};
