import{s as An,n as qn,o as Fn}from"../chunks/scheduler.505acc25.js";import{S as Nn,i as Qn,e as i,s as a,c as m,h as Pn,a as o,d as n,b as s,f as Yt,g as d,j as r,k as Z,l as y,m as l,n as u,t as c,o as p,p as h}from"../chunks/index.fbb49fb4.js";import{C as zn}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as M}from"../chunks/CodeBlock.7f0851b7.js";import{H as Le}from"../chunks/Heading.511e0027.js";import{E as On}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function Dn(zt){let g,Ee,We,Ve,j,He,C,Be,I,Ot=`Remember Alfred, our helpful butler agent from Unit 1?
To assist us effectively, Alfred needs to understand our requests and <strong>prepare, find and use relevant information to help complete tasks.</strong>
This is where LlamaIndex’s components come in.`,Re,k,Dt=`While LlamaIndex has many components, <strong>we’ll focus specifically on the <code>QueryEngine</code> component.</strong>
Why? Because it can be used as a Retrieval-Augmented Generation (RAG) tool for an agent.`,Xe,_,Kt=`So, what is RAG? LLMs are trained on enormous bodies of data to learn general knowledge.
However, they may not be trained on relevant and up-to-date data.
RAG solves this problem by finding and retrieving relevant information from your data and giving that to the LLM.`,Se,$,en='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/rag.png" alt="RAG"/>',Ye,W,tn="Now, think about how Alfred works:",Ae,G,nn="<li>You ask Alfred to help plan a dinner party</li> <li>Alfred needs to check your calendar, dietary preferences, and past successful menus</li> <li>The <code>QueryEngine</code> helps Alfred find this information and use it to plan the dinner party</li>",qe,E,ln=`This makes the <code>QueryEngine</code> <strong>a key component for building agentic RAG workflows</strong> in LlamaIndex.
Just as Alfred needs to search through your household information to be helpful, any agent needs a way to find and understand relevant data.
The <code>QueryEngine</code> provides exactly this capability.`,Fe,V,an="Now, let’s dive a bit deeper into the components and see how you can <strong>combine components to create a RAG pipeline.</strong>",Ne,H,Qe,v,sn='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/components.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',Pe,B,on="There are five key stages within RAG, which in turn will be a part of most larger applications you build. These are:",ze,R,rn="<li><strong>Loading</strong>: this refers to getting your data from where it lives — whether it’s text files, PDFs, another website, a database, or an API — into your workflow. LlamaHub provides hundreds of integrations to choose from.</li> <li><strong>Indexing</strong>: this means creating a data structure that allows for querying the data. For LLMs, this nearly always means creating vector embeddings. Which are numerical representations of the meaning of the data. Indexing can also refer to numerous other metadata strategies to make it easy to accurately find contextually relevant data based on properties.</li> <li><strong>Storing</strong>: once your data is indexed you will want to store your index, as well as other metadata, to avoid having to re-index it.</li> <li><strong>Querying</strong>: for any given indexing strategy there are many ways you can utilize LLMs and LlamaIndex data structures to query, including sub-queries, multi-step queries and hybrid strategies.</li> <li><strong>Evaluation</strong>: a critical step in any flow is checking how effective it is relative to other strategies, or when you make changes. Evaluation provides objective measures of how accurate, faithful and fast your responses to queries are.</li>",Oe,X,mn="Next, let’s see how we can reproduce these stages using components.",De,S,Ke,Y,dn=`As mentioned before, LlamaIndex can work on top of your own data, however, <strong>before accessing data, we need to load it.</strong>
There are three main ways to load data into LlamaIndex:`,et,A,un="<li><code>SimpleDirectoryReader</code>: A built-in loader for various file types from a local directory.</li> <li><code>LlamaParse</code>: LlamaParse, LlamaIndex’s official tool for PDF parsing, available as a managed API.</li> <li><code>LlamaHub</code>: A registry of hundreds of data-loading libraries to ingest data from any source.</li>",tt,T,cn='<p>Get familiar with <a href="https://docs.llamaindex.ai/en/stable/module_guides/loading/connector/">LlamaHub</a> loaders and <a href="https://github.com/run-llama/llama_cloud_services/blob/main/parse.md">LlamaParse</a> parser for more complex data sources.</p>',nt,q,pn=`<strong>The simplest way to load data is with <code>SimpleDirectoryReader</code>.</strong>
This versatile component can load various file types from a folder and convert them into <code>Document</code> objects that LlamaIndex can work with.
Let’s see how we can use <code>SimpleDirectoryReader</code> to load data from a folder.`,lt,F,at,N,hn=`After loading our documents, we need to break them into smaller pieces called <code>Node</code> objects.
A <code>Node</code> is just a chunk of text from the original document that’s easier for the AI to work with, while it still has references to the original <code>Document</code> object.`,st,Q,fn="The <code>IngestionPipeline</code> helps us create these nodes through two key transformations.",it,P,yn="<li><code>SentenceSplitter</code> breaks down documents into manageable chunks by splitting them at natural sentence boundaries.</li> <li><code>HuggingFaceEmbedding</code> converts each chunk into numerical embeddings - vector representations that capture the semantic meaning in a way AI can process efficiently.</li>",ot,z,bn="This process helps us organise our documents in a way that’s more useful for searching and analysis.",rt,O,mt,D,dt,K,wn="After creating our <code>Node</code> objects we need to index them to make them searchable, but before we can do that, we need a place to store our data.",ut,ee,gn=`Since we are using an ingestion pipeline, we can directly attach a vector store to the pipeline to populate it.
In this case, we will use <code>Chroma</code> to store our documents.`,ct,b,Ze,Mn="Install ChromaDB",At,je,vn='As introduced in the <a href="./llama-hub">section on the LlamaHub</a>, we can install the ChromaDB vector store with the following command:',qt,te,pt,ne,ht,x,Tn='<p>An overview of the different vector stores can be found in the <a href="https://docs.llamaindex.ai/en/stable/module_guides/storing/vector_stores/">LlamaIndex documentation</a>.</p>',ft,le,xn=`This is where vector embeddings come in - by embedding both the query and nodes in the same vector space, we can find relevant matches.
The <code>VectorStoreIndex</code> handles this for us, using the same embedding model we used during ingestion to ensure consistency.`,yt,ae,Jn="Let’s see how to create this index from our vector store and embeddings:",bt,se,wt,ie,Un="All information is automatically persisted within the <code>ChromaVectorStore</code> object and the passed directory path.",gt,oe,Ln="Great! Now that we can save and load our index easily, let’s explore how to query it in different ways.",Mt,re,vt,me,Zn="Before we can query our index, we need to convert it to a query interface. The most common conversion options are:",Tt,de,jn="<li><code>as_retriever</code>: For basic document retrieval, returning a list of <code>NodeWithScore</code> objects with similarity scores</li> <li><code>as_query_engine</code>: For single question-answer interactions, returning a written response</li> <li><code>as_chat_engine</code>: For conversational interactions that maintain memory across multiple messages, returning a written response using chat history and indexed context</li>",xt,ue,Cn=`We’ll focus on the query engine since it is more common for agent-like interactions.
We also pass in an LLM to the query engine to use for the response.`,Jt,ce,Ut,pe,Lt,he,In=`Under the hood, the query engine doesn’t only use the LLM to answer the question but also uses a <code>ResponseSynthesizer</code> as a strategy to process the response.
Once again, this is fully customisable but there are three main strategies that work well out of the box:`,Zt,fe,kn="<li><code>refine</code>: create and refine an answer by sequentially going through each retrieved text chunk. This makes a separate LLM call per Node/retrieved chunk.</li> <li><code>compact</code> (default): similar to refining but concatenating the chunks beforehand, resulting in fewer LLM calls.</li> <li><code>tree_summarize</code>: create a detailed answer by going through each retrieved text chunk and creating a tree structure of the answer.</li>",jt,J,_n='<p>Take fine-grained control of your query workflows with the <a href="https://docs.llamaindex.ai/en/stable/module_guides/deploying/query_engine/usage_pattern/#low-level-composition-api">low-level composition API</a>. This API lets you customize and fine-tune every step of the query process to match your exact needs, which also pairs great with <a href="https://docs.llamaindex.ai/en/stable/module_guides/workflow/">Workflows</a></p>',Ct,ye,$n="The language model won’t always perform in predictable ways, so we can’t be sure that the answer we get is always correct. We can deal with this by <strong>evaluating the quality of the answer</strong>.",It,be,kt,we,Wn=`LlamaIndex provides <strong>built-in evaluation tools to assess response quality.</strong>
These evaluators leverage LLMs to analyze responses across different dimensions.
Let’s look at the three main evaluators available:`,_t,ge,Gn="<li><code>FaithfulnessEvaluator</code>: Evaluates the faithfulness of the answer by checking if the answer is supported by the context.</li> <li><code>AnswerRelevancyEvaluator</code>: Evaluate the relevance of the answer by checking if the answer is relevant to the question.</li> <li><code>CorrectnessEvaluator</code>: Evaluate the correctness of the answer by checking if the answer is correct.</li>",$t,U,En='<p>Want to learn more about agent observability and evaluation? Continue your journey with the <a href="https://huggingface.co/learn/agents-course/bonus-unit2/introduction">Bonus Unit 2</a>.</p>',Wt,Me,Gt,ve,Vn=`Even without direct evaluation, we can <strong>gain insights into how our system is performing through observability.</strong>
This is especially useful when we are building more complex workflows and want to understand how each component is performing.`,Et,f,Ce,Hn="Install LlamaTrace",Ft,Ie,Bn='As introduced in the <a href="./llama-hub">section on the LlamaHub</a>, we can install the LlamaTrace callback from Arize Phoenix with the following command:',Nt,Te,Qt,ke,Rn="Additionally, we need to set the <code>PHOENIX_API_KEY</code> environment variable to our LlamaTrace API key. We can get this by:",Pt,_e,Xn='<li>Creating an account at <a href="https://llamatrace.com/login" rel="nofollow">LlamaTrace</a></li> <li>Generating an API key in your account settings</li> <li>Using the API key in the code below to enable tracing</li>',Vt,xe,Ht,L,Sn='<p>Want to learn more about components and how to use them? Continue your journey with the <a href="https://docs.llamaindex.ai/en/stable/module_guides/">Components Guides</a> or the <a href="https://docs.llamaindex.ai/en/stable/understanding/rag/">Guide on RAG</a>.</p>',Bt,Je,Yn="We have seen how to use components to create a <code>QueryEngine</code>. Now, let’s see how we can <strong>use the <code>QueryEngine</code> as a tool for an agent!</strong>",Rt,Ue,Xt,Ge,St;return j=new zn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new Le({props:{title:"What are components in LlamaIndex?",local:"what-are-components-in-llamaindex",headingTag:"h1"}}),H=new Le({props:{title:"Creating a RAG pipeline using components",local:"creating-a-rag-pipeline-using-components",headingTag:"h2"}}),S=new Le({props:{title:"Loading and embedding documents",local:"loading-and-embedding-documents",headingTag:"h3"}}),F=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIlMEElMEFyZWFkZXIlMjAlM0QlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIoaW5wdXRfZGlyJTNEJTIycGF0aCUyRnRvJTJGZGlyZWN0b3J5JTIyKSUwQWRvY3VtZW50cyUyMCUzRCUyMHJlYWRlci5sb2FkX2RhdGEoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> SimpleDirectoryReader

reader = SimpleDirectoryReader(input_dir=<span class="hljs-string">&quot;path/to/directory&quot;</span>)
documents = reader.load_data()`,wrap:!1}}),O=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBEb2N1bWVudCUwQWZyb20lMjBsbGFtYV9pbmRleC5lbWJlZGRpbmdzLmh1Z2dpbmdmYWNlJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmclMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5ub2RlX3BhcnNlciUyMGltcG9ydCUyMFNlbnRlbmNlU3BsaXR0ZXIlMEFmcm9tJTIwbGxhbWFfaW5kZXguY29yZS5pbmdlc3Rpb24lMjBpbXBvcnQlMjBJbmdlc3Rpb25QaXBlbGluZSUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMHBpcGVsaW5lJTIwd2l0aCUyMHRyYW5zZm9ybWF0aW9ucyUwQXBpcGVsaW5lJTIwJTNEJTIwSW5nZXN0aW9uUGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtYXRpb25zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2VudGVuY2VTcGxpdHRlcihjaHVua19vdmVybGFwJTNEMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyhtb2RlbF9uYW1lJTNEJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEElMEFub2RlcyUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUuYXJ1bihkb2N1bWVudHMlM0QlNUJEb2N1bWVudC5leGFtcGxlKCklNUQp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.core.node_parser <span class="hljs-keyword">import</span> SentenceSplitter
<span class="hljs-keyword">from</span> llama_index.core.ingestion <span class="hljs-keyword">import</span> IngestionPipeline

<span class="hljs-comment"># create the pipeline with transformations</span>
pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ]
)

nodes = <span class="hljs-keyword">await</span> pipeline.arun(documents=[Document.example()])`,wrap:!1}}),D=new Le({props:{title:"Storing and indexing documents",local:"storing-and-indexing-documents",headingTag:"h3"}}),te=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXZlY3Rvci1zdG9yZXMtY2hyb21h",highlighted:"pip install llama-index-vector-stores-chroma",wrap:!1}}),ne=new M({props:{code:"aW1wb3J0JTIwY2hyb21hZGIlMEFmcm9tJTIwbGxhbWFfaW5kZXgudmVjdG9yX3N0b3Jlcy5jaHJvbWElMjBpbXBvcnQlMjBDaHJvbWFWZWN0b3JTdG9yZSUwQSUwQWRiJTIwJTNEJTIwY2hyb21hZGIuUGVyc2lzdGVudENsaWVudChwYXRoJTNEJTIyLiUyRmFsZnJlZF9jaHJvbWFfZGIlMjIpJTBBY2hyb21hX2NvbGxlY3Rpb24lMjAlM0QlMjBkYi5nZXRfb3JfY3JlYXRlX2NvbGxlY3Rpb24oJTIyYWxmcmVkJTIyKSUwQXZlY3Rvcl9zdG9yZSUyMCUzRCUyMENocm9tYVZlY3RvclN0b3JlKGNocm9tYV9jb2xsZWN0aW9uJTNEY2hyb21hX2NvbGxlY3Rpb24pJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBJbmdlc3Rpb25QaXBlbGluZSglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1hdGlvbnMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZW50ZW5jZVNwbGl0dGVyKGNodW5rX3NpemUlM0QyNSUyQyUyMGNodW5rX292ZXJsYXAlM0QwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwdmVjdG9yX3N0b3JlJTNEdmVjdG9yX3N0b3JlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> chromadb
<span class="hljs-keyword">from</span> llama_index.vector_stores.chroma <span class="hljs-keyword">import</span> ChromaVectorStore

db = chromadb.PersistentClient(path=<span class="hljs-string">&quot;./alfred_chroma_db&quot;</span>)
chroma_collection = db.get_or_create_collection(<span class="hljs-string">&quot;alfred&quot;</span>)
vector_store = ChromaVectorStore(chroma_collection=chroma_collection)

pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_size=<span class="hljs-number">25</span>, chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ],
    vector_store=vector_store,
)`,wrap:!1}}),se=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZyUwQSUwQWVtYmVkX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmcobW9kZWxfbmFtZSUzRCUyMkJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSUyMiklMEFpbmRleCUyMCUzRCUyMFZlY3RvclN0b3JlSW5kZXguZnJvbV92ZWN0b3Jfc3RvcmUodmVjdG9yX3N0b3JlJTJDJTIwZW1iZWRfbW9kZWwlM0RlbWJlZF9tb2RlbCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding

embed_model = HuggingFaceEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
index = VectorStoreIndex.from_vector_store(vector_store, embed_model=embed_model)`,wrap:!1}}),re=new Le({props:{title:"Querying a VectorStoreIndex with prompts and LLMs",local:"querying-a-vectorstoreindex-with-prompts-and-llms",headingTag:"h3"}}),ce=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEFsbG0lMjAlM0QlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSShtb2RlbF9uYW1lJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMGluZGV4LmFzX3F1ZXJ5X2VuZ2luZSglMEElMjAlMjAlMjAlMjBsbG0lM0RsbG0lMkMlMEElMjAlMjAlMjAlMjByZXNwb25zZV9tb2RlJTNEJTIydHJlZV9zdW1tYXJpemUlMjIlMkMlMEEpJTBBcXVlcnlfZW5naW5lLnF1ZXJ5KCUyMldoYXQlMjBpcyUyMHRoZSUyMG1lYW5pbmclMjBvZiUyMGxpZmUlM0YlMjIpJTBBJTIzJTIwVGhlJTIwbWVhbmluZyUyMG9mJTIwbGlmZSUyMGlzJTIwNDI=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
query_engine = index.as_query_engine(
    llm=llm,
    response_mode=<span class="hljs-string">&quot;tree_summarize&quot;</span>,
)
query_engine.query(<span class="hljs-string">&quot;What is the meaning of life?&quot;</span>)
<span class="hljs-comment"># The meaning of life is 42</span>`,wrap:!1}}),pe=new Le({props:{title:"Response Processing",local:"response-processing",headingTag:"h3"}}),be=new Le({props:{title:"Evaluation and observability",local:"evaluation-and-observability",headingTag:"h3"}}),Me=new M({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuZXZhbHVhdGlvbiUyMGltcG9ydCUyMEZhaXRoZnVsbmVzc0V2YWx1YXRvciUwQSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMCUyMyUyMGZyb20lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEFsbG0lMjAlM0QlMjAlMjMlMjBmcm9tJTIwdGhlJTIwcHJldmlvdXMlMjBzZWN0aW9uJTBBJTBBJTIzJTIwcXVlcnklMjBpbmRleCUwQWV2YWx1YXRvciUyMCUzRCUyMEZhaXRoZnVsbmVzc0V2YWx1YXRvcihsbG0lM0RsbG0pJTBBcmVzcG9uc2UlMjAlM0QlMjBxdWVyeV9lbmdpbmUucXVlcnkoJTBBJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGJhdHRsZXMlMjB0b29rJTIwcGxhY2UlMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwaW4lMjB0aGUlMjBBbWVyaWNhbiUyMFJldm9sdXRpb24lM0YlMjIlMEEpJTBBZXZhbF9yZXN1bHQlMjAlM0QlMjBldmFsdWF0b3IuZXZhbHVhdGVfcmVzcG9uc2UocmVzcG9uc2UlM0RyZXNwb25zZSklMEFldmFsX3Jlc3VsdC5wYXNzaW5n",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.evaluation <span class="hljs-keyword">import</span> FaithfulnessEvaluator

query_engine = <span class="hljs-comment"># from the previous section</span>
llm = <span class="hljs-comment"># from the previous section</span>

<span class="hljs-comment"># query index</span>
evaluator = FaithfulnessEvaluator(llm=llm)
response = query_engine.query(
    <span class="hljs-string">&quot;What battles took place in New York City in the American Revolution?&quot;</span>
)
eval_result = evaluator.evaluate_response(response=response)
eval_result.passing`,wrap:!1}}),Te=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwbGxhbWEtaW5kZXgtY2FsbGJhY2tzLWFyaXplLXBob2VuaXg=",highlighted:"pip install -U llama-index-callbacks-arize-phoenix",wrap:!1}}),xe=new M({props:{code:"aW1wb3J0JTIwbGxhbWFfaW5kZXglMEFpbXBvcnQlMjBvcyUwQSUwQVBIT0VOSVhfQVBJX0tFWSUyMCUzRCUyMCUyMiUzQ1BIT0VOSVhfQVBJX0tFWSUzRSUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJhcGlfa2V5JTNEJTdCUEhPRU5JWF9BUElfS0VZJTdEJTIyJTBBbGxhbWFfaW5kZXguY29yZS5zZXRfZ2xvYmFsX2hhbmRsZXIoJTBBJTIwJTIwJTIwJTIwJTIyYXJpemVfcGhvZW5peCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZsbGFtYXRyYWNlLmNvbSUyRnYxJTJGdHJhY2VzJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> llama_index
<span class="hljs-keyword">import</span> os

PHOENIX_API_KEY = <span class="hljs-string">&quot;&lt;PHOENIX_API_KEY&gt;&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;api_key=<span class="hljs-subst">{PHOENIX_API_KEY}</span>&quot;</span>
llama_index.core.set_global_handler(
    <span class="hljs-string">&quot;arize_phoenix&quot;</span>,
    endpoint=<span class="hljs-string">&quot;https://llamatrace.com/v1/traces&quot;</span>
)`,wrap:!1}}),Ue=new On({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/components.mdx"}}),{c(){g=i("meta"),Ee=a(),We=i("p"),Ve=a(),m(j.$$.fragment),He=a(),m(C.$$.fragment),Be=a(),I=i("p"),I.innerHTML=Ot,Re=a(),k=i("p"),k.innerHTML=Dt,Xe=a(),_=i("p"),_.textContent=Kt,Se=a(),$=i("p"),$.innerHTML=en,Ye=a(),W=i("p"),W.textContent=tn,Ae=a(),G=i("ol"),G.innerHTML=nn,qe=a(),E=i("p"),E.innerHTML=ln,Fe=a(),V=i("p"),V.innerHTML=an,Ne=a(),m(H.$$.fragment),Qe=a(),v=i("blockquote"),v.innerHTML=sn,Pe=a(),B=i("p"),B.textContent=on,ze=a(),R=i("ol"),R.innerHTML=rn,Oe=a(),X=i("p"),X.textContent=mn,De=a(),m(S.$$.fragment),Ke=a(),Y=i("p"),Y.innerHTML=dn,et=a(),A=i("ol"),A.innerHTML=un,tt=a(),T=i("blockquote"),T.innerHTML=cn,nt=a(),q=i("p"),q.innerHTML=pn,lt=a(),m(F.$$.fragment),at=a(),N=i("p"),N.innerHTML=hn,st=a(),Q=i("p"),Q.innerHTML=fn,it=a(),P=i("ol"),P.innerHTML=yn,ot=a(),z=i("p"),z.textContent=bn,rt=a(),m(O.$$.fragment),mt=a(),m(D.$$.fragment),dt=a(),K=i("p"),K.innerHTML=wn,ut=a(),ee=i("p"),ee.innerHTML=gn,ct=a(),b=i("details"),Ze=i("summary"),Ze.textContent=Mn,At=a(),je=i("p"),je.innerHTML=vn,qt=a(),m(te.$$.fragment),pt=a(),m(ne.$$.fragment),ht=a(),x=i("blockquote"),x.innerHTML=Tn,ft=a(),le=i("p"),le.innerHTML=xn,yt=a(),ae=i("p"),ae.textContent=Jn,bt=a(),m(se.$$.fragment),wt=a(),ie=i("p"),ie.innerHTML=Un,gt=a(),oe=i("p"),oe.textContent=Ln,Mt=a(),m(re.$$.fragment),vt=a(),me=i("p"),me.textContent=Zn,Tt=a(),de=i("ul"),de.innerHTML=jn,xt=a(),ue=i("p"),ue.textContent=Cn,Jt=a(),m(ce.$$.fragment),Ut=a(),m(pe.$$.fragment),Lt=a(),he=i("p"),he.innerHTML=In,Zt=a(),fe=i("ul"),fe.innerHTML=kn,jt=a(),J=i("blockquote"),J.innerHTML=_n,Ct=a(),ye=i("p"),ye.innerHTML=$n,It=a(),m(be.$$.fragment),kt=a(),we=i("p"),we.innerHTML=Wn,_t=a(),ge=i("ul"),ge.innerHTML=Gn,$t=a(),U=i("blockquote"),U.innerHTML=En,Wt=a(),m(Me.$$.fragment),Gt=a(),ve=i("p"),ve.innerHTML=Vn,Et=a(),f=i("details"),Ce=i("summary"),Ce.textContent=Hn,Ft=a(),Ie=i("p"),Ie.innerHTML=Bn,Nt=a(),m(Te.$$.fragment),Qt=a(),ke=i("p"),ke.innerHTML=Rn,Pt=a(),_e=i("ul"),_e.innerHTML=Xn,Vt=a(),m(xe.$$.fragment),Ht=a(),L=i("blockquote"),L.innerHTML=Sn,Bt=a(),Je=i("p"),Je.innerHTML=Yn,Rt=a(),m(Ue.$$.fragment),Xt=a(),Ge=i("p"),this.h()},l(e){const t=Pn("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(n),Ee=s(e),We=o(e,"P",{}),Yt(We).forEach(n),Ve=s(e),d(j.$$.fragment,e),He=s(e),d(C.$$.fragment,e),Be=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1vh4okn"&&(I.innerHTML=Ot),Re=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-35rbyv"&&(k.innerHTML=Dt),Xe=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1dt1sd0"&&(_.textContent=Kt),Se=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-kysd50"&&($.innerHTML=en),Ye=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-aqkixd"&&(W.textContent=tn),Ae=s(e),G=o(e,"OL",{"data-svelte-h":!0}),r(G)!=="svelte-135qvuu"&&(G.innerHTML=nn),qe=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-mnkj36"&&(E.innerHTML=ln),Fe=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-ga98sq"&&(V.innerHTML=an),Ne=s(e),d(H.$$.fragment,e),Qe=s(e),v=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1xg39e4"&&(v.innerHTML=sn),Pe=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-bhgae9"&&(B.textContent=on),ze=s(e),R=o(e,"OL",{"data-svelte-h":!0}),r(R)!=="svelte-1y6wwuy"&&(R.innerHTML=rn),Oe=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-12zc4us"&&(X.textContent=mn),De=s(e),d(S.$$.fragment,e),Ke=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1246hsd"&&(Y.innerHTML=dn),et=s(e),A=o(e,"OL",{"data-svelte-h":!0}),r(A)!=="svelte-iz7p8h"&&(A.innerHTML=un),tt=s(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1v11qmv"&&(T.innerHTML=cn),nt=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1c6elju"&&(q.innerHTML=pn),lt=s(e),d(F.$$.fragment,e),at=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-4bo0to"&&(N.innerHTML=hn),st=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1uspfck"&&(Q.innerHTML=fn),it=s(e),P=o(e,"OL",{"data-svelte-h":!0}),r(P)!=="svelte-1slr2bx"&&(P.innerHTML=yn),ot=s(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-7ysnum"&&(z.textContent=bn),rt=s(e),d(O.$$.fragment,e),mt=s(e),d(D.$$.fragment,e),dt=s(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1symqva"&&(K.innerHTML=wn),ut=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1j1sj1y"&&(ee.innerHTML=gn),ct=s(e),b=o(e,"DETAILS",{});var $e=Yt(b);Ze=o($e,"SUMMARY",{"data-svelte-h":!0}),r(Ze)!=="svelte-187ducf"&&(Ze.textContent=Mn),At=s($e),je=o($e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-z0lktq"&&(je.innerHTML=vn),qt=s($e),d(te.$$.fragment,$e),$e.forEach(n),pt=s(e),d(ne.$$.fragment,e),ht=s(e),x=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-18frj1l"&&(x.innerHTML=Tn),ft=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-axr536"&&(le.innerHTML=xn),yt=s(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-s47gic"&&(ae.textContent=Jn),bt=s(e),d(se.$$.fragment,e),wt=s(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-54vaw7"&&(ie.innerHTML=Un),gt=s(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1j63axa"&&(oe.textContent=Ln),Mt=s(e),d(re.$$.fragment,e),vt=s(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-18ur37c"&&(me.textContent=Zn),Tt=s(e),de=o(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-d9r342"&&(de.innerHTML=jn),xt=s(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-rqskw5"&&(ue.textContent=Cn),Jt=s(e),d(ce.$$.fragment,e),Ut=s(e),d(pe.$$.fragment,e),Lt=s(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1j4gc2q"&&(he.innerHTML=In),Zt=s(e),fe=o(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-3mam70"&&(fe.innerHTML=kn),jt=s(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-13ris5q"&&(J.innerHTML=_n),Ct=s(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-16j3xwr"&&(ye.innerHTML=$n),It=s(e),d(be.$$.fragment,e),kt=s(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1m4sp8c"&&(we.innerHTML=Wn),_t=s(e),ge=o(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-252wdz"&&(ge.innerHTML=Gn),$t=s(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-1c9z98q"&&(U.innerHTML=En),Wt=s(e),d(Me.$$.fragment,e),Gt=s(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-f2lt8l"&&(ve.innerHTML=Vn),Et=s(e),f=o(e,"DETAILS",{});var w=Yt(f);Ce=o(w,"SUMMARY",{"data-svelte-h":!0}),r(Ce)!=="svelte-1csrw0t"&&(Ce.textContent=Hn),Ft=s(w),Ie=o(w,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-ho52mp"&&(Ie.innerHTML=Bn),Nt=s(w),d(Te.$$.fragment,w),Qt=s(w),ke=o(w,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-2gef6z"&&(ke.innerHTML=Rn),Pt=s(w),_e=o(w,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-13n4s9w"&&(_e.innerHTML=Xn),w.forEach(n),Vt=s(e),d(xe.$$.fragment,e),Ht=s(e),L=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-a1et1y"&&(L.innerHTML=Sn),Bt=s(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-13rfypl"&&(Je.innerHTML=Yn),Rt=s(e),d(Ue.$$.fragment,e),Xt=s(e),Ge=o(e,"P",{}),Yt(Ge).forEach(n),this.h()},h(){Z(g,"name","hf:doc:metadata"),Z(g,"content",Kn),Z(v,"class","tip"),Z(T,"class","tip"),Z(x,"class","tip"),Z(J,"class","tip"),Z(U,"class","tip"),Z(L,"class","tip")},m(e,t){y(document.head,g),l(e,Ee,t),l(e,We,t),l(e,Ve,t),u(j,e,t),l(e,He,t),u(C,e,t),l(e,Be,t),l(e,I,t),l(e,Re,t),l(e,k,t),l(e,Xe,t),l(e,_,t),l(e,Se,t),l(e,$,t),l(e,Ye,t),l(e,W,t),l(e,Ae,t),l(e,G,t),l(e,qe,t),l(e,E,t),l(e,Fe,t),l(e,V,t),l(e,Ne,t),u(H,e,t),l(e,Qe,t),l(e,v,t),l(e,Pe,t),l(e,B,t),l(e,ze,t),l(e,R,t),l(e,Oe,t),l(e,X,t),l(e,De,t),u(S,e,t),l(e,Ke,t),l(e,Y,t),l(e,et,t),l(e,A,t),l(e,tt,t),l(e,T,t),l(e,nt,t),l(e,q,t),l(e,lt,t),u(F,e,t),l(e,at,t),l(e,N,t),l(e,st,t),l(e,Q,t),l(e,it,t),l(e,P,t),l(e,ot,t),l(e,z,t),l(e,rt,t),u(O,e,t),l(e,mt,t),u(D,e,t),l(e,dt,t),l(e,K,t),l(e,ut,t),l(e,ee,t),l(e,ct,t),l(e,b,t),y(b,Ze),y(b,At),y(b,je),y(b,qt),u(te,b,null),l(e,pt,t),u(ne,e,t),l(e,ht,t),l(e,x,t),l(e,ft,t),l(e,le,t),l(e,yt,t),l(e,ae,t),l(e,bt,t),u(se,e,t),l(e,wt,t),l(e,ie,t),l(e,gt,t),l(e,oe,t),l(e,Mt,t),u(re,e,t),l(e,vt,t),l(e,me,t),l(e,Tt,t),l(e,de,t),l(e,xt,t),l(e,ue,t),l(e,Jt,t),u(ce,e,t),l(e,Ut,t),u(pe,e,t),l(e,Lt,t),l(e,he,t),l(e,Zt,t),l(e,fe,t),l(e,jt,t),l(e,J,t),l(e,Ct,t),l(e,ye,t),l(e,It,t),u(be,e,t),l(e,kt,t),l(e,we,t),l(e,_t,t),l(e,ge,t),l(e,$t,t),l(e,U,t),l(e,Wt,t),u(Me,e,t),l(e,Gt,t),l(e,ve,t),l(e,Et,t),l(e,f,t),y(f,Ce),y(f,Ft),y(f,Ie),y(f,Nt),u(Te,f,null),y(f,Qt),y(f,ke),y(f,Pt),y(f,_e),l(e,Vt,t),u(xe,e,t),l(e,Ht,t),l(e,L,t),l(e,Bt,t),l(e,Je,t),l(e,Rt,t),u(Ue,e,t),l(e,Xt,t),l(e,Ge,t),St=!0},p:qn,i(e){St||(c(j.$$.fragment,e),c(C.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(F.$$.fragment,e),c(O.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(se.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(pe.$$.fragment,e),c(be.$$.fragment,e),c(Me.$$.fragment,e),c(Te.$$.fragment,e),c(xe.$$.fragment,e),c(Ue.$$.fragment,e),St=!0)},o(e){p(j.$$.fragment,e),p(C.$$.fragment,e),p(H.$$.fragment,e),p(S.$$.fragment,e),p(F.$$.fragment,e),p(O.$$.fragment,e),p(D.$$.fragment,e),p(te.$$.fragment,e),p(ne.$$.fragment,e),p(se.$$.fragment,e),p(re.$$.fragment,e),p(ce.$$.fragment,e),p(pe.$$.fragment,e),p(be.$$.fragment,e),p(Me.$$.fragment,e),p(Te.$$.fragment,e),p(xe.$$.fragment,e),p(Ue.$$.fragment,e),St=!1},d(e){e&&(n(Ee),n(We),n(Ve),n(He),n(Be),n(I),n(Re),n(k),n(Xe),n(_),n(Se),n($),n(Ye),n(W),n(Ae),n(G),n(qe),n(E),n(Fe),n(V),n(Ne),n(Qe),n(v),n(Pe),n(B),n(ze),n(R),n(Oe),n(X),n(De),n(Ke),n(Y),n(et),n(A),n(tt),n(T),n(nt),n(q),n(lt),n(at),n(N),n(st),n(Q),n(it),n(P),n(ot),n(z),n(rt),n(mt),n(dt),n(K),n(ut),n(ee),n(ct),n(b),n(pt),n(ht),n(x),n(ft),n(le),n(yt),n(ae),n(bt),n(wt),n(ie),n(gt),n(oe),n(Mt),n(vt),n(me),n(Tt),n(de),n(xt),n(ue),n(Jt),n(Ut),n(Lt),n(he),n(Zt),n(fe),n(jt),n(J),n(Ct),n(ye),n(It),n(kt),n(we),n(_t),n(ge),n($t),n(U),n(Wt),n(Gt),n(ve),n(Et),n(f),n(Vt),n(Ht),n(L),n(Bt),n(Je),n(Rt),n(Xt),n(Ge)),n(g),h(j,e),h(C,e),h(H,e),h(S,e),h(F,e),h(O,e),h(D,e),h(te),h(ne,e),h(se,e),h(re,e),h(ce,e),h(pe,e),h(be,e),h(Me,e),h(Te),h(xe,e),h(Ue,e)}}}const Kn='{"title":"What are components in LlamaIndex?","local":"what-are-components-in-llamaindex","sections":[{"title":"Creating a RAG pipeline using components","local":"creating-a-rag-pipeline-using-components","sections":[{"title":"Loading and embedding documents","local":"loading-and-embedding-documents","sections":[],"depth":3},{"title":"Storing and indexing documents","local":"storing-and-indexing-documents","sections":[],"depth":3},{"title":"Querying a VectorStoreIndex with prompts and LLMs","local":"querying-a-vectorstoreindex-with-prompts-and-llms","sections":[],"depth":3},{"title":"Response Processing","local":"response-processing","sections":[],"depth":3},{"title":"Evaluation and observability","local":"evaluation-and-observability","sections":[],"depth":3}],"depth":2}],"depth":1}';function el(zt){return Fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Nn{constructor(g){super(),Qn(this,g,el,Dn,An,{})}}export{ol as component};
