import{s as Tt,n as jt,o as vt}from"../chunks/scheduler.505acc25.js";import{S as xt,i as Jt,e as s,s as o,c,q as Qe,h as Zt,a as i,d as l,b as a,f as Fe,g as m,j as r,r as qe,k as ee,l as b,m as n,n as p,t as d,o as u,p as h}from"../chunks/index.fbb49fb4.js";import{C as Ct}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as te}from"../chunks/CodeBlock.7f0851b7.js";import{H as se}from"../chunks/Heading.511e0027.js";import{E as $t}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function Ut(De){let y,ce,ie,me,j,pe,v,de,x,Oe=`<strong>Defining a clear set of Tools is crucial to performance.</strong> As we discussed in <a href="../../unit1/tools">unit 1</a>, clear tool interfaces are easier for LLMs to use.
Much like a software API interface for human engineers, they can get more out of the tool if it’s easy to understand how it works.`,ue,J,et="There are <strong>four main types of tools in LlamaIndex</strong>:",he,Z,tt='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/tools.png" alt="Tools"/>',fe,C,lt="<li><code>FunctionTool</code>: Convert any Python function into a tool that an agent can use. It automatically figures out how the function works.</li> <li><code>QueryEngineTool</code>: A tool that lets agents use query engines. Since agents are built on query engines, they can also use other agents as tools.</li> <li><code>Toolspecs</code>: Sets of tools created by the community, which often include tools for specific services like Gmail.</li> <li><code>Utility Tools</code>: Special tools that help handle large amounts of data from other tools.</li>",Me,$,nt="We will go over each of them in more detail below.",ye,U,be,w,ot='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/tools.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',we,G,at=`A FunctionTool provides a simple way to wrap any Python function and make it available to an agent.
You can pass either a synchronous or asynchronous function to the tool, along with optional <code>name</code> and <code>description</code> parameters.
The name and description are particularly important as they help the agent understand when and how to use the tool effectively.
Let’s look at how to create a FunctionTool below and then call it.`,ge,W,Te,g,st='<p>When using an agent or LLM with function calling, the tool selected (and the arguments written for that tool) rely strongly on the tool name and description of the purpose and arguments of the tool. Learn more about function calling in the <a href="https://docs.llamaindex.ai/en/stable/examples/workflow/function_calling_agent/">Function Calling Guide</a>.</p>',je,I,ve,B,it=`The <code>QueryEngine</code> we defined in the previous unit can be easily transformed into a tool using the <code>QueryEngineTool</code> class.
Let’s see how to create a <code>QueryEngineTool</code> from a <code>QueryEngine</code> in the example below.`,xe,_,Je,k,Ze,L,rt=`Think of <code>ToolSpecs</code> as collections of tools that work together harmoniously - like a well-organized professional toolkit.
Just as a mechanic’s toolkit contains complementary tools that work together for vehicle repairs, a <code>ToolSpec</code> combines related tools for specific purposes.
For example, an accounting agent’s <code>ToolSpec</code> might elegantly integrate spreadsheet capabilities, email functionality, and calculation tools to handle financial tasks with precision and efficiency.`,Ce,f,le,ct="Install the Google Toolspec",Ae,V,mt="section on the LlamaHub",Pe,E,$e,N,pt="And now we can load the toolspec and convert it to a list of tools.",Ue,R,Ge,H,dt="To get a more detailed view of the tools, we can take a look at the <code>metadata</code> of each tool.",We,Y,Ie,X,Be,S,ut=`LlamaIndex also allows using MCP tools through a <a href="https://llamahub.ai/l/tools/llama-index-tools-mcp?from=" rel="nofollow">ToolSpec on the LlamaHub</a>.
You can simply run an MCP server and start using it through the following implementation.`,_e,Q,ht='If you want to dive deeper about MCP, you can check our <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">free MCP Course</a>.',ke,M,ne,ft="Install the MCP Toolspec",ze,F,Mt="section on the LlamaHub",Ke,q,Le,A,Ve,P,Ee,z,yt=`Oftentimes, directly querying an API <strong>can return an excessive amount of data</strong>, some of which may be irrelevant, overflow the context window of the LLM, or unnecessarily increase the number of tokens that you are using.
Let’s walk through our two main utility tools below.`,Ne,K,bt="<li><code>OnDemandToolLoader</code>: This tool turns any existing LlamaIndex data loader (BaseReader class) into a tool that an agent can use. The tool can be called with all the parameters needed to trigger <code>load_data</code> from the data loader, along with a natural language query string. During execution, we first load data from the data loader, index it (for instance with a vector store), and then query it ‘on-demand’. All three of these steps happen in a single tool call.</li> <li><code>LoadAndSearchToolSpec</code>: The LoadAndSearchToolSpec takes in any existing Tool as input. As a tool spec, it implements <code>to_tool_list</code>, and when that function is called, two tools are returned: a loading tool and then a search tool. The load Tool execution would call the underlying Tool, and then index the output (by default with a vector index). The search Tool execution would take in a query string as input and call the underlying index.</li>",Re,T,wt='<p>You can find toolspecs and utility tools on the <a href="https://llamahub.ai/">LlamaHub</a></p>',He,D,gt="Now that we understand the basics of agents and tools in LlamaIndex, let’s see how we can <strong>use LlamaIndex to create configurable and manageable workflows!</strong>",Ye,O,Xe,re,Se;return j=new Ct({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new se({props:{title:"Using Tools in LlamaIndex",local:"using-tools-in-llamaindex",headingTag:"h1"}}),U=new se({props:{title:"Creating a FunctionTool",local:"creating-a-functiontool",headingTag:"h2"}}),W=new te({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBGdW5jdGlvblRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcihsb2NhdGlvbiUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVXNlZnVsJTIwZm9yJTIwZ2V0dGluZyUyMHRoZSUyMHdlYXRoZXIlMjBmb3IlMjBhJTIwZ2l2ZW4lMjBsb2NhdGlvbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBwcmludChmJTIyR2V0dGluZyUyMHdlYXRoZXIlMjBmb3IlMjAlN0Jsb2NhdGlvbiU3RCUyMiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyVGhlJTIwd2VhdGhlciUyMGluJTIwJTdCbG9jYXRpb24lN0QlMjBpcyUyMHN1bm55JTIyJTBBJTBBdG9vbCUyMCUzRCUyMEZ1bmN0aW9uVG9vbC5mcm9tX2RlZmF1bHRzKCUwQSUyMCUyMCUyMCUyMGdldF93ZWF0aGVyJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMm15X3dlYXRoZXJfdG9vbCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyVXNlZnVsJTIwZm9yJTIwZ2V0dGluZyUyMHRoZSUyMHdlYXRoZXIlMjBmb3IlMjBhJTIwZ2l2ZW4lMjBsb2NhdGlvbi4lMjIlMkMlMEEpJTBBdG9vbC5jYWxsKCUyMk5ldyUyMFlvcmslMjIp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> FunctionTool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Useful for getting the weather for a given location.&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Getting weather for <span class="hljs-subst">{location}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The weather in <span class="hljs-subst">{location}</span> is sunny&quot;</span>

tool = FunctionTool.from_defaults(
    get_weather,
    name=<span class="hljs-string">&quot;my_weather_tool&quot;</span>,
    description=<span class="hljs-string">&quot;Useful for getting the weather for a given location.&quot;</span>,
)
tool.call(<span class="hljs-string">&quot;New York&quot;</span>)`,wrap:!1}}),I=new se({props:{title:"Creating a QueryEngineTool",local:"creating-a-queryenginetool",headingTag:"h2"}}),_=new te({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUudG9vbHMlMjBpbXBvcnQlMjBRdWVyeUVuZ2luZVRvb2wlMEFmcm9tJTIwbGxhbWFfaW5kZXgubGxtcy5odWdnaW5nZmFjZV9hcGklMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSSUwQWZyb20lMjBsbGFtYV9pbmRleC5lbWJlZGRpbmdzLmh1Z2dpbmdmYWNlJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmclMEFmcm9tJTIwbGxhbWFfaW5kZXgudmVjdG9yX3N0b3Jlcy5jaHJvbWElMjBpbXBvcnQlMjBDaHJvbWFWZWN0b3JTdG9yZSUwQSUwQWVtYmVkX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmcoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUwQSUwQWRiJTIwJTNEJTIwY2hyb21hZGIuUGVyc2lzdGVudENsaWVudChwYXRoJTNEJTIyLiUyRmFsZnJlZF9jaHJvbWFfZGIlMjIpJTBBY2hyb21hX2NvbGxlY3Rpb24lMjAlM0QlMjBkYi5nZXRfb3JfY3JlYXRlX2NvbGxlY3Rpb24oJTIyYWxmcmVkJTIyKSUwQXZlY3Rvcl9zdG9yZSUyMCUzRCUyMENocm9tYVZlY3RvclN0b3JlKGNocm9tYV9jb2xsZWN0aW9uJTNEY2hyb21hX2NvbGxlY3Rpb24pJTBBJTBBaW5kZXglMjAlM0QlMjBWZWN0b3JTdG9yZUluZGV4LmZyb21fdmVjdG9yX3N0b3JlKHZlY3Rvcl9zdG9yZSUyQyUyMGVtYmVkX21vZGVsJTNEZW1iZWRfbW9kZWwpJTBBJTBBbGxtJTIwJTNEJTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEkobW9kZWxfbmFtZSUzRCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEFxdWVyeV9lbmdpbmUlMjAlM0QlMjBpbmRleC5hc19xdWVyeV9lbmdpbmUobGxtJTNEbGxtKSUwQXRvb2wlMjAlM0QlMjBRdWVyeUVuZ2luZVRvb2wuZnJvbV9kZWZhdWx0cyhxdWVyeV9lbmdpbmUlMkMlMjBuYW1lJTNEJTIyc29tZSUyMHVzZWZ1bCUyMG5hbWUlMjIlMkMlMjBkZXNjcmlwdGlvbiUzRCUyMnNvbWUlMjB1c2VmdWwlMjBkZXNjcmlwdGlvbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex
<span class="hljs-keyword">from</span> llama_index.core.tools <span class="hljs-keyword">import</span> QueryEngineTool
<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface <span class="hljs-keyword">import</span> HuggingFaceEmbedding
<span class="hljs-keyword">from</span> llama_index.vector_stores.chroma <span class="hljs-keyword">import</span> ChromaVectorStore

embed_model = HuggingFaceEmbedding(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)

db = chromadb.PersistentClient(path=<span class="hljs-string">&quot;./alfred_chroma_db&quot;</span>)
chroma_collection = db.get_or_create_collection(<span class="hljs-string">&quot;alfred&quot;</span>)
vector_store = ChromaVectorStore(chroma_collection=chroma_collection)

index = VectorStoreIndex.from_vector_store(vector_store, embed_model=embed_model)

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
query_engine = index.as_query_engine(llm=llm)
tool = QueryEngineTool.from_defaults(query_engine, name=<span class="hljs-string">&quot;some useful name&quot;</span>, description=<span class="hljs-string">&quot;some useful description&quot;</span>)`,wrap:!1}}),k=new se({props:{title:"Creating Toolspecs",local:"creating-toolspecs",headingTag:"h2"}}),E=new te({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXRvb2xzLWdvb2dsZQ==",highlighted:"pip install llama-index-tools-google",wrap:!1}}),R=new te({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnRvb2xzLmdvb2dsZSUyMGltcG9ydCUyMEdtYWlsVG9vbFNwZWMlMEElMEF0b29sX3NwZWMlMjAlM0QlMjBHbWFpbFRvb2xTcGVjKCklMEF0b29sX3NwZWNfbGlzdCUyMCUzRCUyMHRvb2xfc3BlYy50b190b29sX2xpc3QoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.tools.google <span class="hljs-keyword">import</span> GmailToolSpec

tool_spec = GmailToolSpec()
tool_spec_list = tool_spec.to_tool_list()`,wrap:!1}}),Y=new te({props:{code:"JTVCKHRvb2wubWV0YWRhdGEubmFtZSUyQyUyMHRvb2wubWV0YWRhdGEuZGVzY3JpcHRpb24pJTIwZm9yJTIwdG9vbCUyMGluJTIwdG9vbF9zcGVjX2xpc3QlNUQ=",highlighted:'[(tool.metadata.name, tool.metadata.description) <span class="hljs-keyword">for</span> tool <span class="hljs-keyword">in</span> tool_spec_list]',wrap:!1}}),X=new se({props:{title:"Model Context Protocol (MCP) in LlamaIndex",local:"model-context-protocol-mcp-in-llamaindex",headingTag:"h3"}}),q=new te({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXRvb2xzLW1jcA==",highlighted:"pip install llama-index-tools-mcp",wrap:!1}}),A=new te({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LnRvb2xzLm1jcCUyMGltcG9ydCUyMEJhc2ljTUNQQ2xpZW50JTJDJTIwTWNwVG9vbFNwZWMlMEElMEElMjMlMjBXZSUyMGNvbnNpZGVyJTIwdGhlcmUlMjBpcyUyMGElMjBtY3AlMjBzZXJ2ZXIlMjBydW5uaW5nJTIwb24lMjAxMjcuMC4wLjElM0E4MDAwJTJDJTIwb3IlMjB5b3UlMjBjYW4lMjB1c2UlMjB0aGUlMjBtY3AlMjBjbGllbnQlMjB0byUyMGNvbm5lY3QlMjB0byUyMHlvdXIlMjBvd24lMjBtY3AlMjBzZXJ2ZXIuJTBBbWNwX2NsaWVudCUyMCUzRCUyMEJhc2ljTUNQQ2xpZW50KCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGc3NlJTIyKSUwQW1jcF90b29sJTIwJTNEJTIwTWNwVG9vbFNwZWMoY2xpZW50JTNEbWNwX2NsaWVudCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBhZ2VudCUwQWFnZW50JTIwJTNEJTIwYXdhaXQlMjBnZXRfYWdlbnQobWNwX3Rvb2wpJTBBJTBBJTIzJTIwY3JlYXRlJTIwdGhlJTIwYWdlbnQlMjBjb250ZXh0JTBBYWdlbnRfY29udGV4dCUyMCUzRCUyMENvbnRleHQoYWdlbnQp",highlighted:`<span class="hljs-keyword">from</span> llama_index.tools.mcp <span class="hljs-keyword">import</span> BasicMCPClient, McpToolSpec

<span class="hljs-comment"># We consider there is a mcp server running on 127.0.0.1:8000, or you can use the mcp client to connect to your own mcp server.</span>
mcp_client = BasicMCPClient(<span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>)
mcp_tool = McpToolSpec(client=mcp_client)

<span class="hljs-comment"># get the agent</span>
agent = <span class="hljs-keyword">await</span> get_agent(mcp_tool)

<span class="hljs-comment"># create the agent context</span>
agent_context = Context(agent)`,wrap:!1}}),P=new se({props:{title:"Utility Tools",local:"utility-tools",headingTag:"h2"}}),O=new $t({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/tools.mdx"}}),{c(){y=s("meta"),ce=o(),ie=s("p"),me=o(),c(j.$$.fragment),pe=o(),c(v.$$.fragment),de=o(),x=s("p"),x.innerHTML=Oe,ue=o(),J=s("p"),J.innerHTML=et,he=o(),Z=s("p"),Z.innerHTML=tt,fe=o(),C=s("ol"),C.innerHTML=lt,Me=o(),$=s("p"),$.textContent=nt,ye=o(),c(U.$$.fragment),be=o(),w=s("blockquote"),w.innerHTML=ot,we=o(),G=s("p"),G.innerHTML=at,ge=o(),c(W.$$.fragment),Te=o(),g=s("blockquote"),g.innerHTML=st,je=o(),c(I.$$.fragment),ve=o(),B=s("p"),B.innerHTML=it,xe=o(),c(_.$$.fragment),Je=o(),c(k.$$.fragment),Ze=o(),L=s("p"),L.innerHTML=rt,Ce=o(),f=s("details"),le=s("summary"),le.textContent=ct,Ae=Qe(`
As introduced in the `),V=s("a"),V.textContent=mt,Pe=Qe(`, we can install the Google toolspec with the following command:

	`),c(E.$$.fragment),$e=o(),N=s("p"),N.textContent=pt,Ue=o(),c(R.$$.fragment),Ge=o(),H=s("p"),H.innerHTML=dt,We=o(),c(Y.$$.fragment),Ie=o(),c(X.$$.fragment),Be=o(),S=s("p"),S.innerHTML=ut,_e=o(),Q=s("p"),Q.innerHTML=ht,ke=o(),M=s("details"),ne=s("summary"),ne.textContent=ft,ze=Qe(`
As introduced in the `),F=s("a"),F.textContent=Mt,Ke=Qe(`, we can install the MCP toolspec with the following command:

	`),c(q.$$.fragment),Le=o(),c(A.$$.fragment),Ve=o(),c(P.$$.fragment),Ee=o(),z=s("p"),z.innerHTML=yt,Ne=o(),K=s("ol"),K.innerHTML=bt,Re=o(),T=s("blockquote"),T.innerHTML=wt,He=o(),D=s("p"),D.innerHTML=gt,Ye=o(),c(O.$$.fragment),Xe=o(),re=s("p"),this.h()},l(e){const t=Zt("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(l),ce=a(e),ie=i(e,"P",{}),Fe(ie).forEach(l),me=a(e),m(j.$$.fragment,e),pe=a(e),m(v.$$.fragment,e),de=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1y4sc3l"&&(x.innerHTML=Oe),ue=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-jgrrn"&&(J.innerHTML=et),he=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-ir2ii4"&&(Z.innerHTML=tt),fe=a(e),C=i(e,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-7bbi5a"&&(C.innerHTML=lt),Me=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1hynje"&&($.textContent=nt),ye=a(e),m(U.$$.fragment,e),be=a(e),w=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1x3fhkd"&&(w.innerHTML=ot),we=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1ij77fk"&&(G.innerHTML=at),ge=a(e),m(W.$$.fragment,e),Te=a(e),g=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1ifg6bn"&&(g.innerHTML=st),je=a(e),m(I.$$.fragment,e),ve=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-wh1h60"&&(B.innerHTML=it),xe=a(e),m(_.$$.fragment,e),Je=a(e),m(k.$$.fragment,e),Ze=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1196szp"&&(L.innerHTML=rt),Ce=a(e),f=i(e,"DETAILS",{});var oe=Fe(f);le=i(oe,"SUMMARY",{"data-svelte-h":!0}),r(le)!=="svelte-8tnjrg"&&(le.textContent=ct),Ae=qe(oe,`
As introduced in the `),V=i(oe,"A",{href:!0,"data-svelte-h":!0}),r(V)!=="svelte-16phayx"&&(V.textContent=mt),Pe=qe(oe,`, we can install the Google toolspec with the following command:

	`),m(E.$$.fragment,oe),oe.forEach(l),$e=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-a37nc2"&&(N.textContent=pt),Ue=a(e),m(R.$$.fragment,e),Ge=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-piorhw"&&(H.innerHTML=dt),We=a(e),m(Y.$$.fragment,e),Ie=a(e),m(X.$$.fragment,e),Be=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-k8w2vg"&&(S.innerHTML=ut),_e=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-ki6njs"&&(Q.innerHTML=ht),ke=a(e),M=i(e,"DETAILS",{});var ae=Fe(M);ne=i(ae,"SUMMARY",{"data-svelte-h":!0}),r(ne)!=="svelte-vevufv"&&(ne.textContent=ft),ze=qe(ae,`
As introduced in the `),F=i(ae,"A",{href:!0,"data-svelte-h":!0}),r(F)!=="svelte-16phayx"&&(F.textContent=Mt),Ke=qe(ae,`, we can install the MCP toolspec with the following command:

	`),m(q.$$.fragment,ae),ae.forEach(l),Le=a(e),m(A.$$.fragment,e),Ve=a(e),m(P.$$.fragment,e),Ee=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1s3291r"&&(z.innerHTML=yt),Ne=a(e),K=i(e,"OL",{"data-svelte-h":!0}),r(K)!=="svelte-1vnf2o5"&&(K.innerHTML=bt),Re=a(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-luijem"&&(T.innerHTML=wt),He=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-a13dju"&&(D.innerHTML=gt),Ye=a(e),m(O.$$.fragment,e),Xe=a(e),re=i(e,"P",{}),Fe(re).forEach(l),this.h()},h(){ee(y,"name","hf:doc:metadata"),ee(y,"content",Gt),ee(w,"class","tip"),ee(g,"class","tip"),ee(V,"href","./llama-hub"),ee(F,"href","./llama-hub"),ee(T,"class","tip")},m(e,t){b(document.head,y),n(e,ce,t),n(e,ie,t),n(e,me,t),p(j,e,t),n(e,pe,t),p(v,e,t),n(e,de,t),n(e,x,t),n(e,ue,t),n(e,J,t),n(e,he,t),n(e,Z,t),n(e,fe,t),n(e,C,t),n(e,Me,t),n(e,$,t),n(e,ye,t),p(U,e,t),n(e,be,t),n(e,w,t),n(e,we,t),n(e,G,t),n(e,ge,t),p(W,e,t),n(e,Te,t),n(e,g,t),n(e,je,t),p(I,e,t),n(e,ve,t),n(e,B,t),n(e,xe,t),p(_,e,t),n(e,Je,t),p(k,e,t),n(e,Ze,t),n(e,L,t),n(e,Ce,t),n(e,f,t),b(f,le),b(f,Ae),b(f,V),b(f,Pe),p(E,f,null),n(e,$e,t),n(e,N,t),n(e,Ue,t),p(R,e,t),n(e,Ge,t),n(e,H,t),n(e,We,t),p(Y,e,t),n(e,Ie,t),p(X,e,t),n(e,Be,t),n(e,S,t),n(e,_e,t),n(e,Q,t),n(e,ke,t),n(e,M,t),b(M,ne),b(M,ze),b(M,F),b(M,Ke),p(q,M,null),n(e,Le,t),p(A,e,t),n(e,Ve,t),p(P,e,t),n(e,Ee,t),n(e,z,t),n(e,Ne,t),n(e,K,t),n(e,Re,t),n(e,T,t),n(e,He,t),n(e,D,t),n(e,Ye,t),p(O,e,t),n(e,Xe,t),n(e,re,t),Se=!0},p:jt,i(e){Se||(d(j.$$.fragment,e),d(v.$$.fragment,e),d(U.$$.fragment,e),d(W.$$.fragment,e),d(I.$$.fragment,e),d(_.$$.fragment,e),d(k.$$.fragment,e),d(E.$$.fragment,e),d(R.$$.fragment,e),d(Y.$$.fragment,e),d(X.$$.fragment,e),d(q.$$.fragment,e),d(A.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),Se=!0)},o(e){u(j.$$.fragment,e),u(v.$$.fragment,e),u(U.$$.fragment,e),u(W.$$.fragment,e),u(I.$$.fragment,e),u(_.$$.fragment,e),u(k.$$.fragment,e),u(E.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(X.$$.fragment,e),u(q.$$.fragment,e),u(A.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),Se=!1},d(e){e&&(l(ce),l(ie),l(me),l(pe),l(de),l(x),l(ue),l(J),l(he),l(Z),l(fe),l(C),l(Me),l($),l(ye),l(be),l(w),l(we),l(G),l(ge),l(Te),l(g),l(je),l(ve),l(B),l(xe),l(Je),l(Ze),l(L),l(Ce),l(f),l($e),l(N),l(Ue),l(Ge),l(H),l(We),l(Ie),l(Be),l(S),l(_e),l(Q),l(ke),l(M),l(Le),l(Ve),l(Ee),l(z),l(Ne),l(K),l(Re),l(T),l(He),l(D),l(Ye),l(Xe),l(re)),l(y),h(j,e),h(v,e),h(U,e),h(W,e),h(I,e),h(_,e),h(k,e),h(E),h(R,e),h(Y,e),h(X,e),h(q),h(A,e),h(P,e),h(O,e)}}}const Gt='{"title":"Using Tools in LlamaIndex","local":"using-tools-in-llamaindex","sections":[{"title":"Creating a FunctionTool","local":"creating-a-functiontool","sections":[],"depth":2},{"title":"Creating a QueryEngineTool","local":"creating-a-queryenginetool","sections":[],"depth":2},{"title":"Creating Toolspecs","local":"creating-toolspecs","sections":[{"title":"Model Context Protocol (MCP) in LlamaIndex","local":"model-context-protocol-mcp-in-llamaindex","sections":[],"depth":3}],"depth":2},{"title":"Utility Tools","local":"utility-tools","sections":[],"depth":2}],"depth":1}';function Wt(De){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends xt{constructor(y){super(),Jt(this,y,Wt,Ut,Tt,{})}}export{Et as component};
