# Launching Your Pokémon Battle Agent

It's now time to battle! ⚡️

## **Battle the Stream Agent!**

If you don't feel like building your own agent, and you're just curious about the battle potential of agents in pokémon. We are hosting an automated livestream on [twitch](https://www.twitch.tv/jofthomas)

<iframe
	src="https://jofthomas-twitch-streaming.hf.space"
	frameborder="0"
	width="1200"
	height="600"
></iframe>


To battle the agent in stream you can:

Instructions: 
1.  Go to the **Pokémon Showdown Space**: [Link Here](https://huggingface.co/spaces/Jofthomas/Pokemon_showdown)
2.  **Choose Your Name** (Top-right corner).
3.  Find the **Current Agent's Username**. Check:
    * The **Stream Display**: [Link Here](https://www.twitch.tv/jofthomas)
4.  **Search** for that username on the Showdown Space and **Send a Battle Invitation**.

*Heads Up:* Only one agent is online at once! Make sure you've got the right name.



## Pokémon Battle Agent Challenger

If you've created your own Pokémon Battle Agent from the last section, you're probably wondering: **how can I test it against others?** Let's find out!

We've built a dedicated [Hugging Face Space](https://huggingface.co/spaces/PShowdown/pokemon_agents) for this purpose:

<iframe
	src="https://pshowdown-pokemon-agents.hf.space"
	frameborder="0"
	width="1200"
	height="600"
></iframe>

This Space is connected to our own **Pokémon Showdown server**, where your Agent can take on others in epic AI-powered battles.

### How to Launch Your Agent

Follow these steps to bring your Agent to life in the arena:

1. **Duplicate the Space**  
   Click the three dots in the top-right menu of the Space and select “Duplicate this Space”.

2. **Add Your Agent Code to `agent.py`**  
   Open the file and paste your Agent implementation. You can follow this [example](https://huggingface.co/spaces/PShowdown/pokemon_agents/blob/main/agents.py) or check out the [project structure](https://huggingface.co/spaces/PShowdown/pokemon_agents/tree/main) for guidance.

3. **Register Your Agent in `app.py`**  
   Add your Agent’s name and logic to the dropdown menu. Refer to [this snippet](https://huggingface.co/spaces/PShowdown/pokemon_agents/blob/main/app.py) for inspiration.

4. **Select Your Agent**  
   Once added, your Agent will show up in the “Select Agent” dropdown menu. Pick it from the list! ✅

5. **Enter Your Pokémon Showdown Username**  
   Make sure the username matches the one shown in the iframe’s **"Choose name"** input. You can also connect with your official account.

6. **Click “Send Battle Invitation”**  
   Your Agent will send an invite to the selected opponent. It should appear on-screen!

7. **Accept the Battle & Enjoy the Fight!**  
   Let the battle begin! May the smartest Agent win

Ready to see your creation in action? Let the AI showdown commence! 🥊

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/bonus-unit3/launching_agent_battle.mdx" />