# Small Quiz (ungraded) [[quiz1]]

So far we've discussed the key components and tools used in LlamaIndex.
It's time to make a short quiz, since **testing yourself** is the best way to learn and [to avoid the illusion of competence](https://www.coursera.org/lecture/learning-how-to-learn/illusions-of-competence-BuFzf).
This will help you find **where you need to reinforce your knowledge**.

This is an optional quiz and it's not graded.

### Q1: What is a QueryEngine?
Which of the following best describes a QueryEngine component?

<Question
choices={[
{
text: "A system that only processes static text without any retrieval capabilities.",
explain: "A QueryEngine must be able to retrieve and process relevant information.",
},
{
text: "A component that finds and retrieves relevant information as part of the RAG process.",
explain: "This captures the core purpose of a QueryEngine component.",
correct: true
},
{
text: "A tool that only stores vector embeddings without search functionality.",
explain: "A QueryEngine does more than just store embeddings - it actively searches and retrieves information.",
},
{
text: "A component that only evaluates response quality.",
explain: "Evaluation is separate from the QueryEngine's main retrieval purpose.",
}
]}
/>

---

### Q2: What is the Purpose of FunctionTools?
Why are FunctionTools important for an Agent?

<Question
choices={[
{
text: "To handle large amounts of data storage.",
explain: "FunctionTools are not primarily for data storage.",
},
{
text: "To convert Python functions into tools that an agent can use.",
explain: "FunctionTools wrap Python functions to make them accessible to agents.",
correct: true
},
{
text: "To allow agents to create random functions definitions.",
explain: "FunctionTools serve the specific purpose of making functions available to agents.",
},
{
text: "To only process text data.",
explain: "FunctionTools can work with various types of functions, not just text processing.",
}
]}
/>

---

### Q3: What are Toolspecs in LlamaIndex?
What is the main purpose of Toolspecs?

<Question
choices={[
{
text: "They are redundant components that don't add functionality.",
explain: "Toolspecs serve an important purpose in the LlamaIndex ecosystem.",
},
{
text: "They are sets of community-created tools that extend agent capabilities.",
explain: "Toolspecs allow the community to share and reuse tools.",
correct: true
},
{
text: "They are used solely for memory management.",
explain: "Toolspecs are about providing tools, not managing memory.",
},
{
text: "They only work with text processing.",
explain: "Toolspecs can include various types of tools, not just text processing.",
}
]}
/>

---

### Q4: What is Required to create a tool?
What information must be included when creating a tool?

<Question
choices={[
{
text: "A function, a name, and description must be defined.",
explain: "While these all make up a tool, the name and description can be parsed from the function and docstring.",
},
{
text: "Only the name is required.",
explain: "A function and description/docstring is also required for proper tool documentation.",
},
{
text: "Only the description is required.",
explain: "A function is required so that we have code to run when an agent selects a tool",
},
{
text: "Only the function is required.",
explain: "The name and description default to the name and docstring from the provided function",
correct: true
}
]}
/>

---

Congrats on finishing this Quiz 🥳, if you missed some elements, take time to read again the chapter to reinforce your knowledge. If you pass it, you're ready to dive deeper into building with these components!


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/en/unit2/llama-index/quiz1.mdx" />