import{s as pt,a as Ul,n as Mt,o as mt}from"../chunks/scheduler.505acc25.js";import{S as ct,i as ut,e as r,s as a,c as m,h as Jt,a as o,d as t,b as n,f as bl,g as c,j as i,k as M,l as yt,m as s,n as u,t as J,o as y,p as T}from"../chunks/index.fbb49fb4.js";import{C as Tt}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as jl}from"../chunks/CodeBlock.2ead06c8.js";import{H as Te}from"../chunks/Heading.511e0027.js";import{E as wt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function dt(hl){let w,we,Je,de,d,je,j,Ue,U,Il="En la última sección, aprendimos cómo podemos crear Agentes desde cero usando código Python, y <strong>vimos lo tedioso que puede ser ese proceso</strong>. Afortunadamente, muchas librerías de Agentes simplifican este trabajo <strong>manejando gran parte del trabajo pesado por ti</strong>.",be,b,Bl="En este tutorial, <strong>crearás tu primer Agente</strong> capaz de realizar acciones como generación de imágenes, búsqueda web, verificación de zonas horarias y mucho más.",he,h,gl="También publicarás tu agente <strong>en un Space de Hugging Face para que puedas compartirlo con amigos y colegas</strong>.",Ie,I,Cl="¡Comencemos!",Be,B,ge,g,fl,Ce,C,vl="Para crear este Agente, vamos a usar <code>smolagents</code>, una librería que <strong>proporciona un marco para desarrollar tus agentes con facilidad</strong>.",fe,f,Wl="Esta librería ligera está diseñada para ser simple, pero abstrae gran parte de la complejidad de construir un Agente, permitiéndote enfocarte en diseño el comportamiento de tu agente.",ve,v,Gl='Profundizaremos más en smolagents en la siguiente Unidad. Mientras tanto, también puedes consultar esta <a href="https://huggingface.co/blog/smolagents" target="_blank">publicación del blog</a> o el <a href="https://github.com/huggingface/smolagents" target="_blank">repositorio de la librería en GitHub</a>.',We,W,Zl="En resumen, <code>smolagents</code> es una librería que se enfoca en <strong>codeAgent</strong>, un tipo de agente que realiza <strong>“Acciones”</strong> a través de bloques de código, y luego <strong>“Observa”</strong> los resultados ejecutando el código.",Ge,G,Vl="¡Aquí un ejemplo de lo que construiremos!",Ze,Z,El="Proporcionamos a nuestro agente una <strong>herramienta de generación de imágenes</strong> y le pedimos que genere una imagen de un gato.",Ve,V,_l="El agente dentro de <code>smolagents</code> va a tener los <strong>mismos comportamientos que el personalizado que construimos anteriormente</strong>: va a <strong>pensar, actuar y observar en ciclo</strong> hasta que llegue a una respuesta final:",Ee,p,zl,_e,E,Sl="Emocionante, ¿cierto?",ze,_,Se,z,Hl='Para comenzar, duplica este Space: <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',He,S,Ql='<p>¡Gracias a <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> por esta plantilla! 🙌</p>',Qe,H,xl="Duplicar este space significa <strong>crear una copia local en tu propio perfil</strong>:",xe,Q,Al,Ae,x,Rl='A lo largo de esta lección, el único archivo que necesitarás modificar es el (actualmente incompleto) <strong>“app.py”</strong>. Puedes ver aquí el <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original en la plantilla</a>. Para encontrar el tuyo, ve a tu copia del space, luego haz clic en la pestaña <code>Files</code> y luego en <code>app.py</code> en el listado de directorios.',Re,A,Yl="Analicemos el código juntos:",Ye,R,kl="<li>El archivo comienza con algunas importaciones de bibliotecas simples pero necesarias</li>",ke,Y,Ne,k,Nl="Como se describió anteriormente, usaremos directamente la clase <strong>CodeAgent</strong> de <strong>smolagents</strong>.",Fe,N,qe,F,Fl='¡Ahora vamos con las herramientas! Si quieres un repaso sobre las herramientas, no dudes en volver a la sección <a href="tools">Herramientas</a> del curso.',Xe,q,$e,X,ql="Las Herramientas son lo que te estamos animando a construir en esta sección. Te damos dos ejemplos:",Le,$,Xl="<li>Una <strong>Herramienta ficticia que no funciona</strong> que puedes modificar para hacer algo útil.</li> <li>Una <strong>Herramienta que realmente funciona</strong> que obtiene la hora actual en algún lugar del mundo.</li>",Pe,L,$l="Para definir tu herramienta es importante:",De,P,Ll="<li>Proporcionar tipos de entrada y salida para tu función, como en <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>Un docstring formateado</strong>. <code>smolagents</code> espera que todos los argumentos tengan una <strong>descripción textual en el docstring</strong>.</li>",Ke,D,Oe,K,Pl='Utiliza <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> como motor LLM. Este es un modelo muy capaz al que accederemos a través de la API sin servidor.',el,O,ll,ee,Dl="¡Este Agente todavía usa el <code>InferenceClient</code> que vimos en una sección anterior detrás de la clase <strong>InferenceClientModel</strong>!",tl,le,Kl="Daremos ejemplos más detallados cuando presentemos el marco en la Unidad 2. Por ahora, debes enfocarte en <strong>agregar nuevas herramientas a la lista de herramientas</strong> usando el parámetro <code>tools</code> de tu Agente.",sl,te,Ol="Por ejemplo, podrías usar el <code>DuckDuckGoSearchTool</code> que se importó en la primera línea del código, o puedes examinar el <code>image_generation_tool</code> que se carga desde el Hub más adelante en el código.",al,se,et="<strong>Agregar herramientas le dará a tu agente nuevas capacidades</strong>, ¡intenta ser creativo aquí!",nl,ae,lt="El “app.py” completo:",rl,ne,ol,re,tt="Tu <strong>Objetivo</strong> es familiarizarte con el Space y el Agente.",il,oe,st="Actualmente, el agente en la plantilla <strong>no utiliza ninguna herramienta, así que intenta proporcionarle algunas de las prefabricadas o incluso crear algunas herramientas nuevas tú mismo.</strong>",pl,ie,at="¡Estamos esperando ansiosamente tus increíbles resultados de agentes en el canal de Discord <strong>#agents-course-showcase</strong>!",Ml,ml,cl,pe,nt="¡Felicidades, has construido tu primer Agente! No dudes en compartirlo con tus amigos y colegas.",ul,Me,rt="Como este es tu primer intento, es perfectamente normal si es un poco inestable o lento. En futuras unidades, aprenderemos cómo construir Agentes aún mejores.",Jl,me,ot="La mejor manera de aprender es intentarlo, así que no dudes en actualizarlo, agregar más herramientas, probar con otro modelo, etc.",yl,ce,it="En la siguiente sección, completarás el Quiz final y obtendrás tu certificado.",Tl,ue,wl,ye,dl;return d=new Tt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new Te({props:{title:"Vamos Crear Nuestro Primer Agente Usando smolagents",local:"vamos-crear-nuestro-primer-agente-usando-smolagents",headingTag:"h1"}}),B=new Te({props:{title:"¿Qué es smolagents?",local:"qué-es-smolagents",headingTag:"h2"}}),_=new Te({props:{title:"¡Construyamos nuestro Agente!",local:"construyamos-nuestro-agente",headingTag:"h2"}}),Y=new jl({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTIwbG9hZF90b29sJTJDJTIwdG9vbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBweXR6JTBBaW1wb3J0JTIweWFtbCUwQWZyb20lMjB0b29scy5maW5hbF9hbnN3ZXIlMjBpbXBvcnQlMjBGaW5hbEFuc3dlclRvb2w=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),N=new Te({props:{title:"Las Herramientas",local:"las-herramientas",headingTag:"h3"}}),q=new jl({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># es importante especificar el tipo que se regresara</span>
    <span class="hljs-comment"># Mantén este formato para la descripción de la herramienta / descripción de args pero siéntete libre de modificar la herramienta</span>
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que aun no hace nada 
    Args:
        arg1: el primer argumento
        arg2: el segundo argumento
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;¿Qué magia construirás?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que obtiene la hora local actual en una zona horaria especificada.
    Args:
        timezone: Una cadena que representa una zona horaria válida (por ejemplo, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Crear objeto de zona horaria</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtener la hora actual en esa zona horaria</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;La hora local actual en <span class="hljs-subst">{timezone}</span> es: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error al obtener la hora para la zona horaria &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),D=new Te({props:{title:"El Agente",local:"el-agente",headingTag:"h3"}}),O=new jl({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QyMDk2JTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QnJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JvbGVfY29udmVyc2lvbnMlM0ROb25lJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVuKCUyMnByb21wdHMueWFtbCUyMiUyQyUyMCdyJyklMjBhcyUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlMjAlM0QlMjB5YW1sLnNhZmVfbG9hZChzdHJlYW0pJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwRXN0YW1vcyUyMGNyZWFuZG8lMjBudWVzdHJvJTIwQ29kZUFnZW50JTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCZmluYWxfYW5zd2VyJTVEJTJDJTIwJTIzJTIwYSVDMyVCMWFkZSUyMHR1cyUyMGhlcnJhbWllbnRhcyUyMGFxdSVDMyVBRCUyMChubyUyMGVsaW1pbmVzJTIwZmluYWxfYW5zd2VyKSUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDYlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ3JhbW1hciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwbGFubmluZ19pbnRlcnZhbCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlM0Rwcm9tcHRfdGVtcGxhdGVzJTBBKSUwQSUwQUdyYWRpb1VJKGFnZW50KS5sYXVuY2goKQ==",highlighted:`final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># Estamos creando nuestro CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># añade tus herramientas aquí (no elimines final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),ne=new jl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># A continuación hay un ejemplo de una herramienta que no hace nada. ¡Sorpréndenos con tu creatividad!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># es importante especificar el tipo de retorno</span>
    <span class="hljs-comment"># Mantén este formato para la descripción de la herramienta / descripción de args pero siéntete libre de modificar la herramienta</span>
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que aún no hace nada 
    Args:
        arg1: el primer argumento
        arg2: el segundo argumento
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;¿Qué magia construirás?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que obtiene la hora local actual en una zona horaria especificada.
    Args:
        timezone: Una cadena que representa una zona horaria válida (por ejemplo, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Crear objeto de zona horaria</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtener la hora actual en esa zona horaria</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;La hora local actual en <span class="hljs-subst">{timezone}</span> es: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error al obtener la hora para la zona horaria &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = InferenceClientModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Importar herramienta desde Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># añade tus herramientas aquí (no elimines final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),ue=new wt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit1/tutorial.mdx"}}),{c(){w=r("meta"),we=a(),Je=r("p"),de=a(),m(d.$$.fragment),je=a(),m(j.$$.fragment),Ue=a(),U=r("p"),U.innerHTML=Il,be=a(),b=r("p"),b.innerHTML=Bl,he=a(),h=r("p"),h.innerHTML=gl,Ie=a(),I=r("p"),I.textContent=Cl,Be=a(),m(B.$$.fragment),ge=a(),g=r("img"),Ce=a(),C=r("p"),C.innerHTML=vl,fe=a(),f=r("p"),f.textContent=Wl,ve=a(),v=r("p"),v.innerHTML=Gl,We=a(),W=r("p"),W.innerHTML=Zl,Ge=a(),G=r("p"),G.textContent=Vl,Ze=a(),Z=r("p"),Z.innerHTML=El,Ve=a(),V=r("p"),V.innerHTML=_l,Ee=a(),p=r("iframe"),_e=a(),E=r("p"),E.textContent=Sl,ze=a(),m(_.$$.fragment),Se=a(),z=r("p"),z.innerHTML=Hl,He=a(),S=r("blockquote"),S.innerHTML=Ql,Qe=a(),H=r("p"),H.innerHTML=xl,xe=a(),Q=r("img"),Ae=a(),x=r("p"),x.innerHTML=Rl,Re=a(),A=r("p"),A.textContent=Yl,Ye=a(),R=r("ul"),R.innerHTML=kl,ke=a(),m(Y.$$.fragment),Ne=a(),k=r("p"),k.innerHTML=Nl,Fe=a(),m(N.$$.fragment),qe=a(),F=r("p"),F.innerHTML=Fl,Xe=a(),m(q.$$.fragment),$e=a(),X=r("p"),X.textContent=ql,Le=a(),$=r("ol"),$.innerHTML=Xl,Pe=a(),L=r("p"),L.textContent=$l,De=a(),P=r("ol"),P.innerHTML=Ll,Ke=a(),m(D.$$.fragment),Oe=a(),K=r("p"),K.innerHTML=Pl,el=a(),m(O.$$.fragment),ll=a(),ee=r("p"),ee.innerHTML=Dl,tl=a(),le=r("p"),le.innerHTML=Kl,sl=a(),te=r("p"),te.innerHTML=Ol,al=a(),se=r("p"),se.innerHTML=et,nl=a(),ae=r("p"),ae.textContent=lt,rl=a(),m(ne.$$.fragment),ol=a(),re=r("p"),re.innerHTML=tt,il=a(),oe=r("p"),oe.innerHTML=st,pl=a(),ie=r("p"),ie.innerHTML=at,Ml=a(),ml=r("hr"),cl=a(),pe=r("p"),pe.textContent=nt,ul=a(),Me=r("p"),Me.textContent=rt,Jl=a(),me=r("p"),me.textContent=ot,yl=a(),ce=r("p"),ce.textContent=it,Tl=a(),m(ue.$$.fragment),wl=a(),ye=r("p"),this.h()},l(e){const l=Jt("svelte-u9bgzb",document.head);w=o(l,"META",{name:!0,content:!0}),l.forEach(t),we=n(e),Je=o(e,"P",{}),bl(Je).forEach(t),de=n(e),c(d.$$.fragment,e),je=n(e),c(j.$$.fragment,e),Ue=n(e),U=o(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-1k05pg6"&&(U.innerHTML=Il),be=n(e),b=o(e,"P",{"data-svelte-h":!0}),i(b)!=="svelte-tievl2"&&(b.innerHTML=Bl),he=n(e),h=o(e,"P",{"data-svelte-h":!0}),i(h)!=="svelte-11b1hs9"&&(h.innerHTML=gl),Ie=n(e),I=o(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-z8wdc9"&&(I.textContent=Cl),Be=n(e),c(B.$$.fragment,e),ge=n(e),g=o(e,"IMG",{src:!0,alt:!0}),Ce=n(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-zqt6ec"&&(C.innerHTML=vl),fe=n(e),f=o(e,"P",{"data-svelte-h":!0}),i(f)!=="svelte-ibz603"&&(f.textContent=Wl),ve=n(e),v=o(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1oz1fp9"&&(v.innerHTML=Gl),We=n(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1971uy4"&&(W.innerHTML=Zl),Ge=n(e),G=o(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1kjiebb"&&(G.textContent=Vl),Ze=n(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1pdukv3"&&(Z.innerHTML=El),Ve=n(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1e49dxv"&&(V.innerHTML=_l),Ee=n(e),p=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),bl(p).forEach(t),_e=n(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-160ich6"&&(E.textContent=Sl),ze=n(e),c(_.$$.fragment,e),Se=n(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-x24dt4"&&(z.innerHTML=Hl),He=n(e),S=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(S)!=="svelte-1lt0ymi"&&(S.innerHTML=Ql),Qe=n(e),H=o(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-976dli"&&(H.innerHTML=xl),xe=n(e),Q=o(e,"IMG",{src:!0,alt:!0}),Ae=n(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-ahm5nq"&&(x.innerHTML=Rl),Re=n(e),A=o(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-yy81s5"&&(A.textContent=Yl),Ye=n(e),R=o(e,"UL",{"data-svelte-h":!0}),i(R)!=="svelte-119fxux"&&(R.innerHTML=kl),ke=n(e),c(Y.$$.fragment,e),Ne=n(e),k=o(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-mt70f8"&&(k.innerHTML=Nl),Fe=n(e),c(N.$$.fragment,e),qe=n(e),F=o(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1ou7f4u"&&(F.innerHTML=Fl),Xe=n(e),c(q.$$.fragment,e),$e=n(e),X=o(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1q83jk1"&&(X.textContent=ql),Le=n(e),$=o(e,"OL",{"data-svelte-h":!0}),i($)!=="svelte-1xx1ttu"&&($.innerHTML=Xl),Pe=n(e),L=o(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-fltuof"&&(L.textContent=$l),De=n(e),P=o(e,"OL",{"data-svelte-h":!0}),i(P)!=="svelte-1mxmbql"&&(P.innerHTML=Ll),Ke=n(e),c(D.$$.fragment,e),Oe=n(e),K=o(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-4qpjof"&&(K.innerHTML=Pl),el=n(e),c(O.$$.fragment,e),ll=n(e),ee=o(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-noysk9"&&(ee.innerHTML=Dl),tl=n(e),le=o(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-10pkzke"&&(le.innerHTML=Kl),sl=n(e),te=o(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-vla5kx"&&(te.innerHTML=Ol),al=n(e),se=o(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-i0yzw0"&&(se.innerHTML=et),nl=n(e),ae=o(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-kgrbhd"&&(ae.textContent=lt),rl=n(e),c(ne.$$.fragment,e),ol=n(e),re=o(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-s8ocjr"&&(re.innerHTML=tt),il=n(e),oe=o(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1mir7mg"&&(oe.innerHTML=st),pl=n(e),ie=o(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-f30lju"&&(ie.innerHTML=at),Ml=n(e),ml=o(e,"HR",{}),cl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-bgfucn"&&(pe.textContent=nt),ul=n(e),Me=o(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1amxj21"&&(Me.textContent=rt),Jl=n(e),me=o(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-nyg79v"&&(me.textContent=ot),yl=n(e),ce=o(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-1dldop1"&&(ce.textContent=it),Tl=n(e),c(ue.$$.fragment,e),wl=n(e),ye=o(e,"P",{}),bl(ye).forEach(t),this.h()},h(){M(w,"name","hf:doc:metadata"),M(w,"content",jt),Ul(g.src,fl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||M(g,"src",fl),M(g,"alt","smolagents"),M(p,"width","560"),M(p,"height","315"),Ul(p.src,zl="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||M(p,"src",zl),M(p,"title","YouTube video player"),M(p,"frameborder","0"),M(p,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),M(p,"referrerpolicy","strict-origin-when-cross-origin"),p.allowFullscreen="",Ul(Q.src,Al="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||M(Q,"src",Al),M(Q,"alt","Duplicate")},m(e,l){yt(document.head,w),s(e,we,l),s(e,Je,l),s(e,de,l),u(d,e,l),s(e,je,l),u(j,e,l),s(e,Ue,l),s(e,U,l),s(e,be,l),s(e,b,l),s(e,he,l),s(e,h,l),s(e,Ie,l),s(e,I,l),s(e,Be,l),u(B,e,l),s(e,ge,l),s(e,g,l),s(e,Ce,l),s(e,C,l),s(e,fe,l),s(e,f,l),s(e,ve,l),s(e,v,l),s(e,We,l),s(e,W,l),s(e,Ge,l),s(e,G,l),s(e,Ze,l),s(e,Z,l),s(e,Ve,l),s(e,V,l),s(e,Ee,l),s(e,p,l),s(e,_e,l),s(e,E,l),s(e,ze,l),u(_,e,l),s(e,Se,l),s(e,z,l),s(e,He,l),s(e,S,l),s(e,Qe,l),s(e,H,l),s(e,xe,l),s(e,Q,l),s(e,Ae,l),s(e,x,l),s(e,Re,l),s(e,A,l),s(e,Ye,l),s(e,R,l),s(e,ke,l),u(Y,e,l),s(e,Ne,l),s(e,k,l),s(e,Fe,l),u(N,e,l),s(e,qe,l),s(e,F,l),s(e,Xe,l),u(q,e,l),s(e,$e,l),s(e,X,l),s(e,Le,l),s(e,$,l),s(e,Pe,l),s(e,L,l),s(e,De,l),s(e,P,l),s(e,Ke,l),u(D,e,l),s(e,Oe,l),s(e,K,l),s(e,el,l),u(O,e,l),s(e,ll,l),s(e,ee,l),s(e,tl,l),s(e,le,l),s(e,sl,l),s(e,te,l),s(e,al,l),s(e,se,l),s(e,nl,l),s(e,ae,l),s(e,rl,l),u(ne,e,l),s(e,ol,l),s(e,re,l),s(e,il,l),s(e,oe,l),s(e,pl,l),s(e,ie,l),s(e,Ml,l),s(e,ml,l),s(e,cl,l),s(e,pe,l),s(e,ul,l),s(e,Me,l),s(e,Jl,l),s(e,me,l),s(e,yl,l),s(e,ce,l),s(e,Tl,l),u(ue,e,l),s(e,wl,l),s(e,ye,l),dl=!0},p:Mt,i(e){dl||(J(d.$$.fragment,e),J(j.$$.fragment,e),J(B.$$.fragment,e),J(_.$$.fragment,e),J(Y.$$.fragment,e),J(N.$$.fragment,e),J(q.$$.fragment,e),J(D.$$.fragment,e),J(O.$$.fragment,e),J(ne.$$.fragment,e),J(ue.$$.fragment,e),dl=!0)},o(e){y(d.$$.fragment,e),y(j.$$.fragment,e),y(B.$$.fragment,e),y(_.$$.fragment,e),y(Y.$$.fragment,e),y(N.$$.fragment,e),y(q.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(ne.$$.fragment,e),y(ue.$$.fragment,e),dl=!1},d(e){e&&(t(we),t(Je),t(de),t(je),t(Ue),t(U),t(be),t(b),t(he),t(h),t(Ie),t(I),t(Be),t(ge),t(g),t(Ce),t(C),t(fe),t(f),t(ve),t(v),t(We),t(W),t(Ge),t(G),t(Ze),t(Z),t(Ve),t(V),t(Ee),t(p),t(_e),t(E),t(ze),t(Se),t(z),t(He),t(S),t(Qe),t(H),t(xe),t(Q),t(Ae),t(x),t(Re),t(A),t(Ye),t(R),t(ke),t(Ne),t(k),t(Fe),t(qe),t(F),t(Xe),t($e),t(X),t(Le),t($),t(Pe),t(L),t(De),t(P),t(Ke),t(Oe),t(K),t(el),t(ll),t(ee),t(tl),t(le),t(sl),t(te),t(al),t(se),t(nl),t(ae),t(rl),t(ol),t(re),t(il),t(oe),t(pl),t(ie),t(Ml),t(ml),t(cl),t(pe),t(ul),t(Me),t(Jl),t(me),t(yl),t(ce),t(Tl),t(wl),t(ye)),t(w),T(d,e),T(j,e),T(B,e),T(_,e),T(Y,e),T(N,e),T(q,e),T(D,e),T(O,e),T(ne,e),T(ue,e)}}}const jt='{"title":"Vamos Crear Nuestro Primer Agente Usando smolagents","local":"vamos-crear-nuestro-primer-agente-usando-smolagents","sections":[{"title":"¿Qué es smolagents?","local":"qué-es-smolagents","sections":[],"depth":2},{"title":"¡Construyamos nuestro Agente!","local":"construyamos-nuestro-agente","sections":[{"title":"Las Herramientas","local":"las-herramientas","sections":[],"depth":3},{"title":"El Agente","local":"el-agente","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ut(hl){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ft extends ct{constructor(w){super(),ut(this,w,Ut,dt,pt,{})}}export{ft as component};
