import{s as gt,a as zl,n as Ct,o as Bt}from"../chunks/scheduler.505acc25.js";import{S as Zt,i as Gt,e as i,s as n,c as u,h as Vt,a as o,d as t,b as a,f as xl,g as c,j as r,k as p,l as zt,m as s,n as m,t as y,o as J,p as d}from"../chunks/index.b1175496.js";import{C as xt,H as Ue}from"../chunks/Heading.988e52fa.js";import{C as Vl}from"../chunks/CodeBlock.ed64aebc.js";import{E as Wt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.3d47a398.js";function At(Wl){let T,he,be,ve,w,fe,j,ge,U,Al="Dans la section précédente, nous avons appris comment créer des agents à partir de zéro en utilisant du code Python, et nous avons <strong>vu à quel point ce processus peut être fastidieux</strong>. Heureusement, de nombreuses bibliothèques d’agents simplifient ce travail en <strong>se chargeant de la majeure partie du travail lourd pour vous</strong>.",Ce,b,_l="Dans ce tutoriel, <strong>vous allez créer votre tout premier agent</strong> capable d’exécuter des actions telles que la génération d’images, la recherche sur le web, la vérification de fuseaux horaires et bien plus encore !",Be,I,El="Vous publierez également votre agent <strong>sur un <em>Space</em> Hugging Face afin de le partager avec vos amis et collègues</strong>.",Ze,h,Hl="C’est parti !",Ge,v,Ve,f,Ql,ze,g,Sl="Pour créer cet agent, nous allons utiliser <code>smolagents</code>, une bibliothèque qui <strong>fournit un cadre facilitant le développement d’agents</strong>.",xe,C,Rl="Cette bibliothèque légère est conçue pour être simple, tout en masquant une grande partie de la complexité liée à la construction d’un agent, permettant ainsi de vous concentrer sur la conception du comportement de l’agent.",We,B,kl='Nous approfondirons smolagents dans la prochaine unité. En attendant, vous pouvez également consulter cet <a href="https://huggingface.co/blog/smolagents" target="_blank">article de blog</a> ou le <a href="https://github.com/huggingface/smolagents" target="_blank">dépôt GitHub</a> de la bibliothèque.',Ae,Z,Xl="Brièvement, <code>smolagents</code> est une bibliothèque se concentrant sur les <strong>agents générant du code</strong> (via la classe <code>CodeAgent</code>), un type d’agent qui exécute des <strong>“actions”</strong> via des blocs de code, puis <strong>“observe”</strong> les résultats en exécutant le code.",_e,G,Nl="Voici un exemple de ce que nous allons construire !",Ee,V,ql="Nous avons équipé notre agent d’un <strong>outil de génération d’images</strong> et lui avons demandé de générer une image d’un chat.",He,z,Fl="L’agent dans <code>smolagents</code> aura les <strong>mêmes comportements que celui personnalisé que nous avons construit précédemment</strong> : il va <strong>réfléchir, agir et observer cycliquement</strong> jusqu’à parvenir à une réponse finale :",Qe,M,Ll,Se,x,$l="Excitant, n’est-ce pas ?",Re,W,ke,A,Yl='Pour commencer, dupliquez ce <em>Space</em> : <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',Xe,_,Pl='<p>Merci à <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> pour ce patron ! 🙌</p>',Ne,E,Dl="Dupliquer signifie <strong>créer une copie locale sur votre propre profil</strong> :",qe,H,Kl,Fe,Q,Ol="Après la duplication, vous devrez ajouter votre <em>token</em> d’API Hugging Face pour que votre agent puisse accéder à l’API du modèle :",Le,S,et='<li>Tout d’abord, obtenez votre <em>token</em> Hugging Face sur <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a> avec la permission d’inférer, si vous n’en avez pas déjà un.</li> <li>Allez dans votre <em>Space</em> dupliqué et cliquez sur l’onglet <strong>Settings</strong>.</li> <li>Descendez jusqu’à la section <strong>Variables and Secrets</strong> et cliquez sur <strong>New Secret</strong>.</li> <li>Créez un secret avec le nom <code>HF_TOKEN</code> et collez votre token comme valeur.</li> <li>Cliquez sur <strong>Save</strong> pour stocker votre <em>token</em> en toute sécurité.</li>',$e,R,lt='Tout au long de cette leçon, le seul fichier (actuellement incomplet) que vous aurez à modifier est le <strong>“app.py”</strong>. Vous pouvez consulter l’<a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original ici</a>. Pour trouver le vôtre, allez dans votre copie du <em>Space</em>, cliquez sur l’onglet <code>Files</code> puis sur <code>app.py</code> dans la liste des répertoires.',Ye,k,tt="Analysons le code ensemble :",Pe,X,st="<li>Le fichier commence par quelques importations de bibliothèques simples mais nécessaires</li>",De,N,Ke,q,nt="Comme indiqué précédemment, nous utiliserons directement la classe <strong>CodeAgent</strong> de <strong>smolagents</strong>.",Oe,F,el,L,at='Entrons maintenant dans le vif du sujet avec les outils ! Si vous souhaitez un rappel sur les outils, n’hésitez pas à consulter la section <a href="tools">Outils</a> du cours.',ll,$,tl,Y,it="Les outils sont ce que nous vous encourageons à construire dans cette section ! Nous vous donnons deux exemples :",sl,P,ot="<li>Un <strong>outil factice non fonctionnel</strong> que vous pouvez modifier pour créer quelque chose d’utile.</li> <li>Un <strong>outil réellement fonctionnel</strong> qui récupère l’heure actuelle quelque part dans le monde.</li>",nl,D,rt="Pour définir votre outil, il est important de :",al,K,Mt="<li>Fournir des types d’entrée et de sortie pour votre fonction, comme dans <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li>Fournir une <strong>docstring bien formatée</strong>. <code>smolagents</code> s’attend à ce que tous les arguments aient une <strong>description textuelle dans la docstring</strong>.</li>",il,O,ol,ee,pt='Il utilise <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> comme moteur LLM. C’est un modèle très performant auquel nous accéderons via l’API <em>serverless</em>.',rl,le,Ml,te,ut="Cet agent utilise toujours l’<code>InferenceClient</code> que nous avons vu dans une section précédente derrière la classe <strong>InferenceClientModel</strong> !",pl,se,ct="Nous fournirons des exemples plus détaillés lors de la présentation du <em>framework</em> dans l’Unité 2. Pour l’instant, vous devez vous concentrer sur <strong>l’ajout de nouveaux outils à la liste des outils</strong> en utilisant le paramètre <code>tools</code> de votre agent.",ul,ne,mt="Par exemple, vous pourriez utiliser <code>DuckDuckGoSearchTool</code> qui a été importé dans la première ligne du code, ou vous pouvez examiner <code>image_generation_tool</code> qui est chargé depuis le Hub plus tard dans le code.",cl,ae,yt="<strong>Ajouter des outils donnera de nouvelles capacités à votre agent</strong>, alors soyez créatif !",ml,ie,yl,oe,Jt="Le <em>prompt</em> système de l’agent est stocké dans un fichier <code>prompts.yaml</code> séparé. Ce fichier contient des instructions prédéfinies qui guident le comportement de l’agent.",Jl,re,dt="Le stockage des <em>prompts</em> dans un fichier YAML permet une personnalisation et une réutilisation aisées pour différents agents ou cas d’utilisation.",dl,Me,Tt='Vous pouvez consulter la <a href="https://huggingface.co/spaces/agents-course/First_agent_template/tree/main" rel="nofollow">structure des fichiers du <em>Space</em></a> pour voir où se trouve le fichier <code>prompts.yaml</code> et comment il est organisé dans le projet.',Tl,pe,wt="Le fichier complet <strong>“app.py”</strong> :",wl,ue,jl,ce,jt="Votre <strong>objectif</strong> est de vous familiariser avec le <em>Space</em> et l’agent.",Ul,me,Ut="Actuellement, l’agent dans le patron <strong>n’utilise aucun outil, alors essayez de lui fournir certains des outils préfabriqués ou même de créer de nouveaux outils vous-même !</strong>",bl,ye,bt="Nous attendons avec impatience vos incroyables agents dans le canal Discord <strong>#agents-course-showcase</strong>!",Il,hl,vl,Je,It="Félicitations, vous avez construit votre premier Agent ! N’hésitez pas à le partager avec vos amis et collègues.",fl,de,ht="Comme c’est votre première tentative, il est tout à fait normal qu’il soit un peu bogué ou lent. Dans les unités futures, nous apprendrons à construire de meilleurs agents.",gl,Te,vt="La meilleure façon d’apprendre est d’essayer, alors n’hésitez pas à le mettre à jour, à ajouter plus d’outils, à essayer avec un autre modèle, etc.",Cl,we,ft="Dans la prochaine section, vous allez remplir le quiz final et obtenir votre certificat !",Bl,je,Zl,Ie,Gl;return w=new xt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new Ue({props:{title:"Créons notre premier agent avec smolagents",local:"créons-notre-premier-agent-avec-smolagents",headingTag:"h1"}}),v=new Ue({props:{title:"Qu’est-ce que smolagents ?",local:"quest-ce-que-smolagents-",headingTag:"h2"}}),W=new Ue({props:{title:"Construisons notre agent !",local:"construisons-notre-agent-",headingTag:"h2"}}),N=new Vl({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEZpbmFsQW5zd2VyVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTIwbG9hZF90b29sJTJDJTIwdG9vbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBweXR6JTBBaW1wb3J0JTIweWFtbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml`,wrap:!1}}),F=new Ue({props:{title:"Les outils",local:"les-outils",headingTag:"h3"}}),$=new Vl({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1: <span class="hljs-built_in">str</span>, arg2: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:  <span class="hljs-comment"># il est important de spécifier le type de retour</span>
    <span class="hljs-comment"># Conservez ce format pour la description de l&#x27;outil et des arguments, mais n&#x27;hésitez pas à modifier l&#x27;outil</span>
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui ne fait encore rien
    Arguments:
        arg1: le premier argument
        arg2: le deuxième argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Quelle magie allez-vous créer ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui récupère l&#x27;heure locale actuelle dans un fuseau horaire spécifié.
    Arguments:
        timezone: Une chaîne représentant un fuseau horaire valide (par exemple, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Créer l&#x27;objet fuseau horaire</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtenir l&#x27;heure actuelle dans ce fuseau horaire</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;L&#x27;heure locale actuelle dans <span class="hljs-subst">{timezone}</span> est : <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Erreur lors de la récupération de l&#x27;heure pour le fuseau horaire &#x27;<span class="hljs-subst">{timezone}</span>&#x27; : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),O=new Ue({props:{title:"L’agent",local:"lagent",headingTag:"h3"}}),le=new Vl({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QyMDk2JTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QnJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JvbGVfY29udmVyc2lvbnMlM0ROb25lJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVuKCUyMnByb21wdHMueWFtbCUyMiUyQyUyMCdyJyklMjBhcyUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlMjAlM0QlMjB5YW1sLnNhZmVfbG9hZChzdHJlYW0pJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwTm91cyUyMGNyJUMzJUE5b25zJTIwbm90cmUlMjBDb2RlQWdlbnQlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJmaW5hbF9hbnN3ZXIlNUQlMkMlMjAlMjAlMjMlMjBham91dGV6JTIwdm9zJTIwb3V0aWxzJTIwaWNpJTIwKG5lJTIwc3VwcHJpbWV6JTIwcGFzJTIwZmluYWxfYW5zd2VyKSUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDYlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ3JhbW1hciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBwbGFubmluZ19pbnRlcnZhbCUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlM0Rwcm9tcHRfdGVtcGxhdGVzJTBBKSUwQSUwQUdyYWRpb1VJKGFnZW50KS5sYXVuY2goKQ==",highlighted:`final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># Nous créons notre CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer],  <span class="hljs-comment"># ajoutez vos outils ici (ne supprimez pas final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),ie=new Ue({props:{title:"Le prompt système",local:"le-prompt-système",headingTag:"h3"}}),ue=new Vl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Voici un exemple d&#x27;un outil qui ne fait encore rien. Épatez-nous avec votre créativité !</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1: <span class="hljs-built_in">str</span>, arg2: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:  <span class="hljs-comment"># il est important de spécifier le type de retour</span>
    <span class="hljs-comment"># Conservez ce format pour la description de l&#x27;outil et des arguments, mais n&#x27;hésitez pas à modifier l&#x27;outil</span>
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui ne fait encore rien
    Arguments:
        arg1: le premier argument
        arg2: le deuxième argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Quelle magie allez-vous créer ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui récupère l&#x27;heure locale actuelle dans un fuseau horaire spécifié.
    Arguments:
        timezone: Une chaîne représentant un fuseau horaire valide (par exemple, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Créer l&#x27;objet fuseau horaire</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtenir l&#x27;heure actuelle dans ce fuseau horaire</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;L&#x27;heure locale actuelle dans <span class="hljs-subst">{timezone}</span> est : <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Erreur lors de la récupération de l&#x27;heure pour le fuseau horaire &#x27;<span class="hljs-subst">{timezone}</span>&#x27; : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-comment"># Importer l&#x27;outil depuis le Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer],  <span class="hljs-comment"># ajoutez vos outils ici (ne supprimez pas final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates <span class="hljs-comment"># Transmettre le prompt du système à CodeAgent</span>
)

GradioUI(agent).launch()`,wrap:!1}}),je=new Wt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit1/tutorial.mdx"}}),{c(){T=i("meta"),he=n(),be=i("p"),ve=n(),u(w.$$.fragment),fe=n(),u(j.$$.fragment),ge=n(),U=i("p"),U.innerHTML=Al,Ce=n(),b=i("p"),b.innerHTML=_l,Be=n(),I=i("p"),I.innerHTML=El,Ze=n(),h=i("p"),h.textContent=Hl,Ge=n(),u(v.$$.fragment),Ve=n(),f=i("img"),ze=n(),g=i("p"),g.innerHTML=Sl,xe=n(),C=i("p"),C.textContent=Rl,We=n(),B=i("p"),B.innerHTML=kl,Ae=n(),Z=i("p"),Z.innerHTML=Xl,_e=n(),G=i("p"),G.textContent=Nl,Ee=n(),V=i("p"),V.innerHTML=ql,He=n(),z=i("p"),z.innerHTML=Fl,Qe=n(),M=i("iframe"),Se=n(),x=i("p"),x.textContent=$l,Re=n(),u(W.$$.fragment),ke=n(),A=i("p"),A.innerHTML=Yl,Xe=n(),_=i("blockquote"),_.innerHTML=Pl,Ne=n(),E=i("p"),E.innerHTML=Dl,qe=n(),H=i("img"),Fe=n(),Q=i("p"),Q.innerHTML=Ol,Le=n(),S=i("ol"),S.innerHTML=et,$e=n(),R=i("p"),R.innerHTML=lt,Ye=n(),k=i("p"),k.textContent=tt,Pe=n(),X=i("ul"),X.innerHTML=st,De=n(),u(N.$$.fragment),Ke=n(),q=i("p"),q.innerHTML=nt,Oe=n(),u(F.$$.fragment),el=n(),L=i("p"),L.innerHTML=at,ll=n(),u($.$$.fragment),tl=n(),Y=i("p"),Y.textContent=it,sl=n(),P=i("ol"),P.innerHTML=ot,nl=n(),D=i("p"),D.textContent=rt,al=n(),K=i("ol"),K.innerHTML=Mt,il=n(),u(O.$$.fragment),ol=n(),ee=i("p"),ee.innerHTML=pt,rl=n(),u(le.$$.fragment),Ml=n(),te=i("p"),te.innerHTML=ut,pl=n(),se=i("p"),se.innerHTML=ct,ul=n(),ne=i("p"),ne.innerHTML=mt,cl=n(),ae=i("p"),ae.innerHTML=yt,ml=n(),u(ie.$$.fragment),yl=n(),oe=i("p"),oe.innerHTML=Jt,Jl=n(),re=i("p"),re.innerHTML=dt,dl=n(),Me=i("p"),Me.innerHTML=Tt,Tl=n(),pe=i("p"),pe.innerHTML=wt,wl=n(),u(ue.$$.fragment),jl=n(),ce=i("p"),ce.innerHTML=jt,Ul=n(),me=i("p"),me.innerHTML=Ut,bl=n(),ye=i("p"),ye.innerHTML=bt,Il=n(),hl=i("hr"),vl=n(),Je=i("p"),Je.textContent=It,fl=n(),de=i("p"),de.textContent=ht,gl=n(),Te=i("p"),Te.textContent=vt,Cl=n(),we=i("p"),we.textContent=ft,Bl=n(),u(je.$$.fragment),Zl=n(),Ie=i("p"),this.h()},l(e){const l=Vt("svelte-u9bgzb",document.head);T=o(l,"META",{name:!0,content:!0}),l.forEach(t),he=a(e),be=o(e,"P",{}),xl(be).forEach(t),ve=a(e),c(w.$$.fragment,e),fe=a(e),c(j.$$.fragment,e),ge=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-qs4xjg"&&(U.innerHTML=Al),Ce=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1q75a4l"&&(b.innerHTML=_l),Be=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ywod5z"&&(I.innerHTML=El),Ze=a(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-13o0trz"&&(h.textContent=Hl),Ge=a(e),c(v.$$.fragment,e),Ve=a(e),f=o(e,"IMG",{src:!0,alt:!0}),ze=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-dbtthn"&&(g.innerHTML=Sl),xe=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1bcgvwk"&&(C.textContent=Rl),We=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1yc3dh6"&&(B.innerHTML=kl),Ae=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-a02t0l"&&(Z.innerHTML=Xl),_e=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-x6axr8"&&(G.textContent=Nl),Ee=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-8v2mq6"&&(V.innerHTML=ql),He=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-jhlkvg"&&(z.innerHTML=Fl),Qe=a(e),M=o(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),xl(M).forEach(t),Se=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1gth0ux"&&(x.textContent=$l),Re=a(e),c(W.$$.fragment,e),ke=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1nhw6j"&&(A.innerHTML=Yl),Xe=a(e),_=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(_)!=="svelte-17wqgsx"&&(_.innerHTML=Pl),Ne=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-a592en"&&(E.innerHTML=Dl),qe=a(e),H=o(e,"IMG",{src:!0,alt:!0}),Fe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-13lr74u"&&(Q.innerHTML=Ol),Le=a(e),S=o(e,"OL",{"data-svelte-h":!0}),r(S)!=="svelte-1rl24xt"&&(S.innerHTML=et),$e=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-o6yf0f"&&(R.innerHTML=lt),Ye=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1azrb"&&(k.textContent=tt),Pe=a(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-118pf10"&&(X.innerHTML=st),De=a(e),c(N.$$.fragment,e),Ke=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1m3exlv"&&(q.innerHTML=nt),Oe=a(e),c(F.$$.fragment,e),el=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ar0zqh"&&(L.innerHTML=at),ll=a(e),c($.$$.fragment,e),tl=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-193l0gp"&&(Y.textContent=it),sl=a(e),P=o(e,"OL",{"data-svelte-h":!0}),r(P)!=="svelte-1petlbb"&&(P.innerHTML=ot),nl=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-qbfp30"&&(D.textContent=rt),al=a(e),K=o(e,"OL",{"data-svelte-h":!0}),r(K)!=="svelte-1opewe3"&&(K.innerHTML=Mt),il=a(e),c(O.$$.fragment,e),ol=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1fhn4cw"&&(ee.innerHTML=pt),rl=a(e),c(le.$$.fragment,e),Ml=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-80mzrd"&&(te.innerHTML=ut),pl=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-14umwg7"&&(se.innerHTML=ct),ul=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1d4myhn"&&(ne.innerHTML=mt),cl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-vatkzs"&&(ae.innerHTML=yt),ml=a(e),c(ie.$$.fragment,e),yl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1ccs376"&&(oe.innerHTML=Jt),Jl=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-94hajw"&&(re.innerHTML=dt),dl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-wgpiab"&&(Me.innerHTML=Tt),Tl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-ubbbh5"&&(pe.innerHTML=wt),wl=a(e),c(ue.$$.fragment,e),jl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-pj2es1"&&(ce.innerHTML=jt),Ul=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-g8nes"&&(me.innerHTML=Ut),bl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-kizn95"&&(ye.innerHTML=bt),Il=a(e),hl=o(e,"HR",{}),vl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1ntujpe"&&(Je.textContent=It),fl=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-kpv7xu"&&(de.textContent=ht),gl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-fowehc"&&(Te.textContent=vt),Cl=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-w5fwm2"&&(we.textContent=ft),Bl=a(e),c(je.$$.fragment,e),Zl=a(e),Ie=o(e,"P",{}),xl(Ie).forEach(t),this.h()},h(){p(T,"name","hf:doc:metadata"),p(T,"content",_t),zl(f.src,Ql="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||p(f,"src",Ql),p(f,"alt","smolagents"),p(M,"width","560"),p(M,"height","315"),zl(M.src,Ll="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||p(M,"src",Ll),p(M,"title","YouTube video player"),p(M,"frameborder","0"),p(M,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),p(M,"referrerpolicy","strict-origin-when-cross-origin"),M.allowFullscreen="",zl(H.src,Kl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||p(H,"src",Kl),p(H,"alt","Duplicate")},m(e,l){zt(document.head,T),s(e,he,l),s(e,be,l),s(e,ve,l),m(w,e,l),s(e,fe,l),m(j,e,l),s(e,ge,l),s(e,U,l),s(e,Ce,l),s(e,b,l),s(e,Be,l),s(e,I,l),s(e,Ze,l),s(e,h,l),s(e,Ge,l),m(v,e,l),s(e,Ve,l),s(e,f,l),s(e,ze,l),s(e,g,l),s(e,xe,l),s(e,C,l),s(e,We,l),s(e,B,l),s(e,Ae,l),s(e,Z,l),s(e,_e,l),s(e,G,l),s(e,Ee,l),s(e,V,l),s(e,He,l),s(e,z,l),s(e,Qe,l),s(e,M,l),s(e,Se,l),s(e,x,l),s(e,Re,l),m(W,e,l),s(e,ke,l),s(e,A,l),s(e,Xe,l),s(e,_,l),s(e,Ne,l),s(e,E,l),s(e,qe,l),s(e,H,l),s(e,Fe,l),s(e,Q,l),s(e,Le,l),s(e,S,l),s(e,$e,l),s(e,R,l),s(e,Ye,l),s(e,k,l),s(e,Pe,l),s(e,X,l),s(e,De,l),m(N,e,l),s(e,Ke,l),s(e,q,l),s(e,Oe,l),m(F,e,l),s(e,el,l),s(e,L,l),s(e,ll,l),m($,e,l),s(e,tl,l),s(e,Y,l),s(e,sl,l),s(e,P,l),s(e,nl,l),s(e,D,l),s(e,al,l),s(e,K,l),s(e,il,l),m(O,e,l),s(e,ol,l),s(e,ee,l),s(e,rl,l),m(le,e,l),s(e,Ml,l),s(e,te,l),s(e,pl,l),s(e,se,l),s(e,ul,l),s(e,ne,l),s(e,cl,l),s(e,ae,l),s(e,ml,l),m(ie,e,l),s(e,yl,l),s(e,oe,l),s(e,Jl,l),s(e,re,l),s(e,dl,l),s(e,Me,l),s(e,Tl,l),s(e,pe,l),s(e,wl,l),m(ue,e,l),s(e,jl,l),s(e,ce,l),s(e,Ul,l),s(e,me,l),s(e,bl,l),s(e,ye,l),s(e,Il,l),s(e,hl,l),s(e,vl,l),s(e,Je,l),s(e,fl,l),s(e,de,l),s(e,gl,l),s(e,Te,l),s(e,Cl,l),s(e,we,l),s(e,Bl,l),m(je,e,l),s(e,Zl,l),s(e,Ie,l),Gl=!0},p:Ct,i(e){Gl||(y(w.$$.fragment,e),y(j.$$.fragment,e),y(v.$$.fragment,e),y(W.$$.fragment,e),y(N.$$.fragment,e),y(F.$$.fragment,e),y($.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(ie.$$.fragment,e),y(ue.$$.fragment,e),y(je.$$.fragment,e),Gl=!0)},o(e){J(w.$$.fragment,e),J(j.$$.fragment,e),J(v.$$.fragment,e),J(W.$$.fragment,e),J(N.$$.fragment,e),J(F.$$.fragment,e),J($.$$.fragment,e),J(O.$$.fragment,e),J(le.$$.fragment,e),J(ie.$$.fragment,e),J(ue.$$.fragment,e),J(je.$$.fragment,e),Gl=!1},d(e){e&&(t(he),t(be),t(ve),t(fe),t(ge),t(U),t(Ce),t(b),t(Be),t(I),t(Ze),t(h),t(Ge),t(Ve),t(f),t(ze),t(g),t(xe),t(C),t(We),t(B),t(Ae),t(Z),t(_e),t(G),t(Ee),t(V),t(He),t(z),t(Qe),t(M),t(Se),t(x),t(Re),t(ke),t(A),t(Xe),t(_),t(Ne),t(E),t(qe),t(H),t(Fe),t(Q),t(Le),t(S),t($e),t(R),t(Ye),t(k),t(Pe),t(X),t(De),t(Ke),t(q),t(Oe),t(el),t(L),t(ll),t(tl),t(Y),t(sl),t(P),t(nl),t(D),t(al),t(K),t(il),t(ol),t(ee),t(rl),t(Ml),t(te),t(pl),t(se),t(ul),t(ne),t(cl),t(ae),t(ml),t(yl),t(oe),t(Jl),t(re),t(dl),t(Me),t(Tl),t(pe),t(wl),t(jl),t(ce),t(Ul),t(me),t(bl),t(ye),t(Il),t(hl),t(vl),t(Je),t(fl),t(de),t(gl),t(Te),t(Cl),t(we),t(Bl),t(Zl),t(Ie)),t(T),d(w,e),d(j,e),d(v,e),d(W,e),d(N,e),d(F,e),d($,e),d(O,e),d(le,e),d(ie,e),d(ue,e),d(je,e)}}}const _t='{"title":"Créons notre premier agent avec smolagents","local":"créons-notre-premier-agent-avec-smolagents","sections":[{"title":"Qu’est-ce que smolagents ?","local":"quest-ce-que-smolagents-","sections":[],"depth":2},{"title":"Construisons notre agent !","local":"construisons-notre-agent-","sections":[{"title":"Les outils","local":"les-outils","sections":[],"depth":3},{"title":"L’agent","local":"lagent","sections":[],"depth":3},{"title":"Le prompt système","local":"le-prompt-système","sections":[],"depth":3}],"depth":2}],"depth":1}';function Et(Wl){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends Zt{constructor(T){super(),Gt(this,T,Et,At,gt,{})}}export{Xt as component};
