# Что такое вызов функции?

Вызов функций - это **способ, с помощью которого LLM может выполнять действия в своем окружении**. Впервые он был [введен в GPT-4](https://openai.com/index/function-calling-and-other-api-updates/), и затем был воспроизведен в других моделях.

Как и инструменты агента, вызов функций дает модели возможность **осуществлять действия в своем окружении**. Однако способность к вызову функций **приобретается моделью в процессе обучения**, и она **меньше зависит от подсказок, чем другие техники агентов**.

В разделе 1 Агент **не учился использовать инструменты**, мы просто предоставили список, и мы полагались на то, что модель **способна обобщить определение плана с помощью этих инструментов**. 

В то время как здесь агент **дообучается (тренируется) использовать инструменты с помощью вызова функций**.

## Как модель "учится" выполнять то или иное действие?

В первом разделе мы рассмотрели общий процесс работы агента. После того как пользователь предоставит агенту некоторые инструменты и сформулирует запрос, модель выполнит следующий цикл:

1. *Рассуждение* : Какое действие (действия) мне нужно предпринять, чтобы выполнить поставленную задачу.
2. *Действие* : Сформирует действие с нужным параметром и остановите генерацию.
3. *Наблюдение* : Получить результат выполнения.

В "типичном" диалоге с моделью через API, диалог будет чередоваться сообщениями пользователя и ассистента следующим образом:

```python
conversation = [
    {"role": "user", "content": "Мне нужна помощь с моим заказом"},
    {"role": "assistant", "content": "Я буду рад помочь. Не могли бы вы сообщить номер вашего заказа?"},
    {"role": "user", "content": "Это ЗАКАЗ-123"},
]
```

Вызов функций привносит **новые роли в диалог**! 

1. Одна новая роль для **Действия** 
2. Одна новая роль для **Наблюдения**

Если мы возьмем [Mistral API](https://docs.mistral.ai/capabilities/function_calling/) в качестве примера, это будет выглядеть так:

```python
conversation = [
    {
        "role": "user",
        "content": "Каков статус моей транзакции T1001?"
    },
    {
        "role": "assistant",
        "content": "",
        "function_call": {
            "name": "retrieve_payment_status",
            "arguments": "{\"transaction_id\": \"T1001\"}"
        }
    },
    {
        "role": "tool",
        "name": "retrieve_payment_status",
        "content": "{\"status\": \"Paid\"}"
    },
    {
        "role": "assistant",
        "content": "Ваша транзакция T1001 была успешно оплачена."
    }
]
```

> ... Но вы сказали, что есть новая роль для вызова функций?

**Да и нет**, в этом случае, как и во многих других API, модель форматирует действие, которое нужно выполнить, как сообщение "ассистенту". Затем шаблон чата представит это в виде **специальных токенов** для вызова функций.

- `[AVAILABLE_TOOLS]` - начать список доступных инструментов 
- `[/AVAILABLE_TOOLS]` - завершить список доступных инструментов 
- `[TOOL_CALLS]` - Сделать вызов инструмента (т.е. выполнить "Действие") 
- `[TOOL_RESULTS]` - "Наблюдать" результат действия 
- `[/TOOL_RESULTS]` - Завершение наблюдение (т.е. модель может снова декодировать)

Мы еще поговорим о вызовах функций в этом курсе, но если вы хотите погрузиться глубже, то можете ознакомиться с [этим отличным разделом документации](https://docs.mistral.ai/capabilities/function_calling/)

---
Теперь, когда мы узнали, что такое вызов функций и как он работает, давайте **добавим некоторые возможности вызова функций к модели, которая еще не имеет таких возможностей**: **"google/gemma-2-2b-it"**, добавив в модель несколько новых специальных токенов.

Чтобы сделать это, **нам нужно сначала понять, что такое дообучение и LoRA**.

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ru-RU/bonus-unit1/what-is-function-calling.mdx" />