# Понимание AI Агентов через цикл Мысль - Действие - Наблюдение.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-3.jpg" alt="Раздел 1 планирование"/>

В предыдущих разделах мы узнали:

- **Как инструменты становятся доступны агенту в системной подсказке**.
- **Как AI агенты являются системами, которые могут 'рассуждать', планировать и взаимодействовать с окружающей средой**.

В этом разделе **мы рассмотрим рабочий процесс агента AI полностью**, цикл, который мы определили как "Мысль - Действие - Наблюдение". 

А затем мы углубимся в каждый из этих этапов.


## Основные компоненты

Агенты работают в непрерывном цикле: **думать (Мысль) → действовать (Действие) и наблюдать (Наблюдение)**.

Давайте разложим эти действия на составляющие:

1. **Мысль**: LLM-часть Агента решает, каким должен быть следующий шаг.
2. **Действие:** Агент выполняет действие, вызывая инструменты с соответствующими аргументами.
3. **Наблюдение:** Модель размышляет над ответом, полученным от инструмента.

## Цикл "Мысль-Действие-Наблюдение"

Все три компонента работают вместе в непрерывном цикле. Если воспользоваться аналогией из программирования, агент использует **цикл while**: цикл продолжается до тех пор, пока не будет выполнена поставленная перед агентом задача.

Визуально это выглядит следующим образом:

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/AgentCycle.gif" alt="Цикл Думай, Действуй, Наблюдай"/>

Во многих фреймворках Агентов **правила и рекомендации встраиваются непосредственно в системную подсказку**, гарантируя, что каждый цикл будет следовать определенной логике.

В упрощенном варианте наша системная подсказка может выглядеть следующим образом:

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/system_prompt_cycle.png" alt="Цикл Думай, Действуй, Наблюдай"/>

Здесь мы видим, что в системном сообщении мы определили :

- *Поведение Агента*.
- *Инструменты, к которым имеет доступ наш Агент*, как мы описали в предыдущем разделе.
- Цикл *Мысль-Действие-Наблюдение*, который мы заложили в инструкции LLM.

Давайте рассмотрим небольшой пример, чтобы понять суть процесса, прежде чем углубляться в каждый его шаг.

## Альфред, Агент сообщающий погоду

Мы создали Альфреда, погодного агента.

Пользователь спрашивает Альфреда: «Какая сегодня погода в Нью-Йорке?».

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/alfred-agent.jpg" alt="Агент Альфред"/>

Задача Альфреда - ответить на этот запрос, используя инструмент API погоды. 

Вот как выглядит этот цикл:

### Мысль

**Внутренние рассуждения:**

Получив запрос, внутренний диалог Альфреда может быть таким:

*"Пользователю нужна текущая информация о погоде в Нью-Йорке. У меня есть доступ к инструменту, который получает данные о погоде. Сначала мне нужно обратиться к API погоды, чтобы получить актуальную информацию."*

Этот шаг показывает, что агент разбивает проблему на этапы: сначала собирает необходимые данные.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/alfred-agent-1.jpg" alt="Агент Альфред"/>

### Действие

**Использование инструмента:**.

Основываясь на своих рассуждениях и на том факте, что Альфред знает об инструменте `get_weather`, Альфред подготавливает команду в формате JSON, которая вызывает инструмент API погоды. Например, его первым действием может быть:

Мысль: Мне нужно проверить текущую погоду в Нью-Йорке.

 ```
    {
      "action": "get_weather",
      "action_input": {
        "location": "New York"
      }
    }
 ```

Здесь действие четко указывает, какой инструмент следует вызвать (например, get_weather) и какой параметр передать ("location": "New York").

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/alfred-agent-2.jpg" alt="Агент Альфред"/>

### Наблюдение

**Обратная связь от окружающей среды:**.

После вызова инструмента Альфред получает наблюдение. Это могут быть необработанные данные о погоде из API, например:

*"Текущая погода в Нью-Йорке: частично облачно, 15°C, влажность 60%."*

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/alfred-agent-3.jpg" alt="Агент Альфред"/>

Это наблюдение затем добавляется к подсказке в качестве дополнительного контекста. Оно функционирует как обратная связь в реальном мире, подтверждая успешность действия и предоставляя необходимые детали.


### Обновленная мысль

**Рефлексия:**

Получив данные наблюдения, Альфред обновляет свои внутренние рассуждения:

*"Теперь, когда у меня есть данные о погоде в Нью-Йорке, я могу подготовить ответ для пользователя."*

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/alfred-agent-4.jpg" alt="Агент Альфред"/>


### Финальное Действие

Затем Алфред генерирует окончательный ответ, отформатированный так, как мы ему сказали:

Мысль: У меня есть данные о погоде. Текущая погода в Нью-Йорке частично облачная, температура 15 °C и влажность 60 %».

Окончательный ответ : Текущая погода в Нью-Йорке частично облачно с температурой 15 °C и влажностью 60 %.

Это заключительное действие возвращает ответ пользователю, закрывая цикл.


<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/alfred-agent-5.jpg" alt="Агент Альфред"/>


Что мы видим в этом примере:

- **Агенты проходят цикл до тех пор, пока цель не будет достигнута:**

**Процесс Альфреда цикличен**. Он начинает с мысли, затем действует, вызывая инструмент, и, наконец, наблюдает за результатом. Если бы наблюдение показало ошибку или неполноту данных, Альфред мог бы снова войти в цикл, чтобы скорректировать свой подход.

- **Интеграция инструментов:**

Способность вызывать инструменты (например, API погоды) позволяет Альфреду выходить **за пределы статических знаний и получать данные в реальном времени**, что является важным аспектом многих AI Агентов.

- **Динамическая адаптация:**

Каждый цикл позволяет агенту включать свежую информацию (наблюдения) в свои рассуждения (мысли), гарантируя, что окончательный ответ будет хорошо обоснованным и точным.

Этот пример демонстрирует основную концепцию цикла *ReAct* (концепцию, которую мы будем развивать в следующем разделе): **взаимодействие мыслей, действий и наблюдений позволяет AI агентам решать сложные задачи итеративно**. 

Понимая и применяя эти принципы, вы сможете разрабатывать агентов, которые не только рассуждают о своих задачах, но и **эффективно используют внешние инструменты для их выполнения**, при этом постоянно совершенствуя свои действия на основе обратной связи от окружающей среды.

---

Теперь давайте углубимся в изучение Мысли, Действия, Наблюдения как отдельных этапов этого процесса.


<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/ru-RU/unit1/agent-steps-and-structure.mdx" />