import{s as Je,a as Ct,n as we,o as ce}from"../chunks/scheduler.505acc25.js";import{S as Ue,i as ue,e as M,s as n,c as m,h as be,a as p,d as e,b as a,f as Bt,g as r,j as i,k as y,l as de,m as s,n as j,t as T,o as J,p as w}from"../chunks/index.b1175496.js";import{C as he,H as Ul}from"../chunks/Heading.eda51538.js";import{C as It}from"../chunks/CodeBlock.9d480d26.js";import{E as Ie}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.ea377ea6.js";function Ce(ft){let c,ul,wl,bl,U,dl,u,hl,b,gt="在上一节中，我们学习了如何使用 Python 代码从头开始创建智能体，并且我们<strong>看到了这个过程是多么繁琐</strong>。幸运的是，许多智能体库通过<strong>为你处理大量繁重的工作</strong>来简化这项工作。",Il,d,Zt="在本教程中，<strong>你将创建你的第一个智能体</strong>，它能够执行图像生成、网络搜索、时区检查等更多操作！",Cl,h,vt="你还将把你的智能体<strong>发布到 Hugging Face Space 上，以便与朋友和同事分享</strong>。",Bl,I,Gt="让我们开始吧！",fl,C,gl,B,At,Zl,f,Wt="为了创建这个智能体，我们将使用 <code>smolagents</code>，这是一个<strong>提供轻松开发智能体框架的库</strong>。",vl,g,_t="这个轻量级库设计简洁，但它抽象了构建智能体的许多复杂性，使你能够专注于设计智能体的行为。",Gl,Z,Ht='我们将在下一个单元中深入了解 smolagents。同时，你也可以查看这篇<a href="https://huggingface.co/blog/smolagents" target="_blank">博客文章</a>或该库的<a href="https://github.com/huggingface/smolagents" target="_blank">GitHub 仓库</a>。',Al,v,Et="简而言之，<code>smolagents</code> 是一个专注于 <strong>codeAgent</strong> 的库，codeAgent 是一种通过代码块执行<strong>“操作”</strong>，然后通过执行代码<strong>“观察”</strong>结果的智能体。",Wl,G,xt="以下是我们将构建的一个示例！",_l,A,Vt="我们为我们的智能体提供了一个<strong>图像生成工具</strong>，并要求它生成一张猫的图片。",Hl,W,Rt="<code>smolagents</code> 中的智能体将具有<strong>与我们之前构建的自定义智能体相同的行为</strong>：它将<strong>以循环的方式思考、行动和观察</strong>，直到得出最终答案：",El,o,kt,xl,_,Qt="很令人兴奋，对吧？",Vl,H,Rl,E,St='首先，复制这个 Space：<a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',kl,x,zt='<p>感谢 <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> 提供的这个模板！🙌</p>',Ql,V,Nt="复制这个 Space 意味着<strong>在你的个人资料中创建一个本地副本</strong>：",Sl,R,Xt,zl,k,$t="复制这个 Space 之后，<strong>你需要添加你的 Hugging Face API token</strong>，以便你的<strong>智能体</strong>可以调用模型 API。",Nl,Q,Ft='<li>首先，从<a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens </a>获取一个具有<strong>推理权限</strong>的 token，第 4 步需要用到。如果你已经有了，可以跳过此步。</li> <li>进入你的主页，找到刚才复制的空间，点击<strong>设置</strong>按钮。</li> <li>向下滚动到<strong>变量和密钥</strong>部分，点击<strong>新建密钥</strong>。</li> <li>创建一个名为<strong>HF_TOKEN</strong>的密钥，值为第一步获取到的 token。</li> <li>点击<strong>保存</strong>。</li>',Xl,S,Lt='在整个课程中，你唯一需要修改的文件是当前不完整的<strong>“app.py”</strong>。你可以在这里查看<a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">模板中的原始文件</a>。要找到你的文件，请进入你复制的 Space，然后点击 <code>Files</code> 选项卡，再在目录列表中点击 <code>app.py</code>。',$l,z,Yt="让我们一起分解代码：",Fl,N,qt="<li>文件开头是一些简单但必要的库导入</li>",Ll,X,Yl,$,Pt="正如之前所述，我们将直接使用 <strong>smolagents</strong> 中的 <strong>CodeAgent</strong> 类。",ql,F,Pl,L,Dt='现在让我们来了解一下工具！如果你需要回顾一下工具的相关内容，请随时回到课程的<a href="tools">工具</a>部分。',Dl,Y,Kl,q,Kt="这些工具是我们在这个部分鼓励你构建的东西！我们给你两个例子：",Ol,P,Ot="<li>一个<strong>不工作的虚拟工具</strong>，你可以修改它来制作一些有用的东西。</li> <li>一个<strong>实际工作的工具</strong>，它可以获取世界某地的当前时间。</li>",lt,D,le="要定义你的工具，重要的是：",tt,K,te="<li>为你的函数提供输入和输出类型，例如 <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>格式良好的文档字符串</strong>。<code>smolagents</code> 期望所有参数在文档字符串中都有<strong>文字描述</strong>。</li>",et,O,st,ll,ee='它使用 <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> 作为 LLM 引擎。这是一个非常强大的模型，我们将通过无服务器 API 访问它。',nt,tl,at,el,se="这个智能体仍在使用我们在前面部分中看到的<code>InferenceClient</code>，它位于<strong>InferenceClientModel</strong>类的背后！",Mt,sl,ne="当我们介绍 Unit 2 中的框架时，我们会给出更深入的例子。目前，你需要专注于通过智能体的<code>tools</code>参数<strong>向工具列表中添加新工具</strong>。",pt,nl,ae="例如，你可以使用代码第一行导入的<code>DuckDuckGoSearchTool</code>，或者你可以检查稍后从 Hub 加载的<code>image_generation_tool</code>。",it,al,Me="<strong>添加工具将赋予你的智能体新的能力</strong>，在这里尝试发挥创意吧！",ot,Ml,pe="完整的”app.py”：",yt,pl,mt,il,ie="你的<strong>目标</strong>是熟悉 Space 和智能体。",rt,ol,oe="目前，模板中的智能体<strong>没有使用任何工具，所以尝试为它提供一些预制的工具，甚至自己动手制作一些新工具！</strong>",jt,yl,ye="我们非常期待在 Discord 频道 <strong>#agents-course-showcase</strong> 中看到你的精彩智能体成果！",Tt,Jt,wt,ml,me="恭喜你，你已经构建了你的第一个智能体！不要犹豫，与你的朋友和同事分享吧。",ct,rl,re="由于这是你的第一次尝试，如果有点小问题或速度有点慢，这是完全正常的。在未来的单元中，我们将学习如何构建更好的智能体。",Ut,jl,je="最好的学习方法是尝试，所以不要犹豫，去更新它，添加更多工具，尝试使用另一个模型，等等。",ut,Tl,Te="在下一节中，你将完成最后的测验并获得证书！",bt,Jl,dt,cl,ht;return U=new he({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new Ul({props:{title:"使用 smolagents 创建我们的第一个智能体",local:"使用-smolagents-创建我们的第一个智能体",headingTag:"h1"}}),C=new Ul({props:{title:"什么是 smolagents？",local:"什么是-smolagents",headingTag:"h2"}}),H=new Ul({props:{title:"让我们来构建我们的智能体！",local:"让我们来构建我们的智能体",headingTag:"h2"}}),X=new It({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTJDJTIwbG9hZF90b29sJTJDJTIwdG9vbCUwQWltcG9ydCUyMGRhdGV0aW1lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBweXR6JTBBaW1wb3J0JTIweWFtbCUwQWZyb20lMjB0b29scy5maW5hbF9hbnN3ZXIlMjBpbXBvcnQlMjBGaW5hbEFuc3dlclRvb2w=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),F=new Ul({props:{title:"Tool（工具）",local:"tool工具",headingTag:"h3"}}),Y=new It({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),O=new Ul({props:{title:"The Agent（智能体）",local:"the-agent智能体",headingTag:"h3"}}),tl=new It({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QyMDk2JTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUzRCdRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QnJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JvbGVfY29udmVyc2lvbnMlM0ROb25lJTJDJTBBKSUwQSUwQXdpdGglMjBvcGVuKCUyMnByb21wdHMueWFtbCUyMiUyQyUyMCdyJyklMjBhcyUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMHByb21wdF90ZW1wbGF0ZXMlMjAlM0QlMjB5YW1sLnNhZmVfbG9hZChzdHJlYW0pJTBBJTBBJTIzJTIwV2UncmUlMjBjcmVhdGluZyUyMG91ciUyMENvZGVBZ2VudCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmZpbmFsX2Fuc3dlciU1RCUyQyUyMCUyMyUyMGFkZCUyMHlvdXIlMjB0b29scyUyMGhlcmUlMjAoZG9uJ3QlMjByZW1vdmUlMjBmaW5hbF9hbnN3ZXIpJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENiUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFtbWFyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHBsYW5uaW5nX2ludGVydmFsJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUzRHByb21wdF90ZW1wbGF0ZXMlMEEpJTBBJTBBR3JhZGlvVUkoYWdlbnQpLmxhdW5jaCgp",highlighted:`final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)

<span class="hljs-comment"># We&#x27;re creating our CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),pl=new It({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Below is an example of a tool that does nothing. Amaze us with your creativity!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># it&#x27;s important to specify the return type</span>
    <span class="hljs-comment"># Keep this format for the tool description / args description but feel free to modify the tool</span>
    <span class="hljs-string">&quot;&quot;&quot;A tool that does nothing yet
    Args:
        arg1: the first argument
        arg2: the second argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;What magic will you build ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;A tool that fetches the current local time in a specified timezone.
    Args:
        timezone: A string representing a valid timezone (e.g., &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Create timezone object</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Get current time in that timezone</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;The current local time in <span class="hljs-subst">{timezone}</span> is: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching time for timezone &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = InferenceClientModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)

agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># add your tools here (don&#x27;t remove final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),Jl=new Ie({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit1/tutorial.mdx"}}),{c(){c=M("meta"),ul=n(),wl=M("p"),bl=n(),m(U.$$.fragment),dl=n(),m(u.$$.fragment),hl=n(),b=M("p"),b.innerHTML=gt,Il=n(),d=M("p"),d.innerHTML=Zt,Cl=n(),h=M("p"),h.innerHTML=vt,Bl=n(),I=M("p"),I.textContent=Gt,fl=n(),m(C.$$.fragment),gl=n(),B=M("img"),Zl=n(),f=M("p"),f.innerHTML=Wt,vl=n(),g=M("p"),g.textContent=_t,Gl=n(),Z=M("p"),Z.innerHTML=Ht,Al=n(),v=M("p"),v.innerHTML=Et,Wl=n(),G=M("p"),G.textContent=xt,_l=n(),A=M("p"),A.innerHTML=Vt,Hl=n(),W=M("p"),W.innerHTML=Rt,El=n(),o=M("iframe"),xl=n(),_=M("p"),_.textContent=Qt,Vl=n(),m(H.$$.fragment),Rl=n(),E=M("p"),E.innerHTML=St,kl=n(),x=M("blockquote"),x.innerHTML=zt,Ql=n(),V=M("p"),V.innerHTML=Nt,Sl=n(),R=M("img"),zl=n(),k=M("p"),k.innerHTML=$t,Nl=n(),Q=M("ol"),Q.innerHTML=Ft,Xl=n(),S=M("p"),S.innerHTML=Lt,$l=n(),z=M("p"),z.textContent=Yt,Fl=n(),N=M("ul"),N.innerHTML=qt,Ll=n(),m(X.$$.fragment),Yl=n(),$=M("p"),$.innerHTML=Pt,ql=n(),m(F.$$.fragment),Pl=n(),L=M("p"),L.innerHTML=Dt,Dl=n(),m(Y.$$.fragment),Kl=n(),q=M("p"),q.textContent=Kt,Ol=n(),P=M("ol"),P.innerHTML=Ot,lt=n(),D=M("p"),D.textContent=le,tt=n(),K=M("ol"),K.innerHTML=te,et=n(),m(O.$$.fragment),st=n(),ll=M("p"),ll.innerHTML=ee,nt=n(),m(tl.$$.fragment),at=n(),el=M("p"),el.innerHTML=se,Mt=n(),sl=M("p"),sl.innerHTML=ne,pt=n(),nl=M("p"),nl.innerHTML=ae,it=n(),al=M("p"),al.innerHTML=Me,ot=n(),Ml=M("p"),Ml.textContent=pe,yt=n(),m(pl.$$.fragment),mt=n(),il=M("p"),il.innerHTML=ie,rt=n(),ol=M("p"),ol.innerHTML=oe,jt=n(),yl=M("p"),yl.innerHTML=ye,Tt=n(),Jt=M("hr"),wt=n(),ml=M("p"),ml.textContent=me,ct=n(),rl=M("p"),rl.textContent=re,Ut=n(),jl=M("p"),jl.textContent=je,ut=n(),Tl=M("p"),Tl.textContent=Te,bt=n(),m(Jl.$$.fragment),dt=n(),cl=M("p"),this.h()},l(l){const t=be("svelte-u9bgzb",document.head);c=p(t,"META",{name:!0,content:!0}),t.forEach(e),ul=a(l),wl=p(l,"P",{}),Bt(wl).forEach(e),bl=a(l),r(U.$$.fragment,l),dl=a(l),r(u.$$.fragment,l),hl=a(l),b=p(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1ujhsd9"&&(b.innerHTML=gt),Il=a(l),d=p(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1fz25zu"&&(d.innerHTML=Zt),Cl=a(l),h=p(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-vbbf2l"&&(h.innerHTML=vt),Bl=a(l),I=p(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-izpy37"&&(I.textContent=Gt),fl=a(l),r(C.$$.fragment,l),gl=a(l),B=p(l,"IMG",{src:!0,alt:!0}),Zl=a(l),f=p(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1p4ogmz"&&(f.innerHTML=Wt),vl=a(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1rnyukb"&&(g.textContent=_t),Gl=a(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-eka5kk"&&(Z.innerHTML=Ht),Al=a(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1terpmt"&&(v.innerHTML=Et),Wl=a(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-teea68"&&(G.textContent=xt),_l=a(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1rvw3dn"&&(A.innerHTML=Vt),Hl=a(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-k9hzof"&&(W.innerHTML=Rt),El=a(l),o=p(l,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),Bt(o).forEach(e),xl=a(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-zp6tm6"&&(_.textContent=Qt),Vl=a(l),r(H.$$.fragment,l),Rl=a(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1ga3nhy"&&(E.innerHTML=St),kl=a(l),x=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(x)!=="svelte-1szeww4"&&(x.innerHTML=zt),Ql=a(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1lf9he9"&&(V.innerHTML=Nt),Sl=a(l),R=p(l,"IMG",{src:!0,alt:!0}),zl=a(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1nok7td"&&(k.innerHTML=$t),Nl=a(l),Q=p(l,"OL",{"data-svelte-h":!0}),i(Q)!=="svelte-17jk4t5"&&(Q.innerHTML=Ft),Xl=a(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1rvndzh"&&(S.innerHTML=Lt),$l=a(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-qzw9ae"&&(z.textContent=Yt),Fl=a(l),N=p(l,"UL",{"data-svelte-h":!0}),i(N)!=="svelte-7zqdyp"&&(N.innerHTML=qt),Ll=a(l),r(X.$$.fragment,l),Yl=a(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-193ax9h"&&($.innerHTML=Pt),ql=a(l),r(F.$$.fragment,l),Pl=a(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1y6flx0"&&(L.innerHTML=Dt),Dl=a(l),r(Y.$$.fragment,l),Kl=a(l),q=p(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-txzape"&&(q.textContent=Kt),Ol=a(l),P=p(l,"OL",{"data-svelte-h":!0}),i(P)!=="svelte-1nki85t"&&(P.innerHTML=Ot),lt=a(l),D=p(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-e5waqh"&&(D.textContent=le),tt=a(l),K=p(l,"OL",{"data-svelte-h":!0}),i(K)!=="svelte-3glxb2"&&(K.innerHTML=te),et=a(l),r(O.$$.fragment,l),st=a(l),ll=p(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-15wg5ed"&&(ll.innerHTML=ee),nt=a(l),r(tl.$$.fragment,l),at=a(l),el=p(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-o63072"&&(el.innerHTML=se),Mt=a(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-1trmkgr"&&(sl.innerHTML=ne),pt=a(l),nl=p(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-1r29o7"&&(nl.innerHTML=ae),it=a(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-1ex3pg"&&(al.innerHTML=Me),ot=a(l),Ml=p(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1islpf0"&&(Ml.textContent=pe),yt=a(l),r(pl.$$.fragment,l),mt=a(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1mbhzkl"&&(il.innerHTML=ie),rt=a(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1scg4wp"&&(ol.innerHTML=oe),jt=a(l),yl=p(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-o093cv"&&(yl.innerHTML=ye),Tt=a(l),Jt=p(l,"HR",{}),wt=a(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-r2adc4"&&(ml.textContent=me),ct=a(l),rl=p(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-1eae468"&&(rl.textContent=re),Ut=a(l),jl=p(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-1vfq4lx"&&(jl.textContent=je),ut=a(l),Tl=p(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-o18u8f"&&(Tl.textContent=Te),bt=a(l),r(Jl.$$.fragment,l),dt=a(l),cl=p(l,"P",{}),Bt(cl).forEach(e),this.h()},h(){y(c,"name","hf:doc:metadata"),y(c,"content",Be),Ct(B.src,At="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||y(B,"src",At),y(B,"alt","smolagents"),y(o,"width","560"),y(o,"height","315"),Ct(o.src,kt="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||y(o,"src",kt),y(o,"title","YouTube video player"),y(o,"frameborder","0"),y(o,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),y(o,"referrerpolicy","strict-origin-when-cross-origin"),o.allowFullscreen="",Ct(R.src,Xt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||y(R,"src",Xt),y(R,"alt","复制")},m(l,t){de(document.head,c),s(l,ul,t),s(l,wl,t),s(l,bl,t),j(U,l,t),s(l,dl,t),j(u,l,t),s(l,hl,t),s(l,b,t),s(l,Il,t),s(l,d,t),s(l,Cl,t),s(l,h,t),s(l,Bl,t),s(l,I,t),s(l,fl,t),j(C,l,t),s(l,gl,t),s(l,B,t),s(l,Zl,t),s(l,f,t),s(l,vl,t),s(l,g,t),s(l,Gl,t),s(l,Z,t),s(l,Al,t),s(l,v,t),s(l,Wl,t),s(l,G,t),s(l,_l,t),s(l,A,t),s(l,Hl,t),s(l,W,t),s(l,El,t),s(l,o,t),s(l,xl,t),s(l,_,t),s(l,Vl,t),j(H,l,t),s(l,Rl,t),s(l,E,t),s(l,kl,t),s(l,x,t),s(l,Ql,t),s(l,V,t),s(l,Sl,t),s(l,R,t),s(l,zl,t),s(l,k,t),s(l,Nl,t),s(l,Q,t),s(l,Xl,t),s(l,S,t),s(l,$l,t),s(l,z,t),s(l,Fl,t),s(l,N,t),s(l,Ll,t),j(X,l,t),s(l,Yl,t),s(l,$,t),s(l,ql,t),j(F,l,t),s(l,Pl,t),s(l,L,t),s(l,Dl,t),j(Y,l,t),s(l,Kl,t),s(l,q,t),s(l,Ol,t),s(l,P,t),s(l,lt,t),s(l,D,t),s(l,tt,t),s(l,K,t),s(l,et,t),j(O,l,t),s(l,st,t),s(l,ll,t),s(l,nt,t),j(tl,l,t),s(l,at,t),s(l,el,t),s(l,Mt,t),s(l,sl,t),s(l,pt,t),s(l,nl,t),s(l,it,t),s(l,al,t),s(l,ot,t),s(l,Ml,t),s(l,yt,t),j(pl,l,t),s(l,mt,t),s(l,il,t),s(l,rt,t),s(l,ol,t),s(l,jt,t),s(l,yl,t),s(l,Tt,t),s(l,Jt,t),s(l,wt,t),s(l,ml,t),s(l,ct,t),s(l,rl,t),s(l,Ut,t),s(l,jl,t),s(l,ut,t),s(l,Tl,t),s(l,bt,t),j(Jl,l,t),s(l,dt,t),s(l,cl,t),ht=!0},p:we,i(l){ht||(T(U.$$.fragment,l),T(u.$$.fragment,l),T(C.$$.fragment,l),T(H.$$.fragment,l),T(X.$$.fragment,l),T(F.$$.fragment,l),T(Y.$$.fragment,l),T(O.$$.fragment,l),T(tl.$$.fragment,l),T(pl.$$.fragment,l),T(Jl.$$.fragment,l),ht=!0)},o(l){J(U.$$.fragment,l),J(u.$$.fragment,l),J(C.$$.fragment,l),J(H.$$.fragment,l),J(X.$$.fragment,l),J(F.$$.fragment,l),J(Y.$$.fragment,l),J(O.$$.fragment,l),J(tl.$$.fragment,l),J(pl.$$.fragment,l),J(Jl.$$.fragment,l),ht=!1},d(l){l&&(e(ul),e(wl),e(bl),e(dl),e(hl),e(b),e(Il),e(d),e(Cl),e(h),e(Bl),e(I),e(fl),e(gl),e(B),e(Zl),e(f),e(vl),e(g),e(Gl),e(Z),e(Al),e(v),e(Wl),e(G),e(_l),e(A),e(Hl),e(W),e(El),e(o),e(xl),e(_),e(Vl),e(Rl),e(E),e(kl),e(x),e(Ql),e(V),e(Sl),e(R),e(zl),e(k),e(Nl),e(Q),e(Xl),e(S),e($l),e(z),e(Fl),e(N),e(Ll),e(Yl),e($),e(ql),e(Pl),e(L),e(Dl),e(Kl),e(q),e(Ol),e(P),e(lt),e(D),e(tt),e(K),e(et),e(st),e(ll),e(nt),e(at),e(el),e(Mt),e(sl),e(pt),e(nl),e(it),e(al),e(ot),e(Ml),e(yt),e(mt),e(il),e(rt),e(ol),e(jt),e(yl),e(Tt),e(Jt),e(wt),e(ml),e(ct),e(rl),e(Ut),e(jl),e(ut),e(Tl),e(bt),e(dt),e(cl)),e(c),w(U,l),w(u,l),w(C,l),w(H,l),w(X,l),w(F,l),w(Y,l),w(O,l),w(tl,l),w(pl,l),w(Jl,l)}}}const Be='{"title":"使用 smolagents 创建我们的第一个智能体","local":"使用-smolagents-创建我们的第一个智能体","sections":[{"title":"什么是 smolagents？","local":"什么是-smolagents","sections":[],"depth":2},{"title":"让我们来构建我们的智能体！","local":"让我们来构建我们的智能体","sections":[{"title":"Tool（工具）","local":"tool工具","sections":[],"depth":3},{"title":"The Agent（智能体）","local":"the-agent智能体","sections":[],"depth":3}],"depth":2}],"depth":1}';function fe(ft){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends Ue{constructor(c){super(),ue(this,c,fe,Ce,Je,{})}}export{We as component};
