import{s as hs,n as Ts,o as Js}from"../chunks/scheduler.0cf4ef2e.js";import{S as ds,i as Us,e as o,s as n,c as p,h as us,a as m,d as a,b as l,f as Ms,g as r,j as f,k as fs,l as js,m as e,n as i,t as c,o as w,p as y}from"../chunks/index.abc433bf.js";import{C as gs,H as R}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f3fe7f8a.js";import{C as ns}from"../chunks/CodeBlock.89cabb39.js";function Cs(ls){let M,G,x,S,h,F,T,Q,J,os="The <code>optimum.fx.optimization</code> module provides a set of torch.fx graph transformations, along with classes and functions to write your own transformations and compose them.",X,d,E,U,ms="In 🤗 Optimum, there are two kinds of transformations: reversible and non-reversible transformations.",N,u,H,j,ps='The most basic case of transformations is non-reversible transformations. Those transformations cannot be reversed, meaning that after applying them to a graph module, there is no way to get the original model back. To implement such transformations in 🤗 Optimum, it is very easy: you just need to subclass <a href="/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation">Transformation</a> and implement the <a href="/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation.transform">transform()</a> method.',A,g,rs="For instance, the following transformation changes all the multiplications to additions:",V,C,Y,b,is="After implementing it, your transformation can be used as a regular function:",L,I,q,$,P,v,cs='A reversible transformation implements both the transformation and its reverse, allowing to retrieve the original model from the transformed one. To implement such transformation, you need to subclass <a href="/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.ReversibleTransformation">ReversibleTransformation</a> and implement the <a href="/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation.transform">transform()</a> and <a href="/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.ReversibleTransformation.reverse">reverse()</a> methods.',K,k,ws="For instance, the following transformation is reversible:",D,Z,O,_,ss,z,ys='As applying multiple transformations in chain is needed more often that not, <a href="/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.compose">compose()</a> is provided. It is an utility function that allows you to create a transformation by chaining multiple other transformations.',ts,B,as,W,es;return h=new gs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new R({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),d=new R({props:{title:"The transformation guide",local:"the-transformation-guide",headingTag:"h2"}}),u=new R({props:{title:"Write a non-reversible transformation",local:"write-a-non-reversible-transformation",headingTag:"h3"}}),C=new ns({props:{code:"aW1wb3J0JTIwb3BlcmF0b3IlMEFmcm9tJTIwb3B0aW11bS5meC5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBUcmFuc2Zvcm1hdGlvbiUwQSUwQWNsYXNzJTIwQ2hhbmdlTXVsVG9BZGQoVHJhbnNmb3JtYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdHJhbnNmb3JtKHNlbGYlMkMlMjBncmFwaF9tb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwbm9kZSUyMGluJTIwZ3JhcGhfbW9kdWxlLmdyYXBoLm5vZGVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub2RlLm9wJTIwJTNEJTNEJTIwJTIyY2FsbF9mdW5jdGlvbiUyMiUyMGFuZCUyMG5vZGUudGFyZ2V0JTIwJTNEJTNEJTIwb3BlcmF0b3IubXVsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9kZS50YXJnZXQlMjAlM0QlMjBvcGVyYXRvci5hZGQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBncmFwaF9tb2R1bGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> operator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.fx.optimization <span class="hljs-keyword">import</span> Transformation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">ChangeMulToAdd</span>(<span class="hljs-title class_ inherited__">Transformation</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">self, graph_module</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> node <span class="hljs-keyword">in</span> graph_module.graph.nodes:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> node.op == <span class="hljs-string">&quot;call_function&quot;</span> <span class="hljs-keyword">and</span> node.target == operator.mul:
<span class="hljs-meta">... </span>                node.target = operator.add
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> graph_module`,wrap:!1}}),I=new ns({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudXRpbHMuZnglMjBpbXBvcnQlMjBzeW1ib2xpY190cmFjZSUwQSUwQW1vZGVsJTIwJTNEJTIwQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0cmFjZWQlMjAlM0QlMjBzeW1ib2xpY190cmFjZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGlucHV0X25hbWVzJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUyQyUwQSklMEElMEF0cmFuc2Zvcm1hdGlvbiUyMCUzRCUyMENoYW5nZU11bFRvQWRkKCklMEF0cmFuc2Zvcm1lZF9tb2RlbCUyMCUzRCUyMHRyYW5zZm9ybWF0aW9uKHRyYWNlZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.utils.fx <span class="hljs-keyword">import</span> symbolic_trace

<span class="hljs-meta">&gt;&gt;&gt; </span>model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>traced = symbolic_trace(
<span class="hljs-meta">... </span>    model,
<span class="hljs-meta">... </span>    input_names=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transformation = ChangeMulToAdd()
<span class="hljs-meta">&gt;&gt;&gt; </span>transformed_model = transformation(traced)`,wrap:!1}}),$=new R({props:{title:"Write a reversible transformation",local:"write-a-reversible-transformation",headingTag:"h3"}}),Z=new ns({props:{code:"aW1wb3J0JTIwb3BlcmF0b3IlMEFmcm9tJTIwb3B0aW11bS5meC5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBSZXZlcnNpYmxlVHJhbnNmb3JtYXRpb24lMEElMEFjbGFzcyUyME11bFRvTXVsVGltZXNUd28oUmV2ZXJzaWJsZVRyYW5zZm9ybWF0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRyYW5zZm9ybShzZWxmJTJDJTIwZ3JhcGhfbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMG5vZGUlMjBpbiUyMGdyYXBoX21vZHVsZS5ncmFwaC5ub2RlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm9kZS5vcCUyMCUzRCUzRCUyMCUyMmNhbGxfZnVuY3Rpb24lMjIlMjBhbmQlMjBub2RlLnRhcmdldCUyMCUzRCUzRCUyMG9wZXJhdG9yLm11bCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMkMlMjB5JTIwJTNEJTIwbm9kZS5hcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9kZS5hcmdzJTIwJTNEJTIwKDIlMjAqJTIweCUyQyUyMHkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3JhcGhfbW9kdWxlJTBBJTIwJTIwJTIwJTIwZGVmJTIwcmV2ZXJzZShzZWxmJTJDJTIwZ3JhcGhfbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMG5vZGUlMjBpbiUyMGdyYXBoX21vZHVsZS5ncmFwaC5ub2RlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm9kZS5vcCUyMCUzRCUzRCUyMCUyMmNhbGxfZnVuY3Rpb24lMjIlMjBhbmQlMjBub2RlLnRhcmdldCUyMCUzRCUzRCUyMG9wZXJhdG9yLm11bCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMkMlMjB5JTIwJTNEJTIwbm9kZS5hcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9kZS5hcmdzJTIwJTNEJTIwKHglMjAlMkYlMjAyJTJDJTIweSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBncmFwaF9tb2R1bGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> operator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.fx.optimization <span class="hljs-keyword">import</span> ReversibleTransformation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MulToMulTimesTwo</span>(<span class="hljs-title class_ inherited__">ReversibleTransformation</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">self, graph_module</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> node <span class="hljs-keyword">in</span> graph_module.graph.nodes:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> node.op == <span class="hljs-string">&quot;call_function&quot;</span> <span class="hljs-keyword">and</span> node.target == operator.mul:
<span class="hljs-meta">... </span>                x, y = node.args
<span class="hljs-meta">... </span>                node.args = (<span class="hljs-number">2</span> * x, y)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> graph_module
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse</span>(<span class="hljs-params">self, graph_module</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> node <span class="hljs-keyword">in</span> graph_module.graph.nodes:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> node.op == <span class="hljs-string">&quot;call_function&quot;</span> <span class="hljs-keyword">and</span> node.target == operator.mul:
<span class="hljs-meta">... </span>                x, y = node.args
<span class="hljs-meta">... </span>                node.args = (x / <span class="hljs-number">2</span>, y)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> graph_module`,wrap:!1}}),_=new R({props:{title:"Composing transformations together",local:"composing-transformations-together",headingTag:"h3"}}),B=new ns({props:{code:"ZnJvbSUyMG9wdGltdW0uZngub3B0aW1pemF0aW9uJTIwaW1wb3J0JTIwY29tcG9zZSUwQWNvbXBvc2l0aW9uJTIwJTNEJTIwY29tcG9zZShNdWxUb011bFRpbWVzVHdvKCklMkMlMjBDaGFuZ2VNdWxUb0FkZCgpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.fx.optimization <span class="hljs-keyword">import</span> compose
<span class="hljs-meta">&gt;&gt;&gt; </span>composition = compose(MulToMulTimesTwo(), ChangeMulToAdd())`,wrap:!1}}),{c(){M=o("meta"),G=n(),x=o("p"),S=n(),p(h.$$.fragment),F=n(),p(T.$$.fragment),Q=n(),J=o("p"),J.innerHTML=os,X=n(),p(d.$$.fragment),E=n(),U=o("p"),U.textContent=ms,N=n(),p(u.$$.fragment),H=n(),j=o("p"),j.innerHTML=ps,A=n(),g=o("p"),g.textContent=rs,V=n(),p(C.$$.fragment),Y=n(),b=o("p"),b.textContent=is,L=n(),p(I.$$.fragment),q=n(),p($.$$.fragment),P=n(),v=o("p"),v.innerHTML=cs,K=n(),k=o("p"),k.textContent=ws,D=n(),p(Z.$$.fragment),O=n(),p(_.$$.fragment),ss=n(),z=o("p"),z.innerHTML=ys,ts=n(),p(B.$$.fragment),as=n(),W=o("p"),this.h()},l(s){const t=us("svelte-u9bgzb",document.head);M=m(t,"META",{name:!0,content:!0}),t.forEach(a),G=l(s),x=m(s,"P",{}),Ms(x).forEach(a),S=l(s),r(h.$$.fragment,s),F=l(s),r(T.$$.fragment,s),Q=l(s),J=m(s,"P",{"data-svelte-h":!0}),f(J)!=="svelte-pyegu9"&&(J.innerHTML=os),X=l(s),r(d.$$.fragment,s),E=l(s),U=m(s,"P",{"data-svelte-h":!0}),f(U)!=="svelte-1u0ybww"&&(U.textContent=ms),N=l(s),r(u.$$.fragment,s),H=l(s),j=m(s,"P",{"data-svelte-h":!0}),f(j)!=="svelte-19zskq5"&&(j.innerHTML=ps),A=l(s),g=m(s,"P",{"data-svelte-h":!0}),f(g)!=="svelte-16d1zd5"&&(g.textContent=rs),V=l(s),r(C.$$.fragment,s),Y=l(s),b=m(s,"P",{"data-svelte-h":!0}),f(b)!=="svelte-4h2eh7"&&(b.textContent=is),L=l(s),r(I.$$.fragment,s),q=l(s),r($.$$.fragment,s),P=l(s),v=m(s,"P",{"data-svelte-h":!0}),f(v)!=="svelte-dfup0a"&&(v.innerHTML=cs),K=l(s),k=m(s,"P",{"data-svelte-h":!0}),f(k)!=="svelte-84g68q"&&(k.textContent=ws),D=l(s),r(Z.$$.fragment,s),O=l(s),r(_.$$.fragment,s),ss=l(s),z=m(s,"P",{"data-svelte-h":!0}),f(z)!=="svelte-g9cmdi"&&(z.innerHTML=ys),ts=l(s),r(B.$$.fragment,s),as=l(s),W=m(s,"P",{}),Ms(W).forEach(a),this.h()},h(){fs(M,"name","hf:doc:metadata"),fs(M,"content",bs)},m(s,t){js(document.head,M),e(s,G,t),e(s,x,t),e(s,S,t),i(h,s,t),e(s,F,t),i(T,s,t),e(s,Q,t),e(s,J,t),e(s,X,t),i(d,s,t),e(s,E,t),e(s,U,t),e(s,N,t),i(u,s,t),e(s,H,t),e(s,j,t),e(s,A,t),e(s,g,t),e(s,V,t),i(C,s,t),e(s,Y,t),e(s,b,t),e(s,L,t),i(I,s,t),e(s,q,t),i($,s,t),e(s,P,t),e(s,v,t),e(s,K,t),e(s,k,t),e(s,D,t),i(Z,s,t),e(s,O,t),i(_,s,t),e(s,ss,t),e(s,z,t),e(s,ts,t),i(B,s,t),e(s,as,t),e(s,W,t),es=!0},p:Ts,i(s){es||(c(h.$$.fragment,s),c(T.$$.fragment,s),c(d.$$.fragment,s),c(u.$$.fragment,s),c(C.$$.fragment,s),c(I.$$.fragment,s),c($.$$.fragment,s),c(Z.$$.fragment,s),c(_.$$.fragment,s),c(B.$$.fragment,s),es=!0)},o(s){w(h.$$.fragment,s),w(T.$$.fragment,s),w(d.$$.fragment,s),w(u.$$.fragment,s),w(C.$$.fragment,s),w(I.$$.fragment,s),w($.$$.fragment,s),w(Z.$$.fragment,s),w(_.$$.fragment,s),w(B.$$.fragment,s),es=!1},d(s){s&&(a(G),a(x),a(S),a(F),a(Q),a(J),a(X),a(E),a(U),a(N),a(H),a(j),a(A),a(g),a(V),a(Y),a(b),a(L),a(q),a(P),a(v),a(K),a(k),a(D),a(O),a(ss),a(z),a(ts),a(as),a(W)),a(M),y(h,s),y(T,s),y(d,s),y(u,s),y(C,s),y(I,s),y($,s),y(Z,s),y(_,s),y(B,s)}}}const bs='{"title":"Optimization","local":"optimization","sections":[{"title":"The transformation guide","local":"the-transformation-guide","sections":[{"title":"Write a non-reversible transformation","local":"write-a-non-reversible-transformation","sections":[],"depth":3},{"title":"Write a reversible transformation","local":"write-a-reversible-transformation","sections":[],"depth":3},{"title":"Composing transformations together","local":"composing-transformations-together","sections":[],"depth":3}],"depth":2}],"depth":1}';function Is(ls){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends ds{constructor(M){super(),Us(this,M,Is,Cs,hs,{})}}export{_s as component};
