import{s as Qt,o as Kt,n as Gt}from"../chunks/scheduler.0cf4ef2e.js";import{S as eo,i as to,e as s,s as r,c as g,h as oo,a as d,d as o,b as n,f as $,g as f,j as k,k as M,l as t,m as c,n as u,t as h,o as _,p as x}from"../chunks/index.abc433bf.js";import{T as ro}from"../chunks/Tip.15dd1ac8.js";import{C as no,H as fe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f3fe7f8a.js";import{D as C}from"../chunks/Docstring.642378c2.js";import{C as Yt}from"../chunks/CodeBlock.89cabb39.js";import{E as ao}from"../chunks/ExampleCodeBlock.c1c40c92.js";function so(ue){let p,D="It is possible to know which tasks are supported for a model for a given backend, by doing:",T,b,y;return b=new Yt({props:{code:"ZnJvbSUyMG9wdGltdW0uZXhwb3J0ZXJzLnRhc2tzJTIwaW1wb3J0JTIwVGFza3NNYW5hZ2VyJTBBJTBBbW9kZWxfdHlwZSUyMCUzRCUyMCUyMmRpc3RpbGJlcnQlMjIlMEElMjMlMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGZvciUyMHRoZSUyME9OTlglMjBleHBvcnQuJTBBYmFja2VuZCUyMCUzRCUyMCUyMm9ubnglMjIlMEFkaXN0aWxiZXJ0X3Rhc2tzJTIwJTNEJTIwbGlzdChUYXNrc01hbmFnZXIuZ2V0X3N1cHBvcnRlZF90YXNrc19mb3JfbW9kZWxfdHlwZShtb2RlbF90eXBlJTJDJTIwYmFja2VuZCkua2V5cygpKSUwQSUwQXByaW50KGRpc3RpbGJlcnRfdGFza3Mp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters.tasks <span class="hljs-keyword">import</span> TasksManager

<span class="hljs-meta">&gt;&gt;&gt; </span>model_type = <span class="hljs-string">&quot;distilbert&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, for the ONNX export.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>backend = <span class="hljs-string">&quot;onnx&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>distilbert_tasks = <span class="hljs-built_in">list</span>(TasksManager.get_supported_tasks_for_model_type(model_type, backend).keys())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(distilbert_tasks)
[<span class="hljs-string">&#x27;default&#x27;</span>, <span class="hljs-string">&#x27;fill-mask&#x27;</span>, <span class="hljs-string">&#x27;text-classification&#x27;</span>, <span class="hljs-string">&#x27;multiple-choice&#x27;</span>, <span class="hljs-string">&#x27;token-classification&#x27;</span>, <span class="hljs-string">&#x27;question-answering&#x27;</span>]`,wrap:!1}}),{c(){p=s("p"),p.textContent=D,T=r(),g(b.$$.fragment)},l(i){p=d(i,"P",{"data-svelte-h":!0}),k(p)!=="svelte-af61zr"&&(p.textContent=D),T=n(i),f(b.$$.fragment,i)},m(i,v){c(i,p,v),c(i,T,v),u(b,i,v),y=!0},p:Gt,i(i){y||(h(b.$$.fragment,i),y=!0)},o(i){_(b.$$.fragment,i),y=!1},d(i){i&&(o(p),o(T)),x(b,i)}}}function io(ue){let p,D="Example:",T,b,y;return b=new Yt({props:{code:"cmVnaXN0ZXJfZm9yX25ld19iYWNrZW5kJTIwJTNEJTIwY3JlYXRlX3JlZ2lzdGVyKCUyMm5ldy1iYWNrZW5kJTIyKSUwQSUwQSU0MHJlZ2lzdGVyX2Zvcl9uZXdfYmFja2VuZCglMjJiZXJ0JTIyJTJDJTIwJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMCUyMnRva2VuLWNsYXNzaWZpY2F0aW9uJTIyKSUwQWNsYXNzJTIwQmVydE5ld0JhY2tlbmRDb25maWcoTmV3QmFja2VuZENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>register_for_new_backend = create_register(<span class="hljs-string">&quot;new-backend&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>@register_for_new_backend(<span class="hljs-string">&quot;bert&quot;</span>, <span class="hljs-string">&quot;text-classification&quot;</span>, <span class="hljs-string">&quot;token-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">BertNewBackendConfig</span>(<span class="hljs-title class_ inherited__">NewBackendConfig</span>):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">pass</span>`,wrap:!1}}),{c(){p=s("p"),p.textContent=D,T=r(),g(b.$$.fragment)},l(i){p=d(i,"P",{"data-svelte-h":!0}),k(p)!=="svelte-11lpom8"&&(p.textContent=D),T=n(i),f(b.$$.fragment,i)},m(i,v){c(i,p,v),c(i,T,v),u(b,i,v),y=!0},p:Gt,i(i){y||(h(b.$$.fragment,i),y=!0)},o(i){_(b.$$.fragment,i),y=!1},d(i){i&&(o(p),o(T)),x(b,i)}}}function co(ue){let p,D,T,b,y,i,v,Pe,R,Nt="Exporting a model from one framework to some format (also called backend here) involves specifying inputs and outputs information that the export function needs. The way <code>optimum.exporters</code> is structured for each backend is as follows:",Ae,Z,Ft="<li>Configuration classes containing the information for each model to perform the export.</li> <li>Exporting functions using the proper configuration for the model to export.</li>",He,z,Pt=`The role of the <a href="/docs/optimum/main/en/exporters/task_manager#optimum.exporters.tasks.TasksManager">TasksManager</a> is to be the main entry-point to load a model given a name and a task, and to get the proper configuration for a given (architecture, backend) couple.
That way, there is a centralized place to register the <code>task -&gt; model class</code> and <code>(architecture, backend) -&gt; configuration</code> mappings. This allows the export functions to use this, and to rely on the various checks it provides.`,je,V,Ie,X,At="The tasks supported might depend on the backend, but here are the mappings between a task name and the auto class for PyTorch.",Oe,P,Ue,B,Le,W,qe,G,Ht="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>audio-classification</code></td> <td><code>AutoModelForAudioClassification</code></td></tr> <tr><td><code>audio-frame-classification</code></td> <td><code>AutoModelForAudioFrameClassification</code></td></tr> <tr><td><code>audio-xvector</code></td> <td><code>AutoModelForAudioXVector</code></td></tr> <tr><td><code>automatic-speech-recognition</code></td> <td><code>AutoModelForSpeechSeq2Seq</code>, <code>AutoModelForCTC</code></td></tr> <tr><td><code>depth-estimation</code></td> <td><code>AutoModelForDepthEstimation</code></td></tr> <tr><td><code>feature-extraction</code></td> <td><code>AutoModel</code></td></tr> <tr><td><code>fill-mask</code></td> <td><code>AutoModelForMaskedLM</code></td></tr> <tr><td><code>image-classification</code></td> <td><code>AutoModelForImageClassification</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>AutoModelForImageToImage</code></td></tr> <tr><td><code>image-to-text</code></td> <td><code>AutoModelForVision2Seq</code>, <code>AutoModel</code></td></tr> <tr><td><code>image-text-to-text</code></td> <td><code>AutoModelForImageTextToText</code></td></tr> <tr><td><code>mask-generation</code></td> <td><code>AutoModel</code></td></tr> <tr><td><code>masked-im</code></td> <td><code>AutoModelForMaskedImageModeling</code></td></tr> <tr><td><code>multiple-choice</code></td> <td><code>AutoModelForMultipleChoice</code></td></tr> <tr><td><code>object-detection</code></td> <td><code>AutoModelForObjectDetection</code></td></tr> <tr><td><code>question-answering</code></td> <td><code>AutoModelForQuestionAnswering</code></td></tr> <tr><td><code>reinforcement-learning</code></td> <td><code>AutoModel</code></td></tr> <tr><td><code>semantic-segmentation</code></td> <td><code>AutoModelForSemanticSegmentation</code></td></tr> <tr><td><code>text-to-audio</code></td> <td><code>AutoModelForTextToSpectrogram</code>, <code>AutoModelForTextToWaveform</code></td></tr> <tr><td><code>text-generation</code></td> <td><code>AutoModelForCausalLM</code></td></tr> <tr><td><code>text2text-generation</code></td> <td><code>AutoModelForSeq2SeqLM</code></td></tr> <tr><td><code>text-classification</code></td> <td><code>AutoModelForSequenceClassification</code></td></tr> <tr><td><code>token-classification</code></td> <td><code>AutoModelForTokenClassification</code></td></tr> <tr><td><code>visual-question-answering</code></td> <td><code>AutoModelForVisualQuestionAnswering</code></td></tr> <tr><td><code>zero-shot-image-classification</code></td> <td><code>AutoModelForZeroShotImageClassification</code></td></tr> <tr><td><code>zero-shot-object-detection</code></td> <td><code>AutoModelForZeroShotObjectDetection</code></td></tr></tbody>",Ee,Y,Se,Q,jt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>AutoPipelineForText2Image</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>AutoPipelineForImage2Image</code></td></tr> <tr><td><code>inpainting</code></td> <td><code>AutoPipelineForInpainting</code></td></tr></tbody>",Je,K,Re,ee,It="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>feature-extraction</code></td> <td><code>SentenceTransformer</code></td></tr> <tr><td><code>sentence-similarity</code></td> <td><code>SentenceTransformer</code></td></tr></tbody>",Ze,te,ze,l,oe,rt,he,Ot="Handles the <code>task name -&gt; model class</code> and <code>architecture -&gt; configuration</code> mappings.",nt,N,re,at,_e,Ut="Creates a register function for the specified backend.",st,A,dt,w,ne,it,xe,Lt="Determines the framework to use for the export.",ct,ke,qt="The priority is in the following order:",lt,be,Et="<li>User input via <code>framework</code>.</li> <li>If local checkpoint is provided, use the same framework as the checkpoint.</li> <li>If model repo, try to infer the framework from the cache if available, else from the Hub.</li> <li>If could not infer, use available framework in environment, with priority given to PyTorch.</li>",mt,H,ae,pt,ye,St="Retrieves all the possible tasks.",gt,j,se,ft,Te,Jt="Gets the <code>ExportConfigConstructor</code> for a model (or alternatively for a model type) and task combination.",ut,I,de,ht,ve,Rt="Attempts to retrieve an AutoModel class from a task name.",_t,O,ie,xt,$e,Zt="Retrieves a model from its name and the task to be enabled.",kt,U,ce,bt,Me,zt="Returns the list of supported architectures by the exporter for a given task. Transformers-specific.",yt,L,le,Tt,we,Vt="Retrieves the <code>task -&gt; exporter backend config constructors</code> map from the model type.",vt,q,me,$t,Ce,Xt="Infers the library from the model repo, model instance, or model class.",Mt,E,pe,wt,De,Bt="Infers the task from the model repo, model instance, or model class.",Ct,S,ge,Dt,Ne,Wt=`Updates the model for export. This function is suitable to make required changes to the models from different
libraries to follow transformers style.`,Ve,Fe,Xe;return y=new no({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new fe({props:{title:"The Tasks Manager",local:"the-tasks-manager",headingTag:"h1"}}),V=new fe({props:{title:"Task names",local:"task-names",headingTag:"h2"}}),P=new ro({props:{$$slots:{default:[so]},$$scope:{ctx:ue}}}),B=new fe({props:{title:"PyTorch",local:"pytorch",headingTag:"h3"}}),W=new fe({props:{title:"Transformers",local:"transformers",headingTag:"h4"}}),Y=new fe({props:{title:"Diffusers",local:"diffusers",headingTag:"h4"}}),K=new fe({props:{title:"Sentence Transformers",local:"sentence-transformers",headingTag:"h4"}}),te=new fe({props:{title:"Reference",local:"optimum.exporters.tasks.TasksManager",headingTag:"h2"}}),oe=new C({props:{name:"class optimum.exporters.tasks.TasksManager",anchor:"optimum.exporters.tasks.TasksManager",parameters:[],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L118"}}),re=new C({props:{name:"create_register",anchor:"optimum.exporters.tasks.TasksManager.create_register",parameters:[{name:"backend",val:": str"},{name:"overwrite_existing",val:": bool = False"}],parametersDescription:[{anchor:"optimum.exporters.tasks.TasksManager.create_register.backend",description:`<strong>backend</strong> (<code>str</code>) &#x2014;
The name of the backend that the register function will handle.`,name:"backend"},{anchor:"optimum.exporters.tasks.TasksManager.create_register.overwrite_existing",description:`<strong>overwrite_existing</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not the register function is allowed to overwrite an already existing config.`,name:"overwrite_existing"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L287",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator taking the model type and a the
supported tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable[[str, Tuple[str, ...]], Callable[[Type], Type]]</code></p>
`}}),A=new ao({props:{anchor:"optimum.exporters.tasks.TasksManager.create_register.example",$$slots:{default:[io]},$$scope:{ctx:ue}}}),ne=new C({props:{name:"determine_framework",anchor:"optimum.exporters.tasks.TasksManager.determine_framework",parameters:[{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"}],parametersDescription:[{anchor:"optimum.exporters.tasks.TasksManager.determine_framework.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.tasks.TasksManager.determine_framework.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.tasks.TasksManager.determine_framework.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>,  defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.tasks.TasksManager.determine_framework.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.tasks.TasksManager.determine_framework.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The framework to use for the export.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ae=new C({props:{name:"get_all_tasks",anchor:"optimum.exporters.tasks.TasksManager.get_all_tasks",parameters:[],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1059",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>all the possible tasks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`}}),se=new C({props:{name:"get_exporter_config_constructor",anchor:"optimum.exporters.tasks.TasksManager.get_exporter_config_constructor",parameters:[{name:"exporter",val:": str"},{name:"model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"task",val:": str = 'feature-extraction'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"exporter_config_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.tasks.TasksManager.get_exporter_config_constructor.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The exporter to use.`,name:"exporter"},{anchor:"optimum.exporters.tasks.TasksManager.get_exporter_config_constructor.model",description:`<strong>model</strong> (<code>Optional[PreTrainedModel]</code>, defaults to <code>None</code>) &#x2014;
The instance of the model.`,name:"model"},{anchor:"optimum.exporters.tasks.TasksManager.get_exporter_config_constructor.task",description:`<strong>task</strong> (<code>str</code>, defaults to <code>&quot;feature-extraction&quot;</code>) &#x2014;
The task to retrieve the config for.`,name:"task"},{anchor:"optimum.exporters.tasks.TasksManager.get_exporter_config_constructor.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the config for.`,name:"model_type"},{anchor:"optimum.exporters.tasks.TasksManager.get_exporter_config_constructor.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"},{anchor:"optimum.exporters.tasks.TasksManager.get_exporter_config_constructor.exporter_config_kwargs",description:`<strong>exporter_config_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Arguments that will be passed to the exporter config class when building the config constructor.`,name:"exporter_config_kwargs"},{anchor:"optimum.exporters.tasks.TasksManager.get_exporter_config_constructor.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1232",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The <code>ExporterConfig</code> constructor for the requested backend.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ExportConfigConstructor</code></p>
`}}),de=new C({props:{name:"get_model_class_for_task",anchor:"optimum.exporters.tasks.TasksManager.get_model_class_for_task",parameters:[{name:"task",val:": str"},{name:"framework",val:": str = 'pt'"},{name:"model_type",val:": typing.Optional[str] = None"},{name:"model_class_name",val:": typing.Optional[str] = None"},{name:"library",val:": str = 'transformers'"}],parametersDescription:[{anchor:"optimum.exporters.tasks.TasksManager.get_model_class_for_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_class_for_task.framework",description:`<strong>framework</strong> (<code>str</code>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The framework to use for the export.`,name:"framework"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_class_for_task.model_type",description:`<strong>model_type</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The model type to retrieve the model class for. Some architectures need a custom class to be loaded,
and can not be loaded from auto class.`,name:"model_type"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_class_for_task.model_class_name",description:`<strong>model_class_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
A model class name, allowing to override the default class that would be detected for the task. This
parameter is useful for example for &#x201C;automatic-speech-recognition&#x201D;, that may map to
AutoModelForSpeechSeq2Seq or to AutoModelForCTC.`,name:"model_class_name"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_class_for_task.library",description:`<strong>library</strong> (<code>str</code>, defaults to <code>transformers</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L445",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The AutoModel class corresponding to the task.</p>
`}}),ie=new C({props:{name:"get_model_from_task",anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task",parameters:[{name:"task",val:": str"},{name:"model_name_or_path",val:": typing.Union[str, pathlib.Path]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"framework",val:": typing.Optional[str] = None"},{name:"torch_dtype",val:": typing.Optional[ForwardRef('torch.dtype')] = None"},{name:"device",val:": typing.Union[ForwardRef('torch.device'), str, NoneType] = None"},{name:"library_name",val:": typing.Optional[str] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task required.`,name:"task"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either the model id of a model repo on the Hugging Face Hub, or a path to a local directory
containing a model.`,name:"model_name_or_path"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.framework",description:`<strong>framework</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
The framework to use for the export. See <code>TasksManager.determine_framework</code> for the priority should
none be provided.`,name:"framework"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.torch_dtype",description:`<strong>torch_dtype</strong> (<code>Optional[torch.dtype]</code>, defaults to <code>None</code>) &#x2014;
Data type to load the model on. PyTorch-only argument.`,name:"torch_dtype"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
Device to initialize the model on. PyTorch-only argument. For PyTorch, defaults to &#x201C;cpu&#x201D;.`,name:"device"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;. See <code>TasksManager.infer_library_from_model</code> for the priority should
none be provided.`,name:"library_name"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Keyword arguments to pass to the model <code>.from_pretrained()</code> method.`,name:"model_kwargs"},{anchor:"optimum.exporters.tasks.TasksManager.get_model_from_task.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;. See <code>TasksManager.infer_library_from_model</code> for the priority should
none be provided.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1079",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The instance of the model.</p>
`}}),ce=new C({props:{name:"get_supported_model_type_for_task",anchor:"optimum.exporters.tasks.TasksManager.get_supported_model_type_for_task",parameters:[{name:"task",val:": str"},{name:"exporter",val:": str"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L403"}}),le=new C({props:{name:"get_supported_tasks_for_model_type",anchor:"optimum.exporters.tasks.TasksManager.get_supported_tasks_for_model_type",parameters:[{name:"model_type",val:": str"},{name:"exporter",val:": str"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.tasks.TasksManager.get_supported_tasks_for_model_type.model_type",description:`<strong>model_type</strong> (<code>str</code>) &#x2014;
The model type to retrieve the supported tasks for.`,name:"model_type"},{anchor:"optimum.exporters.tasks.TasksManager.get_supported_tasks_for_model_type.exporter",description:`<strong>exporter</strong> (<code>str</code>) &#x2014;
The name of the exporter.`,name:"exporter"},{anchor:"optimum.exporters.tasks.TasksManager.get_supported_tasks_for_model_type.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The name attribute of the model object, only used for the exception message.`,name:"model_name"},{anchor:"optimum.exporters.tasks.TasksManager.get_supported_tasks_for_model_type.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L342",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The mapping between the supported tasks and the backend config
constructors for the specified model type.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, ExportConfigConstructor]</code></p>
`}}),me=new C({props:{name:"infer_library_from_model",anchor:"optimum.exporters.tasks.TasksManager.infer_library_from_model",parameters:[{name:"model",val:": typing.Union[str, ForwardRef('PreTrainedModel'), ForwardRef('DiffusionPipeline'), typing.Type]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"}],parametersDescription:[{anchor:"optimum.exporters.tasks.TasksManager.infer_library_from_model.model",description:`<strong>model</strong> (<code>Union[str, PreTrainedModel, DiffusionPipeline, Type]</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model"},{anchor:"optimum.exporters.tasks.TasksManager.infer_library_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.tasks.TasksManager.infer_library_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.tasks.TasksManager.infer_library_from_model.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.tasks.TasksManager.infer_library_from_model.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L962",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The library name automatically detected from the model repo, model instance, or model class.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),pe=new C({props:{name:"infer_task_from_model",anchor:"optimum.exporters.tasks.TasksManager.infer_task_from_model",parameters:[{name:"model",val:": typing.Union[str, ForwardRef('PreTrainedModel'), ForwardRef('DiffusionPipeline'), typing.Type]"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": str = '/home/runner/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.tasks.TasksManager.infer_task_from_model.model",description:`<strong>model</strong> (<code>Union[str, PreTrainedModel, DiffusionPipeline, Type]</code>) &#x2014;
The model to infer the task from. This can either be the name of a repo on the HuggingFace Hub, an
instance of a model, or a model class.`,name:"model"},{anchor:"optimum.exporters.tasks.TasksManager.infer_task_from_model.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the model files are located inside a subfolder of the model directory / repo on the Hugging
Face Hub, you can specify the subfolder name here.`,name:"subfolder"},{anchor:"optimum.exporters.tasks.TasksManager.infer_task_from_model.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>,  defaults to <code>None</code>) &#x2014;
Revision is the specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"revision"},{anchor:"optimum.exporters.tasks.TasksManager.infer_task_from_model.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model weights have been cached if the standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.exporters.tasks.TasksManager.infer_task_from_model.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.exporters.tasks.TasksManager.infer_task_from_model.library_name",description:`<strong>library_name</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The library name of the model. Can be any of &#x201C;transformers&#x201D;, &#x201C;timm&#x201D;, &#x201C;diffusers&#x201D;, &#x201C;sentence_transformers&#x201D;. See <code>TasksManager.infer_library_from_model</code> for the priority should
none be provided.`,name:"library_name"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L803",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The task name automatically detected from the HF hub repo, model instance, or model class.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ge=new C({props:{name:"standardize_model_attributes",anchor:"optimum.exporters.tasks.TasksManager.standardize_model_attributes",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), ForwardRef('DiffusionPipeline')]"},{name:"library_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"optimum.exporters.tasks.TasksManager.standardize_model_attributes.model",description:`<strong>model</strong> (<code>Union[PreTrainedModel, DiffusionPipeline]</code>) &#x2014;
The instance of the model.`,name:"model"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/exporters/tasks.py#L1008"}}),{c(){p=s("meta"),D=r(),T=s("p"),b=r(),g(y.$$.fragment),i=r(),g(v.$$.fragment),Pe=r(),R=s("p"),R.innerHTML=Nt,Ae=r(),Z=s("ul"),Z.innerHTML=Ft,He=r(),z=s("p"),z.innerHTML=Pt,je=r(),g(V.$$.fragment),Ie=r(),X=s("p"),X.textContent=At,Oe=r(),g(P.$$.fragment),Ue=r(),g(B.$$.fragment),Le=r(),g(W.$$.fragment),qe=r(),G=s("table"),G.innerHTML=Ht,Ee=r(),g(Y.$$.fragment),Se=r(),Q=s("table"),Q.innerHTML=jt,Je=r(),g(K.$$.fragment),Re=r(),ee=s("table"),ee.innerHTML=It,Ze=r(),g(te.$$.fragment),ze=r(),l=s("div"),g(oe.$$.fragment),rt=r(),he=s("p"),he.innerHTML=Ot,nt=r(),N=s("div"),g(re.$$.fragment),at=r(),_e=s("p"),_e.textContent=Ut,st=r(),g(A.$$.fragment),dt=r(),w=s("div"),g(ne.$$.fragment),it=r(),xe=s("p"),xe.textContent=Lt,ct=r(),ke=s("p"),ke.textContent=qt,lt=r(),be=s("ol"),be.innerHTML=Et,mt=r(),H=s("div"),g(ae.$$.fragment),pt=r(),ye=s("p"),ye.textContent=St,gt=r(),j=s("div"),g(se.$$.fragment),ft=r(),Te=s("p"),Te.innerHTML=Jt,ut=r(),I=s("div"),g(de.$$.fragment),ht=r(),ve=s("p"),ve.textContent=Rt,_t=r(),O=s("div"),g(ie.$$.fragment),xt=r(),$e=s("p"),$e.textContent=Zt,kt=r(),U=s("div"),g(ce.$$.fragment),bt=r(),Me=s("p"),Me.textContent=zt,yt=r(),L=s("div"),g(le.$$.fragment),Tt=r(),we=s("p"),we.innerHTML=Vt,vt=r(),q=s("div"),g(me.$$.fragment),$t=r(),Ce=s("p"),Ce.textContent=Xt,Mt=r(),E=s("div"),g(pe.$$.fragment),wt=r(),De=s("p"),De.textContent=Bt,Ct=r(),S=s("div"),g(ge.$$.fragment),Dt=r(),Ne=s("p"),Ne.textContent=Wt,Ve=r(),Fe=s("p"),this.h()},l(e){const a=oo("svelte-u9bgzb",document.head);p=d(a,"META",{name:!0,content:!0}),a.forEach(o),D=n(e),T=d(e,"P",{}),$(T).forEach(o),b=n(e),f(y.$$.fragment,e),i=n(e),f(v.$$.fragment,e),Pe=n(e),R=d(e,"P",{"data-svelte-h":!0}),k(R)!=="svelte-ab4qq0"&&(R.innerHTML=Nt),Ae=n(e),Z=d(e,"UL",{"data-svelte-h":!0}),k(Z)!=="svelte-g9sbqh"&&(Z.innerHTML=Ft),He=n(e),z=d(e,"P",{"data-svelte-h":!0}),k(z)!=="svelte-vrw8g8"&&(z.innerHTML=Pt),je=n(e),f(V.$$.fragment,e),Ie=n(e),X=d(e,"P",{"data-svelte-h":!0}),k(X)!=="svelte-bvahnd"&&(X.textContent=At),Oe=n(e),f(P.$$.fragment,e),Ue=n(e),f(B.$$.fragment,e),Le=n(e),f(W.$$.fragment,e),qe=n(e),G=d(e,"TABLE",{"data-svelte-h":!0}),k(G)!=="svelte-1i9hn0e"&&(G.innerHTML=Ht),Ee=n(e),f(Y.$$.fragment,e),Se=n(e),Q=d(e,"TABLE",{"data-svelte-h":!0}),k(Q)!=="svelte-1ucx854"&&(Q.innerHTML=jt),Je=n(e),f(K.$$.fragment,e),Re=n(e),ee=d(e,"TABLE",{"data-svelte-h":!0}),k(ee)!=="svelte-wxe8zc"&&(ee.innerHTML=It),Ze=n(e),f(te.$$.fragment,e),ze=n(e),l=d(e,"DIV",{class:!0});var m=$(l);f(oe.$$.fragment,m),rt=n(m),he=d(m,"P",{"data-svelte-h":!0}),k(he)!=="svelte-11ax9pk"&&(he.innerHTML=Ot),nt=n(m),N=d(m,"DIV",{class:!0});var F=$(N);f(re.$$.fragment,F),at=n(F),_e=d(F,"P",{"data-svelte-h":!0}),k(_e)!=="svelte-1hg58vd"&&(_e.textContent=Ut),st=n(F),f(A.$$.fragment,F),F.forEach(o),dt=n(m),w=d(m,"DIV",{class:!0});var J=$(w);f(ne.$$.fragment,J),it=n(J),xe=d(J,"P",{"data-svelte-h":!0}),k(xe)!=="svelte-rshgf5"&&(xe.textContent=Lt),ct=n(J),ke=d(J,"P",{"data-svelte-h":!0}),k(ke)!=="svelte-1wbth9c"&&(ke.textContent=qt),lt=n(J),be=d(J,"OL",{"data-svelte-h":!0}),k(be)!=="svelte-17imzut"&&(be.innerHTML=Et),J.forEach(o),mt=n(m),H=d(m,"DIV",{class:!0});var Be=$(H);f(ae.$$.fragment,Be),pt=n(Be),ye=d(Be,"P",{"data-svelte-h":!0}),k(ye)!=="svelte-1u59gs0"&&(ye.textContent=St),Be.forEach(o),gt=n(m),j=d(m,"DIV",{class:!0});var We=$(j);f(se.$$.fragment,We),ft=n(We),Te=d(We,"P",{"data-svelte-h":!0}),k(Te)!=="svelte-77ppuy"&&(Te.innerHTML=Jt),We.forEach(o),ut=n(m),I=d(m,"DIV",{class:!0});var Ge=$(I);f(de.$$.fragment,Ge),ht=n(Ge),ve=d(Ge,"P",{"data-svelte-h":!0}),k(ve)!=="svelte-dfgadj"&&(ve.textContent=Rt),Ge.forEach(o),_t=n(m),O=d(m,"DIV",{class:!0});var Ye=$(O);f(ie.$$.fragment,Ye),xt=n(Ye),$e=d(Ye,"P",{"data-svelte-h":!0}),k($e)!=="svelte-xnksbg"&&($e.textContent=Zt),Ye.forEach(o),kt=n(m),U=d(m,"DIV",{class:!0});var Qe=$(U);f(ce.$$.fragment,Qe),bt=n(Qe),Me=d(Qe,"P",{"data-svelte-h":!0}),k(Me)!=="svelte-1tobybd"&&(Me.textContent=zt),Qe.forEach(o),yt=n(m),L=d(m,"DIV",{class:!0});var Ke=$(L);f(le.$$.fragment,Ke),Tt=n(Ke),we=d(Ke,"P",{"data-svelte-h":!0}),k(we)!=="svelte-h2w0ej"&&(we.innerHTML=Vt),Ke.forEach(o),vt=n(m),q=d(m,"DIV",{class:!0});var et=$(q);f(me.$$.fragment,et),$t=n(et),Ce=d(et,"P",{"data-svelte-h":!0}),k(Ce)!=="svelte-k1qkuj"&&(Ce.textContent=Xt),et.forEach(o),Mt=n(m),E=d(m,"DIV",{class:!0});var tt=$(E);f(pe.$$.fragment,tt),wt=n(tt),De=d(tt,"P",{"data-svelte-h":!0}),k(De)!=="svelte-rnhyr"&&(De.textContent=Bt),tt.forEach(o),Ct=n(m),S=d(m,"DIV",{class:!0});var ot=$(S);f(ge.$$.fragment,ot),Dt=n(ot),Ne=d(ot,"P",{"data-svelte-h":!0}),k(Ne)!=="svelte-3l6tv0"&&(Ne.textContent=Wt),ot.forEach(o),m.forEach(o),Ve=n(e),Fe=d(e,"P",{}),$(Fe).forEach(o),this.h()},h(){M(p,"name","hf:doc:metadata"),M(p,"content",lo),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){t(document.head,p),c(e,D,a),c(e,T,a),c(e,b,a),u(y,e,a),c(e,i,a),u(v,e,a),c(e,Pe,a),c(e,R,a),c(e,Ae,a),c(e,Z,a),c(e,He,a),c(e,z,a),c(e,je,a),u(V,e,a),c(e,Ie,a),c(e,X,a),c(e,Oe,a),u(P,e,a),c(e,Ue,a),u(B,e,a),c(e,Le,a),u(W,e,a),c(e,qe,a),c(e,G,a),c(e,Ee,a),u(Y,e,a),c(e,Se,a),c(e,Q,a),c(e,Je,a),u(K,e,a),c(e,Re,a),c(e,ee,a),c(e,Ze,a),u(te,e,a),c(e,ze,a),c(e,l,a),u(oe,l,null),t(l,rt),t(l,he),t(l,nt),t(l,N),u(re,N,null),t(N,at),t(N,_e),t(N,st),u(A,N,null),t(l,dt),t(l,w),u(ne,w,null),t(w,it),t(w,xe),t(w,ct),t(w,ke),t(w,lt),t(w,be),t(l,mt),t(l,H),u(ae,H,null),t(H,pt),t(H,ye),t(l,gt),t(l,j),u(se,j,null),t(j,ft),t(j,Te),t(l,ut),t(l,I),u(de,I,null),t(I,ht),t(I,ve),t(l,_t),t(l,O),u(ie,O,null),t(O,xt),t(O,$e),t(l,kt),t(l,U),u(ce,U,null),t(U,bt),t(U,Me),t(l,yt),t(l,L),u(le,L,null),t(L,Tt),t(L,we),t(l,vt),t(l,q),u(me,q,null),t(q,$t),t(q,Ce),t(l,Mt),t(l,E),u(pe,E,null),t(E,wt),t(E,De),t(l,Ct),t(l,S),u(ge,S,null),t(S,Dt),t(S,Ne),c(e,Ve,a),c(e,Fe,a),Xe=!0},p(e,[a]){const m={};a&2&&(m.$$scope={dirty:a,ctx:e}),P.$set(m);const F={};a&2&&(F.$$scope={dirty:a,ctx:e}),A.$set(F)},i(e){Xe||(h(y.$$.fragment,e),h(v.$$.fragment,e),h(V.$$.fragment,e),h(P.$$.fragment,e),h(B.$$.fragment,e),h(W.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(A.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(de.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(le.$$.fragment,e),h(me.$$.fragment,e),h(pe.$$.fragment,e),h(ge.$$.fragment,e),Xe=!0)},o(e){_(y.$$.fragment,e),_(v.$$.fragment,e),_(V.$$.fragment,e),_(P.$$.fragment,e),_(B.$$.fragment,e),_(W.$$.fragment,e),_(Y.$$.fragment,e),_(K.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(A.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_(se.$$.fragment,e),_(de.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(le.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),Xe=!1},d(e){e&&(o(D),o(T),o(b),o(i),o(Pe),o(R),o(Ae),o(Z),o(He),o(z),o(je),o(Ie),o(X),o(Oe),o(Ue),o(Le),o(qe),o(G),o(Ee),o(Se),o(Q),o(Je),o(Re),o(ee),o(Ze),o(ze),o(l),o(Ve),o(Fe)),o(p),x(y,e),x(v,e),x(V,e),x(P,e),x(B,e),x(W,e),x(Y,e),x(K,e),x(te,e),x(oe),x(re),x(A),x(ne),x(ae),x(se),x(de),x(ie),x(ce),x(le),x(me),x(pe),x(ge)}}}const lo='{"title":"The Tasks Manager","local":"the-tasks-manager","sections":[{"title":"Task names","local":"task-names","sections":[{"title":"PyTorch","local":"pytorch","sections":[{"title":"Transformers","local":"transformers","sections":[],"depth":4},{"title":"Diffusers","local":"diffusers","sections":[],"depth":4},{"title":"Sentence Transformers","local":"sentence-transformers","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Reference","local":"optimum.exporters.tasks.TasksManager","sections":[],"depth":2}],"depth":1}';function mo(ue){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ko extends eo{constructor(p){super(),to(this,p,mo,co,Qt,{})}}export{ko as component};
