# Dummy Input Generators

It is very common to have to generate dummy inputs to perform a task (tracing, exporting a model to some backend,
testing model outputs, etc). The goal of [DummyInputGenerator](/docs/optimum/main/en/utils/dummy_input_generators#optimum.utils.DummyInputGenerator) classes is to make this
generation easy and re-usable.


## Base class[[optimum.utils.DummyInputGenerator]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.DummyInputGenerator</name><anchor>optimum.utils.DummyInputGenerator</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L93</source><parameters>[]</parameters></docstring>

Generates dummy inputs for the supported input names, in the requested framework.



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>concat_inputs</name><anchor>optimum.utils.DummyInputGenerator.concat_inputs</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L292</source><parameters>[{"name": "inputs", "val": ""}, {"name": "dim", "val": ": int"}]</parameters><paramsdesc>- **inputs** --
  The list of tensors in a given framework to concatenate.
- **dim** (`int`) --
  The dimension along which to concatenate.</paramsdesc><paramgroups>0</paramgroups><retdesc>The tensor of the concatenation.</retdesc></docstring>

Concatenates inputs together.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>constant_tensor</name><anchor>optimum.utils.DummyInputGenerator.constant_tensor</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L245</source><parameters>[{"name": "shape", "val": ": typing.List[int]"}, {"name": "value", "val": ": typing.Union[int, float] = 1"}, {"name": "dtype", "val": ": typing.Optional[typing.Any] = None"}, {"name": "framework", "val": ": str = 'pt'"}]</parameters><paramsdesc>- **shape** (`List[int]`) --
  The shape of the constant tensor.
- **value** (`Union[int, float]`, defaults to 1) --
  The value to fill the constant tensor with.
- **dtype** (`Optional[Any]`, defaults to `None`) --
  The dtype of the constant tensor.
- **framework** (`str`, defaults to `"pt"`) --
  The requested framework.</paramsdesc><paramgroups>0</paramgroups><retdesc>A constant tensor in the requested framework.</retdesc></docstring>

Generates a constant tensor.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>generate</name><anchor>optimum.utils.DummyInputGenerator.generate</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L114</source><parameters>[{"name": "input_name", "val": ": str"}, {"name": "framework", "val": ": str = 'pt'"}, {"name": "int_dtype", "val": ": str = 'int64'"}, {"name": "float_dtype", "val": ": str = 'fp32'"}]</parameters><paramsdesc>- **input_name** (`str`) --
  The name of the input to generate.
- **framework** (`str`, defaults to `"pt"`) --
  The requested framework.
- **int_dtype** (`str`, defaults to `"int64"`) --
  The dtypes of generated integer tensors.
- **float_dtype** (`str`, defaults to `"fp32"`) --
  The dtypes of generated float tensors.</paramsdesc><paramgroups>0</paramgroups><retdesc>A tensor in the requested framework of the input.</retdesc></docstring>

Generates the dummy input matching `input_name` for the requested framework.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>pad_input_on_dim</name><anchor>optimum.utils.DummyInputGenerator.pad_input_on_dim</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L317</source><parameters>[{"name": "input_", "val": ""}, {"name": "dim", "val": ": int"}, {"name": "desired_length", "val": ": typing.Optional[int] = None"}, {"name": "padding_length", "val": ": typing.Optional[int] = None"}, {"name": "value", "val": ": typing.Union[int, float] = 1"}, {"name": "dtype", "val": ": typing.Optional[typing.Any] = None"}]</parameters><paramsdesc>- **input_** --
  The tensor to pad.
- **dim** (`int`) --
  The dimension along which to pad.
- **desired_length** (`Optional[int]`, defaults to `None`) --
  The desired length along the dimension after padding.
- **padding_length** (`Optional[int]`, defaults to `None`) --
  The length to pad along the dimension.
- **value** (`Union[int, float]`, defaults to 1) --
  The value to use for padding.
- **dtype** (`Optional[Any]`, defaults to `None`) --
  The dtype of the padding.</paramsdesc><paramgroups>0</paramgroups><retdesc>The padded tensor.</retdesc></docstring>

Pads an input either to the desired length, or by a padding length.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>random_float_tensor</name><anchor>optimum.utils.DummyInputGenerator.random_float_tensor</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L213</source><parameters>[{"name": "shape", "val": ": typing.List[int]"}, {"name": "min_value", "val": ": float = 0"}, {"name": "max_value", "val": ": float = 1"}, {"name": "framework", "val": ": str = 'pt'"}, {"name": "dtype", "val": ": str = 'fp32'"}]</parameters><paramsdesc>- **shape** (`List[int]`) --
  The shape of the random tensor.
- **min_value** (`float`, defaults to 0) --
  The minimum value allowed.
- **max_value** (`float`, defaults to 1) --
  The maximum value allowed.
- **framework** (`str`, defaults to `"pt"`) --
  The requested framework.
- **dtype** (`str`, defaults to `"fp32"`) --
  The dtype of the generated float tensor. Could be "fp32", "fp16", "bf16".</paramsdesc><paramgroups>0</paramgroups><retdesc>A random tensor in the requested framework.</retdesc></docstring>

Generates a tensor of random floats in the [min_value, max_value) range.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>random_int_tensor</name><anchor>optimum.utils.DummyInputGenerator.random_int_tensor</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L134</source><parameters>[{"name": "shape", "val": ": typing.List[int]"}, {"name": "max_value", "val": ": int"}, {"name": "min_value", "val": ": int = 0"}, {"name": "framework", "val": ": str = 'pt'"}, {"name": "dtype", "val": ": str = 'int64'"}]</parameters><paramsdesc>- **shape** (`List[int]`) --
  The shape of the random tensor.
- **max_value** (`int`) --
  The maximum value allowed.
- **min_value** (`int`, defaults to 0) --
  The minimum value allowed.
- **framework** (`str`, defaults to `"pt"`) --
  The requested framework.
- **dtype** (`str`, defaults to `"int64"`) --
  The dtype of the generated integer tensor. Could be "int64", "int32", "int8".</paramsdesc><paramgroups>0</paramgroups><retdesc>A random tensor in the requested framework.</retdesc></docstring>

Generates a tensor of random integers in the [min_value, max_value) range.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>random_mask_tensor</name><anchor>optimum.utils.DummyInputGenerator.random_mask_tensor</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L166</source><parameters>[{"name": "shape", "val": ": typing.List[int]"}, {"name": "padding_side", "val": ": str = 'right'"}, {"name": "framework", "val": ": str = 'pt'"}, {"name": "dtype", "val": ": str = 'int64'"}]</parameters><paramsdesc>- **shape** (`List[int]`) --
  The shape of the random tensor.
- **padding_side** (`str`, defaults to "right") --
  The side on which the padding is applied.
- **framework** (`str`, defaults to `"pt"`) --
  The requested framework.
- **dtype** (`str`, defaults to `"int64"`) --
  The dtype of the generated integer tensor. Could be "int64", "int32", "int8".</paramsdesc><paramgroups>0</paramgroups><retdesc>A random mask tensor either left padded or right padded in the requested framework.</retdesc></docstring>

Generates a mask tensor either right or left padded.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>supports_input</name><anchor>optimum.utils.DummyInputGenerator.supports_input</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L100</source><parameters>[{"name": "input_name", "val": ": str"}]</parameters><paramsdesc>- **input_name** (`str`) --
  The name of the input to generate.</paramsdesc><paramgroups>0</paramgroups><rettype>`bool`</rettype><retdesc>A boolean specifying whether the input is supported.</retdesc></docstring>

Checks whether the `DummyInputGenerator` supports the generation of the requested input.








</div></div>

## Existing dummy input generators[[optimum.utils.DummyTextInputGenerator]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.DummyTextInputGenerator</name><anchor>optimum.utils.DummyTextInputGenerator</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L363</source><parameters>[{"name": "task", "val": ": str"}, {"name": "normalized_config", "val": ": NormalizedTextConfig"}, {"name": "batch_size", "val": ": int = 2"}, {"name": "sequence_length", "val": ": int = 16"}, {"name": "num_choices", "val": ": int = 4"}, {"name": "random_batch_size_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "random_sequence_length_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "random_num_choices_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "padding_side", "val": ": str = 'right'"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>

Generates dummy encoder text inputs.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.DummyDecoderTextInputGenerator</name><anchor>optimum.utils.DummyDecoderTextInputGenerator</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L519</source><parameters>[{"name": "task", "val": ": str"}, {"name": "normalized_config", "val": ": NormalizedTextConfig"}, {"name": "batch_size", "val": ": int = 2"}, {"name": "sequence_length", "val": ": int = 16"}, {"name": "num_choices", "val": ": int = 4"}, {"name": "random_batch_size_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "random_sequence_length_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "random_num_choices_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "padding_side", "val": ": str = 'right'"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>

Generates dummy decoder text inputs.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.DummyPastKeyValuesGenerator</name><anchor>optimum.utils.DummyPastKeyValuesGenerator</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L620</source><parameters>[{"name": "task", "val": ": str"}, {"name": "normalized_config", "val": ": NormalizedTextConfig"}, {"name": "batch_size", "val": ": int = 2"}, {"name": "sequence_length", "val": ": int = 16"}, {"name": "random_batch_size_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "random_sequence_length_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>

Generates dummy past_key_values inputs.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.DummySeq2SeqPastKeyValuesGenerator</name><anchor>optimum.utils.DummySeq2SeqPastKeyValuesGenerator</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L667</source><parameters>[{"name": "task", "val": ": str"}, {"name": "normalized_config", "val": ": typing.Union[optimum.utils.normalized_config.NormalizedSeq2SeqConfig, optimum.utils.normalized_config.NormalizedEncoderDecoderConfig]"}, {"name": "batch_size", "val": ": int = 2"}, {"name": "sequence_length", "val": ": int = 16"}, {"name": "encoder_sequence_length", "val": ": typing.Optional[int] = None"}, {"name": "random_batch_size_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "random_sequence_length_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>

Generates dummy past_key_values inputs for seq2seq architectures.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.DummyBboxInputGenerator</name><anchor>optimum.utils.DummyBboxInputGenerator</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L755</source><parameters>[{"name": "task", "val": ": str"}, {"name": "normalized_config", "val": ": NormalizedConfig"}, {"name": "batch_size", "val": ": int = 2"}, {"name": "sequence_length", "val": ": int = 16"}, {"name": "random_batch_size_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "random_sequence_length_range", "val": ": typing.Optional[typing.Tuple[int, int]] = None"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>

Generates dummy bbox inputs.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.DummyVisionInputGenerator</name><anchor>optimum.utils.DummyVisionInputGenerator</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L795</source><parameters>[{"name": "task", "val": ": str"}, {"name": "normalized_config", "val": ": NormalizedVisionConfig"}, {"name": "batch_size", "val": ": int = 2"}, {"name": "num_channels", "val": ": int = 3"}, {"name": "width", "val": ": int = 64"}, {"name": "height", "val": ": int = 64"}, {"name": "visual_seq_length", "val": ": int = 16"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>

Generates dummy vision inputs.


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.DummyAudioInputGenerator</name><anchor>optimum.utils.DummyAudioInputGenerator</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/input_generators.py#L883</source><parameters>[{"name": "task", "val": ": str"}, {"name": "normalized_config", "val": ": NormalizedConfig"}, {"name": "batch_size", "val": ": int = 2"}, {"name": "feature_size", "val": ": int = 80"}, {"name": "nb_max_frames", "val": ": int = 3000"}, {"name": "audio_sequence_length", "val": ": int = 16000"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>