# Wie funktionieren Transformer-Modelle?

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

In diesem Abschnitt werfen wir einen Blick auf die Architektur von Transformer-Modellen.

## Kurz zur Entwicklungsgeschichte der Transformer-Modelle

Hier sind einige wichtige Meilensteine in der (kurzen) Geschichte der Transformer-Modelle:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono.svg" alt="A brief chronology of Transformers models.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_chrono-dark.svg" alt="A brief chronology of Transformers models.">
</div>

Die [Transformer-Architektur](https://arxiv.org/abs/1706.03762) wurde erstmals im Juni 2017 veröffentlicht. Der Schwerpunkt der ursprünglichen Forschung lag auf Übersetzungsaufgaben. In der Folge wurden mehrere einflussreiche Modelle veröffentlicht, darunter:

- **Juni 2018**: [GPT](https://cdn.openai.com/research-covers/language-unsupervised/language_understanding_paper.pdf), das erste vortrainierte Transformer-Modell, wurde zum Feintuning für verschiedene CL-Aufgaben eingesetzt und erzielte Ergebnisse, die dem neuesten Stand der Technik entsprachen.

- **Oktober 2018**: [BERT](https://arxiv.org/abs/1810.04805), ein weiteres großes vortrainiertes Modell, das dazu dient, bessere Zusammenfassungen von Sätzen zu erstellen (mehr dazu im nächsten Kapitel!)

- **Februar 2019**: [GPT-2](https://cdn.openai.com/better-language-models/language_models_are_unsupervised_multitask_learners.pdf), eine verbesserte (und größere) Version von GPT, die aus ethischen Erwägungen nicht sofort veröffentlicht wurde

- **Oktober 2019**: [DistilBERT](https://arxiv.org/abs/1910.01108), eine abgespeckte Version von BERT, die 60 % schneller ist, 40 % weniger Speicherplatz benötigt und dennoch 97 % der Leistung von BERT erreicht

- **Oktober 2019**: [BART](https://arxiv.org/abs/1910.13461) und [T5](https://arxiv.org/abs/1910.10683), zwei große vortrainierte Modelle, die dieselbe Architektur wie das ursprüngliche Transformer-Modell verwenden (die ersten, die dies getan haben)

- **Mai 2020**, [GPT-3](https://arxiv.org/abs/2005.14165), eine noch größere Version von GPT-2, die in der Lage ist, bei einer Vielzahl von Aufgabenstellungen gute Leistungen zu erbringen, ohne dass ein Feintuning erforderlich ist (auch _Zero-Shot Learning_ genannt)

Diese Auflistung ist bei weitem nicht vollständig und soll nur einige der verschiedenen Arten von Transformer-Modellen aufzeigen. Sie lassen sich grob in drei Kategorien einteilen:

- GPT-ähnliche (auch _autoregressive_-Transformer-Modelle genannt)
- BERT-ähnliche (auch _Auto-Encoding_-Transformer-Modelle genannt)
- BART-/T5-ähnliche (auch _Sequence-to-Sequence_-Transformer-Modelle genannt)

Wir werden uns mit diesen unterschiedlichen Modellfamilien später noch eingehender beschäftigen.

## Transformer-Modelle sind Sprachmodelle

Alle oben genannten Transformer-Modelle (GPT, BERT, BART, T5, etc.) wurden als *Sprachmodelle* (engl. Language Models) trainiert. Das bedeutet, dass sie mit großen Mengen an Rohtext auf selbstüberwachte (engl. self-supervised) Weise trainiert wurden. Selbstüberwachtes Lernen ist eine Form des Trainings, bei der die vorherzusagende Variable, die sog. Zielvariable (engl. Target), automatisch aus den Inputs des Modells berechnet wird. Das bedeutet, dass kein menschliches Zutun nötig ist, um die Daten zu labeln!

Diese Art von Modell entwickelt ein statistisches Verständnis der Sprache, auf die es trainiert wurde, ist aber für spezifische praktische Aufgaben nicht sehr nützlich. Aus diesem Grund durchläuft das allgemeine, vortrainierte Modell ein Vorgang namens *Transfer Learning*. Während dieses Vorgangs wird das Modell unter Überwachung - d. h. mit Hilfe von durch Menschen bereitgestellte Labels - für eine bestimmte Aufgabe feingetunt.

Ein Beispiel für eine Aufgabe ist die Vorhersage des nächsten Wortes in einem Satz, nachdem man die *n* vorherigen Wörter gelesen hat. Dies nennt sich *kausale Sprachmodellierung* (engl. Causal Language Modeling), da der Output von den vergangenen und aktuellen Inputs abhängt, aber nicht von den zukünftigen.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/causal_modeling-dark.svg" alt="Example of causal language modeling in which the next word from a sentence is predicted.">
</div>

Ein weiteres Beispiel ist die *maskierte Sprachmodellierung* (engl. Masked Language Modeling), bei der das Modell ein Wort im Satz, das maskiert ist, vorhersagt.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/masked_modeling-dark.svg" alt="Example of masked language modeling in which a masked word from a sentence is predicted.">
</div>

## Transformer-Modelle sind groß

Abgesehen von einigen wenigen Ausreißern (wie DistilBERT) besteht die allgemeine Strategie, um eine bessere Leistung zu erzielen, darin, die Modelle zu vergrößern und die Menge an Daten zu erhöhen, auf denen sie vortrainiert werden.

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/model_parameters.png" alt="Number of parameters of recent Transformers models" width="90%">
</div>

Leider erfordert das Training eines Modells, insbesondere eines großen, eine große Menge an Daten. Das ist sehr kostspielig in Bezug auf Zeit und Rechenleistung. Es hat sogar Auswirkungen auf die Umwelt, wie in der folgenden Grafik zu sehen ist.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint.svg" alt="The carbon footprint of a large language model.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/carbon_footprint-dark.svg" alt="The carbon footprint of a large language model.">
</div>

<Youtube id="ftWlj4FBHTg"/>

Hier ist ein Projekt zu sehen, bei dem ein Team gezielt versucht, die Umweltauswirkungen des Pretrainings (sehr großer) Modelle zu reduzieren. Wenn man die vielen Versuche berücksichtigt, die dazu nötig sind, die besten Hyperparameter zu finden, wären die zu bemessenden ökologischen Konsequenzen noch größer.

Stell dir vor, dass jedes Mal, wenn ein Forschungsteam, eine Bildungseinrichtung oder ein Unternehmen ein Modell trainieren möchte, dies von Grund auf tun müsste. Das würde zu enormen, unnötigen globalen Kosten führen!

Deshalb ist die gemeinsame Nutzung von Sprachmodellen von größter Bedeutung: trainierte Gewichtungen gemeinsam zu nutzen und auf bereits trainierten Gewichtungen aufzubauen, reduziert die gesamten Rechenkosten und den CO2-Fußabdruck der Community.


## Transfer Learning

<Youtube id="BqqfQnyjmgg" />

Beim *Pretraining* wird ein Modell von Grund auf neu trainiert: Die Gewichte werden nach dem Zufallsprinzip initialisiert und das Training beginnt ohne jegliches Vorwissen.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining.svg" alt="The pretraining of a language model is costly in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/pretraining-dark.svg" alt="The pretraining of a language model is costly in both time and money.">
</div>

Dieses Pretraining wird normalerweise mit sehr großen Datenmengen durchgeführt. Daher wird ein sehr großer Korpus an Daten benötigt und das Training kann mehrere Wochen in Anspruch nehmen.

*Feintuning* ist hingegen das Training, das **nach** dem Pretraining eines Modells durchgeführt wird. Für das Feintuning nimmst du zunächst ein vortrainiertes Sprachmodell und trainierst es dann mit einem aufgabenspezifischen Datensatz nach. Moment - warum trainierst du das Modell nicht gleich für die endgültige Aufgabe? Dafür gibt es mehrere Gründe:

* Das vortrainierte Modell wurde bereits auf einem Datensatz trainiert, der einige Ähnlichkeiten mit dem Datensatz, der für das Feintuning verwendet wird, aufweist. Beim Feintuning kann also von dem Wissen profitiert werden, das das ursprüngliche Modell während des Pretrainings erlangt hat (bei CL-Problemstellungen verfügt das vortrainierte Modell zum Beispiel über eine Art statistisches Verständnis der Sprache, die du für deine Aufgabe verwendest).
* Da das vortrainierte Modell bereits auf vielen Daten trainiert wurde, sind zum Feintuning bedeutend weniger Daten erforderlich, um brauchbare Ergebnisse erzielen zu können.
* Aus demselben Grund sind der Zeitaufwand und die Ressourcen, die für gute Ergebnisse benötigt werden, bedeutend geringer.

Man könnte zum Beispiel ein auf Englisch trainiertes Modell nutzen und es dann auf einem arXiv-Korpus feintunen, um ein auf wissenschaftliche Sprache ausgerichtetes Modell zu erstellen. Für das Feintuning wird nur eine begrenzte Menge an Daten benötigt: Das Wissen, das das vortrainierte Modell erworben hat, wird "übertragen" (engl. transferred), daher der Begriff *Transfer Learning*.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/finetuning-dark.svg" alt="The fine-tuning of a language model is cheaper than pretraining in both time and money.">
</div>

Das Feintuning eines Modells ist daher mit geringeren Zeit-, Daten-, Umwelt- und finanziellen Kosten verbunden. Es ist auch schneller und einfacher, verschiedene Modelle für das Feintuning auszuprobieren, da das Training mit geringeren Einschränkungen einhergeht als ein vollständiges Pretraining.

Dieser Ansatz führt auch zu besseren Ergebnissen als ein Training von Grund auf (es sei denn, du hast viele Daten). Deshalb solltest du immer versuchen, ein vortrainiertes Modell zu nutzen - und zwar ein Modell, das so nah wie möglich an deiner Aufgabenstellung ist - und es für das Feintuning verwenden.

## Grundlegende Architektur

In diesem Abschnitt gehen wir auf die grundlegende Architektur des Transformer-Modells ein. Mach dir keine Sorgen, wenn du einige der Konzepte nicht verstehst. Im weiteren Verlauf folgen noch ausführliche Abschnitte zu den einzelnen Komponenten.

<Youtube id="H39Z_720T5s" />

## Einführung

Das Modell besteht hauptsächlich aus zwei Blöcken:

* **Encoder (links)**: Der Encoder, auch Kodierer genannt, empfängt einen Input und erstellt eine numerische Darstellung bzw. Repräsentation des Inputs (seiner Features, im Deutschen auch als Merkmale bezeichnet). Das bedeutet, dass das Modell darauf optimiert ist, ein Verständnis vom Input zu erlangen.
* **Decoder (rechts)**: Der Decoder, auch bekannt als Dekodierer, verwendet die Repräsentation des Encoders (Features) zusammen mit anderen Inputs, um eine Zielsequenz zu generieren. Das bedeutet, dass das Modell darauf optimiert ist, einen Output zu generieren.

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers_blocks-dark.svg" alt="Architecture of a Transformers models">
</div>

Jede dieser Komponenten kann je nach Aufgabe unabhängig voneinander verwendet werden:

* **Rein Encoder-basierte Modelle** ("Encoder-only Models"): Gut für Aufgaben, die ein Verständnis des Inputs erfordern, wie z. B. bei der Klassifizierung von Sätzen und der Eigennamenerkennung (NER).
* **Rein Decoder-basierte Modelle** ("Decoder-only Models"): Gut geeignet für generative Aufgaben wie die Textgenerierung.
* **Encoder-Decoder-basierte Modelle** bzw. **Sequence-to-Sequence-Modelle**: Gut für generative Aufgaben, die einen Input erfordern, wie z. B. Übersetzungen oder Zusammenfassungen.

Wir werden diese Architekturen in späteren Abschnitten noch gesondert behandeln.

## Attention-Layer

Ein wesentliches Merkmal der Transformer-Modelle ist, dass sie mit speziellen Layern (im Deutschen auch als Schichten bezeichnet), den *Attention-Layern*, aufgebaut sind. Der Titel des Forschungsbeitrags, in dem die Transformer-Architektur vorgestellt wurde, lautete sogar ["Attention Is All You Need"](https://arxiv.org/abs/1706.03762)! Wir werden uns später im Kurs mit den Details von Attention-Layern befassen. Für den Moment musst du nur wissen, dass dieser Layer dem Modell sagt, dass es bei der Repräsentation eines jeden Worts in einem Satz, den du ihm übergeben hast, bestimmten Wörtern besondere Aufmerksamkeit schenken (und die anderen mehr oder weniger ignorieren) soll.

Angenommen, du sollst einen Text aus dem Englischen ins Französische übersetzen. Bei dem Input "You like this course" muss ein Übersetzungsmodell auch das angrenzende Wort "You" berücksichtigen, um die richtige Übersetzung für das Wort "like" zu erhalten, denn im Französischen wird das Verb "like" je nach Subjekt unterschiedlich konjugiert. Der Rest des Satzes ist jedoch für die Übersetzung dieses Wortes nicht hilfreich. Genauso muss das Modell bei der Übersetzung von "this" auf das Wort "course" achten, denn "this" wird unterschiedlich übersetzt, je nachdem, ob das zugehörige Substantiv männlich oder weiblich ist. Auch hier spielen die anderen Wörter im Satz für die Übersetzung von "this" keine Rolle. Bei komplexeren Sätzen (und komplexeren Grammatikregeln) muss das Modell besonders auf Wörter achten, die weiter entfernt im Satz vorkommen, um jedes Wort richtig zu übersetzen.

Das gleiche Konzept gilt für jede Aufgabenstellung, die mit natürlicher Sprache zu tun hat: Ein Wort an sich hat eine Bedeutung, aber diese Bedeutung hängt stark vom Kontext ab, der sich durch ein anderes Wort (oder Wörter) vor oder nach dem untersuchten Wort ergibt.

Nachdem du nun eine Vorstellung davon hast, worum es bei Attention-Layern geht, nehmen wir die Transformer-Architektur genauer unter die Lupe.

## Die ursprüngliche Architektur

Die Transformer-Architektur wurde ursprünglich für die maschinelle Übersetzung entwickelt. Beim Training erhält der Encoder Inputs (Sätze) in einer bestimmten Sprache, während der Decoder die gleichen Sätze in der gewünschten Zielsprache erhält. Im Encoder können die Attention-Layer alle Wörter eines Satzes verwenden (denn wie wir gerade gesehen haben, kann die Übersetzung eines bestimmten Wortes sowohl von dem abhängen, was nach, als auch von dem, was vor dem Wort im Satz steht). Der Decoder arbeitet hingegen sequentiell und kann nur die Wörter im Satz berücksichtigen, die er bereits übersetzt hat (also nur die Wörter vor dem Wort, das gerade generiert wird). Wenn wir zum Beispiel die ersten drei Wörter der übersetzten Zielsequenz vorhergesagt haben, geben wir sie an den Decoder weiter, der dann alle Inputs des Encoders verwendet, um das vierte Wort vorherzusagen.

Um das Training zu beschleunigen (insofern das Modell Zugriff auf die Zielsätze hat), wird der Decoder mit dem gesamten (vorherzusagenden) Zielsatz gefüttert, aber er darf keine nachfolgenden Wörter verwenden (wenn er Zugriff zum Wort an Position 2 hätte, während er versucht, das Wort an Position 2 vorherzusagen, wäre die Aufgabe nicht sonderlich schwer!). Wenn er zum Beispiel versucht, das vierte Wort vorherzusagen, hat der Attention-Layer nur Zugriff zu den Wörtern an den Positionen 1 bis 3.

Die ursprüngliche Transformer-Architektur sah wie folgt aus - mit dem Encoder auf der linken und dem Decoder auf der rechten Seite:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers.svg" alt="Architecture of a Transformers models">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/transformers-dark.svg" alt="Architecture of a Transformers models">
</div>

Beachte, dass die Attention des ersten Attention-Layers in einem Decoder-Block alle (vorangegangenen) Inputs, die der Decoder erhalten hat, berücksichtigt, während der zweite Attention-Layer den Output des Encoders verwendet. Im Rahmen der Vorhersage des aktuellen Wortes kann er also auf den gesamten Input-Satz zugreifen. Das ist vor allem deshalb nützlich, da es in den verschiedenen Sprachen unterschiedliche grammatikalische Regeln geben kann, wodurch die Wörter in einer anderen Reihenfolge aneinandergereiht werden. Ebenso könnte ein erst später im Satz enthaltener Zusammenhang dabei hilfreich sein, die beste Übersetzung eines bestimmten Wortes zu bestimmen.

Die *Attention-Mask* kann auch im Encoder bzw. Decoder verwendet werden, um zu verhindern, dass das Modell bestimmte Wörter beachtet - zum Beispiel das spezielle Füllwort (engl. Padding Word), das verwendet wird, um alle Inputs auf die gleiche Länge zu bringen, wenn die Sätze zu Batches zusammengeführt werden.

##  Architekturen vs. Checkpoints

Wenn wir uns in diesem Kurs mit Transformer-Modellen beschäftigen, wirst du auf *Architekturen*, *Checkpoints* und auch auf *Modelle* stoßen. Diese Begriffe haben alle eine etwas unterschiedliche Bedeutung:

* **Architektur**: Dies ist das Skelett des Modells - die Definition jedes Layers und jeder Operation, die innerhalb des Modells stattfindet.
* **Checkpoints**: Dies ist die Gewichtung, die für eine bestimmte Architektur geladen wird.
* **Modell**: Dies ist ein Oberbegriff, der nicht so präzise ist wie "Architektur" oder "Checkpoint": Er kann beides bedeuten. In diesem Kurs wird jeweils explizit spezifiziert, ob es sich um eine *Architektur* oder um einen *Checkpoint* handelt, um Zweideutigkeiten zu vermeiden.

BERT ist zum Beispiel eine Architektur, während `bert-base-cased` - ein Satz von Gewichten, der vom Google-Team für die erste Version von BERT trainiert wurde - ein Checkpoint ist. Man kann aber auch "das BERT-Modell" oder "das `bert-base-cased`-Modell" sagen.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/de/chapter1/4.mdx" />