# Quiz am Ende des Kapitels

<CourseFloatingBanner
    chapter={3}
    classNames="absolute z-10 right-0 top-0"
/>

Teste, was du in diesem Kapitel gelernt hast!

### 1. Der Datensatz `emotion` enthält Twitter-Nachrichten, die mit Emotionen gelabelt sind. Suche im [Hub](https://huggingface.co/datasets) nach dem Datensatz und lies die Datensatzkarte. Welche der folgenden Emotionen gehört nicht zu den grundlegenden Emotionen?

<Question
	choices={[
		{
			text: "Joy (Freude)",
			explain: "Versuch es noch einmal - diese Emotion ist in diesem Datensatz vorhanden!"
		},
		{
			text: "Love (Liebe)",
			explain: "Versuch es noch einmal - diese Emotion ist in diesem Datensatz vorhanden!"
		},
		{
			text: "Confusion (Verwirrung)",
			explain: "Richtig! Verwirrung gehört nicht zu den sechs Grundemotionen.",
            correct: true
		},
        {
			text: "Surprise (Überraschung)",
			explain: "Überraschung! Probier eine andere!"
		}
	]}
/>

### 2. Suche im [Hub](https://huggingface.co/datasets) nach dem Datensatz `ar_sarcasm`. Welche Aufgabe unterstützt er?

<Question
	choices={[
		{
			text: "Sentiment classification (Sentiment-Klassifizierung)",
			explain: "Das ist richtig! Das erkennst du an den Tags.",
            correct: true
		},
		{
			text: "Machine translation (Maschinelle Übersetzung)",
			explain: "Das war's noch nicht - sieh dir noch einmal die <a href='https://huggingface.co/datasets/ar_sarcasm'>Datensatzkarte</a> an!"
		},
		{
			text: "Named entity recognition (Eigennamenerkennung )",
			explain: "Das war's noch nicht - schau dir noch mal die <a href='https://huggingface.co/datasets/ar_sarcasm'>Datensatzkarte</a> an!"
		},
        {
			text: "Question answering (Fragenbeantwortung)",
			explain: "Leider wurde diese Frage nicht richtig beantwortet. Versuche es noch einmal!"
		}
	]}
/>

### 3. Wie erwartet das BERT Modell, dass ein Satzpaar verarbeitet wird?

<Question
	choices={[
		{
			text: "Satztoken_1 [SEP] Satztoken_2",
			explain: "Ein <code>[SEP]</code> spezielles Token wird benötigt, um die beiden Sätze zu trennen, aber das ist nicht das Einzige!"
		},
		{
			text: "[CLS] Satztoken_1 Satztoken_2",
			explain: "Ein <code>[CLS]</code> spezielles Token ist am Anfang erforderlich, aber das ist nicht das Einzige!"
		},
		{
			text: "[CLS] Satztoken_1 [SEP] Satztoken_2 [SEP]",
			explain: "Das ist richtig!",
            correct: true
		},
        {
			text: "[CLS] Satztoken_1 [SEP] Satztoken_2",
			explain: "Ein <code>[CLS]</code> spezielles Token wird am Anfang benötigt, sowie ein <code>[SEP]</code> spezielles Token, um die beiden Sätze zu trennen, aber das ist noch nicht alles!"
		}
	]}
/>

{#if fw === 'pt'}
### 4. Was sind die Vorteile der Methode `Dataset.map()`?

<Question
	choices={[
		{
			text: "Die Ergebnisse der Funktion werden im Cache zwischengespeichert, sodass es keine Zeit kostet, wenn wir den Code erneut ausführen.",
			explain: "Das ist tatsächlich einer der tollen Vorteile dieser Methode! Es ist aber nicht der einzige...",
            correct: true
		},
		{
			text: "Sie kann Multiprocessing anwenden, um schneller zu sein, als die Funktion auf jedes Element des Datensatzes anzuwenden.",
			explain: "Das ist ein nettes Feature dieser Methode, aber es ist nicht das einzige!",
            correct: true
		},
		{
			text: "Es wird nicht der gesamte Datensatz in den Speicher geladen, sondern die Ergebnisse werden gespeichert, sobald ein Element verarbeitet wurde.",
			explain: "Das ist ein Vorteil dieser Methode. Es gibt aber noch andere!",
            correct: true
		},
	]}
/>

### 5. Was bedeutet dynamisches Padding?

<Question
	choices={[
		{
			text: "Das ist, wenn du die Eingaben für jeden Batch auf die maximale Länge des gesamten Datensatzes auffüllst.",
			explain: "Bei der Erstellung des Batches wird zwar aufgefüllt, aber nicht auf die maximale Länge des gesamten Datensatzes."
		},
		{
			text: "Wenn du deine Eingaben bei der Erstellung des Batches auf die maximale Länge der Sätze in diesem Batch auffüllst.",
			explain: "Das ist richtig! Der 'dynamische' Teil kommt daher, dass die Größe jedes Batches zum Zeitpunkt der Erstellung festgelegt wird und alle deine Batches daher unterschiedliche Formen haben können.",
            correct: true
		},
		{
			text: "Das ist, wenn du deine Eingaben so auffüllst, dass jeder Satz die gleiche Anzahl von Token hat wie der vorherige im Datensatz.",
			explain: "Das ist nicht richtig, außerdem macht es keinen Sinn, sich die Reihenfolge im Datensatz anzusehen, da wir ihn beim Training mischen."
		},
	]}
/>

### 6. Welchen Zweck hat die Funktion collate?

<Question
	choices={[
		{
			text: "Sie stellt sicher, dass alle Sequenzen im Datensatz die gleiche Länge haben.",
			explain: "Eine collate Funktion befasst sich mit der Bearbeitung einzelner Batches, nicht des gesamten Datensatzes. Außerdem geht es hier um allgemeine Funktionen zum Sortieren, nicht um <code>DataCollatorWithPadding</code> im Speziellen."
		},
		{
			text: "Er stellt alle Proben in einem Batch zusammen.",
			explain: "Richtig! Du kannst die collate Funktion als Argument eines <code>DataLoaders</code> übergeben. Wir haben die Funktion <code>DataCollatorWithPadding</code> verwendet, die alle Elemente in einem Batch auffüllt, damit sie die gleiche Länge haben.",
            correct: true
		},
		{
			text: "Es wird der gesamte Datensatz vorverarbeitet.",
			explain: "Das wäre eine Vorverarbeitungsfunktion, keine Zusammenfassungsfunktion wie <code>collate</code>."
		},
        {
			text: "Sie schneidet die Sequenzen im Datensatz ab.",
			explain: "Eine collate Funktion behandelt einzelne Batches, nicht den gesamten Datensatz. Wenn du am Abschneiden interessiert bist, kannst du das <code>truncate</code> Argument von dem <code>tokenizer</code> verwenden."
		}
	]}
/>

### 7. Was passiert, wenn du eine der Klassen `AutoModelForXxx` mit einem vortrainierten Sprachmodell (z. B. `bert-base-uncased`) instanziierst, das einer anderen Aufgabe entspricht als der, für die es trainiert wurde?

<Question
	choices={[
		{
			text: "Nichts, aber du bekommst eine Warnung.",
			explain: "Du bekommst eine Warnung, aber das ist noch nicht alles!"
		},
		{
			text: "Der Kopf des vorher trainierten Modells wird verworfen und stattdessen ein neuer Kopf eingefügt, der für die Aufgabe geeignet ist.",
			explain: "Korrekt. Wenn wir zum Beispiel <code>AutoModelForSequenceClassification</code> mit <code>bert-base-uncased</code> verwendet haben, bekamen wir beim Instanziieren des Modells Warnungen. Der trainierte Kopf wird nicht für die Sequenzklassifizierung verwendet, also wird er verworfen und ein neuer Kopf mit zufälliger Gewichtung wird instanziiert.",
            correct: true
		},
		{
			text: "Der Kopf des vorher trainierten Modells wird verworfen.",
			explain: "Es muss etwas anderes passieren. Versuch es noch einmal!"
		},
        {
			text: "Nichts, da das Modell noch für die andere Aufgabe fein-tunen kann.",
			explain: "Der Kopf des trainierten Modells wurde nicht für die Lösung dieser Aufgabe trainiert, also sollte der Kopf verworfen werden!"
		}
	]}
/>

### 8. Was ist der Zweck von `TrainingArguments`?

<Question
	choices={[
		{
			text: "Sie enthält alle Hyperparameter, die für das Training und die Auswertung mit dem <code>Trainer</code> verwendet werden.",
			explain: "Richtig!",
            correct: true
		},
		{
			text: "Hier wird die Größe des Modells angegeben.",
			explain: "Die Größe des Modells wird durch die Konfiguration des Modells festgelegt, nicht durch die Klasse <code>TrainingArguments</code>."
		},
		{
			text: "Sie enthält nur die Hyperparameter, die für die Auswertung verwendet werden.",
			explain: "In unserem Beispiel haben wir angegeben, wo das Modell und seine Kontrollpunkte gespeichert werden sollen. Versuche es noch einmal!"
		},
        {
			text: "Er enthält nur die Hyperparameter, die für das Training verwendet werden.",
			explain: "In unserem Beispiel haben wir auch eine <code>Auswertungsstrategie</code> verwendet, was sich auf die Auswertung auswirkt. Versuche es noch einmal!"
		}
	]}
/>

### 9. Warum solltest du die 🤗 Accelerate Bibliothek benutzen?

<Question
	choices={[
		{
			text: "Sie bietet Zugang zu schnelleren Modellen.",
			explain: "Nein, die 🤗 Accelerate Bibliothek stellt keine Modelle zur Verfügung."
		},
		{
			text: "Sie bietet eine High-Level-API, damit ich keine eigene Trainingsschleife implementieren muss.",
			explain: "Das haben wir mit <code>Trainer</code> gemacht, nicht mit der 🤗 Accelerate Bibliothek. Versuch es noch einmal!"
		},
		{
			text: "Damit funktionieren unsere Trainingsschleifen bei verteilten Strategien.",
			explain: "Richtig! Mit 🤗 Accelerate funktionieren deine Trainingsschleifen für mehrere verteilte GPUs und TPUs.",
            correct: true
		},
        {
			text: "Es bietet mehr Funktionen zur Optimierung.",
			explain: "Nein, die 🤗 Accelerate Bibliothek stellt keine Optimierungsfunktionen zur Verfügung."
		}
	]}
/>

{:else}
### 4. Was passiert, wenn du eine der Klassen `TFAutoModelForXxx` mit einem vortrainierten Sprachmodell (z. B. `bert-base-uncased`) instanziierst, das einer anderen Aufgabe entspricht als der, für die es trainiert wurde?

<Question
	choices={[
		{
			text: "Nichts, aber du bekommst eine Warnung.",
			explain: "Du bekommst eine Warnung, aber das ist noch nicht alles!"
		},
		{
			text: "Der Kopf des vorher trainierten Modells wird verworfen und stattdessen ein neuer Kopf eingefügt, der für die Aufgabe geeignet ist.",
			explain: "correct. Wenn wir zum Beispiel <code>TFAutoModelForSequenceClassification</code> mit <code>bert-base-uncased</code> verwendet haben, bekamen wir beim Instanziieren des Modells Warnungen. Der trainierte Kopf wird nicht für die Sequenzklassifizierung verwendet, also wird er verworfen und ein neuer Kopf mit zufälligen Gewichten instanziiert.",
            correct: true
		},
		{
			text: "Der Kopf des vorher trainierten Modells wird verworfen.",
			explain: "Es muss etwas anderes passieren. Versuch es noch einmal!"
		},
        {
			text: "Nichts, da das Modell noch für die andere Aufgabe fein-tunen kann.",
			explain: "Der Kopf des trainierten Modells wurde nicht für die Lösung dieser Aufgabe trainiert, also sollten wir den Kopf verwerfen!"
		}
	]}
/>

### 5. Die Tensorflow Modelle von `transformers` sind bereits Keras Modelle. Welchen Vorteil bietet das?

<Question
	choices={[
		{
			text: "Die Modelle funktionieren sofort auf einem TPU.",
			explain: "Fast! Es sind einige kleine zusätzliche Änderungen erforderlich. Zum Beispiel musst du alles in einem <code>TPUStrategy</code>-Bereich ausführen, einschließlich der Initialisierung des Modells."
		},
		{
			text: "Du kannst bestehende Methoden wie <code>compile()</code>, <code>fit()<c/ode> und <code>predict()</code> nutzen.",
			erklären: "Richtig! Wenn du erst einmal die Daten hast, erfordert das Training mit ihnen nur noch wenig Arbeit.",
            correct: true
		},
		{
			text: "Du lernst sowohl Keras als auch Transformer kennen.",
			explain: "Korrekt, aber wir suchen nach etwas anderem :)",
			correct: true
		},
        {
			text: "Du kannst ganz einfach Metriken für den Datensatz berechnen.",
			explain: "Keras hilft uns beim Training und der Auswertung des Modells, nicht bei der Berechnung von datensatzbezogenen Metriken."
		}
	]}
/>

### 6. Wie kannst du deine eigene benutzerdefinierte Metrik definieren?

<Question
	choices={[
		{
			text: "Indem du wir eine Unterklasse von <code>tf.keras.metrics.Metric</code> erstellen.",
			explain: "Großartig!",
			correct: true
		},
		{
			text: "Durch Verwendung der funktionalen Keras-API.",
			explain: "Versuch es noch einmal!"
		},
		{
			text: "Durch die Verwendung einer Callable mit der Signatur <code>metric_fn(y_true, y_pred)</code>.",
			explain: "Korrekt!",
			correct: true
		},
        {
			text: "Indem du es googelst.",
			explain: "Das ist nicht die Antwort, nach der wir suchen, aber es sollte dir helfen, sie zu finden.",
			correct: true
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/de/chapter3/6.mdx" />