import{s as Dt,a as be,o as Ot}from"../chunks/scheduler.cc52f4b9.js";import{S as el,i as tl,e as i,s as a,c,q as Pt,h as ll,a as p,d as l,b as o,f as x,g as u,j as r,r as Kt,k as n,l as J,m as s,n as d,t as h,o as m,p as y}from"../chunks/index.5b747fde.js";import{T as sl}from"../chunks/Tip.f0925d57.js";import{C as al,H as he,E as ol}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{C as ge}from"../chunks/CodeBlock.665bfc37.js";import{C as nl}from"../chunks/CourseFloatingBanner.b33fcd79.js";function il(Te){let M;return{c(){M=Pt("🙋If you're not familiar with the `with` statement in Python, we recommend checking out the excellent [tutorial](https://realpython.com/python-with-statement/) from Real Python. Come back here after reading that 🤗")},l(j){M=Kt(j,"🙋If you're not familiar with the `with` statement in Python, we recommend checking out the excellent [tutorial](https://realpython.com/python-with-statement/) from Real Python. Come back here after reading that 🤗")},m(j,k){s(j,M,k)},d(j){j&&l(M)}}}function pl(Te){let M,j,k,Ce,B,Je,G,je,$,xe,R,Ut="In the previous sections we have explored and created demos using the <code>Interface</code> class. In this section we will introduce our <strong>newly developed</strong> low-level API called <code>gradio.Blocks</code>.",Ie,E,bt="Now, what’s the difference between <code>Interface</code> and <code>Blocks</code>?",ve,Z,gt="<li><p>⚡ <code>Interface</code>: a high-level API that allows you to create a full machine learning demo simply by providing a list of inputs and outputs.</p></li> <li><p>🧱 <code>Blocks</code>: a low-level API that allows you to have full control over the data flows and layout of your application. You can build very complex, multi-step applications using <code>Blocks</code> (as in “building blocks”).</p></li>",ke,_,Be,H,Tt="As we saw in the previous sections, the <code>Interface</code> class allows you to easily create full-fledged machine learning demos with just a few lines of code. The <code>Interface</code> API is extremely easy to use but lacks the flexibility that the <code>Blocks</code> API provides. For example, you might want to:",Ge,S,Ct="<li>Group together related demos as multiple tabs in one web application</li> <li>Change the layout of your demo, e.g. to specify where the inputs and outputs are located</li> <li>Have multi-step interfaces, in which the output of one model becomes the input to the next model, or have more flexible data flows in general</li> <li>Change a component’s properties (for example, the choices in a dropdown) or its visibility based on user input</li>",$e,Q,Jt="We will explore all of these concepts below.",Re,A,Ee,W,jt="After you have installed Gradio, run the code below as a Python script, a Jupyter notebook, or a Colab notebook.",Ze,X,_e,w,xt,He,V,It="This simple example above introduces 4 concepts that underlie Blocks:",Se,T,I,me,vt="Blocks allow you to build web applications that combine markdown, HTML, buttons, and interactive components simply by instantiating objects in Python inside of a <code>with gradio.Blocks</code> context.",mt,v,yt,Mt,ye,kt="<p>You can define regular Python functions anywhere in your code and run them with user input using <code>Blocks</code>. In our example, we have a simple function that “flips” the input text, but you can write any Python function, from a simple calculation to processing the predictions from a machine learning model.</p>",wt,Me,Bt='<p>You can assign events to any <code>Blocks</code> component. This will run your function when the component is clicked, changed, etc. When you assign an event, you pass in three parameters: <code>fn</code>: the function that should be called, <code>inputs</code>: the (list) of input component(s), and <code>outputs</code>: the (list) of output components that should be called.</p> <p>In the example above, we run the <code>flip_text()</code> function when the value in the <code>Textbox</code> named input <code>input</code> changes. The event reads the value in <code>input</code>, passes it as the name parameter to <code>flip_text()</code>, which then returns a value that gets assigned to our second <code>Textbox</code> named <code>output</code>.</p> <p>To see a list of events that each component supports, see the Gradio <a href="https://www.gradio.app/docs/" rel="nofollow">documentation</a>.</p>',ft,we,Gt="<p>Blocks automatically figures out whether a component should be interactive (accept user input) or not, based on the event triggers you define. In our example, the first textbox is interactive, since its value is used by the <code>flip_text()</code> function. The second textbox is not interactive, since its value is never used as an input. In some cases, you might want to override this, which you can do by passing a boolean to the <code>interactive</code> parameter of the component (e.g. <code>gr.Textbox(placeholder=&quot;Flip this text&quot;, interactive=True)</code>).</p>",Qe,z,Ae,L,$t="How can we use <code>Blocks</code> to customize the layout of our demo? By default, <code>Blocks</code> renders the components that you create vertically in one column. You can change that by creating additional columns <code>with gradio.Column():</code> or rows <code>with gradio.Row():</code> and creating components within those contexts.",We,Y,Rt='Here’s what you should keep in mind: any components created under a <code>Column</code> (this is also the default) will be laid out vertically. Any component created under a <code>Row</code> will be laid out horizontally, similar to the <a href="https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Flexible_Box_Layout/Basic_Concepts_of_Flexbox" rel="nofollow">flexbox model in web development</a>.',Xe,N,Et="Finally, you can also create tabs for your demo by using the <code>with gradio.Tabs()</code> context manager. Within this context, you can create multiple tabs by specifying <code>with gradio.TabItem(name_of_tab):</code> children. Any component created inside of a <code>with gradio.TabItem(name_of_tab):</code> context appears in that tab.",Ve,q,Zt="Now let’s add a <code>flip_image()</code> function to our demo and add a new tab that flips images. Below is an example with 2 tabs and also uses a Row:",ze,F,Le,f,_t,Ye,P,Ht="You’ll notice that in this example, we’ve also created a <code>Button</code> component in each tab, and we’ve assigned a click event to each button, which is what actually runs the function.",Ne,K,qe,D,St="Just as you can control the layout, <code>Blocks</code> gives you fine-grained control over what events trigger function calls. Each component and many layouts have specific events that they support.",Fe,O,Qt="For example, the <code>Textbox</code> component has 2 events: <code>change()</code> (when the value inside of the textbox changes), and <code>submit()</code> (when a user presses the enter key while focused on the textbox). More complex components can have even more events: for example, the <code>Audio</code> component also has separate events for when the audio file is played, cleared, paused, etc. See the documentation for the events each component supports.",Pe,ee,At="You can attach event trigger to none, one, or more of these events. You create an event trigger by calling the name of the event on the component instance as a function — e.g. <code>textbox.change(...)</code> or <code>btn.click(...)</code>. The function takes in three parameters, as discussed above:",Ke,te,Wt="<li><code>fn</code>: the function to run</li> <li><code>inputs</code>: a (list of) component(s) whose values should supplied as the input parameters to the function. Each component’s value gets mapped to the corresponding function parameter, in order. This parameter can be None if the function does not take any parameters.</li> <li><code>outputs</code>: a (list of) component(s) whose values should be updated based on the values returned by the function. Each return value sets the corresponding component’s value, in order. This parameter can be None if the function does not return anything.</li>",De,le,Xt="You can even make the input and output component be the same component, as we do in this example that uses a GPT model to do text completion:",Oe,se,et,U,Vt,tt,ae,lt,oe,zt="In some cases, you might want a <em>multi-step demo</em>, in which you reuse the output of one function as the input to the next. This is really easy to do with <code>Blocks</code>, as you can use a component for the input of one event trigger but the output of another. Take a look at the text component in the example below, its value is the result of a speech-to-text model, but also gets passed into a sentiment analysis model:",st,ne,at,b,Lt,ot,ie,nt,pe,Yt="So far, we have seen how to create events to update the value of another component. But what happens if you want to change other properties of a component, like the visibility of a textbox or the choices in a radio button group? You can do this by returning a component class’s <code>update()</code> method instead of a regular return value from your function.",it,re,Nt="This is most easily illustrated with an example:",pt,ce,rt,g,qt,ct,ue,Ft='We just explored all the core concepts of <code>Blocks</code>! Just like with <code>Interfaces</code>, you can create cool demos that can be shared by using <code>share=True</code> in the <code>launch()</code> method or deployed on <a href="https://huggingface.co/spaces" rel="nofollow">Hugging Face Spaces</a>.',ut,de,dt,fe,ht;return B=new al({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),G=new he({props:{title:"Introduction to Gradio Blocks",local:"introduction-to-gradio-blocks",headingTag:"h1"}}),$=new nl({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section7.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section7.ipynb"}]}}),_=new he({props:{title:"Why Blocks 🧱?",local:"why-blocks-",headingTag:"h3"}}),A=new he({props:{title:"Creating a simple demo using Blocks",local:"creating-a-simple-demo-using-blocks",headingTag:"h3"}}),X=new ge({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGZsaXBfdGV4dCh4KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHglNUIlM0ElM0EtMSU1RCUwQSUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQXdpdGglMjBkZW1vJTNBJTBBJTIwJTIwJTIwJTIwZ3IuTWFya2Rvd24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwRmxpcCUyMFRleHQhJTBBJTIwJTIwJTIwJTIwU3RhcnQlMjB0eXBpbmclMjBiZWxvdyUyMHRvJTIwc2VlJTIwdGhlJTIwb3V0cHV0LiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpbnB1dCUyMCUzRCUyMGdyLlRleHRib3gocGxhY2Vob2xkZXIlM0QlMjJGbGlwJTIwdGhpcyUyMHRleHQlMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuVGV4dGJveCgpJTBBJTBBJTIwJTIwJTIwJTIwaW5wdXQuY2hhbmdlKGZuJTNEZmxpcF90ZXh0JTJDJTIwaW5wdXRzJTNEaW5wdXQlMkMlMjBvdXRwdXRzJTNEb3V0cHV0KSUwQSUwQWRlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">flip_text</span>(<span class="hljs-params">x</span>):
    <span class="hljs-keyword">return</span> x[::-<span class="hljs-number">1</span>]


demo = gr.Blocks()

<span class="hljs-keyword">with</span> demo:
    gr.Markdown(
        <span class="hljs-string">&quot;&quot;&quot;
    # Flip Text!
    Start typing below to see the output.
    &quot;&quot;&quot;</span>
    )
    <span class="hljs-built_in">input</span> = gr.Textbox(placeholder=<span class="hljs-string">&quot;Flip this text&quot;</span>)
    output = gr.Textbox()

    <span class="hljs-built_in">input</span>.change(fn=flip_text, inputs=<span class="hljs-built_in">input</span>, outputs=output)

demo.launch()`,wrap:!1}}),v=new sl({props:{$$slots:{default:[il]},$$scope:{ctx:Te}}}),z=new he({props:{title:"Customizing the layout of your demo",local:"customizing-the-layout-of-your-demo",headingTag:"h3"}}),F=new ge({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQSUwQWRlZiUyMGZsaXBfdGV4dCh4KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHglNUIlM0ElM0EtMSU1RCUwQSUwQSUwQWRlZiUyMGZsaXBfaW1hZ2UoeCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBucC5mbGlwbHIoeCklMEElMEElMEF3aXRoJTIwZGVtbyUzQSUwQSUyMCUyMCUyMCUyMGdyLk1hcmtkb3duKCUyMkZsaXAlMjB0ZXh0JTIwb3IlMjBpbWFnZSUyMGZpbGVzJTIwdXNpbmclMjB0aGlzJTIwZGVtby4lMjIpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGdyLlRhYnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBnci5UYWJJdGVtKCUyMkZsaXAlMjBUZXh0JTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBnci5Sb3coKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHRfaW5wdXQlMjAlM0QlMjBnci5UZXh0Ym94KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0X291dHB1dCUyMCUzRCUyMGdyLlRleHRib3goKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHRfYnV0dG9uJTIwJTNEJTIwZ3IuQnV0dG9uKCUyMkZsaXAlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGdyLlRhYkl0ZW0oJTIyRmxpcCUyMEltYWdlJTIyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBnci5Sb3coKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlX2lucHV0JTIwJTNEJTIwZ3IuSW1hZ2UoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlX291dHB1dCUyMCUzRCUyMGdyLkltYWdlKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZV9idXR0b24lMjAlM0QlMjBnci5CdXR0b24oJTIyRmxpcCUyMiklMEElMEElMjAlMjAlMjAlMjB0ZXh0X2J1dHRvbi5jbGljayhmbGlwX3RleHQlMkMlMjBpbnB1dHMlM0R0ZXh0X2lucHV0JTJDJTIwb3V0cHV0cyUzRHRleHRfb3V0cHV0KSUwQSUyMCUyMCUyMCUyMGltYWdlX2J1dHRvbi5jbGljayhmbGlwX2ltYWdlJTJDJTIwaW5wdXRzJTNEaW1hZ2VfaW5wdXQlMkMlMjBvdXRwdXRzJTNEaW1hZ2Vfb3V0cHV0KSUwQSUwQWRlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">flip_text</span>(<span class="hljs-params">x</span>):
    <span class="hljs-keyword">return</span> x[::-<span class="hljs-number">1</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">flip_image</span>(<span class="hljs-params">x</span>):
    <span class="hljs-keyword">return</span> np.fliplr(x)


<span class="hljs-keyword">with</span> demo:
    gr.Markdown(<span class="hljs-string">&quot;Flip text or image files using this demo.&quot;</span>)
    <span class="hljs-keyword">with</span> gr.Tabs():
        <span class="hljs-keyword">with</span> gr.TabItem(<span class="hljs-string">&quot;Flip Text&quot;</span>):
            <span class="hljs-keyword">with</span> gr.Row():
                text_input = gr.Textbox()
                text_output = gr.Textbox()
            text_button = gr.Button(<span class="hljs-string">&quot;Flip&quot;</span>)
        <span class="hljs-keyword">with</span> gr.TabItem(<span class="hljs-string">&quot;Flip Image&quot;</span>):
            <span class="hljs-keyword">with</span> gr.Row():
                image_input = gr.Image()
                image_output = gr.Image()
            image_button = gr.Button(<span class="hljs-string">&quot;Flip&quot;</span>)

    text_button.click(flip_text, inputs=text_input, outputs=text_output)
    image_button.click(flip_image, inputs=image_input, outputs=image_output)

demo.launch()`,wrap:!1}}),K=new he({props:{title:"Exploring events and state",local:"exploring-events-and-state",headingTag:"h3"}}),se=new ge({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWFwaSUyMCUzRCUyMGdyLkludGVyZmFjZS5sb2FkKCUyMmh1Z2dpbmdmYWNlJTJGRWxldXRoZXJBSSUyRmdwdC1qLTZCJTIyKSUwQSUwQSUwQWRlZiUyMGNvbXBsZXRlX3dpdGhfZ3B0KHRleHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlJTIwdGhlJTIwbGFzdCUyMDUwJTIwY2hhcmFjdGVycyUyMG9mJTIwdGhlJTIwdGV4dCUyMGFzJTIwY29udGV4dCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlNUIlM0EtNTAlNUQlMjAlMkIlMjBhcGkodGV4dCU1Qi01MCUzQSU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB0ZXh0Ym94JTIwJTNEJTIwZ3IuVGV4dGJveChwbGFjZWhvbGRlciUzRCUyMlR5cGUlMjBoZXJlJTIwYW5kJTIwcHJlc3MlMjBlbnRlci4uLiUyMiUyQyUyMGxpbmVzJTNENCklMEElMjAlMjAlMjAlMjBidG4lMjAlM0QlMjBnci5CdXR0b24oJTIyR2VuZXJhdGUlMjIpJTBBJTBBJTIwJTIwJTIwJTIwYnRuLmNsaWNrKGNvbXBsZXRlX3dpdGhfZ3B0JTJDJTIwdGV4dGJveCUyQyUyMHRleHRib3gpJTBBJTBBZGVtby5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

api = gr.Interface.load(<span class="hljs-string">&quot;huggingface/EleutherAI/gpt-j-6B&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">complete_with_gpt</span>(<span class="hljs-params">text</span>):
    <span class="hljs-comment"># Use the last 50 characters of the text as context</span>
    <span class="hljs-keyword">return</span> text[:-<span class="hljs-number">50</span>] + api(text[-<span class="hljs-number">50</span>:])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    textbox = gr.Textbox(placeholder=<span class="hljs-string">&quot;Type here and press enter...&quot;</span>, lines=<span class="hljs-number">4</span>)
    btn = gr.Button(<span class="hljs-string">&quot;Generate&quot;</span>)

    btn.click(complete_with_gpt, textbox, textbox)

demo.launch()`,wrap:!1}}),ae=new he({props:{title:"Creating multi-step demos",local:"creating-multi-step-demos",headingTag:"h3"}}),ne=new ge({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWFzciUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjAlMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UtOTYwaCUyMiklMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiklMEElMEElMEFkZWYlMjBzcGVlY2hfdG9fdGV4dChzcGVlY2gpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGFzcihzcGVlY2gpJTVCJTIydGV4dCUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEElMEFkZWYlMjB0ZXh0X3RvX3NlbnRpbWVudCh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNsYXNzaWZpZXIodGV4dCklNUIwJTVEJTVCJTIybGFiZWwlMjIlNUQlMEElMEElMEFkZW1vJTIwJTNEJTIwZ3IuQmxvY2tzKCklMEElMEF3aXRoJTIwZGVtbyUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvX2ZpbGUlMjAlM0QlMjBnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGdyLlRleHRib3goKSUwQSUyMCUyMCUyMCUyMGxhYmVsJTIwJTNEJTIwZ3IuTGFiZWwoKSUwQSUwQSUyMCUyMCUyMCUyMGIxJTIwJTNEJTIwZ3IuQnV0dG9uKCUyMlJlY29nbml6ZSUyMFNwZWVjaCUyMiklMEElMjAlMjAlMjAlMjBiMiUyMCUzRCUyMGdyLkJ1dHRvbiglMjJDbGFzc2lmeSUyMFNlbnRpbWVudCUyMiklMEElMEElMjAlMjAlMjAlMjBiMS5jbGljayhzcGVlY2hfdG9fdGV4dCUyQyUyMGlucHV0cyUzRGF1ZGlvX2ZpbGUlMkMlMjBvdXRwdXRzJTNEdGV4dCklMEElMjAlMjAlMjAlMjBiMi5jbGljayh0ZXh0X3RvX3NlbnRpbWVudCUyQyUyMGlucHV0cyUzRHRleHQlMkMlMjBvdXRwdXRzJTNEbGFiZWwpJTBBJTBBZGVtby5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

asr = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, <span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">speech_to_text</span>(<span class="hljs-params">speech</span>):
    text = asr(speech)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> text


<span class="hljs-keyword">def</span> <span class="hljs-title function_">text_to_sentiment</span>(<span class="hljs-params">text</span>):
    <span class="hljs-keyword">return</span> classifier(text)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;label&quot;</span>]


demo = gr.Blocks()

<span class="hljs-keyword">with</span> demo:
    audio_file = gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>)
    text = gr.Textbox()
    label = gr.Label()

    b1 = gr.Button(<span class="hljs-string">&quot;Recognize Speech&quot;</span>)
    b2 = gr.Button(<span class="hljs-string">&quot;Classify Sentiment&quot;</span>)

    b1.click(speech_to_text, inputs=audio_file, outputs=text)
    b2.click(text_to_sentiment, inputs=text, outputs=label)

demo.launch()`,wrap:!1}}),ie=new he({props:{title:"Updating Component Properties",local:"updating-component-properties",headingTag:"h3"}}),ce=new ge({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGNoYW5nZV90ZXh0Ym94KGNob2ljZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMGNob2ljZSUyMCUzRCUzRCUyMCUyMnNob3J0JTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3IuVGV4dGJveC51cGRhdGUobGluZXMlM0QyJTJDJTIwdmlzaWJsZSUzRFRydWUpJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGNob2ljZSUyMCUzRCUzRCUyMCUyMmxvbmclMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBnci5UZXh0Ym94LnVwZGF0ZShsaW5lcyUzRDglMkMlMjB2aXNpYmxlJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3IuVGV4dGJveC51cGRhdGUodmlzaWJsZSUzREZhbHNlKSUwQSUwQSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwYmxvY2slM0ElMEElMjAlMjAlMjAlMjByYWRpbyUyMCUzRCUyMGdyLlJhZGlvKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiUyMnNob3J0JTIyJTJDJTIwJTIybG9uZyUyMiUyQyUyMCUyMm5vbmUlMjIlNUQlMkMlMjBsYWJlbCUzRCUyMldoYXQlMjBraW5kJTIwb2YlMjBlc3NheSUyMHdvdWxkJTIweW91JTIwbGlrZSUyMHRvJTIwd3JpdGUlM0YlMjIlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGdyLlRleHRib3gobGluZXMlM0QyJTJDJTIwaW50ZXJhY3RpdmUlM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMHJhZGlvLmNoYW5nZShmbiUzRGNoYW5nZV90ZXh0Ym94JTJDJTIwaW5wdXRzJTNEcmFkaW8lMkMlMjBvdXRwdXRzJTNEdGV4dCklMEElMjAlMjAlMjAlMjBibG9jay5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">change_textbox</span>(<span class="hljs-params">choice</span>):
    <span class="hljs-keyword">if</span> choice == <span class="hljs-string">&quot;short&quot;</span>:
        <span class="hljs-keyword">return</span> gr.Textbox.update(lines=<span class="hljs-number">2</span>, visible=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">elif</span> choice == <span class="hljs-string">&quot;long&quot;</span>:
        <span class="hljs-keyword">return</span> gr.Textbox.update(lines=<span class="hljs-number">8</span>, visible=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> gr.Textbox.update(visible=<span class="hljs-literal">False</span>)


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> block:
    radio = gr.Radio(
        [<span class="hljs-string">&quot;short&quot;</span>, <span class="hljs-string">&quot;long&quot;</span>, <span class="hljs-string">&quot;none&quot;</span>], label=<span class="hljs-string">&quot;What kind of essay would you like to write?&quot;</span>
    )
    text = gr.Textbox(lines=<span class="hljs-number">2</span>, interactive=<span class="hljs-literal">True</span>)

    radio.change(fn=change_textbox, inputs=radio, outputs=text)
    block.launch()`,wrap:!1}}),de=new ol({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter9/7.mdx"}}),{c(){M=i("meta"),j=a(),k=i("p"),Ce=a(),c(B.$$.fragment),Je=a(),c(G.$$.fragment),je=a(),c($.$$.fragment),xe=a(),R=i("p"),R.innerHTML=Ut,Ie=a(),E=i("p"),E.innerHTML=bt,ve=a(),Z=i("ul"),Z.innerHTML=gt,ke=a(),c(_.$$.fragment),Be=a(),H=i("p"),H.innerHTML=Tt,Ge=a(),S=i("ul"),S.innerHTML=Ct,$e=a(),Q=i("p"),Q.textContent=Jt,Re=a(),c(A.$$.fragment),Ee=a(),W=i("p"),W.textContent=jt,Ze=a(),c(X.$$.fragment),_e=a(),w=i("iframe"),He=a(),V=i("p"),V.textContent=It,Se=a(),T=i("ol"),I=i("li"),me=i("p"),me.innerHTML=vt,mt=a(),c(v.$$.fragment),yt=Pt(`
The order in which you instantiate components matters as each element gets rendered into the web app in the order it was created. (More complex layouts are discussed below)`),Mt=a(),ye=i("li"),ye.innerHTML=kt,wt=a(),Me=i("li"),Me.innerHTML=Bt,ft=a(),we=i("li"),we.innerHTML=Gt,Qe=a(),c(z.$$.fragment),Ae=a(),L=i("p"),L.innerHTML=$t,We=a(),Y=i("p"),Y.innerHTML=Rt,Xe=a(),N=i("p"),N.innerHTML=Et,Ve=a(),q=i("p"),q.innerHTML=Zt,ze=a(),c(F.$$.fragment),Le=a(),f=i("iframe"),Ye=a(),P=i("p"),P.innerHTML=Ht,Ne=a(),c(K.$$.fragment),qe=a(),D=i("p"),D.innerHTML=St,Fe=a(),O=i("p"),O.innerHTML=Qt,Pe=a(),ee=i("p"),ee.innerHTML=At,Ke=a(),te=i("ul"),te.innerHTML=Wt,De=a(),le=i("p"),le.textContent=Xt,Oe=a(),c(se.$$.fragment),et=a(),U=i("iframe"),tt=a(),c(ae.$$.fragment),lt=a(),oe=i("p"),oe.innerHTML=zt,st=a(),c(ne.$$.fragment),at=a(),b=i("iframe"),ot=a(),c(ie.$$.fragment),nt=a(),pe=i("p"),pe.innerHTML=Yt,it=a(),re=i("p"),re.textContent=Nt,pt=a(),c(ce.$$.fragment),rt=a(),g=i("iframe"),ct=a(),ue=i("p"),ue.innerHTML=Ft,ut=a(),c(de.$$.fragment),dt=a(),fe=i("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);M=p(t,"META",{name:!0,content:!0}),t.forEach(l),j=o(e),k=p(e,"P",{}),x(k).forEach(l),Ce=o(e),u(B.$$.fragment,e),Je=o(e),u(G.$$.fragment,e),je=o(e),u($.$$.fragment,e),xe=o(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-fnf7hg"&&(R.innerHTML=Ut),Ie=o(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-y0a3jr"&&(E.innerHTML=bt),ve=o(e),Z=p(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-gs87hb"&&(Z.innerHTML=gt),ke=o(e),u(_.$$.fragment,e),Be=o(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1z0nnvi"&&(H.innerHTML=Tt),Ge=o(e),S=p(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-1aq803m"&&(S.innerHTML=Ct),$e=o(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-12sq5c4"&&(Q.textContent=Jt),Re=o(e),u(A.$$.fragment,e),Ee=o(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-lya5ne"&&(W.textContent=jt),Ze=o(e),u(X.$$.fragment,e),_e=o(e),w=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(w).forEach(l),He=o(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-wvzmkp"&&(V.textContent=It),Se=o(e),T=p(e,"OL",{});var C=x(T);I=p(C,"LI",{});var Ue=x(I);me=p(Ue,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1andatl"&&(me.innerHTML=vt),mt=o(Ue),u(v.$$.fragment,Ue),yt=Kt(Ue,`
The order in which you instantiate components matters as each element gets rendered into the web app in the order it was created. (More complex layouts are discussed below)`),Ue.forEach(l),Mt=o(C),ye=p(C,"LI",{"data-svelte-h":!0}),r(ye)!=="svelte-12zx6x9"&&(ye.innerHTML=kt),wt=o(C),Me=p(C,"LI",{"data-svelte-h":!0}),r(Me)!=="svelte-bkbklq"&&(Me.innerHTML=Bt),ft=o(C),we=p(C,"LI",{"data-svelte-h":!0}),r(we)!=="svelte-adpuz1"&&(we.innerHTML=Gt),C.forEach(l),Qe=o(e),u(z.$$.fragment,e),Ae=o(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-xbwbxn"&&(L.innerHTML=$t),We=o(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1b3722y"&&(Y.innerHTML=Rt),Xe=o(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1vziw5t"&&(N.innerHTML=Et),Ve=o(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1blpsqu"&&(q.innerHTML=Zt),ze=o(e),u(F.$$.fragment,e),Le=o(e),f=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(f).forEach(l),Ye=o(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-dh4xss"&&(P.innerHTML=Ht),Ne=o(e),u(K.$$.fragment,e),qe=o(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-umhva7"&&(D.innerHTML=St),Fe=o(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-7a3cem"&&(O.innerHTML=Qt),Pe=o(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1yxg48f"&&(ee.innerHTML=At),Ke=o(e),te=p(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-1hhjtd0"&&(te.innerHTML=Wt),De=o(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-y8si09"&&(le.textContent=Xt),Oe=o(e),u(se.$$.fragment,e),et=o(e),U=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(U).forEach(l),tt=o(e),u(ae.$$.fragment,e),lt=o(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1176ewn"&&(oe.innerHTML=zt),st=o(e),u(ne.$$.fragment,e),at=o(e),b=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(b).forEach(l),ot=o(e),u(ie.$$.fragment,e),nt=o(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-14gx35y"&&(pe.innerHTML=Yt),it=o(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1ot4ibu"&&(re.textContent=Nt),pt=o(e),u(ce.$$.fragment,e),rt=o(e),g=p(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),x(g).forEach(l),ct=o(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-t9y78i"&&(ue.innerHTML=Ft),ut=o(e),u(de.$$.fragment,e),dt=o(e),fe=p(e,"P",{}),x(fe).forEach(l),this.h()},h(){n(M,"name","hf:doc:metadata"),n(M,"content",rl),be(w.src,xt="https://course-demos-flip-text.hf.space")||n(w,"src",xt),n(w,"frameborder","0"),n(w,"height","400"),n(w,"title","Gradio app"),n(w,"class","container p-0 flex-grow space-iframe"),n(w,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(w,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),be(f.src,_t="https://course-demos-flip-text-image.hf.space")||n(f,"src",_t),n(f,"frameborder","0"),n(f,"height","450"),n(f,"title","Gradio app"),n(f,"class","container p-0 flex-grow space-iframe"),n(f,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(f,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),be(U.src,Vt="https://course-demos-blocks-gpt.hf.space")||n(U,"src",Vt),n(U,"frameborder","0"),n(U,"height","300"),n(U,"title","Gradio app"),n(U,"class","container p-0 flex-grow space-iframe"),n(U,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(U,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),be(b.src,Lt="https://course-demos-blocks-multi-step.hf.space")||n(b,"src",Lt),n(b,"frameborder","0"),n(b,"height","600"),n(b,"title","Gradio app"),n(b,"class","container p-0 flex-grow space-iframe"),n(b,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(b,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),be(g.src,qt="https://course-demos-blocks-update-component-properties.hf.space")||n(g,"src",qt),n(g,"frameborder","0"),n(g,"height","300"),n(g,"title","Gradio app"),n(g,"class","container p-0 flex-grow space-iframe"),n(g,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),n(g,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){J(document.head,M),s(e,j,t),s(e,k,t),s(e,Ce,t),d(B,e,t),s(e,Je,t),d(G,e,t),s(e,je,t),d($,e,t),s(e,xe,t),s(e,R,t),s(e,Ie,t),s(e,E,t),s(e,ve,t),s(e,Z,t),s(e,ke,t),d(_,e,t),s(e,Be,t),s(e,H,t),s(e,Ge,t),s(e,S,t),s(e,$e,t),s(e,Q,t),s(e,Re,t),d(A,e,t),s(e,Ee,t),s(e,W,t),s(e,Ze,t),d(X,e,t),s(e,_e,t),s(e,w,t),s(e,He,t),s(e,V,t),s(e,Se,t),s(e,T,t),J(T,I),J(I,me),J(I,mt),d(v,I,null),J(I,yt),J(T,Mt),J(T,ye),J(T,wt),J(T,Me),J(T,ft),J(T,we),s(e,Qe,t),d(z,e,t),s(e,Ae,t),s(e,L,t),s(e,We,t),s(e,Y,t),s(e,Xe,t),s(e,N,t),s(e,Ve,t),s(e,q,t),s(e,ze,t),d(F,e,t),s(e,Le,t),s(e,f,t),s(e,Ye,t),s(e,P,t),s(e,Ne,t),d(K,e,t),s(e,qe,t),s(e,D,t),s(e,Fe,t),s(e,O,t),s(e,Pe,t),s(e,ee,t),s(e,Ke,t),s(e,te,t),s(e,De,t),s(e,le,t),s(e,Oe,t),d(se,e,t),s(e,et,t),s(e,U,t),s(e,tt,t),d(ae,e,t),s(e,lt,t),s(e,oe,t),s(e,st,t),d(ne,e,t),s(e,at,t),s(e,b,t),s(e,ot,t),d(ie,e,t),s(e,nt,t),s(e,pe,t),s(e,it,t),s(e,re,t),s(e,pt,t),d(ce,e,t),s(e,rt,t),s(e,g,t),s(e,ct,t),s(e,ue,t),s(e,ut,t),d(de,e,t),s(e,dt,t),s(e,fe,t),ht=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),v.$set(C)},i(e){ht||(h(B.$$.fragment,e),h(G.$$.fragment,e),h($.$$.fragment,e),h(_.$$.fragment,e),h(A.$$.fragment,e),h(X.$$.fragment,e),h(v.$$.fragment,e),h(z.$$.fragment,e),h(F.$$.fragment,e),h(K.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),ht=!0)},o(e){m(B.$$.fragment,e),m(G.$$.fragment,e),m($.$$.fragment,e),m(_.$$.fragment,e),m(A.$$.fragment,e),m(X.$$.fragment,e),m(v.$$.fragment,e),m(z.$$.fragment,e),m(F.$$.fragment,e),m(K.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),ht=!1},d(e){e&&(l(j),l(k),l(Ce),l(Je),l(je),l(xe),l(R),l(Ie),l(E),l(ve),l(Z),l(ke),l(Be),l(H),l(Ge),l(S),l($e),l(Q),l(Re),l(Ee),l(W),l(Ze),l(_e),l(w),l(He),l(V),l(Se),l(T),l(Qe),l(Ae),l(L),l(We),l(Y),l(Xe),l(N),l(Ve),l(q),l(ze),l(Le),l(f),l(Ye),l(P),l(Ne),l(qe),l(D),l(Fe),l(O),l(Pe),l(ee),l(Ke),l(te),l(De),l(le),l(Oe),l(et),l(U),l(tt),l(lt),l(oe),l(st),l(at),l(b),l(ot),l(nt),l(pe),l(it),l(re),l(pt),l(rt),l(g),l(ct),l(ue),l(ut),l(dt),l(fe)),l(M),y(B,e),y(G,e),y($,e),y(_,e),y(A,e),y(X,e),y(v),y(z,e),y(F,e),y(K,e),y(se,e),y(ae,e),y(ne,e),y(ie,e),y(ce,e),y(de,e)}}}const rl='{"title":"Introduction to Gradio Blocks","local":"introduction-to-gradio-blocks","sections":[{"title":"Why Blocks 🧱?","local":"why-blocks-","sections":[],"depth":3},{"title":"Creating a simple demo using Blocks","local":"creating-a-simple-demo-using-blocks","sections":[],"depth":3},{"title":"Customizing the layout of your demo","local":"customizing-the-layout-of-your-demo","sections":[],"depth":3},{"title":"Exploring events and state","local":"exploring-events-and-state","sections":[],"depth":3},{"title":"Creating multi-step demos","local":"creating-multi-step-demos","sections":[],"depth":3},{"title":"Updating Component Properties","local":"updating-component-properties","sections":[],"depth":3}],"depth":1}';function cl(Te){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends el{constructor(M){super(),tl(this,M,cl,pl,Dt,{})}}export{wl as component};
