import{s as te,a as kt,n as ee,o as le}from"../chunks/scheduler.cc52f4b9.js";import{S as se,i as ae,e as i,s as a,c as r,h as ne,a as o,d as l,b as n,f as _t,g as u,j as p,k as f,l as ie,m as s,n as h,t as d,o as M,p as m}from"../chunks/index.5b747fde.js";import{C as oe,H as qt,E as pe}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d38ac5a9.js";import{C as V}from"../chunks/CodeBlock.665bfc37.js";import{C as re}from"../chunks/CourseFloatingBanner.b33fcd79.js";function ue(Rt){let w,D,Y,K,T,O,J,tt,g,et,y,Et='Depending on the NLP task that you’re working with and the specific use case or application, your data and the annotation task will look differently. For this section of the course, we’ll use <a href="https://huggingface.co/datasets/SetFit/ag_news" rel="nofollow">a dataset collecting news</a> to complete two tasks: a text classification on the topic of each text and a token classification to identify the named entities mentioned.',lt,c,Zt,st,j,Bt="It is possible to import datasets from the Hub using the Argilla UI directly, but we’ll be using the SDK to learn how we can make further edits to the data if needed.",at,b,nt,I,Gt="The first step is to connect to our Argilla instance as we did in the previous section:",it,$,ot,U,Ft="We can now think about the settings of our dataset in Argilla. These represent the annotation task we’ll do over our data. First, we can load the dataset from the Hub and inspect its features, so that we can make sure that we configure the dataset correctly.",pt,x,rt,C,Xt="These are the features of our dataset:",ut,A,ht,v,zt="It contains a <code>text</code> and also some initial labels for the text classification. We’ll add those to our dataset settings together with a <code>spans</code> question for the named entities:",dt,k,Mt,_,Wt="Let’s dive a bit deeper into what these settings mean. First, we’ve defined <strong>fields</strong>, these include the information that we’ll be annotating. In this case, we only have one field and it comes in the form of a text, so we’ve choosen a <code>TextField</code>.",mt,q,Qt="Then, we define <strong>questions</strong> that represent the tasks that we want to perform on our data:",ct,R,Ht="<li>For the text classification task we’ve chosen a <code>LabelQuestion</code> and we used the unique values of the <code>label_text</code> column as our labels, to make sure that the question is compatible with the labels that already exist in the dataset.</li> <li>For the token classification task, we’ll need a <code>SpanQuestion</code>. We’ve defined a set of labels that we’ll be using for that task, plus the field on which we’ll be drawing the spans.</li>",ft,E,St='To learn more about all the available types of fields and questions and other advanced settings, like metadata and vectors, go to the <a href="https://docs.argilla.io/latest/how_to_guides/dataset/#define-dataset-settings" rel="nofollow">Argilla docs</a>.',wt,Z,Tt,B,Nt="Now that we’ve defined some settings, we can create the dataset:",Jt,G,gt,F,Lt="The dataset now appears in our Argilla instance, but you will see that it’s empty:",yt,X,Vt,jt,z,Yt="Now we need to add the records that we’ll be annotating i.e., the rows in our dataset. To do that, we’ll simply need to log the data as records and provide a mapping for those elements that don’t have the same name in the hub and Argilla datasets:",bt,W,It,Q,Pt="In our mapping, we’ve specified that the <code>label_text</code> column in the dataset should be mapped to the question with the name <code>label</code>. In this way, we’ll use the existing labels in the dataset as pre-annotations so we can annotate faster.",$t,H,Dt="While the records continue to log, you can already start working with your dataset in the Argilla UI. At this point, it should look like this:",Ut,S,Kt,xt,N,Ot="Now our dataset is ready to start annotating!",Ct,L,At,P,vt;return T=new oe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new qt({props:{title:"Load your dataset to Argilla",local:"load-your-dataset-to-argilla",headingTag:"h1"}}),g=new re({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter10/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter10/section3.ipynb"}]}}),b=new qt({props:{title:"Configure your dataset",local:"configure-your-dataset",headingTag:"h2"}}),$=new V({props:{code:"aW1wb3J0JTIwYXJnaWxsYSUyMGFzJTIwcmclMEElMEFIRl9UT0tFTiUyMCUzRCUyMCUyMi4uLiUyMiUyMCUyMCUyMyUyMG9ubHklMjBmb3IlMjBwcml2YXRlJTIwc3BhY2VzJTBBJTBBY2xpZW50JTIwJTNEJTIwcmcuQXJnaWxsYSglMEElMjAlMjAlMjAlMjBhcGlfdXJsJTNEJTIyLi4uJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi4uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlM0QlN0IlMjJBdXRob3JpemF0aW9uJTIyJTNBJTIwZiUyMkJlYXJlciUyMCU3QkhGX1RPS0VOJTdEJTIyJTdEJTJDJTIwJTIwJTIzJTIwb25seSUyMGZvciUyMHByaXZhdGUlMjBzcGFjZXMlMEEp",highlighted:`<span class="hljs-keyword">import</span> argilla <span class="hljs-keyword">as</span> rg

HF_TOKEN = <span class="hljs-string">&quot;...&quot;</span>  <span class="hljs-comment"># only for private spaces</span>

client = rg.Argilla(
    api_url=<span class="hljs-string">&quot;...&quot;</span>,
    api_key=<span class="hljs-string">&quot;...&quot;</span>,
    headers={<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>},  <span class="hljs-comment"># only for private spaces</span>
)`,wrap:!1}}),x=new V({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJTZXRGaXQlMkZhZ19uZXdzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhLmZlYXR1cmVz",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

data = load_dataset(<span class="hljs-string">&quot;SetFit/ag_news&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
data.features`,wrap:!1}}),A=new V({props:{code:"JTdCJ3RleHQnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnbGFiZWwnJTNBJTIwVmFsdWUoZHR5cGUlM0QnaW50NjQnJTJDJTIwaWQlM0ROb25lKSUyQyUwQSUyMCdsYWJlbF90ZXh0JyUzQSUyMFZhbHVlKGR0eXBlJTNEJ3N0cmluZyclMkMlMjBpZCUzRE5vbmUpJTdE",highlighted:`{<span class="hljs-string">&#x27;text&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label_text&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),k=new V({props:{code:"c2V0dGluZ3MlMjAlM0QlMjByZy5TZXR0aW5ncyglMEElMjAlMjAlMjAlMjBmaWVsZHMlM0QlNUJyZy5UZXh0RmllbGQobmFtZSUzRCUyMnRleHQlMjIpJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb25zJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmcuTGFiZWxRdWVzdGlvbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIybGFiZWwlMjIlMkMlMjB0aXRsZSUzRCUyMkNsYXNzaWZ5JTIwdGhlJTIwdGV4dCUzQSUyMiUyQyUyMGxhYmVscyUzRGRhdGEudW5pcXVlKCUyMmxhYmVsX3RleHQlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJnLlNwYW5RdWVzdGlvbiglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyZW50aXRpZXMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCUyMkhpZ2hsaWdodCUyMGFsbCUyMHRoZSUyMGVudGl0aWVzJTIwaW4lMjB0aGUlMjB0ZXh0JTNBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyUEVSU09OJTIyJTJDJTIwJTIyT1JHJTIyJTJDJTIwJTIyTE9DJTIyJTJDJTIwJTIyRVZFTlQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKQ==",highlighted:`settings = rg.Settings(
    fields=[rg.TextField(name=<span class="hljs-string">&quot;text&quot;</span>)],
    questions=[
        rg.LabelQuestion(
            name=<span class="hljs-string">&quot;label&quot;</span>, title=<span class="hljs-string">&quot;Classify the text:&quot;</span>, labels=data.unique(<span class="hljs-string">&quot;label_text&quot;</span>)
        ),
        rg.SpanQuestion(
            name=<span class="hljs-string">&quot;entities&quot;</span>,
            title=<span class="hljs-string">&quot;Highlight all the entities in the text:&quot;</span>,
            labels=[<span class="hljs-string">&quot;PERSON&quot;</span>, <span class="hljs-string">&quot;ORG&quot;</span>, <span class="hljs-string">&quot;LOC&quot;</span>, <span class="hljs-string">&quot;EVENT&quot;</span>],
            field=<span class="hljs-string">&quot;text&quot;</span>,
        ),
    ],
)`,wrap:!1}}),Z=new qt({props:{title:"Upload the dataset",local:"upload-the-dataset",headingTag:"h2"}}),G=new V({props:{code:"ZGF0YXNldCUyMCUzRCUyMHJnLkRhdGFzZXQobmFtZSUzRCUyMmFnX25ld3MlMjIlMkMlMjBzZXR0aW5ncyUzRHNldHRpbmdzKSUwQSUwQWRhdGFzZXQuY3JlYXRlKCk=",highlighted:`dataset = rg.Dataset(name=<span class="hljs-string">&quot;ag_news&quot;</span>, settings=settings)

dataset.create()`,wrap:!1}}),W=new V({props:{code:"ZGF0YXNldC5yZWNvcmRzLmxvZyhkYXRhJTJDJTIwbWFwcGluZyUzRCU3QiUyMmxhYmVsX3RleHQlMjIlM0ElMjAlMjJsYWJlbCUyMiU3RCk=",highlighted:'dataset.records.log(data, mapping={<span class="hljs-string">&quot;label_text&quot;</span>: <span class="hljs-string">&quot;label&quot;</span>})',wrap:!1}}),L=new pe({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter10/3.mdx"}}),{c(){w=i("meta"),D=a(),Y=i("p"),K=a(),r(T.$$.fragment),O=a(),r(J.$$.fragment),tt=a(),r(g.$$.fragment),et=a(),y=i("p"),y.innerHTML=Et,lt=a(),c=i("iframe"),st=a(),j=i("p"),j.textContent=Bt,at=a(),r(b.$$.fragment),nt=a(),I=i("p"),I.textContent=Gt,it=a(),r($.$$.fragment),ot=a(),U=i("p"),U.textContent=Ft,pt=a(),r(x.$$.fragment),rt=a(),C=i("p"),C.textContent=Xt,ut=a(),r(A.$$.fragment),ht=a(),v=i("p"),v.innerHTML=zt,dt=a(),r(k.$$.fragment),Mt=a(),_=i("p"),_.innerHTML=Wt,mt=a(),q=i("p"),q.innerHTML=Qt,ct=a(),R=i("ul"),R.innerHTML=Ht,ft=a(),E=i("p"),E.innerHTML=St,wt=a(),r(Z.$$.fragment),Tt=a(),B=i("p"),B.textContent=Nt,Jt=a(),r(G.$$.fragment),gt=a(),F=i("p"),F.textContent=Lt,yt=a(),X=i("img"),jt=a(),z=i("p"),z.textContent=Yt,bt=a(),r(W.$$.fragment),It=a(),Q=i("p"),Q.innerHTML=Pt,$t=a(),H=i("p"),H.textContent=Dt,Ut=a(),S=i("img"),xt=a(),N=i("p"),N.textContent=Ot,Ct=a(),r(L.$$.fragment),At=a(),P=i("p"),this.h()},l(t){const e=ne("svelte-u9bgzb",document.head);w=o(e,"META",{name:!0,content:!0}),e.forEach(l),D=n(t),Y=o(t,"P",{}),_t(Y).forEach(l),K=n(t),u(T.$$.fragment,t),O=n(t),u(J.$$.fragment,t),tt=n(t),u(g.$$.fragment,t),et=n(t),y=o(t,"P",{"data-svelte-h":!0}),p(y)!=="svelte-21xmjs"&&(y.innerHTML=Et),lt=n(t),c=o(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),_t(c).forEach(l),st=n(t),j=o(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1nj4pzu"&&(j.textContent=Bt),at=n(t),u(b.$$.fragment,t),nt=n(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-tteoxx"&&(I.textContent=Gt),it=n(t),u($.$$.fragment,t),ot=n(t),U=o(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-qr4xxl"&&(U.textContent=Ft),pt=n(t),u(x.$$.fragment,t),rt=n(t),C=o(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1tgrrsi"&&(C.textContent=Xt),ut=n(t),u(A.$$.fragment,t),ht=n(t),v=o(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-qqdqqz"&&(v.innerHTML=zt),dt=n(t),u(k.$$.fragment,t),Mt=n(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-14iwfy7"&&(_.innerHTML=Wt),mt=n(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1ps5pnk"&&(q.innerHTML=Qt),ct=n(t),R=o(t,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-1pt9e0q"&&(R.innerHTML=Ht),ft=n(t),E=o(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-12o3rnk"&&(E.innerHTML=St),wt=n(t),u(Z.$$.fragment,t),Tt=n(t),B=o(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-kgkkua"&&(B.textContent=Nt),Jt=n(t),u(G.$$.fragment,t),gt=n(t),F=o(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-3nv5zt"&&(F.textContent=Lt),yt=n(t),X=o(t,"IMG",{src:!0,alt:!0}),jt=n(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-q63n9y"&&(z.textContent=Yt),bt=n(t),u(W.$$.fragment,t),It=n(t),Q=o(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-3kvwa0"&&(Q.innerHTML=Pt),$t=n(t),H=o(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-hjqveo"&&(H.textContent=Dt),Ut=n(t),S=o(t,"IMG",{src:!0,alt:!0}),xt=n(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-akh87c"&&(N.textContent=Ot),Ct=n(t),u(L.$$.fragment,t),At=n(t),P=o(t,"P",{}),_t(P).forEach(l),this.h()},h(){f(w,"name","hf:doc:metadata"),f(w,"content",he),kt(c.src,Zt="https://huggingface.co/datasets/SetFit/ag_news/embed/viewer/default/train")||f(c,"src",Zt),f(c,"frameborder","0"),f(c,"width","100%"),f(c,"height","560px"),kt(X.src,Vt="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter10/empty_dataset.png")||f(X,"src",Vt),f(X,"alt","Screenshot of the empty dataset."),kt(S.src,Kt="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter10/argilla_initial_dataset.png")||f(S,"src",Kt),f(S,"alt","Screenshot of the dataset in Argilla.")},m(t,e){ie(document.head,w),s(t,D,e),s(t,Y,e),s(t,K,e),h(T,t,e),s(t,O,e),h(J,t,e),s(t,tt,e),h(g,t,e),s(t,et,e),s(t,y,e),s(t,lt,e),s(t,c,e),s(t,st,e),s(t,j,e),s(t,at,e),h(b,t,e),s(t,nt,e),s(t,I,e),s(t,it,e),h($,t,e),s(t,ot,e),s(t,U,e),s(t,pt,e),h(x,t,e),s(t,rt,e),s(t,C,e),s(t,ut,e),h(A,t,e),s(t,ht,e),s(t,v,e),s(t,dt,e),h(k,t,e),s(t,Mt,e),s(t,_,e),s(t,mt,e),s(t,q,e),s(t,ct,e),s(t,R,e),s(t,ft,e),s(t,E,e),s(t,wt,e),h(Z,t,e),s(t,Tt,e),s(t,B,e),s(t,Jt,e),h(G,t,e),s(t,gt,e),s(t,F,e),s(t,yt,e),s(t,X,e),s(t,jt,e),s(t,z,e),s(t,bt,e),h(W,t,e),s(t,It,e),s(t,Q,e),s(t,$t,e),s(t,H,e),s(t,Ut,e),s(t,S,e),s(t,xt,e),s(t,N,e),s(t,Ct,e),h(L,t,e),s(t,At,e),s(t,P,e),vt=!0},p:ee,i(t){vt||(d(T.$$.fragment,t),d(J.$$.fragment,t),d(g.$$.fragment,t),d(b.$$.fragment,t),d($.$$.fragment,t),d(x.$$.fragment,t),d(A.$$.fragment,t),d(k.$$.fragment,t),d(Z.$$.fragment,t),d(G.$$.fragment,t),d(W.$$.fragment,t),d(L.$$.fragment,t),vt=!0)},o(t){M(T.$$.fragment,t),M(J.$$.fragment,t),M(g.$$.fragment,t),M(b.$$.fragment,t),M($.$$.fragment,t),M(x.$$.fragment,t),M(A.$$.fragment,t),M(k.$$.fragment,t),M(Z.$$.fragment,t),M(G.$$.fragment,t),M(W.$$.fragment,t),M(L.$$.fragment,t),vt=!1},d(t){t&&(l(D),l(Y),l(K),l(O),l(tt),l(et),l(y),l(lt),l(c),l(st),l(j),l(at),l(nt),l(I),l(it),l(ot),l(U),l(pt),l(rt),l(C),l(ut),l(ht),l(v),l(dt),l(Mt),l(_),l(mt),l(q),l(ct),l(R),l(ft),l(E),l(wt),l(Tt),l(B),l(Jt),l(gt),l(F),l(yt),l(X),l(jt),l(z),l(bt),l(It),l(Q),l($t),l(H),l(Ut),l(S),l(xt),l(N),l(Ct),l(At),l(P)),l(w),m(T,t),m(J,t),m(g,t),m(b,t),m($,t),m(x,t),m(A,t),m(k,t),m(Z,t),m(G,t),m(W,t),m(L,t)}}}const he='{"title":"Load your dataset to Argilla","local":"load-your-dataset-to-argilla","sections":[{"title":"Configure your dataset","local":"configure-your-dataset","sections":[],"depth":2},{"title":"Upload the dataset","local":"upload-the-dataset","sections":[],"depth":2}],"depth":1}';function de(Rt){return le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends se{constructor(w){super(),ae(this,w,de,ue,te,{})}}export{Te as component};
