# Building your first demo[[building-your-first-demo]]

<CourseFloatingBanner chapter={9}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section2.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section2.ipynb"},
]} />

Let's start by installing Gradio! Since it is a Python package, simply run:

`$ pip install gradio `

You can run Gradio anywhere, be it from your favourite Python IDE, to Jupyter notebooks or even in Google Colab 🤯!
So install Gradio wherever you run Python!

Let's get started with a simple “Hello World” example to get familiar with the Gradio syntax:

```py
import gradio as gr


def greet(name):
    return "Hello " + name


demo = gr.Interface(fn=greet, inputs="text", outputs="text")

demo.launch()
```

Let's walk through the code above:

- First, we define a function called `greet()`. In this case, it is a simple function that adds "Hello" before your name, but it can be *any* Python function in general. For example, in machine learning applications, this function would *call a model to make a prediction* on an input and return the output.
- Then, we create a Gradio `Interface` with three arguments, `fn`, `inputs`, and `outputs`. These arguments define the prediction function, as well as the _type_ of input and output components we would like. In our case, both components are simple text boxes.
- We then call the `launch()` method on the `Interface` that we created.

If you run this code, the interface below will appear automatically within a Jupyter/Colab notebook, or pop in a browser on **[http://localhost:7860](http://localhost:7860/)** if running from a script.

<iframe src="https://course-demos-hello-world.hf.space" frameBorder="0" height="250" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Try using this GUI right now with your own name or some other input!

You'll notice that in this GUI, Gradio automatically inferred the name of the input parameter (`name`)
and applied it as a label on top of the textbox. What if you'd like to change that?
Or if you'd like to customize the textbox in some other way? In that case, you can
instantiate a class object representing the input component.

Take a look at the example below:

```py
import gradio as gr


def greet(name):
    return "Hello " + name


# We instantiate the Textbox class
textbox = gr.Textbox(label="Type your name here:", placeholder="John Doe", lines=2)

gr.Interface(fn=greet, inputs=textbox, outputs="text").launch()
```

<iframe src="https://course-demos-hello-world-custom.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Here, we've created an input textbox with a label, a placeholder, and a set number of lines.
You could do the same for the output textbox, but we'll leave that for now.

We've seen that with just a few lines of code, Gradio lets you create a simple interface around any function
with any kind of inputs or outputs. In this section, we've started with a
simple textbox, but in the next sections, we'll cover other kinds of inputs and outputs. Let's now take a look at including some NLP in a Gradio application.


## 🤖 Including model predictions[[including-model-predictions]]

Let's now build a simple interface that allows you to demo a **text-generation** model like GPT-2.

We'll load our model using the `pipeline()` function from 🤗 Transformers.
If you need a quick refresher, you can go back to [that section in Chapter 1](/course/chapter1/3#text-generation).

First, we define a prediction function that takes in a text prompt and returns the text completion:

```py
from transformers import pipeline

model = pipeline("text-generation")


def predict(prompt):
    completion = model(prompt)[0]["generated_text"]
    return completion
```

This function completes prompts that you provide, and you can run it with your own input prompts to see how it works. Here is an example (you might get a different completion):

```
predict("My favorite programming language is")
```

```
>> My favorite programming language is Haskell. I really enjoyed the Haskell language, but it doesn't have all the features that can be applied to any other language. For example, all it does is compile to a byte array.
```

Now that we have a function for generating predictions, we can create and launch an `Interface` in the same way we did earlier:

```py
import gradio as gr

gr.Interface(fn=predict, inputs="text", outputs="text").launch()
```


That's it! You can now use this interface to generate text using the GPT-2 model as shown below 🤯.

<iframe src="https://course-demos-gpt-2.hf.space" frameBorder="0" height="300" title="Gradio app" class="container p-0 flex-grow space-iframe" allow="accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking" sandbox="allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"></iframe>

Keep reading to see how to build other kinds of demos with Gradio!

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/en/chapter9/2.mdx" />