# مدل‌ها

{#if fw === 'pt'}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fa/chapter2/section3_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fa/chapter2/section3_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fa/chapter2/section3_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fa/chapter2/section3_tf.ipynb"},
]} />

{/if}

{#if fw === 'pt'}
<Youtube id="AhChOFRegn4"/>
{:else}
<Youtube id="d3JVgghSOew"/>
{/if}

{#if fw === 'pt'}

در این بخش نگاهی نزدیک‌تر به ساخت و استفاده از مدل‌ها می‌اندازیم. کلاس `AutoModel` را به کار خواهیم گرفت که برای ساختن مدل‌ها از نقطه‌های تعلیم مشخص، بسیار پرکاربرد است.

کلاس `AutoModel` و تمامی کلاس‌های شبیه آن، در واقع پوسته‌ای ساده روی انواع مختلف مدل‌های موجود در کتابخانه هستند. پوسته‌ای هوشمند که می‌تواند به صورت خودکار معماری مدل استفاده شده در نقطه‌های تعلیم را تشخیص دهد و سپس مدلی با آن معماری بسازد.

{:else}

در این بخش نگاهی نزدیک‌تر به ساخت و استفاده از مدل‌ها می‌اندازیم. کلاس `TFAutoModel` را به کار خواهیم گرفت که برای ساختن مدل‌ها از نقطه‌های تعلیم مشخص، بسیار پرکاربرد است.

کلاس `TFAutoModel` و تمامی کلاس‌های شبیه آن، در واقع پوسته‌ای ساده روی انواع مختلف مدل‌های موجود در کتابخانه هستند. پوسته‌ای هوشمند که می‌تواند به صورت خودکار معماری مدل استفاده شده در نقطه‌های تعلیم را تشخیص دهد و سپس مدلی با آن معماری بسازد.

{/if}

با این وجود، اگر نوع مدلی که می‌خواهید استفاده کنید را می‌دانید، می‌توانید مستقیماً کلاسی که معماری خاص آن مدل را تعریف می‌کند به کار ببرید. نگاهی به چگونگی انجام این عملیات با مدل BERT می‌اندازیم.

## ساخت ترنسفورمر

اولین کار برای ساخت نمونه‌ای از مدل BERT، بارگذاری شیء تنظیمات است:

<div dir="ltr">

{#if fw === 'pt'}
```py
from transformers import BertConfig, BertModel

# Building the config
config = BertConfig()

# Building the model from the config
model = BertModel(config)
```
{:else}
```py
from transformers import BertConfig, TFBertModel

# Building the config
config = BertConfig()

# Building the model from the config
model = TFBertModel(config)
```
{/if}

</div>

شیء تنظیمات ویژگی‌های بسیاری دارد که برای ساختن مدل به کار می‌روند.

<div dir="ltr">

```py
print(config)
```

```python out
BertConfig {
  [...]
  "hidden_size": 768,
  "intermediate_size": 3072,
  "max_position_embeddings": 512,
  "num_attention_heads": 12,
  "num_hidden_layers": 12,
  [...]
}
```

</div>

با وجود اینکه هنوز ندیده‌اید تک تک این ویژگی‌ها چه تاثیری دارند، بعضی از آنها برای شما آشنا هستند: ویژگی `hidden_size` اندازه بردار `hidden_states` را مشخص می‌کند و ویژگی `num_hidden_layers` مشخص کننده تعداد لایه‌های مدل ترنسفورمر است.

### روش‌های مختلف بارگذاری

ساختن مدل با تنظیمات پیش‌فرض، باعث مقداردهی اولیه وزن‌های آن با اعداد تصادفی می‌شود.

<div dir="ltr">

{#if fw === 'pt'}
```py
from transformers import BertConfig, BertModel

config = BertConfig()
model = BertModel(config)

# Model is randomly initialized!
```
{:else}
```py
from transformers import BertConfig, TFBertModel

config = BertConfig()
model = TFBertModel(config)

# Model is randomly initialized!
```
{/if}

</div>

می‌توان از مدل در این وضعیت استفاده کرد ولی خروجی آن بی‌معنی خواهد بود؛ ابتدا باید مدل را تعلیم دهیم. می‌توانیم مدل را از صفر برای مسئله مورد نظرمان تعلیم دهیم ولی همان گونه که در [فصل اول](/course/chapter1) دیدیم، برای این کار نیاز به زمان طولانی و داده بسیار داریم. این عملیات تاثیرات منفی غیر قابل چشم‌پوشی‌‌ای بر محیط‌زیست دارد. برای جلوگیری از دوباره‌کاری باید بتوانیم مدل‌های از پیش تعلیم دیده را به اشتراک گذاشته و به کار ببریم.

بارگذاری مدل از پیش تعلیم دیده ترنسفورمر، ساده است. برای این کار از تابع `from_pretrained()` استفاده‌‌ می‌کنیم. 

{#if fw === 'pt'}

<div dir="ltr">

```py
from transformers import BertModel

model = BertModel.from_pretrained("bert-base-cased")
```
</div>

همان طور که قبلا دیدید، می‌توانیم کلاس `BertModel` را با کلاس معادل `AutoModel` جایگزین کنیم. از این پس همین کار را خواهیم کرد چون به این صورت کد وابسته به نقطه تعلیم خاصی نخواهد بود. اگر کد شما با یک نقطه تعلیم اجرا می‌شود، بدون تغییر با نقاط تعلیم دیگر هم اجرا خواهد شد. این حتی در مورد معماری‌های متفاوت هم صدق می‌کند، البته در صورتی که نقطه تعلیم متعلق به مسئله مشابهی(برای مثال تحلیل احساسات) باشد. 
 
{:else}

<div dir="ltr">

```py
from transformers import TFBertModel

model = TFBertModel.from_pretrained("bert-base-cased")
```

</div>

همان طور که قبلا دیدید، می‌توانیم کلاس `TFBertModel` را با کلاس معادل `TFAutoModel` جایگزین کنیم. از این پس همین کار را خواهیم کرد چون به این صورت کد وابسته به نقطه تعلیم خاصی نخواهد بود. اگر کد شما با یک نقطه تعلیم اجرا می‌شود، بدون تغییر با نقاط تعلیم دیگر هم اجرا خواهد شد. این حتی در مورد معماری‌های متفاوت هم صدق می‌کند، البته در صورتی که نقطه تعلیم متعلق به مسئله مشابهی(برای مثال تحلیل احساسات) باشد.

{/if}

در کد نمونه بالا، کلاس `BertConfig` را به کار نبرده و در عوض از مدلی از پیش تعلیم دیده با شناسه `bert-base-cased` استفاده کردیم؛ نقطه تعلیم مدلی که توسط خود مؤلفان مدل BERT تعلیم دیده است. اطلاعات بیشتر در مورد این نقطه تعلیم را می‌توانید در [صفحه توضیحات](https://huggingface.co/bert-base-cased) آن ببینید.

این مدل اکنون با وزن‌های نقطه تعلیم پر شده است و می‌توان آن را مستقیماً برای مسائلی که برای آن تعلیم دیده به کار برد یا برای مسئله جدیدی کوک کرد. با تعلیم روی وزن‌های از پیش تعلیم دیده، به جای تعلیم از صفر، می‌توانیم به سرعت به نتایج خوبی دست پیدا کنیم.

این وزن‌ها دانلود و در پوشه‌ای مخصوص انبار شده‌اند، تا اجرای تابع `from_pretrained()` در آینده مسبب دانلود دوباره‌اشان نباشد. این پوشه به صورت پیش‌فرض در آدرس *~/.cache/huggingface/transformers* قرار دارد. شما می‌توانید با تخصیص مقدار به متغیر محیطی `HF_HOME` مکان این پوشه را تغییر دهید.

شناسه هر مدلی در هاب مدل‌ها را می‌توانید برای بارگذاری استفاده کنید. البته در صورتی که آن مدل با معماری BERT سازگاری داشته باشد. فهرست کامل تمام نقاط تعلیم سازگار با BERT را [اینجا مشاهده کنید](https://huggingface.co/models?filter=bert).

### روش‌های ذخیره‌سازی

ذخیره‌سازی مدل به سادگی بارگذاری آن است. از تابع `save_pretrained()` استفاده می‌کنیم که متناظر با تابع `from_pretrained()` است:

<div dir="ltr">

```py
model.save_pretrained("directory_on_my_computer")
```

</div>

اجرای این تابع باعث ذخیره شدن دو فایل در سیستم شما می‌شود:

<div dir="ltr">

{#if fw === 'pt'}
```
ls directory_on_my_computer

config.json model.safetensors
```
{:else}
```
ls directory_on_my_computer

config.json tf_model.h5
```
{/if}

</div>

اگر نگاهی به فایل *config.json* بیاندازید، با ویژگی‌های آشنای مورد نیاز برای ساختن معماری مدل روبرو خواهید شد. این فایل حاوی مقادیری متادیتا، مانند نقطه مادر این نقطه تعلیم و نسخه‌‌ کتابخانه ترنسفورمرهای هاگینگ‌فِیس که آخرین بار برای ذخیره‌سازی این نقطه به کار رفته است، می‌باشد.
 
{#if fw === 'pt'}

فایل *model.safetensors* در واقع *دیکشنری وضعیت‌ها* است و حاوی تمام وزن‌های مدل شماست. این دو فایل به همراه هم کاربرد دارند؛ فایل تنظیمات برای دانستن معماری به کار رفته در مدل ضروری است و پارامترهای مدل هم که همان وزن‌های داخل فایل دوم هستند.

{:else}

فایل *tf_model.h5* در واقع *دیکشنری وضعیت‌ها* است و حاوی تمام وزن‌های مدل شماست. این دو فایل به همراه هم کاربرد دارند؛ فایل تنظیمات برای دانستن معماری به کار رفته در مدل ضروری است و پارامترهای مدل هم که همان وزن‌های داخل فایل دوم هستند.

{/if}

## اجرای یک مدل ترنسفورمر

حالا که می‌دانید چگونه مدل‌ها را ذخیره‌سازی و بارگذاری کنید، می‌توانیم آنها را برای پیش‌بینی به کار بگیریم. مدل‌های ترنسفورمر فقط می‌توانند اعداد را پردازش کنند؛ اعدادی که توکِنایزر تولید نموده است. ولی پیش از آن که سراغ بحث توکِنایزرها برویم، ورودی‌های قابل قبول برای مدل‌ها را بررسی می‌کنیم.

توکِنایزرها می‌توانند ورودی‌ها را به تِنسورهای مخصوص هر فریمورک تبدیل کنند ولی برای آنکه درست متوجه آنچه اتفاق می‌افتد شویم، نگاهی کوتاه به کارهایی که باید قبل از فرستادن ورودی‌ها به مدل انجام شود می‌اندازیم.

تصور کنید چند جمله به این صورت داریم:

<div dir="ltr">

```py
sequences = ["Hello!", "Cool.", "Nice!"]
```

</div>

توکِنایزر این جملات را به اندیس‌های مخصوص کلمات که معمولا به آنها *شناسه‌های ورودی* می‌گوییم، تبدیل می‌کند. هر رشته اکنون لیستی از اعداد است! نتیجه خروجی از این قرار است:

<div dir="ltr">

```py no-format
encoded_sequences = [
    [101, 7592, 999, 102],
    [101, 4658, 1012, 102],
    [101, 3835, 999, 102],
]
```

</div>

این خروجی لیستی از رشته‌های کد شده شده است: لیستی از لیست‌ها. تِنسورها تنها مقادیر به شکل مستطیل(همان ماتریس) را می‌پذیرند. این «آرایه» خود شکل مستطیلی دارد پس تبدیل آن به تِنسور ساده است:

<div dir="ltr">

{#if fw === 'pt'}
```py
import torch

model_inputs = torch.tensor(encoded_sequences)
```
{:else}
```py
import tensorflow as tf

model_inputs = tf.constant(encoded_sequences)
```
{/if}

</div>

### استفاده از تِنسور‌ها به عنوان ورودی مدل

به کار بردن تِنسورها به عنوان ورودی مدل بسیار ساده است؛ تنها آرگومان تِنسور ورودی را به صورت زیر به مدل پاس می‌دهیم:

<div dir="ltr">

```py
output = model(model_inputs)
```

</div>

این تابع آرگومان‌های بسیاری را می‌پذیرد ولی تنها شناسه‌های ورودی ضروری هستند. کاربرد آرگومان‌های دیگر و شرایط ضرورت آنها را بعد توضیح خواهیم داد. ولی ابتدا باید نگاهی نزدیک‌تر به توکِنایزرهایی که ورودی‌های قابل فهم مدل‌های ترنسفورمر را می‌سازند، بیاندازیم.
</div>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fa/chapter2/3.mdx" />