# کوک کردن مدل‌ها با استفاده از کِراس

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter3/section3_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter3/section3_tf.ipynb"},
]} />

زمانی که همه کارهای پیش‌پردازش در بخش قبل را انجام دادید، فقط چند مرحله با‌قی‌مانده تا تعلیم مدل دارید. با این حال، توجه داشته باشید که دستور <span dir="ltr">`model.fit()`</span> روی CPU بسیار آهسته اجرا خواهد شد. اگر GPU ندارید، می‌توانید از GPU یا TPU مجانی روی [گوگل کولَب](https://colab.research.google.com/) استفاده کنید.

نمونه کدهای زیر فرض می‌کنند که شما مثال‌های بخش قبل را از پیش اجرا کرده‌اید. این یک خلاصه کوتاه است جهت یادآوری آنچه نیاز دارید:

<div dir="ltr">

```py
from datasets import load_dataset
from transformers import AutoTokenizer, DataCollatorWithPadding
import numpy as np

raw_datasets = load_dataset("glue", "mrpc")
checkpoint = "bert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


def tokenize_function(example):
    return tokenizer(example["sentence1"], example["sentence2"], truncation=True)


tokenized_datasets = raw_datasets.map(tokenize_function, batched=True)

data_collator = DataCollatorWithPadding(tokenizer=tokenizer, return_tensors="tf")

tf_train_dataset = tokenized_datasets["train"].to_tf_dataset(
    columns=["attention_mask", "input_ids", "token_type_ids"],
    label_cols=["labels"],
    shuffle=True,
    collate_fn=data_collator,
    batch_size=8,
)

tf_validation_dataset = tokenized_datasets["validation"].to_tf_dataset(
    columns=["attention_mask", "input_ids", "token_type_ids"],
    label_cols=["labels"],
    shuffle=False,
    collate_fn=data_collator,
    batch_size=8,
)
```

</div>


### تعلیم

مدل‌های تِنسورفِلو که از ترَنسفورمِرهای هاگینگ‌فِیس وارد شده‌اند از پیش مدل‌های کِراس هستند. این هم مقدمه‌ای کوتاه به کِراس.

<Youtube id="rnTGBy2ax1c"/>

این به این معنی است که به محض اینکه داده‌مان را در اختیار بگیریم، کار بسیار کمی لازم است تا تعلیم را روی آن شروع کنیم.

<Youtube id="AUozVp78dhk"/>

مانند [فصل قبل](/course/chapter2)، ما از کلاس `TFAutoModelForSequenceClassification` با دو برچسب دسته استفاده خواهیم کرد:

<div dir="ltr">

```py
from transformers import TFAutoModelForSequenceClassification

model = TFAutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
```

</div>

شما متوجه خواهید شد که برخلاف [فصل ۲](/course/chapter2)، بعد از ساختن این مدل از پیش‌ تعلیم دیده یک هشدار دریافت می‌کنید. این به این خاطر است که BERT برای دسته‌بندی دو جمله‌ها از پیش‌ تعلیم ندیده است، بنابراین لایه سَر مدل از پیش‌ تعلیم دیده حذف شده و یک لایه سَر مناسب جهت دسته بندی رشته‌‌‌ها به جای آن قرار گرفته است. هشدارها نشان می‌دهند که برخی از وزن‌های مدل استفاده نشده‌اند (آنهایی که مربوط به لایه‌ سَر حذف شده مدل از پیش تعلیم دیده هستند) و برخی دیگر به صورت تصادفی مقدار‌ دهی شده‌‌اند (آنهایی که مربوط به لایه‌ سَر جدید هستند). در نتیجه این امر شما را تشویق به تعلیم مدل می‌کند، که دقیقا همان کاری است که می‌خواهیم اکنون انجام دهیم.

برای کوک‌ کردن مدل روی دِیتاسِت‌مان، ما فقط باید مدل را <span dir="ltr">`compile()`</span> کنیم و سپس داده‌مان را به تابع <span dir="ltr">`fit()`</span> ارسال کنیم. این کار فرایند کوک‌ کردن را شروع می‌کند (که باید چند دقیقه روی GPU طول بکشد) و در همین حین هزینه `training` و هزینه `validation` را در انتهای هر epoch گزارش می‌دهد.

<Tip>

توجه داشته باشید که مدل‌های ترَنسفورمِر هاگینگ‌فِیس قابلیت ویژه‌ای دارند که بسیاری از مدل‌های کِراس ندارند - آنها می‌توانند به صورت خودکار از یک تابع هزینه مناسب که به صورت داخلی محاسبه می‌کنند استفاده کنند. در صورتی که شما آرگومانی برای تابع هزینه در زمان <span dir="ltr">`compile()`</span> تعیین نکنید آنها از این تابع هزینه به صورت پیش‌فرض استفاده خواهند کرد. توجه داشته باشید که جهت استفاده از تابع هزینه داخلی شما نیاز خواهید داشت برچسب دسته‌های خودتان را به عنوان بخشی از ورودی، نه به صورت یک برچسب دسته مجزا که روش معمول استفاده از برچسب دسته‌ها در مدل‌های کِراس می‌باشد، ارسال کنید. شما مثال‌هایی از این را در بخش ۲ این درس خواهید دید، جایی که تعیین تابع هزینه‌ی درست می‌تواند تا اندازه‌ای پیچیده باشد. به هر حال، برای دسته‌بندی رشته‌‌‌ها، یک تابع هزینه استانداد کِراس به خوبی کار می‌کند، چیزی که ما در اینجا استفاده خواهیم کرد.

</Tip>

<div dir="ltr">

```py
from tensorflow.keras.losses import SparseCategoricalCrossentropy

model.compile(
    optimizer="adam",
    loss=SparseCategoricalCrossentropy(from_logits=True),
    metrics=["accuracy"],
)
model.fit(
    tf_train_dataset,
    validation_data=tf_validation_dataset,
)
```

</div>

<Tip warning={true}>

در اینجا توجه شما را به یک مسئله عام جلب می‌کنیم - شما *می‌توانید* فقط نام تابع هزینه را به صورت یک متغیر متنی برای کِراس ارسال کنید، اما کِراس به صورت پیش‌فرض فکر می‌کند شما یک لایه softmax از پیش به خروجی‌تان اعمال کرده‌اید. با این حال، بسیاری از مدل‌ها مقادیر را درست قبل از اینکه softmax به آنها اعمال شود به خروجی می‌دهند، که همچنین به عنوان *logits* شناخته می‌شوند. ما نیاز داریم که به تابع هزینه بگوییم، این کاری است که مدل‌مان انجام می‌دهد و تنها راه گفتن آن این است که به جای ارسال نام تابع هزینه به صورت متغیر متنی، آن را به صورت مستقیم صدا بزنیم.

</Tip>

### بهبود کارایی تعلیم

<Youtube id="cpzq6ESSM5c"/>

اگر کد بالا را امتحان کنید، قطعا اجرا خواهد شد، اما متوجه خواهید شد که هزینه بسیار آهسته یا به صورت گاه و بیگاه کاهش می‌یابد. علت اصلی این امر *نرخ یادگیری* می‌باشد. مانند تابع هزینه، وقتی که ما نام بهینه‌ساز را به صورت یک متغیر متنی به کِراس ارسال می‌کنیم، کِراس همه پارامترهای آن، شامل نرخ یادگیری، را با مقادیر پیش‌فرض مقداردهی اولیه می‌کند. به تجربه طولانی، ما می‌دانیم که مدل‌های ترَنسفورمِر از نرخ‌های یادگیری بسیار کوچک‌تر بهره بیشتری می‌برند تا مقدار پیش‌فرض برای بهینه‌ساز Adam، که <span dir="ltr">۱e-۳</span> می‌باشد و به صورت‌ ۱۰ به توان <span dir="ltr">-۳</span> یا ۰،۰۰۱ نیز نوشته می‌شود.

علاوه بر کم کردن یکباره نرخ یادگیری، ترفند دیگری نیز در آستین داریم: ما می‌توانیم نرخ یادگیری را به آهستگی در طول دوره تعلیم کاهش دهیم. گاها خواهید دید که از این روش در متون مشابه با عنوان نرخ یادگیری *محو شونده* یا *بازپُختی* یاد می‌شود. بهترین روش برای انجام این کار در کِراس استفاده از زمان‌بند نرخ یادگیری است. یک زمان‌بند خوب برای استفاده، زمان‌بند `PolynomialDecay` می‌باشد - این زمان‌بند برخلاف نامش نرخ یادگیری را در حالت پیش‌فرض به صورت خطی از مقدار اولیه تا مقدار نهایی  در طول دوره تعلیم کاهش می‌دهد که دقیقا همان چیزی است که ما می‌خواهیم. به منظور استفاده درست از زمان‌بند ما نیاز داریم که به آن بگویم طول زمان تعلیم چقدر خواهد بود. در زیر ما آن را به عنوان `num_train_steps` محاسبه می‌کنیم.  

<div dir="ltr">

```py
from tensorflow.keras.optimizers.schedules import PolynomialDecay

batch_size = 8
num_epochs = 3
# The number of training steps is the number of samples in the dataset, divided by the batch size then multiplied
# by the total number of epochs. Note that the tf_train_dataset here is a batched tf.data.Dataset,
# not the original Hugging Face Dataset, so its len() is already num_samples // batch_size.
num_train_steps = len(tf_train_dataset) * num_epochs
lr_scheduler = PolynomialDecay(
    initial_learning_rate=5e-5, end_learning_rate=0.0, decay_steps=num_train_steps
)
from tensorflow.keras.optimizers import Adam

opt = Adam(learning_rate=lr_scheduler)
```

</div>

<Tip>

کتابخانه ترنسفورمرهای هاگینگ‌فِیس همچنین یک تابع <span dir="ltr">`create_optimizer()`</span> دارد که بهینه‌سازی از نوع `AdamW`، دارای میزان کاهش نرخ یادگیری می‌سازد. این یک میان‌بر مناسب است که آن‌ را با جزئیات در بخش‌های بعدی این آموزش خواهید دید.

</Tip>

اکنون بهینه‌ساز کاملا جدیدمان را در اختیار داریم و می‌توانیم آن را تعلیم دهیم. ابتدا، اجازه دهید مدل را مجددا بارگذاری کنیم تا تغییرات ایجاد شده بر وزنها که در تعلیم قبلی اعمال شده‌اند را به حالت اولیه بازگردانیم، سپس می‌توانیم مدل را با بهینه ساز جدید تدوین کنیم: 

<div dir="ltr">

```py
import tensorflow as tf

model = TFAutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
loss = tf.keras.losses.SparseCategoricalCrossentropy(from_logits=True)
model.compile(optimizer=opt, loss=loss, metrics=["accuracy"])
```

</div>

حالا دوباره مدل را فیت می‌کنیم:

<div dir="ltr">

```py
model.fit(tf_train_dataset, validation_data=tf_validation_dataset, epochs=3)
```

</div>


<Tip>

💡 اگر مایلید مدلتان را در حین تعلیم به صورت خودکار در هاب بارگذاری کنید، می‌توانید پارامتر `PushToHubCallback` را در تابع <span dir="ltr">`model.fit()`</span> ارسال کنید. در [فصل ۴](/course/chapter4/3) در این مورد بیشتر خواهیم آموخت. 

</Tip>

### پیش‌بینی‌های مدل

<Youtube id="nx10eh4CoOs"/>

تعلیم و تماشای پایین رفتن هزینه خیلی خوب است، اما اگر واقعا بخواهیم از مدل تعلیم دیده‌مان، چه برای محاسبه برخی معیار‌ها و چه برای استفاده در خط تولید، خروجی دریافت کنیم باید چه کار کنیم؟ برای این منظور می‌توانیم از تابع <span dir="ltr">`predict()`</span> استفاده کنیم. این کار به ازای هر کلاس یک  *logits* از لایه‌ سَر خروجی مدل باز می‌گرداند.


<div dir="ltr">

```py
preds = model.predict(tf_validation_dataset)["logits"]
```

</div>

سپس می‌توانیم `logits` را با استفاده از `argmax` برای یافتن بزرگ‌ترین `logit`، که نماینده محتمل‌ترین دسته می‌باشد، به پیش‌بینی‌های دسته مدل تبدیل کنیم:

<div dir="ltr">

```py
class_preds = np.argmax(preds, axis=1)
print(preds.shape, class_preds.shape)
```

</div>

<div dir="ltr">

```python out
(408, 2) (408,)
```

</div>

اکنون، اجازه دهید از `preds` برای محاسبه برخی معیارها استفاده کنیم! ما می‌توانیم معیارهای مرتبط با دیتاسِت MRPC را، به همان آسانی که دیتاسِت را بارگذاری کردیم، بارگذاری کنیم اما این بار با استفاده از تابع <span dir="ltr">`load_metric()`</span>. شیء باز گردانده شده تابعی به نام <span dir="ltr">`compute()`</span> دارد که می‌توانیم برای محاسبه معیارها از آن استفاده کنیم:

<div dir="ltr">

```py
from datasets import load_metric

metric = load_metric("glue", "mrpc")
metric.compute(predictions=class_preds, references=raw_datasets["validation"]["label"])
```

</div>

<div dir="ltr">

```python out
{'accuracy': 0.8578431372549019, 'f1': 0.8996539792387542}
```

</div>

از آنجایی که مقداردهی اولیه تصادفی در لایه‌ سَر مدل ممکن است مقادیر معیارهای حاصل را تغییر دهد، نتایج دریافتی شما می‌توانند متفاوت باشند. در اینجا می‌بینیم که مدل ما دقتی معادل ۸۵.۷۸٪ و <span dir="ltr">F1 score</span> معادل ۸۹.۹۷٪ روی مجموعه `validation` دارد. این‌‌ها دو معیاری هستند که جهت سنجش نتایج روی داده MRPC در محک GLUE به کار رفته‌اند. جدول نتایج در مقاله [BERT](https://arxiv.org/pdf/1810.04805.pdf)، <span dir="ltr">F1 score</span> برابر با ۸۸.۹ برای مدل پایه گزارش کرده است. توجه داشته باشید که آن مدل `uncased` بود در حالی که اکنون ما از مدل `cased` استفاده می‌کنیم، که نتایج بهتر را توجیح می‌کند.

به این ترتیب مقدمه کوک کردن با استفاده از `API` کِراس به پایان می‌رسد. در فصل ۷ یک مثال از انجام این کار برای معمول‌ترین مسئله‌های `NLP` ارائه خواهد شد. اگر مایلید مهارت‌های خود را روی `API` کِراس تقویت کنید، سعی کنید مدلی را روی مسئله <span dir="ltr">`GLUE SST-2`</span>، با استفاده از روش پردازش داده‌ که در بخش ۲ انجام دادید، کوک کنید.


</div>

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fa/chapter3/3_tf.mdx" />