# Quiz de fin de chapitre

<CourseFloatingBanner
    chapter={3}
    classNames="absolute z-10 right-0 top-0"
/>

Testez ce que vous avez appris dans ce chapitre !

### 1. Le jeu de données `emotion` contient des messages Twitter étiquetés avec des émotions. Cherchez-le dans le [*Hub*](https://huggingface.co/datasets) et lisez la carte du jeu de données. Laquelle de ces émotions n'est pas une de ses émotions de base ?

<Question
	choices={[
		{
			text: "Joie",
			explain: "Essayez à nouveau, cette émotion est présente dans ce jeu de données !"
		},
		{
			text: "Amour",
			explain: "Essayez à nouveau, cette émotion est présente dans ce jeu de données !"
		},
		{
			text: "Confusion",
			explain: "La confusion n'est pas l'une des six émotions de base.",
            correct: true
		},
        {
			text: "Surprise",
			explain: "Surprise ! Essayez-en une autre !"
		}
	]}
/>

### 2. Cherchez le jeu de données `ar_sarcasme` dans le [*Hub*](https://huggingface.co/datasets). Quelle tâche prend-il en charge ?

<Question
	choices={[
		{
			text: "Classification de sentiments",
			explain: "C'est vrai ! Vous pouvez le dire grâce aux <i>tags</i>.",
            correct: true
		},
		{
			text: "Traduction automatique",
			explain: "Ce n'est pas ça. Jetez un autre coup d'œil à la <a href='https://huggingface.co/datasets/ar_sarcasm'>carte du jeu de données</a> !"
		},
		{
			text: "Reconnaissance des entités nommées",
			explain: "Ce n'est pas ça. Jetez un autre coup d'œil à la <a href='https://huggingface.co/datasets/ar_sarcasm'>carte du jeu de données</a> !"
		},
        {
			text: "Réponse aux questions",
			explain: "Hélas, cette question n'a pas reçu de réponse correcte. Essayez à nouveau !"
		}
	]}
/>

### 3. Comment le modèle BERT attend-il qu'une paire de phrases soit traitée ?

<Question
	choices={[
		{
			text: "Tokens_de_la_phrase_1 [SEP] Tokens_de_la_phrase_2",
			explain: "Un jeton spécial <code>[SEP]</code> est nécessaire pour séparer les deux phrases, mais ce n'est pas tout !"
		},
		{
			text: "[CLS] Tokens_de_la_phrase_1 Tokens_de_la_phrase_2",
			explain: "Un jeton spécial <code>[CLS]</code> est requis au début, mais ce n'est pas la seule chose !"
		},
		{
			text: "[CLS] Tokens_de_la_phrase_1 [SEP] Tokens_de_la_phrase_2 [SEP]",
			explain: "C'est exact !",
            correct: true
		},
        {
			text: "[CLS] Tokens_de_la_phrase_1 [SEP] Tokens_de_la_phrase_2",
			explain: "Un jeton spécial <code>[CLS]</code> est nécessaire au début, ainsi qu'un jeton spécial <code>[SEP]</code> pour séparer les deux phrases, mais ce n'est pas tout !"
		}
	]}
/>

{#if fw === 'pt'}
### 4. Quels sont les avantages de la méthode `Dataset.map()` ?

<Question
	choices={[
		{
			text: "Les résultats de la fonction sont mis en cache, donc cela ne prendra pas de temps si nous réexécutons le code.",
			explain: "C'est en effet l'un des avantages de cette méthode ! Ce n'est pas le seul, cependant...",
            correct: true
		},
		{
			text: "Elle peut appliquer le multitraitement pour aller plus vite que l'application de la fonction sur chaque élément du jeu de données.",
			explain: "C'est une caractéristique intéressante de cette méthode, mais ce n'est pas la seule !",
            correct: true
		},
		{
			text: "Elle ne charge pas le jeu de données en mémoire, mais sauvegarde les résultats dès qu'un élément est traité.",
			explain: "C'est l'un des avantages de cette méthode. Mais il y en a d'autres !",
            correct: true
		},
	]}
/>

### 5. Que signifie le remplissage (*padding*) dynamique ?

<Question
	choices={[
		{
			text: "C'est lorsque vous remplissez les entrées de chaque batch à la longueur maximale du jeu de données entier.",
			explain: "Cela implique un remplissage lors de la création du batch, mais pas à la longueur maximale du jeu de données entier."
		},
		{
			text: "C'est lorsque vous remplissez vos entrées lorsque le batch est créé, à la longueur maximale des phrases à l'intérieur de ce batch.",
			explain: "La partie dynamique vient du fait que la taille de chaque batch est déterminée au moment de la création, et que tous vos batchs peuvent avoir des formes différentes.",
            correct: true
		},
		{
			text: "C'est lorsque vous remplissez vos entrées de sorte que chaque phrase ait le même nombre de <i>tokens</i> que la précédente dans le jeu de données.",
			explain: "Cela n'a pas de sens de regarder l'ordre dans le jeu de données puisque nous le mélangeons pendant l'entraînement."
		},
	]}
/>

### 6. Quel est le but d'une fonction d'assemblement ?

<Question
	choices={[
		{
			text: "Elle garantit que toutes les séquences du jeu de données ont la même longueur.",
			explain: "Une fonction d'assemblement est impliquée dans le traitement des batchs individuels, et non de tout le jeu de données. De plus, nous parlons de fonctions génériques et pas spécialement du <code>DataCollatorWithPadding</code>."
		},
		{
			text: "Elle rassemble tous les échantillons dans un batch.",
			explain: "Vous pouvez passer la fonction d'assemblement comme argument d'une fonction <code>DataLoader</code>. Nous avons utilisé la fonction <code>DataCollatorWithPadding</code> qui remplit tous les éléments d'un batch pour qu'ils aient la même longueur.",
            correct: true
		},
		{
			text: "Elle pré-traite tout le jeu de données.",
			explain: "Ce serait une fonction de prétraitement, pas une fonction d'assemblement."
		},
        {
			text: "Elle tronque les séquences dans le jeu de données.",
			explain: "Une fonction d'assemblement est impliquée dans le traitement des batchs individuels, et non de tout le jeu de données. Si vous êtes intéressé par la troncature, vous pouvez utiliser la fonction <code>truncate</code> en argument du <code>tokenizer</code>."
		}
	]}
/>

### 7. Que se passe-t-il lorsque vous instanciez une des classes `AutoModelForXxx` avec un modèle de langage pré-entraîné (tel que `bert-base-uncased`) qui correspond à une tâche différente de celle pour laquelle il a été entraîné ?

<Question
	choices={[
		{
			text: "Rien, mais vous recevez un message d'avertissement.",
			explain: "Effectivement, mais ce n'est pas tout !"
		},
		{
			text: "La tête du modèle pré-entraîné est supprimée et une nouvelle tête adaptée à la tâche est insérée à la place.",
			explain: "Par exemple, lorsque nous avons utilisé l'<code>AutoModelForSequenceClassification</code> avec <code>bert-base-uncased</code>, nous avons eu des messages d'avertissement lors de l'instanciation du modèle. La tête pré-entraînée n'est pas utilisée pour la tâche de classification de séquences, elle est donc supprimée et une nouvelle tête est instanciée avec des poids aléatoires..",
            correct: true
		},
		{
			text: "La tête du modèle pré-entraîné est supprimée.",
			explain: "Quelque chose d'autre doit se produire. Essayez encore !"
		},
        {
			text: "Rien, puisque le modèle peut encore être <i>finetuné</i> pour les différentes tâches.",
			explain: "La tête du modèle pré-entraîné n'a pas été entraînée à résoudre cette tâche, nous devons donc la supprimer !"
		}
	]}
/>

### 8. Quel est le but de `TrainingArguments` ?

<Question
	choices={[
		{
			text: "Contenir tous les hyperparamètres utilisés pour l'entraînement et l'évaluation avec le <code>Trainer</code>.",
			explain: "",
            correct: true
		},
		{
			text: "Préciser la taille du modèle.",
			explain: "La taille du modèle est définie par la configuration du modèle, et non par la classe <code>TrainingArguments</code>."
		},
		{
			text: "Juste contenir les hyperparamètres utilisés pour l'évaluation.",
			explain: "Dans l'exemple, nous avons spécifié où le modèle et ses <i>checkpoints</i> seront sauvegardés. Essayez à nouveau !"
		},
        {
			text: "Contenir seulement les hyperparamètres utilisés pour l'entraînement.",
			explain: "Dans l'exemple, nous avons utilisé une <code>evaluation_strategy</code> également, ce qui a un impact sur l'évaluation. Essayez à nouveau !"
		}
	]}
/>

### 9. Pourquoi devriez-vous utiliser la librairie 🤗 *Accelerate* ?

<Question
	choices={[
		{
			text: "Elle permet d'accéder à des modèles plus rapides.",
			explain: "Non, la librairie 🤗 <i>Accelerate</i> ne fournit aucun modèles."
		},
		{
			text: "Elle fournit une API de haut niveau qui évite d'avoir à mettre en place sa propre boucle d'entraînement.",
			explain: "C'est ce que nous avons fait avec le <code>Trainer</code> mais pas avec la librairie 🤗 <i>Accelerate</i>. Essayez à nouveau !"
		},
		{
			text: "Elle permet à nos boucles d'entraînement de fonctionner avec des stratégies distribuées.",
			explain: "Avec 🤗 <i>Accelerate</i>, vos boucles d'entraînement fonctionneront pour plusieurs GPUs et TPUs.",
            correct: true
		},
        {
			text: "Elle offre davantage de fonctions d'optimisation.",
			explain: "Non, la librairie 🤗 <i>Accelerate</i> ne fournit pas de fonctions d'optimisation."
		}
	]}
/>

{:else}
### 4. Que se passe-t-il lorsque vous instanciez une des classes `TFAutoModelForXxx` avec un modèle de langage pré-entraîné (tel que `bert-base-uncased`) qui correspond à une tâche différente de celle pour laquelle il a été entraîné ?

<Question
	choices={[
		{
			text: "Rien, mais vous recevez un message d'avertissement.",
			explain: "Effectivement, mais ce n'est pas tout !"
		},
		{
			text: "La tête du modèle pré-entraîné est supprimée et une nouvelle tête adaptée à la tâche est insérée à la place.",
			explain: "Par exemple, lorsque nous avons utilisé <code>TFAutoModelForSequenceClassification</code> avec <code>bert-base-uncased</code>, nous avons eu des messages d'avertissement lors de l'instanciation du modèle. La tête pré-entraînée n'est pas utilisée pour la tâche de classification de séquences, elle est donc supprimée et une nouvelle tête est instanciée avec des poids aléatoires..",
            correct: true
		},
		{
			text: "La tête du modèle pré-entraîné est supprimée.",
			explain: "Quelque chose d'autre doit se produire. Essayez encore !"
		},
        {
			text: "Rien, puisque le modèle peut encore être <i>finetuné</i> pour les différentes tâches.",
			explain: "La tête du modèle pré-entraîné n'a pas été entraînée à résoudre cette tâche, nous devons donc la supprimer !"
		}
	]}
/>

### 5. Les modèles TensorFlow de `transformers` sont déjà des modèles Keras. Quel avantage cela offre-t-il ?

<Question
	choices={[
		{
			text: "Les modèles fonctionnent sur un TPU prêt à l'emploi.",
			explain: "Presque ! Il y a quelques petites modifications supplémentaires à apporter. Par exemple, vous devez tout exécuter dans un fichier de type <code>TPUStrategy</code>, y compris l'initialisation du modèle."
		},
		{
			text: "Vous pouvez tirer parti des méthodes existantes telles que <code>compile()</code>, <code>fit()</code> et <code>predict()</code>.",
			explain: "Une fois que vous disposez des données, l'entraînement sur celles-ci ne demande que très peu de travail.",
            correct: true
		},
		{
			text: "Vous apprendrez à connaître Keras ainsi que transformers.",
			explain: "Mais nous cherchons quelque chose d'autre :)",
			correct: true
		},
        {
			text: "Vous pouvez facilement calculer les métriques liées au jeu de données.",
			explain: "Keras nous aide à entraîner et à évaluer le modèle, et non à calculer les paramètres liés aux jeux de données."
		}
	]}
/>

### 6. Comment pouvez-vous définir votre propre métrique personnalisée ?

<Question
	choices={[
		{
			text: "Par le biais de la sous-classe <code>tf.keras.metrics.Metric</code>.",
			explain: "Excellent !",
			correct: true
		},
		{
			text: "Utilisation de l'API fonctionnelle de Keras.",
			explain: "Essayez à nouveau !"
		},
		{
			text: "En utilisant un callable avec la signature <code>metric_fn(y_true, y_pred)</code>.",
			explain: " ",
			correct: true
		},
        {
			text: "En le googlant.",
			explain: "Ce n'est pas la réponse que nous cherchons, mais cela devrait vous aider à la trouver.",
			correct: true
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter3/6.mdx" />