# Quiz de fin de chapitre

<CourseFloatingBanner
    chapter={6}
    classNames="absolute z-10 right-0 top-0"
/>

Testons ce que vous avez appris dans ce chapitre !

### 1. Quand devez-vous entraîner un nouveau <i>tokenizer</i> ?

<Question
	choices={[
		{
			text: "Lorsque votre jeu de données est similaire à celui utilisé par un modèle pré-entraîné existant et que vous voulez pré-entraîner un nouveau modèle",
			explain: "Dans ce cas, pour économiser du temps et des ressources de calcul, il est préférable d'utiliser le même <i>tokenizer</i> que le modèle pré-entraîné et de <i>finetuner</i> ce modèle à la place."
		},
		{
			text: "Lorsque votre jeu de données est similaire à celui utilisé par un modèle pré-entraîné existant et que vous souhaitez <i>finetuner</i> un nouveau modèle en utilisant ce modèle pré-entraîné.",
			explain: "Pour <i>finetuner</i> un modèle à partir d'un modèle pré-entraîné, vous devez toujours utiliser le même <i>tokenizer</i>."
		},
		{
			text: "Lorsque votre jeu de données est différent de celui utilisé par un modèle pré-entraîné existant et que vous souhaitez pré-entraîner un nouveau modèle.",
			explain: "Dans ce cas, il n'y a aucun avantage à utiliser le même <i>tokenizer</i>.",
            correct: true
		},
        {
			text: "Lorsque votre jeu de données est différent de celui utilisé par un modèle pré-entraîné existant mais que vous souhaitez <i>finetuner</i> un nouveau modèle en utilisant ce modèle pré-entraîné.",
			explain: "Pour <i>finetuner</i> un modèle à partir d'un modèle pré-entraîné, vous devez toujours utiliser le même <i>tokenizer</i>."
		}
	]}
/>

### 2. Quel est l'avantage d'utiliser un générateur de listes par rapport à une liste de listes lors de l'utilisation de <code>train_new_from_iterator()</code> ?

<Question
	choices={[
		{
			text: "C'est le seul type que la méthode <code>train_new_from_iterator()</code> accepte.",
			explain: "Une liste de listes de textes est un type particulier de générateur de listes de textes, la méthode l'acceptera donc aussi. Essayez à nouveau !"
		},
		{
			text: "Vous éviterez de charger l'ensemble des données en mémoire en une seule fois.",
			explain: "Chaque batch de textes sera libéré de la mémoire lorsque vous itérerez et le gain sera particulièrement visible si vous utilisez des 🤗 <i>Datasets</i> pour stocker vos textes.",
			correct: true
		},
		{
			text: "Cela permettra à la bibliothèque 🤗 <i>Tokenizers</i> d'utiliser le multitraitement.",
			explain: "Il utilisera le multiprocesseur dans tous les cas."
		},
        {
			text: "Le <i>tokenizer</i> que vous entraînez générera de meilleurs textes.",
			explain: "Le <i>tokenizer</i> ne génère pas de texte. Vous le confondez avec un modèle de langage ?"
		}
	]}
/>

### 3. Quels sont les avantages d'utiliser un <i>tokenizer</i> « rapide » ?

<Question
	choices={[
		{
			text: "Il peut traiter les entrées plus rapidement qu'un <i>tokenizer</i> lent lorsque vous faites des batchs d'entrées.",
			explain: "Grâce au parallélisme implémenté dans Rust, il sera plus rapide sur les batchs d'entrées. Quel autre avantage pouvez-vous imaginer ?",
			correct: true
		},
		{
			text: "Les <i>tokenizers</i> rapides sont toujours plus rapides que leurs homologues lents.",
			explain: "Un <i>tokenizer</i> rapide peut en fait être plus lent si vous ne lui donnez qu'un seul ou très peu de textes, car il ne peut pas utiliser le parallélisme."
		},
		{
			text: "Il peut appliquer le <i>padding</i> et la troncature.",
			explain: "C'est vrai, mais les <i>tokenizers</i> lents le font aussi."
		},
        {
			text: "Il possède des fonctionnalités supplémentaires qui vous permettent d'associer les <i>tokens</i> à l'extrait de texte qui les a créés.",
			explain: "En effet, c'est ce qu'on appelle des correspondances d'<i>offset</i>. Ce n'est pas le seul avantage, cependant.",
			correct: true
		}
	]}
/>

### 4. Comment le pipeline `token-classification` gère-t-il les entités qui s'étendent sur plusieurs <i>tokens</i> ?

<Question
	choices={[
		{
			text: "Les entités ayant la même étiquette sont fusionnées en une seule entité.",
			explain: "C'est un peu trop simplifier les choses. Essayez encore !"
		},
		{
			text: "Il existe une étiquette pour le début d'une entité et une étiquette pour la suite d'une entité.",
			explain: " ",
			correct: true
		},
		{
			text: "Dans un mot donné, tant que le premier <i>token</i> porte l'étiquette de l'entité, le mot entier est considéré comme étiqueté avec cette entité.",
			explain: "C'est une stratégie pour gérer les entités. Quelles autres réponses s'appliquent ici ?",
			correct: true
		},
        {
			text: "Lorsqu'un <i>token</i> a l'étiquette d'une entité donnée, tout autre <i>token</i> suivant ayant la même étiquette est considéré comme faisant partie de la même entité, à moins qu'il ne soit étiqueté comme le début d'une nouvelle entité.",
			explain: "C'est la façon la plus courante de regrouper des entités, mais ce n'est pas la seule bonne réponse.",
			correct: true
		}
	]}
/>

### 5. Comment le pipeline `question-answering` gère-t-il les contextes longs ?

<Question
	choices={[
		{
			text: "Ce n'est pas vraiment le cas car il tronque le long contexte à la longueur maximale acceptée par le modèle.",
			explain: "Il existe une astuce que vous pouvez utiliser pour gérer les longs contextes. Vous en souvenez-vous ?"
		},
		{
			text: "Il divise le contexte en plusieurs parties et fait la moyenne des résultats obtenus.",
			explain: "Cela n'aurait pas de sens de faire la moyenne des résultats car certaines parties du contexte n'incluront pas la réponse."
		},
		{
			text: "Il divise le contexte en plusieurs parties (avec chevauchement) et trouve le score maximum pour une réponse dans chaque partie.",
			explain: "C'est la bonne réponse !",
			correct: true
		},
        {
			text: "Il divise le contexte en plusieurs parties (sans chevauchemen par souci d'efficacité) et trouve le score maximum pour une réponse dans chaque partie.",
			explain: "Il comprend un certain chevauchement entre les parties pour éviter une situation où la réponse serait divisée en deux parties."
		}
	]}
/>

### 6. Qu'est-ce que la normalisation ?

<Question
	choices={[
		{
			text: "C'est le nettoyage que le <i>tokenizer</i> effectue sur les textes lors des étapes initiales.",
			explain: "Par exemple, il peut s'agir de supprimer les accents ou les espaces, ou de mettre les entrées en minuscules.",
			correct: true
		},
		{
			text: "Il s'agit d'une technique d'augmentation de données qui consiste à rendre le texte plus normal en supprimant les mots rares.",
			explain: "Essayez encore."
		},
		{
			text: "C'est l'étape finale du post-traitement où le <i>tokenizer</i> ajoute les <i>tokens</i> spéciaux.",
			explain: "Cette étape est simplement appelée post-traitement."
		},
        {
			text: "C'est lorsque les enchâssements sont faits avec une moyenne nulle et un écart-type de 1, en soustrayant la moyenne et en divisant par l'écart-type.",
			explain: "Ce processus est communément appelé normalisation lorsqu'il est appliqué aux valeurs des pixels en vision par ordinateur, mais ce n'est pas ce que signifie la normalisation en NLP."
		}
	]}
/>

### 7. Qu'est-ce que la pré-tokénisation pour un <i>tokenizer</i> en sous-mots ?

<Question
	choices={[
		{
			text: "C'est l'étape qui précède la tokénisation, où l'augmentation des données (comme le masquage aléatoire) est appliquée.",
			explain: "Cette étape fait partie du prétraitement."
		},
		{
			text: "C'est l'étape avant la tokénisation, où les opérations de nettoyage souhaitées sont appliquées au texte.",
			explain: "C'est l'étape de normalisation."
		},
		{
			text: "C'est l'étape qui précède l'application du modèle <i>tokenizer</i>, pour diviser l'entrée en mots.",
			explain: "C'est la bonne réponse !",
			correct: true
		},
        {
			text: "Il s'agit de l'étape précédant l'application du modèle <i>tokenizer</i>, qui divise l'entrée en <i>tokens</i>.",
			explain: "La division en <i>tokens</i> est le travail du modèle <i>tokenizer</i>."
		}
	]}
/>

### 8. Sélectionnez les phrases qui s'appliquent au <i>tokenizer</i> BPE.

<Question
	choices={[
		{
			text: "BPE est un algorithme de tokénisation en sous-mots qui part d'un petit vocabulaire et apprend des règles de fusion.",
			explain: "C'est le cas en effet !",
			correct: true
		},
		{
			text: "BPE est un algorithme de tokénisation en sous-mots qui part d'un grand vocabulaire et en retire progressivement les <i>tokens</i>.",
			explain: "C'est l'approche adoptée par un algorithme de tokénisation différent."
		},
		{
			text: "Un <i>tokenizer</i> BPE apprend les règles de fusion en fusionnant la paire de <i>tokens</i> la plus fréquente.",
			explain: "C'est exact !",
			correct: true
		},
		{
			text: "Un <i>tokenizer</i> BPE apprend une règle de fusion en fusionnant la paire de <i>tokens</i> qui maximise un score qui privilégie les paires fréquentes avec des parties individuelles moins fréquentes.",
			explain: "C'est la stratégie appliquée par un autre algorithme de tokenization."
		},
		{
			text: "BPE tokenise les mots en sous-mots en les divisant en caractères, puis en appliquant les règles de fusion.",
			explain: " ",
			correct: true
		},
		{
			text: "BPE tokenise les mots en sous-mots en trouvant le plus long sous-mot du vocabulaire en commençant par le début, puis en répétant le processus pour le reste du texte.",
			explain: "C'est la façon de faire d'un autre algorithme de tokenization."
		},
	]}
/>

### 9. Sélectionnez les phrases qui s'appliquent au <i>tokenizer</i> WordPiece.

<Question
	choices={[
		{
			text: "WordPiece est un algorithme de tokénisation en sous-mots qui part d'un petit vocabulaire et apprend des règles de fusion.",
			explain: "C'est le cas en effet !",
			correct: true
		},
		{
			text: "WordPiece est un algorithme de tokénisation en sous-mots qui part d'un grand vocabulaire et en retire progressivement les <i>tokens</i>.",
			explain: "C'est la façon de faire d'un autre algorithme de tokenization."
		},
		{
			text: "Les <i>tokenizer</i> WordPiece apprennent les règles de fusion en fusionnant la paire de <i>tokens</i> la plus fréquente.",
			explain: "C'est la façon de faire d'un autre algorithme de tokenization."
		},
		{
			text: "Un <i>tokenizer</i> WordPiece apprend une règle de fusion en fusionnant la paire de <i>tokens</i> qui maximise un score qui privilégie les paires fréquentes avec des parties individuelles moins fréquentes.",
			explain: " ",
			correct: true
		},
		{
			text: "WordPiece tokenise les mots en sous-mots en trouvant la segmentation en <i>tokens</i> la plus probable, selon le modèle.",
			explain: "C'est la façon de faire d'un autre algorithme de tokenization."
		},
		{
			text: "WordPiece tokenise les mots en sous-mots en trouvant le plus long sous-mot du vocabulaire en commençant par le début, puis en répétant le processus pour le reste du texte.",
			explain: "C'est ainsi que WordPiece procède pour l'encodage.",
			correct: true
		},
	]}
/>

### 10. Sélectionnez les phrases qui s'appliquent au <i>tokenizer</i> Unigram.

<Question
	choices={[
		{
			text: "Unigram est un algorithme de tokénisation en sous-mots qui part d'un petit vocabulaire et apprend des règles de fusion.",
			explain: "C'est la façon de faire d'un autre algorithme de tokenization."
		},
		{
			text: "Unigram est un algorithme de tokénisation en sous-mots qui part d'un grand vocabulaire et en retire progressivement les <i>tokens</i>.",
			explain: " ",
			correct: true
		},
		{
			text: "Unigram adapte son vocabulaire en minimisant une perte calculée sur l'ensemble du corpus.",
			explain: " ",
			correct: true
		},
		{
			text: "Unigram adapte son vocabulaire en conservant les sous-mots les plus fréquents.",
			explain: " "
		},
		{
			text: "Unigram segmente les mots en sous-mots en trouvant la segmentation la plus probable en <i>tokens</i>, selon le modèle.",
			explain: " ",
			correct: true
		},
		{
			text: "Unigram décompose les mots en sous-mots en les divisant en caractères puis en appliquant les règles de fusion.",
			explain: "C'est la façon de faire d'un autre algorithme de tokenization."
		},
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/fr/chapter6/10.mdx" />