# परिचय

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## 🤗 पाठ्यक्रम में आपका स्वागत है!

<Youtube id="00GKzGyWFEs" />

यह पाठ्यक्रम आपको [Hugging Face](https://huggingface.co) पारिस्थितिकी तंत्र - [🤗 ट्रान्सफ़ॉर्मर](https://github.com/huggingface/transformers), [🤗 डेटासेट](https://github.com/huggingface/datasets), [🤗 टोकनीज़र](https://github.com/huggingface/tokenizers), तथा [🤗 एक्सेलेरेट](https://github.com/huggingface/accelerate) - इसके साथ ही [हगिंग फेस हब](https://huggingface.co/models) पुस्तकालयों का उपयोग करके प्राकृतिक भाषा प्रसंस्करण (एनएलपी) के बारे में सिखाएगा। यह पूरी तरह से मुफ़्त है और विज्ञापनों के बिना है।

## क्या उम्मीद करें?

यहां पाठ्यक्रम का संक्षिप्त विवरण दिया गया है।

<div class="flex justify-center">
    <img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
    <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- अध्याय 1 से 4 🤗 ट्रान्सफ़ॉर्मर पुस्तकालय की मुख्य अवधारणाओं का परिचय प्रदान करते हैं। पाठ्यक्रम के इस भाग के अंत तक, आप इस बात से परिचित होंगे कि ट्रांसफार्मर मॉडल कैसे काम करते हैं और [हगिंग फेस हब](https://huggingface.co/models) से मॉडल का उपयोग करना जानते हैं, इसे ठीक करें। डेटासेट पर, और हब पर अपने परिणाम साझा करें!
- अध्याय 5 से 8 क्लासिक एनएलपी कार्यों में गोता लगाने से पहले 🤗 डेटासेट और 🤗 टोकनाइज़र की मूल बातें सिखाते हैं। इस भाग के अंत तक, आप सबसे आम एनएलपी समस्याओं से स्वयं निपटने में सक्षम होंगे।
- अध्याय 9 से 12 एनएलपी से आगे जाते हैं और यह पता लगाते हैं कि भाषा प्रसंस्करण और कंप्यूटर दृष्टि में कार्यों से निपटने के लिए ट्रांसफार्मर मॉडल का उपयोग कैसे किया जा सकता है। साथ ही, आप सीखेंगे कि अपने मॉडलों के डेमो कैसे बनाएं और साझा करें, और उन्हें उत्पादन परिवेशों के लिए अनुकूलित करें। इस भाग के अंत तक, आप (लगभग) किसी भी मशीन सीखने की समस्या के लिए 🤗 ट्रांसफॉर्मर लगाने के लिए तैयार होंगे!

यह पाठ्यक्रम के लिए:

* पायथन के अच्छे ज्ञान की आवश्यकता है
* प्रारंभिक गहन शिक्षण पाठ्यक्रम, जैसे [fast.ai के](https://www.fast.ai/) [कोडर्स के लिए प्रैक्टिकल डीप लर्निंग](https://course.fast.ai/) के बाद लेना बेहतर है। 
* पूर्व [PyTorch](https://pytorch.org/) या [TensorFlow](https://www.tensorflow.org/) ज्ञान की अपेक्षा नहीं करता है, हालांकि इनमें से किसी के साथ कुछ परिचित होने से मदद मिलेगी।

आपके द्वारा इस पाठ्यक्रम को पूरा करने के बाद, हम आपको DeepLearning.AI की [प्राकृतिक भाषा संसाधन विशेषज्ञता](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutes&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh) की जाँच करने की सलाह देते हैं। जो पारंपरिक NLP मॉडल जैसे कि Naive Bayes और LSTMs की एक विस्तृत श्रृंखला को कवर करता है, जो अच्छी तरह से जानने योग्य हैं!

## हम कौन हैं?

लेखक के बारे में:

**मैथ्यू कैरिगन** हगिंग फेस में मशीन लर्निंग इंजीनियर हैं। वह डबलिन, आयरलैंड में रहता है, और पहले Parse.ly में एक एमएल इंजीनियर के रूप में काम करता था और उससे पहले ट्रिनिटी कॉलेज डबलिन में पोस्ट-डॉक्टरेट शोधकर्ता के रूप में काम करता था। वह विश्वास नहीं कर सकता कि हम मौजूदा आर्किटेक्चर को स्केल करके एजीआई तक पहुंचने जा रहे हैं, लेकिन रोबोट अमरता की परवाह किए बिना उच्च उम्मीदें हैं।

**लिसेंड्रे डेब्यू** हगिंग फेस में एक मशीन लर्निंग इंजीनियर है और बहुत प्रारंभिक विकास चरणों के बाद से 🤗 ट्रांसफॉर्मर्स लाइब्रेरी पर काम कर रहा है। उनका उद्देश्य एक बहुत ही सरल एपीआई के साथ उपकरण विकसित करके एनएलपी को सभी के लिए सुलभ बनाना है।

**सिल्वेन गुगर** हगिंग फेस में एक रिसर्च इंजीनियर हैं और 🤗 ट्रान्सफ़ॉर्मर्स लाइब्रेरी के मुख्य अनुरक्षकों में से एक हैं। पहले वे fast.ai में एक शोध वैज्ञानिक थे, और उन्होंने _[डीप लर्निंग फॉर कोडर्स विद फास्टाई और पायटॉर्च](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/) का सह-लेखन किया जेरेमी हॉवर्ड के साथ। उनके शोध का मुख्य फोकस तकनीकों को डिजाइन और सुधार करके गहन शिक्षण को और अधिक सुलभ बनाने पर है जो मॉडल को सीमित संसाधनों पर तेजी से प्रशिक्षित करने की अनुमति देता है।

**मर्व नोयान** हगिंग फेस में एक डेवलपर एडवोकेट है, जो सभी के लिए मशीन लर्निंग का लोकतंत्रीकरण करने के लिए टूल विकसित करने और उनके आसपास सामग्री बनाने पर काम कर रहे है।

**ल्यूसिले शाॅलनियर** हगिंग फेस में एक मशीन लर्निंग इंजीनियर है, जो ओपन-सोर्स टूल के उपयोग का विकास और समर्थन करता है। वह सहयोगात्मक प्रशिक्षण और बिगसाइंस जैसे प्राकृतिक भाषा प्रसंस्करण के क्षेत्र में कई शोध परियोजनाओं में भी सक्रिय रूप से शामिल हैं।

**लुईस ट्यूनस्टाल** हगिंग फेस में एक मशीन लर्निंग इंजीनियर है, जो ओपन-सोर्स टूल विकसित करने और उन्हें व्यापक समुदाय के लिए सुलभ बनाने पर केंद्रित है। वह आगामी [ओ'रेली बुक ऑन ट्रांसफॉर्मर्स](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) के सह-लेखक भी हैं।

**लिंड्रो वॉन वेरा** हगिंग फेस की ओपन-सोर्स टीम में मशीन लर्निंग इंजीनियर हैं और आगामी [ओ'रेली बुक ऑन ट्रांसफॉर्मर्स](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) के सह-लेखक भी हैं। पूरे मशीन लर्निंग स्टैक में काम करके एनएलपी परियोजनाओं को उत्पादन में लाने के लिए उनके पास कई वर्षों का औद्योगिक अनुभव है।

क्या आप तैयार हैं? इस अध्याय में आप सीखेंगे:
* पाठ निर्माण और वर्गीकरण जैसे एनएलपी कार्यों को हल करने के लिए `pipeline()` फ़ंक्शन का उपयोग कैसे करें
* ट्रांसफार्मर आर्किटेक्चर के बारे में
* एन्कोडर, डिकोडर और एन्कोडर-डिकोडर आर्किटेक्चर के बीच अंतर कैसे करें और उपयोग करें


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/hi/chapter1/1.mdx" />