# अध्याय के अंत की प्रश्नोत्तरी

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

इस अध्याय में बहुत सारी जमीन शामिल है! यदि आप सभी विवरणों को नहीं समझ पाए हैं तो चिंता न करें; अगले अध्याय आपको यह समझने में मदद करेंगे कि चीजें हुड के तहत कैसे काम करती हैं।

लेकिन, आइए पहले यह जाँचें कि आपने इस अध्याय में क्या सीखा!

### 1. हब को एक्सप्लोर करें और `रॉबर्टा-लार्ज-एमएनली` चेकपॉइंट देखें। यह कौन सा कार्य करता है?

<Question
	choices={[
		{
			text: "संक्षेपण",
			explain: "<a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli पेज</a> पर फिर से देखें।"
		},
		{
			text: "पाठ वर्गीकरण",
			explain: "अधिक सटीक रूप से, यह वर्गीकृत करता है कि क्या दो वाक्य तार्किक रूप से तीन लेबल (विरोधाभास, तटस्थ, प्रवेश) से जुड़े हुए हैं - एक कार्य जिसे <em>प्राकृतिक भाषा अनुमान</em> भी कहा जाता है।",
			correct: true
		},
		{
			text: "पाठ निर्माण",
			explain: "<a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli पेज</a> पर फिर से देखें।"
		}
	]}
/>

### 2. निम्नलिखित कोड क्या लौटाएगा?

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "यह इस वाक्य के लिए \"सकारात्मक\" या \"नकारात्मक\" लेबल के साथ वर्गीकरण स्कोर लौटाएगा।",
			explain: "यह गलत है — यह एक <code>भावना-विश्लेषण</code> पाइपलाइन होगी।"
		},
		{
			text: "यह इस वाक्य को पूरा करने वाला एक उत्पन्न पाठ लौटाएगा।",
			explain: "यह गलत है — यह एक <code>टेक्स्ट-जनरेशन</code> पाइपलाइन होगी।",
		},
		{
			text: "यह व्यक्तियों, संगठनों या स्थानों का प्रतिनिधित्व करने वाले शब्दों को वापस कर देगा।",
			explain: "इसके अलावा, <code>grouped_entities=True</code> के साथ, यह एक ही इकाई से संबंधित शब्दों को एक साथ समूहित करेगा, जैसे \"हगिंग फेस\"।",
			correct: true
		}
	]}
/>

### 3. क्या प्रतिस्थापित करना चाहिए ... इस कोड नमूने में?

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "यह &#60;mask> आपका इंतजार कर रहा है।",
			explain: "यह गलत है। <code>bert-base-cased</code> मॉडल कार्ड देखें और अपनी गलती का पता लगाने का प्रयास करें।"
		},
		{
			text: "यह [मास्क] आपका इंतजार कर रहा है।",
			explain: "सही! इस मॉडल का मास्क टोकन [MASK] है।",
			correct: true
		},
		{
			text: "यह आदमी तुम्हारा इंतजार कर रहा है।",
			explain: "यह गलत है। यह पाइपलाइन नकाबपोश शब्दों में भरती है, इसलिए इसे कहीं न कहीं मास्क टोकन की जरूरत है।"
		}
	]}
/>

### 4. यह कोड विफल क्यों होगा?

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
			text: "इस पाइपलाइन के लिए आवश्यक है कि इस पाठ को वर्गीकृत करने के लिए लेबल दिए जाएं।",
			explain: "सही — सही कोड में <code>candidate_labels=[...]</code> शामिल होना चाहिए।",
			correct: true
		},
		{
			text: "इस पाइपलाइन के लिए केवल एक नहीं, बल्कि कई वाक्यों की आवश्यकता है।",
			explain: "यह गलत है, हालांकि जब ठीक से उपयोग किया जाता है, तो यह पाइपलाइन प्रक्रिया के लिए वाक्यों की एक सूची ले सकती है (अन्य सभी पाइपलाइनों की तरह)।"
		},
		{
			text: "🤗 ट्रान्सफ़ॉर्मर पुस्तकालय हमेशा की तरह टूटा हुआ है।",
			explain: "हम इस उत्तर को एक टिप्पणी के साथ सम्मानित नहीं करेंगे!!"
		},
		{
			text: "इस पाइपलाइन को लंबे समय तक इनपुट की आवश्यकता है; यह बहुत छोटा है।",
			explain: "यह गलत है। ध्यान दें कि इस पाइपलाइन द्वारा संसाधित किए जाने पर एक बहुत लंबा टेक्स्ट छोटा कर दिया जाएगा।"
		}
	]}
/>

### 5. "ट्रांसफर लर्निंग" का क्या अर्थ है?

<Question
	choices={[
		{
			text: "एक पूर्व-प्रशिक्षित मॉडल के ज्ञान को उसी डेटासेट पर प्रशिक्षण देकर एक नए मॉडल में स्थानांतरित करना।",
			explain: "नहीं, यह एक ही मॉडल के दो संस्करण होंगे।"
		},
		{
			text: "पहले मॉडल के वजन के साथ दूसरे मॉडल को इनिशियलाइज़ करके एक पूर्व-प्रशिक्षित मॉडल के ज्ञान को एक नए मॉडल में स्थानांतरित करना।",
			explain: "सही: जब दूसरे मॉडल को एक नए कार्य के लिए प्रशिक्षित किया जाता है, तो यह पहले मॉडल के ज्ञान को *स्थानांतरित* करता है।",
			correct: true
		},
		{
			text: "पहले मॉडल के समान आर्किटेक्चर के साथ दूसरे मॉडल का निर्माण करके एक पूर्व-प्रशिक्षित मॉडल के ज्ञान को एक नए मॉडल में स्थानांतरित करना।",
			explain: "आर्किटेक्चर ठीक उसी तरह है जैसे मॉडल बनाया गया है; इस मामले में कोई ज्ञान साझा या स्थानांतरित नहीं किया गया है।"
		}
	]}
/>

### 6. सही या गलत? एक भाषा मॉडल को आमतौर पर इसके पूर्व-प्रशिक्षण के लिए लेबल की आवश्यकता नहीं होती है।

<Question
	choices={[
		{
			text: "सही",
			explain: "पूर्व-प्रशिक्षण आमतौर पर <em>स्व-पर्यवेक्षित</em> होता है, जिसका अर्थ है कि लेबल स्वचालित रूप से इनपुट से बनाए जाते हैं (जैसे अगले शब्द की भविष्यवाणी करना या कुछ नकाबपोश शब्दों को भरना)।",
			correct: true
		},
		{
			text: "गलत",
			explain: "यह सही उत्तर नहीं है।"
		}
	]}
/>

### 7. उस वाक्य का चयन करें जो "मॉडल," "वास्तुकला," और "वजन" शब्दों का सबसे अच्छा वर्णन करता है।

<Question
	choices={[
		{
			text: "यदि कोई मॉडल एक इमारत है, तो उसकी वास्तुकला खाका है और वजन अंदर रहने वाले लोग हैं।",
			explain: "इस रूपक के बाद, इमारत के निर्माण के लिए उपयोग की जाने वाली ईंटों और अन्य सामग्रियों का वजन होगा।"
		},
		{
			text: "वास्तुकला एक मॉडल के निर्माण के लिए एक नक्शा है और इसके भार मानचित्र पर दर्शाए गए शहर हैं।",
			explain: "इस रूपक के साथ समस्या यह है कि एक नक्शा आमतौर पर एक मौजूदा वास्तविकता का प्रतिनिधित्व करता है (फ्रांस में पेरिस नाम का केवल एक शहर है)। किसी दिए गए आर्किटेक्चर के लिए, कई वज़न संभव हैं।"
		},
		{
			text: "आर्किटेक्चर एक मॉडल बनाने के लिए गणितीय कार्यों का एक क्रम है और इसके भार वे फ़ंक्शन पैरामीटर हैं।",
			explain: "विभिन्न मापदंडों (वजन) का उपयोग करके विभिन्न मॉडलों के निर्माण के लिए गणितीय कार्यों (वास्तुकला) के एक ही सेट का उपयोग किया जा सकता है।",
			correct: true
		}
	]}
/>

### 8. आप जनरेट किए गए टेक्स्ट के साथ संकेतों को पूरा करने के लिए इनमें से किस प्रकार के मॉडल का उपयोग करेंगे?

<Question
	choices={[
		{
			text: "एक एन्कोडर मॉडल",
			explain: "एक एन्कोडर मॉडल पूरे वाक्य का प्रतिनिधित्व करता है जो वर्गीकरण जैसे कार्यों के लिए बेहतर अनुकूल है।"
		},
		{
			text: "एक डिकोडर मॉडल",
			explain: "डिकोडर मॉडल एक प्रॉम्प्ट से टेक्स्ट जनरेशन के लिए पूरी तरह से अनुकूल हैं।",
			correct: true
		},
		{
			text: "अनुक्रम-से-अनुक्रम मॉडल",
			explain: "अनुक्रम-से-अनुक्रम मॉडल उन कार्यों के लिए बेहतर अनुकूल हैं जहां आप इनपुट वाक्यों के संबंध में वाक्य उत्पन्न करना चाहते हैं, दिए गए संकेत नहीं।"
		}
	]}
/>

### 9. पाठों को सारांशित करने के लिए आप इनमें से किस प्रकार के मॉडल का उपयोग करेंगे?

<Question
	choices={[
		{
			text: "एक एन्कोडर मॉडल",
			explain: "एक एन्कोडर मॉडल पूरे वाक्य का प्रतिनिधित्व करता है जो वर्गीकरण जैसे कार्यों के लिए बेहतर अनुकूल है।"
		},
		{
			text: "एक डिकोडर मॉडल",
			explain: "डिकोडर मॉडल आउटपुट टेक्स्ट (सारांश की तरह) उत्पन्न करने के लिए अच्छे हैं, लेकिन उनके पास सारांशित करने के लिए संपूर्ण टेक्स्ट जैसे संदर्भ का फायदा उठाने की क्षमता नहीं है।"
		},
		{
			text: "अनुक्रम-से-अनुक्रम मॉडल",
			explain: "अनुक्रम-से-अनुक्रम मॉडल संक्षेप कार्य के लिए पूरी तरह उपयुक्त हैं।",
			correct: true
		}
	]}
/>

### 10. कुछ लेबल के अनुसार टेक्स्ट इनपुट को वर्गीकृत करने के लिए आप इनमें से किस प्रकार के मॉडल का उपयोग करेंगे?

<Question
	choices={[
		{
			text: "एक एन्कोडर मॉडल",
			explain: "एक एन्कोडर मॉडल पूरे वाक्य का प्रतिनिधित्व करता है जो वर्गीकरण जैसे कार्य के लिए पूरी तरह उपयुक्त है।",
			correct: true
		},
		{
			text: "एक डिकोडर मॉडल",
			explain: "डिकोडर मॉडल आउटपुट टेक्स्ट जेनरेट करने के लिए अच्छे होते हैं, न कि किसी वाक्य से किसी लेबल को निकालने के लिए।"
		},
		{
			text: "अनुक्रम-से-अनुक्रम मॉडल",
			explain: "अनुक्रम-से-अनुक्रम मॉडल उन कार्यों के लिए बेहतर अनुकूल हैं जहां आप एक इनपुट वाक्य के आधार पर पाठ उत्पन्न करना चाहते हैं, न कि एक लेबल।",
		}
	]}
/>

### 11. एक मॉडल में देखे गए पूर्वाग्रह के संभावित स्रोत क्या हो सकते हैं?

<Question
	choices={[
		{
			text: "मॉडल एक पूर्व-प्रशिक्षित मॉडल का एक परिष्कृत संस्करण है और इसने इससे अपना पूर्वाग्रह उठाया।",
			explain: "ट्रांसफर लर्निंग को लागू करते समय, इस्तेमाल किए गए पूर्व-प्रशिक्षित मॉडल में पूर्वाग्रह फाइन-ट्यून मॉडल में होता है।",
			correct: true
		},
		{
			text: "जिस डेटा पर मॉडल को प्रशिक्षित किया गया था वह पक्षपाती है।",
			explain: "यह पूर्वाग्रह का सबसे स्पष्ट स्रोत है, लेकिन केवल एक ही नहीं है।",
			correct: true
		},
		{
			text: "जिस मीट्रिक के लिए मॉडल को अनुकूलित किया गया था, वह पक्षपाती है।",
			explain: "मॉडल को प्रशिक्षित करने का तरीका पूर्वाग्रह का एक कम स्पष्ट स्रोत है। आपका मॉडल बिना किसी दूसरे विचार के, आपके द्वारा चुने गए किसी भी मीट्रिक के लिए आँख बंद करके अनुकूलन करेगा।",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/hi/chapter1/10.mdx" />