# अध्याय-का-अंत प्रश्नोत्तरी

<CourseFloatingBanner
    chapter={3}
    classNames="absolute z-10 right-0 top-0"
/>

इस अध्याय में आपने जो सीखा, उसका परीक्षण करें!

### 1. `इमोशन` डेटासेट में ट्विटर संदेश है जिनहे भावनाओं के साथ लेबल किया गया है। इसे [हब](https://huggingface.co/datasets) में खोजें, और डेटासेट कार्ड पढ़ें। इनमें से कौन सा इसकी मूल भावनाओं में से एक नहीं है?

<Question
	choices={[
		{
			text: "हर्ष",
			explain: "पुनः प्रयास करें — यह भावना उस डेटासेट में मौजूद है!"
		},
		{
			text: "प्रेम",
			explain: "पुनः प्रयास करें — यह भावना उस डेटासेट में मौजूद है!"
		},
		{
			text: "कन्फ्यूश़न",
			explain: "सही! भ्रम छह बुनियादी भावनाओं में से एक नहीं है।",
            correct: true
		},
        {
			text: "सप्राइज़",
			explain: "सप्राइज़! एक बार फिर कोशिश करें!"
		}
	]}
/>

### 2. [हब](https://huggingface.co/datasets) में `ar_sarcasm` डेटासेट खोजें। यह कौन से कार्य का समर्थन करता है?

<Question
	choices={[
		{
			text: "भाव वर्गीकरण",
			explain: "ये सही है! आप टैग को धन्यवाद दे सकते हैं।",
            correct: true
		},
		{
			text: "मशीन अनुवाद",
			explain: "यह बात नहीं है — <a href='https://huggingface.co/datasets/ar_sarcasm'>डेटासेट कार्ड</a> पर एक और नज़र डालें !"
		},
		{
			text: "नैम्ड एन्टिटी रेकग्निशन",
			explain: "यह बात नहीं है — <a href='https://huggingface.co/datasets/ar_sarcasm'>डेटासेट कार्ड</a> पर एक और नज़र डालें !"
		},
        {
			text: "क्वेश्चन आंसरिंग",
			explain: "हाय! इस प्रश्न का उत्तर सही नहीं दिया। पुनः प्रयास करें!"
		}
	]}
/>

### 3. BERT मॉडल वाक्यों की एक जोड़ी को कैसे संसाधित करने की अपेक्षा करता है?

<Question
	choices={[
		{
			text: "वाक्य_के_टोकन_1 [SEP] वाक्य_के_टोकन_2",
			explain: "दो वाक्यों को अलग करने के लिए एक <code>[SEP]</code> विशेष टोकन की आवश्यकता है, लेकिन केवल यही एक चीज नहीं है!"
		},
		{
			text: "[CLS] वाक्य_के_टोकन_1 वाक्य_के_टोकन_2",
			explain: "शुरुआत में एक <code>[CLS]</code> विशेष टोकन की आवश्यकता होती है, लेकिन केवल यही एक चीज नहीं है!"
		},
		{
			text: "[CLS] वाक्य_के_टोकन_1 [SEP] वाक्य_के_टोकन_2 [SEP]",
			explain: "यह सही है!",
            correct: true
		},
        {
			text: "[CLS] वाक्य_के_टोकन_1 [SEP] वाक्य_के_टोकन_2",
			explain: "शुरुआत में एक <code>[CLS]</code> विशेष टोकन की आवश्यकता होती है और साथ ही साथ दो वाक्यों को अलग करने के लिए एक <code>[SEP]</code> विशेष टोकन की आवश्यकता होती है, लेकिन यही सब नहीं है!"
		}
	]}
/>

{#if fw === 'pt'}
### 4. `Dataset.map()` विधि के क्या लाभ हैं?

<Question
	choices={[
		{
			text: "फ़ंक्शन के परिणाम कैश किए जाते हैं, इसलिए यदि हम कोड को फिर से निष्पादित करते हैं तो इसमें कोई समय नहीं लगेगा।",
			explain: "यह वास्तव में इस पद्धति के स्वच्छ लाभों में से एक है! हालांकि यह अकेला नहीं है...",
            correct: true
		},
		{
			text: "यह डेटासेट के प्रत्येक तत्व पर फ़ंक्शन को लागू करने के बजाए तेज़ी से आगे बढ़ने के लिए बहुप्रक्रमण लागू कर सकता है।",
			explain: "यह इस पद्धति की एक साफ-सुथरी विशेषता है, लेकिन केवल यही एक नहीं है!",
            correct: true
		},
		{
			text: "यह पूरे डेटासेट को मेमोरी में लोड नहीं करता है, जैसे ही एक तत्व संसाधित होता है उसके परिणामो को सहेजता हैं।",
			explain: "यह इस विधि का एक फायदा है। हालांकि अन्य भी हैं!",
            correct: true
		},
	]}
/>

### 5. डायनेमिक पैडिंग का क्या अर्थ है?

<Question
	choices={[
		{
			text: "यह तब होता है जब आप प्रत्येक बैच के लिए इनपुट को अधिकतम लंबाई तक संपूर्ण डेटासेट में पैड करते हैं।",
			explain: "इसका मतलब है बैच बनाते समय पैडिंग करना, लेकिन पूरे डेटासेट में अधिकतम लंबाई तक नहीं।"
		},
		{
			text: "यह तब होता है जब आप बैच बनाते समय अपने इनपुट को पैड करते हैं, उस बैच के अंदर वाक्यों की अधिकतम लंबाई तक।",
			explain: "यह सही है! \"डायनेमिक\" भाग इस तथ्य से आता है कि प्रत्येक बैच का आकार निर्माण के समय निर्धारित होता है, और परिणामस्वरूप आपके सभी बैचों के अलग-अलग आकार हो सकते हैं।",
            correct: true
		},
		{
			text: "यह तब होता है जब आप अपने इनपुट को पैड करते हैं ताकि प्रत्येक वाक्य में टोकन की समान संख्या हो जितने पिछले वाले में है डेटासेट के।",
			explain: "यह गलत है, साथ ही डेटासेट में ऑर्डर को देखने का कोई मतलब ही नहीं है क्योंकि हम इसे प्रशिक्षण के दौरान फेरबदल यानि शफल करते हैं।"
		},
	]}
/>

### 6. कोलेट फ़ंक्शन का उद्देश्य क्या है?

<Question
	choices={[
		{
			text: "यह सुनिश्चित करता है कि डेटासेट में सभी अनुक्रमों की लंबाई समान हो।",
			explain: "एक कोलेट फ़ंक्शन अलग-अलग बैचों को संभालने में शामिल होता है, संपूर्ण डेटासेट नहीं। इसके अतिरिक्त, हम सामान्य कोलेट फ़ंक्शंस के बारे में बात कर रहे हैं, न कि विशेष रूप से <code>DataCollatorWithPadding</code> की।"
		},
		{
			text: "यह सभी सैम्पल्स को एक बैच में एक साथ रखता है।",
			explain: "सही! आप कोलेट फ़ंक्शन को <code>DataLoader</code> के वितर्क के रूप में पास कर सकते हैं। हमने <code>DataCollatorWithPadding</code> फ़ंक्शन का उपयोग किया है, जो एक बैच में सभी आइटम्स को पैड करता है ताकि उनकी लंबाई समान हो।",
            correct: true
		},
		{
			text: "यह पूरे डेटासेट को पूर्व प्रसंस्करण यानि प्रीप्रोसेस करता है।",
			explain: "यह एक प्रीप्रोसेसिंग फ़ंक्शन होगा, न कि कोलेट फ़ंक्शन।"
		},
        {
			text: "यह डेटासेट में अनुक्रमों को छोटा कर देता है।",
			explain: "एक कोलेट फ़ंक्शन अलग-अलग बैचों को संभालने में शामिल होता है, संपूर्ण डेटासेट नहीं। यदि आप काट-छाँट करने में रुचि रखते हैं, तो आप <code>tokenizer</code> के <code>truncate</code> वितर्क का उपयोग कर सकते हैं।"
		}
	]}
/>

### 7. क्या होता है जब आप `AutoModelForXxx` कक्षाओं में से एक को पूर्व-प्रशिक्षित भाषा मॉडल (जैसे कि `बर्ट-बेस-अनकेस्ड`) के साथ इन्स्टैन्शीऐट करते हैं, जो भिन्न कार्य से मेल खाता है बजाये उसके जिसके लिए उसे प्रशिक्षित किया गया ?

<Question
	choices={[
		{
			text: "कुछ नहीं, लेकिन आपको चेतावनी मिलती है।",
			explain: "आपको एक चेतावनी मिलती है, लेकिन इतना ही नहीं!"
		},
		{
			text: "पूर्व-प्रशिक्षित मॉडल के प्रमुख को त्याग दिया जाता है और इसके बजाये कार्य के लिए उपयुक्त एक नया प्रमुख डाला जाता है।",
			explain: "सही। उदाहरण के लिए, जब हमने <code>AutoModelForSequenceClassification</code> का उपयोग <code>bert-base-uncased</code> के साथ किया, तो मॉडल को इन्स्टैन्शीऐट करते समय हमें चेतावनियां मिलीं। अनुक्रम वर्गीकरण कार्य के लिए पूर्व-प्रशिक्षित के प्रमुख का उपयोग नहीं किया जाता है, इसलिए इसे त्याग दिया जाता है और क्रमरहित भार के साथ एक नये प्रमुख को इन्स्टैन्शीऐट किया जाता है।",
            correct: true
		},
		{
			text: "पूर्व-प्रशिक्षित मॉडल के प्रमुख को त्याग दिया जाता है ।",
			explain: "कुछ और होना चाहिए। पुनः प्रयास करें!"
		},
        {
			text: "कुछ भी नहीं, चूंकि मॉडल को अभी भी भिन्न कार्य के लिए ठीक यानि फाइन-ट्यून किया जा सकता है।",
			explain: "इस कार्य को हल करने के लिए पूर्व-प्रशिक्षित मॉडल के प्रमुख को प्रशिक्षित नहीं किया गया था, इसलिए हमें प्रमुख को त्याग देना चाहिए!"
		}
	]}
/>

### 8. `TrainingArguments` का क्या उद्देश्य है?

<Question
	choices={[
		{
			text: "इसमें <code>Trainer</code> के साथ प्रशिक्षण और मूल्यांकन के लिए उपयोग किए जाने वाले सभी हाइपरपैरामीटर शामिल हैं।",
			explain: "सही!",
            correct: true
		},
		{
			text: "यह मॉडल के आकार को निर्दिष्ट करता है।",
			explain: "मॉडल का आकार मॉडल कॉन्फ़िगरेशन द्वारा परिभाषित किया जाता है, न कि कक्षा <code>TrainingArguments</code> द्वारा।"
		},
		{
			text: "इसमें केवल मूल्यांकन के लिए उपयोग किए जाने वाले हाइपरपैरामीटर शामिल हैं।",
			explain: "उदाहरण में, हमने निर्दिष्ट किया कि मॉडल और उसकी चौकियों को कहाँ सहेजा जाएगा। पुनः प्रयास करें!"
		},
        {
			text: "इसमें सिर्फ प्रशिक्षण के लिए उपयोग किए जाने वाले हाइपरपैरामीटर शामिल हैं।",
			explain: "उदाहरण में, हमने <code>evaluation_strategy</code> का भी इस्तेमाल किया है, इसलिए यह मूल्यांकन को प्रभावित करता है। पुनः प्रयास करें!"
		}
	]}
/>

### 9. आपको 🤗 Accelerate लाइब्रेरी का उपयोग क्यों करना चाहिए?

<Question
	choices={[
		{
			text: "यह तेज मॉडल तक पहुंच प्रदान करता है।",
			explain: "नहीं, 🤗 Accelerate लाइब्रेरी कोई मॉडल प्रदान नहीं करती है।"
		},
		{
			text: "यह एक उच्च स्तरीय API प्रदान करता है इसलिए मुझे अपना खुद का प्रशिक्षण लूप लागू करने की आवश्यकता नहीं है।",
			explain: "हमने <code>Trainer</code> के साथ यही किया है, न की 🤗 Accelerate लाइब्रेरी ने। पुनः प्रयास करें!"
		},
		{
			text: "यह हमारे प्रशिक्षण लूप्स को वितरित रणनीतियों पर काम कराता है",
			explain: "सही! 🤗 Accelerate के साथ, आपका प्रशिक्षण लूप कई GPUs और TPUs के लिए काम करेगा।",
            correct: true
		},
        {
			text: "यह अधिक ऑप्टिमाइजेशन फंक्शन्स प्रदान करता है।",
			explain: "नहीं, 🤗 Accelerate लाइब्रेरी कोई ऑप्टिमाइजेशन फंक्शन्स प्रदान नहीं करता है।"
		}
	]}
/>

{:else}
### 4. क्या होता है जब आप `TFAutoModelForXxx` कक्षाओं में से एक को पूर्व-प्रशिक्षित भाषा मॉडल (जैसे कि `बर्ट-बेस-अनकेस्ड`) के साथ इन्स्टैन्शीऐट करते हैं, जो भिन्न कार्य से मेल खाता है बजाये उसके जिसके लिए उसे प्रशिक्षित किया गया ?

<Question
	choices={[
		{
			text: "कुछ नहीं, लेकिन आपको चेतावनी मिलती है।",
			explain: "आपको एक चेतावनी मिलती है, लेकिन इतना ही नहीं!"
		},
		{
			text: "पूर्व-प्रशिक्षित मॉडल के प्रमुख को त्याग दिया जाता है और इसके बजाये कार्य के लिए उपयुक्त एक नया प्रमुख डाला जाता है।",
			explain: "सही। उदाहरण के लिए, जब हमने <code>TFAutoModelForSequenceClassification</code> का उपयोग <code>bert-base-uncased</code> के साथ किया, तो मॉडल को इन्स्टैन्शीऐट करते समय हमें चेतावनियां मिलीं। अनुक्रम वर्गीकरण कार्य के लिए पूर्व-प्रशिक्षित के प्रमुख का उपयोग नहीं किया जाता है, इसलिए इसे त्याग दिया जाता है और क्रमरहित भार के साथ एक नये प्रमुख को इन्स्टैन्शीऐट किया जाता है।",
            correct: true
		},
		{
			text: "पूर्व-प्रशिक्षित मॉडल के प्रमुख को त्याग दिया जाता है ।",
			explain: "कुछ और होना चाहिए। पुनः प्रयास करें!"
		},
        {
			text: "कुछ भी नहीं, चूंकि मॉडल को अभी भी भिन्न कार्य के लिए ठीक यानि फाइन-ट्यून किया जा सकता है।",
			explain: "इस कार्य को हल करने के लिए पूर्व-प्रशिक्षित मॉडल के प्रमुख को प्रशिक्षित नहीं किया गया था, इसलिए हमें प्रमुख को त्याग देना चाहिए!"
		}
	]}
/>

### 5. `ट्रांसफॉर्मर` से TensorFlow मॉडल पहले से ही Keras मॉडल हैं। यह क्या लाभ प्रदान करता है?

<Question
	choices={[
		{
			text: "मॉडल बॉक्स के बाहर एक टीपीयू पर काम करते हैं।",
			explain: "लगभग! कुछ छोटे अतिरिक्त परिवर्तनों की आवश्यकता है। उदाहरण के लिए, आपको सब कुछ एक <code>TPUStrategy</code> दायरे में चलाने की जरूरत है, जिसमें मॉडल का इनिशियलाइज़ेशन भी शामिल है।"
		},
		{
			text: "आप <code>compile()</code>, <code>fit()</code>, और <code>predict()</code> जैसी मौजूदा विधियों का लाभ उठा सकते हैं।",
			explain: "सही! एक बार आपके पास डेटा हो जाने के बाद, उस पर प्रशिक्षण के लिए बहुत कम काम की आवश्यकता होती है।",
            correct: true
		},
		{
			text: "आपको Keras के साथ-साथ ट्रांसफार्मरस भी सीखने को मिलते हैं।",
			explain: "सही है, लेकिन हम कुछ और ढूंढ रहे हैं :)",
			correct: true
		},
        {
			text: "आप डेटासेट से संबंधित मेट्रिक्स की आसानी से गणना कर सकते हैं।",
			explain: "आप डेटासेट से संबंधित मेट्रिक्स की आसानी से गणना कर सकते हैं।"
		}
	]}
/>

### 6. आप अपनी खुद की कस्टम मीट्रिक कैसे परिभाषित कर सकते हैं?

<Question
	choices={[
		{
			text: "<code>tf.keras.metrics.Metric</code> की उपवर्गीकरण करके।",
			explain: "बहुत बढ़िया !",
			correct: true
		},
		{
			text: "Keras क्रियात्मक API का उपयोग करना।",
			explain: "पुनः प्रयास करें!"
		},
		{
			text: "हस्ताक्षर <code>metric_fn(y_true, y_pred)</code> के साथ प्रतिदेय का उपयोग करना।",
			explain: "सही!",
			correct: true
		},
        {
			text: "इसे गुगल करके।",
			explain: "यह वह उत्तर नहीं है जिसकी हम तलाश कर रहे हैं, लेकिन इससे आपको उसे खोजने में मदद मिलेगी।",
			correct: true
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/hi/chapter3/6.mdx" />