# Pendahuluan

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## Selamat datang di Kursus 🤗!

<Youtube id="00GKzGyWFEs" />

Pada kursus ini, anda akan belajar mengenai _natural language processing_ (pemrosesan bahasa natural) atau NLP menggunakan modul-modul dari ekosistem [Hugging Face](https://huggingface.co/) - [🤗 Transformers](https://github.com/huggingface/transformers), [🤗 Datasets](https://github.com/huggingface/datasets), [🤗 Tokenizers](https://github.com/huggingface/tokenizers), and [🤗 Accelerate](https://github.com/huggingface/accelerate) — as well as the [Hugging Face Hub](https://huggingface.co/models). Kursus ini 100% gratis tanpa iklan.


## Silabus

Silabus kursus ini adalah sebagai berikut:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- Bab 1-4 akan mencakup pengenalan konsep-konsep dasar modul 🤗 Transformers. Di akhir bab 4, anda akan tahu bagaimana menggunakan model-model _Transformer_ dari [Hugging Face Hub](https://huggingface.co/models), melakukan model _fine-tuning_ untuk dataset anda, dan membagikan model anda di Hugging Face Hub!
- Bab 5-8 akan mencakup dasar-dasar dari 🤗 Datasets dan 🤗 Tokenizers sebelum anda diperkenalkan ke kasus-kasus yang dapat ditangani dengan NLP. Diakhir kursus ini, anda akan mampu menangani dan menyelesaikan kasus-kasus NLP.
- Chapters 9 to 12 go beyond NLP, and explore how Transformer models can be used tackle tasks in speech processing and computer vision. Along the way, you'll learn how to build and share demos of your models, and optimize them for production environments. By the end of this part, you will be ready to apply 🤗 Transformers to (almost) any machine learning problem!
- Setelah NLP, di bab 9-12, anda akan mengeksplorasi bagaimana model-model Transformer dapat digunakan untuk menangani kasus-kasus lain seperti _speech processing_ (pemrosesan ucapan) dan _computer vision_ (penglihatan komputer). Selain itu, anda akan belajar cara membuat dan membagikan demo (prototype) dari model anda, serta cara mengoptimisasi model anda untuk _production environment_ (penerapan di kasus asli). Di akhir bab 12, anda akan siap mengimplementasikan 🤗 Transformers untuk (hampir) semua kasus _machine learning_ (pembelajaran mesin)!

Syarat mengikuti kursus:

* Requires a good knowledge of Python
* Pengetahuan mengenai Python
* Akan lebih baik jika sudah mengenal deep learning dengan mengambil kursus dari [fast.ai](https://www.fast.ai/) "[Practical Deep Learning for Coders](https://course.fast.ai/)" atau program-program yang dikembangkan oleh [DeepLearning.AI](https://www.deeplearning.ai/)
* Tidak perlu pengetahuan mengenai [PyTorch](https://pytorch.org/) atau [TensorFlow](https://www.tensorflow.org/). Tapi, akan lebih baik jika sudah terbiasa dengan salah satu framework tersebut.

Setelah menyelesaikan kursus ini, sangat direkomendasikan untuk mengikuti kursus dari DeepLearning.AI [Natural Language Processing Specialization](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh) yang akan mencakup model-model NLP klasik seperti naive Bayes dan LSTM. Pengetahuan tersebut akan sangat berharga bagi anda!

## Tentang penulis

**Abubakar Abid** adalah lulusan PhD dari Stanford dengan konsentrasi aplikasi pembelajaran mesin. Sembari menyelesaikan pendidikan PhD, beliau menciptakan [Gradio](https://github.com/gradio-app/gradio), sebuah modul _open-source_ Python yang sudah digunakan untuk membuat lebih dari 600.000 demo (prototype) model _machine learning_. Gradio telah diakusisi oleh Hugging Face, tempat dimana Abubakar bekerja sebagai _machine learning team lead_.

**Matthew Carrigan** bekerja sebagai _Machine Learning Engineer_ di Hugging Face. Beliau tinggal di Dublin, Irlandia, pernah bekerja sebagai _ML engineer_ di Parse.ly dan sebelumnya merupakan peneliti post-doctoral di Trinity College Dublin. Beliau tidak percaya kita akan mencapai Artificial general intelligence (AGI) dengan menambahkan skala dari arsitektur yang digunakan sekarang, namun memiliki optimisme mengenai imortalitas robot.

**Lysandre Debut** bekerja sebagai _Machine Learning Engineer_ di Hugging Face dan berfokus mengembangkan modul 🤗 Transformers sejak seumur jagung. Beliau mempunya mimpi untuk agar NLP dapat diakses oleh semua orang dengan mengembangkan alat-alat atau aplikasi-aplikasi sederhana menggunkan API.

**Sylvain Gugger** adalah _Research Engineer_ di Hugging Face dan merupakan salah satu _maintainer_ dari modul 🤗 Transformers. Beliau pernah bekerja sebagai _Research Scientist_ di fast.ai, dan bersama Jeremy Howard menulis _[Deep Learning for Coders with fastai and PyTorch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/)_. Fokus utama dari penelitian beliau adalah membuat _deep learning_ lebih mudah diakses dengan mendesain dan memperbaiki teknik-teknik untuk melatih model dengan sumber daya terbatas.

**Dawood Khan** bekerja sebagai _Machine Learning Engineer_ di Hugging Face. Beliau berasal dari NYC dan merupakan lulusan New York University jurusan _Computer Science_. Sempat bekerja sebagai iOS _Engineer_ untuk beberapa tahun, Dawood memutuskan untuk _resign_ dan mengembangkan Gradio bersama rekan-rekan co-foundernya. Seiring berjalannya waktu, Gradio diakusisi oleh Hugging Face.

**Merve Noyan** adalah advokat _developer_ di Hugging Face, beliau bertugas untuk mengembangkan konten beserta medianya untuk mendemokrasikan _machine learning_ untuk semua orang.

**Lucile Saulnier** adalah _machine learning engineer_ di Hugging Face, bertugas untuk mengembangkan dan mendukung penggunaan alat-alat _open source_. Beliau juga aktif dalam banyak riset mengenai _Natural Language Processing_ seperti _collaborative training_ dan BigScience.

**Lewis Tunstall**  merupakan _machine learning engineer_ di Hugging Face, bertugas untuk mengembangkan alat-alat _open source_ dan membuatnya dapat diakses oleh komunitas. Beliau juga merupakan salah satu penulis dari buku terbitan O’Reilly berjudul [Natural Language Processing with Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/).

**Leandro von Werra**  bekerja sebagai _machine learning engineer_ untuk tim _open-source_ di Hugging Face dan juga merupkan salah satu penulis buku [Natural Language Processing with Transformers](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/) yang diterbitkan oleh O'Reilly. Beliau memiliki memiliki pengalaman mengembangkan proyek-proyek NLP untuk kasus nyata pada berbagai macam _machine learning stack_ selama beberapa tahun.

Sudah siap untuk belajar? Di bab ini anda akan belajar mengenai:
* Penggunaan fungsi `pipeline()` untuk memecahkan masalah-masalah NLP seperti _text generation_ (pembuatan teks) dan klasifikasi.
* Arsitektur Transformer
* Bagaimana membedakan arsitektur encoder, decoder, dan encoder-decoder beserta kasus-kasus terkait.


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/id/chapter1/1.mdx" />