# イントロダクション

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

## 🤗 コースへようこそ!

<Youtube id="00GKzGyWFEs" />

このコースでは、[Hugging Face](https://huggingface.co/)のエコシステムを形成するライブラリである[🤗 Transformers](https://github.com/huggingface/transformers)、[🤗 Datasets](https://github.com/huggingface/datasets)、[🤗 Tokenizers](https://github.com/huggingface/tokenizers)、[🤗 Accelerate](https://github.com/huggingface/accelerate)、そして[Hugging Face Hub](https://huggingface.co/models)を使って自然言語処理（NLP）について学習することができます。このコースは、完全に無料で取り組むことができ、広告もありません。


## 何を学ぶことができるのか？

こちらがこのコースの概要になります:

<div class="flex justify-center">
<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary.svg" alt="Brief overview of the chapters of the course.">
<img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter1/summary-dark.svg" alt="Brief overview of the chapters of the course.">
</div>

- 第１章から第４章では、🤗 Transformersライブラリのメインコンセプトを紹介します。このパートを終える頃には、Transformerモデルがどのように機能するかを理解し、[Hugging Face Hub](https://huggingface.co/models)にあるモデルを利用し、データセットでfine-tuningを行い、その成果をHub上で共有する方法を身につけることができるでしょう！
- 第５章から第８章では、代表的なNLPタスクに取り掛かる前に、🤗 Datasetsと🤗 Tokenizersの基礎を学びます。このパートを終える頃には、大半のNLPの課題に自分で取り組むことができるようになります。
- 第９章から第１２章では、NLPの範囲にとどまらず、音声処理とコンピュータビジョンのタスクにTransformerモデルをどのように適用できるかを検討します。その過程で、モデルのデモを作成して共有することや本番環境用にモデルを最適化する方法を学ぶことができます。このパートを終える頃には、🤗 Transformersを（ほとんど）全ての機械学習の問題に適用する知識が身についていることでしょう！

このコースでは:

* Pythonの知識が必要です
* コースに取り組む前に、深層学習の入門コースである[fast.ai](https://www.fast.ai/)による [Practical Deep Learning for Coders](https://course.fast.ai/)や[DeepLearning.AI](https://www.deeplearning.ai/)が開発したプログラムなどを受講した方がよいでしょう
* [PyTorch](https://pytorch.org/)や[TensorFlow](https://www.tensorflow.org/)の事前知識は必須ではありませんが、どちらかに精通していると理解がより促進されるでしょう

このコースを修了した後は、DeepLearning.AIの[Natural Language Processing Specialization](https://www.coursera.org/specializations/natural-language-processing?utm_source=deeplearning-ai&utm_medium=institutions&utm_campaign=20211011-nlp-2-hugging_face-page-nlp-refresh)をご覧いただくことをお勧めします。ナイーブベイズやLSTMなどの従来のNLPモデルを幅広くカバーしており、これらも理解しておいて損はありませんよ！

## 私たちについて

筆者のプロフィール:

**Matthew Carrigan**はHugging Faceの機械学習エンジニアです。アイルランドのダブリンに住んでおり、以前はParse.lyで機械学習エンジニアとして、それ以前はトリニティ・カレッジ・ダブリンでポスドク研究員として働いていました。彼は、既存のアーキテクチャを拡張することでAGI（汎用人工知能）に到達できるとは思っていませんが、ロボットによる不死には大きな期待を寄せています。

**Lysandre Debut**はHugging Faceの機械学習エンジニアで、かなり初期の開発段階から🤗 Transformersライブラリに携わってきました。彼の目標は、非常にシンプルなAPIのツールを開発することによって、誰もがNLPにアクセスできるようにすることです。

**Sylvain Gugger**はHugging Faceのリサーチエンジニアで、🤗 Transformersライブラリのコアメンテナーの1人です。以前は、fast.aiのリサーチサイエンティストで、Jeremy Howard氏と[Deep Learning for Coders with fastai and PyTorch](https://learning.oreilly.com/library/view/deep-learning-for/9781492045519/)を共同執筆しています。限られたリソースでモデルを高速に学習させる技術を設計・改善することで、深層学習をより身近なものにすることに研究の焦点を置いています。

**Merve Noyan**はHugging Faceのデベロッパーアドボケイトであり、誰もが機械学習に取り組めるようなツールの開発とその周辺のコンテンツ作成に取り組んでいます。

**Lucile Saulnier**はHugging Faceの機械学習エンジニアで、オープンソースツールの開発および利用のサポートを行っています。また、共同でのモデルの学習やBigScienceなど、自然言語処理の分野で多くの研究プロジェクトに積極的に参加しています。

**Lewis Tunstall**はHugging Faceの機械学習エンジニアで、オープンソースツールの開発とより広いコミュニティで利用されるようにすることに注力しています。また、[オライリー出版のTransformersに関する本](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/)の著者の1人です。

**Leandro von Werra**はHugging Faceのオープンソースチームの機械学習エンジニアであり、[オライリー出版のTransformersに関する本](https://www.oreilly.com/library/view/natural-language-processing/9781098136789/)の著者の1人です。機械学習全般に関わり、NLPプロジェクトを実運用に移行する経験をこの業界で数年積んでいます。

準備はできていますか？この章では、以下のことを学びます:
* `pipeline()`機能を使ったテキスト生成や分類などNLPタスクの取り組み方
* Transformerのアーキテクチャについて
* エンコーダ、デコーダ、エンコーダ・デコーダのアーキテクチャとユースケースの見分け方

<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter1/1.mdx" />