# 学習済みモデルを共有する

{#if fw === 'pt'}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/ja/chapter4/section3_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/ja/chapter4/section3_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={4}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/ja/chapter4/section3_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/ja/chapter4/section3_tf.ipynb"},
]} />

{/if}

以下のステップでは、学習済みモデルを🤗ハブに共有する最も簡単な方法について見ていきます。ハブ上で直接モデルを共有し、更新できるツールやユーティリティが用意されていますので、以下、それを見ていきます。

<Youtube id="9yY3RB_GSPM"/>

たとえ非常に特殊なデータセットで学習させたとしても、モデルをコミュニティに共有することをお勧めします。他のユーザーの時間と計算資源を節約し、有用な学習済みモデルを提供することができるからです。代わりに、他の人の成果物の恩恵を受けることもできます！

新しいモデルリポジトリを作成するには、次の3つの方法があります：

- `push_to_hub` APIを使用する
- `huggingface_hub` Pythonライブラリを使用する
- ウェブインターフェイスを使用する

リポジトリを作成したら、git と git-lfs を使ってリポジトリにファイルをアップロードすることができます。以下のセクションでは、モデルリポジトリを作成し、ファイルをアップロードする方法を説明します。

## `push_to_hub` APIを使用する

{#if fw === 'pt'}

<Youtube id="Zh0FfmVrKX0"/>

{:else}

<Youtube id="pUh5cGmNV8Y"/>

{/if}

ハブにファイルをアップロードする最も簡単な方法は、`push_to_hub` API を使うことです。

先に進む前に、あなたが誰で、どのネームスペースに書き込み権限があるのかを通知するために、認証トークンを生成しましょう。`transformers`がインストールされている環境であることを確認してください（[セットアップ](/course/chapter0)を参照のこと）。ノートブックの場合は、以下の関数を使ってログインすることができます：

```python
from huggingface_hub import notebook_login

notebook_login()
```

ターミナル上では次の通りです:

```bash
huggingface-cli login
```

どちらの場合も、ユーザー名とパスワードの入力を求められますが、これはハブにログインするときに使用するものと同じです。まだハブのプロフィールをお持ちでない方は、[こちら](https://huggingface.co/join)から作成してください。

これで、認証トークンがキャッシュフォルダに保存されました。それでは、リポジトリを作成しましょう！

{#if fw === 'pt'}

`Trainer`API を使ってモデルを学習させたのであれば、 `TrainingArguments`において`push_to_hub=True`と設定することで、最も簡単にハブにアップロードすることができます：

```py
from transformers import TrainingArguments

training_args = TrainingArguments(
    "bert-finetuned-mrpc", save_strategy="epoch", push_to_hub=True
)
```

`trainer.train()`を実行すると、モデルを保存する度に（ここではエポック毎に）`Trainer`はモデルをレポジトリにアップロードします。このリポジトリは出力ディレクトリと同じ名前になりますが（この例では`bert-finetuned-mrpc`）、`hub_model_id = "a_different_name"`とすることで別の名前を指定することができます。

あなたが所属する組織にモデルをアップロードするには、`hub_model_id = "my_organization/my_repo_name"`とすればよいです。

学習が終了したら、最後に `trainer.push_to_hub()` を実行して、モデルの最終版をアップロードしてください。この際、使用したハイパーパラメータと評価結果など、全ての関連するメタデータを含むモデルカードが生成されます！以下に、モデルカードに含まれる内容の例を示します。

<div class="flex justify-center">
  <img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/model_card.png" alt="An example of an auto-generated model card." width="100%"/>
</div>

{:else}

モデルの学習にKerasを使用している場合、最も簡単にアップロードする方法は`PushToHubCallback`を`model.fit()`に渡すことです：

```py
from transformers import PushToHubCallback

callback = PushToHubCallback(
    "bert-finetuned-mrpc", save_strategy="epoch", tokenizer=tokenizer
)
```

そして、`model.fit()`の呼び出しに`callbacks=[callback]`を追加してください。モデルを保存する度に（ここではエポック毎に）コールバックはモデルをリポジトリにアップロードします。このリポジトリは出力ディレクトリと同じ名前になりますが（この例では`bert-finetuned-mrpc`）、`hub_model_id = "a_different_name"`とすることで別の名前を指定することができます。

あなたが所属する組織にモデルをアップロードするには、`hub_model_id = "my_organization/my_repo_name"`とすればよいです。

{/if}

より低いレベルでは、モデル、トークナイザー、および設定オブジェクトの `push_to_hub()` メソッドを通じて、モデルハブへのアクセスを直接行うことができます。このメソッドは、リポジトリの作成と、モデルやトークナイザーのリポジトリへのプッシュの両方を行います。後述するAPIとは異なり、手動で操作する必要はありません。

その仕組みを理解するために、まずモデルとトークナイザーを初期化してみましょう：

{#if fw === 'pt'}
```py
from transformers import AutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = AutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
```
{:else}
```py
from transformers import TFAutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = TFAutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
```
{/if}

これらを使って、トークナイザーにトークンを追加したり、モデルを学習させたり、微調整したりと、好きなことを自由に行うことができます。出来上がったモデル、重み、トークナイザーに満足したら、`model` オブジェクトから直接利用できる`push_to_hub()`メソッドを活用できます：

```py
model.push_to_hub("dummy-model")
```

これであなたのプロファイルに新しいリポジトリ `dummy-model` が作成され、モデルファイルがそこに格納されます。すべてのファイルがこのリポジトリで利用できるよう、トークナイザーにも同様に実行してください：

```py
tokenizer.push_to_hub("dummy-model")
```

組織に所属している場合、`organization`引数を指定することで当該組織のネームスペースにアップロードできます：

```py
tokenizer.push_to_hub("dummy-model", organization="huggingface")
```

特定のHugging Faceトークンを使うこともできます：

```py
tokenizer.push_to_hub("dummy-model", organization="huggingface", use_auth_token="<TOKEN>")
```

さあ、新しくアップロードしたモデルをモデルハブで見てみましょう：*https://huggingface.co/user-or-organization/dummy-model*.

"Files and versions"タブをクリックすると、これらのファイルが表示されるはずです：

{#if fw === 'pt'}
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/push_to_hub_dummy_model.png" alt="Dummy model containing both the tokenizer and model files." width="80%"/>
</div>
{:else}
<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/push_to_hub_dummy_model_tf.png" alt="Dummy model containing both the tokenizer and model files." width="80%"/>
</div>
{/if}

<Tip>

✏️ **やってみよう！** `bert-base-cased`チェックポイントに関連付けられたモデルとトークナイザーを、`push_to_hub()`メソッドを使って自分のネームスペースにあるリポジトリにアップロードします。レポジトリを削除する前に、レポジトリがあなたのページに正しく表示されることを確認してください。

</Tip>

これまで見てきたように、`push_to_hub()`メソッドはいくつかの引数をとるので、特定のリポジトリや組織のネームスペースにアップロードしたり、別のAPI トークンを使用したりすることが可能です。詳細については、[🤗 Transformers documentation](https://huggingface.co/transformers/model_sharing.html)で仕様を確認することをお勧めします。

この`push_to_hub()`メソッドは、ハギングフェイスハブに直接アクセスできる[`huggingface_hub`](https://github.com/huggingface/huggingface_hub) Pythonパッケージで実装されており、🤗 Transformersや、[`allenlp`](https://github.com/allenai/allennlp)といった、他の機械学習ライブラリに統合されています。この章では🤗 Transformersに焦点を当てますが、あなた自身のコードやライブラリに統合することは簡単です。

最後のセクションに移動して、新しく作成したリポジトリにファイルをアップロードする方法をご覧ください！

## `huggingface_hub` Pythonライブラリを使用する

`huggingface_hub` Pythonライブラリは、モデルとデータセットのハブのためのツールセットを提供するパッケージです。ハブ上のリポジトリに関する情報を取得し、それらを管理するような一般的なタスクのためのシンプルなメソッドとクラスを提供します。また、これらのリポジトリのコンテンツを管理し、あなたのプロジェクトやライブラリにハブを統合するために、gitの上で動作するシンプルなAPIを提供します。

`push_to_hub` API を使用する場合と同様に、APIトークンをキャッシュに保存しておく必要があります。これを行うには、前のセクションで説明したように、CLI から `login` コマンドを使用する必要があります (Google Colab で実行する場合は、これらのコマンドの前に `!` 文字を付加してください)：

```bash
huggingface-cli login
```

`huggingface_hub` パッケージには、便利なメソッドとクラスがいくつかあります。まず、リポジトリの作成と削除を管理するためのメソッドがいくつかあります：

```python no-format
from huggingface_hub import (
    # ユーザー管理
    login,
    logout,
    whoami,

    # レポジトリの作成と管理
    create_repo,
    delete_repo,
    update_repo_visibility,

    # そして、コンテンツに関する情報を取得／変更するためのいくつかのメソッド
    list_models,
    list_datasets,
    list_metrics,
    list_repo_files,
    upload_file,
    delete_file,
)
```


さらに、ローカルリポジトリを管理するための非常に強力な `Repository` クラスを提供しています。これらのメソッドやクラスをどのように活用するかについては、次のセクションで説明します。

`create_repo` メソッドを使用すると、ハブに新しいリポジトリを作成できます：

```py
from huggingface_hub import create_repo

create_repo("dummy-model")
```

これで、あなたのネームスペースに `dummy-model` というリポジトリが作成されます。もし必要なら、 `organization` 引数で所属する組織を指定することもできます：

```py
from huggingface_hub import create_repo

create_repo("dummy-model", organization="huggingface")
```

あなたがその組織に所属していると仮定して、これで`huggingface`ネームスペースに `dummy-model` リポジトリが作成されます。その他の便利な引数は以下の通りです。

- `private`：リポジトリを他から見えるようにするかどうかを指定します。
- `token`：キャッシュに保存されているトークンではない、別のトークンを指定します。
- `repo_type`：モデルではなく「データセット」や「スペース」のレポジトリを作成します。指定できる値は`"dataset"`と`"space"`です。

レポジトリが作成できたらファイルを追加してみましょう！次のセクションに移動して、3つの方法を見てみましょう。


## ウェブインターフェイスを使う

ウェブインタフェースでは、ハブのリポジトリを直接管理することができます。このインターフェイスを使って、リポジトリの作成、ファイル（大きなものも！）の追加、モデルの検索、差分の可視化など、さまざまなことが簡単にできます。

レポジトリを新しく作るには、[huggingface.co/new](https://huggingface.co/new)にアクセスして下さい：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/new_model.png" alt="Page showcasing the model used for the creation of a new model repository." width="80%"/>
</div>

まず、リポジトリの所有者を指定します。これはあなた自身か、あなたが所属する組織のいずれかになります。組織を選択した場合、モデルは組織のページで紹介され、組織の全メンバーがリポジトリに貢献することができるようになります。

次に、モデルの名前を入力します。これはリポジトリの名前にもなります。最後に、モデルをパブリックにするかプライベートにするかを指定します。プライベートモデルは、一般公開されないモデルです。

モデルリポジトリを作成すると、このようなページが表示されるはずです：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/empty_model.png" alt="An empty model page after creating a new repository." width="80%"/>
</div>

これは、あなたのモデルがホストされる場所です。ウェブインターフェースから直接、モデルにREADMEファイルを追加してみましょう。

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/dummy_model.png" alt="The README file showing the Markdown capabilities." width="80%"/>
</div>

READMEファイルはMarkdownで書かれています - どうぞ自由に使ってください。この章の第三部は、モデルカードの作成に専念します。モデルカードはそのモデルができることを他の人に伝える場所であり、あなたのモデルに価値を与えるために最も重要なものです。

"Files and versions"タブを見ると、まだ多くのファイルがないことがわかります。先ほど作成した *README.md* と、大きなファイルを追跡するための *.gitattributes* ファイルがあるだけです。

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/files.png" alt="The 'Files and versions' tab only shows the .gitattributes and README.md files." width="80%"/>
</div>

次は、新しいファイルを追加する方法について見てみましょう。

## モデルファイルのアップロード

ハギングフェイスハブでのファイル管理の仕組みは、通常のファイルはgit、大きなファイルはgit-lfs ([Git Large File Storage](https://git-lfs.github.com/)の略)をベースにしています。

次のセクションでは、ハブにファイルをアップロードする3つの方法について説明します: `huggingface_hub` と git コマンドです。

### `upload_file`を使ったアプローチ

`upload_file` を使用する場合、git や git-lfs がシステムにインストールされている必要はありません。HTTP POST リクエストを使用して、ファイルを直接 🤗 ハブにプッシュします。この方法の制限は、5GB を超えるサイズのファイルを扱えないことです。5GB を超えるファイルを扱う場合は、以下に説明する他の2つの方法に従ってください。

本APIは次のように使用することができます：

```py
from huggingface_hub import upload_file

upload_file(
    "<path_to_file>/config.json",
    path_in_repo="config.json",
    repo_id="<namespace>/dummy-model",
)
```

これは、リポジトリのルートである `<path_to_file>` にある `config.json` というファイルを `dummy-model` リポジトリにアップロードすることになります。
その他便利な引数は次の通りです：

- `token`、キャッシュに保存されているトークンではない、別のトークンを指定します。
- `repo_type`、モデルではなく「データセット」や「スペース」のレポジトリを作成します。指定できる値は`"dataset"`と`"space"`です。


### `Repository`クラス

`Repository` クラスは、gitに似た方法でローカルリポジトリを管理します。このクラスは、gitであれば苦労する点のほとんどを抽象化してくれます。

このクラスを使用するには、git と git-lfs がインストールされている必要があります。そのため、始める前に git-lfs をインストールし（インストール方法は[こちら](https://git-lfs.github.com/)を参照）、セットアップしておく必要があります。

作成したリポジトリでいろいろ試してみるために、リモートリポジトリをクローンしてローカルフォルダに初期化することから始めましょう：

```py
from huggingface_hub import Repository

repo = Repository("<path_to_dummy_folder>", clone_from="<namespace>/dummy-model")
```

作業ディレクトリに `<path_to_dummy_folder>` というフォルダが作成されます。このフォルダには `.gitattributes` というファイルだけが存在しているはずです。これは、`create_repo` でリポジトリを作成する際に作成される唯一のファイルだからです。

これ以降、従来のgitのメソッドのいくつかを使用することができます：

```py
repo.git_pull()
repo.git_add()
repo.git_commit()
repo.git_push()
repo.git_tag()
```

その他にも同様のメソッドがあります！利用可能なすべてのメソッドの概要については、[こちら](https://github.com/huggingface/huggingface_hub/tree/main/src/huggingface_hub#advanced-programmatic-repository-management)にある `Repository` のドキュメントをご覧になることをお勧めします。

現在、私たちはハブにプッシュしたいモデルとトークナイザーを持っていると仮定します。リポジトリのクローンには成功し、そのリポジトリ内にファイルを保存することができるはずです。

まず、ローカルのクローンから最新の変更を取り込み、最新の状態にします：

```py
repo.git_pull()
```

それが終わったら、モデルファイルとトークナイザーファイルを保存します：

```py
model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```

`<path_to_dummy_folder>` には、すべてのモデルファイルとトークナイザーファイルが格納されています。通常の git ワークフローに従って、ファイルをステージング・エリアに追加し、コミットしてハブにプッシュします。

```py
repo.git_add()
repo.git_commit("Add model and tokenizer files")
repo.git_push()
```

おめでとうございます！あなたは今、最初のファイルをハブにプッシュしました。

### gitベースのアプローチ

これは、ファイルをアップロードするための必要最小限なアプローチで、gitとgit-lfsを直接使います。これまでのアプローチでは困難なことのほとんどは抽象化されていますが、このアプローチにはいくつかの注意点があります。より複雑なユースケースで説明していきます。

このクラスを使用するには、git と git-lfs がインストールされている必要があります。そのため、始める前に[git-lfs](https://git-lfs.github.com/)をインストールし（インストール方法はこちらを参照）、セットアップしておいてください。

まず最初に git-lfs を初期化することから始めます：

```bash
git lfs install
```

```bash
Updated git hooks.
Git LFS initialized.
```

それが終わったら、まず最初にモデルリポジトリをクローンします：

```bash
git clone https://huggingface.co/<namespace>/<your-model-id>
```

私のユーザ名は `lysandre` で、モデル名は `dummy` としたので、私の場合、コマンドは以下のようになります：

```
git clone https://huggingface.co/lysandre/dummy
```

作業ディレクトリに*dummy*という名前のフォルダができました。このフォルダに `cd` して、中身を見ることができます：

```bash
cd dummy && ls
```

```bash
README.md
```

ハギングフェイスハブの `create_repo` メソッドを使ってリポジトリを作成したばかりの場合、このフォルダーには `.gitattributes` という隠しファイルだけが存在しているはずです。前のセクションの指示に従ってウェブインターフェースを使用してリポジトリを作成した場合、このフォルダーには、ここに示すように、`.gitattributes` ファイルと一緒に*README.md* ファイルだけが存在しているはずです。

設定ファイルや語彙ファイルなど、基本的に数メガバイト以下の通常サイズのファイルを追加することは、gitベースのシステムで行うのとまったく同じように行われます。しかし、より大きなファイルを *huggingface.co* にプッシュするには、git-lfs を通して登録する必要があります。

Pythonに少し戻って、ダミーリポジトリにコミットするモデルとトークナイザを生成してみましょう：

{#if fw === 'pt'}
```py
from transformers import AutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = AutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

# モデルを使って、トレーニングしたり、微調整したり...。

model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```
{:else}
```py
from transformers import TFAutoModelForMaskedLM, AutoTokenizer

checkpoint = "camembert-base"

model = TFAutoModelForMaskedLM.from_pretrained(checkpoint)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

# モデルを使って、トレーニングしたり、微調整したり...。

model.save_pretrained("<path_to_dummy_folder>")
tokenizer.save_pretrained("<path_to_dummy_folder>")
```
{/if}

さて、モデルとトークナイザーのアーティファクトをいくつか保存したので、*dummy* フォルダーをもう一度見てみましょう。

```bash
ls
```

{#if fw === 'pt'}
```bash
config.json  pytorch_model.bin  README.md  sentencepiece.bpe.model  special_tokens_map.json tokenizer_config.json  tokenizer.json
```

ファイルサイズを見ると（たとえば `ls -lh` で）、モデル状態のディクショナリファイル (*pytorch_model.bin*) が唯一、400 MB 以上あることがわかると思います。

{:else}
```bash
config.json  README.md  sentencepiece.bpe.model  special_tokens_map.json  tf_model.h5  tokenizer_config.json  tokenizer.json
```

ファイルサイズを見ると（たとえば `ls -lh` で）、モデル状態のディクショナリファイル (*t5_model.h5*) が唯一、400 MB 以上あることがわかると思います。

{/if}

<Tip>
✏️ ウェブインターフェースからリポジトリを作成する場合、*.gitattributes* ファイルは自動的に *.bin* や *.h5* などの特定の拡張子を持つファイルを大きなファイルとみなすように設定され、git-lfs がそれらを追跡するようになります。ユーザー側で別途設定を行う必要はありません。
</Tip> 

これで、従来の Git リポジトリと同じように作業を進められるようになりました。すべてのファイルを Git のステージング環境に追加するには、`git add` コマンドを使います：

```bash
git add .
```

そして、現在ステージングされているファイルを見ることができます：

```bash
git status
```

{#if fw === 'pt'}
```bash
On branch main
Your branch is up to date with 'origin/main'.

Changes to be committed:
  (use "git restore --staged <file>..." to unstage)
  modified:   .gitattributes
	new file:   config.json
	new file:   pytorch_model.bin
	new file:   sentencepiece.bpe.model
	new file:   special_tokens_map.json
	new file:   tokenizer.json
	new file:   tokenizer_config.json
```
{:else}
```bash
On branch main
Your branch is up to date with 'origin/main'.

Changes to be committed:
  (use "git restore --staged <file>..." to unstage)
  modified:   .gitattributes
  	new file:   config.json
	new file:   sentencepiece.bpe.model
	new file:   special_tokens_map.json
	new file:   tf_model.h5
	new file:   tokenizer.json
	new file:   tokenizer_config.json
```
{/if}

同様に、git-lfs が正しいファイルを追跡しているかどうかを `status` コマンドで確認することができます：

```bash
git lfs status
```

{#if fw === 'pt'}
```bash
On branch main
Objects to be pushed to origin/main:


Objects to be committed:

	config.json (Git: bc20ff2)
	pytorch_model.bin (LFS: 35686c2)
	sentencepiece.bpe.model (LFS: 988bc5a)
	special_tokens_map.json (Git: cb23931)
	tokenizer.json (Git: 851ff3e)
	tokenizer_config.json (Git: f0f7783)

Objects not staged for commit:


```

`LFS`で処理される*pytorch_model.bin* と *sentencepiece.bpe.model* を除き、すべてのファイルが `Git` で処理されることが分かります。素晴らしい！

{:else}
```bash
On branch main
Objects to be pushed to origin/main:


Objects to be committed:

	config.json (Git: bc20ff2)
	sentencepiece.bpe.model (LFS: 988bc5a)
	special_tokens_map.json (Git: cb23931)
	tf_model.h5 (LFS: 86fce29)
	tokenizer.json (Git: 851ff3e)
	tokenizer_config.json (Git: f0f7783)

Objects not staged for commit:


```

`LFS`で処理される*t5_model.h5*を除き、すべてのファイルが `Git` で処理されることが分かります。素晴らしい！

{/if}

最後のステップ、コミットと*huggingface.co*リモートリポジトリへのプッシュへと進みましょう：

```bash
git commit -m "First model version"
```

{#if fw === 'pt'}
```bash
[main b08aab1] First model version
 7 files changed, 29027 insertions(+)
  6 files changed, 36 insertions(+)
 create mode 100644 config.json
 create mode 100644 pytorch_model.bin
 create mode 100644 sentencepiece.bpe.model
 create mode 100644 special_tokens_map.json
 create mode 100644 tokenizer.json
 create mode 100644 tokenizer_config.json
```
{:else}
```bash
[main b08aab1] First model version
 6 files changed, 36 insertions(+)
 create mode 100644 config.json
 create mode 100644 sentencepiece.bpe.model
 create mode 100644 special_tokens_map.json
 create mode 100644 tf_model.h5
 create mode 100644 tokenizer.json
 create mode 100644 tokenizer_config.json
```
{/if}

プッシュは、インターネットの接続速度やファイルの大きさによって、少し時間がかかることがあります：

```bash
git push
```

```bash
Uploading LFS objects: 100% (1/1), 433 MB | 1.3 MB/s, done.
Enumerating objects: 11, done.
Counting objects: 100% (11/11), done.
Delta compression using up to 12 threads
Compressing objects: 100% (9/9), done.
Writing objects: 100% (9/9), 288.27 KiB | 6.27 MiB/s, done.
Total 9 (delta 1), reused 0 (delta 0), pack-reused 0
To https://huggingface.co/lysandre/dummy
   891b41d..b08aab1  main -> main
```

{#if fw === 'pt'}
これが終了した時点でモデルリポジトリを見てみると、最近追加されたすべてのファイルを見ることができます：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/full_model.png" alt="The 'Files and versions' tab now contains all the recently uploaded files." width="80%"/>
</div>

このUIでは、モデルファイルやコミットを探索したり、各コミットでの差分を確認することができます：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/diffs.gif" alt="The diff introduced by the recent commit." width="80%"/>
</div>
{:else}
これが終了した時点でモデルリポジトリを見てみると、最近追加されたすべてのファイルを見ることができます：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/full_model_tf.png" alt="The 'Files and versions' tab now contains all the recently uploaded files." width="80%"/>
</div>

このUIでは、モデルファイルやコミットを探索したり、各コミットでの差分を確認することができます：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter4/diffstf.gif" alt="The diff introduced by the recent commit." width="80%"/>
</div>
{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter4/3.mdx" />