# チャプター修了クイズ

<CourseFloatingBanner
    chapter={4}
    classNames="absolute z-10 right-0 top-0"
/>

この章で学んだことを確認してみましょう！
  
### 1. ハブにアップロードできるモデルには何か制限があるでしょうか？

<Question
	choices={[
		{
			text: "🤗 Transformersライブラリのモデルに制限される。",
			explain: "🤗 Transformersライブラリのモデルはハギングフェイスハブでサポートされていますが、それだけではありません！"
		},
		{
			text: "🤗 Transformersと似たインターフェイスを備えたモデルに制限される。",
			explain: "どんなインターフェイスのモデルでもハギングフェイスハブにアップロードすることができます。"
		},
		{
			text: "制限はありません。",
			explain: "正解です！どんなモデルでもハブにアップロードすることができます。",
            correct: true
		},
        {
			text: "NLPに関連したモデルに制限される。",
			explain: "どんな分野のモデルでも構いません！"
		}
	]}
/>

### 2. ハブではどうやってモデルを管理すればよいでしょうか？

<Question
	choices={[
		{
			text: "GCPアカウントを通じて",
			explain: "Incorrect!"
		},
		{
			text: "P2P配信を通じて",
			explain: "Incorrect!"
		},
		{
			text: "gitとgit-lfsを通じて",
			explain: "正解です！ハブ上のモデルは単にGitのレポジトリで、大きなファイルには<code>git-lfs</code>を活用しています。",
            correct: true
		}
	]}
/>

### 3. ハギングフェイスハブのウェブインターフェイスを使うと何ができるでしょうか？

<Question
	choices={[
		{
			text: "既存のレポジトリをフォークできる。",
			explain: "ハギングフェイスハブではレポジトリのフォークはできません。"
		},
		{
			text: "モデルレポジトリの新規作成ができる。",
			explain: "正解です！でもそれだけではありません。",
            correct: true
		},
		{
			text: "ファイルの管理と編集ができる。",
			explain: "正解です！でもそれだけではありません。",
            correct: true
		},
        {
			text: "ファイルのアップロードができる。",
			explain: "正解です！でもそれだけではありません。",
            correct: true
		},
        {
			text: "バージョン間の差異を確認できる。",
			explain: "正解です！でもそれだけではありません。",
            correct: true
		}
	]}
/>

### 4. モデルカードとは何でしょう？

<Question
	choices={[
		{
			text: "モデルの概要なので、モデルやトークナイザーのファイルよりは重要ではない。",
			explain: "確かにモデルの説明ですが、とても重要な情報です。もし不完全であったり、なかったりすると、モデルの有用性が激減してしまいます。"
		},
		{
			text: "再現性、再利用性、公平性を確保するための方法です。",
			explain: "正解です！モデルカードで正しい情報を共有することで、ユーザーはモデルを活用し、その限界と偏りを認識することができます。",
            correct: true
		},
		{
			text: "モデルの情報を取得するためのPythonファイルです。",
			explain: "モデルカードは単純なマークダウンファイルです。"
		}
	]}
/>

### 5. これらの🤗 Transformersライブラリのオブジェクトのうち、 `push_to_hub()` を使ってハブ上で直接共有できるものはどれでしょうか？

{#if fw === 'pt'}
<Question
	choices={[
		{
			text: "トークナイザー",
			explain: "正解です！全てのトークナイザーは<code>push_to_hub</code>メソッドを備えており、全てのトークナイザーファイル（ボキャブラリー、トークナイザーのアーキテクチャ、等々）をレポジトリにプッシュすることができます。でもこれだけが正解ではありません。",
            correct: true
		},
		{
			text: "モデルの設定",
			explain: "正解です！全てのモデル設定は<code>push_to_hub</code>メソッドを備えており、レポジトリにプッシュすることができます。その他に共有できるものは何でしょうか？",
            correct: true
		},
		{
			text: "モデル",
			explain: "正解です！全てのモデルは<code>push_to_hub</code>メソッドを備えており、モデルとその設定ファイルをレポジトリにプッシュすることができます。でも他にも共有できるものがあります。",
            correct: true
		},
        {
			text: "トレーナー",
			explain: "正解です！<code>Trainer</code>も<code>push_to_hub</code>メソッドを備えており、モデル、モデル設定、トークナイザー、モデルカードの下書きを、レポジトリにプッシュすることができます。その他の正解も当ててみましょう！",
            correct: true
		}
	]}
/>
{:else}
<Question
	choices={[
		{
			text: "トークナイザー",
			explain: "正解です！全てのトークナイザーは<code>push_to_hub</code>メソッドを備えており、全てのトークナイザーファイル（ボキャブラリー、トークナイザーのアーキテクチャ、等々）をレポジトリにプッシュすることができます。でもこれだけが正解ではありません。",
            correct: true
		},
		{
			text: "モデルの設定",
			explain: "正解です！全てのモデル設定は<code>push_to_hub</code>メソッドを備えており、レポジトリにプッシュすることができます。その他に共有できるものは何でしょうか？",
            correct: true
		},
		{
			text: "モデル",
			explain: "正解です！<code>Trainer</code>も<code>push_to_hub</code>メソッドを備えており、モデル、モデル設定、トークナイザー、モデルカードの下書きを、レポジトリにプッシュすることができます。その他の正解も当ててみましょう！",
            correct: true
		},
		{
			text: "専用のコールバックを備えた上記の全て",
			explain: "正解です！<code>PushToHubCallback</code>は学習中、定期的にこれらのオブジェクトをレポジトリに送信します。",
            correct: true
		}
	]}
/>
{/if}

### 6. `push_to_hub()`メソッドやCLIツールを使用する際の最初のステップは何でしょうか？

<Question
	choices={[
		{
			text: "ウェブサイトにログインする。",
			explain: "これはローカルマシンでは役に立ちません。"
		},
		{
			text: "ターミナル上で'huggingface-cli login'と実行する。",
			explain: "正解です。これでパーソナルトークンをダウンロードし、キャッシュします。",
            correct: true
		},
		{
			text: "ノートブック上で'notebook_login()'と実行する。",
			explain: "正解です。これで認証画面を表示します。",
            correct: true
		},
	]}
/>

### 7. モデルとトークナイザーはどうやってハブにアップロードすればよいですか？

<Question
	choices={[
		{
			text: "モデルとトークナイザーの`push_to_hub`メソッドを直接実行する。",
			explain: "正解です！",
            correct: true
		},
		{
			text: "Pythonランタイム上で、これらを<code>huggingface_hub</code>ユーティリティでラップする。",
			explain: "モデルとトークナイザーは既に<code>huggingface_hub</code>ユーティリティの恩恵を受けています。追加のラッピングは必要はありません。"
		},
		{
			text: "ディスクに保存して、<code>transformers-cli upload-model</code>を実行する。",
			explain: "<code>upload-model</code>というコマンドは存在しません。"
		}
	]}
/>

### 8. `Repository`クラスでできる git 操作はなんでしょう？

<Question
	choices={[
		{
			text: "コミット",
			explain: "正解です。<code>git_commit()</code>メソッドはそのためにあります。",
            correct: true
		},
		{
			text: "プル",
			explain: "それが<code>git_pull()</code>メソッドの目的です。",
            correct: true
		},
		{
			text: "プッシュ",
			explain: "これを行うのが<code>git_push()</code>メソッドです。",
            correct: true
		},
		{
			text: "マージ",
			explain: "このAPIを通してのマージは、未来永劫絶対にできません。"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter4/6.mdx" />