# 章末クイズ

<CourseFloatingBanner
    chapter={7}
    classNames="absolute z-10 right-0 top-0"
/>

この章で学んだことをテストしてみましょう！

### 1. 次のタスクのうち、トークン分類問題として組み立てられるものはどれでしょうか？

<Question
	choices={[
		{
			text: "文中の文法的な構成要素を見つける。",
			explain: "正解! あとは各単語に名詞、動詞などのラベルをつければいいです。",
			correct: true
		},
		{
			text: "文が文法的に正しいかどうかを調べる。",
			explain: "いいえ、それはシーケンス分類の問題です。"
		},
		{
			text: "文中で言及されている人物を見つける。",
			explain: "正解! 各単語に人物かそうでないかのラベルをつければよいです。",
            correct: true
		},
        {
			text: "質問の答えとなる単語の塊を文中から見つける。",
			explain: "いいえ、それは質問応答問題でしょう。"
		}
	]}
/>

### 2. トークン分類のための前処理は、他の前処理パイプラインとどの部分が違うのでしょうか？

<Question
	choices={[
		{
			text: "何もする必要はありません。テキストはすでにトークン化されています。",
			explain: "テキストは確かに別々の単語として与えられていますが、それでもサブワード型トークン化モデルを適用する必要があります。"
		},
		{
			text: "テキストは単語として与えられているので、サブワード トークン化を適用するだけです。",
			explain: "正解! これは、トークン化パイプラインをすべて適用する必要がある、通常の前処理とは異なります。他の違いも思いつきますか？",
			correct: true
		},
		{
			text: "特殊なトークンには <code>-100</code> を使ってラベル付けしています。",
			explain: "これはトークン分類に限ったことではありません。損失で無視したいトークンのラベルには、常に<code>-100</code>を使用します。"
		},
		{
			text: "単語を切り捨て/パディングを適用する際に、ラベルも入力と同じサイズに切り捨てるかパディングする必要があります。",
			explain: "確かに! しかし、それだけが違いではありません。",
			correct: true
		}
	]}
/>

### 3.トークン分類問題で単語をトークン化し、そのトークンにラベルを付けたい場合、どのような問題がありますか？

<Question
	choices={[
		{
			text: "トークナイザーは特別なトークンを追加しますが、それに対応するラベルがありません。",
			explain: "損失で無視されるように、これらに<code>-100</code>の特別なラベルを付ける事ができます。"
		},
		{
			text: "各単語は複数のトークンを生成できるため、ラベルの数よりも多くのトークンを持つことになります。",
			explain: "これが主な問題になります。元のラベルとトークンを揃える必要があります。",
			correct: true
		},
		{
			text: "追加されたトークンはラベルを持たないので、問題はありません。",
			explain: "それは正しくありません。トークンと同じ数のラベルが必要です。そうしないと、モデルがエラーになります。"
		}
	]}
/>

### 4. 「ドメイン適応」とはどういう意味ですか？

<Question
	choices={[
		{
			text: "あるデータセットに対してモデルを実行し、そのデータセット内の各サンプルに対する予測値を得ることです。",
			explain: "いいえ、これは推論タスクを実行しているだけです。"
		},
		{
			text: "あるデータセットでモデルを学習することです。",
			explain: "いいえ、これはモデルのトレーニングです。そこに適応がありません。"
		},
		{
			text: "事前に学習したモデルを新しいデータセットを微調整することで、そのデータセットに適応した予測をすることです。",
			explain: "正解! モデルは新しいデータセットに知識を適応させました。",
            correct: true
		},
        {
			text: "モデルをより堅牢にするために、誤分類されたサンプルをデータセットに追加することです。",
			explain: "確かに定期的にモデルを再トレーニングするのであれば行うべきことですが、それはドメイン適応ではありません。"
		}
	]}
/>

### 5. マスク言語モデリング問題におけるラベルとは何ですか？

<Question
	choices={[
		{
			text: "入力文の一部のトークンはランダムにマスクされます。ラベルは元の入力トークンです。",
			explain: "それです！",
            correct: true
		},
		{
			text: "入力文のいくつかのトークンはランダムにマスクされ、ラベルは元の入力トークンを左にシフトしたものです。",
			explain: "いいえ、ラベルを左にず>らすことは次の単語を予測することに相当し、これは因果言語モデリングです。"
		},
		{
			text: "入力文の一部のトークンをランダムにマスクし、その文が肯定的か否定的かをラベルとします。",
			explain: "これはデータ拡張を伴うシーケンス分類の問題で、マスク言語モデリングではありません。"
		},
        {
			text: "2つの入力文のトークンの一部がランダムにマスクされた後、ラベルとは2つの文が類似しているかどうかになります。",
			explain: "これはデータ拡張を伴うシーケンス分類の問題であり>、マスク言語モデリングではありません。"
		}
	]}
/>

### 6. 以下の作業のうち、シーケンス間問題と見なせるものはどれですか？

<Question
	choices={[
		{
			text: "長い文書の短いレビューを書く",
			explain: "はい、それは要約問題です。他の答えも探してみてください！",
            correct: true
		},
		{
			text: "文書に関する質問に答える",
			explain: "これはシーケンス間問題として組み立てられます。しかし、他にも正解はあります。",
            correct: true
		},
		{
			text: "中国語の文章を英語に翻訳する",
			explain: "これは間違いなくシーケンス間問題です。他の正解も見つけられますか？",
            correct: true
		},
        {
			text: "甥っ子/友人が送ってきたメッセージを正しい英語に直す",
			explain: "これは一種の翻訳問題なので、シーケンス間タスクに間違いありません。しかし、これだけが正解ではありません！",
			correct: true
		}
	]}
/>

### 7. シーケンス間問題におけるデータの前処理はどのように行うのが適切でしょうか？

<Question
	choices={[
		{
			text: "入力とターゲットは<code>inputs=...</code>と<code>targets=...</code>で一緒にトークナイザーに送らなければなりません。",
			explain: "これは将来的に>追加するAPIかもしれませんが、今はまだ不可能です。"
		},
		{
			text: "入力とターゲットの両方を前処理する必要があり、トークナイザーを2回別々に呼び出す必要があります。",
			explain: "その通りですが、不完全です。トークナイザーが両方を適切に処理できるようにするために必要なことがあります。"
		},
		{
			text: "いつも通り、入力をトークン化すればいいだけです。",
			explain: "シーケンス分類の問題ではありません。ターゲットも数値に変換する必要があるテキストです！"
		},
        {
			text: "入力はトークナイザーに送られなければなりません。ターゲットもですが、特別なコンテキストマネージャーの下で送らなければなりません。",
			explain: "その通りです。トークナイザは、そのコンテキストマネージャによってターゲットモードにする必要があります。",
			correct: true
		}
	]}
/>

{#if fw === 'pt'}

### 8. なぜシーケンス間問題には `Trainer` の特定のサブクラスが存在するのでしょうか？

<Question
	choices={[
		{
			text: "シーケンス間問題はカスタム損失を使い、<code>-100</code>に設定されたラベルを無視するためです。",
			explain: "それはカスタム損失固有の問題ではなく、損失が計算される際は常にそうなります。"
		},
		{
			text: "シーケンス間問題には特別な評価ループが必要だからです。",
			explain: "その通りです。シーケンス間モデルの予測は <code>generate()</code>メソッドで実行されることが多いです。",
			correct: true
		},
		{
			text: "シーケンス間問題ではターゲットがテキストになるためです。",
			explain: "事前に前処理されているので、<code>Trainer</code>はあまり気にしません。"
		},
        {
			text: "シーケンス間問題では2つのモデルを使用するためです。",
			explain: "ある意味2つのモデルを使用しています。エンコーダーとデコーダーですが、1つのモデルにまとめられています。"
		}
	]}
/>

{:else}

### 9. Transformerモデルで `compile()` を呼び出す際に、損失を指定する必要がないことが多いのはなぜですか？

<Question
	choices={[
		{
			text: "Transformerのモデルは教師なし学習でトレーニングされるからです。",
			explain: "そうではありません。教師なし学習でも損失関数が必要なのです！"
		},
		{
			text: "モデル内部の損失出力がデフォルトで使われるからです。",
			explain: "その通りです！",
			correct: true
		},
		{
			text: "代わりに学習後に指標を計算するからです。",
			explain: "よくやる事ですが、これでは学習時に最適化に使用する損失値をどこから得ているのか説明がつきません。"
		},
        {
			text: "損失は `model.fit()` で代わりに指定されているからです。",
			explain: "いいえ、損失関数は `model.compile()` を実行すると常に固定され、 `model.fit()` で変更することはできません。"
		}
	]}
/>

{/if}

### 10. 新しいモデルの事前学習はいつ行うべきですか？

<Question
	choices={[
		{
			text: "特定の言語で利用できる事前学習済みモデルがない場合",
			explain: "その通りです。",
			correct: true
		},
		{
			text: "たとえ事前学習済みモデルがあったとしても、利用可能なデータがたくさんある場合",
			explain: "この場合、膨大な計算コストを避けるために、事前学習済みのモデルを使用し>て、データ上で微調整を行うべきでしょう。"
		},
		{
			text: "使用している事前学習済みモデルのバイアスに懸念がある場合",
			explain: "その通りですが、学習に使用するデータが本当に良いものであることをよく確認する必要があります。",
			correct: true
		},
        {
			text: "利用できる事前学習済みモデルが十分に良い性能ではない場合",
			explain: "学習時にきちんとデバッグができていますか？"
		}
	]}
/>

### 11. なぜ、たくさんのテキストで言語モデルを事前学習する事は簡単なのですか？

<Question
	choices={[
		{
			text: "インターネット上にたくさんのテキストがあるからです。",
			explain: "確かにそうですが、それでは質問に答えているとは言えません。もう一度試してみてください。"
		},
		{
			text: "事前学習の目的では人間がデータにラベル付けする必要がないからです",
			explain: "その通りです。言語モデリングは自己教師あり問題です。",
			correct: true
		},
		{
			text: "🤗 Transformers は数行のコードで学習を開始することができるからです。",
			explain: "確かにそうですが、それでは質問されたことに答えられません。別の答えを試してみてください！"
		}
	]}
/>

### 12. 質問応答タスクのためにデータを前処理する際の主な課題は何ですか？

<Question
	choices={[
		{
			text: "入力をトークン化する必要があります。",
			explain: "その通りですが、本当に主な課題でしょうか？"
		},
		{
			text: "非常に長い文脈を扱う必要があり、その中には、答えに繋がるかどうかわからないいくつかの学習対象となる特徴があります。",
			explain: "これは間違いなく課題の1つです。",
			correct: true
		},
		{
			text: "入力だけでなく、質問に対する答えもトークン化する必要があります。",
			explain: "いいえ、質問回答の問題をシーケンス間タスクとして組み立てているのでなければ、そうではありません。"
		},
       {
			text: "テキスト内の回答の範囲から、トークン化された入力の開始と終了のトークンを見つけなければなりません。",
			explain: "それは難しい部分の1つです、はい！",
			correct: true
		}
	]}
/>

### 13. 質問応答では通常どのように後処理が行われますか？

<Question
	choices={[
		{
			text: "モデルが回答の開始と終了の位置を与えるので、対応するトークンの範囲をデコードするだけです。",
			explain: "それも一つの方法かもしれませんが、ちょっと単純すぎますね。"
		},
		{
			text: "モデルは、1つの例文から作成した各特徴の開始位置と終了位置を与えるので、最も良いスコアを持つものの中から対応するトークンの範囲を解読すればよいです。",
			explain: "私たちが勉強した後処理に近いですが、完全に正しいわけではありません。"
		},
		{
			text: "このモデルでは、1つの例文から作成した各特徴の答えの開始位置と終了位置を与えるので、ベストスコアを出した方のコンテキストの範囲に合わせればいいだけです。",
			explain: "簡単に言うとそれだけです！",
			correct: true
		},
        {
			text: "モデルが答えを生成するので、あなたはそれを解読すればいいだけです。",
			explain: "いいえ、質問応答問題をシーケンス間タスクとして組み立てているのでなければ、そうではありません。"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ja/chapter7/9.mdx" />