# 단원 마무리 퀴즈[[end-of-chapter-quiz]]

<CourseFloatingBanner
    chapter={2}
    classNames="absolute z-10 right-0 top-0"
/>

### 1. 언어 모델링 파이프라인은 어떤 순서로 진행될까요?

<Question
	choices={[
		{
			text: "먼저, 모델이 텍스트를 처리하고 원시 예측 결과를 출력합니다. 이어서 토크나이저가 이 예측 결과를 이해하고 텍스트로 변환합니다.",
			explain: "모델은 텍스트를 이해할 수 없습니다! 먼저 토크나이저가 텍스트를 토큰화하고 ID로 변환해야만 모델이 이해할 수 있습니다."
		},
		{
			text: "먼저, 토크나이저가 텍스트를 처리하고 ID를 반환합니다. 모델은 ID를 이용해 텍스트로 된 예측 결과를 출력합니다.",
			explain: "모델의 예측 결과가 텍스트 형태로 바로 나올 수는 없습니다. 예측을 텍스트로 변환하기 위해 토크나이저를 사용해야 합니다!"
		},
		{
			text: "토크나이저가 텍스트를 처리하고 ID를 반환합니다. 모델은 ID를 이용해 예측 결과를 출력합니다. 그리고 토크나이저를 다시 사용해 예측 결과를 일부 텍스트로 변환할 수 있습니다.",
			explain: "정답! 토크나이저는 토큰화와 역토큰화에 사용될 수 있습니다.",
            correct: true
		}
	]}
/>

### 2. 기본 Transformer 모델에 의해 만들어지는 텐서의 출력은 몇 차원이며, 각 텐서가 무엇을 의미하나요?

<Question
	choices={[
		{
			text: "2: 문장 길이, 배치 크기",
			explain: "틀렸습니다! 모델에 의한 텐서 출력은 은닉 크기를 포함한 3차원입니다."
		},
		{
			text: "2: 문장 길이, 은닉 크기",
			explain: "틀렸습니다! 모든 Transformer 모델은 단일 시퀀스에서도 크기 1로 배치를 처리합니다!"
		},
		{
			text: "3: 문장 길이, 배치 크기, 은닉 크기",
			explain: "정답!",
            correct: true
		}
	]}
/>

### 3. 서브워드 토큰화 예시에 해당하는 것은 무엇인가요?

<Question
	choices={[
		{
			text: "WordPiece",
			explain: "정답입니다. 서브워드 토큰화 예시 중 하나에 해당합니다!",
            correct: true
		},
		{
			text: "문자 기반 토큰화",
			explain: "문자 기반 토큰화는 서브워드 토큰화 방법이 아닙니다."
		},
		{
			text: "공백과 구두점을 기준으로 나누기",
			explain: "단어 기반 토큰화 방법입니다!"
		},
		{
			text: "BPE",
			explain: "정답입니다. 서브워드 토큰화 예시 중 하나에 해당합니다!",
            correct: true
        },
		{
			text: "Unigram",
			explain: "정답입니다. 서브워드 토큰화 예시 중 하나에 해당합니다!",
            correct: true
        },
		{
			text: "해당하는 것이 없습니다.",
			explain: "오답!"
        }
	]}
/>

### 4. 모델 헤드가 무엇인가요?

<Question
	choices={[
		{
			text: "기본 Transformer 네트워크의 요소로, 텐서를 적합한 레이어로 리디렉션합니다.",
			explain: "오답입니다! 그런 요소는 없습니다."
		},
		{
			text: "셀프 어텐션 메커니즘이라고도 부르며, 시퀀스 내 다른 토큰에 따라 토큰의 표현을 조정합니다.",
			explain: "오답입니다! 셀프 어텐션 레이어는 어텐션 \"헤드,\"를 포함하고 있지만 어텐션 헤드가 적응 헤드는 아닙니다."
		},
		{
			text: "하나 또는 여러 개의 레이어로 이루어진 추가적인 요소로 트랜스포머의 예측 결과를 task-specific한 출력으로 변환합니다.",
			explain: "정답입니다. 헤드라고 알려진 적응 헤드는 언어 모델링 헤드, 질의 응답 헤드, 순차 분류 헤드 등과 같이 다양한 형태로 나타납니다.",
			correct: true
		} 
	]}
/>

{#if fw === 'pt'}
### 5. AutoModel이 무엇인가요?

<Question
	choices={[
		{
			text: "데이터를 자동으로 학습하는 모델입니다.",
			explain: "오답입니다. <a href='https://huggingface.co/autotrain'>AutoTrain</a>과 헷갈린 게 아닐까요?"
		},
		{
			text: "체크포인트에 기반하여 적합한 구조를 반환하는 객체입니다.",
			explain: "정확합니다. <code>AutoModel</code>은 적절한 모델 구조를 초기화할 때 필요한 체크포인트만을 필요로 합니다.",
			correct: true
		},
		{
			text: "적합한 가중치를 불러오기 위해 입력에 사용된 언어를 자동으로 감지하는 모델입니다.",
			explain: "오답입니다. 몇몇 체크포인트와 모델은 다양한 언어를 처리할 수 있지만, 언어에 따라 체크포인트를 자동으로 선택할 수 있도록 내장된 도구는 없습니다. 태스크에 가장 적합한 체크포인트를 찾으려면 <a href='https://huggingface.co/models'>모델 허브</a>에 가보세요!"
		} 
	]}
/>

{:else}
### 5. TFAutoModel이 무엇인가요?

<Question
	choices={[
		{
			text: "데이터를 자동으로 학습하는 모델입니다.",
			explain: "오답입니다. <a href='https://huggingface.co/autotrain'>AutoTrain</a>과 헷갈린 게 아닐까요?"
		},
		{
			text: "체크포인트에 기반하여 적합한 구조를 반환하는 객체입니다.",
			explain: "정확합니다. <code>AutoModel</code>은 적절한 모델 구조를 초기화할 때 필요한 체크포인트만을 필요로 합니다.",
			correct: true
		},
		{
			text: "적합한 가중치를 불러오기 위해 입력에 사용된 언어를 자동으로 감지하는 모델입니다.",
			explain: "오답입니다. 몇몇 체크포인트와 모델은 다양한 언어를 처리할 수 있지만, 언어에 따라 체크포인트를 자동으로 선택할 수 있도록 내장된 도구는 없습니다. 태스크에 가장 적합한 체크포인트를 찾으려면 <a href='https://huggingface.co/models'>모델 허브</a>에 가보세요!"
		} 
	]}
/>

{/if}

### 6. 길이가 다른 시퀀스를 하나의 배치로 만들 때 신경써야 할 부분은 무엇일까요?

<Question
	choices={[
		{
			text: "잘라내기",
			explain: "정답입니다, 잘라내기는 시퀀스 길이를 동일하게 만들어서 텐서가 직사각형 형태를 가질 수 있게 하는 확실한 방법입니다. 하지만 이 방법 밖에 없을까요?",
			correct: true
		},
		{
			text: "텐서 반환하기",
			explain: "직사각형 텐서를 만들 수 있는 방법은 여러가지가 있겠지만, 텐서를 반환하는 것은 시퀀스를 하나의 배치로 만들 때 유용한 방법이 아닙니다."
		},
		{
			text: "패딩 추가하기",
			explain: "정답입니다, 패딩은 시퀀스 길이를 동일하게 만들어서 텐서가 직사각형 형태를 가질 수 있게 하는 확실한 방법입니다. 하지만 이 방법 밖에 없을까요?",
			correct: true
		}, 
		{
			text: "어텐션 마스킹",
			explain: "정확합니다! 어텐션 마스크는 다른 길이의 시퀀스를 처리할 때 매우 중요합니다. 하지만 어텐션 마스킹이 신경써야 하는 유일한 부분은 아닙니다.",
			correct: true
		} 
	]}
/>

### 7. 시퀀스 분류 모델의 로짓 출력 결과에 소프트맥스 함수를 적용하는 핵심적인 이유는 무엇일까요?

<Question
	choices={[
		{
			text: "소프트맥스 함수는 더 신뢰성 있는 로짓 결과를 만들기 위해 정규화를 수행합니다.",
			explain: "오답입니다, 소프트맥스 함수는 결과의 신뢰도에 영향을 주지 않습니다."
		},
		{
			text: "소프트맥스 함수는 상한과 하한을 적용해서 로짓 결과를 이해하기 쉽게 만듭니다.",
			explain: "정답입니다! 소프트맥스 함수를 거친 로짓 값은 0과 1 사이 값으로 바뀌게 됩니다. 하지만 이 이유가 소프트맥스 함수를 사용하는 유일한 이유는 아닙니다.",
            correct: true
		},
		{
			text: "출력 결과의 총 합이 1이므로 확률적으로 해석이 가능합니다.",
			explain: "정답입니다! 하지만 이 이유가 소프트맥스 함수를 사용하는 유일한 이유는 아닙니다.",
            correct: true
		}
	]}
/>

### 8. 토크나이저 API의 가장 핵심적인 메서드는 무엇일까요?

<Question
	choices={[
		{
			text: "텍스트를 ID로 인코딩하고 ID를 예측 결과로 인코딩하는 <code>encode</code>입니다.",
			explain: "틀렸습니다! <code>encode</code> 메서드가 토크나이저에는 있지만, 모델에는 없습니다."
		},
		{
			text: "토크나이저 객체를 바로 호출하는 메서드입니다.",
			explain: "정확합니다! 토크나이저의 <code>__call__</code> 메서드는 거의 모든 것을 처리할 수 있는 강력한 메서드입니다. 이 메서드는 또한 모델로부터 예측 결과를 탐색하는 데에 사용되기도 합니다.",
			correct: true
		},
		{
			text: "<code>pad</code> 메서드입니다.",
			explain: "틀렸습니다! 패딩은 매우 유용한 방법이지만, 토크나이저 API가 제공하는 기능 중 하나일 뿐입니다."
		},
		{
			text: "<code>tokenize</code> 메서드입니다.",
			explain: "<code>tokenize</code> 메서드가 유용한 것은 틀림없지만, 토크나이저 API의 핵심은 아닙니다."
		}
	]}
/>

### 9. 아래 코드 예시에서 `result` 변수가 포함하고 있는 것은 무엇일까요?

```py
from transformers import AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
result = tokenizer.tokenize("Hello!")
```

<Question
	choices={[
		{
			text: "문자열 리스트로, 각 문자열은 토큰입니다.",
			explain: "아주 정확합니다! 토큰을 ID로 변환하고 모델로 넘겨 보세요!",
            correct: true
		},
		{
			text: "ID 리스트입니다.",
			explain: "오답입니다. ID 리스트를 만드는 메서드는 <code>__call__</code> 또는 <code>convert_tokens_to_ids</code> 입니다!"
		},
		{
			text: "모든 토큰을 포함하고 있는 문자열입니다.",
			explain: "문자열을 각각의 토큰으로 나누는 것이 목표기 때문에 정확한 정답은 아닙니다."
		}
	]}
/>

{#if fw === 'pt'}
### 10. 아래 코드에서 잘못된 부분이 있을까요?

```py
from transformers import AutoTokenizer, AutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = AutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "아니요, 모두 제대로 되어 있습니다.",
			explain: "안타깝게도, 서로 다른 체크포인트로 학습된 토크나이저와 모델을 함께 사용하는 것은 좋은 방법이 아닙니다. 모델은 토크나이저의 출력 결과를 이해할 수 있도록 학습되지 않았기 때문에 모델이 동작하더라도 모델의 출력을 이해할 수 없을 것입니다."
		},
		{
			text: "토크나이저와 모델은 같은 체크포인트를 사용해야 합니다.",
			explain: "정답입니다!",
            correct: true
		},
		{
			text: "토크나이저를 이용해 패딩을 추가하거나 시퀀스 길이를 잘라내는 것은 모든 입력이 배치로 처리될 때 좋은 방법입니다.",
			explain: "모든 모델의 입력이 배치로 들어가야 하는 것은 맞습니다. 하지만 주어진 시퀀스가 하나뿐이기 때문에 이 예시에서 필수적인 부분은 아닙니다. 시퀀스를 잘라내거나 시퀀스에 패딩을 추가하는 것은 여러 개의 문장으로 배치를 만들 때 필요한 기술입니다."
		}
	]}
/>

{:else}
### 10. 아래 코드에서 잘못된 부분이 있을까요?

```py
from transformers import AutoTokenizer, TFAutoModel

tokenizer = AutoTokenizer.from_pretrained("bert-base-cased")
model = TFAutoModel.from_pretrained("gpt2")

encoded = tokenizer("Hey!", return_tensors="pt")
result = model(**encoded)
```

<Question
	choices={[
		{
			text: "아니요, 모두 제대로 되어 있습니다.",
			explain: "안타깝게도, 서로 다른 체크포인트로 학습된 토크나이저와 모델을 함께 사용하는 것은 좋은 방법이 아닙니다. 모델은 토크나이저의 출력 결과를 이해할 수 있도록 학습되지 않았기 때문에 모델이 동작하더라도 모델의 출력을 이해할 수 없을 것입니다."
		},
		{
			text: "토크나이저와 모델은 같은 체크포인트를 사용해야 합니다.",
			explain: "정답입니다!",
            correct: true
		},
		{
			text: "토크나이저를 이용해 패딩을 추가하거나 시퀀스 길이를 잘라내는 것은 모든 입력이 배치로 처리될 때 좋은 방법입니다.",
			explain: "모든 모델의 입력이 배치로 들어가야 하는 것은 맞습니다. 하지만 주어진 시퀀스가 하나뿐이기 때문에 이 예시에서 필수적인 부분은 아닙니다. 시퀀스를 잘라내거나 시퀀스에 패딩을 추가하는 것은 여러 개의 문장으로 배치를 만들 때 필요한 기술입니다."
		}
	]}
/>

{/if}


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/ko/chapter2/8.mdx" />